<?php

class Ezfc_Form {
	public $id;

	public function __construct($id = 0, $name = "") {
		$this->frontend = Ezfc_frontend::instance();
		$this->form     = $this->frontend->form_get($id, $name);
		$this->id       = $id;
	}

	public function get_elements($index = false, $key = "id", $merge = true) {
		$res = $this->frontend->wpdb->get_results($this->frontend->wpdb->prepare(
			"SELECT * FROM {$this->frontend->tables["forms_elements"]} WHERE f_id=%d ORDER BY position DESC",
			$id
		));

		if ($merge) {
			foreach ($res as &$element) {
				// extension elements (todo)
				if (!isset($this->frontend->elements[$element->e_id])) {
					$extension_data = json_decode($element->data);
					if (property_exists($extension_data, "extension")) {
						$element->type = $extension_data->extension;
					}
					
					continue;
				}

				$tmp_element = (array) $this->frontend->elements[$element->e_id]->data;
				$tmp_array = (array) json_decode($element->data);

				$element_type = $this->frontend->get_element_type($element);

				// do not add default element options for payment element
				if ($element_type == "payment") {
					$data = json_encode(Ezfc_Functions::array_merge_recursive_ignore_options($tmp_element, $tmp_array));
				}
				// add default element options
				else {
					$data = json_encode(Ezfc_Functions::array_merge_recursive_distinct($tmp_element, $tmp_array));
				}

				$element->data = $data;
				$element->data_array = $tmp_array;
				$element->type = $element_type; // needed?
			}
		}

		if ($index) $res = Ezfc_Functions::array_index_key($res, $key);

		return $res;
	}

	public function get_output($id=null, $name=null, $product_id=null, $theme=null, $preview=null, $counter = 0) {
		global $form;
		global $options;
		global $post;
		global $product;

		if (!$id && !$name && $preview === null) {
			echo __("No id or name found. Correct syntax: [ezfc id='1' /] or [ezfc name='form-name' /].", "ezfc");
			return;
		}

		// get form by id
		if ($id) {
			$form = $this->form_get($id);

			if (!$form) {
				echo __("No form found (ID: {$id}).", "ezfc");
				return;
			}
		}
		// get form by name
		else if ($name) {
			$form = $this->form_get(null, $name);

			if (!$form) {
				echo __("No form found (Name: {$name}).", "ezfc");
				return;
			}
		}
		// get preview form data
		else if ($preview !== null) {
			$preview_form = $this->form_get_preview($preview);
			$form = $preview_form->form;
		}

		// frontend output
		if ($preview !== null) {
			$form_elements = $preview_form->elements;
			$options       = $this->form_get_option_values(null, $preview_form->options);
		}
		else {
			$form_elements = $this->form_elements_get($form->id);
			$options       = $this->form_get_option_values($form->id);
		}

		$this->element_js_vars[$form->id] = array();
		$this->form = $this->form_get($form->id);
		$this->form_data = $this->form_get_data();
		$this->options = apply_filters("ezfc_output_form_options", $options, $form->id);
		$form_elements = apply_filters("ezfc_output_form_elements", $form_elements, $form->id, $this->options);
		$this->form_elements = Ezfc_Functions::array_index_key($form_elements, "id");
		$this->form_element_object_classes = array();
		// order of form elements
		$form_elements_order = array();

		if ($counter > 0) {
			$form->id = $form->id . "_" . $counter;
			$options["submission_enabled"] = 0;
			$this->options["submission_enabled"] = 0;
		}

		// reference id for file uploads
		$ref_id = uniqid();

		// open in popup
		if (Ezfc_Functions::get_array_value($this->options, "popup_enabled", 0) == 1) {
			require_once(EZFC_PATH . "inc/php/form/popup.php");
			new Ezfc_Form_Popup($form->id);
		}

		// begin output
		$html  = "";
		// output begin filter
		$html .= apply_filters("ezfc_form_output_start", "", $form->id);

		// count all elements beforehand
		$elements_count = count($form_elements);
		// element object classes
		// step counter
		$this->current_step = 0;
		// get amount of steps
		$this->step_count = 0;
		$step_titles = array();
		// trigger ID array
		$trigger_ids = array();
		// html element output array
		$html_array = array();

		foreach ($form_elements as $i => $element) {
			$element->__counter = $counter;

			$this->element_js_vars[$form->id][$element->id] = array();
			// element data
			$data = json_decode($element->data);
			// element type
			$element_type = $this->get_element_type($element);

			// get element class
			$element_class = $this->get_element_class($element);
			$element_class->set_counter($counter);
			$element_class->set_element_data($data);
			$element_class->set_form($form);
			$element_class->set_form_options($this->options);
			$element_class->enqueue_scripts();
			$element_class->init();
			$this->form_element_object_classes[$element_class->get_id()] = $element_class;

			// add to order
			$form_elements_order[] = $element->id;
			// trigger ids
			$trigger_ids[$element->id] = array();
			// html element output
			$html_array[$element->id] = array();

			// skip if extension element
			if (!empty($data->extension) || !isset($this->elements[$element->e_id])) continue;
			// step counter
			if ($element_type == "stepstart") {
				$step_titles[] = $data->title;
				$this->step_count++;
			}
		}
		
		// additional styles
		$css_label_width = get_option("ezfc_css_form_label_width");
		$css_label_width = empty($css_label_width) ? "" : "style='width: {$css_label_width}'";
		$form_class      = isset($options["form_class"]) ? $options["form_class"] : "";
		$wrapper_class   = "";

		// override theme by shortcode
		if (empty($theme)) {
			$theme = isset($options["theme"]) ? $options["theme"] : "default";
		}

		// theme css
		$theme_file = EZFC_PATH . "themes/{$theme}.css";
		$theme_def  = EZFC_PATH . "themes/slick.css";
		if (file_exists($theme_file)) {
			wp_enqueue_style("ezfc-theme-style-{$theme}", plugins_url("themes/{$theme}.css", __FILE__), array(), EZFC_VERSION);
		}
		else if (file_exists($theme_def)) {
			wp_enqueue_style("ezfc-theme-slick", plugins_url("themes/slick.css", __FILE__), array(), EZFC_VERSION);	
		}

		// global custom styling will be added from shortcode
		// form custom styling
		if ($options["load_custom_styling"] == 1) {
			$form_custom_styling  = $options["css_custom_styling"];
			$form_custom_styling .= $options["css_custom_styling_user"];

			wp_add_inline_style("ezfc-css-frontend", $form_custom_styling);

			// font
			if (!empty($options["css_font"])) {
				$font_name = $options["css_font"];
				wp_register_style("ezfc-font-{$font_name}", "//fonts.googleapis.com/css?family={$font_name}");
				wp_enqueue_style("ezfc-font-{$font_name}");
			}
		}

		// center form
		if ($options["form_center"] == 1) $form_class .= " ezfc-form-center";
		// show loading text
		$form_show_loading = get_option("ezfc_form_show_loading", 1);
		if ($form_show_loading) $wrapper_class .= " ezfc-form-loading";
		// image selection style
		$image_selection_style = empty($options["image_selection_style"]) ? "default" : $options["image_selection_style"];
		$form_class .= " ezfc-image-selection-style-{$image_selection_style}";

		// check if woocommerce is used
		$cart_item = null;
		$cart_key  = null;
		$use_woocommerce = 0;
		if ($options["submission_enabled"] == 1) {
			// submission / woocommerce
			if (get_option("ezfc_woocommerce", 0) == 1 && $options["woo_disable_form"] == 0) {
				$use_woocommerce = 1;

				// edit previously added product
				if (!empty($_GET["ezfc_cart_product_key"])) {
					$cart_items = WC()->instance()->cart->get_cart();

					foreach ($cart_items as $cart_item_key => $cart_item_tmp) {
						if (!empty($cart_item_tmp["ezfc_cart_product_key"]) && $cart_item_tmp["ezfc_cart_product_key"] == $_GET["ezfc_cart_product_key"]) {
							$cart_item = $cart_item_tmp;
							$cart_key  = $cart_item_key;
						}
					}
				}
			}
		}

		// check for payment methods
		$stripe_enabled    = get_option("ezfc_stripe_enabled", 0) && $options["stripe_enabled"];
		$stripe_enabled    = apply_filters("ezfc_stripe_check", $stripe_enabled, $id);
		//$authorize_enabled = get_option("ezfc_authorize_enabled", 0) && $options["authorize_enabled"];
		$authorize_enabled = false;

		// global conditions
		$global_conditions = Ezfc_Functions::get_object_value($this->form_data, "global_conditions", null);
		// prepare output
		if ($global_conditions) {
			$global_conditions = Ezfc_conditional::prepare_conditional_js($global_conditions);
		}

		// js output - form_vars
		$form_options_js = json_encode(array(
			"clear_selected_values_hidden"  => !empty($options["clear_selected_values_hidden"]) ? $options["clear_selected_values_hidden"] : 0,
			"counter_duration"              => isset($options["counter_duration"]) ? $options["counter_duration"] : 1000,
			"counter_interval"              => isset($options["counter_interval"]) ? $options["counter_interval"] : 30,
			"currency"                      => $options["currency"],
			"currency_position"             => $options["currency_position"],
			"datepicker_format"             => $options["datepicker_format"],
			"disable_error_scroll"          => !empty($options["disable_error_scroll"]) ? $options["disable_error_scroll"] : 0,
			"form_elements_order"           => $form_elements_order,
			"format_currency_numbers_elements" => $options["format_currency_numbers_elements"],
			"format_number_show_zero"       => $options["format_number_show_zero"],
			"global_conditions"             => $global_conditions,
			"hard_submit"                   => isset($options["hard_submit"]) ? $options["hard_submit"] : 0,
			"has_steps"                     => $this->step_count > 0,
			"hide_all_forms"                => !empty($options["hide_all_forms"]) ? $options["hide_all_forms"] : 0,
			"live_summary_enabled"          => Ezfc_Functions::get_array_value($options, "live_summary_enabled", 0),
			//"payment_force_authorize"       => $options["payment_force_authorize"],
			"payment_force_stripe"          => $options["payment_force_stripe"],
			"payment_info_shown"            => array(
				"authorize" => 0,
				"stripe"    => 0
			),
			"popup_open_auto"               => Ezfc_Functions::get_array_value($options, "popup_open_auto", 0),
			"preview_form"                  => $preview,
			"price_format"                  => !empty($options["price_format"]) ? $options["price_format"] : get_option("ezfc_price_format"),
			"price_position_scroll_top"     => !empty($options["price_position_scroll_top"]) ? $options["price_position_scroll_top"] : 0,
			"price_requested"               => 0,
			"price_show_request_before"     => !empty($options["price_show_request_before"]) ? $options["price_show_request_before"] : 0,
			"price_show_request"            => !empty($options["price_show_request"]) ? $options["price_show_request"] : 0,
			"redirect_forward_values"       => !empty($options["redirect_forward_values"]) ? $options["redirect_forward_values"] : 0,
			"redirect_text"                 => sprintf($options["redirect_text"], $options["redirect_timer"]),
			"redirect_timer"                => $options["redirect_timer"],
			"redirect_url"                  => trim($options["redirect_url"]),
			"refresh_page_after_submission" => $options["refresh_page_after_submission"],
			"reset_after_submission"        => $options["reset_after_submission"],
			"scroll_to_success_message"     => $options["scroll_to_success_message"],
			"selectable_max_error"          => get_option("ezfc_text_error_max_selectable", __("Please select at most %s options.", "ezfc")),
			"selectable_min_error"          => get_option("ezfc_text_error_min_selectable", __("Please select at least %s options.", "ezfc")),
			"show_success_text"             => $options["show_success_text"],
			"show_success_text_duration"    => Ezfc_Functions::get_array_value($options, "show_success_text_duration", 10),
			"step_auto_progress"            => $options["step_auto_progress"],
			"step_count"                    => $this->step_count,
			"step_indicator_start"          => $options["step_indicator_start"],
			"step_reset_succeeding"         => Ezfc_Functions::get_array_value($options, "step_reset_succeeding", 0),
			"step_speed"                    => $options["step_speed"],
			"submission_js_func"            => !empty($options["submission_js_func"]) ? $options["submission_js_func"] : "",
			"submit_text"                   => array(
				//"authorize"   => $options["submit_text_authorize"],
				"default"     => $options["submit_text"],
				"paypal"      => $options["pp_submittext"],
				"request"     => !empty($options["price_show_request_text"]) ? $options["price_show_request_text"] : __("Request price", "ezfc"),
				"stripe"      => $options["submit_text_stripe"],
				"summary"     => $options["summary_button_text"],
				"woocommerce" => $options["submit_text_woo"]
			),
			"summary_enabled"   => $options["summary_enabled"],
			"summary_shown"     => 0,
			"timepicker_format" => $options["timepicker_format"],
			//"use_authorize"     => $options["authorize_enabled"],
			"use_paypal"        => $options["pp_enabled"],
			"use_stripe"        => $options["stripe_enabled"],
			"use_woocommerce"   => $use_woocommerce,
			"verify_steps"      => $options["verify_steps"]
		));
		$form_options_js_output = str_replace("'", "&apos;", $form_options_js);

		if ($preview !== null) {
			$form_class .= " ezfc-preview";
		}

		$grid_class = empty($options["grid_12"]) ? "ezfc-grid-6" : "ezfc-grid-12";

		$form_action = "";
		if ($options["hard_submit"] == 1) {
			$form_action = "//{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}";
		}

		// wrapper class filter
		$wrapper_class = apply_filters("ezfc_form_wrapper_class", $wrapper_class, $form->id);

		// main wrapper
		$html .= "<div class='ezfc-wrapper ezfc-form-{$form->id} ezfc-theme-{$theme} {$grid_class} {$wrapper_class}'>";

		// form loading text
		if ($form_show_loading) {
			$html .= "<div class='ezfc-form-loading-text'>" . get_option("ezfc_form_show_loading_text", __("Loading...", "ezfc")) . "</div>";
		}

		// adding "novalidate" is essential since required fields can be hidden due to conditional logic
		$html .= "<form class='ezfc-form {$form_class}' id='ezfc-form-{$form->id}' name='ezfc-form[{$form->id}]' action='{$form_action}' data-id='{$form->id}' data-currency='{$options["currency"]}' data-vars='{$form_options_js_output}' method='POST' novalidate>";

		// reference
		$html .= "<input type='hidden' name='id' value='{$form->id}' />";
		$html .= "<input type='hidden' name='ref_id' value='' id='ezfc-ref-id-{$form->id}' />"; // filled in with JS

		// woo product id
		// retrieve product ID via global product if it's not set
		if (empty($product_id) && !empty($product) && method_exists($product, "get_id")) {
			$product_id = $product->get_id();
		}

		if (!empty($product_id)) {
			$html .= "<input type='hidden' name='woo_product_id' value='" . esc_attr($product_id) . "' />";
		}

		// woo edit cart key
		if (!is_null($cart_key)) {
			$html .= "<input type='hidden' name='woo_cart_item_key' value='" . esc_attr($cart_key) . "' />";
		}

		// price
		if ($options["currency_position"] == 0) {
			$price_html = "<span class='ezfc-price-currency ezfc-price-currency-before'>{$options["currency"]}</span><span class='ezfc-price-value' data-id='{$form->id}'>0</span>";
		}
		else {
			$price_html = "<span class='ezfc-price-value' data-id='{$form->id}'>0</span><span class='ezfc-price-currency ezfc-price-currency-after'>{$options["currency"]}</span>";
		}

		// total price above form elements
		if ($options["show_price_position"] == 2 || $options["show_price_position"] == 3) {
			$html .= "<div class='ezfc-element ezfc-price-wrapper-element'>";
			$html .= "	<label class='ezfc-label' {$css_label_width}>" . $options["price_label"] . "</label>";
			$html .= "	<div class='ezfc-price-wrapper'>";
			$html .= "		<span class='ezfc-price-prefix'>{$options["price_label_prefix"]}</span>";
			$html .= "		<span class='ezfc-price'>{$price_html}</span>";
			$html .= "		<span class='ezfc-price-suffix'>{$options["price_label_suffix"]}</span>";
			$html .= "	</div>";
			$html .= "</div>";
		}

		// step indicators
		if ($options["step_indicator"] == 1) {
			$html .= "<div class='ezfc-step-indicator'>";

			$indicator_start = (int) $options["step_indicator_start"];
			if (is_nan($indicator_start)) {
				$indicator_start = 0;
			}
			else {
				$indicator_start -= 1;
			}
			$indicator_start = max($indicator_start, 0);

			$s_loop = 1;
			for ($s = $indicator_start; $s < $this->step_count; $s++) {
				$step_add_class = $s == 0 ? "ezfc-step-indicator-item-active" : "";

				if ($options["step_allow_free_navigation"] == 1) {
					$step_add_class .= " ezfc-step-indicator-item-force";
				}

				if ($options["step_use_titles"] == 1) {
					$step_title_text = sprintf($step_titles[$s], $s + 1);
				}
				else {
					$step_title_text = sprintf($options["step_indicator_text"], $s_loop);
				}

				$html .= sprintf("<a class='ezfc-step-indicator-item {$step_add_class}' href='#' data-step='{$s}'>%s</a>", $step_title_text);

				$s_loop++;
			}

			$html .= "</div>";
			$html .= "<div class='ezfc-clear'></div>";
		}

		// begin of form elements
		$html .= "<div class='ezfc-form-elements'>";

		foreach ($form_elements as $i => $element) {
			if (!isset($this->elements[$element->e_id]) && $element->e_id != 0) {
				$this->debug(sprintf(__("Element %s does not exist.", "ezfc"), $element->id));
				continue;
			}

			$form_element_output = $this->get_form_element_output($element, $form, $options);
			// add to html array
			$html_array[$element->id] = array(
				"element" => $element,
				"output"  => $form_element_output["html"]
			);
			// add to js output
			$this->element_js_vars[$form->id][$element->id] = $form_element_output["element_js_vars"];
		}

		// set unique trigger IDs
		foreach ($form_elements as $i => $element) {
			// unique trigger ids
			$trigger_ids[$element->id] = array_unique($trigger_ids[$element->id]);

			$this->element_js_vars[$form->id][$element->id]["trigger_ids"] = $trigger_ids[$element->id];
		}

		$html_element_output_final = $this->build_element_output($html_array);
		
		$html .= $html_element_output_final;

		// end of form elements
		$html .= "</div>";

		// summary
		if ($options["summary_enabled"] == 1) {
			$html .= "<div class='ezfc-summary-wrapper ezfc-element ezfc-hidden'>";
			// summary text
			$html .= "  <label class='ezfc-label ezfc-summary-text'>" . $this->apply_content_filter($options["summary_text"]) . "</label>";
			// actual summary
			$html .= "  <div class='ezfc-summary'></div>";
			$html .= "</div>";
		}

		// price
		if ($options["show_price_position"] == 1 ||	$options["show_price_position"] == 3) {
			$html .= "<div class='ezfc-element ezfc-price-wrapper-element'>";
			$html .= "	<label class='ezfc-label' {$css_label_width}>" . $options["price_label"] . "</label>";
			$html .= "	<div class='ezfc-price-wrapper'>";
			$html .= "		<span class='ezfc-price-prefix'>{$options["price_label_prefix"]}</span>";
			$html .= "		<span class='ezfc-price'>{$price_html}</span>";
			$html .= "		<span class='ezfc-price-suffix'>{$options["price_label_suffix"]}</span>";
			$html .= "	</div>";
			$html .= "</div>";
		}

		// reset button
		if (!empty($options["reset_enabled"]) && $options["reset_enabled"]["enabled"] == 1) {
			$html .= "<div class='ezfc-element ezfc-reset-wrapper'>";
			$html .= "	<label {$css_label_width}></label>";
			$html .= "	<button class='ezfc-btn ezfc-element ezfc-element-reset ezfc-reset' id='ezfc-reset-{$form->id}'>{$options["reset_enabled"]["text"]}</button>";
			$html .= "</div>";
		}

		// submit
		if ($options["submission_enabled"] == 1) {
			// summary
			if ($options["summary_enabled"] == 1) $submit_text = $options["summary_button_text"];
			// submission / woocommerce
			else if ($use_woocommerce == 1) $submit_text = $options["submit_text_woo"];
			// paypal
			else if ($options["pp_enabled"] == 1) $submit_text = $options["pp_submittext"];
			// default
			else $submit_text = $options["submit_text"];

			$submit_text = $this->get_listen_placeholders(null, $submit_text);

			$html .= "<div class='ezfc-element ezfc-submit-wrapper'>";
			$html .= "	<label {$css_label_width}></label>";
			$html .= "	<input class='ezfc-btn ezfc-element ezfc-element-submit ezfc-submit {$options["submit_button_class"]}' id='ezfc-submit-{$form->id}' type='submit' value='" . esc_attr($submit_text) . "' data-element='submit' />";
			// loading icon
			$html .= "	<span class='ezfc-submit-icon'><i class='" . esc_attr(get_option("ezfc_loading_icon", "fa fa-cog fa-spin")) . "'></i></span>";
			$html .= "</div>";
		}

		// required char
		$required_text = get_option("ezfc_required_text");
		if (!empty($options["required_text"])) {
			$required_text = $options["required_text"];
		}

		if ($options["show_required_char"] != 0 && !empty($required_text)) {
			$html .= "<div class='ezfc-required-notification'><span class='ezfc-required-char'>*</span> " . $required_text . "</div>";
		}

		// stripe token
		if ($stripe_enabled) {
			$html .= "<input type='hidden' name='stripeToken' id='ezfc-stripetoken-{$form->id}' value='' />";
		}
		// authorize token
		if ($authorize_enabled) {
			$html .= "<input type='hidden' name='authorizeToken' id='ezfc-authorizetoken-{$form->id}' value='' />";
		}

		$html .= "</form>";

		// fixed wrapper position
		$fixed_wrapper_add     = false;
		$fixed_wrapper_content = "";
		$fixed_price_position  = "right";

		// add fixed price
		if ($options["show_price_position"] == 4 ||	$options["show_price_position"] == 5) {
			$fixed_price_position = $options["show_price_position"]==4 ? "left" : "right";

			$fixed_wrapper_content .= "<div class='ezfc-fixed-price ezfc-fixed-price-{$fixed_price_position} ezfc-price-wrapper-element' data-id='{$form->id}'>";
			$fixed_wrapper_content .= "	<label {$css_label_width}>" . $options["price_label"] . "</label>";
			$fixed_wrapper_content .= "	<div class='ezfc-price-wrapper'>";
			$fixed_wrapper_content .= "		<span class='ezfc-price-prefix'>{$options["price_label_prefix"]}</span>";
			$fixed_wrapper_content .= "		<span class='ezfc-price'>{$price_html}</span>";
			$fixed_wrapper_content .= "		<span class='ezfc-price-suffix'>{$options["price_label_suffix"]}</span>";
			$fixed_wrapper_content .= "	</div>";
			$fixed_wrapper_content .= "</div>";

			$fixed_wrapper_add = true;
		}

		// live summary table
		if (Ezfc_Functions::get_array_value($options, "live_summary_enabled", 0) == 1) {
			$text_above = do_shortcode(Ezfc_Functions::get_array_value($options, "live_summary_text_above", ""));
			$text_below = do_shortcode(Ezfc_Functions::get_array_value($options, "live_summary_text_below", ""));

			$fixed_wrapper_content .= "<div class='ezfc-live-summary' id='ezfc-live-summary-{$form->id}'>";
			$fixed_wrapper_content .= 	"<div class='ezfc-live-summary-text-above'>{$text_above}</div>";
			$fixed_wrapper_content .= 	"<div class='ezfc-live-summary-content'></div>";
			$fixed_wrapper_content .= 	"<div class='ezfc-live-summary-text-below'>{$text_below}</div>";
			$fixed_wrapper_content .= "</div>";

			$fixed_wrapper_add = true;
		}

		if ($fixed_wrapper_add) {
			$html .= "<div class='ezfc-fixed ezfc-fixed-{$fixed_price_position}' data-id='{$form->id}'>";
			$html .= 	$fixed_wrapper_content;
			$html .= "</div>";
		}

		// error messages
		$html .= "<div class='ezfc-message' id='ezfc-message-{$form->id}'></div>";

		// success message
		if (get_option("ezfc_woocommerce") == 1 && $options["woo_disable_form"] == 0) {
			$success_text = get_option("ezfc_woocommerce_text");
		}
		else {
			$success_text = $options["success_text"];
		}
		$success_text = $this->replace_values_text($success_text);

		$html .= "<div class='ezfc-success-text' data-id='{$form->id}'></div>";

		// stripe payment
		if ($stripe_enabled) {
			wp_enqueue_script("ezfc-stripejs", "https://js.stripe.com/v2/");

			// modal
			$html .= "<div id='ezfc-stripe-form-modal-{$form->id}' class='ezfc-payment-dialog-modal' data-form_id='{$form->id}'></div>";
			// payment form
			$html .= $this->get_template("payment/stripe-popup");
		}
		// authorize payment
		if ($authorize_enabled) {
			wp_enqueue_script("ezfc-authorize-acceptjs");

			// modal
			$html .= "<div id='ezfc-authorize-form-modal-{$form->id}' class='ezfc-payment-dialog-modal' data-form_id='{$form->id}'></div>";
			// payment form
			$html .= $this->get_template("payment/authorize-popup");
		}

		// wrapper
		$html .= "</div>";

		// overview
		$html .= "<div class='ezfc-overview' data-id='{$form->id}'></div>";

		$html .= apply_filters("ezfc_form_output_end", "", $form->id);

		$html = apply_filters("ezfc_form_output", $html, $form, $options);

		// add view
		if (class_exists("Ezfc_stats")) {
			$ezfc_stats_instance = Ezfc_stats::instance();
			$ezfc_stats_instance::view($form->id);
		}

		return $html;
	}
}