<?php

abstract class Ezfc_i18n {
	static function get_vars() {
		$ezfc_vars = array(
			"delete"                 => __("Delete", "ezfc"),
			"delete_form"            => __("Really delete the selected form?", "ezfc"),
			"delete_element"         => __("Really delete the selected element?", "ezfc"),
			"file_download_url"      => trailingslashit(site_url()) . "ezfc-file.php",
			"form_changed"           => __("You have changed the form without having saved. Really leave the current form unsaved?"),
			"form_overwrite_confirm" => __("Really overwrite this option for all forms?", "ezfc"),
			"price"                  => __("Price", "ezfc"),
			"submit_button"          => __("Submit button", "ezfc"),
			"unavailable_element"    => __("Unavailable for this element.", "ezfc"),
			"yes_no" => array(
				"yes" => __("Yes", "ezfc"),
				"no"  => __("No", "ezfc")
			),
			"conditional_actions" => array(
				"show"                      => __("Show", "ezfc"),
				"hide"                      => __("Hide", "ezfc"),
				"calc_routine_enable"       => __("Enable calc routine (index)"),
				"calc_routine_enable_name"  => __("Enable calc routine (name)"),
				"calc_routine_disable"      => __("Disable calc routine (index)"),
				"calc_routine_disable_name" => __("Disable calc routine (name)"),
				"set"                       => __("Set", "ezfc"),
				"set_factor"                => __("Set factor", "ezfc"),
				"activate"                  => __("Activate", "ezfc"),
				"activate_option"           => __("Activate option", "ezfc"),
				"deactivate"                => __("Deactivate", "ezfc"),
				"deactivate_option"         => __("Deactivate option", "ezfc"),
				"select_option"             => __("Select option", "ezfc"),
				"deselect_option"           => __("Deselect option", "ezfc"),
				"show_option"               => __("Show option", "ezfc"),
				"hide_option"               => __("Hide option", "ezfc"),
				"redirect"                  => __("Redirect", "ezfc"),
				"step_goto"                 => __("Go to step", "ezfc"),
				"step_next"                 => __("Next step", "ezfc"),
				"step_prev"                 => __("Previous step", "ezfc"),
				"email_target"              => __("Email target", "ezfc"),
				"set_min"                   => __("Set min", "ezfc"),
				"set_max"                   => __("Set max", "ezfc"),
				"set_min_selectable"        => __("Set min selectable", "ezfc"),
				"set_max_selectable"        => __("Set max selectable", "ezfc"),
				"add_class"                 => __("Add class", "ezfc"),
				"remove_class"              => __("Remove class", "ezfc"),
				"set_color"                 => __("Set color", "ezfc")
			),
			"element_option_description" => array(
				"add_line"                  => __("Add a line above step buttons.", "ezfc"),
				"add_to_price"              => __("The calculated price of this element will be added in the calculation routine.", "ezfc"),
				"allow_multiple"            => __("Allow multiple email addresses to be entered, separated by comma.", "ezfc"),
				"alt"                       => __("Alternate text for images which can't be loaded.", "ezfc"),
				"autocomplete"              => __("Enable or disable input autocomplete.", "ezfc"),
				"available_days"            => __("Weekdays allowed to be selected, starting with Sunday (0), Monday (1) etc. up to Saturday (6), separated by commas. If you wish to leave out Sundays and Saturdays, set the value to 1,2,3,4,5", "ezfc"),
				"blocked_days"              => __("Blocked dates, e.g.: 2017-12-30, 2017-12-31. Periods are also possible separated by a colon, e.g.: 2017-12-01 : 2017-12-31. Multiple blocked dates can be separated by commas.", "ezfc"),
				"calculate"                 => __("Choose the operator and target element to calculate with. <br><br>Example: [ * ] [ field_1 ]<br>Result = current_value + field_1 * this_field.", "ezfc"),
				"calculate_enabled"         => __("When checked, this field will be taken into calculations.", "ezfc"),
				"calculate_before"          => __("When checked, this field will be calculated first. <br><br><strong>Checked</strong>: this_field / target_calculation_field. <br><br><strong>Unchecked</strong>: target_calculation_field / this_field.", "ezfc"),
				"calculate_when_hidden"     => __("Whether to take this element into calculations when it is hidden or not.", "ezfc"),
				"class"                     => __("Additional CSS class for this element.", "ezfc"),
				"collapsible"               => __("Allow the user to collapse or expand the group manually.", "ezfc"),
				"conditional"               => __("Conditional fields can show or hide elements. Check out the conditional example from the templates or visit the documentation site for more information.", "ezfc"),
				"custom_calculation"        => __("Javascript code. The code inside will be wrapped in a unique function. You do not need to add a return value since the variable 'price' will always be returned.", "ezfc"),
				"custom_calculation_function_name" => __("Function name of the custom calculation code. By default, the function name is randomly generated.", "ezfc"),
				"custom_calculation_function_safe" => __("Only call the custom calculation function if the custom name doesn't exist in order to prevent overriding existing functions.", "ezfc"),
				"custom_calculation_function_external" => __("Call an external JS function with the given name (only if it's a callable function)", "ezfc"),
				"custom_calculation_init_js" => __("JS code that will only be called on startup.", "ezfc"),
				"custom_calculation_init_add" => __("Add the custom init JS code.", "ezfc"),
				"custom_error_message"      => __("Error message when element value does not validate regular expression from custom_regex", "ezfc"),
				"custom_filter"             => __("Run input through a custom WordPress filter.", "ezfc"),
				"custom_regex"              => __("Custom regular expression. Only numbers allowed example: /[0-9]/i", "ezfc"),
				"custom_regex_check_first"  => __("Check regex before empty-check", "ezfc"),
				"daterange_count_full_days" => __("If this option is enabled, the daterange element counts full days only instead of nights. For example, if the user selects from 2020-01-01 to 2020-01-02 the element will calculate 2 days instead of 1 day.", "ezfc"),
				"daterange_single"          => __("If this option is enabled, only one datepicker field will be shown instead of two. This is useful if you want to calculate the number of days from a specified date. Use the placeholder __today__ in the value field to set today's date (datepicker and daterange element only).", "ezfc"),
				"datepicker_change_month"   => __("Show month dropdown selection.", "ezfc"),
				"datepicker_change_year"    => __("Show year dropdown selection.", "ezfc"),
				"datepicker_day_prices_default" => __("Default price for each week day.", "ezfc"),
				"datepicker_day_prices"     => __("Individual day prices. Each line represents a new date range."),
				"datepicker_year_range"     => esc_attr(__("The range of years to be displayed. Relative values are defined like this: c-10:c+10 (will show 10 years in the past and 10 years in the future). Absolute values can be set like this: 1969:2042. Default: c-10:c+10", "ezfc")),
				"description"               => __("Users will see the description in a tooltip.", "ezfc"),
				"description_below_element" => __("This description will be shown below the element.", "ezfc"),
				"description_below_input"   => __("This description will be shown below the input field.", "ezfc"),
				"description_below_label"   => __("This description will be shown below the element label.", "ezfc"),
				"discount"                  => __("Discount values", "ezfc"),
				"discount_show_table"       => __("Generate a table with all discounts below the element.", "ezfc"),
				"discount_show_table_indicator" => __("Active indicator for the discount table.", "ezfc"),
				"discount_value_apply"      => __("The value on which the discounts be applied on.", "ezfc"),
				"discount_value_type"       => __("Which value should be checked for the discount range.", "ezfc"),
				"do_shortcode"              => __("Process shortcodes", "ezfc"),
				"double_check"              => __("Double check element values to be equal", "ezfc"),
				"email_text_column_1"       => __("This option defines which value will be shown in the first result column.", "ezfc"),
				"email_text_column_2"       => __("This option defines which value will be shown in the second result column.", "ezfc"),
				"expanded"                  => __("Whether the group should be expanded or collapsed at page load (only relevant when 'collapsible' is enabled).", "ezfc"),
				"factor"                    => __("The value will be automatically multiplied by this factor. Default factor: 1", "ezfc"),
				"fallback_image"            => __("This image will be used if no featured image was found.", "ezfc"),
				"featured_image"            => __("Use the featured image of the current post, page or product. The fallback image will be used if no featured image was found.", "ezfc"),
				"featured_image_size"       => sprintf(__("Size of the featured image. Select from %s or any custom size.", "ezfc"), "thumbnail, medium, large, full"),
				"file_upload_auto"          => __("Files will be automatically uploaded when selected if this option is enabled.", "ezfc"),
				"firstDay"                  => __("Week starts with this day: Sunday = 0, Monday = 1 etc.", "ezfc"),
				"GET"                       => __("This field will be filled from a GET-parameter. Example: <br><br><strong>URL</strong>: http://www.test.com/?test_value=1 <br><strong>GET</strong>: test_value <br><strong>Field value</strong>: 1.", "ezfc"),
				"half_stars"                => __("Allow half-star selection", "ezfc"),
				"hidden"                    => __("Hidden field. If this field is taken into conditional calculations, you need to enable the element option Calculate_when_hidden.", "ezfc"),
				"image_auto_width"          => __("If this option is enabled, all options will be displayed in a single row with equal width.", "ezfc"),
				"inline"                    => __("Display options in a row.", "ezfc"),
				"inline_calculation"        => sprintf(__("Perform custom calculation in JS code, e.g.: %s", "ezfc"), "{{a}} + {{b}} * {{c}}"),
				"is_currency"               => __("Format this field as currency value in submissions.", "ezfc"),
				"is_number"                 => __("Whether this element should be read as a number or not. If you are dealing with strings and conditions, set this option to 'No'.", "ezfc"),
				"is_telephone_nr"           => __("Mobile phones will automatically show the number pad when this element is focused. However, it will *not* check for actual phone numbers.", "ezfc"),
				"keep_value_after_reset"    => __("If enabled, this element will keep its value when the form will be reset.", "ezfc"),
				"label"                     => __("This text will be displayed in the frontend.", "ezfc"),
				"recaptcha_language"        => __("Set the recacptcha language. Use Google's language codes, e.g. en (English US), en-GB (English UK), de (German) etc. Leave empty so Google will auto-detect the user's language.", "ezfc"),
				"max"                       => __("Maximum value", "ezfc"),
				"maxDate"                   => __("The opposite of minDate.", "ezfc"),
				"maxDays"                   => __("The amount of maximum days to select.", "ezfc"),
				"maxTime"                   => __("Latest entry time, e.g. 23:00", "ezfc"),
				"max_length"                => __("Maximum amount of characters.", "ezfc"),
				"min_selectable"            => __("Minimum amount of selectable options. Use 0 for unlimited selectable options.", "ezfc"),
				"max_selectable"            => __("Maximum amount of selectable options. Use 0 for unlimited selectable options.", "ezfc"),
				"max_width"                 => __("Maximum width of images (if no unit is present, px will be used)."),
				"max_height"                => __("Maximum height of images (if no unit is present, px will be used)."),
				"min"                       => __("Minimum value", "ezfc"),
				"minDate"                   => __("Minimum date of both dates. Example: +1d;;+2d - the first datepicker (from) will only have selectable dates 1 day in the future, the second datepicker (to) will only have selectable dates 2 days in the future", "ezfc"),
				"minDays"                   => __("The amount of minimum days to select.", "ezfc"),
				"minTime"                   => __("Earliest time entry, e.g. 09:00", "ezfc"),
				"multiple"                  => __("When checked, multiple files can be uploaded.", "ezfc"),
				"name"                      => __("Internal name. This value is displayed in submissions/emails only.", "ezfc"),
				"numberOfMonths"            => __("Number of months to be shown simultaneously.", "ezfc"),
				"options_add_text_icon"     => __("Icons will be added to options texts.", "ezfc"),
				"options_source"            => __("Options can be retrieved via an external PHP function or from a JSON URL. Use \"Options\" so the options created in the form editor will be used.", "ezfc"),
				"options_text_only"         => __("Options will be displayed in a text box.", "ezfc"),
				"overwrite_price"           => __("When checked, this field will override the calculations above. Useful with division operator. <br><br><strong>Checked</strong>: result = target_calculation_field / this_field. <br><br><strong>Unchecked</strong>: result = current_value + target_calculation_field / this_field.", "ezfc"),
				"pips"                      => __("Show little \"pips\" in the slider.", "ezfc"),
				"placeholder"               => __("Placeholder only (slight background text when no value is present).", "ezfc"),
				"post_id"                   => __("Enter the ID of the post you want to show.", "ezfc"),
				"precision"                 => __("How many decimal numbers are used to calculate with", "ezfc"),
				"price_format"              => __("Custom price format (see numeraljs.com for syntax). Default: 0,0[.]00", "ezfc"),
				"read_only"                 => __("Element is read-only.", "ezfc"),
				"required"                  => __("Whether this is a required field or not.", "ezfc"),
				"set"                       => __("All selected elements will use the \"set_operator\".", "ezfc"),
				"set_allow_zero"            => __("If this option is enabled, elements with value 0 will be taken into calculation.", "ezfc"),
				"set_dom_selector"          => __("DOM-Selector will be used to retrieve element values, e.g. .my-elements", "ezfc"),
				"set_operator"              => __("This operator will be applied on all selected elements.", "ezfc"),
				"set_use_factor"            => __("The value to be read from another element will be multiplied by its factor.", "ezfc"),
				"show_empty_values_in_email" => __("Whether to show columns with empty values or not.", "ezfc"),
				"show_in_email"             => __("Show this element in emails", "ezfc"),
				"show_in_email_label"       => __("Which label to show in the summary table (use 'Custom' to use your own text).", "ezfc"),
				"show_in_live_summary"      => __("Show this element in the live summary", "ezfc"),
				"show_item_price"           => __("Show the item price column in the order table.", "ezfc"),
				"show_subtotal_column"      => __("Show the subtotal column in the order table.", "ezfc"),
				"showAnim"                  => __("Show animation of the datepicker. Any of the jQuery UI effects, e.g. show, slideDown, fadeIn.", "ezfc"),
				"showWeek"                  => __("Shows the week number in the datepicker.", "ezfc"),
				"slider"                    => __("Display a slider instead of a textfield. Needs minimum and maximum fields defined.", "ezfc"),
				"slidersteps"               => __("Slider step value", "ezfc"),
				"slider_values"             => __("Fixed slider values, separated by comma. Example: 10, 20.99, 50, 100", "ezfc"),
				"spinner"                   => __("Display a spinner instead of a textfield.", "ezfc"),
				"stars"                     => __("Amount of stars to be shown", "ezfc"),
				"steps_pips"                => __("Incremental steps", "ezfc"),
				"steps_slider"              => __("Incremental steps", "ezfc"),
				"steps_spinner"             => __("Incremental steps", "ezfc"),
				"store_type"                => __("This option determines how the value will be stored. For passwords, you should leave this to none or encrypt it in terms of security as plain text is not recommended.", "ezfc"),
				"style"                     => __("CSS inline style, example (without quotes): \"color: #f00; margin-top: 1em;\"", "ezfc"),
				"tag"                       => __("HTML tag", "ezfc"),
				"text_after"                => __("Text after price", "ezfc"),
				"text_before"               => __("Text before price", "ezfc"),
				"title"                     => __("Title", "ezfc"),
				"use_address"               => __("Emails will be sent to this address.", "ezfc"),
				"text_only"                 => __("Display text only instead of an input field", "ezfc"),
				"use_woocommerce_price"     => __("This element will get the price of the current WooCommerce product.", "ezfc"),
				"value"                     => __("Predefined value. If you use floating values, you always have to use a dot as decimal point.", "ezfc"),
				"value_attribute"           => __("Retrieve attribute value from the current WooCommerce product.", "ezfc"),
				"value_external"            => __("DOM-selector to get the value from (e.g. #myinputfield).", "ezfc"),
				"value_external_listen"     => __("If a selector is entered in the value_external option, the plugin is listening to any changes in the selector element. If this behavior is not wanted, you should disable this option.", "ezfc"),
				"value_http"                => __("Fetch value from an external website. Make sure to enter a correct URL, e.g. http://www.yoursite.com/get_value.php", "ezfc"),
				"value_http_json"           => __("If the fetched value from the value_http option is a JSON object, you can access any property in the object here ( e.g. object.property.somekey ).", "ezfc"),
				"verify_value"              => __("If this option is enabled, the plugin will try to check if a correct value was entered. If this option is disabled, the input check will be skipped.", "ezfc"),
				"workdays_only"             => __("Calculate the amount of work days only (Saturday and Sunday excluded).", "ezfc"),
				"wrapper_class"             => __("CSS class that will be added to the element wrapper.", "ezfc"),
				"wrapper_style"             => __("CSS inline style that will be added to the element wrapper.", "ezfc")
			),
			"element_tip_description" => array(
				"action_perform"              => esc_attr(__("This action will be performed", "ezfc")),
				"calc_target_element"         => esc_attr(__("The value of the target element will be used to calculate with", "ezfc")),
				"calc_target_value"           => esc_attr(__("The calculation value will only be used when no target element is selected", "ezfc")),
				"calc_ctv_raw"                => esc_attr("1) " . __("Raw value", "ezfc")),
				"calc_ctv_raw_without_factor" => esc_attr("2) " . __("Raw value without factor", "ezfc")),
				"calc_ctv_with_subtotal"      => esc_attr("3) " . __("Calculated value with subtotal", "ezfc")),
				"calc_ctv_without_subtotal"   => esc_attr("4) " . __("Calculated value without subtotal", "ezfc")),
				"conditional_chain"           => esc_attr(__("Conditional action will only be performed when all conditions are true.", "ezfc")),
				"conditional_factor"          => esc_attr(__("Calculate with factor: the value to be read from another element will be multiplied by its factor", "ezfc")),
				"conditional_operator"        => esc_attr(__("Conditional operator: compare operator of this element's value and target element's value. For the 'in between' operator, use a colon (:) as separator, example: 20:100", "ezfc")),
				"conditional_row_operator"    => esc_attr(__("If this checkbox is checked, then at least one condition needs to be true to trigger the conditional action.")),
				"conditional_toggle"          => esc_attr(__("Conditional toggle: when this field is checked, the opposite action will not be executed when this condition is triggered. Example: if you want to show an element on a certain condition but don't hide it automatically, you need to select this checkbox.", "ezfc")),
				"conditional_value"           => esc_attr(__("Conditional value. Use __self__ to use this element's value as compare value.", "ezfc")),
				"discount_operator"           => esc_attr(__("Discount operator for the following discount value", "ezfc")),
				"discount_value_min"          => esc_attr(__("Minimum value for this discount condition (leave blank for negative infinity)", "ezfc")),
				"discount_value_max"          => esc_attr(__("Maximum value for this discount condition (leave blank for positive infinity)", "ezfc")),
				"option_create_condition"     => esc_attr(__("Create condition", "ezfc")),
				"prio_dec"                    => esc_attr(__("Decrease priority", "ezfc")),
				"prio_inc"                    => esc_attr(__("Increase priority", "ezfc")),
				"target_element"              => esc_attr(__("Target element", "ezfc")),
				"target_value"                => esc_attr(__("Set target element value to this value (only used with 'Set' action). Use __self__ in order to set the target element's value to the current value of this element.", "ezfc")),
				"use_calculated_target_value" => esc_attr(__("Use calculated target value. By default, the raw input value from the target element will be retrieved. If you want to retrieve the calculated element value, you need to select 'Use calculated target value' or 'Use calculated target value without Subtotal' (the latter is only relevant for Subtotal elements).", "ezfc"))
			),
			"notifications" => array(
				"value_dot_notfication" => __("NOTE: you have to use a dot as decimal point for floating numbers.", "ezfc")
			),
			"set_operators" => array(
				"min"  => __("Minimum", "ezfc"),
				"max"  => __("Maximum", "ezfc"),
				"avg"  => __("Average", "ezfc"),
				"sum"  => __("Sum", "ezfc"),
				"dif"  => __("Difference", "ezfc"),
				"prod" => __("Product", "ezfc"),
				"quot" => __("Quotient", "ezfc")
			),
			"texts" => array(
				"action"                       => __("Action", "ezfc"),
				"add_another_condition"        => __("Add another condition", "ezfc"),
				"add_calculation_field"        => __("Add calculation field", "ezfc"),
				"add_calculation_routine"      => __("Add calculation routine", "ezfc"),
				"add_calculation_row"          => __("Add calculation row", "ezfc"),
				"add_conditional_field"        => __("Add conditional field", "ezfc"),
				"add_discount_field"           => __("Add discount field", "ezfc"),
				"add_option"                   => __("Add option", "ezfc"),
				"and"                          => __("AND", "ezfc"),
				"and_or"                       => __("And / Or", "ezfc"),
				"always"                       => __("always", "ezfc"),
				"autocomplete_value_placeholder" => __("Autocomplete value", "ezfc"),
				"batch_edit"                   => __("Batch edit", "ezfc"),
				"blank"                        => __("Blank", "ezfc"),
				"blur"                         => __("blur", "ezfc"),
				"calculated_value"             => __("Calculated value", "ezfc"),
				"change_element"               => __("Change element", "ezfc"),
				"close_element_data"           => __("Close", "ezfc"),
				"choose_image"                 => esc_attr(__("Choose image", "ezfc")),
				"choose_icon"                  => __("Choose icon", "ezfc"),
				"close"                        => __("Close", "ezfc"),
				"compare_value"                => __("Compare value", "ezfc"),
				"conditional_hidden"           => __("Conditional hidden", "ezfc"),
				"conditional_operator_short"   => __("CO", "ezfc"),
				"country"                      => __("Country", "ezfc"),
				"ctv_raw"                      => __("Use raw target value", "ezfc"),
				"ctv_subtotal"                 => __("Use calculated target value with subtotal", "ezfc"),
				"ctv_without_subtotal"         => __("Use calculated target value without subtotal", "ezfc"),
				"custom"                       => __("Custom", "ezfc"),
				"custom_php_function"          => __("Custom PHP Function", "ezfc"),
				"default"                      => __("Default", "ezfc"),
				"disabled"                     => __("Disabled", "ezfc"),
				"discount_value"               => __("Discount value", "ezfc"),
				"documentation"                => __("Documentation", "ezfc"),
				"duplicate_name"               => __("Duplicate name", "ezfc"),
				"enabled"                      => __("Enabled", "ezfc"),
				"example"                      => __("Example", "ezfc"),
				"fileupload_conditional"       => __("Please note that file upload elements cannot be both required and hidden at the same time due to browser security restrictions."),
				"focus"                        => __("focus", "ezfc"),
				"format"                       => __("Format", "ezfc"),
				"functions"                    => __("Functions", "ezfc"),
				"get_check_option_values"      => array(
					"ind" => __("Index", "ezfc"),
					"val" => __("Value", "ezfc")
				),
				"hide_from"                    => esc_attr(__("Hide 'from' field", "ezfc")),
				"hide_to"                      => esc_attr(__("Hide 'to' field", "ezfc")),
				"if"                           => __("If", "ezfc"),
				"image"                        => __("Image", "ezfc"),
				"index"                        => esc_attr(__("Index", "ezfc")),
				"js_function_name"             => esc_attr(__("JS function name"), "ezfc"),
				"label"                        => __("Label", "ezfc"),
				"locality"                     => __("Locality", "ezfc"),
				"matrix_clear_table"           => __("Clear table", "ezfc"),
				"matrix_create_from_element_rows"    => __("Create from element (rows)", "ezfc"),
				"matrix_create_from_element_columns" => __("Create from element (columns)", "ezfc"),
				"clear_preselected_value"      => __("Clear preselected value", "ezfc"),
				"name"                         => __("Name", "ezfc"),
				"next"                         => __("Next", "ezfc"),
				"none"                         => __("None", "ezfc"),
				"no_auto_toggle"               => __("No auto toggle", "ezfc"),
				"operator"                     => __("Operator", "ezfc"),
				"option_id"                    => __("Option ID", "ezfc"),
				"option_create_all_conditions" => __("Create conditions", "ezfc"),
				"option_create_ids"            => __("Create option IDs", "ezfc"),
				"options_source_options"       => __("Options", "ezfc"),
				"options_source_php"           => __("PHP Function", "ezfc"),
				"or"                           => __("OR", "ezfc"),
				"paid_with"                    => __("Paid with:", "ezfc") . " ",
				"phone_number"                 => __("Phone Number", "ezfc") . " ",
				"plaintext"                    => __("Plain text", "ezfc"),
				"postal_code"                  => __("Postal Code", "ezfc"),
				"preselect_values"             => esc_attr(__("Preselect values", "ezfc")),
				"pp_payment_verified"          => esc_attr(__("Payment verified", "ezfc")),
				"pp_payment_denied"            => esc_attr(__("Payment denied or cancelled", "ezfc")),
				"previous"                     => __("Previous", "ezfc"),
				"region"                       => __("Region", "ezfc"),
				"remove"                       => __("Remove", "ezfc"),
				"remove_icon"                  => esc_attr(__("Remove icon", "ezfc")),
				"remove_image"                 => esc_attr(__("Remove image", "ezfc")),
				"refresh_fields"               => __("Refresh fields", "ezfc"),
				"self"                         => __("Self", "ezfc"),
				"show_if"                      => __("Show if...", "ezfc"),
				"show_if_not_empty"            => __("Show if not empty", "ezfc"),
				"show_if_not_empty_0"          => __("Show if not empty and not 0", "ezfc"),
				"show_if_visible"              => __("Show if visible", "ezfc"),
				"show_if_visible_and_not_empty" => __("Show if visible and not empty", "ezfc"),
				"show_if_visible_and_not_empty_and_not_zero" => __("Show if visible and not empty and not 0", "ezfc"),
				"step_equals"                  => __("Step =", "ezfc"),
				"step_gt"                      => __("Step >", "ezfc"),
				"step_lt"                      => __("Step <", "ezfc"),
				"street_address"               => __("Street address", "ezfc"),
				"submission_send_admin"        => __("Send to admin", "ezfc"),
				"submission_send_customer"     => __("Send to customer", "ezfc"),
				"submission_value"             => __("Submission value", "ezfc"),
				"target_element"               => __("Target element", "ezfc"),
				"target_value"                 => __("Target value", "ezfc"),
				"target_value_short"           => __("TV", "ezfc"),
				"text"                         => __("Text", "ezfc"),
				"use_calculated_target_value"  => __("Retrieve target value", "ezfc"),
				"use_factor"                   => __("Compare with target factor", "ezfc"),
				"update_options"               => __("Update options", "ezfc"),
				"value"                        => __("Value", "ezfc"),
				"value_min"                    => __("Value min", "ezfc"),
				"value_max"                    => __("Value max", "ezfc"),
				"verify_value_not_empty"       => __("Check if empty", "ezfc"),
				"vertical"                     => __("Vertical", "ezfc")
			),
			"weekdays" => array(
				0 => __("Monday", "ezfc"),
				1 => __("Tuesday", "ezfc"),
				2 => __("Wednesday", "ezfc"),
				3 => __("Thursday", "ezfc"),
				4 => __("Friday", "ezfc"),
				5 => __("Saturday", "ezfc"),
				6 => __("Sunday", "ezfc"),
			),
			"editor" => array(
				"batch_separator"           => get_option("ezfc_batch_separator", ","),
				"reopen_last_form"          => get_option("ezfc_reopen_last_form", 1),
				"reopen_last_form_id"       => get_option("ezfc_reopen_last_form_id", 1),
				"tinymce_use_relative_urls" => get_option("ezfc_tinymce_use_relative_urls", 1),
				"use_tinymce"               => get_option("ezfc_use_tinymce", 1),
				"use_large_data_editor"     => get_option("ezfc_use_large_data_editor", 1)
			)
		);

		$ezfc_vars["element_option_description"] = apply_filters("ezfc_i18n_element_option_description", $ezfc_vars["element_option_description"]);

		return $ezfc_vars;
	}
}