/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 3.20.2
 * @date    2018-02-07
 *
 * @license
 * Copyright (C) 2013-2018 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.math=t():e.math=t()}("undefined"!=typeof self?self:this,function(){return function(e){var t={};function r(n){if(t[n])return t[n].exports;var i=t[n]={i:n,l:!1,exports:{}};return e[n].call(i.exports,i,i.exports,r),i.l=!0,i.exports}return r.m=e,r.c=t,r.d=function(e,t,n){r.o(e,t)||Object.defineProperty(e,t,{configurable:!1,enumerable:!0,get:n})},r.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return r.d(t,"a",t),t},r.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},r.p="",r(r.s=151)}([function(e,t,r){"use strict";t.name="matrix",t.factory=function(e,t,r,n){var i=n("matrix",{"":function(){return a([])},string:function(e){return a([],e)},"string, string":function(e,t){return a([],e,t)},Array:function(e){return a(e)},Matrix:function(e){return a(e,e.storage())},"Array | Matrix, string":a,"Array | Matrix, string, string":a});return i.toTex={0:"\\begin{bmatrix}\\end{bmatrix}",1:"\\left(${args[0]}\\right)",2:"\\left(${args[0]}\\right)"},i;function a(t,r,n){return new(e.Matrix.storage(r||"default"))(t,n)}}},function(e,t,r){"use strict";e.exports=function e(t,r,n){return t&&"function"==typeof t.map?t.map(function(t){return e(t,r,n)}):r(t)}},function(e,t,r){"use strict";var n=r(3),i=r(9),a=(r(5),r(60),r(11)),o=r(53);t.size=function(e){for(var t=[];Array.isArray(e);)t.push(e.length),e=e[0];return t},t.validate=function(e,t){if(0==t.length){if(Array.isArray(e))throw new a(e.length,0)}else!function e(t,r,n){var i,o=t.length;if(o!=r[n])throw new a(o,r[n]);if(n<r.length-1){var s=n+1;for(i=0;i<o;i++){var u=t[i];if(!Array.isArray(u))throw new a(r.length-1,r.length,"<");e(t[i],r,s)}}else for(i=0;i<o;i++)if(Array.isArray(t[i]))throw new a(r.length+1,r.length,">")}(e,t,0)},t.validateIndex=function(e,t){if(!n.isNumber(e)||!n.isInteger(e))throw new TypeError("Index must be an integer (value: "+e+")");if(e<0||"number"==typeof t&&e>=t)throw new o(e,t)},t.UNINITIALIZED={},t.resize=function(e,r,a){if(!Array.isArray(e)||!Array.isArray(r))throw new TypeError("Array expected");if(0===r.length)throw new Error("Resizing to scalar is not supported");return r.forEach(function(e){if(!n.isNumber(e)||!n.isInteger(e)||e<0)throw new TypeError("Invalid size, must contain positive integers (size: "+i.format(r)+")")}),function e(r,n,i,a){var o;var s;var u=r.length;var c=n[i];var f=Math.min(u,c);r.length=c;if(i<n.length-1){var l=i+1;for(o=0;o<f;o++)s=r[o],Array.isArray(s)||(s=[s],r[o]=s),e(s,n,l,a);for(o=f;o<c;o++)s=[],r[o]=s,e(s,n,l,a)}else{for(o=0;o<f;o++)for(;Array.isArray(r[o]);)r[o]=r[o][0];if(a!==t.UNINITIALIZED)for(o=f;o<c;o++)r[o]=a}}(e,r,0,void 0!==a?a:0),e},t.reshape=function(e,r){var n,i=t.flatten(e),o=function(e){return e.reduce(function(e,t){return e*t})};if(!Array.isArray(e)||!Array.isArray(r))throw new TypeError("Array expected");if(0===r.length)throw new a(0,o(t.size(e)),"!=");try{n=function e(t,r){var n=[];var i;if(0===r.length){if(0===t.length)throw new a(null,null,"!=");return t.shift()}for(i=0;i<r[0];i+=1)n.push(e(t,r.slice(1)));return n}(i,r)}catch(n){if(n instanceof a)throw new a(o(r),o(t.size(e)),"!=");throw n}if(i.length>0)throw new a(o(r),o(t.size(e)),"!=");return n},t.squeeze=function(e,r){for(var n=r||t.size(e);Array.isArray(e)&&1===e.length;)e=e[0],n.shift();for(var i=n.length;1===n[i-1];)i--;return i<n.length&&(e=function e(t,r,n){var i,a;if(n<r){var o=n+1;for(i=0,a=t.length;i<a;i++)t[i]=e(t[i],r,o)}else for(;Array.isArray(t);)t=t[0];return t}(e,i,0),n.length=i),e},t.unsqueeze=function(e,r,n,i){var a=i||t.size(e);if(n)for(var o=0;o<n;o++)e=[e],a.unshift(1);for(e=function e(t,r,n){var i,a;if(Array.isArray(t)){var o=n+1;for(i=0,a=t.length;i<a;i++)t[i]=e(t[i],r,o)}else for(var s=n;s<r;s++)t=[t];return t}(e,r,0);a.length<r;)a.push(1);return e},t.flatten=function(e){if(!Array.isArray(e))return e;var t=[];return e.forEach(function e(r){Array.isArray(r)?r.forEach(e):t.push(r)}),t},t.map=function(e,t){return Array.prototype.map.call(e,t)},t.forEach=function(e,t){Array.prototype.forEach.call(e,t)},t.filter=function(e,r){if(1!==t.size(e).length)throw new Error("Only one dimensional matrices supported");return Array.prototype.filter.call(e,r)},t.filterRegExp=function(e,r){if(1!==t.size(e).length)throw new Error("Only one dimensional matrices supported");return Array.prototype.filter.call(e,function(e){return r.test(e)})},t.join=function(e,t){return Array.prototype.join.call(e,t)},t.identify=function(e){if(!Array.isArray(e))throw new TypeError("Array input expected");if(0===e.length)return e;var t=[],r=0;t[0]={value:e[0],identifier:0};for(var n=1;n<e.length;n++)e[n]===e[n-1]?r++:r=0,t.push({value:e[n],identifier:r});return t},t.generalize=function(e){if(!Array.isArray(e))throw new TypeError("Array input expected");if(0===e.length)return e;for(var t=[],r=0;r<e.length;r++)t.push(e[r].value);return t},t.isArray=Array.isArray},function(e,t,r){"use strict";function n(e){for(var t=[],r=0;r<e;r++)t.push(0);return t}t.isNumber=function(e){return"number"==typeof e},t.isInteger=function(e){return!!isFinite(e)&&e==Math.round(e)},t.sign=Math.sign||function(e){return e>0?1:e<0?-1:0},t.format=function(e,r){if("function"==typeof r)return r(e);if(e===1/0)return"Infinity";if(e===-1/0)return"-Infinity";if(isNaN(e))return"NaN";var n="auto",i=void 0;switch(r&&(r.notation&&(n=r.notation),t.isNumber(r)?i=r:r.precision&&(i=r.precision)),n){case"fixed":return t.toFixed(e,i);case"exponential":return t.toExponential(e,i);case"engineering":return t.toEngineering(e,i);case"auto":return t.toPrecision(e,i,r&&r.exponential).replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],t=arguments[4];return"."!==e?e+t:t});default:throw new Error('Unknown notation "'+n+'". Choose "auto", "exponential", or "fixed".')}},t.splitNumber=function(e){var t=String(e).toLowerCase().match(/^0*?(-?)(\d+\.?\d*)(e([+-]?\d+))?$/);if(!t)throw new SyntaxError("Invalid number "+e);var r=t[1],n=t[2],i=parseFloat(t[4]||"0"),a=n.indexOf(".");i+=-1!==a?a-1:n.length-1;var o=n.replace(".","").replace(/^0*/,function(e){return i-=e.length,""}).replace(/0*$/,"").split("").map(function(e){return parseInt(e)});return 0===o.length&&(o.push(0),i++),{sign:r,coefficients:o,exponent:i}},t.toEngineering=function(e,r){if(isNaN(e)||!isFinite(e))return String(e);var i=t.roundDigits(t.splitNumber(e),r),a=i.exponent,o=i.coefficients,s=a%3==0?a:a<0?a-3-a%3:a-a%3,u=a>=0?a:Math.abs(s);o.length-1<u&&(o=o.concat(n(u-(o.length-1))));for(var c=Math.abs(a-s),f=1;--c>=0;)f++;var l=o.slice(f).join(""),p=l.match(/[1-9]/)?"."+l:"",h=o.slice(0,f).join("")+p+"e"+(a>=0?"+":"")+s.toString();return i.sign+h},t.toFixed=function(e,r){if(isNaN(e)||!isFinite(e))return String(e);var i=t.splitNumber(e),a=t.roundDigits(i,i.exponent+1+(r||0)),o=a.coefficients,s=a.exponent+1,u=s+(r||0);return o.length<u&&(o=o.concat(n(u-o.length))),s<0&&(o=n(1-s).concat(o),s=1),r&&o.splice(s,0,0===s?"0.":"."),a.sign+o.join("")},t.toExponential=function(e,r){if(isNaN(e)||!isFinite(e))return String(e);var i=t.splitNumber(e),a=r?t.roundDigits(i,r):i,o=a.coefficients,s=a.exponent;o.length<r&&(o=o.concat(n(r-o.length)));var u=o.shift();return a.sign+u+(o.length>0?"."+o.join(""):"")+"e"+(s>=0?"+":"")+s},t.toPrecision=function(e,r,i){if(isNaN(e)||!isFinite(e))return String(e);var a=i&&void 0!==i.lower?i.lower:.001,o=i&&void 0!==i.upper?i.upper:1e5,s=t.splitNumber(e),u=Math.abs(Math.pow(10,s.exponent));if(u<a||u>=o)return t.toExponential(e,r);var c=r?t.roundDigits(s,r):s,f=c.coefficients,l=c.exponent;f.length<r&&(f=f.concat(n(r-f.length))),f=f.concat(n(l-f.length+1+(f.length<r?r-f.length:0))),f=n(-l).concat(f);var p=l>0?l:0;return p<f.length-1&&f.splice(p+1,0,"."),c.sign+f.join("")},t.roundDigits=function(e,t){for(var r={sign:e.sign,coefficients:e.coefficients,exponent:e.exponent},n=r.coefficients;t<=0;)n.unshift(0),r.exponent++,t++;if(n.length>t&&n.splice(t,n.length-t)[0]>=5){var i=t-1;for(n[i]++;10===n[i];)n.pop(),0===i&&(n.unshift(0),r.exponent++,i++),n[--i]++}return r},t.digits=function(e){return e.toExponential().replace(/e.*$/,"").replace(/^0\.?0*|\./,"").length},t.DBL_EPSILON=Number.EPSILON||2.220446049250313e-16,t.nearlyEqual=function(e,r,n){if(null==n)return e==r;if(e==r)return!0;if(isNaN(e)||isNaN(r))return!1;if(isFinite(e)&&isFinite(r)){var i=Math.abs(e-r);return i<t.DBL_EPSILON||i<=Math.max(Math.abs(e),Math.abs(r))*n}return!1}},function(e,t,r){"use strict";var n=r(173);t.symbols={Alpha:"A",alpha:"\\alpha",Beta:"B",beta:"\\beta",Gamma:"\\Gamma",gamma:"\\gamma",Delta:"\\Delta",delta:"\\delta",Epsilon:"E",epsilon:"\\epsilon",varepsilon:"\\varepsilon",Zeta:"Z",zeta:"\\zeta",Eta:"H",eta:"\\eta",Theta:"\\Theta",theta:"\\theta",vartheta:"\\vartheta",Iota:"I",iota:"\\iota",Kappa:"K",kappa:"\\kappa",varkappa:"\\varkappa",Lambda:"\\Lambda",lambda:"\\lambda",Mu:"M",mu:"\\mu",Nu:"N",nu:"\\nu",Xi:"\\Xi",xi:"\\xi",Omicron:"O",omicron:"o",Pi:"\\Pi",pi:"\\pi",varpi:"\\varpi",Rho:"P",rho:"\\rho",varrho:"\\varrho",Sigma:"\\Sigma",sigma:"\\sigma",varsigma:"\\varsigma",Tau:"T",tau:"\\tau",Upsilon:"\\Upsilon",upsilon:"\\upsilon",Phi:"\\Phi",phi:"\\phi",varphi:"\\varphi",Chi:"X",chi:"\\chi",Psi:"\\Psi",psi:"\\psi",Omega:"\\Omega",omega:"\\omega",true:"\\mathrm{True}",false:"\\mathrm{False}",i:"i",inf:"\\infty",Inf:"\\infty",infinity:"\\infty",Infinity:"\\infty",oo:"\\infty",lim:"\\lim",undefined:"\\mathbf{?}"},t.operators={transpose:"^\\top",factorial:"!",pow:"^",dotPow:".^\\wedge",unaryPlus:"+",unaryMinus:"-",bitNot:"~",not:"\\neg",multiply:"\\cdot",divide:"\\frac",dotMultiply:".\\cdot",dotDivide:".:",mod:"\\mod",add:"+",subtract:"-",to:"\\rightarrow",leftShift:"<<",rightArithShift:">>",rightLogShift:">>>",equal:"=",unequal:"\\neq",smaller:"<",larger:">",smallerEq:"\\leq",largerEq:"\\geq",bitAnd:"\\&",bitXor:"\\underline{|}",bitOr:"|",and:"\\wedge",xor:"\\veebar",or:"\\vee"},t.defaultTemplate="\\mathrm{${name}}\\left(${args}\\right)";var i={deg:"^\\circ"};t.escape=function(e){return n(e,{preserveFormatting:!0})},t.toSymbol=function(e,r){return(r=void 0!==r&&r)?i.hasOwnProperty(e)?i[e]:"\\mathrm{"+t.escape(e)+"}":t.symbols.hasOwnProperty(e)?t.symbols[e]:t.escape(e)}},function(e,t,r){"use strict";var n=r(71);t.clone=function e(r){var i=typeof r;if("number"===i||"string"===i||"boolean"===i||null===r||void 0===r)return r;if("function"==typeof r.clone)return r.clone();if(Array.isArray(r))return r.map(function(t){return e(t)});if(r instanceof Number)return new Number(r.valueOf());if(r instanceof String)return new String(r.valueOf());if(r instanceof Boolean)return new Boolean(r.valueOf());if(r instanceof Date)return new Date(r.valueOf());if(n(r))return r;if(r instanceof RegExp)throw new TypeError("Cannot clone "+r);return t.map(r,e)},t.map=function(e,r){var n={};for(var i in e)t.hasOwnProperty(e,i)&&(n[i]=r(e[i]));return n},t.extend=function(e,r){for(var n in r)t.hasOwnProperty(r,n)&&(e[n]=r[n]);return e},t.deepExtend=function e(r,n){if(Array.isArray(n))throw new TypeError("Arrays are not supported by deepExtend");for(var i in n)if(t.hasOwnProperty(n,i))if(n[i]&&n[i].constructor===Object)void 0===r[i]&&(r[i]={}),r[i].constructor===Object?e(r[i],n[i]):r[i]=n[i];else{if(Array.isArray(n[i]))throw new TypeError("Arrays are not supported by deepExtend");r[i]=n[i]}return r},t.deepEqual=function(e,r){var n,i,a;if(Array.isArray(e)){if(!Array.isArray(r))return!1;if(e.length!=r.length)return!1;for(i=0,a=e.length;i<a;i++)if(!t.deepEqual(e[i],r[i]))return!1;return!0}if(e instanceof Object){if(Array.isArray(r)||!(r instanceof Object))return!1;for(n in e)if(!t.deepEqual(e[n],r[n]))return!1;for(n in r)if(!t.deepEqual(e[n],r[n]))return!1;return!0}return typeof e==typeof r&&e==r},t.canDefineProperty=function(){try{if(Object.defineProperty)return Object.defineProperty({},"x",{get:function(){}}),!0}catch(e){}return!1},t.lazy=function(e,r,n){if(t.canDefineProperty()){var i,a=!0;Object.defineProperty(e,r,{get:function(){return a&&(i=n(),a=!1),i},set:function(e){i=e,a=!1},configurable:!0,enumerable:!0})}else e[r]=n()},t.traverse=function(e,t){var r=e;if(t)for(var n=t.split("."),i=0;i<n.length;i++){var a=n[i];a in r||(r[a]={}),r=r[a]}return r},t.hasOwnProperty=function(e,t){return e&&Object.hasOwnProperty.call(e,t)},t.isFactory=function(e){return e&&"function"==typeof e.factory}},function(e,t,r){"use strict";var n=r(5).clone;t.name="algorithm14",t.factory=function(e,t,r,i){var a=e.DenseMatrix,o=function(e,t,r,n,i,a,s){var u=[];if(t===r.length-1)for(var c=0;c<n;c++)u[c]=s?e(a,i[c]):e(i[c],a);else for(var f=0;f<n;f++)u[f]=o(e,t+1,r,r[t+1],i[f],a,s);return u};return function(e,t,r,s){var u,c=e._data,f=e._size,l=e._datatype,p=r;"string"==typeof l&&(u=l,t=i.convert(t,u),p=i.find(r,[u,u]));var h=f.length>0?o(p,0,f,f[0],c,t,s):[];return new a({data:h,size:n(f),datatype:u})}}},function(e,t,r){var n=r(5).hasOwnProperty;t.factory=function(){var e={};return{register:function(t,r){if(void 0!==e[t])throw new Error('Cannot register type "'+t+'": already exists');e[t]=r},compile:function(t,r,i){if(n(e,t.type))return(0,e[t.type])(t,r,i);if("function"!=typeof t._compile||n(t,"_compile"))throw new Error('Cannot compile node: unknown type "'+t.type+'"');return t._compile(r,i)}}}},function(e,t,r){"use strict";var n=r(25),i=r(11);n.string.isString;t.name="algorithm13",t.factory=function(e,t,r,n){var a=e.DenseMatrix,o=function(e,t,r,n,i,a){var s=[];if(t===r.length-1)for(var u=0;u<n;u++)s[u]=e(i[u],a[u]);else for(var c=0;c<n;c++)s[c]=o(e,t+1,r,r[t+1],i[c],a[c]);return s};return function(e,t,r){var s,u=e._data,c=e._size,f=e._datatype,l=t._data,p=t._size,h=t._datatype,m=[];if(c.length!==p.length)throw new i(c.length,p.length);for(var d=0;d<c.length;d++){if(c[d]!==p[d])throw new RangeError("Dimension mismatch. Matrix A ("+c+") must match Matrix B ("+p+")");m[d]=c[d]}var g=r;"string"==typeof f&&f===h&&(s=f,t=n.convert(t,s),g=n.find(r,[s,s]));var v=m.length>0?o(g,0,m,m[0],u,l):[];return new a({data:v,size:m,datatype:s})}}},function(e,t,r){"use strict";var n=r(3).format,i=r(168).format,a=r(71);t.isString=function(e){return"string"==typeof e},t.endsWith=function(e,t){var r=e.length-t.length,n=e.length;return e.substring(r,n)===t},t.format=function(e,r){if("number"==typeof e)return n(e,r);if(a(e))return i(e,r);if((o=e)&&"object"==typeof o&&"number"==typeof o.s&&"number"==typeof o.n&&"number"==typeof o.d)return r&&"decimal"===r.fraction?e.toString():e.s*e.n+"/"+e.d;var o;if(Array.isArray(e))return function e(r,n){{if(Array.isArray(r)){for(var i="[",a=r.length,o=0;o<a;o++)0!=o&&(i+=", "),i+=e(r[o],n);return i+="]"}return t.format(r,n)}}(e,r);if(t.isString(e))return'"'+e+'"';if("function"==typeof e)return e.syntax?String(e.syntax):"function";if(e&&"object"==typeof e){if("function"==typeof e.format)return e.format(r);if(e&&e.toString()!=={}.toString())return e.toString();var s=[];for(var u in e)e.hasOwnProperty(u)&&s.push('"'+u+'": '+t.format(e[u],r));return"{"+s.join(", ")+"}"}return String(e)},t.stringify=function(e){for(var t=String(e),r="",n=0;n<t.length;){var i=t.charAt(n);"\\"===i?(r+=i,n++,""!==(i=t.charAt(n))&&-1!=='"\\/bfnrtu'.indexOf(i)||(r+="\\"),r+=i):r+='"'===i?'\\"':i,n++}return'"'+r+'"'},t.escape=function(e){var t=String(e);return t=t.replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}},function(e,t,r){"use strict";var n=r(3).nearlyEqual,i=r(37);t.factory=function(e,t,r,a){var o=a("equalScalar",{"boolean, boolean":function(e,t){return e===t},"number, number":function(e,r){return e===r||n(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return e.eq(r)||i(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return e.equals(t)},"Complex, Complex":function(e,t){return e.equals(t)},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return o(e.value,t.value)},"string, string":function(e,t){return e===t}});return o}},function(e,t,r){"use strict";function n(e,t,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.actual=e,this.expected=t,this.relation=r,this.message="Dimension mismatch ("+(Array.isArray(e)?"["+e.join(", ")+"]":e)+" "+(this.relation||"!=")+" "+(Array.isArray(t)?"["+t.join(", ")+"]":t)+")",this.stack=(new Error).stack}n.prototype=new RangeError,n.prototype.constructor=RangeError,n.prototype.name="DimensionError",n.prototype.isDimensionError=!0,e.exports=n},function(e,t,r){"use strict";var n=r(5).extend,i=r(2);t.name="multiply",t.factory=function(e,t,a,o){var s=r(4),u=a(r(0)),c=a(r(16)),f=a(r(22)),l=a(r(10)),p=a(r(19)),h=a(r(6)),m=e.DenseMatrix,d=e.SparseMatrix,g=o("multiply",n({"Array, Array":function(t,r){v(i.size(t),i.size(r));var n=g(u(t),u(r));return e.isMatrix(n)?n.valueOf():n},"Matrix, Matrix":function(e,t){var r=e.size(),n=t.size();return v(r,n),1===r.length?1===n.length?y(e,t,r[0]):x(e,t):1===n.length?b(e,t):N(e,t)},"Matrix, Array":function(e,t){return g(e,u(t))},"Array, Matrix":function(e,t){return g(u(e,t.storage()),t)},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=p(e,t,f,!1);break;case"dense":r=h(e,t,f,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=p(t,e,f,!0);break;case"dense":r=h(t,e,f,!0)}return r},"Array, any":function(e,t){return h(u(e),t,f,!1).valueOf()},"any, Array":function(e,t){return h(u(t),e,f,!0).valueOf()},"any, any":f,"Array | Matrix | any, Array | Matrix | any, ...any":function(e,t,r){for(var n=g(e,t),i=0;i<r.length;i++)n=g(n,r[i]);return n}},f.signatures)),v=function(e,t){switch(e.length){case 1:switch(t.length){case 1:if(e[0]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Vectors must have the same length");break;case 2:if(e[0]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Vector length ("+e[0]+") must match Matrix rows ("+t[0]+")");break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix B has "+t.length+" dimensions)")}break;case 2:switch(t.length){case 1:if(e[1]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Matrix columns ("+e[1]+") must match Vector length ("+t[0]+")");break;case 2:if(e[1]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Matrix A columns ("+e[1]+") must match Matrix B rows ("+t[0]+")");break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix B has "+t.length+" dimensions)")}break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix A has "+e.length+" dimensions)")}},y=function(e,t,r){if(0===r)throw new Error("Cannot multiply two empty vectors");var n,i=e._data,a=e._datatype,s=t._data,u=t._datatype,l=c,p=f;a&&u&&a===u&&"string"==typeof a&&(n=a,l=o.find(c,[n,n]),p=o.find(f,[n,n]));for(var h=p(i[0],s[0]),m=1;m<r;m++)h=l(h,p(i[m],s[m]));return h},x=function(e,t){switch(t.storage()){case"dense":return w(e,t)}throw new Error("Not implemented")},w=function(e,t){var r,n=e._data,i=e._size,a=e._datatype,s=t._data,u=t._size,l=t._datatype,p=i[0],h=u[1],d=c,g=f;a&&l&&a===l&&"string"==typeof a&&(r=a,d=o.find(c,[r,r]),g=o.find(f,[r,r]));for(var v=[],y=0;y<h;y++){for(var x=g(n[0],s[0][y]),w=1;w<p;w++)x=d(x,g(n[w],s[w][y]));v[y]=x}return new m({data:v,size:[h],datatype:r})},b=function(e,t){switch(e.storage()){case"dense":return E(e,t);case"sparse":return O(e,t)}},N=function(e,t){switch(e.storage()){case"dense":switch(t.storage()){case"dense":return M(e,t);case"sparse":return A(e,t)}break;case"sparse":switch(t.storage()){case"dense":return T(e,t);case"sparse":return S(e,t)}}},E=function(e,t){var r,n=e._data,i=e._size,a=e._datatype,s=t._data,u=t._datatype,l=i[0],p=i[1],h=c,d=f;a&&u&&a===u&&"string"==typeof a&&(r=a,h=o.find(c,[r,r]),d=o.find(f,[r,r]));for(var g=[],v=0;v<l;v++){for(var y=n[v],x=d(y[0],s[0]),w=1;w<p;w++)x=h(x,d(y[w],s[w]));g[v]=x}return new m({data:g,size:[l],datatype:r})},M=function(e,t){var r,n=e._data,i=e._size,a=e._datatype,s=t._data,u=t._size,l=t._datatype,p=i[0],h=i[1],d=u[1],g=c,v=f;a&&l&&a===l&&"string"==typeof a&&(r=a,g=o.find(c,[r,r]),v=o.find(f,[r,r]));for(var y=[],x=0;x<p;x++){var w=n[x];y[x]=[];for(var b=0;b<d;b++){for(var N=v(w[0],s[0][b]),E=1;E<h;E++)N=g(N,v(w[E],s[E][b]));y[x][b]=N}}return new m({data:y,size:[p,d],datatype:r})},A=function(e,t){var r=e._data,n=e._size,i=e._datatype,a=t._values,s=t._index,u=t._ptr,p=t._size,h=t._datatype;if(!a)throw new Error("Cannot multiply Dense Matrix times Pattern only Matrix");var m,g=n[0],v=p[1],y=c,x=f,w=l,b=0;i&&h&&i===h&&"string"==typeof i&&(m=i,y=o.find(c,[m,m]),x=o.find(f,[m,m]),w=o.find(l,[m,m]),b=o.convert(0,m));for(var N=[],E=[],M=[],A=new d({values:N,index:E,ptr:M,size:[g,v],datatype:m}),O=0;O<v;O++){M[O]=E.length;var T=u[O],S=u[O+1];if(S>T)for(var _=0,C=0;C<g;C++){for(var z,k=C+1,B=T;B<S;B++){var I=s[B];_!==k?(z=x(r[C][I],a[B]),_=k):z=y(z,x(r[C][I],a[B]))}_!==k||w(z,b)||(E.push(C),N.push(z))}}return M[v]=E.length,A},O=function(e,t){var r=e._values,n=e._index,i=e._ptr,a=e._datatype;if(!r)throw new Error("Cannot multiply Pattern only Matrix times Dense Matrix");var s,u=t._data,p=t._datatype,h=e._size[0],m=t._size[0],g=[],v=[],y=[],x=c,w=f,b=l,N=0;a&&p&&a===p&&"string"==typeof a&&(s=a,x=o.find(c,[s,s]),w=o.find(f,[s,s]),b=o.find(l,[s,s]),N=o.convert(0,s));var E=[],M=[];y[0]=0;for(var A=0;A<m;A++){var O=u[A];if(!b(O,N))for(var T=i[A],S=i[A+1],_=T;_<S;_++){var C=n[_];M[C]?E[C]=x(E[C],w(O,r[_])):(M[C]=!0,v.push(C),E[C]=w(O,r[_]))}}for(var z=v.length,k=0;k<z;k++){var B=v[k];g[k]=E[B]}return y[1]=v.length,new d({values:g,index:v,ptr:y,size:[h,1],datatype:s})},T=function(e,t){var r=e._values,n=e._index,i=e._ptr,a=e._datatype;if(!r)throw new Error("Cannot multiply Pattern only Matrix times Dense Matrix");var s,u=t._data,p=t._datatype,h=e._size[0],m=t._size[0],g=t._size[1],v=c,y=f,x=l,w=0;a&&p&&a===p&&"string"==typeof a&&(s=a,v=o.find(c,[s,s]),y=o.find(f,[s,s]),x=o.find(l,[s,s]),w=o.convert(0,s));for(var b=[],N=[],E=[],M=new d({values:b,index:N,ptr:E,size:[h,g],datatype:s}),A=[],O=[],T=0;T<g;T++){E[T]=N.length;for(var S=T+1,_=0;_<m;_++){var C=u[_][T];if(!x(C,w))for(var z=i[_],k=i[_+1],B=z;B<k;B++){var I=n[B];O[I]!==S?(O[I]=S,N.push(I),A[I]=y(C,r[B])):A[I]=v(A[I],y(C,r[B]))}}for(var P=E[T],R=N.length,U=P;U<R;U++){var q=N[U];b[U]=A[q]}}return E[g]=N.length,M},S=function(e,t){var r,n=e._values,i=e._index,a=e._ptr,s=e._datatype,u=t._values,l=t._index,p=t._ptr,h=t._datatype,m=e._size[0],g=t._size[1],v=n&&u,y=c,x=f;s&&h&&s===h&&"string"==typeof s&&(r=s,y=o.find(c,[r,r]),x=o.find(f,[r,r]));for(var w,b,N,E,M,A,O,T,S=v?[]:void 0,_=[],C=[],z=new d({values:S,index:_,ptr:C,size:[m,g],datatype:r}),k=v?[]:void 0,B=[],I=0;I<g;I++){C[I]=_.length;var P=I+1;for(M=p[I],A=p[I+1],E=M;E<A;E++)if(T=l[E],v)for(b=a[T],N=a[T+1],w=b;w<N;w++)B[O=i[w]]!==P?(B[O]=P,_.push(O),k[O]=x(u[E],n[w])):k[O]=y(k[O],x(u[E],n[w]));else for(b=a[T],N=a[T+1],w=b;w<N;w++)B[O=i[w]]!==P&&(B[O]=P,_.push(O));if(v)for(var R=C[I],U=_.length,q=R;q<U;q++){var L=_[q];S[q]=k[L]}}return C[g]=_.length,z};return g.toTex={2:"\\left(${args[0]}"+s.operators.multiply+"${args[1]}\\right)"},g}},function(e,t,r){"use strict";var n=r(5).hasOwnProperty;function i(e,t){return!(!e||"object"!=typeof e)&&(!!n(s,t)||!(t in Object.prototype)&&!(t in Function.prototype))}function a(e,t){return!(!e||"function"!=typeof e[t])&&(!(n(e,t)&&e.__proto__&&t in e.__proto__)&&(!!n(u,t)||!(t in Object.prototype)&&!(t in Function.prototype)))}function o(e){return"object"==typeof e&&e&&e.constructor===Object}var s={length:!0,name:!0},u={toString:!0,valueOf:!0,toLocaleString:!0};t.getSafeProperty=function(e,t){if(o(e)&&i(e,t))return e[t];if("function"==typeof e[t]&&a(e,t))throw new Error('Cannot access method "'+t+'" as a property');throw new Error('No access to property "'+t+'"')},t.setSafeProperty=function(e,t,r){if(o(e)&&i(e,t))return e[t]=r;throw new Error('No access to property "'+t+'"')},t.isSafeProperty=i,t.validateSafeMethod=function(e,t){if(!a(e,t))throw new Error('No access to method "'+t+'"')},t.isSafeMethod=a,t.isPlainObject=o},function(e,t,r){"use strict";t.factory=function(e,t,n,i){var a=n(r(22)),o=i("divide",{"number, number":function(e,t){return e/t},"Complex, Complex":function(e,t){return e.div(t)},"BigNumber, BigNumber":function(e,t){return e.div(t)},"Fraction, Fraction":function(e,t){return e.div(t)},"Unit, number | Fraction | BigNumber":function(e,t){var r=e.clone();return r.value=o(null===r.value?r._normalize(1):r.value,t),r},"number | Fraction | BigNumber, Unit":function(e,t){var r=t.pow(-1);return r.value=a(null===r.value?r._normalize(1):r.value,e),r},"Unit, Unit":function(e,t){return e.divide(t)}});return o}},function(e,t,r){"use strict";var n=r(77),i=r(5).deepEqual,a=r(5).hasOwnProperty;t.name="Node",t.path="expression.node",t.math=!0,t.factory=function(e,t,o,s,u){var c=o(r(7)).compile;function f(){if(!(this instanceof f))throw new SyntaxError("Constructor must be called with the new operator")}function l(e){for(var t in e)if(a(e,t)&&t in n)throw new Error('Scope contains an illegal symbol, "'+t+'" is a reserved keyword')}return f.prototype.eval=function(e){return this.compile().eval(e)},f.prototype.type="Node",f.prototype.isNode=!0,f.prototype.comment="",f.prototype.compile=function(){if(arguments.length>0)throw new Error("Calling compile(math) is deprecated. Call the function as compile() instead.");var e={math:u.expression.mathWithTransform,args:{},_validateScope:l},t=c(this,e,{}),r=Object.keys(e).map(function(e){return"    var "+e+' = defs["'+e+'"];'}).join(" ")+'return {  "eval": function (scope) {    if (scope) _validateScope(scope);    scope = scope || {};    return '+t+";  }};";return new Function("defs",r)(e)},f.prototype.forEach=function(e){throw new Error("Cannot run forEach on a Node interface")},f.prototype.map=function(e){throw new Error("Cannot run map on a Node interface")},f.prototype._ifNode=function(t){if(!e.isNode(t))throw new TypeError("Callback function must return a Node");return t},f.prototype.traverse=function(e){e(this,null,null),function e(t,r){t.forEach(function(t,n,i){r(t,n,i),e(t,r)})}(this,e)},f.prototype.transform=function(e){return function e(t,r){return t.map(function(t,n,i){return e(r(t,n,i),r)})}(e(this,null,null),e)},f.prototype.filter=function(e){var t=[];return this.traverse(function(r,n,i){e(r,n,i)&&t.push(r)}),t},f.prototype.find=function(){throw new Error("Function Node.find is deprecated. Use Node.filter instead.")},f.prototype.match=function(){throw new Error("Function Node.match is deprecated. See functions Node.filter, Node.transform, Node.traverse.")},f.prototype.clone=function(){throw new Error("Cannot clone a Node interface")},f.prototype.cloneDeep=function(){return this.map(function(e){return e.cloneDeep()})},f.prototype.equals=function(e){return!!e&&i(this,e)},f.prototype.toString=function(e){var t;if(e&&"object"==typeof e)switch(typeof e.handler){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return void 0!==t?t:this._toString(e)},f.prototype.toHTML=function(e){var t;if(e&&"object"==typeof e)switch(typeof e.handler){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return void 0!==t?t:this.toHTML(e)},f.prototype._toString=function(){throw new Error("_toString not implemented for "+this.type)},f.prototype.toTex=function(e){var t;if(e&&"object"==typeof e)switch(typeof e.handler){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return void 0!==t?t:this._toTex(e)},f.prototype._toTex=function(e){throw new Error("_toTex not implemented for "+this.type)},f.prototype.getIdentifier=function(){return this.type},f.prototype.getContent=function(){return this},f}},function(e,t,r){"use strict";t.factory=function(e,t,r,n){var i=n("add",{"number, number":function(e,t){return e+t},"Complex, Complex":function(e,t){return e.add(t)},"BigNumber, BigNumber":function(e,t){return e.plus(t)},"Fraction, Fraction":function(e,t){return e.add(t)},"Unit, Unit":function(e,t){if(null==e.value)throw new Error("Parameter x contains a unit with undefined value");if(null==t.value)throw new Error("Parameter y contains a unit with undefined value");if(!e.equalBase(t))throw new Error("Units do not match");var r=e.clone();return r.value=i(r.value,t.value),r.fixPrefix=!1,r}});return i}},function(e,t,r){"use strict";var n=r(11);t.name="algorithm03",t.factory=function(e,t,r,i){var a=e.DenseMatrix;return function(e,t,r,o){var s=e._data,u=e._size,c=e._datatype,f=t._values,l=t._index,p=t._ptr,h=t._size,m=t._datatype;if(u.length!==h.length)throw new n(u.length,h.length);if(u[0]!==h[0]||u[1]!==h[1])throw new RangeError("Dimension mismatch. Matrix A ("+u+") must match Matrix B ("+h+")");if(!f)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");var d,g=u[0],v=u[1],y=0,x=r;"string"==typeof c&&c===m&&(d=c,y=i.convert(0,d),x=i.find(r,[d,d]));for(var w=[],b=0;b<g;b++)w[b]=[];for(var N=[],E=[],M=0;M<v;M++){for(var A=M+1,O=p[M],T=p[M+1],S=O;S<T;S++){var _=l[S];N[_]=o?x(f[S],s[_][M]):x(s[_][M],f[S]),E[_]=A}for(var C=0;C<g;C++)E[C]===A?w[C][M]=N[C]:w[C][M]=o?x(y,s[C][M]):x(s[C][M],y)}return new a({data:w,size:[g,v],datatype:d})}}},function(e,t,r){"use strict";t.name="algorithm12",t.factory=function(e,t,r,n){var i=e.DenseMatrix;return function(e,t,r,a){var o=e._values,s=e._index,u=e._ptr,c=e._size,f=e._datatype;if(!o)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var l,p=c[0],h=c[1],m=r;"string"==typeof f&&(l=f,t=n.convert(t,l),m=n.find(r,[l,l]));for(var d=[],g=new i({data:d,size:[p,h],datatype:l}),v=[],y=[],x=0;x<h;x++){for(var w=x+1,b=u[x],N=u[x+1],E=b;E<N;E++){var M=s[E];v[M]=o[E],y[M]=w}for(var A=0;A<p;A++)0===x&&(d[A]=[]),y[A]===w?d[A][x]=a?m(t,v[A]):m(v[A],t):d[A][x]=a?m(t,0):m(0,t)}return g}}},function(e,t,r){"use strict";t.name="algorithm11",t.factory=function(e,t,n,i){var a=n(r(10)),o=e.SparseMatrix;return function(e,t,r,n){var s=e._values,u=e._index,c=e._ptr,f=e._size,l=e._datatype;if(!s)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var p,h=f[0],m=f[1],d=a,g=0,v=r;"string"==typeof l&&(p=l,d=i.find(a,[p,p]),g=i.convert(0,p),t=i.convert(t,p),v=i.find(r,[p,p]));for(var y=[],x=[],w=[],b=new o({values:y,index:x,ptr:w,size:[h,m],datatype:p}),N=0;N<m;N++){w[N]=x.length;for(var E=c[N],M=c[N+1],A=E;A<M;A++){var O=u[A],T=n?v(t,s[A]):v(s[A],t);d(T,g)||(x.push(O),y.push(T))}}return w[m]=x.length,b}}},function(e,t,r){"use strict";var n=r(5).extend;t.name="add",t.factory=function(e,t,i,a){var o=i(r(0)),s=i(r(16)),u=r(4),c=i(r(33)),f=i(r(73)),l=i(r(38)),p=i(r(8)),h=i(r(6)),m=a("add",n({"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,s);break;default:r=c(t,e,s,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,s,!1);break;default:r=p(e,t,s)}}return r},"Array, Array":function(e,t){return m(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return m(o(e),t)},"Matrix, Array":function(e,t){return m(e,o(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,s,!1);break;default:r=h(e,t,s,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=l(t,e,s,!0);break;default:r=h(t,e,s,!0)}return r},"Array, any":function(e,t){return h(o(e),t,s,!1).valueOf()},"any, Array":function(e,t){return h(o(t),e,s,!0).valueOf()},"any, any":s,"Array | Matrix | any, Array | Matrix | any, ...any":function(e,t,r){for(var n=m(e,t),i=0;i<r.length;i++)n=m(n,r[i]);return n}},s.signatures));return m.toTex={2:"\\left(${args[0]}"+u.operators.add+"${args[1]}\\right)"},m}},function(e,t,r){"use strict";var n=r(11);t.name="subtract",t.factory=function(e,t,i,a){var o=r(4),s=i(r(0)),u=i(r(16)),c=i(r(35)),f=i(r(33)),l=i(r(17)),p=i(r(61)),h=i(r(38)),m=i(r(8)),d=i(r(6)),g=a("subtract",{"number, number":function(e,t){return e-t},"Complex, Complex":function(e,t){return e.sub(t)},"BigNumber, BigNumber":function(e,t){return e.minus(t)},"Fraction, Fraction":function(e,t){return e.sub(t)},"Unit, Unit":function(e,t){if(null==e.value)throw new Error("Parameter x contains a unit with undefined value");if(null==t.value)throw new Error("Parameter y contains a unit with undefined value");if(!e.equalBase(t))throw new Error("Units do not match");var r=e.clone();return r.value=g(r.value,t.value),r.fixPrefix=!1,r},"Matrix, Matrix":function(e,t){var r,i=e.size(),a=t.size();if(i.length!==a.length)throw new n(i.length,a.length);switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=p(e,t,g);break;default:r=l(t,e,g,!0)}break;default:switch(t.storage()){case"sparse":r=f(e,t,g,!1);break;default:r=m(e,t,g)}}return r},"Array, Array":function(e,t){return g(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return g(s(e),t)},"Matrix, Array":function(e,t){return g(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=h(e,c(t),u);break;default:r=d(e,t,g)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=h(t,e,g,!0);break;default:r=d(t,e,g,!0)}return r},"Array, any":function(e,t){return d(s(e),t,g,!1).valueOf()},"any, Array":function(e,t){return d(s(t),e,g,!0).valueOf()}});return g.toTex={2:"\\left(${args[0]}"+o.operators.subtract+"${args[1]}\\right)"},g}},function(e,t,r){"use strict";t.factory=function(e,t,r,n){var i=n("multiplyScalar",{"number, number":function(e,t){return e*t},"Complex, Complex":function(e,t){return e.mul(t)},"BigNumber, BigNumber":function(e,t){return e.times(t)},"Fraction, Fraction":function(e,t){return e.mul(t)},"number | Fraction | BigNumber | Complex, Unit":function(e,t){var r=t.clone();return r.value=null===r.value?r._normalize(e):i(r.value,e),r},"Unit, number | Fraction | BigNumber | Complex":function(e,t){var r=e.clone();return r.value=null===r.value?r._normalize(t):i(r.value,t),r},"Unit, Unit":function(e,t){return e.multiply(t)}});return i}},function(e,t,r){"use strict";var n=r(5).clone,i=r(2).validateIndex,a=r(13).getSafeProperty,o=r(13).setSafeProperty,s=r(11);function u(e,t){if(1!==t.size().length)throw new s(t.size(),1);var r=t.dimension(0);if("string"!=typeof r)throw new TypeError("String expected as index to retrieve an object property");return a(e,r)}function c(e,t,r){if(1!==t.size().length)throw new s(t.size(),1);var i=t.dimension(0);if("string"!=typeof i)throw new TypeError("String expected as index to retrieve an object property");var a=n(e);return o(a,i,r),a}t.name="subset",t.factory=function(e,t,a,o){var f=a(r(0)),l=o("subset",{"Array, Index":function(e,t){var r=f(e).subset(t);return t.isScalar()?r:r.valueOf()},"Matrix, Index":function(e,t){return e.subset(t)},"Object, Index":u,"string, Index":function(t,r){if(!e.isIndex(r))throw new TypeError("Index expected");if(1!=r.size().length)throw new s(r.size().length,1);var n=t.length;i(r.min()[0],n),i(r.max()[0],n);var a="";return r.dimension(0).forEach(function(e){a+=t.charAt(e)}),a},"Array, Index, any":function(e,t,r){return f(n(e)).subset(t,r,void 0).valueOf()},"Array, Index, any, any":function(e,t,r,i){return f(n(e)).subset(t,r,i).valueOf()},"Matrix, Index, any":function(e,t,r){return e.clone().subset(t,r)},"Matrix, Index, any, any":function(e,t,r,n){return e.clone().subset(t,r,n)},"string, Index, string":p,"string, Index, string, string":p,"Object, Index, any":c});return l.toTex=void 0,l;function p(e,t,r,n){if(!t||!0!==t.isIndex)throw new TypeError("Index expected");if(1!=t.size().length)throw new s(t.size().length,1);if(void 0!==n){if("string"!=typeof n||1!==n.length)throw new TypeError("Single character expected as defaultValue")}else n=" ";var a=t.dimension(0),o=a.size()[0];if(o!=r.length)throw new s(a.size()[0],r.length);var u=e.length;i(t.min()[0]),i(t.max()[0]);for(var c=[],f=0;f<u;f++)c[f]=e.charAt(f);if(a.forEach(function(e,t){c[e]=r.charAt(t[0])}),c.length>u)for(f=u-1,o=c.length;f<o;f++)c[f]||(c[f]=n);return c.join("")}}},function(e,t,r){"use strict";var n=r(11);t.name="algorithm02",t.factory=function(e,t,i,a){var o=i(r(10)),s=e.SparseMatrix;return function(e,t,r,i){var u=e._data,c=e._size,f=e._datatype,l=t._values,p=t._index,h=t._ptr,m=t._size,d=t._datatype;if(c.length!==m.length)throw new n(c.length,m.length);if(c[0]!==m[0]||c[1]!==m[1])throw new RangeError("Dimension mismatch. Matrix A ("+c+") must match Matrix B ("+m+")");if(!l)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");var g,v=c[0],y=c[1],x=o,w=0,b=r;"string"==typeof f&&f===d&&(g=f,x=a.find(o,[g,g]),w=a.convert(0,g),b=a.find(r,[g,g]));for(var N=[],E=[],M=[],A=0;A<y;A++){M[A]=E.length;for(var O=h[A],T=h[A+1],S=O;S<T;S++){var _=p[S],C=i?b(l[S],u[_][A]):b(u[_][A],l[S]);x(C,w)||(E.push(_),N.push(C))}}return M[y]=E.length,new s({values:N,index:E,ptr:M,size:[v,y],datatype:g})}}},function(e,t,r){"use strict";t.array=r(2),t.boolean=r(178),t.function=r(32),t.number=r(3),t.object=r(5),t.string=r(9),t.types=r(60),t.emitter=r(91)},function(e,t,r){"use strict";var n=r(11);t.name="algorithm07",t.factory=function(e,t,r,i){var a=e.DenseMatrix,o=function(e,t,r,n,i){for(var a=e._values,o=e._index,s=e._ptr,u=s[t],c=s[t+1];u<c;u++){var f=o[u];r[f]=i,n[f]=a[u]}};return function(e,t,r){var s=e._size,u=e._datatype,c=t._size,f=t._datatype;if(s.length!==c.length)throw new n(s.length,c.length);if(s[0]!==c[0]||s[1]!==c[1])throw new RangeError("Dimension mismatch. Matrix A ("+s+") must match Matrix B ("+c+")");var l,p,h,m=s[0],d=s[1],g=0,v=r;"string"==typeof u&&u===f&&(l=u,g=i.convert(0,l),v=i.find(r,[l,l]));var y=[];for(p=0;p<m;p++)y[p]=[];var x=new a({data:y,size:[m,d],datatype:l}),w=[],b=[],N=[],E=[];for(h=0;h<d;h++){var M=h+1;for(o(e,h,N,w,M),o(t,h,E,b,M),p=0;p<m;p++){var A=N[p]===M?w[p]:g,O=E[p]===M?b[p]:g;y[p][h]=v(A,O)}}return x}}},function(e,t,r){"use strict";var n=r(5).clone,i=r(3).isInteger;t.name="Index",t.path="type",t.factory=function(e){function t(n){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this._dimensions=[],this._isScalar=!0;for(var i=0,a=arguments.length;i<a;i++){var o=arguments[i];if(e.isRange(o))this._dimensions.push(o),this._isScalar=!1;else if(Array.isArray(o)||e.isMatrix(o)){var s=r(o.valueOf());this._dimensions.push(s);var u=s.size();1===u.length&&1===u[0]||(this._isScalar=!1)}else if("number"==typeof o)this._dimensions.push(r([o]));else{if("string"!=typeof o)throw new TypeError("Dimension must be an Array, Matrix, number, string, or Range");this._dimensions.push(o)}}}function r(t){for(var r=0,n=t.length;r<n;r++)if("number"!=typeof t[r]||!i(t[r]))throw new TypeError("Index parameters must be positive integer numbers");return new e.ImmutableDenseMatrix(t)}return t.prototype.type="Index",t.prototype.isIndex=!0,t.prototype.clone=function(){var e=new t;return e._dimensions=n(this._dimensions),e._isScalar=this._isScalar,e},t.create=function(e){var r=new t;return t.apply(r,e),r},t.prototype.size=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?1:n.size()[0]}return e},t.prototype.max=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?n:n.max()}return e},t.prototype.min=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?n:n.min()}return e},t.prototype.forEach=function(e){for(var t=0,r=this._dimensions.length;t<r;t++)e(this._dimensions[t],t,this)},t.prototype.dimension=function(e){return this._dimensions[e]||null},t.prototype.isObjectProperty=function(){return 1===this._dimensions.length&&"string"==typeof this._dimensions[0]},t.prototype.getObjectProperty=function(){return this.isObjectProperty()?this._dimensions[0]:null},t.prototype.isScalar=function(){return this._isScalar},t.prototype.toArray=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e.push("string"==typeof n?n:n.toArray())}return e},t.prototype.valueOf=t.prototype.toArray,t.prototype.toString=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];"string"==typeof n?e.push(JSON.stringify(n)):e.push(n.toString())}return"["+e.join(", ")+"]"},t.prototype.toJSON=function(){return{mathjs:"Index",dimensions:this._dimensions}},t.fromJSON=function(e){return t.create(e.dimensions)},t}},function(e,t,r){"use strict";var n=r(1);t.name="abs",t.factory=function(e,t,r,i){var a=i("abs",{number:Math.abs,Complex:function(e){return e.abs()},BigNumber:function(e){return e.abs()},Fraction:function(e){return e.abs()},"Array | Matrix":function(e){return n(e,a,!0)},Unit:function(e){return e.abs()}});return a.toTex={1:"\\left|${args[0]}\\right|"},a}},function(e,t,r){"use strict";var n=r(2);t.name="size",t.factory=function(e,t,i,a){var o=i(r(0)),s=a("size",{Matrix:function(e){return o(e.size())},Array:n.size,string:function(e){return"Array"===t.matrix?[e.length]:o([e.length])},"number | Complex | BigNumber | Unit | boolean | null":function(e){return"Array"===t.matrix?[]:o([])}});return s.toTex=void 0,s}},function(e,t,r){"use strict";t.name="equal",t.factory=function(e,t,n,i){var a=n(r(0)),o=n(r(10)),s=n(r(17)),u=n(r(26)),c=n(r(18)),f=n(r(8)),l=n(r(6)),p=r(4),h=i("equal",{"any, any":function(e,t){return null===e?null===t:null===t?null===e:void 0===e?void 0===t:void 0===t?void 0===e:o(e,t)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=u(e,t,o);break;default:r=s(t,e,o,!0)}break;default:switch(t.storage()){case"sparse":r=s(e,t,o,!1);break;default:r=f(e,t,o)}}return r},"Array, Array":function(e,t){return h(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return h(a(e),t)},"Matrix, Array":function(e,t){return h(e,a(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=c(e,t,o,!1);break;default:r=l(e,t,o,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=c(t,e,o,!0);break;default:r=l(t,e,o,!0)}return r},"Array, any":function(e,t){return l(a(e),t,o,!1).valueOf()},"any, Array":function(e,t){return l(a(t),e,o,!0).valueOf()}});return h.toTex={2:"\\left(${args[0]}"+p.operators.equal+"${args[1]}\\right)"},h}},function(e,t,r){"use strict";var n=r(486);t.name="compareNatural",t.factory=function(e,t,i,a){var o=i(r(76)),s=(i(r(0)),i(r(52))),u=s.signatures["boolean,boolean"],c=a("compareNatural",{"any, any":function(t,r){var i,a,l,p=o(t),h=o(r);if(!("number"!==p&&"BigNumber"!==p&&"Fraction"!==p||"number"!==h&&"BigNumber"!==h&&"Fraction"!==h))return"0"!==(i=s(t,r)).toString()?i>0?1:-1:n(p,h);if("Array"===p||"Matrix"===p||"Array"===h||"Matrix"===h)return 0!==(i=function t(r,n){return e.isSparseMatrix(r)&&e.isSparseMatrix(n)?f(r.toJSON().values,n.toJSON().values):e.isSparseMatrix(r)?t(r.toArray(),n):e.isSparseMatrix(n)?t(r,n.toArray()):e.isDenseMatrix(r)?t(r.toJSON().data,n):e.isDenseMatrix(n)?t(r,n.toJSON().data):Array.isArray(r)?Array.isArray(n)?f(r,n):t(r,[n]):t([r],n)}(t,r))?i:n(p,h);if(p!==h)return n(p,h);if("Complex"===p)return l=r,(a=t).re>l.re?1:a.re<l.re?-1:a.im>l.im?1:a.im<l.im?-1:0;if("Unit"===p)return t.equalBase(r)?c(t.value,r.value):f(t.formatUnits(),r.formatUnits());if("boolean"===p)return u(t,r);if("string"===p)return n(t,r);if("Object"===p)return function(e,t){var r=Object.keys(e),i=Object.keys(t);r.sort(n),i.sort(n);var a=f(r,i);if(0!==a)return a;for(var o=0;o<r.length;o++){var s=c(e[r[o]],t[i[o]]);if(0!==s)return s}return 0}(t,r);if("null"===p)return 0;if("undefined"===p)return 0;throw new TypeError('Unsupported type of value "'+p+'"')}});function f(e,t){for(var r=0,n=Math.min(e.length,t.length);r<n;r++){var i=c(e[r],t[r]);if(0!==i)return i}return e.length>t.length?1:e.length<t.length?-1:0}return c.toTex=void 0,c}},function(e,t){t.memoize=function(e,t){return function r(){"object"!=typeof r.cache&&(r.cache={});for(var n=[],i=0;i<arguments.length;i++)n[i]=arguments[i];var a=t?t(n):JSON.stringify(n);return a in r.cache?r.cache[a]:r.cache[a]=e.apply(e,n)}},t.maxArgumentCount=function(e){return Object.keys(e.signatures||{}).reduce(function(e,t){var r=(t.match(/,/g)||[]).length+1;return Math.max(e,r)},-1)},t.callWithRightArgumentCount=function(e,t,r){return Object.keys(e.signatures||{}).reduce(function(e,t){var r=(t.match(/,/g)||[]).length+1;return Math.max(e,r)},-1)}},function(e,t,r){"use strict";var n=r(11);t.name="algorithm01",t.factory=function(e,t,r,i){var a=e.DenseMatrix;return function(e,t,r,o){var s=e._data,u=e._size,c=e._datatype,f=t._values,l=t._index,p=t._ptr,h=t._size,m=t._datatype;if(u.length!==h.length)throw new n(u.length,h.length);if(u[0]!==h[0]||u[1]!==h[1])throw new RangeError("Dimension mismatch. Matrix A ("+u+") must match Matrix B ("+h+")");if(!f)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");var d,g,v=u[0],y=u[1],x="string"==typeof c&&c===m?c:void 0,w=x?i.find(r,[x,x]):r,b=[];for(d=0;d<v;d++)b[d]=[];var N=[],E=[];for(g=0;g<y;g++){for(var M=g+1,A=p[g],O=p[g+1],T=A;T<O;T++)N[d=l[T]]=o?w(f[T],s[d][g]):w(s[d][g],f[T]),E[d]=M;for(d=0;d<v;d++)E[d]===M?b[d][g]=N[d]:b[d][g]=s[d][g]}return new a({data:b,size:[v,y],datatype:x})}}},function(e,t,r){"use strict";var n=r(3).nearlyEqual,i=r(37);t.name="larger",t.factory=function(e,t,a,o){var s=a(r(0)),u=a(r(17)),c=a(r(26)),f=a(r(18)),l=a(r(8)),p=a(r(6)),h=r(4),m=o("larger",{"boolean, boolean":function(e,t){return e>t},"number, number":function(e,r){return e>r&&!n(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return e.gt(r)&&!i(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return 1===e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return m(e.value,t.value)},"string, string":function(e,t){return e>t},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,m);break;default:r=u(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,m,!1);break;default:r=l(e,t,m)}}return r},"Array, Array":function(e,t){return m(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return m(s(e),t)},"Matrix, Array":function(e,t){return m(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=p(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,m,!0);break;default:r=p(t,e,m,!0)}return r},"Array, any":function(e,t){return p(s(e),t,m,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+h.operators.larger+"${args[1]}\\right)"},m}},function(e,t,r){"use strict";var n=r(1);t.name="unaryMinus",t.factory=function(e,t,i,a){var o=r(4),s=a("unaryMinus",{number:function(e){return-e},Complex:function(e){return e.neg()},BigNumber:function(e){return e.neg()},Fraction:function(e){return e.neg()},Unit:function(e){var t=e.clone();return t.value=s(e.value),t},"Array | Matrix":function(e){return n(e,s,!0)}});return s.toTex={1:o.operators.unaryMinus+"\\left(${args[0]}\\right)"},s}},function(e,t,r){"use strict";var n=r(4),i=r(9).stringify,a=r(9).escape,o=r(5).hasOwnProperty,s=r(13).getSafeProperty;t.name="SymbolNode",t.path="expression.node",t.math=!0,t.factory=function(e,t,u,c,f){var l=u(r(7)).register,p=(u(r(7)).compile,u(r(15)));function h(t){return!!e.Unit&&e.Unit.isValuelessUnit(t)}function m(e){if(!(this instanceof m))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof e)throw new TypeError('String expected for parameter "name"');this.name=e}function d(e){throw new Error("Undefined symbol "+e)}return m.prototype=new p,m.prototype.type="SymbolNode",m.prototype.isSymbolNode=!0,l(m.prototype.type,function(t,r,n){if(!(t instanceof m))throw new TypeError("No valid SymbolNode");r.undef=d,r.Unit=e.Unit,r.getSafeProperty=s,r.hasOwnProperty=o;var a=i(t.name);return o(n,t.name)?n[t.name]:t.name in r.math?"("+a+" in scope ? getSafeProperty(scope, "+a+") : getSafeProperty(math, "+a+"))":"("+a+" in scope ? getSafeProperty(scope, "+a+") : "+(h(t.name)?"new Unit(null, "+a+")":"undef("+a+")")+")"}),m.prototype.forEach=function(e){},m.prototype.map=function(e){return this.clone()},m.prototype.clone=function(){return new m(this.name)},m.prototype._toString=function(e){return this.name},m.prototype.toHTML=function(e){var t=a(this.name);return"true"==t||"false"==t?'<span class="math-symbol math-boolean">'+t+"</span>":"i"==t?'<span class="math-symbol math-imaginary-symbol">'+t+"</span>":"Infinity"==t?'<span class="math-symbol math-infinity-symbol">'+t+"</span>":"NaN"==t?'<span class="math-symbol math-nan-symbol">'+t+"</span>":"null"==t?'<span class="math-symbol math-null-symbol">'+t+"</span>":"uninitialized"==t?'<span class="math-symbol math-uninitialized-symbol">'+t+"</span>":'<span class="math-symbol">'+t+"</span>"},m.prototype._toTex=function(e){var t=!1;void 0===f[this.name]&&h(this.name)&&(t=!0);var r=n.toSymbol(this.name,t);return"\\"===r[0]?r:" "+r},m}},function(e,t,r){"use strict";e.exports=function(e,t,r){if(null==r)return e.eq(t);if(e.eq(t))return!0;if(e.isNaN()||t.isNaN())return!1;if(e.isFinite()&&t.isFinite()){var n=e.minus(t).abs();if(n.isZero())return!0;var i=e.constructor.max(e.abs(),t.abs());return n.lte(i.times(r))}return!1}},function(e,t,r){"use strict";t.name="algorithm10",t.factory=function(e,t,r,n){var i=e.DenseMatrix;return function(e,t,r,a){var o=e._values,s=e._index,u=e._ptr,c=e._size,f=e._datatype;if(!o)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var l,p=c[0],h=c[1],m=r;"string"==typeof f&&(l=f,t=n.convert(t,l),m=n.find(r,[l,l]));for(var d=[],g=new i({data:d,size:[p,h],datatype:l}),v=[],y=[],x=0;x<h;x++){for(var w=x+1,b=u[x],N=u[x+1],E=b;E<N;E++){var M=s[E];v[M]=o[E],y[M]=w}for(var A=0;A<p;A++)0===x&&(d[A]=[]),y[A]===w?d[A][x]=a?m(t,v[A]):m(v[A],t):d[A][x]=t}return g}}},function(e,t,r){"use strict";var n=r(3).nearlyEqual,i=r(37);t.name="smaller",t.factory=function(e,t,a,o){var s=a(r(0)),u=a(r(17)),c=a(r(26)),f=a(r(18)),l=a(r(8)),p=a(r(6)),h=r(4),m=o("smaller",{"boolean, boolean":function(e,t){return e<t},"number, number":function(e,r){return e<r&&!n(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return e.lt(r)&&!i(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return-1===e.compare(t)},"Complex, Complex":function(e,t){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return m(e.value,t.value)},"string, string":function(e,t){return e<t},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,m);break;default:r=u(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,m,!1);break;default:r=l(e,t,m)}}return r},"Array, Array":function(e,t){return m(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return m(s(e),t)},"Matrix, Array":function(e,t){return m(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=p(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,m,!0);break;default:r=p(t,e,m,!0)}return r},"Array, any":function(e,t){return p(s(e),t,m,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+h.operators.smaller+"${args[1]}\\right)"},m}},function(e,t,r){"use strict";var n=r(3).isInteger,i=r(2).resize;t.name="zeros",t.factory=function(e,t,a,o){var s=a(r(0)),u=o("zeros",{"":function(){return"Array"===t.matrix?c([]):c([],"default")},"...number | BigNumber | string":function(e){return"string"==typeof e[e.length-1]?c(e,e.pop()):"Array"===t.matrix?c(e):c(e,"default")},Array:c,Matrix:function(e){var t=e.storage();return c(e.valueOf(),t)},"Array | Matrix, string":function(e,t){return c(e.valueOf(),t)}});return u.toTex=void 0,u;function c(t,r){var a,o=(a=!1,t.forEach(function(t,r,n){e.isBigNumber(t)&&(a=!0,n[r]=t.toNumber())}),a?new e.BigNumber(0):0);if(t.forEach(function(e){if("number"!=typeof e||!n(e)||e<0)throw new Error("Parameters in function zeros must be positive integers")}),r){var u=s(r);return t.length>0?u.resize(t,o):u}var c=[];return t.length>0?i(c,t,o):c}}},function(e,t,r){"use strict";var n=r(44),i=r(1);t.name="parse",t.path="expression",t.factory=function(e,t,a,o){var s=a(r(103)),u=a(r(80)),c=a(r(105)),f=a(r(106)),l=a(r(107)),p=a(r(47)),h=a(r(108)),m=a(r(78)),d=a(r(110)),g=a(r(55)),v=a(r(63)),y=a(r(56)),x=a(r(79)),w=a(r(36));function b(t,r){if(1!=arguments.length&&2!=arguments.length)throw new n("parse",arguments.length,1,2);if(A=r&&r.nodes?r.nodes:{},"string"==typeof t)return O=t,F();if(Array.isArray(t)||t instanceof e.Matrix)return i(t,function(e){if("string"!=typeof e)throw new TypeError("String expected");return O=e,F()});throw new TypeError("String or matrix expected")}var N={NULL:0,DELIMITER:1,NUMBER:2,SYMBOL:3,UNKNOWN:4},E={",":!0,"(":!0,")":!0,"[":!0,"]":!0,"{":!0,"}":!0,'"':!0,";":!0,"+":!0,"-":!0,"*":!0,".*":!0,"/":!0,"./":!0,"%":!0,"^":!0,".^":!0,"~":!0,"!":!0,"&":!0,"|":!0,"^|":!0,"'":!0,"=":!0,":":!0,"?":!0,"==":!0,"!=":!0,"<":!0,">":!0,"<=":!0,">=":!0,"<<":!0,">>":!0,">>>":!0},M={mod:!0,to:!0,in:!0,and:!0,xor:!0,or:!0,not:!0},A={},O="",T="",S=0,_="",C="",z=N.NULL,k=0,B=null;function I(){S++,_=O.charAt(S)}function P(){return O.charAt(S-1)}function R(){return O.charAt(S+1)}function U(){for(z=N.NULL,C="",T="";b.isWhitespace(_,k);)I();if("#"==_)for(;"\n"!=_&&""!=_;)T+=_,I();if(""!=_){if("\n"==_&&!k)return z=N.DELIMITER,C=_,void I();var e=_+R(),t=e+O.charAt(S+2);if(3==t.length&&E[t])return z=N.DELIMITER,C=t,I(),I(),void I();if(2==e.length&&E[e])return z=N.DELIMITER,C=e,I(),void I();if(E[_])return z=N.DELIMITER,C=_,void I();if(b.isDigitDot(_)){if(z=N.NUMBER,"."==_)C+=_,I(),b.isDigit(_)||(z=N.DELIMITER);else{for(;b.isDigit(_);)C+=_,I();b.isDecimalMark(_,R())&&(C+=_,I())}for(;b.isDigit(_);)C+=_,I();if(e=R(),"E"==_||"e"==_)if(b.isDigit(e)||"-"==e||"+"==e){if(C+=_,I(),"+"!=_&&"-"!=_||(C+=_,I()),!b.isDigit(_))throw ae('Digit expected, got "'+_+'"');for(;b.isDigit(_);)C+=_,I();if(b.isDecimalMark(_,R()))throw ae('Digit expected, got "'+_+'"')}else if("."==e)throw I(),ae('Digit expected, got "'+_+'"')}else{if(!b.isAlpha(_,P(),R())){for(z=N.UNKNOWN;""!=_;)C+=_,I();throw ae('Syntax error in part "'+C+'"')}for(;b.isAlpha(_,P(),R())||b.isDigit(_);)C+=_,I();z=M.hasOwnProperty(C)?N.DELIMITER:N.SYMBOL}}else z=N.DELIMITER}function q(){do{U()}while("\n"==C)}function L(){k++}function j(){k--}function F(){S=0,_=O.charAt(0),k=0,B=null,U();var e=function(){var e,t,r=[];for(""!=C&&"\n"!=C&&";"!=C&&((e=D()).comment=T);"\n"==C||";"==C;)0==r.length&&e&&(t=";"!=C,r.push({node:e,visible:t})),U(),"\n"!=C&&";"!=C&&""!=C&&((e=D()).comment=T,t=";"!=C,r.push({node:e,visible:t}));return r.length>0?new f(r):(e||((e=new p("undefined","undefined")).comment=T),e)}();if(""!=C)throw z==N.DELIMITER?oe("Unexpected operator "+C):ae('Unexpected part "'+C+'"');return e}function D(){var t,r,n,i,a=function(){for(var e=function(){for(var e=H();"or"==C;)q(),e=new g("or","or",[e,H()]);return e}();"?"==C;){var t=B;B=k,q();var r=e,n=D();if(":"!=C)throw ae("False part of conditional expression expected");B=null,q();var i=D();e=new l(r,n,i),B=t}return e}();if("="==C){if(e.isSymbolNode(a))return t=a.name,q(),n=D(),new c(new w(t),n);if(e.isAccessorNode(a))return q(),n=D(),new c(a.object,a.index,n);if(e.isFunctionNode(a)&&e.isSymbolNode(a.fn)&&(i=!0,r=[],t=a.name,a.args.forEach(function(t,n){e.isSymbolNode(t)?r[n]=t.name:i=!1}),i))return q(),n=D(),new h(t,r,n);throw ae("Invalid left hand side of assignment operator =")}return a}function H(){for(var e=$();"xor"==C;)q(),e=new g("xor","xor",[e,$()]);return e}function $(){for(var e=G();"and"==C;)q(),e=new g("and","and",[e,G()]);return e}function G(){for(var e=Z();"|"==C;)q(),e=new g("|","bitOr",[e,Z()]);return e}function Z(){for(var e=V();"^|"==C;)q(),e=new g("^|","bitXor",[e,V()]);return e}function V(){for(var e=W();"&"==C;)q(),e=new g("&","bitAnd",[e,W()]);return e}function W(){var e,t,r,n,i;for(e=Y(),t={"==":"equal","!=":"unequal","<":"smaller",">":"larger","<=":"smallerEq",">=":"largerEq"};t.hasOwnProperty(C);)n=t[r=C],q(),i=[e,Y()],e=new g(r,n,i);return e}function Y(){var e,t,r,n,i;for(e=X(),t={"<<":"leftShift",">>":"rightArithShift",">>>":"rightLogShift"};t.hasOwnProperty(C);)n=t[r=C],q(),i=[e,X()],e=new g(r,n,i);return e}function X(){var e,t,r,n,i;for(e=J(),t={to:"to",in:"to"};t.hasOwnProperty(C);)n=t[r=C],q(),"in"===r&&""===C?e=new g("*","multiply",[e,new w("in")],!0):(i=[e,J()],e=new g(r,n,i));return e}function J(){var e,t=[];if(e=":"==C?new p("1","number"):Q(),":"==C&&B!==k){for(t.push(e);":"==C&&t.length<3;)q(),")"==C||"]"==C||","==C||""==C?t.push(new w("end")):t.push(Q());e=3==t.length?new x(t[0],t[2],t[1]):new x(t[0],t[1])}return e}function Q(){var e,t,r,n,i;for(e=K(),t={"+":"add","-":"subtract"};t.hasOwnProperty(C);)n=t[r=C],q(),i=[e,K()],e=new g(r,n,i);return e}function K(){var t,r,n,i,a;for(r=t=ee(),n={"*":"multiply",".*":"dotMultiply","/":"divide","./":"dotDivide","%":"mod",mod:"mod"};;)if(n.hasOwnProperty(C))a=n[i=C],q(),r=ee(),t=new g(i,a,[t,r]);else{if(!(z===N.SYMBOL||"in"===C&&e.isConstantNode(t))&&(z!==N.NUMBER||e.isConstantNode(r)||e.isOperatorNode(r)&&"!"!==r.op)&&"("!==C)break;r=ee(),t=new g("*","multiply",[t,r],!0)}return t}function ee(){var e,t,r,n,i,a,o,s={"-":"unaryMinus","+":"unaryPlus","~":"bitNot",not:"not"};return s.hasOwnProperty(C)?(r=s[C],e=C,q(),t=[ee()],new g(e,r,t)):(n=function(){var e,t,r,n;for(e=function(){var e,t,r=[];if(z==N.SYMBOL&&A.hasOwnProperty(C)){var n=A[C];if(U(),"("==C){if(r=[],L(),U(),")"!=C)for(r.push(D());","==C;)U(),r.push(D());if(")"!=C)throw ae("Parenthesis ) expected");j(),U()}return new n(r)}return z==N.SYMBOL||z==N.DELIMITER&&C in M?(e=C,U(),te(new w(e))):'"'==C?(t=re(),te(new p(t,"string"))):function(){var e,t,r,n;if("["==C){if(L(),U(),"]"!=C){var i=ne();if(";"==C){for(r=1,t=[i];";"==C;)U(),t[r]=ne(),r++;if("]"!=C)throw ae("End of matrix ] expected");j(),U(),n=t[0].items.length;for(var a=1;a<r;a++)if(t[a].items.length!=n)throw oe("Column dimensions mismatch ("+t[a].items.length+" != "+n+")");e=new u(t)}else{if("]"!=C)throw ae("End of matrix ] expected");j(),U(),e=i}}else j(),U(),e=new u([]);return te(e)}return function(){if("{"==C){var e,t={};do{if(U(),"}"!=C){if('"'==C)e=re();else{if(z!=N.SYMBOL)throw ae("Symbol or string expected as object key");e=C,U()}if(":"!=C)throw ae("Colon : expected after object key");U(),t[e]=D()}}while(","==C);if("}"!=C)throw ae("Comma , or bracket } expected after object value");U();var r=new d(t);return r=te(r)}return z==N.NUMBER?(n=C,U(),new p(n,"number")):function(){var e;if("("==C){if(L(),U(),e=D(),")"!=C)throw ae("Parenthesis ) expected");return j(),U(),e=te(e=new v(e))}return function(){throw ae(""==C?"Unexpected end of expression":"'"===C?"Value expected. Note: strings must be enclosed by double quotes":"Value expected")}()}();var n}()}()}(),t={"!":"factorial","'":"transpose"};t.hasOwnProperty(C);)n=t[r=C],U(),e=te(e=new g(r,n,[e]));return e}(),("^"==C||".^"==C)&&(a="^"==(i=C)?"pow":"dotPow",q(),o=[n,ee()],n=new g(i,a,o)),n)}function te(t,r){for(var n;!("("!==C&&"["!==C&&"."!==C||r&&-1===r.indexOf(C));)if(n=[],"("===C){if(!(e.isSymbolNode(t)||e.isAccessorNode(t)||e.isFunctionNode(t)))return t;if(L(),U(),")"!==C)for(n.push(D());","===C;)U(),n.push(D());if(")"!==C)throw ae("Parenthesis ) expected");j(),U(),t=new y(t,n)}else if("["===C){if(L(),U(),"]"!==C)for(n.push(D());","===C;)U(),n.push(D());if("]"!==C)throw ae("Parenthesis ] expected");j(),U(),t=new s(t,new m(n))}else{if(U(),z!==N.SYMBOL)throw ae("Property name expected after dot");n.push(new p(C)),U(),t=new s(t,new m(n,!0))}return t}function re(){for(var e="";""!=_&&'"'!=_;)"\\"==_&&(e+=_,I()),e+=_,I();if(U(),'"'!=C)throw ae('End of string " expected');return U(),e}function ne(){for(var e=[D()],t=1;","==C;)U(),e[t]=D(),t++;return new u(e)}function ie(){return S-C.length+1}function ae(e){var t=ie(),r=new SyntaxError(e+" (char "+t+")");return r.char=t,r}function oe(e){var t=ie(),r=new SyntaxError(e+" (char "+t+")");return r.char=t,r}return b.isAlpha=function(e,t,r){return b.isValidLatinOrGreek(e)||b.isValidMathSymbol(e,r)||b.isValidMathSymbol(t,e)},b.isValidLatinOrGreek=function(e){return/^[a-zA-Z_$\u00C0-\u02AF\u0370-\u03FF\u2100-\u214F]$/.test(e)},b.isValidMathSymbol=function(e,t){return/^[\uD835]$/.test(e)&&/^[\uDC00-\uDFFF]$/.test(t)&&/^[^\uDC55\uDC9D\uDCA0\uDCA1\uDCA3\uDCA4\uDCA7\uDCA8\uDCAD\uDCBA\uDCBC\uDCC4\uDD06\uDD0B\uDD0C\uDD15\uDD1D\uDD3A\uDD3F\uDD45\uDD47-\uDD49\uDD51\uDEA6\uDEA7\uDFCC\uDFCD]$/.test(t)},b.isWhitespace=function(e,t){return" "==e||"\t"==e||"\n"==e&&t>0},b.isDecimalMark=function(e,t){return"."==e&&"/"!==t&&"*"!==t&&"^"!==t},b.isDigitDot=function(e){return e>="0"&&e<="9"||"."==e},b.isDigit=function(e){return e>="0"&&e<="9"},b}},function(e,t,r){var n=r(53);t.transform=function(e){return e&&e.isIndexError?new n(e.index+1,e.min+1,void 0!==e.max?e.max+1:void 0):e}},function(e,t,r){"use strict";var n=r(59);e.exports=function e(t,r){n(t)&&(t=t.valueOf());for(var i=0,a=t.length;i<a;i++){var o=t[i];Array.isArray(o)?e(o,r):r(o)}}},function(e,t,r){"use strict";function n(e,t,r,i){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.fn=e,this.count=t,this.min=r,this.max=i,this.message="Wrong number of arguments in function "+e+" ("+t+" provided, "+r+(void 0!=i?"-"+i:"")+" expected)",this.stack=(new Error).stack}n.prototype=new Error,n.prototype.constructor=Error,n.prototype.name="ArgumentsError",n.prototype.isArgumentsError=!0,e.exports=n},function(e,t,r){"use strict";var n=r(25),i=r(11),a=(r(13).getSafeProperty,r(13).setSafeProperty,n.string),o=n.array,s=n.object,u=n.number,c=Array.isArray,f=u.isNumber,l=u.isInteger,p=a.isString,h=o.validateIndex;t.name="DenseMatrix",t.path="type",t.factory=function(e,t,u,m){var d=u(r(72));function g(t,r){if(!(this instanceof g))throw new SyntaxError("Constructor must be called with the new operator");if(r&&!p(r))throw new Error("Invalid datatype: "+r);if(e.isMatrix(t))"DenseMatrix"===t.type?(this._data=s.clone(t._data),this._size=s.clone(t._size),this._datatype=r||t._datatype):(this._data=t.toArray(),this._size=t.size(),this._datatype=r||t._datatype);else if(t&&c(t.data)&&c(t.size))this._data=t.data,this._size=t.size,this._datatype=r||t.datatype;else if(c(t))this._data=function e(t){for(var r=0,n=t.length;r<n;r++){var i=t[r];c(i)?t[r]=e(i):i&&!0===i.isMatrix&&(t[r]=e(i.valueOf()))}return t}(t),this._size=o.size(this._data),o.validate(this._data,this._size),this._datatype=r;else{if(t)throw new TypeError("Unsupported type of data ("+n.types.type(t)+")");this._data=[],this._size=[0],this._datatype=r}}g.prototype=new d,g.prototype.type="DenseMatrix",g.prototype.isDenseMatrix=!0,g.prototype.storage=function(){return"dense"},g.prototype.datatype=function(){return this._datatype},g.prototype.create=function(e,t){return new g(e,t)},g.prototype.subset=function(t,r,n){switch(arguments.length){case 1:return function(t,r){if(!e.isIndex(r))throw new TypeError("Invalid index");if(r.isScalar())return t.get(r.min());var n=r.size();if(n.length!=t._size.length)throw new i(n.length,t._size.length);for(var a=r.min(),o=r.max(),s=0,u=t._size.length;s<u;s++)h(a[s],t._size[s]),h(o[s],t._size[s]);return new g(function e(t,r,n,i){var a=i===n-1,o=r.dimension(i);return a?o.map(function(e){return h(e,t.length),t[e]}).valueOf():o.map(function(a){h(a,t.length);var o=t[a];return e(o,r,n,i+1)}).valueOf()}(t._data,r,n.length,0),t._datatype)}(this,t);case 2:case 3:return function(t,r,n,a){if(!r||!0!==r.isIndex)throw new TypeError("Invalid index");var u,c=r.size(),f=r.isScalar();if(e.isMatrix(n)?(u=n.size(),n=n.valueOf()):u=o.size(n),f){if(0!==u.length)throw new TypeError("Scalar expected");t.set(r.min(),n,a)}else{if(c.length<t._size.length)throw new i(c.length,t._size.length,"<");if(u.length<c.length){for(var l=0,p=0;1===c[l]&&1===u[l];)l++;for(;1===c[l];)p++,l++;n=o.unsqueeze(n,c.length,p,u)}if(!s.deepEqual(c,u))throw new i(c,u,">");var m=r.max().map(function(e){return e+1});y(t,m,a);var d=c.length;!function e(t,r,n,i,a){var o=a===i-1,s=r.dimension(a);o?s.forEach(function(e,r){h(e),t[e]=n[r[0]]}):s.forEach(function(o,s){h(o),e(t[o],r,n[s[0]],i,a+1)})}(t._data,r,n,d,0)}return t}(this,t,r,n);default:throw new SyntaxError("Wrong number of arguments")}},g.prototype.get=function(e){if(!c(e))throw new TypeError("Array expected");if(e.length!=this._size.length)throw new i(e.length,this._size.length);for(var t=0;t<e.length;t++)h(e[t],this._size[t]);for(var r=this._data,n=0,a=e.length;n<a;n++){var o=e[n];h(o,r.length),r=r[o]}return r},g.prototype.set=function(e,t,r){if(!c(e))throw new TypeError("Array expected");if(e.length<this._size.length)throw new i(e.length,this._size.length,"<");var n,a,o;y(this,e.map(function(e){return e+1}),r);var s=this._data;for(n=0,a=e.length-1;n<a;n++)o=e[n],h(o,s.length),s=s[o];return o=e[e.length-1],h(o,s.length),s[o]=t,this},g.prototype.resize=function(e,t,r){if(!c(e))throw new TypeError("Array expected");var n=r?this.clone():this;return v(n,e,t)};var v=function(e,t,r){if(0===t.length){for(var n=e._data;c(n);)n=n[0];return n}return e._size=t.slice(0),e._data=o.resize(e._data,e._size,r),e};function y(e,t,r){for(var n=e._size.slice(0),i=!1;n.length<t.length;)n.push(0),i=!0;for(var a=0,o=t.length;a<o;a++)t[a]>n[a]&&(n[a]=t[a],i=!0);i&&v(e,n,r)}return g.prototype.reshape=function(e,t){var r=t?this.clone():this;return r._data=o.reshape(r._data,e),r._size=e.slice(0),r},g.prototype.clone=function(){return new g({data:s.clone(this._data),size:s.clone(this._size),datatype:this._datatype})},g.prototype.size=function(){return this._size.slice(0)},g.prototype.map=function(e){var t=this,r=function(n,i){return c(n)?n.map(function(e,t){return r(e,i.concat(t))}):e(n,i,t)};return new g({data:r(this._data,[]),size:s.clone(this._size),datatype:this._datatype})},g.prototype.forEach=function(e){var t=this,r=function(n,i){c(n)?n.forEach(function(e,t){r(e,i.concat(t))}):e(n,i,t)};r(this._data,[])},g.prototype.toArray=function(){return s.clone(this._data)},g.prototype.valueOf=function(){return this._data},g.prototype.format=function(e){return a.format(this._data,e)},g.prototype.toString=function(){return a.format(this._data)},g.prototype.toJSON=function(){return{mathjs:"DenseMatrix",data:this._data,size:this._size,datatype:this._datatype}},g.prototype.diagonal=function(t){if(t){if(e.isBigNumber(t)&&(t=t.toNumber()),!f(t)||!l(t))throw new TypeError("The parameter k must be an integer number")}else t=0;for(var r=t>0?t:0,n=t<0?-t:0,i=this._size[0],a=this._size[1],o=Math.min(i-n,a-r),s=[],u=0;u<o;u++)s[u]=this._data[u+n][u+r];return new g({data:s,size:[o],datatype:this._datatype})},g.diagonal=function(t,r,n,i,a){if(!c(t))throw new TypeError("Array expected, size parameter");if(2!==t.length)throw new Error("Only two dimensions matrix are supported");if(t=t.map(function(t){if(e.isBigNumber(t)&&(t=t.toNumber()),!f(t)||!l(t)||t<1)throw new Error("Size values must be positive integers");return t}),n){if(e.isBigNumber(n)&&(n=n.toNumber()),!f(n)||!l(n))throw new TypeError("The parameter k must be an integer number")}else n=0;i&&p(a)&&(i=m.convert(i,a));var s,u=n>0?n:0,h=n<0?-n:0,d=t[0],v=t[1],y=Math.min(d-h,v-u);if(c(r)){if(r.length!==y)throw new Error("Invalid value array length");s=function(e){return r[e]}}else if(e.isMatrix(r)){var x=r.size();if(1!==x.length||x[0]!==y)throw new Error("Invalid matrix length");s=function(e){return r.get([e])}}else s=function(){return r};i||(i=e.isBigNumber(s(0))?new e.BigNumber(0):0);var w=[];if(t.length>0){w=o.resize(w,t,i);for(var b=0;b<y;b++)w[b+h][b+u]=s(b)}return new g({data:w,size:[d,v]})},g.fromJSON=function(e){return new g(e)},g.prototype.swapRows=function(e,t){if(!(f(e)&&l(e)&&f(t)&&l(t)))throw new Error("Row index must be positive integers");if(2!==this._size.length)throw new Error("Only two dimensional matrix is supported");return h(e,this._size[0]),h(t,this._size[0]),g._swapRows(e,t,this._data),this},g._swapRows=function(e,t,r){var n=r[e];r[e]=r[t],r[t]=n},e.Matrix._storage.dense=g,e.Matrix._storage.default=g,g},t.lazy=!1},function(e,t,r){"use strict";var n=r(3).isInteger,i=r(2).size;t.name="pow",t.factory=function(e,t,a,o){var s=r(4),u=a(r(62)),c=a(r(12)),f=a(r(0)),l=a(r(93)),p=a(r(74)),h=o("pow",{"number, number":m,"Complex, Complex":function(e,t){return e.pow(t)},"BigNumber, BigNumber":function(r,n){return n.isInteger()||r>=0||t.predictable?r.pow(n):new e.Complex(r.toNumber(),0).pow(n.toNumber(),0)},"Fraction, Fraction":function(e,r){if(1!==r.d){if(t.predictable)throw new Error("Function pow does not support non-integer exponents for fractions.");return m(e.valueOf(),r.valueOf())}return e.pow(r)},"Array, number":d,"Array, BigNumber":function(e,t){return d(e,t.toNumber())},"Matrix, number":g,"Matrix, BigNumber":function(e,t){return g(e,t.toNumber())},"Unit, number":function(e,t){return e.pow(t)}});function m(r,i){if(t.predictable&&!n(i)&&r<0)try{var a=l(i),o=p(a);if((i===o||Math.abs((i-o)/i)<1e-14)&&a.d%2==1)return(a.n%2==0?1:-1)*Math.pow(-r,i)}catch(e){}return r*r<1&&i===1/0||r*r>1&&i===-1/0?0:t.predictable&&(r<-1&&i===1/0||r>-1&&r<0&&i===-1/0)?NaN:n(i)||r>=0||t.predictable?Math.pow(r,i):new e.Complex(r,0).pow(i,0)}function d(e,t){if(!n(t)||t<0)throw new TypeError("For A^b, b must be a positive integer (value is "+t+")");var r=i(e);if(2!=r.length)throw new Error("For A^b, A must be 2 dimensional (A has "+r.length+" dimensions)");if(r[0]!=r[1])throw new Error("For A^b, A must be square (size is "+r[0]+"x"+r[1]+")");for(var a=u(r[0]).valueOf(),o=e;t>=1;)1==(1&t)&&(a=c(o,a)),t>>=1,o=c(o,o);return a}function g(e,t){return f(d(e.valueOf(),t))}return h.toTex={2:"\\left(${args[0]}\\right)"+s.operators.pow+"{${args[1]}}"},h}},function(e,t,r){"use strict";var n=r(60).type,i=r(9).stringify,a=r(9).escape,o=r(4).escape;t.name="ConstantNode",t.path="expression.node",t.factory=function(e,t,s,u){var c=s(r(7)).register,f=(s(r(7)).compile,s(r(15)));function l(e,t){if(!(this instanceof l))throw new SyntaxError("Constructor must be called with the new operator");if(t){if("string"!=typeof t)throw new TypeError('String expected for parameter "valueType"');if("string"!=typeof e)throw new TypeError('String expected for parameter "value"');this.value=e,this.valueType=t}else this.value=e+"",this.valueType=n(e);if(!p[this.valueType])throw new TypeError('Unsupported type of value "'+this.valueType+'"')}var p={number:!0,string:!0,boolean:!0,undefined:!0,null:!0};return l.prototype=new f,l.prototype.type="ConstantNode",l.prototype.isConstantNode=!0,c(l.prototype.type,function(e,r,n){if(!(e instanceof l))throw new TypeError("No valid ConstantNode");switch(e.valueType){case"number":return"BigNumber"===t.number?"math.bignumber("+i(e.value)+")":"Fraction"===t.number?"math.fraction("+i(e.value)+")":(function(e){if("string"!=typeof e||!/^[\-+]?((\d+\.?\d*)|(\d*\.?\d+))([eE][+\-]?\d+)?$/.test(e))throw new Error('Invalid numeric value "'+e+'"')}(e.value),e.value.replace(/^(0*)[0-9]/,function(e,t){return e.substring(t.length)}));case"string":return i(e.value);case"boolean":return"true"===String(e.value)?"true":"false";case"undefined":return"undefined";case"null":return"null";default:throw new TypeError('Unsupported type of constant "'+e.valueType+'"')}}),l.prototype.forEach=function(e){},l.prototype.map=function(e){return this.clone()},l.prototype.clone=function(){return new l(this.value,this.valueType)},l.prototype._toString=function(e){switch(this.valueType){case"string":return i(this.value);default:return this.value}},l.prototype.toHTML=function(e){var t=a(this.value);switch(this.valueType){case"number":return'<span class="math-number">'+t+"</span>";case"string":return'<span class="math-string">'+t+"</span>";case"boolean":return'<span class="math-boolean">'+t+"</span>";case"null":return'<span class="math-null-symbol">'+t+"</span>";case"undefined":return'<span class="math-undefined">'+t+"</span>";default:return'<span class="math-symbol">'+t+"</span>"}},l.prototype._toTex=function(e){var t,r=this.value;switch(this.valueType){case"string":return"\\mathtt{"+o(i(r))+"}";case"number":return-1!==(t=r.toLowerCase().indexOf("e"))?r.substring(0,t)+"\\cdot10^{"+r.substring(t+1)+"}":r;default:return r}},l}},function(e,t,r){"use strict";var n=r(59);e.exports=function(e){return Array.isArray(e)||n(e)}},function(e,t,r){"use strict";var n=r(5).extend;t.name="divide",t.factory=function(e,t,i,a){var o=i(r(14)),s=i(r(12)),u=i(r(116)),c=i(r(0)),f=i(r(19)),l=i(r(6)),p=a("divide",n({"Array | Matrix, Array | Matrix":function(e,t){return s(e,u(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,o,!1);break;case"dense":r=l(e,t,o,!1)}return r},"Array, any":function(e,t){return l(c(e),t,o,!1).valueOf()},"any, Array | Matrix":function(e,t){return s(e,u(t))}},o.signatures));return p.toTex={2:"\\frac{${args[0]}}{${args[1]}}"},p}},function(e,t,r){"use strict";var n=r(1);t.name="sqrt",t.factory=function(e,t,r,i){var a=i("sqrt",{number:o,Complex:function(e){return e.sqrt()},BigNumber:function(e){return!e.isNegative()||t.predictable?e.sqrt():o(e.toNumber())},"Array | Matrix":function(e){return n(e,a,!0)},Unit:function(e){return e.pow(.5)}});function o(r){return r>=0||t.predictable?Math.sqrt(r):new e.Complex(r,0).sqrt()}return a.toTex={1:"\\sqrt{${args[0]}}"},a}},function(e,t,r){"use strict";var n=r(1),i=r(3);t.name="isInteger",t.factory=function(e,t,r,a){var o=a("isInteger",{number:i.isInteger,BigNumber:function(e){return e.isInt()},Fraction:function(e){return 1===e.d&&isFinite(e.n)},"Array | Matrix":function(e){return n(e,o)}});return o}},function(e,t,r){"use strict";var n=r(3).nearlyEqual,i=r(37);t.name="compare",t.factory=function(e,t,a,o){var s=a(r(0)),u=a(r(17)),c=a(r(61)),f=a(r(18)),l=a(r(8)),p=a(r(6)),h=o("compare",{"boolean, boolean":function(e,t){return e===t?0:e>t?1:-1},"number, number":function(e,r){return e===r||n(e,r,t.epsilon)?0:e>r?1:-1},"BigNumber, BigNumber":function(r,n){return r.eq(n)||i(r,n,t.epsilon)?new e.BigNumber(0):new e.BigNumber(r.cmp(n))},"Fraction, Fraction":function(t,r){return new e.Fraction(t.compare(r))},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return h(e.value,t.value)},"string, string":function(e,t){return e===t?0:e>t?1:-1},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,h);break;default:r=u(t,e,h,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,h,!1);break;default:r=l(e,t,h)}}return r},"Array, Array":function(e,t){return h(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return h(s(e),t)},"Matrix, Array":function(e,t){return h(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,h,!1);break;default:r=p(e,t,h,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,h,!0);break;default:r=p(t,e,h,!0)}return r},"Array, any":function(e,t){return p(s(e),t,h,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,h,!0).valueOf()}});return h.toTex=void 0,h}},function(e,t,r){"use strict";function n(e,t,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.index=e,arguments.length<3?(this.min=0,this.max=t):(this.min=t,this.max=r),void 0!==this.min&&this.index<this.min?this.message="Index out of range ("+this.index+" < "+this.min+")":void 0!==this.max&&this.index>=this.max?this.message="Index out of range ("+this.index+" > "+(this.max-1)+")":this.message="Index out of range ("+this.index+")",this.stack=(new Error).stack}n.prototype=new RangeError,n.prototype.constructor=RangeError,n.prototype.name="IndexError",n.prototype.isIndexError=!0,e.exports=n},function(e,t,r){"use strict";var n=[{AssignmentNode:{},FunctionAssignmentNode:{}},{ConditionalNode:{latexLeftParens:!1,latexRightParens:!1,latexParens:!1}},{"OperatorNode:or":{associativity:"left",associativeWith:[]}},{"OperatorNode:xor":{associativity:"left",associativeWith:[]}},{"OperatorNode:and":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitOr":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitXor":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitAnd":{associativity:"left",associativeWith:[]}},{"OperatorNode:equal":{associativity:"left",associativeWith:[]},"OperatorNode:unequal":{associativity:"left",associativeWith:[]},"OperatorNode:smaller":{associativity:"left",associativeWith:[]},"OperatorNode:larger":{associativity:"left",associativeWith:[]},"OperatorNode:smallerEq":{associativity:"left",associativeWith:[]},"OperatorNode:largerEq":{associativity:"left",associativeWith:[]}},{"OperatorNode:leftShift":{associativity:"left",associativeWith:[]},"OperatorNode:rightArithShift":{associativity:"left",associativeWith:[]},"OperatorNode:rightLogShift":{associativity:"left",associativeWith:[]}},{"OperatorNode:to":{associativity:"left",associativeWith:[]}},{RangeNode:{}},{"OperatorNode:add":{associativity:"left",associativeWith:["OperatorNode:add","OperatorNode:subtract"]},"OperatorNode:subtract":{associativity:"left",associativeWith:[]}},{"OperatorNode:multiply":{associativity:"left",associativeWith:["OperatorNode:multiply","OperatorNode:divide","Operator:dotMultiply","Operator:dotDivide"]},"OperatorNode:divide":{associativity:"left",associativeWith:[],latexLeftParens:!1,latexRightParens:!1,latexParens:!1},"OperatorNode:dotMultiply":{associativity:"left",associativeWith:["OperatorNode:multiply","OperatorNode:divide","OperatorNode:dotMultiply","OperatorNode:doDivide"]},"OperatorNode:dotDivide":{associativity:"left",associativeWith:[]},"OperatorNode:mod":{associativity:"left",associativeWith:[]}},{"OperatorNode:unaryPlus":{associativity:"right"},"OperatorNode:unaryMinus":{associativity:"right"},"OperatorNode:bitNot":{associativity:"right"},"OperatorNode:not":{associativity:"right"}},{"OperatorNode:pow":{associativity:"right",associativeWith:[],latexRightParens:!1},"OperatorNode:dotPow":{associativity:"right",associativeWith:[]}},{"OperatorNode:factorial":{associativity:"left"}},{"OperatorNode:transpose":{associativity:"left"}}];function i(e,t){var r=e;"keep"!==t&&(r=e.getContent());for(var i=r.getIdentifier(),a=0;a<n.length;a++)if(i in n[a])return a;return null}e.exports.properties=n,e.exports.getPrecedence=i,e.exports.getAssociativity=function(e,t){var r=e;"keep"!==t&&(r=e.getContent());var a=r.getIdentifier(),o=i(r,t);if(null===o)return null;var s=n[o][a];if(s.hasOwnProperty("associativity")){if("left"===s.associativity)return"left";if("right"===s.associativity)return"right";throw Error("'"+a+"' has the invalid associativity '"+s.associativity+"'.")}return null},e.exports.isAssociativeWith=function(e,t,r){var a=e,o=t;"keep"!==r&&(a=e.getContent(),o=t.getContent());var s=a.getIdentifier(),u=o.getIdentifier(),c=i(a,r);if(null===c)return null;var f=n[c][s];if(f.hasOwnProperty("associativeWith")&&f.associativeWith instanceof Array){for(var l=0;l<f.associativeWith.length;l++)if(f.associativeWith[l]===u)return!0;return!1}return null}},function(e,t,r){"use strict";var n=r(4),i=r(2).map,a=r(2).join,o=r(9).stringify,s=r(9).escape,u=r(13).isSafeMethod,c=r(54);t.name="OperatorNode",t.path="expression.node",t.factory=function(e,t,f,l){var p=f(r(7)).register,h=f(r(7)).compile,m=f(r(15));function d(t,r,n,i){if(!(this instanceof d))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof t)throw new TypeError('string expected for parameter "op"');if("string"!=typeof r)throw new TypeError('string expected for parameter "fn"');if(!Array.isArray(n)||!n.every(e.isNode))throw new TypeError('Array containing Nodes expected for parameter "args"');this.implicit=!0===i,this.op=t,this.fn=r,this.args=n||[]}function g(e,t,r,n,i){var a=c.getPrecedence(e,t),o=c.getAssociativity(e,t);if("all"===t||n.length>2&&"OperatorNode:add"!==e.getIdentifier()&&"OperatorNode:multiply"!==e.getIdentifier())return n.map(function(e){switch(e.getContent().type){case"ArrayNode":case"ConstantNode":case"SymbolNode":case"ParenthesisNode":return!1;default:return!0}});var s=void 0;switch(n.length){case 0:s=[];break;case 1:var u=c.getPrecedence(n[0],t);if(i&&null!==u){var f;if("keep"===t?(f=n[0].getIdentifier(),d=e.getIdentifier()):(f=n[0].getContent().getIdentifier(),d=e.getContent().getIdentifier()),!1===c.properties[a][d].latexLeftParens){s=[!1];break}if(!1===c.properties[u][f].latexParens){s=[!1];break}}if(null===u){s=[!1];break}if(u<=a){s=[!0];break}s=[!1];break;case 2:var l,p,h=c.getPrecedence(n[0],t),m=c.isAssociativeWith(e,n[0],t);l=null!==h&&(h===a&&"right"===o&&!m||h<a);var d,g,v,y=c.getPrecedence(n[1],t),x=c.isAssociativeWith(e,n[1],t);p=null!==y&&(y===a&&"left"===o&&!x||y<a),i&&("keep"===t?(d=e.getIdentifier(),g=e.args[0].getIdentifier(),v=e.args[1].getIdentifier()):(d=e.getContent().getIdentifier(),g=e.args[0].getContent().getIdentifier(),v=e.args[1].getContent().getIdentifier()),null!==h&&(!1===c.properties[a][d].latexLeftParens&&(l=!1),!1===c.properties[h][g].latexParens&&(l=!1)),null!==y&&(!1===c.properties[a][d].latexRightParens&&(p=!1),!1===c.properties[y][v].latexParens&&(p=!1))),s=[l,p];break;default:"OperatorNode:add"!==e.getIdentifier()&&"OperatorNode:multiply"!==e.getIdentifier()||(s=n.map(function(r){var n=c.getPrecedence(r,t),i=c.isAssociativeWith(e,r,t),s=c.getAssociativity(r,t);return null!==n&&(a===n&&o===s&&!i||n<a)}))}return n.length>=2&&"OperatorNode:multiply"===e.getIdentifier()&&e.implicit&&"auto"===t&&"hide"===r&&(s=n.map(function(e,t){var r="ParenthesisNode"===e.getIdentifier();return!(!s[t]&&!r)})),s}return f(r(47)),f(r(36)),f(r(56)),d.prototype=new m,d.prototype.type="OperatorNode",d.prototype.isOperatorNode=!0,p(d.prototype.type,function(e,t,r){if(!(e instanceof d))throw new TypeError("No valid OperatorNode");if("string"!=typeof e.fn||!u(t.math,e.fn))throw t.math[e.fn]?new Error('No access to function "'+e.fn+'"'):new Error("Function "+e.fn+' missing in provided namespace "math"');var n=i(e.args,function(e){return h(e,t,r)});return"math["+o(e.fn)+"]("+a(n,", ")+")"}),d.prototype.forEach=function(e){for(var t=0;t<this.args.length;t++)e(this.args[t],"args["+t+"]",this)},d.prototype.map=function(e){for(var t=[],r=0;r<this.args.length;r++)t[r]=this._ifNode(e(this.args[r],"args["+r+"]",this));return new d(this.op,this.fn,t,this.implicit)},d.prototype.clone=function(){return new d(this.op,this.fn,this.args.slice(0),this.implicit)},d.prototype._toString=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=e&&e.implicit?e.implicit:"hide",n=this.args,i=g(this,t,r,n,!1);if(1===n.length){var a=c.getAssociativity(this,t),o=n[0].toString(e);return i[0]&&(o="("+o+")"),"right"===a?this.op+o:o+this.op}if(2==n.length){var s=n[0].toString(e),u=n[1].toString(e);return i[0]&&(s="("+s+")"),i[1]&&(u="("+u+")"),this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"==r?s+" "+u:s+" "+this.op+" "+u}if(n.length>2&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())){var f=n.map(function(t,r){return t=t.toString(e),i[r]&&(t="("+t+")"),t});return this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"===r?f.join(" "):f.join(" "+this.op+" ")}return this.fn+"("+this.args.join(", ")+")"},d.prototype.toHTML=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=e&&e.implicit?e.implicit:"hide",n=this.args,i=g(this,t,r,n,!1);if(1===n.length){var a=c.getAssociativity(this,t),o=n[0].toHTML(e);return i[0]&&(o='<span class="math-parenthesis math-round-parenthesis">(</span>'+o+'<span class="math-parenthesis math-round-parenthesis">)</span>'),"right"===a?'<span class="math-operator math-unary-operator math-lefthand-unary-operator">'+s(this.op)+"</span>"+o:'<span class="math-operator math-unary-operator math-righthand-unary-operator">'+s(this.op)+"</span>"+o}if(2==n.length){var u=n[0].toHTML(e),f=n[1].toHTML(e);return i[0]&&(u='<span class="math-parenthesis math-round-parenthesis">(</span>'+u+'<span class="math-parenthesis math-round-parenthesis">)</span>'),i[1]&&(f='<span class="math-parenthesis math-round-parenthesis">(</span>'+f+'<span class="math-parenthesis math-round-parenthesis">)</span>'),this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"==r?u+'<span class="math-operator math-binary-operator math-implicit-binary-operator"></span>'+f:u+'<span class="math-operator math-binary-operator math-explicit-binary-operator">'+s(this.op)+"</span>"+f}if(n.length>2&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())){var l=n.map(function(t,r){return t=t.toHTML(e),i[r]&&(t='<span class="math-parenthesis math-round-parenthesis">(</span>'+t+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t});return this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"===r?l.join('<span class="math-operator math-binary-operator math-implicit-binary-operator"></span>'):l.join('<span class="math-operator math-binary-operator math-explicit-binary-operator">'+s(this.op)+"</span>")}return'<span class="math-function">'+s(this.fn)+'</span><span class="math-paranthesis math-round-parenthesis">(</span>'+l.join('<span class="math-separator">,</span>')+'<span class="math-paranthesis math-round-parenthesis">)</span>'},d.prototype._toTex=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=e&&e.implicit?e.implicit:"hide",i=this.args,a=g(this,t,r,i,!0),o=n.operators[this.fn];if(o=void 0===o?this.op:o,1===i.length){var s=c.getAssociativity(this,t),u=i[0].toTex(e);return a[0]&&(u="\\left("+u+"\\right)"),"right"===s?o+u:u+o}if(2===i.length){var f=i[0],l=f.toTex(e);a[0]&&(l="\\left("+l+"\\right)");var p,h=i[1].toTex(e);switch(a[1]&&(h="\\left("+h+"\\right)"),p="keep"===t?f.getIdentifier():f.getContent().getIdentifier(),this.getIdentifier()){case"OperatorNode:divide":return o+"{"+l+"}{"+h+"}";case"OperatorNode:pow":switch(l="{"+l+"}",h="{"+h+"}",p){case"ConditionalNode":case"OperatorNode:divide":l="\\left("+l+"\\right)"}case"OperatorNode:multiply":if(this.implicit&&"hide"===r)return l+"~"+h}return l+o+h}if(i.length>2&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())){var m=i.map(function(t,r){return t=t.toTex(e),a[r]&&(t="\\left("+t+"\\right)"),t});return"OperatorNode:multiply"===this.getIdentifier()&&this.implicit?m.join("~"):m.join(o)}return"\\mathrm{"+this.fn+"}\\left("+i.map(function(t){return t.toTex(e)}).join(",")+"\\right)"},d.prototype.getIdentifier=function(){return this.type+":"+this.fn},d}},function(e,t,r){"use strict";var n=r(4),i=r(9).stringify,a=r(9).escape,o=r(5).extend,s=r(5).hasOwnProperty,u=r(2).map,c=r(2).join,f=r(13).validateSafeMethod,l=r(109);t.name="FunctionNode",t.path="expression.node",t.math=!0,t.factory=function(e,t,p,h,m){var d=p(r(7)).register,g=p(r(7)).compile,v=p(r(15)),y=p(r(36));function x(t,r){if(!(this instanceof x))throw new SyntaxError("Constructor must be called with the new operator");if("string"==typeof t&&(t=new y(t)),!e.isNode(t))throw new TypeError('Node expected as parameter "fn"');if(!Array.isArray(r)||!r.every(e.isNode))throw new TypeError('Array containing Nodes expected for parameter "args"');this.fn=t,this.args=r||[],Object.defineProperty(this,"name",{get:function(){return this.fn.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}});var n=function(){throw new Error("Property `FunctionNode.object` is deprecated, use `FunctionNode.fn` instead")};Object.defineProperty(this,"object",{get:n,set:n})}x.prototype=new v,x.prototype.type="FunctionNode",x.prototype.isFunctionNode=!0,d(x.prototype.type,function(t,r,n){if(!(t instanceof x))throw new TypeError("No valid FunctionNode");var a,p=g(t.fn,r,n),h=u(t.args,function(e){return g(e,r,n)}),m=function(e,t){var r=Object.keys(t);if(0===r.length)return"scope";e.extend=o;var n=u(r,function(e){return i(e)+": "+t[e]});return"extend(extend({}, scope), {"+c(n,", ")+"})"}(r,n);if(e.isSymbolNode(t.fn)){var d=t.fn.name,v=s(r.math,d)?r.math[d]:void 0;return"function"==typeof v&&1==v.rawArgs?(a=l(r),r[a]=t.args,p+"("+a+", math, "+m+")"):p+"("+c(h,", ")+")"}if(e.isAccessorNode(t.fn)&&e.isIndexNode(t.fn.index)&&t.fn.index.isObjectProperty()){a=l(r),r[a]=t.args,r.validateSafeMethod=f;var y=g(t.fn.object,r,n),w=i(t.fn.index.getObjectProperty());return"(function () {var object = "+y+";validateSafeMethod(object, "+w+");return (object["+w+"] && object["+w+"].rawArgs)  ? object["+w+"]("+a+", math, "+m+") : object["+w+"]("+c(h,", ")+")})()"}return a=l(r),r[a]=t.args,"(function () {var fn = "+p+";return (fn && fn.rawArgs)  ? fn("+a+", math, "+m+") : fn("+c(h,", ")+")})()"}),x.prototype.forEach=function(e){for(var t=0;t<this.args.length;t++)e(this.args[t],"args["+t+"]",this)},x.prototype.map=function(e){for(var t=this.fn.map(e),r=[],n=0;n<this.args.length;n++)r[n]=this._ifNode(e(this.args[n],"args["+n+"]",this));return new x(t,r)},x.prototype.clone=function(){return new x(this.fn,this.args.slice(0))};var w=x.prototype.toString;function b(t,r,n){for(var i,a="",o=new RegExp("\\$(?:\\{([a-z_][a-z_0-9]*)(?:\\[([0-9]+)\\])?\\}|\\$)","ig"),s=0;null!==(i=o.exec(t));)if(a+=t.substring(s,i.index),s=i.index,"$$"===i[0])a+="$",s++;else{s+=i[0].length;var u=r[i[1]];if(!u)throw new ReferenceError("Template: Property "+i[1]+" does not exist.");if(void 0===i[2])switch(typeof u){case"string":a+=u;break;case"object":if(e.isNode(u))a+=u.toTex(n);else{if(!Array.isArray(u))throw new TypeError("Template: "+i[1]+" has to be a Node, String or array of Nodes");a+=u.map(function(t,r){if(e.isNode(t))return t.toTex(n);throw new TypeError("Template: "+i[1]+"["+r+"] is not a Node.")}).join(",")}break;default:throw new TypeError("Template: "+i[1]+" has to be a Node, String or array of Nodes")}else{if(!e.isNode(u[i[2]]&&u[i[2]]))throw new TypeError("Template: "+i[1]+"["+i[2]+"] is not a Node.");a+=u[i[2]].toTex(n)}}return a+=t.slice(s)}x.prototype.toString=function(e){var t,r=this.fn.toString(e);return e&&"object"==typeof e.handler&&s(e.handler,r)&&(t=e.handler[r](this,e)),void 0!==t?t:w.call(this,e)},x.prototype._toString=function(t){var r=this.args.map(function(e){return e.toString(t)});return(e.isFunctionAssignmentNode(this.fn)?"("+this.fn.toString(t)+")":this.fn.toString(t))+"("+r.join(", ")+")"},x.prototype.toHTML=function(e){var t=this.args.map(function(t){return t.toHTML(e)});return'<span class="math-function">'+a(this.fn)+'</span><span class="math-paranthesis math-round-parenthesis">(</span>'+t.join('<span class="math-separator">,</span>')+'<span class="math-paranthesis math-round-parenthesis">)</span>'};var N=x.prototype.toTex;return x.prototype.toTex=function(e){var t;return e&&"object"==typeof e.handler&&s(e.handler,this.name)&&(t=e.handler[this.name](this,e)),void 0!==t?t:N.call(this,e)},x.prototype._toTex=function(e){var t,r,i=this.args.map(function(t){return t.toTex(e)});switch(!m[this.name]||"function"!=typeof m[this.name].toTex&&"object"!=typeof m[this.name].toTex&&"string"!=typeof m[this.name].toTex||(t=m[this.name].toTex),typeof t){case"function":r=t(this,e);break;case"string":r=b(t,this,e);break;case"object":switch(typeof t[i.length]){case"function":r=t[i.length](this,e);break;case"string":r=b(t[i.length],this,e)}}return void 0!==r?r:b(n.defaultTemplate,this,e)},x.prototype.getIdentifier=function(){return this.type+":"+this.name},x}},function(e,t,r){"use strict";var n=r(1);r(3);t.name="isPositive",t.factory=function(e,t,r,i){var a=i("isPositive",{number:function(e){return e>0},BigNumber:function(e){return!e.isNeg()&&!e.isZero()&&!e.isNaN()},Fraction:function(e){return e.s>0&&e.n>0},Unit:function(e){return a(e.value)},"Array | Matrix":function(e){return n(e,a)}});return a}},function(e,t,r){"use strict";var n=r(1);r(3);t.name="isNegative",t.factory=function(e,t,r,i){var a=i("isNegative",{number:function(e){return e<0},BigNumber:function(e){return e.isNeg()&&!e.isZero()&&!e.isNaN()},Fraction:function(e){return e.s<0},Unit:function(e){return a(e.value)},"Array | Matrix":function(e){return n(e,a)}});return a}},function(e,t,r){"use strict";e.exports=function(e){return e&&e.constructor.prototype.isMatrix||!1}},function(e,t,r){"use strict";t.type=function(e){var t=typeof e;return"object"===t?null===e?"null":Array.isArray(e)?"Array":e instanceof Date?"Date":e instanceof RegExp?"RegExp":e instanceof Boolean?"boolean":e instanceof Number?"number":e instanceof String?"string":"Object":"function"===t?"Function":t}},function(e,t,r){"use strict";var n=r(11);t.name="algorithm05",t.factory=function(e,t,i,a){var o=i(r(10)),s=e.SparseMatrix;return function(e,t,r){var i=e._values,u=e._index,c=e._ptr,f=e._size,l=e._datatype,p=t._values,h=t._index,m=t._ptr,d=t._size,g=t._datatype;if(f.length!==d.length)throw new n(f.length,d.length);if(f[0]!==d[0]||f[1]!==d[1])throw new RangeError("Dimension mismatch. Matrix A ("+f+") must match Matrix B ("+d+")");var v,y=f[0],x=f[1],w=o,b=0,N=r;"string"==typeof l&&l===g&&(v=l,w=a.find(o,[v,v]),b=a.convert(0,v),N=a.find(r,[v,v]));var E,M,A,O,T=i&&p?[]:void 0,S=[],_=[],C=new s({values:T,index:S,ptr:_,size:[y,x],datatype:v}),z=T?[]:void 0,k=T?[]:void 0,B=[],I=[];for(M=0;M<x;M++){_[M]=S.length;var P=M+1;for(A=c[M],O=c[M+1];A<O;A++)E=u[A],S.push(E),B[E]=P,z&&(z[E]=i[A]);for(A=m[M],O=m[M+1];A<O;A++)B[E=h[A]]!==P&&S.push(E),I[E]=P,k&&(k[E]=p[A]);if(T)for(A=_[M];A<S.length;){var R=B[E=S[A]],U=I[E];if(R===P||U===P){var q=N(R===P?z[E]:b,U===P?k[E]:b);w(q,b)?S.splice(A,1):(T.push(q),A++)}}}return _[x]=S.length,C}}},function(e,t,r){"use strict";var n=r(2),i=r(3).isInteger;t.name="eye",t.factory=function(e,t,a,o){var s=a(r(0)),u=o("eye",{"":function(){return"Matrix"===t.matrix?s([]):[]},string:function(e){return s(e)},"number | BigNumber":function(e){return f(e,e,"Matrix"===t.matrix?"default":void 0)},"number | BigNumber, string":function(e,t){return f(e,e,t)},"number | BigNumber, number | BigNumber":function(e,r){return f(e,r,"Matrix"===t.matrix?"default":void 0)},"number | BigNumber, number | BigNumber, string":function(e,t,r){return f(e,t,r)},Array:function(e){return c(e)},"Array, string":function(e,t){return c(e,t)},Matrix:function(e){return c(e.valueOf(),e.storage())},"Matrix, string":function(e,t){return c(e.valueOf(),t)}});return u.toTex=void 0,u;function c(e,t){switch(e.length){case 0:return t?s(t):[];case 1:return f(e[0],e[0],t);case 2:return f(e[0],e[1],t);default:throw new Error("Vector containing two values expected")}}function f(t,r,a){var o=e.isBigNumber(t)||e.isBigNumber(r)?e.BigNumber:null;if(e.isBigNumber(t)&&(t=t.toNumber()),e.isBigNumber(r)&&(r=r.toNumber()),!i(t)||t<1)throw new Error("Parameters in function eye must be positive integers");if(!i(r)||r<1)throw new Error("Parameters in function eye must be positive integers");var s=o?new e.BigNumber(1):1,u=o?new o(0):0,c=[t,r];if(a)return e.Matrix.storage(a).diagonal(c,s,0,u);for(var f=n.resize([],c,u),l=t<r?t:r,p=0;p<l;p++)f[p][p]=s;return f}}},function(e,t,r){"use strict";t.name="ParenthesisNode",t.path="expression.node",t.factory=function(e,t,n,i){var a=n(r(7)).register,o=n(r(7)).compile,s=n(r(15));function u(t){if(!(this instanceof u))throw new SyntaxError("Constructor must be called with the new operator");if(!e.isNode(t))throw new TypeError('Node expected for parameter "content"');this.content=t}return u.prototype=new s,u.prototype.type="ParenthesisNode",u.prototype.isParenthesisNode=!0,a(u.prototype.type,function(e,t,r){if(!(e instanceof u))throw new TypeError("No valid ParenthesisNode");return o(e.content,t,r)}),u.prototype.getContent=function(){return this.content.getContent()},u.prototype.forEach=function(e){e(this.content,"content",this)},u.prototype.map=function(e){return new u(e(this.content,"content",this))},u.prototype.clone=function(){return new u(this.content)},u.prototype._toString=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?"("+this.content.toString(e)+")":this.content.toString(e)},u.prototype.toHTML=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?'<span class="math-parenthesis math-round-parenthesis">(</span>'+this.content.toHTML(e)+'<span class="math-parenthesis math-round-parenthesis">)</span>':this.content.toHTML(e)},u.prototype._toTex=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?"\\left("+this.content.toTex(e)+"\\right)":this.content.toTex(e)},u}},function(e,t,r){"use strict";var n=r(5).clone,i=r(3).isInteger,a=r(2),o=r(53),s=r(11);function u(e,t,r,n){if(n<r){if(e.length!=t.length)throw new s(e.length,t.length);for(var i=[],a=0;a<e.length;a++)i[a]=u(e[a],t[a],r,n+1);return i}return e.concat(t)}t.name="concat",t.factory=function(e,t,c,f){var l=c(r(0)),p=f("concat",{"...Array | Matrix | number | BigNumber":function(t){var r,c,f=t.length,p=-1,h=!1,m=[];for(r=0;r<f;r++){var d=t[r];if(e.isMatrix(d)&&(h=!0),e.isNumber(d)||e.isBigNumber(d)){if(r!==f-1)throw new Error("Dimension must be specified as last argument");if(c=p,p=d.valueOf(),!i(p))throw new TypeError("Integer number expected for dimension");if(p<0||r>0&&p>c)throw new o(p,c+1)}else{var g=n(d).valueOf(),v=a.size(g);if(m[r]=g,c=p,p=v.length-1,r>0&&p!=c)throw new s(c+1,p+1)}}if(0==m.length)throw new SyntaxError("At least one matrix expected");for(var y=m.shift();m.length;)y=u(y,m.shift(),p,0);return h?l(y):y},"...string":function(e){return e.join("")}});return p.toTex=void 0,p}},function(e,t,r){"use strict";var n=r(2).size,i=r(59),a=r(53);function o(e,t,r){var n,i,a,s;if(t<=0){if(Array.isArray(e[0])){for(s=function(e){var t,r,n=e.length,i=e[0].length,a=[];for(r=0;r<i;r++){var o=[];for(t=0;t<n;t++)o.push(e[t][r]);a.push(o)}return a}(e),i=[],n=0;n<s.length;n++)i[n]=o(s[n],t-1,r);return i}for(a=e[0],n=1;n<e.length;n++)a=r(a,e[n]);return a}for(i=[],n=0;n<e.length;n++)i[n]=o(e[n],t-1,r);return i}e.exports=function(e,t,r){var s=Array.isArray(e)?n(e):e.size();if(t<0||t>=s.length)throw new a(t,s.length);return i(e)?e.create(o(e.valueOf(),t,r)):o(e,t,r)}},function(e,t,r){"use strict";var n=r(48);e.exports=function(e){for(var t=0;t<e.length;t++)if(n(e[t]))return!0;return!1}},function(e,t,r){"use strict";var n=r(5).clone,i=r(9).format;t.name="transpose",t.factory=function(e,t,a,o){var s=r(4),u=a(r(0)),c=e.DenseMatrix,f=e.SparseMatrix,l=o("transpose",{Array:function(e){return l(u(e)).valueOf()},Matrix:function(e){var t,r=e.size();switch(r.length){case 1:t=e.clone();break;case 2:var n=r[0],a=r[1];if(0===a)throw new RangeError("Cannot transpose a 2D matrix with no columns (size: "+i(r)+")");switch(e.storage()){case"dense":t=p(e,n,a);break;case"sparse":t=h(e,n,a)}break;default:throw new RangeError("Matrix must be a vector or two dimensional (size: "+i(this._size)+")")}return t},any:function(e){return n(e)}}),p=function(e,t,r){for(var i,a=e._data,o=[],s=0;s<r;s++){i=o[s]=[];for(var u=0;u<t;u++)i[u]=n(a[u][s])}return new c({data:o,size:[r,t],datatype:e._datatype})},h=function(e,t,r){for(var i,a,o,s=e._values,u=e._index,c=e._ptr,l=s?[]:void 0,p=[],h=[],m=[],d=0;d<t;d++)m[d]=0;for(i=0,a=u.length;i<a;i++)m[u[i]]++;for(var g=0,v=0;v<t;v++)h.push(g),g+=m[v],m[v]=h[v];for(h.push(g),o=0;o<r;o++)for(var y=c[o],x=c[o+1],w=y;w<x;w++){var b=m[u[w]]++;p[b]=o,s&&(l[b]=n(s[w]))}return new f({values:l,index:p,ptr:h,size:[r,t],datatype:e._datatype})};return l.toTex={1:"\\left(${args[0]}\\right)"+s.operators.transpose},l}},function(e,t,r){"use strict";var n=r(439),i=r(11);t.name="algorithm06",t.factory=function(e,t,a,o){var s=a(r(10)),u=e.SparseMatrix;return function(e,t,r){var a=e._values,c=e._size,f=e._datatype,l=t._values,p=t._size,h=t._datatype;if(c.length!==p.length)throw new i(c.length,p.length);if(c[0]!==p[0]||c[1]!==p[1])throw new RangeError("Dimension mismatch. Matrix A ("+c+") must match Matrix B ("+p+")");var m,d=c[0],g=c[1],v=s,y=0,x=r;"string"==typeof f&&f===h&&(m=f,v=o.find(s,[m,m]),y=o.convert(0,m),x=o.find(r,[m,m]));for(var w=a&&l?[]:void 0,b=[],N=[],E=new u({values:w,index:b,ptr:N,size:[d,g],datatype:m}),M=w?[]:void 0,A=[],O=[],T=0;T<g;T++){N[T]=b.length;var S=T+1;if(n(e,T,A,M,O,S,E,x),n(t,T,A,M,O,S,E,x),M)for(var _=N[T];_<b.length;){var C=b[_];if(O[C]===S){var z=M[C];v(z,y)?b.splice(_,1):(w.push(z),_++)}else b.splice(_,1)}else for(var k=N[T];k<b.length;)O[b[k]]!==S?b.splice(k,1):k++}return N[g]=b.length,E}}},function(e,t,r){"use strict";var n=r(1);t.name="factorial",t.factory=function(e,t,i,a){var o=i(r(140)),s=r(4),u=a("factorial",{number:function(e){if(e<0)throw new Error("Value must be non-negative");return o(e+1)},BigNumber:function(e){if(e.isNegative())throw new Error("Value must be non-negative");return o(e.plus(1))},"Array | Matrix":function(e){return n(e,u)}});return u.toTex={1:"\\left(${args[0]}\\right)"+s.operators.factorial},u}},function(e,t,r){"use strict";var n=r(3).isInteger;function i(e){return e.isInteger()&&e.gte(0)}t.name="combinations",t.factory=function(e,t,r,a){var o=a("combinations",{"number, number":function(e,t){var r,i,a;if(!n(e)||e<0)throw new TypeError("Positive integer value expected in function combinations");if(!n(t)||t<0)throw new TypeError("Positive integer value expected in function combinations");if(t>e)throw new TypeError("k must be less than or equal to n");for(r=Math.max(t,e-t),i=1,a=1;a<=e-r;a++)i=i*(r+a)/a;return i},"BigNumber, BigNumber":function(t,r){var n,a,o,s,u=new e.BigNumber(1);if(!i(t)||!i(r))throw new TypeError("Positive integer value expected in function combinations");if(r.gt(t))throw new TypeError("k must be less than n in function combinations");for(n=t.minus(r),r.lt(n)&&(n=r),a=u,o=u,s=t.minus(n);o.lte(s);o=o.plus(1))a=a.times(n.plus(o)).dividedBy(o);return a}});return o.toTex={2:"\\binom{${args[0]}}{${args[1]}}"},o}},function(e,t){e.exports=function(e){return e&&e.constructor.prototype.isBigNumber||!1}},function(e,t,r){"use strict";var n=r(25).string.isString;t.name="Matrix",t.path="type",t.factory=function(e,t,r,i){function a(){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator")}return a.prototype.type="Matrix",a.prototype.isMatrix=!0,a.storage=function(e){if(!n(e))throw new TypeError("format must be a string value");var t=a._storage[e];if(!t)throw new SyntaxError("Unsupported matrix storage format: "+e);return t},a._storage={},a.prototype.storage=function(){throw new Error("Cannot invoke storage on a Matrix interface")},a.prototype.datatype=function(){throw new Error("Cannot invoke datatype on a Matrix interface")},a.prototype.create=function(e,t){throw new Error("Cannot invoke create on a Matrix interface")},a.prototype.subset=function(e,t,r){throw new Error("Cannot invoke subset on a Matrix interface")},a.prototype.get=function(e){throw new Error("Cannot invoke get on a Matrix interface")},a.prototype.set=function(e,t,r){throw new Error("Cannot invoke set on a Matrix interface")},a.prototype.resize=function(e,t){throw new Error("Cannot invoke resize on a Matrix interface")},a.prototype.reshape=function(e,t){throw new Error("Cannot invoke reshape on a Matrix interface")},a.prototype.clone=function(){throw new Error("Cannot invoke clone on a Matrix interface")},a.prototype.size=function(){throw new Error("Cannot invoke size on a Matrix interface")},a.prototype.map=function(e,t){throw new Error("Cannot invoke map on a Matrix interface")},a.prototype.forEach=function(e){throw new Error("Cannot invoke forEach on a Matrix interface")},a.prototype.toArray=function(){throw new Error("Cannot invoke toArray on a Matrix interface")},a.prototype.valueOf=function(){throw new Error("Cannot invoke valueOf on a Matrix interface")},a.prototype.format=function(e){throw new Error("Cannot invoke format on a Matrix interface")},a.prototype.toString=function(){throw new Error("Cannot invoke toString on a Matrix interface")},a}},function(e,t,r){"use strict";var n=r(11);t.name="algorithm04",t.factory=function(e,t,i,a){var o=i(r(10)),s=e.SparseMatrix;return function(e,t,r){var i=e._values,u=e._index,c=e._ptr,f=e._size,l=e._datatype,p=t._values,h=t._index,m=t._ptr,d=t._size,g=t._datatype;if(f.length!==d.length)throw new n(f.length,d.length);if(f[0]!==d[0]||f[1]!==d[1])throw new RangeError("Dimension mismatch. Matrix A ("+f+") must match Matrix B ("+d+")");var v,y=f[0],x=f[1],w=o,b=0,N=r;"string"==typeof l&&l===g&&(v=l,w=a.find(o,[v,v]),b=a.convert(0,v),N=a.find(r,[v,v]));var E,M,A,O,T,S=i&&p?[]:void 0,_=[],C=[],z=new s({values:S,index:_,ptr:C,size:[y,x],datatype:v}),k=i&&p?[]:void 0,B=i&&p?[]:void 0,I=[],P=[];for(M=0;M<x;M++){C[M]=_.length;var R=M+1;for(O=c[M],T=c[M+1],A=O;A<T;A++)E=u[A],_.push(E),I[E]=R,k&&(k[E]=i[A]);for(O=m[M],T=m[M+1],A=O;A<T;A++)if(I[E=h[A]]===R){if(k){var U=N(k[E],p[A]);w(U,b)?I[E]=null:k[E]=U}}else _.push(E),P[E]=R,B&&(B[E]=p[A]);if(k&&B)for(A=C[M];A<_.length;)I[E=_[A]]===R?(S[A]=k[E],A++):P[E]===R?(S[A]=B[E],A++):_.splice(A,1)}return C[x]=_.length,z}}},function(e,t,r){"use strict";var n=r(1);t.name="number",t.factory=function(e,t,r,i){var a=i("number",{"":function(){return 0},number:function(e){return e},string:function(e){var t=Number(e);if(isNaN(t))throw new SyntaxError('String "'+e+'" is no valid number');return t},BigNumber:function(e){return e.toNumber()},Fraction:function(e){return e.valueOf()},Unit:function(e){throw new Error("Second argument with valueless unit expected")},"Unit, string | Unit":function(e,t){return e.toNumber(t)},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={0:"0",1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)${args[1]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);r(3);t.name="isNumeric",t.factory=function(e,t,r,i){var a=i("isNumeric",{"number | BigNumber | Fraction | boolean":function(){return!0},"Complex | Unit | string":function(){return!1},"Array | Matrix":function(e){return n(e,a)}});return a}},function(e,t,r){"use strict";var n=r(60);t.name="typeof",t.factory=function(e,t,r,i){var a=i("_typeof",{any:function(t){var r=n.type(t);if("Object"===r){if(e.isBigNumber(t))return"BigNumber";if(e.isComplex(t))return"Complex";if(e.isFraction(t))return"Fraction";if(e.isMatrix(t))return"Matrix";if(e.isUnit(t))return"Unit";if(e.isIndex(t))return"Index";if(e.isRange(t))return"Range";if(e.isChain(t))return"Chain";if(e.isHelp(t))return"Help"}return r}});return a.toTex=void 0,a}},function(e,t,r){"use strict";e.exports={end:!0}},function(e,t,r){"use strict";var n=r(2).map,i=r(2).join,a=r(9).escape;t.name="IndexNode",t.path="expression.node",t.factory=function(e,t,o,s){var u=o(r(7)).register,c=o(r(7)).compile,f=o(r(15)),l=(o(r(79)),o(r(36)),o(r(94))),p=Array.isArray;function h(t,r){if(!(this instanceof h))throw new SyntaxError("Constructor must be called with the new operator");if(this.dimensions=t,this.dotNotation=r||!1,!p(t)||!t.every(e.isNode))throw new TypeError('Array containing Nodes expected for parameter "dimensions"');if(this.dotNotation&&!this.isObjectProperty())throw new Error("dotNotation only applicable for object properties");var n=function(){throw new Error("Property `IndexNode.object` is deprecated, use `IndexNode.fn` instead")};Object.defineProperty(this,"object",{get:n,set:n})}return h.prototype=new f,h.prototype.type="IndexNode",h.prototype.isIndexNode=!0,u(h.prototype.type,function(t,r,a){if(!(t instanceof h))throw new TypeError("No valid IndexNode");var o=Object.create(a);r.range=function(t,r,n){return new l(e.isBigNumber(t)?t.toNumber():t,e.isBigNumber(r)?r.toNumber():r,e.isBigNumber(n)?n.toNumber():n)};var s=n(t.dimensions,function(t,n){return e.isRangeNode(t)?t.needsEnd()?(o.end="end","(function () {var end = size["+n+"]; return range("+c(t.start,r,o)+", "+c(t.end,r,o)+", "+(t.step?c(t.step,r,o):"1")+"); })()"):"range("+c(t.start,r,o)+", "+c(t.end,r,o)+", "+(t.step?c(t.step,r,o):"1")+")":e.isSymbolNode(t)&&"end"===t.name?(o.end="end","(function () {var end = size["+n+"]; return "+c(t,r,o)+"; })()"):c(t,r,o)});return"math.index("+i(s,", ")+")"}),h.prototype.forEach=function(e){for(var t=0;t<this.dimensions.length;t++)e(this.dimensions[t],"dimensions["+t+"]",this)},h.prototype.map=function(e){for(var t=[],r=0;r<this.dimensions.length;r++)t[r]=this._ifNode(e(this.dimensions[r],"dimensions["+r+"]",this));return new h(t)},h.prototype.clone=function(){return new h(this.dimensions.slice(0))},h.prototype.isObjectProperty=function(){return 1===this.dimensions.length&&e.isConstantNode(this.dimensions[0])&&"string"===this.dimensions[0].valueType},h.prototype.getObjectProperty=function(){return this.isObjectProperty()?this.dimensions[0].value:null},h.prototype._toString=function(e){return this.dotNotation?"."+this.getObjectProperty():"["+this.dimensions.join(", ")+"]"},h.prototype.toHTML=function(e){for(var t=[],r=0;r<this.dimensions.length;r++)t[r]=this.dimensions[r].toHTML();return this.dotNotation?'<span class="math-operator math-accessor-operator">.</span><span class="math-symbol math-property">'+a(this.getObjectProperty())+"</span>":'<span class="math-parenthesis math-square-parenthesis">[</span>'+t.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-square-parenthesis">]</span>'},h.prototype._toTex=function(e){var t=this.dimensions.map(function(t){return t.toTex(e)});return this.dotNotation?"."+this.getObjectProperty():"_{"+t.join(",")+"}"},h.prototype.needsSize=function(){return this.dimensions.some(function(t){return e.isRangeNode(t)&&t.needsEnd()||e.isSymbolNode(t)&&"end"===t.name})},h}},function(e,t,r){"use strict";var n=r(54);t.name="RangeNode",t.path="expression.node",t.factory=function(e,t,i,a){var o=i(r(7)).register,s=i(r(7)).compile,u=i(r(15));function c(t,r,n){if(!(this instanceof c))throw new SyntaxError("Constructor must be called with the new operator");if(!e.isNode(t))throw new TypeError("Node expected");if(!e.isNode(r))throw new TypeError("Node expected");if(n&&!e.isNode(n))throw new TypeError("Node expected");if(arguments.length>3)throw new Error("Too many arguments");this.start=t,this.end=r,this.step=n||null}function f(e,t){var r=n.getPrecedence(e,t),i={},a=n.getPrecedence(e.start,t);if(i.start=null!==a&&a<=r||"all"===t,e.step){var o=n.getPrecedence(e.step,t);i.step=null!==o&&o<=r||"all"===t}var s=n.getPrecedence(e.end,t);return i.end=null!==s&&s<=r||"all"===t,i}return c.prototype=new u,c.prototype.type="RangeNode",c.prototype.isRangeNode=!0,c.prototype.needsEnd=function(){return this.filter(function(t){return e.isSymbolNode(t)&&"end"===t.name}).length>0},o(c.prototype.type,function(e,t,r){if(!(e instanceof c))throw new TypeError("No valid RangeNode");return"math.range("+s(e.start,t,r)+", "+s(e.end,t,r)+(e.step?", "+s(e.step,t,r):"")+")"}),c.prototype.forEach=function(e){e(this.start,"start",this),e(this.end,"end",this),this.step&&e(this.step,"step",this)},c.prototype.map=function(e){return new c(this._ifNode(e(this.start,"start",this)),this._ifNode(e(this.end,"end",this)),this.step&&this._ifNode(e(this.step,"step",this)))},c.prototype.clone=function(){return new c(this.start,this.end,this.step&&this.step)},c.prototype._toString=function(e){var t,r=f(this,e&&e.parenthesis?e.parenthesis:"keep"),n=this.start.toString(e);if(r.start&&(n="("+n+")"),t=n,this.step){var i=this.step.toString(e);r.step&&(i="("+i+")"),t+=":"+i}var a=this.end.toString(e);return r.end&&(a="("+a+")"),t+=":"+a},c.prototype.toHTML=function(e){var t,r=f(this,e&&e.parenthesis?e.parenthesis:"keep"),n=this.start.toHTML(e);if(r.start&&(n='<span class="math-parenthesis math-round-parenthesis">(</span>'+n+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t=n,this.step){var i=this.step.toHTML(e);r.step&&(i='<span class="math-parenthesis math-round-parenthesis">(</span>'+i+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+='<span class="math-operator math-range-operator">:</span>'+i}var a=this.end.toHTML(e);return r.end&&(a='<span class="math-parenthesis math-round-parenthesis">(</span>'+a+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+='<span class="math-operator math-range-operator">:</span>'+a},c.prototype._toTex=function(e){var t=f(this,e&&e.parenthesis?e.parenthesis:"keep"),r=this.start.toTex(e);if(t.start&&(r="\\left("+r+"\\right)"),this.step){var n=this.step.toTex(e);t.step&&(n="\\left("+n+"\\right)"),r+=":"+n}var i=this.end.toTex(e);return t.end&&(i="\\left("+i+"\\right)"),r+=":"+i},c}},function(e,t,r){"use strict";var n=r(2).map,i=r(2).join;t.name="ArrayNode",t.path="expression.node",t.factory=function(e,t,a,o){var s=a(r(7)).register,u=a(r(7)).compile,c=a(r(15));function f(t){if(!(this instanceof f))throw new SyntaxError("Constructor must be called with the new operator");if(this.items=t||[],!Array.isArray(this.items)||!this.items.every(e.isNode))throw new TypeError("Array containing Nodes expected");var r=function(){throw new Error("Property `ArrayNode.nodes` is deprecated, use `ArrayNode.items` instead")};Object.defineProperty(this,"nodes",{get:r,set:r})}return f.prototype=new c,f.prototype.type="ArrayNode",f.prototype.isArrayNode=!0,s(f.prototype.type,function(e,t,r){if(!(e instanceof f))throw new TypeError("No valid ArrayNode");var a="Array"!==t.math.config().matrix,o=n(e.items,function(e){return u(e,t,r)});return(a?"math.matrix([":"[")+i(o,",")+(a?"])":"]")}),f.prototype.forEach=function(e){for(var t=0;t<this.items.length;t++)e(this.items[t],"items["+t+"]",this)},f.prototype.map=function(e){for(var t=[],r=0;r<this.items.length;r++)t[r]=this._ifNode(e(this.items[r],"items["+r+"]",this));return new f(t)},f.prototype.clone=function(){return new f(this.items.slice(0))},f.prototype._toString=function(e){return"["+this.items.map(function(t){return t.toString(e)}).join(", ")+"]"},f.prototype.toHTML=function(e){return'<span class="math-parenthesis math-square-parenthesis">[</span>'+this.items.map(function(t){return t.toHTML(e)}).join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-square-parenthesis">]</span>'},f.prototype._toTex=function(e){var t="\\begin{bmatrix}";return this.items.forEach(function(r){r.items?t+=r.items.map(function(t){return t.toTex(e)}).join("&"):t+=r.toTex(e),t+="\\\\"}),t+="\\end{bmatrix}"},f}},function(e,t){t.factory=function(e,t,r,n){return function(t,r,n){var i=t.filter(function(t){return e.isSymbolNode(t)&&!(t.name in r)&&!(t.name in n)})[0];if(!i)throw new Error('No undefined variable found in inline expression "'+t+'"');var a=i.name,o=Object.create(n),s=t.compile();return function(e){return o[a]=e,s.eval(o)}}}},function(e,t,r){"use strict";t.math=!0,t.name="simplify",t.factory=function(e,t,n,i,a){var o=n(r(41)),s=n(r(47)),u=n(r(56)),c=n(r(55)),f=n(r(63)),l=n(r(36)),p=(n(r(15)),n(r(120))),h=n(r(122)),m=n(r(410)),d=n(r(121)),g=d.isCommutative,v=d.isAssociative,y=d.flatten,x=d.unflattenr,w=d.unflattenl,b=d.createMakeNodeFunction,N=i("simplify",{string:function(e){return N(o(e),N.rules,{})},"string, Object":function(e,t){return N(o(e),N.rules,t)},"string, Array":function(e,t){return N(o(e),t,{})},"string, Array, Object":function(e,t,r){return N(o(e),t,r)},"Node, Object":function(e,t){return N(e,N.rules,t)},Node:function(e){return N(e,N.rules,{})},"Node, Array":function(e,t){return N(e,t,{})},"Node, Array, Object":function(e,t,r){t=function(e){for(var t=[],r=0;r<e.length;r++){var n,i=e[r],a=typeof i;switch(a){case"string":var s=i.split("->");if(2!==s.length)throw SyntaxError("Could not parse rule: "+i);i={l:s[0],r:s[1]};case"object":if(n={l:E(o(i.l)),r:E(o(i.r))},i.context&&(n.evaluate=i.context),i.evaluate&&(n.evaluate=o(i.evaluate)),v(n.l)){var u=b(n.l),c=new l("_p"+A++);n.expanded={},n.expanded.l=u([n.l.clone(),c]),y(n.expanded.l),x(n.expanded.l),n.expanded.r=u([n.r,c])}break;case"function":n=i;break;default:throw TypeError("Unsupported type of rule: "+a)}t.push(n)}return t}(t);for(var n,i={},a=(n=E(n=m(e,r))).toString({parenthesis:"all"});!i[a];){i[a]=!0,A=0;for(var s=0;s<t.length;s++)"function"==typeof t[s]?n=t[s](n):(y(n),n=O(n,t[s])),w(n);a=n.toString({parenthesis:"all"})}return n}});function E(t){return t.transform(function(t,r,n){return e.isParenthesisNode(t)?t.content:t})}N.simplifyCore=h,N.resolve=m;var M={true:!0,false:!0,e:!0,i:!0,Infinity:!0,LN2:!0,LN10:!0,LOG2E:!0,LOG10E:!0,NaN:!0,phi:!0,pi:!0,SQRT1_2:!0,SQRT2:!0,tau:!0};N.rules=[h,{l:"log(e)",r:"1"},{l:"n-n1",r:"n+-n1"},{l:"-(c*v)",r:"(-c) * v"},{l:"-v",r:"(-1) * v"},{l:"n/n1^n2",r:"n*n1^-n2"},{l:"n/n1",r:"n*n1^-1"},{l:"(n ^ n1) ^ n2",r:"n ^ (n1 * n2)"},{l:"n*n",r:"n^2"},{l:"n * n^n1",r:"n^(n1+1)"},{l:"n^n1 * n^n2",r:"n^(n1+n2)"},{l:"n+n",r:"2*n"},{l:"n+-n",r:"0"},{l:"n1*n2 + n2",r:"(n1+1)*n2"},{l:"n1*n3 + n2*n3",r:"(n1+n2)*n3"},{l:"n1 + -1 * (n2 + n3)",r:"n1 + -1 * n2 + -1 * n3"},p,{l:"(-n)*n1",r:"-(n*n1)"},{l:"c+v",r:"v+c",context:{add:{commutative:!1}}},{l:"v*c",r:"c*v",context:{multiply:{commutative:!1}}},{l:"n+-n1",r:"n-n1"},{l:"n*(n1^-1)",r:"n/n1"},{l:"n*n1^-n2",r:"n/n1^n2"},{l:"n1^-1",r:"1/n1"},{l:"n*(n1/n2)",r:"(n*n1)/n2"},{l:"n-(n1+n2)",r:"n-n1-n2"},{l:"1*n",r:"n"}];var A=0,O=i("applyRule",{"Node, Object":function(e,t){var r=e;if(r instanceof c||r instanceof u){if(r.args)for(var n=0;n<r.args.length;n++)r.args[n]=O(r.args[n],t)}else r instanceof f&&r.content&&(r.content=O(r.content,t));var i=t.r,a=_(t.l,r)[0];if(!a&&t.expanded&&(i=t.expanded.r,a=_(t.expanded.l,r)[0]),a){r=i.clone();var o=function(e){return e.isSymbolNode&&a.placeholders.hasOwnProperty(e.name)?a.placeholders[e.name].clone():e.map(o)};r=o(r)}return r}});function T(e,t){var r={placeholders:{}};if(!e.placeholders&&!t.placeholders)return r;if(!e.placeholders)return t;if(!t.placeholders)return e;for(var n in e.placeholders)if(r.placeholders[n]=e.placeholders[n],t.placeholders.hasOwnProperty(n)&&!C(e.placeholders[n],t.placeholders[n]))return null;for(var n in t.placeholders)r.placeholders[n]=t.placeholders[n];return r}function S(e,t){var r,n=[];if(0===e.length||0===t.length)return n;for(var i=0;i<e.length;i++)for(var a=0;a<t.length;a++)(r=T(e[i],t[a]))&&n.push(r);return n}function _(t,r,n){var i=[{placeholders:{}}];if(t instanceof c&&r instanceof c||t instanceof u&&r instanceof u){if(t instanceof c){if(t.op!==r.op||t.fn!==r.fn)return[]}else if(t instanceof u&&t.name!==r.name)return[];if((1!==r.args.length||1!==t.args.length)&&v(r)&&!n){if(r.args.length>=2&&2===t.args.length){var o=function(e,t){var r,n,i=[],a=b(e);if(g(e,t))for(var o=0;o<e.args.length;o++)(n=e.args.slice(0)).splice(o,1),r=1===n.length?n[0]:a(n),i.push(a([e.args[o],r]));else r=1===(n=e.args.slice(1)).length?n[0]:a(n),i.push(a([e.args[0],r]));return i}(r,t.context),f=[];for(m=0;m<o.length;m++){var p=_(t,o[m],!0);f=f.concat(p)}return f}if(t.args.length>2)throw Error("Unexpected non-binary associative function: "+t.toString());return[]}for(var h=[],m=0;m<t.args.length;m++){var d=_(t.args[m],r.args[m]);if(0===d.length)return[];h.push(d)}i=function(e){if(0===e.length)return e;for(var t=e.reduce(S),r=[],n={},i=0;i<t.length;i++){var a=JSON.stringify(t[i]);n[a]||(n[a]=!0,r.push(t[i]))}return r}(h)}else if(t instanceof l){if(0===t.name.length)throw new Error("Symbol in rule has 0 length...!?");if(a.hasOwnProperty(t.name)){if(!M[t.name])throw new Error("Built in constant: "+t.name+" is not supported by simplify.");if(t.name!==r.name)return[]}else if("n"===t.name[0]||"_p"===t.name.substring(0,2))i[0].placeholders[t.name]=r;else if("v"===t.name[0]){if(e.isConstantNode(r))return[];i[0].placeholders[t.name]=r}else{if("c"!==t.name[0])throw new Error("Invalid symbol in rule: "+t.name);if(!(r instanceof s))return[];i[0].placeholders[t.name]=r}}else{if(!(t instanceof s))return[];if(t.value!==r.value)return[]}return i}function C(e,t){if(e instanceof s&&t instanceof s){if(e.value!==t.value)return!1}else if(e instanceof l&&t instanceof l){if(e.name!==t.name)return!1}else{if(!(e instanceof c&&t instanceof c||e instanceof u&&t instanceof u))return!1;if(e instanceof c){if(e.op!==t.op||e.fn!==t.fn)return!1}else if(e instanceof u&&e.name!==t.name)return!1;if(e.args.length!==t.args.length)return!1;for(var r=0;r<e.args.length;r++)if(!C(e.args[r],t.args[r]))return!1}return!0}return N}},function(e,t,r){"use strict";var n=r(1);r(3);t.name="isZero",t.factory=function(e,t,r,i){var a=i("isZero",{number:function(e){return 0===e},BigNumber:function(e){return e.isZero()},Complex:function(e){return 0===e.re&&0===e.im},Fraction:function(e){return 1===e.d&&0===e.n},Unit:function(e){return a(e.value)},"Array | Matrix":function(e){return n(e,a)}});return a}},function(e,t,r){"use strict";t.name="cs_flip",t.path="sparse",t.factory=function(){return function(e){return-e-2}}},function(e,t,r){"use strict";var n=r(25),i=n.string,a=n.array,o=Array.isArray;t.factory=function(e){var t=e.DenseMatrix;return function(r,n,s){var u=r.size();if(2!==u.length)throw new RangeError("Matrix must be two dimensional (size: "+i.format(u)+")");var c,f,l,p=u[0];if(p!==u[1])throw new RangeError("Matrix must be square (size: "+i.format(u)+")");if(e.isMatrix(n)){var h=n.size();if(1===h.length){if(h[0]!==p)throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(c=[],l=n._data,f=0;f<p;f++)c[f]=[l[f]];return new t({data:c,size:[p,1],datatype:n._datatype})}if(2===h.length){if(h[0]!==p||1!==h[1])throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");if(e.isDenseMatrix(n)){if(s){for(c=[],l=n._data,f=0;f<p;f++)c[f]=[l[f][0]];return new t({data:c,size:[p,1],datatype:n._datatype})}return n}for(c=[],f=0;f<p;f++)c[f]=[0];for(var m=n._values,d=n._index,g=n._ptr,v=g[1],y=g[0];y<v;y++)c[f=d[y]][0]=m[y];return new t({data:c,size:[p,1],datatype:n._datatype})}throw new RangeError("Dimension mismatch. Matrix columns must match vector length.")}if(o(n)){var x=a.size(n);if(1===x.length){if(x[0]!==p)throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(c=[],f=0;f<p;f++)c[f]=[n[f]];return new t({data:c,size:[p,1]})}if(2===x.length){if(x[0]!==p||1!==x[1])throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(c=[],f=0;f<p;f++)c[f]=[n[f][0]];return new t({data:c,size:[p,1]})}throw new RangeError("Dimension mismatch. Matrix columns must match vector length.")}}}},function(e,t,r){var n=r(87);function i(e){for(var t=e.d,r=t[0]+"",n=1;n<t.length;++n){for(var i=t[n]+"",a=7-i.length;a--;)i="0"+i;r+=i}for(l=r.length-1;"0"==r.charAt(l);--l);var o=e.e,s=r.slice(0,l+1||1),u=s.length;if(o>0)if(++o>u)for(o-=u;o--;s+="0");else o<u&&(s=s.slice(0,o)+"."+s.slice(o));var c=[0];for(n=0;n<s.length;){for(var f=c.length;f--;c[f]*=10);c[0]+=s.charAt(n++)<<0;for(var l=0;l<c.length;++l)c[l]>1&&(null==c[l+1]&&(c[l+1]=0),c[l+1]+=c[l]>>1,c[l]&=1)}return c.reverse()}e.exports=function(e,t,r){var a,o,s,u,c,f=e.constructor,l=+(e.s<0),p=+(t.s<0);if(l){a=i(n(e));for(var h=0;h<a.length;++h)a[h]^=1}else a=i(e);if(p){o=i(n(t));for(h=0;h<o.length;++h)o[h]^=1}else o=i(t);a.length<=o.length?(s=a,u=o,c=l):(s=o,u=a,c=p);var m=s.length,d=u.length,g=1^r(l,p),v=new f(1^g),y=new f(1),x=new f(2),w=f.precision;for(f.config({precision:1e9});m>0;)r(s[--m],u[--d])==g&&(v=v.plus(y)),y=y.times(x);for(;d>0;)r(c,u[--d])==g&&(v=v.plus(y)),y=y.times(x);return f.config({precision:w}),0==g&&(v.s=-v.s),v}},function(e,t){e.exports=function(e){if(e.isFinite()&&!e.isInteger())throw new Error("Integer expected in function bitNot");var t=e.constructor,r=t.precision;return t.config({precision:1e9}),(e=e.plus(new t(1))).s=-e.s||null,t.config({precision:r}),e}},function(e,t,r){"use strict";var n=r(11);t.name="algorithm08",t.factory=function(e,t,i,a){var o=i(r(10)),s=e.SparseMatrix;return function(e,t,r){var i=e._values,u=e._index,c=e._ptr,f=e._size,l=e._datatype,p=t._values,h=t._index,m=t._ptr,d=t._size,g=t._datatype;if(f.length!==d.length)throw new n(f.length,d.length);if(f[0]!==d[0]||f[1]!==d[1])throw new RangeError("Dimension mismatch. Matrix A ("+f+") must match Matrix B ("+d+")");if(!i||!p)throw new Error("Cannot perform operation on Pattern Sparse Matrices");var v,y=f[0],x=f[1],w=o,b=0,N=r;"string"==typeof l&&l===g&&(v=l,w=a.find(o,[v,v]),b=a.convert(0,v),N=a.find(r,[v,v]));for(var E,M,A,O,T=[],S=[],_=[],C=new s({values:T,index:S,ptr:_,size:[y,x],datatype:v}),z=[],k=[],B=0;B<x;B++){_[B]=S.length;var I=B+1;for(M=c[B],A=c[B+1],E=M;E<A;E++)k[O=u[E]]=I,z[O]=i[E],S.push(O);for(M=m[B],A=m[B+1],E=M;E<A;E++)k[O=h[E]]===I&&(z[O]=N(z[O],p[E]));for(E=_[B];E<S.length;){var P=z[O=S[E]];w(P,b)?S.splice(E,1):(T.push(P),E++)}}return _[x]=S.length,C}}},function(e,t,r){"use strict";var n=r(3).isInteger;t.name="partitionSelect",t.factory=function(e,t,i,a){var o=i(r(52));function s(e,t){return-o(e,t)}return a("partitionSelect",{"Array | Matrix, number":function(e,t){return u(e,t,o)},"Array | Matrix, number, string":function(e,t,r){if("asc"===r)return u(e,t,o);if("desc"===r)return u(e,t,s);throw new Error('Compare string must be "asc" or "desc"')},"Array | Matrix, number, function":u});function u(t,r,i){if(!n(r)||r<0)throw new Error("k must be a non-negative integer");if(e.isMatrix(t)){if(t.size().length>1)throw new Error("Only one dimensional matrices supported");return c(t.valueOf(),r,i)}if(Array.isArray(t))return c(t,r,i)}function c(e,t,r){if(t>=e.length)throw new Error("k out of bounds");for(var n=0,i=e.length-1;n<i;){for(var a=n,o=i,s=e[Math.floor(Math.random()*(i-n+1))+n];a<o;)if(r(e[a],s)>=0){var u=e[o];e[o]=e[a],e[a]=u,--o}else++a;r(e[a],s)>0&&--a,t<=a?i=a:n=a+1}return e[t]}}},function(e,t,r){"use strict";var n=r(44),i=r(48),a=r(3).isNumber;t.name="distribution",t.factory=function(e,t,o,s,u){var c=o(r(0)),f=r(2),l=o(r(493));function p(t){if(!h.hasOwnProperty(t))throw new Error("Unknown distribution "+t);var r,o,u,p,m,d,g=Array.prototype.slice.call(arguments,1),v=h[t].apply(this,g);return r=v,o={random:function(t,r,o){var s,u,f;if(arguments.length>3)throw new n("random",arguments.length,0,3);if(1===arguments.length?i(t)?s=t:f=t:2===arguments.length?i(t)?(s=t,f=r):(u=t,f=r):(s=t,u=r,f=o),void 0!==u&&!a(u)||void 0!==f&&!a(f))throw new TypeError("Invalid argument in function random");if(void 0===f&&(f=1),void 0===u&&(u=0),void 0!==s){var l=d(s.valueOf(),u,f,p);return e.isMatrix(s)?c(l):l}return p(u,f)},randomInt:s({"number | Array":function(t){if(i(t)){var r=t,n=1,a=d(r.valueOf(),0,n,m);return e.isMatrix(r)?c(a):a}return m(0,n=t)},"number | Array, number":function(t,r){if(i(t)){var n=t,a=r,o=0,s=d(n.valueOf(),o,a,m);return e.isMatrix(n)?c(s):s}return m(o=t,a=r)},"Array, number, number":function(e,t,r){var n=d(e.valueOf(),t,r,m);return e&&!0===e.isMatrix?c(n):n}}),pickRandom:s({Array:function(e){return u(e)},"Array, number | Array":function(e,t){var r,n;if(Array.isArray(t))n=t;else{if(!a(t))throw new TypeError("Invalid argument in function pickRandom");r=t}return u(e,r,n)},"Array, number | Array, Array | number":function(e,t,r){var n,i;if(Array.isArray(t)?(i=t,n=r):(i=r,n=t),!Array.isArray(i)||!a(n))throw new TypeError("Invalid argument in function pickRandom");return u(e,n,i)}})},u=function(t,r,n){var i=void 0===r;if(i&&(r=1),e.isMatrix(t))t=t.valueOf();else if(!Array.isArray(t))throw new TypeError("Unsupported type of value in function pickRandom");if(f.size(t).length>1)throw new Error("Only one dimensional vectors supported");if(void 0!==n){if(n.length!=t.length)throw new Error("Weights must have the same length as possibles");for(var o=0,s=0,u=n.length;s<u;s++){if(!a(n[s])||n[s]<0)throw new Error("Weights must be an array of positive numbers");o+=n[s]}}var c=t.length;if(0==c)return[];if(r>=c)return r>1?t:t[0];for(var p,h=[];h.length<r;){if(void 0===n)p=t[Math.floor(l()*c)];else{var m=l()*o;for(s=0,u=t.length;s<u;s++)if((m-=n[s])<0){p=t[s];break}}-1==h.indexOf(p)&&h.push(p)}return i?h[0]:h},p=function(e,t){return e+r()*(t-e)},m=function(e,t){return Math.floor(e+r()*(t-e))},d=function(e,t,r,n){var i=[];if((e=e.slice(0)).length>1)for(var a=0,o=e.shift();a<o;a++)i.push(d(e,t,r,n));else for(a=0,o=e.shift();a<o;a++)i.push(n(t,r));return i},o}var h={uniform:function(){return l},normal:function(){return function(){for(var e,t,r=-1;r<0||r>1;)e=l(),t=l(),r=1/6*Math.pow(-2*Math.log(e),.5)*Math.cos(2*Math.PI*t)+.5;return r}}};return p.toTex=void 0,p}},function(e,t,r){var n=r(156);t.mixin=function(e){var t=new n;return e.on=t.on.bind(t),e.off=t.off.bind(t),e.once=t.once.bind(t),e.emit=t.emit.bind(t),e}},function(e,t,r){var n=r(171),i=r(3).format,a=r(3).isNumber;t.name="Complex",t.path="type",t.factory=function(e,t,r,o,s){return n.prototype.type="Complex",n.prototype.isComplex=!0,n.prototype.toJSON=function(){return{mathjs:"Complex",re:this.re,im:this.im}},n.prototype.toPolar=function(){return{r:this.abs(),phi:this.arg()}},n.prototype.format=function(e){var t=this.im,r=this.re,n=i(this.re,e),o=i(this.im,e),s=a(e)?e:e?e.precision:null;if(null!==s){var u=Math.pow(10,-s);Math.abs(r/t)<u&&(r=0),Math.abs(t/r)<u&&(t=0)}return 0==t?n:0==r?1==t?"i":-1==t?"-i":o+"i":t<0?-1==t?n+" - i":n+" - "+o.substring(1)+"i":1==t?n+" + i":n+" + "+o+"i"},n.fromPolar=function(t){switch(arguments.length){case 1:var r=arguments[0];if("object"==typeof r)return n(r);throw new TypeError("Input has to be an object with r and phi keys.");case 2:var i=arguments[0],o=arguments[1];if(a(i)){if(e.isUnit(o)&&o.hasBase("ANGLE")&&(o=o.toNumber("rad")),a(o))return new n({r:i,phi:o});throw new TypeError("Phi is not a number nor an angle unit.")}throw new TypeError("Radius r is not a number.");default:throw new SyntaxError("Wrong number of arguments in function fromPolar")}},n.prototype.valueOf=n.prototype.toString,n.fromJSON=function(e){return new n(e)},n.EPSILON=t.epsilon,s.on("config",function(e,t){e.epsilon!==t.epsilon&&(n.EPSILON=e.epsilon)}),n.compare=function(e,t){return e.re>t.re?1:e.re<t.re?-1:e.im>t.im?1:e.im<t.im?-1:0},n},t.math=!0},function(e,t,r){"use strict";var n=r(1);t.name="fraction",t.factory=function(e,t,r,i){var a=i("fraction",{number:function(t){if(!isFinite(t)||isNaN(t))throw new Error(t+" cannot be represented as a fraction");return new e.Fraction(t)},string:function(t){return new e.Fraction(t)},"number, number":function(t,r){return new e.Fraction(t,r)},BigNumber:function(t){return new e.Fraction(t.toString())},Fraction:function(e){return e},Object:function(t){return new e.Fraction(t)},"Array | Matrix":function(e){return n(e,a)}});return a}},function(e,t,r){"use strict";var n=r(3);t.name="Range",t.path="type",t.factory=function(e,t,r,i){function a(t,r,n){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(null!=t)if(e.isBigNumber(t))t=t.toNumber();else if("number"!=typeof t)throw new TypeError("Parameter start must be a number");if(null!=r)if(e.isBigNumber(r))r=r.toNumber();else if("number"!=typeof r)throw new TypeError("Parameter end must be a number");if(null!=n)if(e.isBigNumber(n))n=n.toNumber();else if("number"!=typeof n)throw new TypeError("Parameter step must be a number");this.start=null!=t?parseFloat(t):0,this.end=null!=r?parseFloat(r):0,this.step=null!=n?parseFloat(n):1}return a.prototype.type="Range",a.prototype.isRange=!0,a.parse=function(e){if("string"!=typeof e)return null;var t=e.split(":").map(function(e){return parseFloat(e)});if(t.some(function(e){return isNaN(e)}))return null;switch(t.length){case 2:return new a(t[0],t[1]);case 3:return new a(t[0],t[2],t[1]);default:return null}},a.prototype.clone=function(){return new a(this.start,this.end,this.step)},a.prototype.size=function(){var e=0,t=this.start,r=this.step,i=this.end-t;return n.sign(r)==n.sign(i)?e=Math.ceil(i/r):0==i&&(e=0),isNaN(e)&&(e=0),[e]},a.prototype.min=function(){var e=this.size()[0];return e>0?this.step>0?this.start:this.start+(e-1)*this.step:void 0},a.prototype.max=function(){var e=this.size()[0];return e>0?this.step>0?this.start+(e-1)*this.step:this.start:void 0},a.prototype.forEach=function(e){var t=this.start,r=this.step,n=this.end,i=0;if(r>0)for(;t<n;)e(t,[i],this),t+=r,i++;else if(r<0)for(;t>n;)e(t,[i],this),t+=r,i++},a.prototype.map=function(e){var t=[];return this.forEach(function(r,n,i){t[n[0]]=e(r,n,i)}),t},a.prototype.toArray=function(){var e=[];return this.forEach(function(t,r){e[r[0]]=t}),e},a.prototype.valueOf=function(){return this.toArray()},a.prototype.format=function(e){var t=n.format(this.start,e);return 1!=this.step&&(t+=":"+n.format(this.step,e)),t+=":"+n.format(this.end,e)},a.prototype.toString=function(){return this.format()},a.prototype.toJSON=function(){return{mathjs:"Range",start:this.start,end:this.end,step:this.step}},a.fromJSON=function(e){return new a(e.start,e.end,e.step)},a}},function(e,t,r){"use strict";t.name="ResultSet",t.path="type",t.factory=function(e,t,r,n){function i(e){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this.entries=e||[]}return i.prototype.type="ResultSet",i.prototype.isResultSet=!0,i.prototype.valueOf=function(){return this.entries},i.prototype.toString=function(){return"["+this.entries.join(", ")+"]"},i.prototype.toJSON=function(){return{mathjs:"ResultSet",entries:this.entries}},i.fromJSON=function(e){return new i(e.entries)},i}},function(e,t,r){var n=r(32).memoize;function i(e){return e[0].precision}t.e=n(function(e){return new e(1).exp()},i),t.phi=n(function(e){return new e(1).plus(new e(5).sqrt()).div(2)},i),t.pi=n(function(e){return e.acos(-1)},i),t.tau=n(function(e){return t.pi(e).times(2)},i)},function(e,t,r){"use strict";var n=r(1);t.name="fix",t.factory=function(e,t,r,i){var a=i("fix",{number:function(e){return e>0?Math.floor(e):Math.ceil(e)},Complex:function(t){return new e.Complex(t.re>0?Math.floor(t.re):Math.ceil(t.re),t.im>0?Math.floor(t.im):Math.ceil(t.im))},BigNumber:function(e){return e.isNegative()?e.ceil():e.floor()},Fraction:function(e){return e.s<0?e.ceil():e.floor()},"Array | Matrix":function(e){return n(e,a,!0)}});return a.toTex={1:"\\mathrm{${name}}\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(3).isInteger,i=r(3).toFixed,a=r(1),o="Number of decimals in function round must be an integer";t.name="round",t.factory=function(e,t,s,u){var c=s(r(0)),f=s(r(10)),l=s(r(40)),p=s(r(19)),h=s(r(18)),m=s(r(6)),d=u("round",{number:Math.round,"number, number":function(e,t){if(!n(t))throw new TypeError(o);if(t<0||t>15)throw new Error("Number of decimals in function round must be in te range of 0-15");return parseFloat(i(e,t))},Complex:function(e){return e.round()},"Complex, number":function(e,t){if(t%1)throw new TypeError(o);return e.round(t)},"Complex, BigNumber":function(e,t){if(!t.isInteger())throw new TypeError(o);var r=t.toNumber();return e.round(r)},"number, BigNumber":function(t,r){if(!r.isInteger())throw new TypeError(o);return new e.BigNumber(t).toDecimalPlaces(r.toNumber())},BigNumber:function(e){return e.toDecimalPlaces(0)},"BigNumber, BigNumber":function(e,t){if(!t.isInteger())throw new TypeError(o);return e.toDecimalPlaces(t.toNumber())},Fraction:function(e){return e.round()},"Fraction, number":function(e,t){if(t%1)throw new TypeError(o);return e.round(t)},"Array | Matrix":function(e){return a(e,d,!0)},"Matrix, number | BigNumber":function(e,t){var r;switch(e.storage()){case"sparse":r=p(e,t,d,!1);break;default:r=m(e,t,d,!1)}return r},"number | Complex | BigNumber, Matrix":function(e,t){if(!f(e,0)){var r;switch(t.storage()){case"sparse":r=h(t,e,d,!0);break;default:r=m(t,e,d,!0)}return r}return l(t.size(),t.storage())},"Array, number | BigNumber":function(e,t){return m(c(e),t,d,!1).valueOf()},"number | Complex | BigNumber, Array":function(e,t){return m(c(t),e,d,!0).valueOf()}});return d.toTex={1:"\\left\\lfloor${args[0]}\\right\\rceil",2:void 0},d}},function(e,t,r){"use strict";var n=r(9);t.name="format",t.factory=function(e,t,r,i){var a=i("format",{any:n.format,"any, Object | function | number":n.format});return a.toTex=void 0,a}},function(e,t,r){t.name="docs",t.path="expression",t.factory=function(e,t,n,i){var a={};return a.bignumber=r(196),a.boolean=r(197),a.complex=r(198),a.createUnit=r(199),a.fraction=r(200),a.index=r(201),a.matrix=r(202),a.number=r(203),a.sparse=r(204),a.splitUnit=r(205),a.string=r(206),a.unit=r(207),a.e=r(101),a.E=r(101),a.false=r(208),a.i=r(209),a[1/0]=r(210),a.LN2=r(211),a.LN10=r(212),a.LOG2E=r(213),a.LOG10E=r(214),a.NaN=r(215),a.null=r(216),a.pi=r(102),a.PI=r(102),a.phi=r(217),a.SQRT1_2=r(218),a.SQRT2=r(219),a.tau=r(220),a.true=r(221),a.version=r(222),a.speedOfLight={description:"Speed of light in vacuum",examples:["speedOfLight"]},a.gravitationConstant={description:"Newtonian constant of gravitation",examples:["gravitationConstant"]},a.planckConstant={description:"Planck constant",examples:["planckConstant"]},a.reducedPlanckConstant={description:"Reduced Planck constant",examples:["reducedPlanckConstant"]},a.magneticConstant={description:"Magnetic constant (vacuum permeability)",examples:["magneticConstant"]},a.electricConstant={description:"Electric constant (vacuum permeability)",examples:["electricConstant"]},a.vacuumImpedance={description:"Characteristic impedance of vacuum",examples:["vacuumImpedance"]},a.coulomb={description:"Coulomb's constant",examples:["coulomb"]},a.elementaryCharge={description:"Elementary charge",examples:["elementaryCharge"]},a.bohrMagneton={description:"Borh magneton",examples:["bohrMagneton"]},a.conductanceQuantum={description:"Conductance quantum",examples:["conductanceQuantum"]},a.inverseConductanceQuantum={description:"Inverse conductance quantum",examples:["inverseConductanceQuantum"]},a.magneticFluxQuantum={description:"Magnetic flux quantum",examples:["magneticFluxQuantum"]},a.nuclearMagneton={description:"Nuclear magneton",examples:["nuclearMagneton"]},a.klitzing={description:"Von Klitzing constant",examples:["klitzing"]},a.bohrRadius={description:"Borh radius",examples:["bohrRadius"]},a.classicalElectronRadius={description:"Classical electron radius",examples:["classicalElectronRadius"]},a.electronMass={description:"Electron mass",examples:["electronMass"]},a.fermiCoupling={description:"Fermi coupling constant",examples:["fermiCoupling"]},a.fineStructure={description:"Fine-structure constant",examples:["fineStructure"]},a.hartreeEnergy={description:"Hartree energy",examples:["hartreeEnergy"]},a.protonMass={description:"Proton mass",examples:["protonMass"]},a.deuteronMass={description:"Deuteron Mass",examples:["deuteronMass"]},a.neutronMass={description:"Neutron mass",examples:["neutronMass"]},a.quantumOfCirculation={description:"Quantum of circulation",examples:["quantumOfCirculation"]},a.rydberg={description:"Rydberg constant",examples:["rydberg"]},a.thomsonCrossSection={description:"Thomson cross section",examples:["thomsonCrossSection"]},a.weakMixingAngle={description:"Weak mixing angle",examples:["weakMixingAngle"]},a.efimovFactor={description:"Efimov factor",examples:["efimovFactor"]},a.atomicMass={description:"Atomic mass constant",examples:["atomicMass"]},a.avogadro={description:"Avogadro's number",examples:["avogadro"]},a.boltzmann={description:"Boltzmann constant",examples:["boltzmann"]},a.faraday={description:"Faraday constant",examples:["faraday"]},a.firstRadiation={description:"First radiation constant",examples:["firstRadiation"]},a.loschmidt={description:"Loschmidt constant at T=273.15 K and p=101.325 kPa",examples:["loschmidt"]},a.gasConstant={description:"Gas constant",examples:["gasConstant"]},a.molarPlanckConstant={description:"Molar Planck constant",examples:["molarPlanckConstant"]},a.molarVolume={description:"Molar volume of an ideal gas at T=273.15 K and p=101.325 kPa",examples:["molarVolume"]},a.sackurTetrode={description:"Sackur-Tetrode constant at T=1 K and p=101.325 kPa",examples:["sackurTetrode"]},a.secondRadiation={description:"Second radiation constant",examples:["secondRadiation"]},a.stefanBoltzmann={description:"Stefan-Boltzmann constant",examples:["stefanBoltzmann"]},a.wienDisplacement={description:"Wien displacement law constant",examples:["wienDisplacement"]},a.molarMass={description:"Molar mass constant",examples:["molarMass"]},a.molarMassC12={description:"Molar mass constant of carbon-12",examples:["molarMassC12"]},a.gravity={description:"Standard acceleration of gravity (standard acceleration of free-fall on Earth)",examples:["gravity"]},a.planckLength={description:"Planck length",examples:["planckLength"]},a.planckMass={description:"Planck mass",examples:["planckMass"]},a.planckTime={description:"Planck time",examples:["planckTime"]},a.planckCharge={description:"Planck charge",examples:["planckCharge"]},a.planckTemperature={description:"Planck temperature",examples:["planckTemperature"]},a.derivative=r(223),a.lsolve=r(224),a.lup=r(225),a.lusolve=r(226),a.simplify=r(227),a.rationalize=r(228),a.slu=r(229),a.usolve=r(230),a.qr=r(231),a.abs=r(232),a.add=r(233),a.cbrt=r(234),a.ceil=r(235),a.cube=r(236),a.divide=r(237),a.dotDivide=r(238),a.dotMultiply=r(239),a.dotPow=r(240),a.exp=r(241),a.fix=r(242),a.floor=r(243),a.gcd=r(244),a.hypot=r(245),a.lcm=r(246),a.log=r(247),a.log10=r(248),a.mod=r(249),a.multiply=r(250),a.norm=r(251),a.nthRoot=r(252),a.pow=r(253),a.round=r(254),a.sign=r(255),a.sqrt=r(256),a.square=r(257),a.subtract=r(258),a.unaryMinus=r(259),a.unaryPlus=r(260),a.xgcd=r(261),a.bitAnd=r(262),a.bitNot=r(263),a.bitOr=r(264),a.bitXor=r(265),a.leftShift=r(266),a.rightArithShift=r(267),a.rightLogShift=r(268),a.bellNumbers=r(269),a.catalan=r(270),a.composition=r(271),a.stirlingS2=r(272),a.config=r(273),a.import=r(274),a.typed=r(275),a.arg=r(276),a.conj=r(277),a.re=r(278),a.im=r(279),a.eval=r(280),a.help=r(281),a.distance=r(282),a.intersect=r(283),a.and=r(284),a.not=r(285),a.or=r(286),a.xor=r(287),a.concat=r(288),a.cross=r(289),a.det=r(290),a.diag=r(291),a.dot=r(292),a.eye=r(293),a.filter=r(294),a.flatten=r(295),a.forEach=r(296),a.inv=r(297),a.kron=r(298),a.map=r(299),a.ones=r(300),a.partitionSelect=r(301),a.range=r(302),a.resize=r(303),a.reshape=r(304),a.size=r(305),a.sort=r(306),a.squeeze=r(307),a.subset=r(308),a.trace=r(309),a.transpose=r(310),a.zeros=r(311),a.combinations=r(312),a.factorial=r(313),a.gamma=r(314),a.kldivergence=r(315),a.multinomial=r(316),a.permutations=r(317),a.pickRandom=r(318),a.random=r(319),a.randomInt=r(320),a.compare=r(321),a.compareNatural=r(322),a.deepEqual=r(323),a.equal=r(324),a.larger=r(325),a.largerEq=r(326),a.smaller=r(327),a.smallerEq=r(328),a.unequal=r(329),a.setCartesian=r(330),a.setDifference=r(331),a.setDistinct=r(332),a.setIntersect=r(333),a.setIsSubset=r(334),a.setMultiplicity=r(335),a.setPowerset=r(336),a.setSize=r(337),a.setSymDifference=r(338),a.setUnion=r(339),a.erf=r(340),a.mad=r(341),a.max=r(342),a.mean=r(343),a.median=r(344),a.min=r(345),a.mode=r(346),a.prod=r(347),a.quantileSeq=r(348),a.std=r(349),a.sum=r(350),a.var=r(351),a.acos=r(352),a.acosh=r(353),a.acot=r(354),a.acoth=r(355),a.acsc=r(356),a.acsch=r(357),a.asec=r(358),a.asech=r(359),a.asin=r(360),a.asinh=r(361),a.atan=r(362),a.atanh=r(363),a.atan2=r(364),a.cos=r(365),a.cosh=r(366),a.cot=r(367),a.coth=r(368),a.csc=r(369),a.csch=r(370),a.sec=r(371),a.sech=r(372),a.sin=r(373),a.sinh=r(374),a.tan=r(375),a.tanh=r(376),a.to=r(377),a.clone=r(378),a.format=r(379),a.isNaN=r(380),a.isInteger=r(381),a.isNegative=r(382),a.isNumeric=r(383),a.isPositive=r(384),a.isPrime=r(385),a.isZero=r(386),a.typeof=r(387),a}},function(e,t){e.exports={name:"e",category:"Constants",syntax:["e"],description:"Euler's number, the base of the natural logarithm. Approximately equal to 2.71828",examples:["e","e ^ 2","exp(2)","log(e)"],seealso:["exp"]}},function(e,t){e.exports={name:"pi",category:"Constants",syntax:["pi"],description:"The number pi is a mathematical constant that is the ratio of a circle's circumference to its diameter, and is approximately equal to 3.14159",examples:["pi","sin(pi/2)"],seealso:["tau"]}},function(e,t,r){"use strict";var n=r(9).stringify,i=r(13).getSafeProperty;t.name="AccessorNode",t.path="expression.node",t.factory=function(e,t,a,o){var s=a(r(7)).register,u=a(r(7)).compile,c=a(r(15)),f=(a(r(78)),a(r(104)));function l(t,r){if(!(this instanceof l))throw new SyntaxError("Constructor must be called with the new operator");if(!e.isNode(t))throw new TypeError('Node expected for parameter "object"');if(!e.isIndexNode(r))throw new TypeError('IndexNode expected for parameter "index"');this.object=t||null,this.index=r,Object.defineProperty(this,"name",{get:function(){return this.index?this.index.isObjectProperty()?this.index.getObjectProperty():"":this.object.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}})}function p(t){return!(e.isAccessorNode(t)||e.isArrayNode(t)||e.isConstantNode(t)||e.isFunctionNode(t)||e.isObjectNode(t)||e.isParenthesisNode(t)||e.isSymbolNode(t))}return l.prototype=new c,l.prototype.type="AccessorNode",l.prototype.isAccessorNode=!0,s(l.prototype.type,function(e,t,r){if(!(e instanceof l))throw new TypeError("No valid AccessorNode");t.access=f,t.getSafeProperty=i;var a=u(e.object,t,r),o=u(e.index,t,r);return e.index.isObjectProperty()?"getSafeProperty("+a+", "+n(e.index.getObjectProperty())+")":e.index.needsSize()?"(function () {  var object = "+a+";  var size = math.size(object).valueOf();  return access(object, "+o+");})()":"access("+a+", "+o+")"}),l.prototype.forEach=function(e){e(this.object,"object",this),e(this.index,"index",this)},l.prototype.map=function(e){return new l(this._ifNode(e(this.object,"object",this)),this._ifNode(e(this.index,"index",this)))},l.prototype.clone=function(){return new l(this.object,this.index)},l.prototype._toString=function(e){var t=this.object.toString(e);return p(this.object)&&(t="("+t+")"),t+this.index.toString(e)},l.prototype.toHTML=function(e){var t=this.object.toHTML(e);return p(this.object)&&(t='<span class="math-parenthesis math-round-parenthesis">(</span>'+t+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+this.index.toHTML(e)},l.prototype._toTex=function(e){var t=this.object.toTex(e);return p(this.object)&&(t="\\left("+t+"\\right)"),t+this.index.toTex(e)},l}},function(e,t,r){"use strict";var n=r(42).transform,i=r(13).getSafeProperty;t.factory=function(e,t,a,o){var s=a(r(23));return function(e,t){try{if(Array.isArray(e))return s(e,t);if(e&&"function"==typeof e.subset)return e.subset(t);if("string"==typeof e)return s(e,t);if("object"==typeof e){if(!t.isObjectProperty())throw new TypeError("Cannot apply a numeric index as object property");return i(e,t.getObjectProperty())}throw new TypeError("Cannot apply index: unsupported type of object")}catch(e){throw n(e)}}}},function(e,t,r){"use strict";r(4);var n=r(9).stringify,i=r(13).getSafeProperty,a=r(13).setSafeProperty;t.name="AssignmentNode",t.path="expression.node",t.factory=function(e,t,o,s){var u=o(r(7)).register,c=o(r(7)).compile,f=o(r(15)),l=(o(r(80)),o(r(0)),o(r(390))),p=o(r(104)),h=(r(77),r(54));function m(t,r,n){if(!(this instanceof m))throw new SyntaxError("Constructor must be called with the new operator");if(this.object=t,this.index=n?r:null,this.value=n||r,!e.isSymbolNode(t)&&!e.isAccessorNode(t))throw new TypeError('SymbolNode or AccessorNode expected as "object"');if(e.isSymbolNode(t)&&"end"===t.name)throw new Error('Cannot assign to symbol "end"');if(this.index&&!e.isIndexNode(this.index))throw new TypeError('IndexNode expected as "index"');if(!e.isNode(this.value))throw new TypeError('Node expected as "value"');Object.defineProperty(this,"name",{get:function(){return this.index?this.index.isObjectProperty()?this.index.getObjectProperty():"":this.object.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}})}function d(e,t){t||(t="keep");var r=h.getPrecedence(e,t),n=h.getPrecedence(e.value,t);return"all"===t||null!==n&&n<=r}return m.prototype=new f,m.prototype.type="AssignmentNode",m.prototype.isAssignmentNode=!0,u(m.prototype.type,function(t,r,o){if(!(t instanceof m))throw new TypeError("No valid AssignmentNode");var s;r.assign=l,r.access=p,r.getSafeProperty=i,r.setSafeProperty=a;var u=c(t.object,r,o),f=t.index?c(t.index,r,o):null,h=c(t.value,r,o),d=n(t.object.name);if(t.index){if(t.index.isObjectProperty())return"setSafeProperty("+u+", "+n(t.index.getObjectProperty())+", "+h+")";if(e.isSymbolNode(t.object))return"(function () {  var object = "+u+";  var value = "+h+";  "+(s=t.index.needsSize()?"var size = math.size(object).valueOf();":"")+"  setSafeProperty(scope, "+d+", assign(object, "+f+", value));  return value;})()";s=t.index.needsSize()?"var size = math.size(object).valueOf();":"";var g=c(t.object.object,r,o);if(t.object.index.isObjectProperty()){var v=n(t.object.index.getObjectProperty());return"(function () {  var parent = "+g+";  var object = getSafeProperty(parent, "+v+");  var value = "+h+";"+s+"  setSafeProperty(parent, "+v+", assign(object, "+f+", value));  return value;})()"}return"(function () {  var parent = "+g+";  "+(t.object.index.needsSize()?"var size = math.size(parent).valueOf();":"")+"  var parentIndex = "+c(t.object.index,r,o)+";  var object = access(parent, parentIndex);  var value = "+h+";  "+s+"  assign(parent, parentIndex, assign(object, "+f+", value));  return value;})()"}if(!e.isSymbolNode(t.object))throw new TypeError("SymbolNode expected as object");return"setSafeProperty(scope, "+d+", "+h+")"}),m.prototype.forEach=function(e){e(this.object,"object",this),this.index&&e(this.index,"index",this),e(this.value,"value",this)},m.prototype.map=function(e){return new m(this._ifNode(e(this.object,"object",this)),this.index?this._ifNode(e(this.index,"index",this)):null,this._ifNode(e(this.value,"value",this)))},m.prototype.clone=function(){return new m(this.object,this.index,this.value)},m.prototype._toString=function(e){var t=this.object.toString(e),r=this.index?this.index.toString(e):"",n=this.value.toString(e);return d(this,e&&e.parenthesis)&&(n="("+n+")"),t+r+" = "+n},m.prototype.toHTML=function(e){var t=this.object.toHTML(e),r=this.index?this.index.toHTML(e):"",n=this.value.toHTML(e);return d(this,e&&e.parenthesis)&&(n='<span class="math-paranthesis math-round-parenthesis">(</span>'+n+'<span class="math-paranthesis math-round-parenthesis">)</span>'),t+r+'<span class="math-operator math-assignment-operator math-variable-assignment-operator math-binary-operator">=</span>'+n},m.prototype._toTex=function(e){var t=this.object.toTex(e),r=this.index?this.index.toTex(e):"",n=this.value.toTex(e);return d(this,e&&e.parenthesis)&&(n="\\left("+n+"\\right)"),t+r+":="+n},m}},function(e,t,r){"use strict";var n=r(2).map,i=r(2).join;t.name="BlockNode",t.path="expression.node",t.factory=function(e,t,a,o){var s=a(r(7)).register,u=a(r(7)).compile,c=a(r(15)),f=a(r(95));function l(t){if(!(this instanceof l))throw new SyntaxError("Constructor must be called with the new operator");if(!Array.isArray(t))throw new Error("Array expected");this.blocks=t.map(function(t){var r=t&&t.node,n=!t||void 0===t.visible||t.visible;if(!e.isNode(r))throw new TypeError('Property "node" must be a Node');if("boolean"!=typeof n)throw new TypeError('Property "visible" must be a boolean');return{node:r,visible:n}})}return l.prototype=new c,l.prototype.type="BlockNode",l.prototype.isBlockNode=!0,s(l.prototype.type,function(e,t,r){if(!(e instanceof l))throw new TypeError("No valid BlockNode");t.ResultSet=f;var a=n(e.blocks,function(e){var n=u(e.node,t,r);return e.visible?"results.push("+n+");":n+";"});return"(function () {var results = [];"+i(a,"")+"return new ResultSet(results);})()"}),l.prototype.forEach=function(e){for(var t=0;t<this.blocks.length;t++)e(this.blocks[t].node,"blocks["+t+"].node",this)},l.prototype.map=function(e){for(var t=[],r=0;r<this.blocks.length;r++){var n=this.blocks[r],i=this._ifNode(e(n.node,"blocks["+r+"].node",this));t[r]={node:i,visible:n.visible}}return new l(t)},l.prototype.clone=function(){return new l(this.blocks.map(function(e){return{node:e.node,visible:e.visible}}))},l.prototype._toString=function(e){return this.blocks.map(function(t){return t.node.toString(e)+(t.visible?"":";")}).join("\n")},l.prototype.toHTML=function(e){return this.blocks.map(function(t){return t.node.toHTML(e)+(t.visible?"":'<span class="math-separator">;</span>')}).join('<span class="math-separator"><br /></span>')},l.prototype._toTex=function(e){return this.blocks.map(function(t){return t.node.toTex(e)+(t.visible?"":";")}).join("\\;\\;\n")},l}},function(e,t,r){"use strict";r(4);var n=r(54);t.name="ConditionalNode",t.path="expression.node",t.factory=function(e,t,i,a){var o=i(r(7)).register,s=i(r(7)).compile,u=i(r(15));function c(t,r,n){if(!(this instanceof c))throw new SyntaxError("Constructor must be called with the new operator");if(!e.isNode(t))throw new TypeError("Parameter condition must be a Node");if(!e.isNode(r))throw new TypeError("Parameter trueExpr must be a Node");if(!e.isNode(n))throw new TypeError("Parameter falseExpr must be a Node");this.condition=t,this.trueExpr=r,this.falseExpr=n}return c.prototype=new u,c.prototype.type="ConditionalNode",c.prototype.isConditionalNode=!0,o(c.prototype.type,function(t,r,n){if(!(t instanceof c))throw new TypeError("No valid ConditionalNode");return r.testCondition=function(t){if("number"==typeof t||"boolean"==typeof t||"string"==typeof t)return!!t;if(t){if(e.isBigNumber(t))return!t.isZero();if(e.isComplex(t))return!(!t.re&&!t.im);if(e.isUnit(t))return!!t.value}if(null===t||void 0===t)return!1;throw new TypeError('Unsupported type of condition "'+r.math.typeof(t)+'"')},"testCondition("+s(t.condition,r,n)+") ? ( "+s(t.trueExpr,r,n)+") : ( "+s(t.falseExpr,r,n)+")"}),c.prototype.forEach=function(e){e(this.condition,"condition",this),e(this.trueExpr,"trueExpr",this),e(this.falseExpr,"falseExpr",this)},c.prototype.map=function(e){return new c(this._ifNode(e(this.condition,"condition",this)),this._ifNode(e(this.trueExpr,"trueExpr",this)),this._ifNode(e(this.falseExpr,"falseExpr",this)))},c.prototype.clone=function(){return new c(this.condition,this.trueExpr,this.falseExpr)},c.prototype._toString=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=n.getPrecedence(this,t),i=this.condition.toString(e),a=n.getPrecedence(this.condition,t);("all"===t||"OperatorNode"===this.condition.type||null!==a&&a<=r)&&(i="("+i+")");var o=this.trueExpr.toString(e),s=n.getPrecedence(this.trueExpr,t);("all"===t||"OperatorNode"===this.trueExpr.type||null!==s&&s<=r)&&(o="("+o+")");var u=this.falseExpr.toString(e),c=n.getPrecedence(this.falseExpr,t);return("all"===t||"OperatorNode"===this.falseExpr.type||null!==c&&c<=r)&&(u="("+u+")"),i+" ? "+o+" : "+u},c.prototype.toHTML=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=n.getPrecedence(this,t),i=this.condition.toHTML(e),a=n.getPrecedence(this.condition,t);("all"===t||"OperatorNode"===this.condition.type||null!==a&&a<=r)&&(i='<span class="math-parenthesis math-round-parenthesis">(</span>'+i+'<span class="math-parenthesis math-round-parenthesis">)</span>');var o=this.trueExpr.toHTML(e),s=n.getPrecedence(this.trueExpr,t);("all"===t||"OperatorNode"===this.trueExpr.type||null!==s&&s<=r)&&(o='<span class="math-parenthesis math-round-parenthesis">(</span>'+o+'<span class="math-parenthesis math-round-parenthesis">)</span>');var u=this.falseExpr.toHTML(e),c=n.getPrecedence(this.falseExpr,t);return("all"===t||"OperatorNode"===this.falseExpr.type||null!==c&&c<=r)&&(u='<span class="math-parenthesis math-round-parenthesis">(</span>'+u+'<span class="math-parenthesis math-round-parenthesis">)</span>'),i+'<span class="math-operator math-conditional-operator">?</span>'+o+'<span class="math-operator math-conditional-operator">:</span>'+u},c.prototype._toTex=function(e){return"\\begin{cases} {"+this.trueExpr.toTex(e)+"}, &\\quad{\\text{if }\\;"+this.condition.toTex(e)+"}\\\\{"+this.falseExpr.toTex(e)+"}, &\\quad{\\text{otherwise}}\\end{cases}"},c}},function(e,t,r){"use strict";var n=r(77),i=r(9).stringify,a=r(9).escape,o=r(2).map,s=r(2).join,u=r(4),c=r(54),f=r(13).setSafeProperty,l=r(109);t.name="FunctionAssignmentNode",t.path="expression.node",t.factory=function(e,t,p,h){var m=p(r(7)).register,d=p(r(7)).compile,g=p(r(15));function v(t,r,i){if(!(this instanceof v))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof t)throw new TypeError('String expected for parameter "name"');if(!Array.isArray(r))throw new TypeError('Array containing strings or objects expected for parameter "params"');if(!e.isNode(i))throw new TypeError('Node expected for parameter "expr"');if(t in n)throw new Error('Illegal function name, "'+t+'" is a reserved keyword');this.name=t,this.params=r.map(function(e){return e&&e.name||e}),this.types=r.map(function(e){return e&&e.type||"any"}),this.expr=i}function y(e,t){var r=c.getPrecedence(e,t),n=c.getPrecedence(e.expr,t);return"all"===t||null!==n&&n<=r}return v.prototype=new g,v.prototype.type="FunctionAssignmentNode",v.prototype.isFunctionAssignmentNode=!0,m(v.prototype.type,function(e,t,r){if(!(e instanceof v))throw new TypeError("No valid FunctionAssignmentNode");t.typed=h,t.setSafeProperty=f;var n=Object.create(r),a=o(e.params,function(e){return n[e]=l(n),n[e]}),u=d(e.expr,t,n),c=i(e.name);return"setSafeProperty(scope, "+c+",   (function () {    var fn = typed("+c+", {      "+i(s(e.types,","))+": function ("+s(a,",")+") {        return "+u+"      }    });    fn.syntax = "+i(e.name+"("+s(e.params,", ")+")")+";    return fn;  })())"}),v.prototype.forEach=function(e){e(this.expr,"expr",this)},v.prototype.map=function(e){var t=this._ifNode(e(this.expr,"expr",this));return new v(this.name,this.params.slice(0),t)},v.prototype.clone=function(){return new v(this.name,this.params.slice(0),this.expr)},v.prototype._toString=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=this.expr.toString(e);return y(this,t)&&(r="("+r+")"),this.name+"("+this.params.join(", ")+") = "+r},v.prototype.toHTML=function(e){for(var t=e&&e.parenthesis?e.parenthesis:"keep",r=[],n=0;n<this.params.length;n++)r.push('<span class="math-symbol math-parameter">'+a(this.params[n])+"</span>");var i=this.expr.toHTML(e);return y(this,t)&&(i='<span class="math-parenthesis math-round-parenthesis">(</span>'+i+'<span class="math-parenthesis math-round-parenthesis">)</span>'),'<span class="math-function">'+a(this.name)+'</span><span class="math-parenthesis math-round-parenthesis">(</span>'+r.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-round-parenthesis">)</span><span class="math-operator math-assignment-operator math-variable-assignment-operator math-binary-operator">=</span>'+i},v.prototype._toTex=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=this.expr.toTex(e);return y(this,t)&&(r="\\left("+r+"\\right)"),"\\mathrm{"+this.name+"}\\left("+this.params.map(u.toSymbol).join(",")+"\\right):="+r},v}},function(e,t){e.exports=function(e){return"arg"+Object.keys(e).length}},function(e,t,r){"use strict";var n=r(9).stringify,i=r(9).escape,a=r(13).isSafeProperty,o=r(5).hasOwnProperty;t.name="ObjectNode",t.path="expression.node",t.factory=function(e,t,s,u){var c=s(r(7)).register,f=s(r(7)).compile,l=s(r(15));function p(t){if(!(this instanceof p))throw new SyntaxError("Constructor must be called with the new operator");if(this.properties=t||{},t&&("object"!=typeof t||!Object.keys(t).every(function(r){return e.isNode(t[r])})))throw new TypeError("Object containing Nodes expected")}return p.prototype=new l,p.prototype.type="ObjectNode",p.prototype.isObjectNode=!0,c(p.prototype.type,function(e,t,r){if(!(e instanceof p))throw new TypeError("No valid ObjectNode");var i=[];for(var s in e.properties)if(o(e.properties,s)){var u=n(s),c=JSON.parse(u);if(!a(e.properties,c))throw new Error('No access to property "'+c+'"');i.push(u+": "+f(e.properties[s],t,r))}return"{"+i.join(", ")+"}"}),p.prototype.forEach=function(e){for(var t in this.properties)this.properties.hasOwnProperty(t)&&e(this.properties[t],"properties["+n(t)+"]",this)},p.prototype.map=function(e){var t={};for(var r in this.properties)this.properties.hasOwnProperty(r)&&(t[r]=this._ifNode(e(this.properties[r],"properties["+n(r)+"]",this)));return new p(t)},p.prototype.clone=function(){var e={};for(var t in this.properties)this.properties.hasOwnProperty(t)&&(e[t]=this.properties[t]);return new p(e)},p.prototype._toString=function(e){var t=[];for(var r in this.properties)this.properties.hasOwnProperty(r)&&t.push(n(r)+": "+this.properties[r].toString(e));return"{"+t.join(", ")+"}"},p.prototype.toHTML=function(e){var t=[];for(var r in this.properties)this.properties.hasOwnProperty(r)&&t.push('<span class="math-symbol math-property">'+i(r)+'</span><span class="math-operator math-assignment-operator math-property-assignment-operator math-binary-operator">:</span>'+this.properties[r].toHTML(e));return'<span class="math-parenthesis math-curly-parenthesis">{</span>'+t.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-curly-parenthesis">}</span>'},p.prototype._toTex=function(e){var t=[];for(var r in this.properties)this.properties.hasOwnProperty(r)&&t.push("\\mathbf{"+r+":} & "+this.properties[r].toTex(e)+"\\\\");return"\\left\\{\\begin{array}{ll}"+t.join("\n")+"\\end{array}\\right\\}"},p}},function(e,t,r){"use strict";t.name="parse",t.factory=function(e,t,n,i){var a=n(r(41));return i("parse",{"string | Array | Matrix":a,"string | Array | Matrix, Object":a})}},function(e,t,r){"use strict";t.name="parser",t.factory=function(e,t,n,i,a){var o=n(r(113));return i("parser",{"":function(){return new o(a)}})},t.math=!0},function(e,t,r){"use strict";var n=r(5).extend,i=r(13);t.name="Parser",t.path="expression",t.factory=function(e,t,a,o,s){var u=a(r(41));function c(){if(!(this instanceof c))throw new SyntaxError("Constructor must be called with the new operator");this.scope={}}return c.prototype.type="Parser",c.prototype.isParser=!0,c.prototype.parse=function(e){throw new Error("Parser.parse is deprecated. Use math.parse instead.")},c.prototype.compile=function(e){throw new Error("Parser.compile is deprecated. Use math.compile instead.")},c.prototype.eval=function(e){return u(e).compile().eval(this.scope)},c.prototype.get=function(e){return e in this.scope?i.getSafeProperty(this.scope,e):void 0},c.prototype.getAll=function(){return n({},this.scope)},c.prototype.set=function(e,t){return i.setSafeProperty(this.scope,e,t)},c.prototype.remove=function(e){delete this.scope[e]},c.prototype.clear=function(){for(var e in this.scope)this.scope.hasOwnProperty(e)&&delete this.scope[e]},c},t.math=!0},function(e,t,r){"use strict";var n=r(43),i=r(65),a=r(66);t.name="max",t.factory=function(e,t,o,s){var u=o(r(34)),c=s("max",{"Array | Matrix":l,"Array | Matrix, number | BigNumber":function(e,t){return i(e,t.valueOf(),f)},"...":function(e){if(a(e))throw new TypeError("Scalar values expected in function max");return l(e)}});return c.toTex="\\max\\left(${args}\\right)",c;function f(e,t){return u(e,t)?e:t}function l(e){var t=void 0;if(n(e,function(e){(void 0===t||u(e,t))&&(t=e)}),void 0===t)throw new Error("Cannot calculate max of an empty array");return t}}},function(e,t,r){"use strict";var n=r(2).size,i=r(43),a=r(65),o=r(66);t.name="mean",t.factory=function(e,t,s,u){var c=s(r(20)),f=s(r(49)),l=u("mean",{"Array | Matrix":p,"Array | Matrix, number | BigNumber":function(e,t){var r=a(e,t,c),i=Array.isArray(e)?n(e):e.size();return f(r,i[t])},"...":function(e){if(o(e))throw new TypeError("Scalar values expected in function mean");return p(e)}});return l.toTex=void 0,l;function p(e){var t=0,r=0;if(i(e,function(e){t=c(t,e),r++}),0===r)throw new Error("Cannot calculate mean of an empty array");return f(t,r)}}},function(e,t,r){"use strict";var n=r(25);t.name="inv",t.factory=function(e,t,i,a){var o=i(r(0)),s=i(r(14)),u=i(r(16)),c=i(r(12)),f=i(r(35)),l=i(r(117)),p=i(r(62)),h=a("inv",{"Array | Matrix":function(t){var r=e.isMatrix(t)?t.size():n.array.size(t);switch(r.length){case 1:if(1==r[0])return e.isMatrix(t)?o([s(1,t.valueOf()[0])]):[s(1,t[0])];throw new RangeError("Matrix must be square (size: "+n.string.format(r)+")");case 2:var i=r[0],a=r[1];if(i==a)return e.isMatrix(t)?o(m(t.valueOf(),i,a),t.storage()):m(t,i,a);throw new RangeError("Matrix must be square (size: "+n.string.format(r)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+n.string.format(r)+")")}},any:function(e){return s(1,e)}});function m(e,t,r){var n,i,a,o,h;if(1==t){if(0==(o=e[0][0]))throw Error("Cannot calculate inverse, determinant is zero");return[[s(1,o)]]}if(2==t){var m=l(e);if(0==m)throw Error("Cannot calculate inverse, determinant is zero");return[[s(e[1][1],m),s(f(e[0][1]),m)],[s(f(e[1][0]),m),s(e[0][0],m)]]}var d=e.concat();for(n=0;n<t;n++)d[n]=d[n].concat();for(var g=p(t).valueOf(),v=0;v<r;v++){for(n=v;n<t&&0==d[n][v];)n++;if(n==t||0==d[n][v])throw Error("Cannot calculate inverse, determinant is zero");n!=v&&(h=d[v],d[v]=d[n],d[n]=h,h=g[v],g[v]=g[n],g[n]=h);var y=d[v],x=g[v];for(n=0;n<t;n++){var w=d[n],b=g[n];if(n!=v){if(0!=w[v]){for(a=s(f(w[v]),y[v]),i=v;i<r;i++)w[i]=u(w[i],c(a,y[i]));for(i=0;i<r;i++)b[i]=u(b[i],c(a,x[i]))}}else{for(a=y[v],i=v;i<r;i++)w[i]=s(w[i],a);for(i=0;i<r;i++)b[i]=s(b[i],a)}}}return g}return h.toTex={1:"\\left(${args[0]}\\right)^{-1}"},h}},function(e,t,r){"use strict";var n=r(25),i=n.object,a=n.string;t.name="det",t.factory=function(e,t,n,o){var s=n(r(0)),u=n(r(20)),c=n(r(21)),f=n(r(12)),l=n(r(35)),p=o("det",{any:function(e){return i.clone(e)},"Array | Matrix":function(t){var r;switch((r=e.isMatrix(t)?t.size():Array.isArray(t)?(t=s(t)).size():[]).length){case 0:return i.clone(t);case 1:if(1==r[0])return i.clone(t.valueOf()[0]);throw new RangeError("Matrix must be square (size: "+a.format(r)+")");case 2:var n=r[0],o=r[1];if(n==o)return function(e,t,r){if(1==t)return i.clone(e[0][0]);if(2==t)return c(f(e[0][0],e[1][1]),f(e[1][0],e[0][1]));for(var n=function(e){var t,r,n=new Array(e.length),i=0;for(t=1;t<e.length;t++)i=u(i,e[t][t]);for(t=0;t<e.length;t++){for(n[t]=new Array(e.length),n[t][t]=l(i),r=0;r<t;r++)n[t][r]=0;for(r=t+1;r<e.length;r++)n[t][r]=e[t][r];t+1<e.length&&(i=c(i,e[t+1][t+1]))}return n},a=e,o=0;o<t-1;o++)a=f(n(a),e);return t%2==0?l(a[0][0]):a[0][0]}(t.clone().valueOf(),n);throw new RangeError("Matrix must be square (size: "+a.format(r)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+a.format(r)+")")}}});return p.toTex={1:"\\det\\left(${args[0]}\\right)"},p}},function(e,t,r){"use strict";var n=r(43),i=r(65),a=r(66);t.name="min",t.factory=function(e,t,o,s){var u=o(r(39)),c=s("min",{"Array | Matrix":l,"Array | Matrix, number | BigNumber":function(e,t){return i(e,t.valueOf(),f)},"...":function(e){if(a(e))throw new TypeError("Scalar values expected in function min");return l(e)}});return c.toTex="\\min\\left(${args}\\right)",c;function f(e,t){return u(e,t)?e:t}function l(e){var t=void 0;if(n(e,function(e){(void 0===t||u(e,t))&&(t=e)}),void 0===t)throw new Error("Cannot calculate min of an empty array");return t}}},function(e,t,r){"use strict";t.name="range",t.factory=function(e,t,n,i){var a=n(r(0)),o=new e.BigNumber(0),s=new e.BigNumber(1),u=i("range",{string:f,"string, boolean":f,"number, number":function(e,t){return c(l(e,t,1))},"number, number, number":function(e,t,r){return c(l(e,t,r))},"number, number, boolean":function(e,t,r){return c(r?p(e,t,1):l(e,t,1))},"number, number, number, boolean":function(e,t,r,n){return c(n?p(e,t,r):l(e,t,r))},"BigNumber, BigNumber":function(e,t){return c(h(e,t,s))},"BigNumber, BigNumber, BigNumber":function(e,t,r){return c(h(e,t,r))},"BigNumber, BigNumber, boolean":function(e,t,r){return c(r?m(e,t,s):h(e,t,s))},"BigNumber, BigNumber, BigNumber, boolean":function(e,t,r,n){return c(n?m(e,t,r):h(e,t,r))}});return u.toTex=void 0,u;function c(e){return"Array"===t.matrix?e:a(e)}function f(r,n){var i=function(e){var t=e.split(":").map(function(e){return Number(e)});if(t.some(function(e){return isNaN(e)}))return null;switch(t.length){case 2:return{start:t[0],end:t[1],step:1};case 3:return{start:t[0],end:t[2],step:t[1]};default:return null}}(r);if(!i)throw new SyntaxError('String "'+r+'" is no valid range');return"BigNumber"===t.number?c((n?m:h)(new e.BigNumber(i.start),new e.BigNumber(i.end),new e.BigNumber(i.step))):c((n?p:l)(i.start,i.end,i.step))}function l(e,t,r){var n=[],i=e;if(r>0)for(;i<t;)n.push(i),i+=r;else if(r<0)for(;i>t;)n.push(i),i+=r;return n}function p(e,t,r){var n=[],i=e;if(r>0)for(;i<=t;)n.push(i),i+=r;else if(r<0)for(;i>=t;)n.push(i),i+=r;return n}function h(e,t,r){var n=[],i=e;if(r.gt(o))for(;i.lt(t);)n.push(i),i=i.plus(r);else if(r.lt(o))for(;i.gt(t);)n.push(i),i=i.plus(r);return n}function m(e,t,r){var n=[],i=e;if(r.gt(o))for(;i.lte(t);)n.push(i),i=i.plus(r);else if(r.lt(o))for(;i.gte(t);)n.push(i),i=i.plus(r);return n}}},function(e,t,r){"use strict";r(3).digits;t.math=!0,t.name="simplifyConstant",t.path="algebra.simplify",t.factory=function(e,t,n,i,a){var o=n(r(121)),s=o.isCommutative,u=o.isAssociative,c=o.allChildren,f=o.createMakeNodeFunction,l=a.expression.node.ConstantNode,p=a.expression.node.OperatorNode,h=a.expression.node.FunctionNode;function m(t,r){try{return v(a[t].apply(null,r))}catch(n){return r=r.map(function(t){return e.isFraction(t)?t.valueOf():t}),v(a[t].apply(null,r))}}var d=i({Fraction:function(e){var t,r=e.s*e.n;return t=r<0?new p("-","unaryMinus",[new l(-r)]):new l(r),1===e.d?t:new p("/","divide",[t,new l(e.d)])},number:function(e){return e<0?y(new l(-e)):new l(e)},BigNumber:function(e){return e<0?y(new l(e.negated().toString(),"number")):new l(e.toString(),"number")},Complex:function(e){throw"Cannot convert Complex number to Node"}});function g(e){if(isFinite(e)){var t=a.fraction(e);if(t.valueOf()===e)return t}return e}var v=i({string:function(e){return"BigNumber"===t.number?a.bignumber(e):"Fraction"===t.number?a.fraction(e):g(parseFloat(e))},Fraction:function(e){return e},BigNumber:function(e){return e},number:function(e){return g(e)},Complex:function(e){return 0!==e.im?e:g(e.re)}});function y(e){return new p("-","unaryMinus",[e])}function x(t,r,n){return r.reduce(function(r,i){if(e.isNode(r)||e.isNode(i))e.isNode(r)?e.isNode(i)||(i=d(i)):r=d(r);else{try{return m(t,[r,i])}catch(e){}r=d(r),i=d(i)}return n([r,i])})}function w(t){switch(t.type){case"SymbolNode":return t;case"ConstantNode":return"number"===t.valueType?v(t.value):t;case"FunctionNode":if(a[t.name]&&a[t.name].rawArgs)return t;if(-1===["add","multiply"].indexOf(t.name)){if(!(r=t.args.map(w)).some(e.isNode))try{return m(t.name,r)}catch(e){}return r=r.map(function(t){return e.isNode(t)?t:d(t)}),new h(t.name,r)}case"OperatorNode":var r,n,i=t.fn.toString(),o=f(t);if(1===t.args.length)r=[w(t.args[0])],n=e.isNode(r[0])?o(r):m(i,r);else if(u(t))if(r=(r=c(t)).map(w),s(i)){for(var l=[],p=[],g=0;g<r.length;g++)e.isNode(r[g])?p.push(r[g]):l.push(r[g]);l.length>1?(n=x(i,l,o),p.unshift(n),n=x(i,p,o)):n=x(i,r,o)}else n=x(i,r,o);else n=x(i,r=t.args.map(w),o);return n;case"ParenthesisNode":return w(t.content);case"AccessorNode":case"ArrayNode":case"AssignmentNode":case"BlockNode":case"FunctionAssignmentNode":case"IndexNode":case"ObjectNode":case"RangeNode":case"UpdateNode":case"ConditionalNode":default:throw"Unimplemented node type in simplifyConstant: "+t.type}}return function(t){var r=w(t);return e.isNode(r)?r:d(r)}}},function(e,t,r){"use strict";t.factory=function(e,t,r,n,i){var a=i.expression.node.FunctionNode,o=i.expression.node.OperatorNode,s=i.expression.node.SymbolNode,u={add:!0,multiply:!0},c={add:!0,multiply:!0};function f(t,r){if(!e.isOperatorNode(t))return!1;var n=t.fn.toString();return r&&r.hasOwnProperty(n)&&r[n].hasOwnProperty("associative")?r[n].associative:c[n]||!1}function l(t){var r,n=[],i=function(t){for(var a=0;a<t.args.length;a++){var o=t.args[a];e.isOperatorNode(o)&&r===o.op?i(o):n.push(o)}};return f(t)?(r=t.op,i(t),n):t.args}function p(t){return e.isOperatorNode(t)?function(e){try{return new o(t.op,t.fn,e)}catch(e){return console.error(e),[]}}:function(e){return new a(new s(t.name),e)}}return{createMakeNodeFunction:p,isCommutative:function(t,r){if(!e.isOperatorNode(t))return!0;var n=t.fn.toString();return r&&r.hasOwnProperty(n)&&r[n].hasOwnProperty("commutative")?r[n].commutative:u[n]||!1},isAssociative:f,flatten:function e(t){if(!t.args||0===t.args.length)return t;t.args=l(t);for(var r=0;r<t.args.length;r++)e(t.args[r])},allChildren:l,unflattenr:function e(t){if(t.args&&0!==t.args.length){for(var r=p(t),n=t.args.length,i=0;i<n;i++)e(t.args[i]);if(n>2&&f(t)){for(var a=t.args.pop();t.args.length>0;)a=r([t.args.pop(),a]);t.args=a.args}}},unflattenl:function e(t){if(t.args&&0!==t.args.length){for(var r=p(t),n=t.args.length,i=0;i<n;i++)e(t.args[i]);if(n>2&&f(t)){for(var a=t.args.shift();t.args.length>0;)a=r([a,t.args.shift()]);t.args=a.args}}}}},t.math=!0},function(e,t,r){"use strict";t.math=!0,t.name="simplifyCore",t.path="algebra.simplify",t.factory=function(e,t,r,n,i){var a=i.expression.node.ConstantNode,o=i.expression.node.OperatorNode,s=i.expression.node.FunctionNode,u=i.expression.node.ParenthesisNode,c=new a(0),f=new a(1);return function t(r){if(e.isOperatorNode(r)&&r.args.length<=2){var n=t(r.args[0]),l=r.args[1]&&t(r.args[1]);if("+"===r.op){if(1===r.args.length)return r.args[0];if(e.isConstantNode(n)){if("0"===n.value)return l;if(e.isConstantNode(l)&&n.value&&n.value.length<5&&l.value&&l.value.length<5)return new a(Number(n.value)+Number(l.value))}return e.isConstantNode(l)&&"0"===l.value?n:2===r.args.length&&e.isOperatorNode(l)&&"-"===l.op&&"unaryMinus"===l.fn?new o("-","subtract",[n,l.args[0]]):new o(r.op,r.fn,l?[n,l]:[n])}if("-"===r.op){if(e.isConstantNode(n)&&l){if(e.isConstantNode(l)&&n.value&&n.value.length<5&&l.value&&l.value.length<5)return new a(Number(n.value)-Number(l.value));if("0"===n.value)return new o("-","unaryMinus",[l])}if("subtract"===r.fn&&2===r.args.length)return e.isConstantNode(l)&&"0"===l.value?n:e.isOperatorNode(l)&&"unaryMinus"===l.fn?t(new o("+","add",[n,l.args[0]])):new o(r.op,r.fn,[n,l]);if("unaryMinus"===r.fn){if(e.isOperatorNode(n)){if("unaryMinus"===n.fn)return n.args[0];if("subtract"===n.fn)return new o("-","subtract",[n.args[1],n.args[0]])}return new o(r.op,r.fn,[n])}throw new Error("never happens")}if("*"===r.op){if(e.isConstantNode(n)){if("0"===n.value)return c;if("1"===n.value)return l;if(e.isConstantNode(l)&&n.value&&n.value.length<5&&l.value&&l.value.length<5)return new a(Number(n.value)*Number(l.value))}if(e.isConstantNode(l)){if("0"===l.value)return c;if("1"===l.value)return n;if(e.isOperatorNode(n)&&n.op===r.op){var p=n.args[0];if(e.isConstantNode(p)&&l.value&&l.value.length<5&&p.value&&p.value.length<5){var h=new a(Number(n.args[0].value)*Number(l.value));return new o(r.op,r.fn,[h,n.args[1]])}}return new o(r.op,r.fn,[l,n])}return new o(r.op,r.fn,[n,l])}if("/"===r.op){if(e.isConstantNode(n)){if("0"===n.value)return c;if(e.isConstantNode(l)&&n.value&&n.value.length<5&&("1"===l.value||"2"===l.value||"4"===l.value))return new a(Number(n.value)/Number(l.value))}return new o(r.op,r.fn,[n,l])}if("^"===r.op){if(e.isConstantNode(l)){if("0"===l.value)return f;if("1"===l.value)return n;if(e.isConstantNode(n)&&n.value&&n.value.length<5&&l.value&&l.value.length<2)return new a(i.pow(Number(n.value),Number(l.value)));if(e.isOperatorNode(n)&&"^"===n.op){var m=n.args[1];if(e.isConstantNode(m))return new o(r.op,r.fn,[n.args[0],new a(m.value*l.value)])}}return new o(r.op,r.fn,[n,l])}}else{if(e.isParenthesisNode(r)){var d=t(r.content);return e.isParenthesisNode(d)||e.isSymbolNode(d)||e.isConstantNode(d)?d:new u(d)}if(e.isFunctionNode(r)){var g=r.args.map(t);return 1===g.length&&e.isParenthesisNode(g[0])&&(g[0]=g[0].content),new s(t(r.fn),g)}}return r}}},function(e,t,r){"use strict";var n=r(5);t.name="clone",t.factory=function(e,t,r,i){var a=i("clone",{any:n.clone});return a.toTex=void 0,a}},function(e,t,r){"use strict";var n=r(3).nearlyEqual,i=r(37);t.name="unequal",t.factory=function(e,t,a,o){var s=a(r(0)),u=a(r(17)),c=a(r(26)),f=a(r(18)),l=a(r(8)),p=a(r(6)),h=r(4),m=o("unequal",{"any, any":function(e,t){return null===e?null!==t:null===t?null!==e:void 0===e?void 0!==t:void 0===t?void 0!==e:d(e,t)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,d);break;default:r=u(t,e,d,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,d,!1);break;default:r=l(e,t,d)}}return r},"Array, Array":function(e,t){return m(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return m(s(e),t)},"Matrix, Array":function(e,t){return m(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,d,!1);break;default:r=p(e,t,d,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,d,!0);break;default:r=p(t,e,d,!0)}return r},"Array, any":function(e,t){return p(s(e),t,d,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,d,!0).valueOf()}}),d=o("_unequal",{"boolean, boolean":function(e,t){return e!==t},"number, number":function(e,r){return!n(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return!i(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return!e.equals(t)},"Complex, Complex":function(e,t){return!e.equals(t)},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return m(e.value,t.value)},"string, string":function(e,t){return e!==t}});return m.toTex={2:"\\left(${args[0]}"+h.operators.unequal+"${args[1]}\\right)"},m}},function(e,t,r){"use strict";var n=r(3),i=r(1);t.name="sign",t.factory=function(e,t,r,a){var o=a("sign",{number:n.sign,Complex:function(e){return e.sign()},BigNumber:function(t){return new e.BigNumber(t.cmp(0))},Fraction:function(t){return new e.Fraction(t.s,1)},"Array | Matrix":function(e){return i(e,o,!0)},Unit:function(e){return o(e.value)}});return o.toTex={1:"\\mathrm{${name}}\\left(${args[0]}\\right)"},o}},function(e,t,r){"use strict";var n=r(1);t.name="conj",t.factory=function(e,t,r,i){var a=i("conj",{number:function(e){return e},BigNumber:function(e){return e},Complex:function(e){return e.conjugate()},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\left(${args[0]}\\right)^*"},a}},function(e,t,r){"use strict";var n=r(25).object;t.name="lup",t.factory=function(e,t,i,a){var o=i(r(0)),s=i(r(28)),u=i(r(16)),c=i(r(14)),f=i(r(22)),l=i(r(21)),p=i(r(34)),h=i(r(10)),m=i(r(35)),d=e.SparseMatrix,g=e.DenseMatrix,v=e.Spa,y=a("lup",{DenseMatrix:function(e){return x(e)},SparseMatrix:function(e){return w(e)},Array:function(e){var t=o(e),r=x(t);return{L:r.L.valueOf(),U:r.U.valueOf(),p:r.p}}}),x=function(e){var t,r,i,a=e._size[0],o=e._size[1],m=Math.min(a,o),d=n.clone(e._data),v=[],y=[a,m],x=[],w=[m,o],b=[];for(t=0;t<a;t++)b[t]=t;for(r=0;r<o;r++){if(r>0)for(t=0;t<a;t++){var N=Math.min(t,r),E=0;for(i=0;i<N;i++)E=u(E,f(d[t][i],d[i][r]));d[t][r]=l(d[t][r],E)}var M=r,A=0,O=0;for(t=r;t<a;t++){var T=d[t][r],S=s(T);p(S,A)&&(M=t,A=S,O=T)}if(r!==M&&(b[r]=[b[M],b[M]=b[r]][0],g._swapRows(r,M,d)),r<a)for(t=r+1;t<a;t++){var _=d[t][r];h(_,0)||(d[t][r]=c(d[t][r],O))}}for(r=0;r<o;r++)for(t=0;t<a;t++)0===r&&(t<o&&(x[t]=[]),v[t]=[]),t<r?(t<o&&(x[t][r]=d[t][r]),r<a&&(v[t][r]=0)):t!==r?(t<o&&(x[t][r]=0),r<a&&(v[t][r]=d[t][r])):(t<o&&(x[t][r]=d[t][r]),r<a&&(v[t][r]=1));var C=new g({data:v,size:y}),z=new g({data:x,size:w}),k=[];for(t=0,m=b.length;t<m;t++)k[b[t]]=t;return{L:C,U:z,p:k,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\nP: "+this.p}}},w=function(e){var t,r,n,i,a,o,u,l=e._size[0],g=e._size[1],y=Math.min(l,g),x=e._values,w=e._index,b=e._ptr,N=[],E=[],M=[],A=[l,y],O=[],T=[],S=[],_=[y,g],C=[],z=[];for(t=0;t<l;t++)C[t]=t,z[t]=t;for(r=0;r<g;r++){var k=new v;r<l&&(M.push(N.length),N.push(1),E.push(r)),S.push(O.length);var B=b[r],I=b[r+1];for(n=B;n<I;n++)t=w[n],k.set(C[t],x[n]);r>0&&k.forEach(0,r-1,function(e,t){d._forEachRow(e,N,E,M,function(r,n){r>e&&k.accumulate(r,m(f(n,t)))})});var P=r,R=k.get(r),U=s(R);k.forEach(r+1,l-1,function(e,t){var r=s(t);p(r,U)&&(P=e,U=r,R=t)}),r!==P&&(d._swapRows(r,P,A[1],N,E,M),d._swapRows(r,P,_[1],O,T,S),k.swap(r,P),a=P,o=z[i=r],u=z[a],C[o]=a,C[u]=i,z[i]=u,z[a]=o),k.forEach(0,l-1,function(e,t){e<=r?(O.push(t),T.push(e)):(t=c(t,R),h(t,0)||(N.push(t),E.push(e)))})}return S.push(O.length),M.push(N.length),{L:new d({values:N,index:E,ptr:M,size:A}),U:new d({values:O,index:T,ptr:S,size:_}),p:C,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\nP: "+this.p}}};return y}},function(e,t,r){"use strict";var n=r(25).number.isInteger;t.name="slu",t.factory=function(e,t,i,a){var o=i(r(413)),s=i(r(421));return a("slu",{"SparseMatrix, number, number":function(e,t,r){if(!n(t)||t<0||t>3)throw new Error("Symbolic Ordering and Analysis order must be an integer number in the interval [0, 3]");if(r<0||r>1)throw new Error("Partial pivoting threshold must be a number from 0 to 1");var i=o(t,e,!1),a=s(e,i,r);return{L:a.L,U:a.U,p:a.pinv,q:i.q,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\np: "+this.p.toString()+(this.q?"\nq: "+this.q.toString():"")+"\n"}}}})}},function(e,t,r){"use strict";t.name="cs_tdfs",t.path="sparse",t.factory=function(){return function(e,t,r,n,i,a,o){var s=0;for(r[o]=e;s>=0;){var u=r[o+s],c=r[n+u];-1==c?(s--,a[t++]=u):(r[n+u]=r[i+c],r[o+ ++s]=c)}return t}}},function(e,t,r){"use strict";var n=r(3).nearlyEqual,i=r(37);t.name="largerEq",t.factory=function(e,t,a,o){var s=a(r(0)),u=a(r(17)),c=a(r(26)),f=a(r(18)),l=a(r(8)),p=a(r(6)),h=r(4),m=o("largerEq",{"boolean, boolean":function(e,t){return e>=t},"number, number":function(e,r){return e>=r||n(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return e.gte(r)||i(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return-1!==e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return m(e.value,t.value)},"string, string":function(e,t){return e>=t},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,m);break;default:r=u(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,m,!1);break;default:r=l(e,t,m)}}return r},"Array, Array":function(e,t){return m(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return m(s(e),t)},"Matrix, Array":function(e,t){return m(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=p(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,m,!0);break;default:r=p(t,e,m,!0)}return r},"Array, any":function(e,t){return p(s(e),t,m,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+h.operators.largerEq+"${args[1]}\\right)"},m}},function(e,t,r){"use strict";t.name="cs_marked",t.path="sparse",t.factory=function(){return function(e,t){return e[t]<0}}},function(e,t,r){"use strict";t.name="cs_mark",t.path="sparse",t.factory=function(e,t,n){var i=n(r(84));return function(e,t){e[t]=i(e[t])}}},function(e,t,r){"use strict";t.name="lsolve",t.factory=function(e,t,n,i){var a=n(r(0)),o=n(r(14)),s=n(r(22)),u=n(r(21)),c=n(r(10)),f=n(r(85)),l=e.DenseMatrix,p=i("lsolve",{"SparseMatrix, Array | Matrix":function(e,t){return m(e,t)},"DenseMatrix, Array | Matrix":function(e,t){return h(e,t)},"Array, Array | Matrix":function(e,t){var r=a(e);return h(r,t).valueOf()}}),h=function(e,t){for(var r=(t=f(e,t,!0))._data,n=e._size[0],i=e._size[1],a=[],p=e._data,h=0;h<i;h++){var m,d=r[h][0]||0;if(c(d,0))m=0;else{var g=p[h][h];if(c(g,0))throw new Error("Linear system cannot be solved since matrix is singular");m=o(d,g);for(var v=h+1;v<n;v++)r[v]=[u(r[v][0]||0,s(m,p[v][h]))]}a[h]=[m]}return new l({data:a,size:[n,1]})},m=function(e,t){for(var r,n,i=(t=f(e,t,!0))._data,a=e._size[0],p=e._size[1],h=e._values,m=e._index,d=e._ptr,g=[],v=0;v<p;v++){var y=i[v][0]||0;if(c(y,0))g[v]=[0];else{var x=0,w=[],b=[],N=d[v+1];for(n=d[v];n<N;n++)(r=m[n])===v?x=h[n]:r>v&&(w.push(h[n]),b.push(r));if(c(x,0))throw new Error("Linear system cannot be solved since matrix is singular");var E=o(y,x);for(n=0,N=b.length;n<N;n++)i[r=b[n]]=[u(i[r][0]||0,s(E,w[n]))];g[v]=[E]}}return new l({data:g,size:[a,1]})};return p}},function(e,t,r){"use strict";t.name="usolve",t.factory=function(e,t,n,i){var a=n(r(0)),o=n(r(14)),s=n(r(22)),u=n(r(21)),c=n(r(10)),f=n(r(85)),l=e.DenseMatrix,p=i("usolve",{"SparseMatrix, Array | Matrix":function(e,t){return m(e,t)},"DenseMatrix, Array | Matrix":function(e,t){return h(e,t)},"Array, Array | Matrix":function(e,t){var r=a(e);return h(r,t).valueOf()}}),h=function(e,t){for(var r=(t=f(e,t,!0))._data,n=e._size[0],i=e._size[1],a=[],p=e._data,h=i-1;h>=0;h--){var m,d=r[h][0]||0;if(c(d,0))m=0;else{var g=p[h][h];if(c(g,0))throw new Error("Linear system cannot be solved since matrix is singular");m=o(d,g);for(var v=h-1;v>=0;v--)r[v]=[u(r[v][0]||0,s(m,p[v][h]))]}a[h]=[m]}return new l({data:a,size:[n,1]})},m=function(e,t){for(var r,n,i=(t=f(e,t,!0))._data,a=e._size[0],p=e._size[1],h=e._values,m=e._index,d=e._ptr,g=[],v=p-1;v>=0;v--){var y=i[v][0]||0;if(c(y,0))g[v]=[0];else{var x=0,w=[],b=[],N=d[v],E=d[v+1];for(n=E-1;n>=N;n--)(r=m[n])===v?x=h[n]:r<v&&(w.push(h[n]),b.push(r));if(c(x,0))throw new Error("Linear system cannot be solved since matrix is singular");var M=o(y,x);for(n=0,E=b.length;n<E;n++)i[r=b[n]]=[u(i[r][0],s(M,w[n]))];g[v]=[M]}}return new l({data:g,size:[a,1]})};return p}},function(e,t,r){"use strict";t.name="dotDivide",t.factory=function(e,t,n,i){var a=n(r(0)),o=n(r(14)),s=r(4),u=n(r(24)),c=n(r(17)),f=n(r(26)),l=n(r(19)),p=n(r(18)),h=n(r(8)),m=n(r(6)),d=i("dotDivide",{"any, any":o,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,o,!1);break;default:r=u(t,e,o,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,o,!1);break;default:r=h(e,t,o)}}return r},"Array, Array":function(e,t){return d(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return d(a(e),t)},"Matrix, Array":function(e,t){return d(e,a(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,o,!1);break;default:r=m(e,t,o,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=p(t,e,o,!0);break;default:r=m(t,e,o,!0)}return r},"Array, any":function(e,t){return m(a(e),t,o,!1).valueOf()},"any, Array":function(e,t){return m(a(t),e,o,!0).valueOf()}});return d.toTex={2:"\\left(${args[0]}"+s.operators.dotDivide+"${args[1]}\\right)"},d}},function(e,t,r){"use strict";var n=r(11);t.name="algorithm09",t.factory=function(e,t,i,a){var o=i(r(10)),s=e.SparseMatrix;return function(e,t,r){var i=e._values,u=e._index,c=e._ptr,f=e._size,l=e._datatype,p=t._values,h=t._index,m=t._ptr,d=t._size,g=t._datatype;if(f.length!==d.length)throw new n(f.length,d.length);if(f[0]!==d[0]||f[1]!==d[1])throw new RangeError("Dimension mismatch. Matrix A ("+f+") must match Matrix B ("+d+")");var v,y=f[0],x=f[1],w=o,b=0,N=r;"string"==typeof l&&l===g&&(v=l,w=a.find(o,[v,v]),b=a.convert(0,v),N=a.find(r,[v,v]));var E,M,A,O,T,S=i&&p?[]:void 0,_=[],C=[],z=new s({values:S,index:_,ptr:C,size:[y,x],datatype:v}),k=S?[]:void 0,B=[];for(M=0;M<x;M++){C[M]=_.length;var I=M+1;if(k)for(O=m[M],T=m[M+1],A=O;A<T;A++)B[E=h[A]]=I,k[E]=p[A];for(O=c[M],T=c[M+1],A=O;A<T;A++)if(E=u[A],k){var P=B[E]===I?k[E]:b,R=N(i[A],P);w(R,b)||(_.push(E),S.push(R))}else _.push(E)}return C[x]=_.length,z}}},function(e,t,r){"use strict";var n=r(1);t.name="log",t.factory=function(e,t,i,a){var o=i(r(14)),s=a("log",{number:function(r){return r>=0||t.predictable?Math.log(r):new e.Complex(r,0).log()},Complex:function(e){return e.log()},BigNumber:function(r){return!r.isNegative()||t.predictable?r.ln():new e.Complex(r.toNumber(),0).log()},"Array | Matrix":function(e){return n(e,s)},"any, any":function(e,t){return o(s(e),s(t))}});return s.toTex={1:"\\ln\\left(${args[0]}\\right)",2:"\\log_{${args[1]}}\\left(${args[0]}\\right)"},s}},function(e,t,r){"use strict";var n=r(5).clone,i=r(9).format;t.name="trace",t.factory=function(e,t,a,o){var s=a(r(0)),u=a(r(20)),c=o("trace",{Array:function(e){return c(s(e))},Matrix:function(e){var t;switch(e.storage()){case"dense":t=f(e);break;case"sparse":t=l(e)}return t},any:n}),f=function(e){var t=e._size,r=e._data;switch(t.length){case 1:if(1==t[0])return n(r[0]);throw new RangeError("Matrix must be square (size: "+i(t)+")");case 2:var a=t[0];if(a===t[1]){for(var o=0,s=0;s<a;s++)o=u(o,r[s][s]);return o}throw new RangeError("Matrix must be square (size: "+i(t)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+i(t)+")")}},l=function(e){var t=e._values,r=e._index,n=e._ptr,a=e._size,o=a[0],s=a[1];if(o===s){var c=0;if(t.length>0)for(var f=0;f<s;f++)for(var l=n[f],p=n[f+1],h=l;h<p;h++){var m=r[h];if(m===f){c=u(c,t[h]);break}if(m>f)break}return c}throw new RangeError("Matrix must be square (size: "+i(a)+")")};return c.toTex={1:"\\mathrm{tr}\\left(${args[0]}\\right)"},c}},function(e,t,r){"use strict";t.name="stirlingS2",t.factory=function(e,t,n,i){var a=n(r(20)),o=n(r(21)),s=n(r(12)),u=n(r(49)),c=n(r(46)),f=n(r(69)),l=n(r(70)),p=n(r(58)),h=n(r(51)),m=n(r(34)),d=i("stirlingS2",{"number | BigNumber, number | BigNumber":function(e,t){if(!h(e)||p(e)||!h(t)||p(t))throw new TypeError("Non-negative integer value expected in function stirlingS2");if(m(t,e))throw new TypeError("k must be less than or equal to n in function stirlingS2");for(var r=f(t),n=0,i=0;i<=t;i++){var d=c(-1,o(t,i)),g=l(t,i),v=c(i,e);n=a(n,s(s(g,v),d))}return u(n,r)}});return d.toTex={2:"\\mathrm{S}\\left(${args}\\right)"},d}},function(e,t,r){"use strict";var n=r(1),i=r(3).isInteger;var a=4.7421875,o=[.9999999999999971,57.15623566586292,-59.59796035547549,14.136097974741746,-.4919138160976202,3399464998481189e-20,4652362892704858e-20,-9837447530487956e-20,.0001580887032249125,-.00021026444172410488,.00021743961811521265,-.0001643181065367639,8441822398385275e-20,-26190838401581408e-21,36899182659531625e-22];t.name="gamma",t.factory=function(e,t,s,u){var c=s(r(12)),f=s(r(46)),l=u("gamma",{number:function(e){var t,r;if(i(e)){if(e<=0)return isFinite(e)?1/0:NaN;if(e>171)return 1/0;for(var n=e-2,s=e-1;n>1;)s*=n,n--;return 0==s&&(s=1),s}if(e<.5)return Math.PI/(Math.sin(Math.PI*e)*l(1-e));if(e>=171.35)return 1/0;if(e>85){var u=e*e,c=u*e,f=c*e,p=f*e;return Math.sqrt(2*Math.PI/e)*Math.pow(e/Math.E,e)*(1+1/(12*e)+1/(288*u)-139/(51840*c)-571/(2488320*f)+163879/(209018880*p)+5246819/(75246796800*p*e))}--e,r=o[0];for(var h=1;h<o.length;++h)r+=o[h]/(e+h);return t=e+a+.5,Math.sqrt(2*Math.PI)*Math.pow(t,e+.5)*Math.exp(-t)*r},Complex:function(t){var r,n;if(0==t.im)return l(t.re);t=new e.Complex(t.re-1,t.im),n=new e.Complex(o[0],0);for(var i=1;i<o.length;++i){var s=t.re+i,u=s*s+t.im*t.im;0!=u?(n.re+=o[i]*s/u,n.im+=-o[i]*t.im/u):n.re=o[i]<0?-1/0:1/0}r=new e.Complex(t.re+a+.5,t.im);var p=Math.sqrt(2*Math.PI);t.re+=.5;var h=f(r,t);0==h.im?h.re*=p:0==h.re?h.im*=p:(h.re*=p,h.im*=p);var m=Math.exp(-r.re);return r.re=m*Math.cos(-r.im),r.im=m*Math.sin(-r.im),c(c(h,r),n)},BigNumber:function(r){if(r.isInteger())return r.isNegative()||r.isZero()?new e.BigNumber(1/0):function(r){if(r.isZero())return new e.BigNumber(1);for(var n=t.precision+(0|Math.log(r.toNumber())),i=new(e.BigNumber.clone({precision:n}))(r),a=r.toNumber()-1;a>1;)i=i.times(a),a--;return new e.BigNumber(i.toPrecision(e.BigNumber.precision))}(r.minus(1));if(!r.isFinite())return new e.BigNumber(r.isNegative()?NaN:1/0);throw new Error("Integer BigNumber expected")},"Array | Matrix":function(e){return n(e,l)}});return l.toTex={1:"\\Gamma\\left(${args[0]}\\right)"},l}},function(e,t,r){"use strict";var n=r(1);t.name="not",t.factory=function(e,t,i,a){var o=r(4),s=a("not",{number:function(e){return!e},Complex:function(e){return 0===e.re&&0===e.im},BigNumber:function(e){return e.isZero()||e.isNaN()},Unit:function(e){return s(e.value)},"Array | Matrix":function(e){return n(e,s)}});return s.toTex={1:o.operators.not+"\\left(${args[0]}\\right)"},s}},function(e,t,r){"use strict";var n=r(32).maxArgumentCount;function i(e,t){var r=n(t),i=function(n,a){return Array.isArray(n)?n.map(function(e,t){return i(e,a.concat(t))}):1===r?t(n):2===r?t(n,a):t(n,a,e)};return i(e,[])}t.name="map",t.factory=function(e,t,r,n){var a=n("map",{"Array, function":i,"Matrix, function":function(e,t){return e.map(t)}});return a.toTex=void 0,a}},function(e,t,r){"use strict";var n=r(2).size;t.name="sort",t.factory=function(e,t,i,a){var o=i(r(0)),s=i(r(52)),u=function(e,t){return-s(e,t)},c=i(r(31)),f=a("sort",{Array:function(e){return p(e),e.sort(s)},Matrix:function(e){return h(e),o(e.toArray().sort(s),e.storage())},"Array, function":function(e,t){return p(e),e.sort(t)},"Matrix, function":function(e,t){return h(e),o(e.toArray().sort(t),e.storage())},"Array, string":function(e,t){return p(e),e.sort(l(t))},"Matrix, string":function(e,t){return h(e),o(e.toArray().sort(l(t)),e.storage())}});function l(e){if("asc"===e)return s;if("desc"===e)return u;if("natural"===e)return c;throw new Error('String "asc", "desc", or "natural" expected')}function p(e){if(1!==n(e).length)throw new Error("One dimensional array expected")}function h(e){if(1!==e.size().length)throw new Error("One dimensional matrix expected")}return f.toTex=void 0,f}},function(e,t,r){"use strict";var n=r(43);t.name="sum",t.factory=function(e,t,i,a){var o=i(r(16)),s=a("sum",{"Array | Matrix":function(e){return u(e)},"Array | Matrix, number | BigNumber":function(){throw new Error("sum(A, dim) is not yet supported")},"...":function(e){return u(e)}});return s.toTex=void 0,s;function u(r){var i=void 0;if(n(r,function(e){i=void 0===i?e:o(i,e)}),void 0===i)switch(t.number){case"number":return 0;case"BigNumber":return new e.BigNumber(0);case"Fraction":return new e.Fraction(0);default:return 0}return i}}},function(e,t,r){"use strict";var n=r(2).flatten,i=r(2).identify,a=r(2).generalize;t.name="setDifference",t.factory=function(e,t,o,s){var u=o(r(30)),c=o(r(27)),f=o(r(45)),l=o(r(29)),p=o(r(23)),h=o(r(31));return s("setDifference",{"Array | Matrix, Array | Matrix":function(e,t){if(0===p(l(e),new c(0)))var r=[];else{if(0===p(l(t),new c(0)))return n(e.toArray());for(var o,s=i(n(Array.isArray(e)?e:e.toArray()).sort(h)),m=i(n(Array.isArray(t)?t:t.toArray()).sort(h)),d=(r=[],0);d<s.length;d++){o=!1;for(var g=0;g<m.length;g++)if(u(s[d].value,m[g].value)&&s[d].identifier===m[g].identifier){o=!0;break}o||r.push(s[d])}}return Array.isArray(e)&&Array.isArray(t)?a(r):new f(a(r))}})}},function(e,t,r){"use strict";var n=r(2).flatten,i=r(2).identify,a=r(2).generalize;t.name="setIntersect",t.factory=function(e,t,o,s){var u=o(r(30)),c=o(r(27)),f=o(r(45)),l=o(r(29)),p=o(r(23)),h=o(r(31));return s("setIntersect",{"Array | Matrix, Array | Matrix":function(e,t){if(0===p(l(e),new c(0))||0===p(l(t),new c(0)))var r=[];else for(var o=i(n(Array.isArray(e)?e:e.toArray()).sort(h)),s=i(n(Array.isArray(t)?t:t.toArray()).sort(h)),m=(r=[],0);m<o.length;m++)for(var d=0;d<s.length;d++)if(u(o[m].value,s[d].value)&&o[m].identifier===s[d].identifier){r.push(o[m]);break}return Array.isArray(e)&&Array.isArray(t)?a(r):new f(a(r))}})}},function(e,t,r){"use strict";var n=r(2).flatten;t.name="setSymDifference",t.factory=function(e,t,i,a){var o=i(r(27)),s=i(r(64)),u=i(r(29)),c=(i(r(143)),i(r(23))),f=i(r(145));return a("setSymDifference",{"Array | Matrix, Array | Matrix":function(e,t){if(0===c(u(e),new o(0)))return n(t);if(0===c(u(t),new o(0)))return n(e);var r=n(e),i=n(t);return s(f(r,i),f(i,r))}})}},function(e,t,r){"use strict";var n=r(2).flatten,i=(r(65),r(66));t.name="median",t.factory=function(e,t,a,o){var s=a(r(16)),u=a(r(14)),c=a(r(52)),f=a(r(89)),l=o("median",{"Array | Matrix":p,"Array | Matrix, number | BigNumber":function(e,t){throw new Error("median(A, dim) is not yet supported")},"...":function(e){if(i(e))throw new TypeError("Scalar values expected in function median");return p(e)}});function p(e){var t=(e=n(e.valueOf())).length;if(0==t)throw new Error("Cannot calculate median of an empty array");if(t%2==0){for(var r=t/2-1,i=f(e,r+1),a=e[r],o=0;o<r;++o)c(e[o],a)>0&&(a=e[o]);return m(a,i)}var s=f(e,(t-1)/2);return h(s)}var h=o({"number | BigNumber | Complex | Unit":function(e){return e}}),m=o({"number | BigNumber | Complex | Unit, number | BigNumber | Complex | Unit":function(e,t){return u(s(e,t),2)}});return l.toTex=void 0,l}},function(e,t,r){"use strict";var n="unbiased",i=r(43);t.name="var",t.factory=function(e,t,a,o){var s=a(r(16)),u=a(r(21)),c=a(r(22)),f=a(r(14)),l=o("variance",{"Array | Matrix":function(e){return p(e,n)},"Array | Matrix, string":p,"...":function(e){return p(e,n)}});return l.toTex="\\mathrm{Var}\\left(${args}\\right)",l;function p(t,r){var n=0,a=0;if(0==t.length)throw new SyntaxError("Function var requires one or more parameters (0 provided)");if(i(t,function(e){n=s(n,e),a++}),0===a)throw new Error("Cannot calculate var of an empty array");var o=f(n,a);switch(n=0,i(t,function(e){var t=u(e,o);n=s(n,c(t,t))}),r){case"uncorrected":return f(n,a);case"biased":return f(n,a+1);case"unbiased":var l=e.isBigNumber(n)?new e.BigNumber(0):0;return 1==a?l:f(n,a-1);default:throw new Error('Unknown normalization "'+r+'". Choose "unbiased" (default), "uncorrected", or "biased".')}}}},function(e,t,r){"use strict";var n=r(1);var i=Math.acosh||function(e){return Math.log(Math.sqrt(e*e-1)+e)};t.name="acosh",t.factory=function(e,t,r,a){var o=a("acosh",{number:function(r){return r>=1||t.predictable?i(r):r<=-1?new e.Complex(Math.log(Math.sqrt(r*r-1)-r),Math.PI):new e.Complex(r,0).acosh()},Complex:function(e){return e.acosh()},BigNumber:function(e){return e.acosh()},"Array | Matrix":function(e){return n(e,o)}});return o.toTex={1:"\\cosh^{-1}\\left(${args[0]}\\right)"},o}},function(e,t,r){var n=r(152);e.exports=function e(t){var i=n.create(t);return i.create=e,i.import(r(159)),i}()},function(e,t,r){e.exports=r(153)},function(e,t,r){var n=r(5).isFactory,i=r(154),a=r(91),o=r(157),s=r(158);t.create=function(e){if("function"!=typeof Object.create)throw new Error("ES5 not supported by this JavaScript engine. Please load the es5-shim and es5-sham library for compatibility.");var t=[],r=[],u=a.mixin({});u.type={},u.expression={transform:{},mathWithTransform:{}},u.typed=i.create(u.type);var c={epsilon:1e-12,matrix:"Matrix",number:"number",precision:64,predictable:!1,randomSeed:null};function f(e){if(!n(e))throw new Error("Factory object with properties `type`, `name`, and `factory` expected");var i,a=t.indexOf(e);return-1===a?(i=!0===e.math?e.factory(u.type,c,f,u.typed,u):e.factory(u.type,c,f,u.typed),t.push(e),r.push(i)):i=r[a],i}return u.import=f(o),u.config=f(s),u.expression.mathWithTransform.config=u.config,e&&u.config(e),u}},function(e,t,r){var n=r(155),i=r(3).digits,a=r(71),o=r(59),s=function(){return s=n.create,n};t.create=function(e){e.isNumber=function(e){return"number"==typeof e},e.isComplex=function(t){return e.Complex&&t instanceof e.Complex||!1},e.isBigNumber=a,e.isFraction=function(t){return e.Fraction&&t instanceof e.Fraction||!1},e.isUnit=function(e){return e&&e.constructor.prototype.isUnit||!1},e.isString=function(e){return"string"==typeof e},e.isArray=Array.isArray,e.isMatrix=o,e.isDenseMatrix=function(e){return e&&e.isDenseMatrix&&e.constructor.prototype.isMatrix||!1},e.isSparseMatrix=function(e){return e&&e.isSparseMatrix&&e.constructor.prototype.isMatrix||!1},e.isRange=function(e){return e&&e.constructor.prototype.isRange||!1},e.isIndex=function(e){return e&&e.constructor.prototype.isIndex||!1},e.isBoolean=function(e){return"boolean"==typeof e},e.isResultSet=function(e){return e&&e.constructor.prototype.isResultSet||!1},e.isHelp=function(e){return e&&e.constructor.prototype.isHelp||!1},e.isFunction=function(e){return"function"==typeof e},e.isDate=function(e){return e instanceof Date},e.isRegExp=function(e){return e instanceof RegExp},e.isObject=function(e){return"object"==typeof e},e.isNull=function(e){return null===e},e.isUndefined=function(e){return void 0===e},e.isAccessorNode=function(e){return e&&e.isAccessorNode&&e.constructor.prototype.isNode||!1},e.isArrayNode=function(e){return e&&e.isArrayNode&&e.constructor.prototype.isNode||!1},e.isAssignmentNode=function(e){return e&&e.isAssignmentNode&&e.constructor.prototype.isNode||!1},e.isBlockNode=function(e){return e&&e.isBlockNode&&e.constructor.prototype.isNode||!1},e.isConditionalNode=function(e){return e&&e.isConditionalNode&&e.constructor.prototype.isNode||!1},e.isConstantNode=function(e){return e&&e.isConstantNode&&e.constructor.prototype.isNode||!1},e.isFunctionAssignmentNode=function(e){return e&&e.isFunctionAssignmentNode&&e.constructor.prototype.isNode||!1},e.isFunctionNode=function(e){return e&&e.isFunctionNode&&e.constructor.prototype.isNode||!1},e.isIndexNode=function(e){return e&&e.isIndexNode&&e.constructor.prototype.isNode||!1},e.isNode=function(e){return e&&e.isNode&&e.constructor.prototype.isNode||!1},e.isObjectNode=function(e){return e&&e.isObjectNode&&e.constructor.prototype.isNode||!1},e.isOperatorNode=function(e){return e&&e.isOperatorNode&&e.constructor.prototype.isNode||!1},e.isParenthesisNode=function(e){return e&&e.isParenthesisNode&&e.constructor.prototype.isNode||!1},e.isRangeNode=function(e){return e&&e.isRangeNode&&e.constructor.prototype.isNode||!1},e.isSymbolNode=function(e){return e&&e.isSymbolNode&&e.constructor.prototype.isNode||!1},e.isChain=function(e){return e&&e.constructor.prototype.isChain||!1};var t=s();return t.types=[{name:"number",test:e.isNumber},{name:"Complex",test:e.isComplex},{name:"BigNumber",test:e.isBigNumber},{name:"Fraction",test:e.isFraction},{name:"Unit",test:e.isUnit},{name:"string",test:e.isString},{name:"Array",test:e.isArray},{name:"Matrix",test:e.isMatrix},{name:"DenseMatrix",test:e.isDenseMatrix},{name:"SparseMatrix",test:e.isSparseMatrix},{name:"Range",test:e.isRange},{name:"Index",test:e.isIndex},{name:"boolean",test:e.isBoolean},{name:"ResultSet",test:e.isResultSet},{name:"Help",test:e.isHelp},{name:"function",test:e.isFunction},{name:"Date",test:e.isDate},{name:"RegExp",test:e.isRegExp},{name:"Object",test:e.isObject},{name:"null",test:e.isNull},{name:"undefined",test:e.isUndefined},{name:"OperatorNode",test:e.isOperatorNode},{name:"ConstantNode",test:e.isConstantNode},{name:"SymbolNode",test:e.isSymbolNode},{name:"ParenthesisNode",test:e.isParenthesisNode},{name:"FunctionNode",test:e.isFunctionNode},{name:"FunctionAssignmentNode",test:e.isFunctionAssignmentNode},{name:"ArrayNode",test:e.isArrayNode},{name:"AssignmentNode",test:e.isAssignmentNode},{name:"BlockNode",test:e.isBlockNode},{name:"ConditionalNode",test:e.isConditionalNode},{name:"IndexNode",test:e.isIndexNode},{name:"RangeNode",test:e.isRangeNode},{name:"Node",test:e.isNode}],t.conversions=[{from:"number",to:"BigNumber",convert:function(t){if(i(t)>15)throw new TypeError("Cannot implicitly convert a number with >15 significant digits to BigNumber (value: "+t+"). Use function bignumber(x) to convert to BigNumber.");return new e.BigNumber(t)}},{from:"number",to:"Complex",convert:function(t){return new e.Complex(t,0)}},{from:"number",to:"string",convert:function(e){return e+""}},{from:"BigNumber",to:"Complex",convert:function(t){return new e.Complex(t.toNumber(),0)}},{from:"Fraction",to:"BigNumber",convert:function(e){throw new TypeError("Cannot implicitly convert a Fraction to BigNumber or vice versa. Use function bignumber(x) to convert to BigNumber or fraction(x) to convert to Fraction.")}},{from:"Fraction",to:"Complex",convert:function(t){return new e.Complex(t.valueOf(),0)}},{from:"number",to:"Fraction",convert:function(t){if(new e.Fraction(t).valueOf()!==t)throw new TypeError("Cannot implicitly convert a number to a Fraction when there will be a loss of precision (value: "+t+"). Use function fraction(x) to convert to Fraction.");return new e.Fraction(t)}},{from:"string",to:"number",convert:function(e){var t=Number(e);if(isNaN(t))throw new Error('Cannot convert "'+e+'" to a number');return t}},{from:"string",to:"BigNumber",convert:function(t){try{return new e.BigNumber(t)}catch(e){throw new Error('Cannot convert "'+t+'" to BigNumber')}}},{from:"string",to:"Fraction",convert:function(t){try{return new e.Fraction(t)}catch(e){throw new Error('Cannot convert "'+t+'" to Fraction')}}},{from:"string",to:"Complex",convert:function(t){try{return new e.Complex(t)}catch(e){throw new Error('Cannot convert "'+t+'" to Complex')}}},{from:"boolean",to:"number",convert:function(e){return+e}},{from:"boolean",to:"BigNumber",convert:function(t){return new e.BigNumber(+t)}},{from:"boolean",to:"Fraction",convert:function(t){return new e.Fraction(+t)}},{from:"boolean",to:"string",convert:function(e){return+e}},{from:"null",to:"number",convert:function(){return 0}},{from:"null",to:"string",convert:function(){return"null"}},{from:"null",to:"BigNumber",convert:function(){return new e.BigNumber(0)}},{from:"null",to:"Fraction",convert:function(){return new e.Fraction(0)}},{from:"Array",to:"Matrix",convert:function(t){return new e.DenseMatrix(t)}},{from:"Matrix",to:"Array",convert:function(e){return e.valueOf()}}],t}},function(e,t,r){"use strict";var n,i,a;i=[],void 0===(a="function"==typeof(n=function(){return function e(){function t(e){for(var t,r=0;r<g.types.length;r++){var n=g.types[r];if(n.name===e){t=n.test;break}}if(!t){var i;for(r=0;r<g.types.length;r++)if((n=g.types[r]).name.toLowerCase()==e.toLowerCase()){i=n.name;break}throw new Error('Unknown type "'+e+'"'+(i?'. Did you mean "'+i+'"?':""))}return t}function r(e){for(var t="",r=0;r<e.length;r++){var n=e[r];if(n.signatures&&""!=n.name)if(""==t)t=n.name;else if(t!=n.name){var i=new Error("Function names do not match (expected: "+t+", actual: "+n.name+")");throw i.data={actual:n.name,expected:t},i}}return t}function n(e,t,r,n,i){var a,o=c(n),s=i?i.split(","):null,u=e||"unnamed",l=s&&f(s,"any"),p={fn:e,index:r,actual:o,expected:s};a=s?t>r&&!l?"Unexpected type of argument in function "+u+" (expected: "+s.join(" or ")+", actual: "+o+", index: "+r+")":"Too few arguments in function "+u+" (expected: "+s.join(" or ")+", index: "+r+")":"Too many arguments in function "+u+" (expected: "+r+", actual: "+t+")";var h=new TypeError(a);return h.data=p,h}function i(e){this.name=e||"refs",this.categories={}}function a(e,t){if("string"==typeof e){var r=e.trim(),n="..."===r.substr(0,3);if(n&&(r=r.substr(3)),""===r)this.types=["any"];else{this.types=r.split("|");for(var i=0;i<this.types.length;i++)this.types[i]=this.types[i].trim()}}else{if(!Array.isArray(e)){if(e instanceof a)return e.clone();throw new Error("String or Array expected")}this.types=e}this.conversions=[],this.varArgs=n||t||!1,this.anyType=-1!==this.types.indexOf("any")}function o(e,t){var r;if("string"==typeof e)r=""!==e?e.split(","):[];else{if(!Array.isArray(e))throw new Error("string or Array expected");r=e}this.params=new Array(r.length),this.anyType=!1,this.varArgs=!1;for(var n=0;n<r.length;n++){var i=new a(r[n]);if(this.params[n]=i,i.anyType&&(this.anyType=!0),n===r.length-1)this.varArgs=i.varArgs;else if(i.varArgs)throw new SyntaxError('Unexpected variable arguments operator "..."')}this.fn=t}function s(e,t,r,n){this.path=e||[],this.param=e[e.length-1]||null,this.signature=t||null,this.childs=r||[],this.fallThrough=n||!1}function u(e,t){var r=new i,u=function(e){var t,r,n={},i=[];for(var a in e)if(e.hasOwnProperty(a)){if((t=new o(a,e[a])).ignore())continue;var s=t.expand();for(r=0;r<s.length;r++){var u=s[r],c=u.toString(),l=n[c];if(l){var p=o.compare(u,l);if(p<0)n[c]=u;else if(0===p)throw new Error('Signature "'+c+'" is defined twice')}else n[c]=u}}for(c in n)n.hasOwnProperty(c)&&i.push(n[c]);for(i.sort(function(e,t){return o.compare(e,t)}),r=0;r<i.length;r++)if((t=i[r]).varArgs)for(var h=t.params.length-1,m=t.params[h],d=0;d<m.types.length;){if(m.conversions[d])for(var g=m.types[d],v=0;v<i.length;v++){var y=i[v],x=y.params[h];if(y!==t&&x&&f(x.types,g)&&!x.conversions[h]){m.types.splice(d,1),m.conversions.splice(d,1),d--;break}}d++}return i}(t);if(0==u.length)throw new Error("No signatures provided");var c=function e(t,r,n){var i,o,u,c=r.length,l=[];for(i=0;i<t.length;i++)(o=t[i]).params.length!==c||u||(u=o),void 0!=o.params[c]&&l.push(o);l.sort(function(e,t){return a.compare(e.params[c],t.params[c])});var p=[];for(i=0;i<l.length;i++){var h=(o=l[i]).params[c],m=p.filter(function(e){return e.param.overlapping(h)})[0];if(m){if(m.param.varArgs)throw new Error('Conflicting types "'+m.param+'" and "'+h+'"');m.signatures.push(o)}else p.push({param:h,signatures:[o]})}var d=[];for(i=0;i<n.length;i++)n[i].paramsStartWith(r)&&d.push(n[i]);var g=!1;for(i=0;i<d.length;i++)if(!f(t,d[i])){g=!0;break}var v=new Array(p.length);for(i=0;i<p.length;i++){var y=p[i];v[i]=e(y.signatures,r.concat(y.param),d)}return new s(r,u,v,g)}(u,[],function(e){for(var t=[],r=0;r<e.length;r++)e[r].anyType&&t.push(e[r]);return t}(u)),l=[],p=(e||"").replace(/[^a-zA-Z0-9_$]/g,"_"),h=function(e){for(var t=[],r=0;r<e;r++)t[r]="arg"+r;return t}(function(e){for(var t=0,r=0;r<e.length;r++){var n=e[r].params.length;n>t&&(t=n)}return t}(u));l.push("function "+p+"("+h.join(", ")+") {"),l.push('  "use strict";'),l.push("  var name = "+JSON.stringify(e||"")+";"),l.push(c.toCode(r,"  ",!1)),l.push("}");var m=[r.toCode(),"return "+l.join("\n")].join("\n"),d=new Function(r.name,"createError",m)(r,n);return d.signatures=function(e){for(var t={},r=0;r<e.length;r++){var n=e[r];n.fn&&!n.hasConversions()&&(t[n.params.join(",")]=n.fn)}return t}(u),d}function c(e){for(var t,r=0;r<g.types.length;r++){var n=g.types[r];if("Object"===n.name)t=n;else if(n.test(e))return n.name}return t&&t.test(e)?t.name:"unknown"}function f(e,t){return-1!==e.indexOf(t)}function l(e){return e[e.length-1]}i.prototype.add=function(e,t){var r=t||"fn";this.categories[r]||(this.categories[r]=[]);var n=this.categories[r].indexOf(e);return-1==n&&(n=this.categories[r].length,this.categories[r].push(e)),r+n},i.prototype.toCode=function(){var e=[],t=this.name+".categories",r=this.categories;for(var n in r)if(r.hasOwnProperty(n))for(var i=r[n],a=0;a<i.length;a++)e.push("var "+n+a+" = "+t+"['"+n+"']["+a+"];");return e.join("\n")},a.compare=function(e,t){if(e.anyType)return 1;if(t.anyType)return-1;if(f(e.types,"Object"))return 1;if(f(t.types,"Object"))return-1;if(e.hasConversions()){if(t.hasConversions()){var r,n,i;for(r=0;r<e.conversions.length;r++)if(void 0!==e.conversions[r]){n=e.conversions[r];break}for(r=0;r<t.conversions.length;r++)if(void 0!==t.conversions[r]){i=t.conversions[r];break}return g.conversions.indexOf(n)-g.conversions.indexOf(i)}return 1}if(t.hasConversions())return-1;var a,o;for(r=0;r<g.types.length;r++)if(g.types[r].name===e.types[0]){a=r;break}for(r=0;r<g.types.length;r++)if(g.types[r].name===t.types[0]){o=r;break}return a-o},a.prototype.overlapping=function(e){for(var t=0;t<this.types.length;t++)if(f(e.types,this.types[t]))return!0;return!1},a.prototype.matches=function(e){return this.anyType||e.anyType||this.overlapping(e)},a.prototype.clone=function(){var e=new a(this.types.slice(),this.varArgs);return e.conversions=this.conversions.slice(),e},a.prototype.hasConversions=function(){return this.conversions.length>0},a.prototype.contains=function(e){for(var t=0;t<this.types.length;t++)if(e[this.types[t]])return!0;return!1},a.prototype.toString=function(e){for(var t=[],r={},n=0;n<this.types.length;n++){var i=this.conversions[n],a=e&&i?i.to:this.types[n];a in r||(r[a]=!0,t.push(a))}return(this.varArgs?"...":"")+t.join("|")},o.prototype.clone=function(){return new o(this.params.slice(),this.fn)},o.prototype.expand=function(){var e=[];return function t(r,n){if(n.length<r.params.length){var i,s,u,c=r.params[n.length];if(c.varArgs){for(s=c.clone(),i=0;i<g.conversions.length;i++)if(u=g.conversions[i],!f(c.types,u.from)&&f(c.types,u.to)){var l=s.types.length;s.types[l]=u.from,s.conversions[l]=u}t(r,n.concat(s))}else{for(i=0;i<c.types.length;i++)t(r,n.concat(new a(c.types[i])));for(i=0;i<g.conversions.length;i++)u=g.conversions[i],!f(c.types,u.from)&&f(c.types,u.to)&&((s=new a(u.from)).conversions[0]=u,t(r,n.concat(s)))}}else e.push(new o(n,r.fn))}(this,[]),e},o.compare=function(e,t){if(e.params.length>t.params.length)return 1;if(e.params.length<t.params.length)return-1;var r,n=e.params.length,i=0,o=0;for(r=0;r<n;r++)e.params[r].hasConversions()&&i++,t.params[r].hasConversions()&&o++;if(i>o)return 1;if(i<o)return-1;for(r=0;r<e.params.length;r++){var s=a.compare(e.params[r],t.params[r]);if(0!==s)return s}return 0},o.prototype.hasConversions=function(){for(var e=0;e<this.params.length;e++)if(this.params[e].hasConversions())return!0;return!1},o.prototype.ignore=function(){for(var e={},t=0;t<g.ignore.length;t++)e[g.ignore[t]]=!0;for(t=0;t<this.params.length;t++)if(this.params[t].contains(e))return!0;return!1},o.prototype.paramsStartWith=function(e){if(0===e.length)return!0;for(var t=l(this.params),r=l(e),n=0;n<e.length;n++){var i=this.params[n]||(t.varArgs?t:null),a=e[n]||(r.varArgs?r:null);if(!i||!a||!i.matches(a))return!1}return!0},o.prototype.toCode=function(e,t){for(var r=new Array(this.params.length),n=0;n<this.params.length;n++){var i=this.params[n],a=i.conversions[0];i.varArgs?r[n]="varArgs":r[n]=a?e.add(a.convert,"convert")+"(arg"+n+")":"arg"+n}var o=this.fn?e.add(this.fn,"signature"):void 0;return o?t+"return "+o+"("+r.join(", ")+"); // signature: "+this.params.join(", "):[].join("\n")},o.prototype.toString=function(){return this.params.join(", ")},s.prototype.toCode=function(e,r){var n=[];if(this.param){var i=this.path.length-1,a=this.param.conversions[0],o="// type: "+(a?a.from+" (convert to "+a.to+")":this.param);if(this.param.varArgs)if(this.param.anyType)n.push(r+"if (arguments.length > "+i+") {"),n.push(r+"  var varArgs = [];"),n.push(r+"  for (var i = "+i+"; i < arguments.length; i++) {"),n.push(r+"    varArgs.push(arguments[i]);"),n.push(r+"  }"),n.push(this.signature.toCode(e,r+"  ")),n.push(r+"}");else{for(var s=function(r,n){for(var i=[],a=0;a<r.length;a++)i[a]=e.add(t(r[a]),"test")+"("+n+")";return i.join(" || ")}.bind(this),u=this.param.types,c=[],f=0;f<u.length;f++)void 0===this.param.conversions[f]&&c.push(u[f]);for(n.push(r+"if ("+s(u,"arg"+i)+") { "+o),n.push(r+"  var varArgs = [arg"+i+"];"),n.push(r+"  for (var i = "+(i+1)+"; i < arguments.length; i++) {"),n.push(r+"    if ("+s(c,"arguments[i]")+") {"),n.push(r+"      varArgs.push(arguments[i]);"),f=0;f<u.length;f++){var l=this.param.conversions[f];if(l){var p=e.add(t(u[f]),"test"),h=e.add(l.convert,"convert");n.push(r+"    }"),n.push(r+"    else if ("+p+"(arguments[i])) {"),n.push(r+"      varArgs.push("+h+"(arguments[i]));")}}n.push(r+"    } else {"),n.push(r+"      throw createError(name, arguments.length, i, arguments[i], '"+c.join(",")+"');"),n.push(r+"    }"),n.push(r+"  }"),n.push(this.signature.toCode(e,r+"  ")),n.push(r+"}")}else if(this.param.anyType)n.push(r+"// type: any"),n.push(this._innerCode(e,r));else{var m=this.param.types[0];p="any"!==m?e.add(t(m),"test"):null,n.push(r+"if ("+p+"(arg"+i+")) { "+o),n.push(this._innerCode(e,r+"  ")),n.push(r+"}")}}else n.push(this._innerCode(e,r));return n.join("\n")},s.prototype._innerCode=function(e,t){var r,n=[];for(this.signature&&(n.push(t+"if (arguments.length === "+this.path.length+") {"),n.push(this.signature.toCode(e,t+"  ")),n.push(t+"}")),r=0;r<this.childs.length;r++)n.push(this.childs[r].toCode(e,t));if(!this.fallThrough||this.param&&this.param.anyType){var i=this._exceptions(e,t);i&&n.push(i)}return n.join("\n")},s.prototype._exceptions=function(e,t){var r=this.path.length;if(0===this.childs.length)return[t+"if (arguments.length > "+r+") {",t+"  throw createError(name, arguments.length, "+r+", arguments["+r+"]);",t+"}"].join("\n");for(var n={},i=[],a=0;a<this.childs.length;a++){var o=this.childs[a];if(o.param)for(var s=0;s<o.param.types.length;s++){var u=o.param.types[s];u in n||o.param.conversions[s]||(n[u]=!0,i.push(u))}}return t+"throw createError(name, arguments.length, "+r+", arguments["+r+"], '"+i.join(",")+"');"};var p=[{name:"number",test:function(e){return"number"==typeof e}},{name:"string",test:function(e){return"string"==typeof e}},{name:"boolean",test:function(e){return"boolean"==typeof e}},{name:"Function",test:function(e){return"function"==typeof e}},{name:"Array",test:Array.isArray},{name:"Date",test:function(e){return e instanceof Date}},{name:"RegExp",test:function(e){return e instanceof RegExp}},{name:"Object",test:function(e){return"object"==typeof e}},{name:"null",test:function(e){return null===e}},{name:"undefined",test:function(e){return void 0===e}}],h={},m=[],d=[],g={config:h,types:p,conversions:m,ignore:d};return(g=u("typed",{Object:function(e){var t=[];for(var n in e)e.hasOwnProperty(n)&&t.push(e[n]);return u(r(t),e)},"string, Object":u,"...Function":function(e){for(var t,n=r(e),i={},a=0;a<e.length;a++){var o=e[a];if("object"!=typeof o.signatures)throw(t=new TypeError("Function is no typed-function (index: "+a+")")).data={index:a},t;for(var s in o.signatures)if(o.signatures.hasOwnProperty(s))if(i.hasOwnProperty(s)){if(o.signatures[s]!==i[s])throw(t=new Error('Signature "'+s+'" is defined twice')).data={signature:s},t}else i[s]=o.signatures[s]}return u(n,i)}})).config=h,g.types=p,g.conversions=m,g.ignore=d,g.create=e,g.find=function(e,t){if(!e.signatures)throw new TypeError("Function is no typed-function");var r;if("string"==typeof t){r=t.split(",");for(var n=0;n<r.length;n++)r[n]=r[n].trim()}else{if(!Array.isArray(t))throw new TypeError("String array or a comma separated string expected");r=t}var i=r.join(","),a=e.signatures[i];if(a)return a;throw new TypeError("Signature not found (signature: "+(e.name||"unnamed")+"("+r.join(", ")+"))")},g.convert=function(e,t){var r=c(e);if(t===r)return e;for(var n=0;n<g.conversions.length;n++){var i=g.conversions[n];if(i.from===r&&i.to===t)return i.convert(e)}throw new Error("Cannot convert from "+r+" to "+t)},g.addType=function(e){if(!e||"string"!=typeof e.name||"function"!=typeof e.test)throw new TypeError("Object with properties {name: string, test: function} expected");g.types.push(e)},g.addConversion=function(e){if(!e||"string"!=typeof e.from||"string"!=typeof e.to||"function"!=typeof e.convert)throw new TypeError("Object with properties {from: string, to: string, convert: function} expected");g.conversions.push(e)},g}()})?n.apply(t,i):n)||(e.exports=a)},function(e,t){function r(){}r.prototype={on:function(e,t,r){var n=this.e||(this.e={});return(n[e]||(n[e]=[])).push({fn:t,ctx:r}),this},once:function(e,t,r){var n=this;function i(){n.off(e,i),t.apply(r,arguments)}return i._=t,this.on(e,i,r)},emit:function(e){for(var t=[].slice.call(arguments,1),r=((this.e||(this.e={}))[e]||[]).slice(),n=0,i=r.length;n<i;n++)r[n].fn.apply(r[n].ctx,t);return this},off:function(e,t){var r=this.e||(this.e={}),n=r[e],i=[];if(n&&t)for(var a=0,o=n.length;a<o;a++)n[a].fn!==t&&n[a].fn._!==t&&i.push(n[a]);return i.length?r[e]=i:delete r[e],this}},e.exports=r},function(e,t,r){"use strict";var n=r(5).lazy,i=r(5).isFactory,a=r(5).traverse,o=r(44);t.math=!0,t.name="import",t.factory=function(e,t,r,s,u){function c(e,t,r){if(r.wrap&&"function"==typeof t&&(i=function(){for(var e=[],t=0,r=arguments.length;t<r;t++){var i=arguments[t];e[t]=i&&i.valueOf()}return n.apply(u,e)},(n=t).transform&&(i.transform=n.transform),t=i),p(u[e])&&p(t))return t=r.override?s(e,t.signatures):s(u[e],t),u[e]=t,f(e,t),void u.emit("import",e,function(){return t});var n,i;if(void 0===u[e]||r.override)return u[e]=t,f(e,t),void u.emit("import",e,function(){return t});if(!r.silent)throw new Error('Cannot import "'+e+'": already exists')}function f(e,t){t&&"function"==typeof t.transform?(u.expression.transform[e]=t.transform,h(e)&&(u.expression.mathWithTransform[e]=t.transform)):(delete u.expression.transform[e],h(e)&&(u.expression.mathWithTransform[e]=t))}function l(e,t){if("string"==typeof e.name){var i=e.name,o=i in u.expression.transform,c=e.path?a(u,e.path):u,f=c.hasOwnProperty(i)?c[i]:void 0,l=function(){var n=r(e);if(n&&"function"==typeof n.transform)throw new Error('Transforms cannot be attached to factory functions. Please create a separate function for it with exports.path="expression.transform"');if(p(f)&&p(n))return t.override||(n=s(f,n)),n;if(void 0===f||t.override)return n;if(!t.silent)throw new Error('Cannot import "'+i+'": already exists')};!1!==e.lazy?(n(c,i,l),o||("expression.transform"===e.path||m(e))&&n(u.expression.mathWithTransform,i,l)):(c[i]=l(),o||("expression.transform"===e.path||m(e))&&(u.expression.mathWithTransform[i]=l())),u.emit("import",i,l,e.path)}else r(e)}function p(e){return"function"==typeof e&&"object"==typeof e.signatures}function h(e){return!d.hasOwnProperty(e)}function m(e){return void 0===e.path&&!d.hasOwnProperty(e.name)}var d={expression:!0,type:!0,docs:!0,error:!0,json:!0,chain:!0};return function t(r,n){var a,s=arguments.length;if(1!==s&&2!==s)throw new o("import",s,1,2);if(n||(n={}),i(r))l(r,n);else if(Array.isArray(r))r.forEach(function(e){t(e,n)});else if("object"==typeof r){for(var u in r)if(r.hasOwnProperty(u)){var f=r[u];"function"==typeof(a=f)||"number"==typeof a||"string"==typeof a||"boolean"==typeof a||null===a||a&&e.isUnit(a)||a&&e.isComplex(a)||a&&e.isBigNumber(a)||a&&e.isFraction(a)||a&&e.isMatrix(a)||a&&Array.isArray(a)?c(u,f,n):i(r)?l(r,n):t(f,n)}}else if(!n.silent)throw new TypeError("Factory, Object, or Array expected")}},t.lazy=!0},function(e,t,r){"use strict";var n=r(5);function i(e,t,r){if(void 0!==e[t]&&(o=r,s=e[t],-1===o.indexOf(s))){var n=(i=r,a=e[t],i.map(function(e){return e.toLowerCase()}).indexOf(a.toLowerCase()));-1!==n?(console.warn('Warning: Wrong casing for configuration option "'+t+'", should be "'+r[n]+'" instead of "'+e[t]+'".'),e[t]=r[n]):console.warn('Warning: Unknown value "'+e[t]+'" for configuration option "'+t+'". Available options: '+r.map(JSON.stringify).join(", ")+".")}var i,a,o,s}t.name="config",t.math=!0,t.factory=function(e,t,r,a,o){var s=["Matrix","Array"],u=["number","BigNumber","Fraction"];function c(e){if(e){var r=n.map(t,n.clone);i(e,"matrix",s),i(e,"number",u),n.deepExtend(t,e);var a=n.map(t,n.clone),c=n.map(e,n.clone);return o.emit("config",a,r,c),a}return n.map(t,n.clone)}return c.MATRIX=s,c.NUMBER=u,c}},function(e,t,r){e.exports=[r(160),r(193),r(195),r(407),r(549),r(551)]},function(e,t,r){e.exports=[r(161),r(165),r(166),r(170),r(174),r(177),r(74),r(185),r(186),r(187)]},function(e,t,r){e.exports=[r(162),r(164)]},function(e,t,r){var n=r(163);t.name="BigNumber",t.path="type",t.factory=function(e,t,r,i,a){var o=n.clone({precision:t.precision});return o.prototype.type="BigNumber",o.prototype.isBigNumber=!0,o.prototype.toJSON=function(){return{mathjs:"BigNumber",value:this.toString()}},o.fromJSON=function(e){return new o(e.value)},a.on("config",function(e,t){e.precision!==t.precision&&o.config({precision:e.precision})}),o},t.math=!0},function(e,t,r){var n;!function(i){"use strict";var a,o,s,u=9e15,c=1e9,f="0123456789abcdef",l="2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058",p="3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632789",h={precision:20,rounding:4,modulo:1,toExpNeg:-7,toExpPos:21,minE:-u,maxE:u,crypto:!1},m=!0,d="[DecimalError] ",g=d+"Invalid argument: ",v=d+"Precision limit exceeded",y=d+"crypto unavailable",x=Math.floor,w=Math.pow,b=/^0b([01]+(\.[01]*)?|\.[01]+)(p[+-]?\d+)?$/i,N=/^0x([0-9a-f]+(\.[0-9a-f]*)?|\.[0-9a-f]+)(p[+-]?\d+)?$/i,E=/^0o([0-7]+(\.[0-7]*)?|\.[0-7]+)(p[+-]?\d+)?$/i,M=/^(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,A=1e7,O=7,T=l.length-1,S=p.length-1,_={name:"[object Decimal]"};function C(e){var t,r,n,i=e.length-1,a="",o=e[0];if(i>0){for(a+=o,t=1;t<i;t++)n=e[t]+"",(r=O-n.length)&&(a+=F(r)),a+=n;o=e[t],(r=O-(n=o+"").length)&&(a+=F(r))}else if(0===o)return"0";for(;o%10==0;)o/=10;return a+o}function z(e,t,r){if(e!==~~e||e<t||e>r)throw Error(g+e)}function k(e,t,r,n){var i,a,o,s;for(a=e[0];a>=10;a/=10)--t;return--t<0?(t+=O,i=0):(i=Math.ceil((t+1)/O),t%=O),a=w(10,O-t),s=e[i]%a|0,null==n?t<3?(0==t?s=s/100|0:1==t&&(s=s/10|0),o=r<4&&99999==s||r>3&&49999==s||5e4==s||0==s):o=(r<4&&s+1==a||r>3&&s+1==a/2)&&(e[i+1]/a/100|0)==w(10,t-2)-1||(s==a/2||0==s)&&0==(e[i+1]/a/100|0):t<4?(0==t?s=s/1e3|0:1==t?s=s/100|0:2==t&&(s=s/10|0),o=(n||r<4)&&9999==s||!n&&r>3&&4999==s):o=((n||r<4)&&s+1==a||!n&&r>3&&s+1==a/2)&&(e[i+1]/a/1e3|0)==w(10,t-3)-1,o}function B(e,t,r){for(var n,i,a=[0],o=0,s=e.length;o<s;){for(i=a.length;i--;)a[i]*=t;for(a[0]+=f.indexOf(e.charAt(o++)),n=0;n<a.length;n++)a[n]>r-1&&(void 0===a[n+1]&&(a[n+1]=0),a[n+1]+=a[n]/r|0,a[n]%=r)}return a.reverse()}_.absoluteValue=_.abs=function(){var e=new this.constructor(this);return e.s<0&&(e.s=1),P(e)},_.ceil=function(){return P(new this.constructor(this),this.e+1,2)},_.comparedTo=_.cmp=function(e){var t,r,n,i,a=this.d,o=(e=new this.constructor(e)).d,s=this.s,u=e.s;if(!a||!o)return s&&u?s!==u?s:a===o?0:!a^s<0?1:-1:NaN;if(!a[0]||!o[0])return a[0]?s:o[0]?-u:0;if(s!==u)return s;if(this.e!==e.e)return this.e>e.e^s<0?1:-1;for(t=0,r=(n=a.length)<(i=o.length)?n:i;t<r;++t)if(a[t]!==o[t])return a[t]>o[t]^s<0?1:-1;return n===i?0:n>i^s<0?1:-1},_.cosine=_.cos=function(){var e,t,r=this,n=r.constructor;return r.d?r.d[0]?(e=n.precision,t=n.rounding,n.precision=e+Math.max(r.e,r.sd())+O,n.rounding=1,r=function(e,t){var r,n,i=t.d.length;i<32?(r=Math.ceil(i/3),n=Math.pow(4,-r).toString()):(r=16,n="2.3283064365386962890625e-10");e.precision+=r,t=Y(e,1,t.times(n),new e(1));for(var a=r;a--;){var o=t.times(t);t=o.times(o).minus(o).times(8).plus(1)}return e.precision-=r,t}(n,X(n,r)),n.precision=e,n.rounding=t,P(2==s||3==s?r.neg():r,e,t,!0)):new n(1):new n(NaN)},_.cubeRoot=_.cbrt=function(){var e,t,r,n,i,a,o,s,u,c,f=this,l=f.constructor;if(!f.isFinite()||f.isZero())return new l(f);for(m=!1,(a=f.s*Math.pow(f.s*f,1/3))&&Math.abs(a)!=1/0?n=new l(a.toString()):(r=C(f.d),(a=((e=f.e)-r.length+1)%3)&&(r+=1==a||-2==a?"0":"00"),a=Math.pow(r,1/3),e=x((e+1)/3)-(e%3==(e<0?-1:2)),(n=new l(r=a==1/0?"5e"+e:(r=a.toExponential()).slice(0,r.indexOf("e")+1)+e)).s=f.s),o=(e=l.precision)+3;;)if(c=(u=(s=n).times(s).times(s)).plus(f),n=I(c.plus(f).times(s),c.plus(u),o+2,1),C(s.d).slice(0,o)===(r=C(n.d)).slice(0,o)){if("9999"!=(r=r.slice(o-3,o+1))&&(i||"4999"!=r)){+r&&(+r.slice(1)||"5"!=r.charAt(0))||(P(n,e+1,1),t=!n.times(n).times(n).eq(f));break}if(!i&&(P(s,e+1,0),s.times(s).times(s).eq(f))){n=s;break}o+=4,i=1}return m=!0,P(n,e,l.rounding,t)},_.decimalPlaces=_.dp=function(){var e,t=this.d,r=NaN;if(t){if(r=((e=t.length-1)-x(this.e/O))*O,e=t[e])for(;e%10==0;e/=10)r--;r<0&&(r=0)}return r},_.dividedBy=_.div=function(e){return I(this,new this.constructor(e))},_.dividedToIntegerBy=_.divToInt=function(e){var t=this.constructor;return P(I(this,new t(e),0,1,1),t.precision,t.rounding)},_.equals=_.eq=function(e){return 0===this.cmp(e)},_.floor=function(){return P(new this.constructor(this),this.e+1,3)},_.greaterThan=_.gt=function(e){return this.cmp(e)>0},_.greaterThanOrEqualTo=_.gte=function(e){var t=this.cmp(e);return 1==t||0===t},_.hyperbolicCosine=_.cosh=function(){var e,t,r,n,i,a=this,o=a.constructor,s=new o(1);if(!a.isFinite())return new o(a.s?1/0:NaN);if(a.isZero())return s;r=o.precision,n=o.rounding,o.precision=r+Math.max(a.e,a.sd())+4,o.rounding=1,(i=a.d.length)<32?(e=Math.ceil(i/3),t=Math.pow(4,-e).toString()):(e=16,t="2.3283064365386962890625e-10"),a=Y(o,1,a.times(t),new o(1),!0);for(var u,c=e,f=new o(8);c--;)u=a.times(a),a=s.minus(u.times(f.minus(u.times(f))));return P(a,o.precision=r,o.rounding=n,!0)},_.hyperbolicSine=_.sinh=function(){var e,t,r,n,i=this,a=i.constructor;if(!i.isFinite()||i.isZero())return new a(i);if(t=a.precision,r=a.rounding,a.precision=t+Math.max(i.e,i.sd())+4,a.rounding=1,(n=i.d.length)<3)i=Y(a,2,i,i,!0);else{e=(e=1.4*Math.sqrt(n))>16?16:0|e,i=Y(a,2,i=i.times(Math.pow(5,-e)),i,!0);for(var o,s=new a(5),u=new a(16),c=new a(20);e--;)o=i.times(i),i=i.times(s.plus(o.times(u.times(o).plus(c))))}return a.precision=t,a.rounding=r,P(i,t,r,!0)},_.hyperbolicTangent=_.tanh=function(){var e,t,r=this.constructor;return this.isFinite()?this.isZero()?new r(this):(e=r.precision,t=r.rounding,r.precision=e+7,r.rounding=1,I(this.sinh(),this.cosh(),r.precision=e,r.rounding=t)):new r(this.s)},_.inverseCosine=_.acos=function(){var e,t=this,r=t.constructor,n=t.abs().cmp(1),i=r.precision,a=r.rounding;return-1!==n?0===n?t.isNeg()?L(r,i,a):new r(0):new r(NaN):t.isZero()?L(r,i+4,a).times(.5):(r.precision=i+6,r.rounding=1,t=t.asin(),e=L(r,i+4,a).times(.5),r.precision=i,r.rounding=a,e.minus(t))},_.inverseHyperbolicCosine=_.acosh=function(){var e,t,r=this,n=r.constructor;return r.lte(1)?new n(r.eq(1)?0:NaN):r.isFinite()?(e=n.precision,t=n.rounding,n.precision=e+Math.max(Math.abs(r.e),r.sd())+4,n.rounding=1,m=!1,r=r.times(r).minus(1).sqrt().plus(r),m=!0,n.precision=e,n.rounding=t,r.ln()):new n(r)},_.inverseHyperbolicSine=_.asinh=function(){var e,t,r=this,n=r.constructor;return!r.isFinite()||r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+2*Math.max(Math.abs(r.e),r.sd())+6,n.rounding=1,m=!1,r=r.times(r).plus(1).sqrt().plus(r),m=!0,n.precision=e,n.rounding=t,r.ln())},_.inverseHyperbolicTangent=_.atanh=function(){var e,t,r,n,i=this,a=i.constructor;return i.isFinite()?i.e>=0?new a(i.abs().eq(1)?i.s/0:i.isZero()?i:NaN):(e=a.precision,t=a.rounding,n=i.sd(),Math.max(n,e)<2*-i.e-1?P(new a(i),e,t,!0):(a.precision=r=n-i.e,i=I(i.plus(1),new a(1).minus(i),r+e,1),a.precision=e+4,a.rounding=1,i=i.ln(),a.precision=e,a.rounding=t,i.times(.5))):new a(NaN)},_.inverseSine=_.asin=function(){var e,t,r,n,i=this,a=i.constructor;return i.isZero()?new a(i):(t=i.abs().cmp(1),r=a.precision,n=a.rounding,-1!==t?0===t?((e=L(a,r+4,n).times(.5)).s=i.s,e):new a(NaN):(a.precision=r+6,a.rounding=1,i=i.div(new a(1).minus(i.times(i)).sqrt().plus(1)).atan(),a.precision=r,a.rounding=n,i.times(2)))},_.inverseTangent=_.atan=function(){var e,t,r,n,i,a,o,s,u,c=this,f=c.constructor,l=f.precision,p=f.rounding;if(c.isFinite()){if(c.isZero())return new f(c);if(c.abs().eq(1)&&l+4<=S)return(o=L(f,l+4,p).times(.25)).s=c.s,o}else{if(!c.s)return new f(NaN);if(l+4<=S)return(o=L(f,l+4,p).times(.5)).s=c.s,o}for(f.precision=s=l+10,f.rounding=1,e=r=Math.min(28,s/O+2|0);e;--e)c=c.div(c.times(c).plus(1).sqrt().plus(1));for(m=!1,t=Math.ceil(s/O),n=1,u=c.times(c),o=new f(c),i=c;-1!==e;)if(i=i.times(u),a=o.minus(i.div(n+=2)),i=i.times(u),void 0!==(o=a.plus(i.div(n+=2))).d[t])for(e=t;o.d[e]===a.d[e]&&e--;);return r&&(o=o.times(2<<r-1)),m=!0,P(o,f.precision=l,f.rounding=p,!0)},_.isFinite=function(){return!!this.d},_.isInteger=_.isInt=function(){return!!this.d&&x(this.e/O)>this.d.length-2},_.isNaN=function(){return!this.s},_.isNegative=_.isNeg=function(){return this.s<0},_.isPositive=_.isPos=function(){return this.s>0},_.isZero=function(){return!!this.d&&0===this.d[0]},_.lessThan=_.lt=function(e){return this.cmp(e)<0},_.lessThanOrEqualTo=_.lte=function(e){return this.cmp(e)<1},_.logarithm=_.log=function(e){var t,r,n,i,a,o,s,u,c=this.constructor,f=c.precision,l=c.rounding;if(null==e)e=new c(10),t=!0;else{if(r=(e=new c(e)).d,e.s<0||!r||!r[0]||e.eq(1))return new c(NaN);t=e.eq(10)}if(r=this.d,this.s<0||!r||!r[0]||this.eq(1))return new c(r&&!r[0]?-1/0:1!=this.s?NaN:r?0:1/0);if(t)if(r.length>1)a=!0;else{for(i=r[0];i%10==0;)i/=10;a=1!==i}if(m=!1,o=Z(this,s=f+5),n=t?q(c,s+10):Z(e,s),k((u=I(o,n,s,1)).d,i=f,l))do{if(o=Z(this,s+=10),n=t?q(c,s+10):Z(e,s),u=I(o,n,s,1),!a){+C(u.d).slice(i+1,i+15)+1==1e14&&(u=P(u,f+1,0));break}}while(k(u.d,i+=10,l));return m=!0,P(u,f,l)},_.minus=_.sub=function(e){var t,r,n,i,a,o,s,u,c,f,l,p,h=this,d=h.constructor;if(e=new d(e),!h.d||!e.d)return h.s&&e.s?h.d?e.s=-e.s:e=new d(e.d||h.s!==e.s?h:NaN):e=new d(NaN),e;if(h.s!=e.s)return e.s=-e.s,h.plus(e);if(c=h.d,p=e.d,s=d.precision,u=d.rounding,!c[0]||!p[0]){if(p[0])e.s=-e.s;else{if(!c[0])return new d(3===u?-0:0);e=new d(h)}return m?P(e,s,u):e}if(r=x(e.e/O),f=x(h.e/O),c=c.slice(),a=f-r){for((l=a<0)?(t=c,a=-a,o=p.length):(t=p,r=f,o=c.length),a>(n=Math.max(Math.ceil(s/O),o)+2)&&(a=n,t.length=1),t.reverse(),n=a;n--;)t.push(0);t.reverse()}else{for((l=(n=c.length)<(o=p.length))&&(o=n),n=0;n<o;n++)if(c[n]!=p[n]){l=c[n]<p[n];break}a=0}for(l&&(t=c,c=p,p=t,e.s=-e.s),o=c.length,n=p.length-o;n>0;--n)c[o++]=0;for(n=p.length;n>a;){if(c[--n]<p[n]){for(i=n;i&&0===c[--i];)c[i]=A-1;--c[i],c[n]+=A}c[n]-=p[n]}for(;0===c[--o];)c.pop();for(;0===c[0];c.shift())--r;return c[0]?(e.d=c,e.e=U(c,r),m?P(e,s,u):e):new d(3===u?-0:0)},_.modulo=_.mod=function(e){var t,r=this.constructor;return e=new r(e),!this.d||!e.s||e.d&&!e.d[0]?new r(NaN):!e.d||this.d&&!this.d[0]?P(new r(this),r.precision,r.rounding):(m=!1,9==r.modulo?(t=I(this,e.abs(),0,3,1)).s*=e.s:t=I(this,e,0,r.modulo,1),t=t.times(e),m=!0,this.minus(t))},_.naturalExponential=_.exp=function(){return G(this)},_.naturalLogarithm=_.ln=function(){return Z(this)},_.negated=_.neg=function(){var e=new this.constructor(this);return e.s=-e.s,P(e)},_.plus=_.add=function(e){var t,r,n,i,a,o,s,u,c,f,l=this,p=l.constructor;if(e=new p(e),!l.d||!e.d)return l.s&&e.s?l.d||(e=new p(e.d||l.s===e.s?l:NaN)):e=new p(NaN),e;if(l.s!=e.s)return e.s=-e.s,l.minus(e);if(c=l.d,f=e.d,s=p.precision,u=p.rounding,!c[0]||!f[0])return f[0]||(e=new p(l)),m?P(e,s,u):e;if(a=x(l.e/O),n=x(e.e/O),c=c.slice(),i=a-n){for(i<0?(r=c,i=-i,o=f.length):(r=f,n=a,o=c.length),i>(o=(a=Math.ceil(s/O))>o?a+1:o+1)&&(i=o,r.length=1),r.reverse();i--;)r.push(0);r.reverse()}for((o=c.length)-(i=f.length)<0&&(i=o,r=f,f=c,c=r),t=0;i;)t=(c[--i]=c[i]+f[i]+t)/A|0,c[i]%=A;for(t&&(c.unshift(t),++n),o=c.length;0==c[--o];)c.pop();return e.d=c,e.e=U(c,n),m?P(e,s,u):e},_.precision=_.sd=function(e){var t;if(void 0!==e&&e!==!!e&&1!==e&&0!==e)throw Error(g+e);return this.d?(t=j(this.d),e&&this.e+1>t&&(t=this.e+1)):t=NaN,t},_.round=function(){var e=this.constructor;return P(new e(this),this.e+1,e.rounding)},_.sine=_.sin=function(){var e,t,r=this,n=r.constructor;return r.isFinite()?r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+Math.max(r.e,r.sd())+O,n.rounding=1,r=function(e,t){var r,n=t.d.length;if(n<3)return Y(e,2,t,t);r=(r=1.4*Math.sqrt(n))>16?16:0|r,t=t.times(Math.pow(5,-r)),t=Y(e,2,t,t);for(var i,a=new e(5),o=new e(16),s=new e(20);r--;)i=t.times(t),t=t.times(a.plus(i.times(o.times(i).minus(s))));return t}(n,X(n,r)),n.precision=e,n.rounding=t,P(s>2?r.neg():r,e,t,!0)):new n(NaN)},_.squareRoot=_.sqrt=function(){var e,t,r,n,i,a,o=this.d,s=this.e,u=this.s,c=this.constructor;if(1!==u||!o||!o[0])return new c(!u||u<0&&(!o||o[0])?NaN:o?this:1/0);for(m=!1,0==(u=Math.sqrt(+this))||u==1/0?(((t=C(o)).length+s)%2==0&&(t+="0"),u=Math.sqrt(t),s=x((s+1)/2)-(s<0||s%2),n=new c(t=u==1/0?"1e"+s:(t=u.toExponential()).slice(0,t.indexOf("e")+1)+s)):n=new c(u.toString()),r=(s=c.precision)+3;;)if(n=(a=n).plus(I(this,a,r+2,1)).times(.5),C(a.d).slice(0,r)===(t=C(n.d)).slice(0,r)){if("9999"!=(t=t.slice(r-3,r+1))&&(i||"4999"!=t)){+t&&(+t.slice(1)||"5"!=t.charAt(0))||(P(n,s+1,1),e=!n.times(n).eq(this));break}if(!i&&(P(a,s+1,0),a.times(a).eq(this))){n=a;break}r+=4,i=1}return m=!0,P(n,s,c.rounding,e)},_.tangent=_.tan=function(){var e,t,r=this,n=r.constructor;return r.isFinite()?r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+10,n.rounding=1,(r=r.sin()).s=1,r=I(r,new n(1).minus(r.times(r)).sqrt(),e+10,0),n.precision=e,n.rounding=t,P(2==s||4==s?r.neg():r,e,t,!0)):new n(NaN)},_.times=_.mul=function(e){var t,r,n,i,a,o,s,u,c,f=this.constructor,l=this.d,p=(e=new f(e)).d;if(e.s*=this.s,!(l&&l[0]&&p&&p[0]))return new f(!e.s||l&&!l[0]&&!p||p&&!p[0]&&!l?NaN:l&&p?0*e.s:e.s/0);for(r=x(this.e/O)+x(e.e/O),(u=l.length)<(c=p.length)&&(a=l,l=p,p=a,o=u,u=c,c=o),a=[],n=o=u+c;n--;)a.push(0);for(n=c;--n>=0;){for(t=0,i=u+n;i>n;)s=a[i]+p[n]*l[i-n-1]+t,a[i--]=s%A|0,t=s/A|0;a[i]=(a[i]+t)%A|0}for(;!a[--o];)a.pop();return t?++r:a.shift(),e.d=a,e.e=U(a,r),m?P(e,f.precision,f.rounding):e},_.toBinary=function(e,t){return J(this,2,e,t)},_.toDecimalPlaces=_.toDP=function(e,t){var r=this,n=r.constructor;return r=new n(r),void 0===e?r:(z(e,0,c),void 0===t?t=n.rounding:z(t,0,8),P(r,e+r.e+1,t))},_.toExponential=function(e,t){var r,n=this,i=n.constructor;return void 0===e?r=R(n,!0):(z(e,0,c),void 0===t?t=i.rounding:z(t,0,8),r=R(n=P(new i(n),e+1,t),!0,e+1)),n.isNeg()&&!n.isZero()?"-"+r:r},_.toFixed=function(e,t){var r,n,i=this.constructor;return void 0===e?r=R(this):(z(e,0,c),void 0===t?t=i.rounding:z(t,0,8),r=R(n=P(new i(this),e+this.e+1,t),!1,e+n.e+1)),this.isNeg()&&!this.isZero()?"-"+r:r},_.toFraction=function(e){var t,r,n,i,a,o,s,u,c,f,l,p,h=this.d,d=this.constructor;if(!h)return new d(this);if(c=r=new d(1),o=(a=(t=new d(n=u=new d(0))).e=j(h)-this.e-1)%O,t.d[0]=w(10,o<0?O+o:o),null==e)e=a>0?t:c;else{if(!(s=new d(e)).isInt()||s.lt(c))throw Error(g+s);e=s.gt(t)?a>0?t:c:s}for(m=!1,s=new d(C(h)),f=d.precision,d.precision=a=h.length*O*2;l=I(s,t,0,1,1),1!=(i=r.plus(l.times(n))).cmp(e);)r=n,n=i,i=c,c=u.plus(l.times(i)),u=i,i=t,t=s.minus(l.times(i)),s=i;return i=I(e.minus(r),n,0,1,1),u=u.plus(i.times(c)),r=r.plus(i.times(n)),u.s=c.s=this.s,p=I(c,n,a,1).minus(this).abs().cmp(I(u,r,a,1).minus(this).abs())<1?[c,n]:[u,r],d.precision=f,m=!0,p},_.toHexadecimal=_.toHex=function(e,t){return J(this,16,e,t)},_.toNearest=function(e,t){var r=this,n=r.constructor;if(r=new n(r),null==e){if(!r.d)return r;e=new n(1),t=n.rounding}else{if(e=new n(e),void 0!==t&&z(t,0,8),!r.d)return e.s?r:e;if(!e.d)return e.s&&(e.s=r.s),e}return e.d[0]?(m=!1,t<4&&(t=[4,5,7,8][t]),r=I(r,e,0,t,1).times(e),m=!0,P(r)):(e.s=r.s,r=e),r},_.toNumber=function(){return+this},_.toOctal=function(e,t){return J(this,8,e,t)},_.toPower=_.pow=function(e){var t,r,n,i,a,o,s=this,u=s.constructor,c=+(e=new u(e));if(!(s.d&&e.d&&s.d[0]&&e.d[0]))return new u(w(+s,c));if((s=new u(s)).eq(1))return s;if(n=u.precision,a=u.rounding,e.eq(1))return P(s,n,a);if((t=x(e.e/O))>=e.d.length-1&&(r=c<0?-c:c)<=9007199254740991)return i=D(u,s,r,n),e.s<0?new u(1).div(i):P(i,n,a);if((o=s.s)<0){if(t<e.d.length-1)return new u(NaN);if(0==(1&e.d[t])&&(o=1),0==s.e&&1==s.d[0]&&1==s.d.length)return s.s=o,s}return(t=0!=(r=w(+s,c))&&isFinite(r)?new u(r+"").e:x(c*(Math.log("0."+C(s.d))/Math.LN10+s.e+1)))>u.maxE+1||t<u.minE-1?new u(t>0?o/0:0):(m=!1,u.rounding=s.s=1,r=Math.min(12,(t+"").length),(i=G(e.times(Z(s,n+r)),n)).d&&k((i=P(i,n+5,1)).d,n,a)&&(t=n+10,+C((i=P(G(e.times(Z(s,t+r)),t),t+5,1)).d).slice(n+1,n+15)+1==1e14&&(i=P(i,n+1,0))),i.s=o,m=!0,u.rounding=a,P(i,n,a))},_.toPrecision=function(e,t){var r,n=this,i=n.constructor;return void 0===e?r=R(n,n.e<=i.toExpNeg||n.e>=i.toExpPos):(z(e,1,c),void 0===t?t=i.rounding:z(t,0,8),r=R(n=P(new i(n),e,t),e<=n.e||n.e<=i.toExpNeg,e)),n.isNeg()&&!n.isZero()?"-"+r:r},_.toSignificantDigits=_.toSD=function(e,t){var r=this.constructor;return void 0===e?(e=r.precision,t=r.rounding):(z(e,1,c),void 0===t?t=r.rounding:z(t,0,8)),P(new r(this),e,t)},_.toString=function(){var e=this.constructor,t=R(this,this.e<=e.toExpNeg||this.e>=e.toExpPos);return this.isNeg()&&!this.isZero()?"-"+t:t},_.truncated=_.trunc=function(){return P(new this.constructor(this),this.e+1,1)},_.valueOf=_.toJSON=function(){var e=this.constructor,t=R(this,this.e<=e.toExpNeg||this.e>=e.toExpPos);return this.isNeg()?"-"+t:t};var I=function(){function e(e,t,r){var n,i=0,a=e.length;for(e=e.slice();a--;)n=e[a]*t+i,e[a]=n%r|0,i=n/r|0;return i&&e.unshift(i),e}function t(e,t,r,n){var i,a;if(r!=n)a=r>n?1:-1;else for(i=a=0;i<r;i++)if(e[i]!=t[i]){a=e[i]>t[i]?1:-1;break}return a}function r(e,t,r,n){for(var i=0;r--;)e[r]-=i,i=e[r]<t[r]?1:0,e[r]=i*n+e[r]-t[r];for(;!e[0]&&e.length>1;)e.shift()}return function(n,i,a,s,u,c){var f,l,p,h,m,d,g,v,y,w,b,N,E,M,T,S,_,C,z,k,B=n.constructor,I=n.s==i.s?1:-1,R=n.d,U=i.d;if(!(R&&R[0]&&U&&U[0]))return new B(n.s&&i.s&&(R?!U||R[0]!=U[0]:U)?R&&0==R[0]||!U?0*I:I/0:NaN);for(c?(m=1,l=n.e-i.e):(c=A,m=O,l=x(n.e/m)-x(i.e/m)),z=U.length,_=R.length,w=(y=new B(I)).d=[],p=0;U[p]==(R[p]||0);p++);if(U[p]>(R[p]||0)&&l--,null==a?(M=a=B.precision,s=B.rounding):M=u?a+(n.e-i.e)+1:a,M<0)w.push(1),d=!0;else{if(M=M/m+2|0,p=0,1==z){for(h=0,U=U[0],M++;(p<_||h)&&M--;p++)T=h*c+(R[p]||0),w[p]=T/U|0,h=T%U|0;d=h||p<_}else{for((h=c/(U[0]+1)|0)>1&&(U=e(U,h,c),R=e(R,h,c),z=U.length,_=R.length),S=z,N=(b=R.slice(0,z)).length;N<z;)b[N++]=0;(k=U.slice()).unshift(0),C=U[0],U[1]>=c/2&&++C;do{h=0,(f=t(U,b,z,N))<0?(E=b[0],z!=N&&(E=E*c+(b[1]||0)),(h=E/C|0)>1?(h>=c&&(h=c-1),1==(f=t(g=e(U,h,c),b,v=g.length,N=b.length))&&(h--,r(g,z<v?k:U,v,c))):(0==h&&(f=h=1),g=U.slice()),(v=g.length)<N&&g.unshift(0),r(b,g,N,c),-1==f&&(f=t(U,b,z,N=b.length))<1&&(h++,r(b,z<N?k:U,N,c)),N=b.length):0===f&&(h++,b=[0]),w[p++]=h,f&&b[0]?b[N++]=R[S]||0:(b=[R[S]],N=1)}while((S++<_||void 0!==b[0])&&M--);d=void 0!==b[0]}w[0]||w.shift()}if(1==m)y.e=l,o=d;else{for(p=1,h=w[0];h>=10;h/=10)p++;y.e=p+l*m-1,P(y,u?a+y.e+1:a,s,d)}return y}}();function P(e,t,r,n){var i,a,o,s,u,c,f,l,p,h=e.constructor;e:if(null!=t){if(!(l=e.d))return e;for(i=1,s=l[0];s>=10;s/=10)i++;if((a=t-i)<0)a+=O,o=t,u=(f=l[p=0])/w(10,i-o-1)%10|0;else if((p=Math.ceil((a+1)/O))>=(s=l.length)){if(!n)break e;for(;s++<=p;)l.push(0);f=u=0,i=1,o=(a%=O)-O+1}else{for(f=s=l[p],i=1;s>=10;s/=10)i++;u=(o=(a%=O)-O+i)<0?0:f/w(10,i-o-1)%10|0}if(n=n||t<0||void 0!==l[p+1]||(o<0?f:f%w(10,i-o-1)),c=r<4?(u||n)&&(0==r||r==(e.s<0?3:2)):u>5||5==u&&(4==r||n||6==r&&(a>0?o>0?f/w(10,i-o):0:l[p-1])%10&1||r==(e.s<0?8:7)),t<1||!l[0])return l.length=0,c?(t-=e.e+1,l[0]=w(10,(O-t%O)%O),e.e=-t||0):l[0]=e.e=0,e;if(0==a?(l.length=p,s=1,p--):(l.length=p+1,s=w(10,O-a),l[p]=o>0?(f/w(10,i-o)%w(10,o)|0)*s:0),c)for(;;){if(0==p){for(a=1,o=l[0];o>=10;o/=10)a++;for(o=l[0]+=s,s=1;o>=10;o/=10)s++;a!=s&&(e.e++,l[0]==A&&(l[0]=1));break}if(l[p]+=s,l[p]!=A)break;l[p--]=0,s=1}for(a=l.length;0===l[--a];)l.pop()}return m&&(e.e>h.maxE?(e.d=null,e.e=NaN):e.e<h.minE&&(e.e=0,e.d=[0])),e}function R(e,t,r){if(!e.isFinite())return V(e);var n,i=e.e,a=C(e.d),o=a.length;return t?(r&&(n=r-o)>0?a=a.charAt(0)+"."+a.slice(1)+F(n):o>1&&(a=a.charAt(0)+"."+a.slice(1)),a=a+(e.e<0?"e":"e+")+e.e):i<0?(a="0."+F(-i-1)+a,r&&(n=r-o)>0&&(a+=F(n))):i>=o?(a+=F(i+1-o),r&&(n=r-i-1)>0&&(a=a+"."+F(n))):((n=i+1)<o&&(a=a.slice(0,n)+"."+a.slice(n)),r&&(n=r-o)>0&&(i+1===o&&(a+="."),a+=F(n))),a}function U(e,t){var r=e[0];for(t*=O;r>=10;r/=10)t++;return t}function q(e,t,r){if(t>T)throw m=!0,r&&(e.precision=r),Error(v);return P(new e(l),t,1,!0)}function L(e,t,r){if(t>S)throw Error(v);return P(new e(p),t,r,!0)}function j(e){var t=e.length-1,r=t*O+1;if(t=e[t]){for(;t%10==0;t/=10)r--;for(t=e[0];t>=10;t/=10)r++}return r}function F(e){for(var t="";e--;)t+="0";return t}function D(e,t,r,n){var i,a=new e(1),o=Math.ceil(n/O+4);for(m=!1;;){if(r%2&&Q((a=a.times(t)).d,o)&&(i=!0),0===(r=x(r/2))){r=a.d.length-1,i&&0===a.d[r]&&++a.d[r];break}Q((t=t.times(t)).d,o)}return m=!0,a}function H(e){return 1&e.d[e.d.length-1]}function $(e,t,r){for(var n,i=new e(t[0]),a=0;++a<t.length;){if(!(n=new e(t[a])).s){i=n;break}i[r](n)&&(i=n)}return i}function G(e,t){var r,n,i,a,o,s,u,c=0,f=0,l=0,p=e.constructor,h=p.rounding,d=p.precision;if(!e.d||!e.d[0]||e.e>17)return new p(e.d?e.d[0]?e.s<0?0:1/0:1:e.s?e.s<0?0:e:NaN);for(null==t?(m=!1,u=d):u=t,s=new p(.03125);e.e>-2;)e=e.times(s),l+=5;for(u+=n=Math.log(w(2,l))/Math.LN10*2+5|0,r=a=o=new p(1),p.precision=u;;){if(a=P(a.times(e),u,1),r=r.times(++f),C((s=o.plus(I(a,r,u,1))).d).slice(0,u)===C(o.d).slice(0,u)){for(i=l;i--;)o=P(o.times(o),u,1);if(null!=t)return p.precision=d,o;if(!(c<3&&k(o.d,u-n,h,c)))return P(o,p.precision=d,h,m=!0);p.precision=u+=10,r=a=s=new p(1),f=0,c++}o=s}}function Z(e,t){var r,n,i,a,o,s,u,c,f,l,p,h=1,d=e,g=d.d,v=d.constructor,y=v.rounding,x=v.precision;if(d.s<0||!g||!g[0]||!d.e&&1==g[0]&&1==g.length)return new v(g&&!g[0]?-1/0:1!=d.s?NaN:g?0:d);if(null==t?(m=!1,f=x):f=t,v.precision=f+=10,n=(r=C(g)).charAt(0),!(Math.abs(a=d.e)<15e14))return c=q(v,f+2,x).times(a+""),d=Z(new v(n+"."+r.slice(1)),f-10).plus(c),v.precision=x,null==t?P(d,x,y,m=!0):d;for(;n<7&&1!=n||1==n&&r.charAt(1)>3;)n=(r=C((d=d.times(e)).d)).charAt(0),h++;for(a=d.e,n>1?(d=new v("0."+r),a++):d=new v(n+"."+r.slice(1)),l=d,u=o=d=I(d.minus(1),d.plus(1),f,1),p=P(d.times(d),f,1),i=3;;){if(o=P(o.times(p),f,1),C((c=u.plus(I(o,new v(i),f,1))).d).slice(0,f)===C(u.d).slice(0,f)){if(u=u.times(2),0!==a&&(u=u.plus(q(v,f+2,x).times(a+""))),u=I(u,new v(h),f,1),null!=t)return v.precision=x,u;if(!k(u.d,f-10,y,s))return P(u,v.precision=x,y,m=!0);v.precision=f+=10,c=o=d=I(l.minus(1),l.plus(1),f,1),p=P(d.times(d),f,1),i=s=1}u=c,i+=2}}function V(e){return String(e.s*e.s/0)}function W(e,t){var r,n,i;for((r=t.indexOf("."))>-1&&(t=t.replace(".","")),(n=t.search(/e/i))>0?(r<0&&(r=n),r+=+t.slice(n+1),t=t.substring(0,n)):r<0&&(r=t.length),n=0;48===t.charCodeAt(n);n++);for(i=t.length;48===t.charCodeAt(i-1);--i);if(t=t.slice(n,i)){if(i-=n,e.e=r=r-n-1,e.d=[],n=(r+1)%O,r<0&&(n+=O),n<i){for(n&&e.d.push(+t.slice(0,n)),i-=O;n<i;)e.d.push(+t.slice(n,n+=O));t=t.slice(n),n=O-t.length}else n-=i;for(;n--;)t+="0";e.d.push(+t),m&&(e.e>e.constructor.maxE?(e.d=null,e.e=NaN):e.e<e.constructor.minE&&(e.e=0,e.d=[0]))}else e.e=0,e.d=[0];return e}function Y(e,t,r,n,i){var a,o,s,u,c=e.precision,f=Math.ceil(c/O);for(m=!1,u=r.times(r),s=new e(n);;){if(o=I(s.times(u),new e(t++*t++),c,1),s=i?n.plus(o):n.minus(o),n=I(o.times(u),new e(t++*t++),c,1),void 0!==(o=s.plus(n)).d[f]){for(a=f;o.d[a]===s.d[a]&&a--;);if(-1==a)break}a=s,s=n,n=o,o=a,0}return m=!0,o.d.length=f+1,o}function X(e,t){var r,n=t.s<0,i=L(e,e.precision,1),a=i.times(.5);if((t=t.abs()).lte(a))return s=n?4:1,t;if((r=t.divToInt(i)).isZero())s=n?3:2;else{if((t=t.minus(r.times(i))).lte(a))return s=H(r)?n?2:3:n?4:1,t;s=H(r)?n?1:4:n?3:2}return t.minus(i).abs()}function J(e,t,r,n){var i,a,s,u,l,p,h,m,d,g=e.constructor,v=void 0!==r;if(v?(z(r,1,c),void 0===n?n=g.rounding:z(n,0,8)):(r=g.precision,n=g.rounding),e.isFinite()){for(s=(h=R(e)).indexOf("."),v?(i=2,16==t?r=4*r-3:8==t&&(r=3*r-2)):i=t,s>=0&&(h=h.replace(".",""),(d=new g(1)).e=h.length-s,d.d=B(R(d),10,i),d.e=d.d.length),a=l=(m=B(h,10,i)).length;0==m[--l];)m.pop();if(m[0]){if(s<0?a--:((e=new g(e)).d=m,e.e=a,m=(e=I(e,d,r,n,0,i)).d,a=e.e,p=o),s=m[r],u=i/2,p=p||void 0!==m[r+1],p=n<4?(void 0!==s||p)&&(0===n||n===(e.s<0?3:2)):s>u||s===u&&(4===n||p||6===n&&1&m[r-1]||n===(e.s<0?8:7)),m.length=r,p)for(;++m[--r]>i-1;)m[r]=0,r||(++a,m.unshift(1));for(l=m.length;!m[l-1];--l);for(s=0,h="";s<l;s++)h+=f.charAt(m[s]);if(v){if(l>1)if(16==t||8==t){for(s=16==t?4:3,--l;l%s;l++)h+="0";for(l=(m=B(h,i,t)).length;!m[l-1];--l);for(s=1,h="1.";s<l;s++)h+=f.charAt(m[s])}else h=h.charAt(0)+"."+h.slice(1);h=h+(a<0?"p":"p+")+a}else if(a<0){for(;++a;)h="0"+h;h="0."+h}else if(++a>l)for(a-=l;a--;)h+="0";else a<l&&(h=h.slice(0,a)+"."+h.slice(a))}else h=v?"0p+0":"0";h=(16==t?"0x":2==t?"0b":8==t?"0o":"")+h}else h=V(e);return e.s<0?"-"+h:h}function Q(e,t){if(e.length>t)return e.length=t,!0}function K(e){return new this(e).abs()}function ee(e){return new this(e).acos()}function te(e){return new this(e).acosh()}function re(e,t){return new this(e).plus(t)}function ne(e){return new this(e).asin()}function ie(e){return new this(e).asinh()}function ae(e){return new this(e).atan()}function oe(e){return new this(e).atanh()}function se(e,t){e=new this(e),t=new this(t);var r,n=this.precision,i=this.rounding,a=n+4;return e.s&&t.s?e.d||t.d?!t.d||e.isZero()?(r=t.s<0?L(this,n,i):new this(0)).s=e.s:!e.d||t.isZero()?(r=L(this,a,1).times(.5)).s=e.s:t.s<0?(this.precision=a,this.rounding=1,r=this.atan(I(e,t,a,1)),t=L(this,a,1),this.precision=n,this.rounding=i,r=e.s<0?r.minus(t):r.plus(t)):r=this.atan(I(e,t,a,1)):(r=L(this,a,1).times(t.s>0?.25:.75)).s=e.s:r=new this(NaN),r}function ue(e){return new this(e).cbrt()}function ce(e){return P(e=new this(e),e.e+1,2)}function fe(e){if(!e||"object"!=typeof e)throw Error(d+"Object expected");var t,r,n,i=!0===e.defaults,a=["precision",1,c,"rounding",0,8,"toExpNeg",-u,0,"toExpPos",0,u,"maxE",0,u,"minE",-u,0,"modulo",0,9];for(t=0;t<a.length;t+=3)if(r=a[t],i&&(this[r]=h[r]),void 0!==(n=e[r])){if(!(x(n)===n&&n>=a[t+1]&&n<=a[t+2]))throw Error(g+r+": "+n);this[r]=n}if(r="crypto",i&&(this[r]=h[r]),void 0!==(n=e[r])){if(!0!==n&&!1!==n&&0!==n&&1!==n)throw Error(g+r+": "+n);if(n){if("undefined"==typeof crypto||!crypto||!crypto.getRandomValues&&!crypto.randomBytes)throw Error(y);this[r]=!0}else this[r]=!1}return this}function le(e){return new this(e).cos()}function pe(e){return new this(e).cosh()}function he(e,t){return new this(e).div(t)}function me(e){return new this(e).exp()}function de(e){return P(e=new this(e),e.e+1,3)}function ge(){var e,t,r=new this(0);for(m=!1,e=0;e<arguments.length;)if((t=new this(arguments[e++])).d)r.d&&(r=r.plus(t.times(t)));else{if(t.s)return m=!0,new this(1/0);r=t}return m=!0,r.sqrt()}function ve(e){return e instanceof a||e&&"[object Decimal]"===e.name||!1}function ye(e){return new this(e).ln()}function xe(e,t){return new this(e).log(t)}function we(e){return new this(e).log(2)}function be(e){return new this(e).log(10)}function Ne(){return $(this,arguments,"lt")}function Ee(){return $(this,arguments,"gt")}function Me(e,t){return new this(e).mod(t)}function Ae(e,t){return new this(e).mul(t)}function Oe(e,t){return new this(e).pow(t)}function Te(e){var t,r,n,i,a=0,o=new this(1),s=[];if(void 0===e?e=this.precision:z(e,1,c),n=Math.ceil(e/O),this.crypto)if(crypto.getRandomValues)for(t=crypto.getRandomValues(new Uint32Array(n));a<n;)(i=t[a])>=429e7?t[a]=crypto.getRandomValues(new Uint32Array(1))[0]:s[a++]=i%1e7;else{if(!crypto.randomBytes)throw Error(y);for(t=crypto.randomBytes(n*=4);a<n;)(i=t[a]+(t[a+1]<<8)+(t[a+2]<<16)+((127&t[a+3])<<24))>=214e7?crypto.randomBytes(4).copy(t,a):(s.push(i%1e7),a+=4);a=n/4}else for(;a<n;)s[a++]=1e7*Math.random()|0;for(n=s[--a],e%=O,n&&e&&(i=w(10,O-e),s[a]=(n/i|0)*i);0===s[a];a--)s.pop();if(a<0)r=0,s=[0];else{for(r=-1;0===s[0];r-=O)s.shift();for(n=1,i=s[0];i>=10;i/=10)n++;n<O&&(r-=O-n)}return o.e=r,o.d=s,o}function Se(e){return P(e=new this(e),e.e+1,this.rounding)}function _e(e){return(e=new this(e)).d?e.d[0]?e.s:0*e.s:e.s||NaN}function Ce(e){return new this(e).sin()}function ze(e){return new this(e).sinh()}function ke(e){return new this(e).sqrt()}function Be(e,t){return new this(e).sub(t)}function Ie(e){return new this(e).tan()}function Pe(e){return new this(e).tanh()}function Re(e){return P(e=new this(e),e.e+1,1)}(a=function e(t){var r,n,i;function o(e){var t,r,n,i=this;if(!(i instanceof o))return new o(e);if(i.constructor=o,e instanceof o)return i.s=e.s,i.e=e.e,void(i.d=(e=e.d)?e.slice():e);if("number"==(n=typeof e)){if(0===e)return i.s=1/e<0?-1:1,i.e=0,void(i.d=[0]);if(e<0?(e=-e,i.s=-1):i.s=1,e===~~e&&e<1e7){for(t=0,r=e;r>=10;r/=10)t++;return i.e=t,void(i.d=[e])}return 0*e!=0?(e||(i.s=NaN),i.e=NaN,void(i.d=null)):W(i,e.toString())}if("string"!==n)throw Error(g+e);return 45===e.charCodeAt(0)?(e=e.slice(1),i.s=-1):i.s=1,M.test(e)?W(i,e):function(e,t){var r,n,i,o,s,u,c,f,l;if("Infinity"===t||"NaN"===t)return+t||(e.s=NaN),e.e=NaN,e.d=null,e;if(N.test(t))r=16,t=t.toLowerCase();else if(b.test(t))r=2;else{if(!E.test(t))throw Error(g+t);r=8}for((o=t.search(/p/i))>0?(c=+t.slice(o+1),t=t.substring(2,o)):t=t.slice(2),s=(o=t.indexOf("."))>=0,n=e.constructor,s&&(o=(u=(t=t.replace(".","")).length)-o,i=D(n,new n(r),o,2*o)),o=l=(f=B(t,r,A)).length-1;0===f[o];--o)f.pop();return o<0?new n(0*e.s):(e.e=U(f,l),e.d=f,m=!1,s&&(e=I(e,i,4*u)),c&&(e=e.times(Math.abs(c)<54?Math.pow(2,c):a.pow(2,c))),m=!0,e)}(i,e)}if(o.prototype=_,o.ROUND_UP=0,o.ROUND_DOWN=1,o.ROUND_CEIL=2,o.ROUND_FLOOR=3,o.ROUND_HALF_UP=4,o.ROUND_HALF_DOWN=5,o.ROUND_HALF_EVEN=6,o.ROUND_HALF_CEIL=7,o.ROUND_HALF_FLOOR=8,o.EUCLID=9,o.config=o.set=fe,o.clone=e,o.isDecimal=ve,o.abs=K,o.acos=ee,o.acosh=te,o.add=re,o.asin=ne,o.asinh=ie,o.atan=ae,o.atanh=oe,o.atan2=se,o.cbrt=ue,o.ceil=ce,o.cos=le,o.cosh=pe,o.div=he,o.exp=me,o.floor=de,o.hypot=ge,o.ln=ye,o.log=xe,o.log10=be,o.log2=we,o.max=Ne,o.min=Ee,o.mod=Me,o.mul=Ae,o.pow=Oe,o.random=Te,o.round=Se,o.sign=_e,o.sin=Ce,o.sinh=ze,o.sqrt=ke,o.sub=Be,o.tan=Ie,o.tanh=Pe,o.trunc=Re,void 0===t&&(t={}),t&&!0!==t.defaults)for(i=["precision","rounding","toExpNeg","toExpPos","maxE","minE","modulo","crypto"],r=0;r<i.length;)t.hasOwnProperty(n=i[r++])||(t[n]=this[n]);return o.config(t),o}(h)).default=a.Decimal=a,l=new a(l),p=new a(p),void 0===(n=function(){return a}.call(t,r,t,e))||(e.exports=n)}()},function(e,t,r){"use strict";var n=r(1);t.name="bignumber",t.factory=function(e,t,r,i){var a=i("bignumber",{"":function(){return new e.BigNumber(0)},number:function(t){return new e.BigNumber(t+"")},string:function(t){return new e.BigNumber(t)},BigNumber:function(e){return e},Fraction:function(t){return new e.BigNumber(t.n).div(t.d)},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={0:"0",1:"\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);t.name="boolean",t.factory=function(e,t,r,i){var a=i("bool",{"":function(){return!1},boolean:function(e){return e},number:function(e){return!!e},BigNumber:function(e){return!e.isZero()},string:function(e){var t=e.toLowerCase();if("true"===t)return!0;if("false"===t)return!1;var r=Number(e);if(""!=e&&!isNaN(r))return!!r;throw new Error('Cannot convert "'+e+'" to a boolean')},"Array | Matrix":function(e){return n(e,a)}});return a}},function(e,t,r){e.exports=[r(167),r(169)]},function(e,t,r){"use strict";var n=r(9).format,i=r(5).lazy;t.name="Chain",t.path="type",t.factory=function(e,t,r,a,o){function s(t){if(!(this instanceof s))throw new SyntaxError("Constructor must be called with the new operator");e.isChain(t)?this.value=t.value:this.value=t}function u(e,t){"function"==typeof t&&(s.prototype[e]=c(t))}function c(e){return function(){for(var t=[this.value],r=0;r<arguments.length;r++)t[r+1]=arguments[r];return new s(e.apply(e,t))}}return s.prototype.type="Chain",s.prototype.isChain=!0,s.prototype.done=function(){return this.value},s.prototype.valueOf=function(){return this.value},s.prototype.toString=function(){return n(this.value)},s.createProxy=function(e,t){if("string"==typeof e)u(e,t);else for(var r in e)e.hasOwnProperty(r)&&u(r,e[r])},s.createProxy(o),o.on("import",function(e,t,r){var n,a;void 0===r&&(n=e,a=t,i(s.prototype,n,function(){var e=a();if("function"==typeof e)return c(e)}))}),s},t.math=!0,t.lazy=!1},function(e,t){t.format=function(e,r){if("function"==typeof r)return r(e);if(!e.isFinite())return e.isNaN()?"NaN":e.gt(0)?"Infinity":"-Infinity";var n="auto",i=void 0;switch(void 0!==r&&(r.notation&&(n=r.notation),"number"==typeof r?i=r:r.precision&&(i=r.precision)),n){case"fixed":return t.toFixed(e,i);case"exponential":return t.toExponential(e,i);case"auto":var a=.001,o=1e5;r&&r.exponential&&(void 0!==r.exponential.lower&&(a=r.exponential.lower),void 0!==r.exponential.upper&&(o=r.exponential.upper));e.constructor.toExpNeg,e.constructor.toExpPos;if(e.constructor.config({toExpNeg:Math.round(Math.log(a)/Math.LN10),toExpPos:Math.round(Math.log(o)/Math.LN10)}),e.isZero())return"0";var s=e.abs();return(s.gte(a)&&s.lt(o)?e.toSignificantDigits(i).toFixed():t.toExponential(e,i)).replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],t=arguments[4];return"."!==e?e+t:t});default:throw new Error('Unknown notation "'+n+'". Choose "auto", "exponential", or "fixed".')}},t.toExponential=function(e,t){return void 0!==t?e.toExponential(t-1):e.toExponential()},t.toFixed=function(e,t){return e.toFixed(t||0)}},function(e,t,r){"use strict";t.name="chain",t.factory=function(e,t,r,n){return n("chain",{"":function(){return new e.Chain},any:function(t){return new e.Chain(t)}})}},function(e,t,r){e.exports=[r(92),r(172)]},function(e,t,r){var n;
/**
 * @license Complex.js v2.0.3 11/02/2016
 *
 * Copyright (c) 2016, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
/**
 * @license Complex.js v2.0.3 11/02/2016
 *
 * Copyright (c) 2016, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
!function(r){"use strict";var i={re:0,im:0},a=function(e){return.5*(Math.exp(e)+Math.exp(-e))},o=function(e){return.5*(Math.exp(e)-Math.exp(-e))},s=function(){throw SyntaxError("Invalid Param")};function u(e,t){var r=Math.abs(e),n=Math.abs(t);return 0===e?Math.log(n):0===t?Math.log(r):r<3e3&&n<3e3?.5*Math.log(e*e+t*t):Math.log(e/Math.cos(Math.atan2(t,e)))}var c=function(e,t){if(void 0===e||null===e)i.re=i.im=0;else if(void 0!==t)i.re=e,i.im=t;else switch(typeof e){case"object":"im"in e&&"re"in e?(i.re=e.re,i.im=e.im):"abs"in e&&"arg"in e?(i.re=e.abs*Math.cos(e.arg),i.im=e.abs*Math.sin(e.arg)):"r"in e&&"phi"in e?(i.re=e.r*Math.cos(e.phi),i.im=e.r*Math.sin(e.phi)):2===e.length?(i.re=e[0],i.im=e[1]):s();break;case"string":i.im=i.re=0;var r=e.match(/\d+\.?\d*e[+-]?\d+|\d+\.?\d*|\.\d+|./g),n=1,a=0;null===r&&s();for(var o=0;o<r.length;o++){var u=r[o];" "===u||"\t"===u||"\n"===u||("+"===u?n++:"-"===u?a++:"i"===u||"I"===u?(n+a===0&&s()," "===r[o+1]||isNaN(r[o+1])?i.im+=parseFloat((a%2?"-":"")+"1"):(i.im+=parseFloat((a%2?"-":"")+r[o+1]),o++),n=a=0):((n+a===0||isNaN(u))&&s(),"i"===r[o+1]||"I"===r[o+1]?(i.im+=parseFloat((a%2?"-":"")+u),o++):i.re+=parseFloat((a%2?"-":"")+u),n=a=0))}n+a>0&&s();break;case"number":i.im=0,i.re=e;break;default:s()}isNaN(i.re)||isNaN(i.im)};function f(e,t){if(!(this instanceof f))return new f(e,t);c(e,t),this.re=i.re,this.im=i.im}f.prototype={re:0,im:0,sign:function(){var e=this.abs();return new f(this.re/e,this.im/e)},add:function(e,t){return c(e,t),new f(this.re+i.re,this.im+i.im)},sub:function(e,t){return c(e,t),new f(this.re-i.re,this.im-i.im)},mul:function(e,t){return c(e,t),0===i.im&&0===this.im?new f(this.re*i.re,0):new f(this.re*i.re-this.im*i.im,this.re*i.im+this.im*i.re)},div:function(e,t){c(e,t),e=this.re,t=this.im;var r,n,a=i.re,o=i.im;return 0===o?0===a?new f(0!==e?e/0:0,0!==t?t/0:0):new f(e/a,t/a):Math.abs(a)<Math.abs(o)?new f((e*(n=a/o)+t)/(r=a*n+o),(t*n-e)/r):new f((e+t*(n=o/a))/(r=o*n+a),(t-e*n)/r)},pow:function(e,t){if(c(e,t),e=this.re,t=this.im,0===e&&0===t)return f.ZERO;if(0===i.im){if(0===t&&e>=0)return new f(Math.pow(e,i.re),0);if(0===e)switch((i.re%4+4)%4){case 0:return new f(Math.pow(t,i.re),0);case 1:return new f(0,Math.pow(t,i.re));case 2:return new f(-Math.pow(t,i.re),0);case 3:return new f(0,-Math.pow(t,i.re))}}var r=Math.atan2(t,e),n=u(e,t);return e=Math.exp(i.re*n-i.im*r),t=i.im*n+i.re*r,new f(e*Math.cos(t),e*Math.sin(t))},sqrt:function(){var e,t,r=this.re,n=this.im,i=this.abs();if(r>=0){if(0===n)return new f(Math.sqrt(r),0);e=.5*Math.sqrt(2*(i+r))}else e=Math.abs(n)/Math.sqrt(2*(i-r));return t=r<=0?.5*Math.sqrt(2*(i-r)):Math.abs(n)/Math.sqrt(2*(i+r)),new f(e,n<0?-t:t)},exp:function(){var e=Math.exp(this.re);return this.im,new f(e*Math.cos(this.im),e*Math.sin(this.im))},log:function(){var e=this.re,t=this.im;return new f(u(e,t),Math.atan2(t,e))},abs:function(){return e=this.re,t=this.im,r=Math.abs(e),n=Math.abs(t),r<3e3&&n<3e3?Math.sqrt(r*r+n*n):(r<n?(r=n,n=e/t):n=t/e,r*Math.sqrt(1+n*n));var e,t,r,n},arg:function(){return Math.atan2(this.im,this.re)},sin:function(){var e=this.re,t=this.im;return new f(Math.sin(e)*a(t),Math.cos(e)*o(t))},cos:function(){var e=this.re,t=this.im;return new f(Math.cos(e)*a(t),-Math.sin(e)*o(t))},tan:function(){var e=2*this.re,t=2*this.im,r=Math.cos(e)+a(t);return new f(Math.sin(e)/r,o(t)/r)},cot:function(){var e=2*this.re,t=2*this.im,r=Math.cos(e)-a(t);return new f(-Math.sin(e)/r,o(t)/r)},sec:function(){var e=this.re,t=this.im,r=.5*a(2*t)+.5*Math.cos(2*e);return new f(Math.cos(e)*a(t)/r,Math.sin(e)*o(t)/r)},csc:function(){var e=this.re,t=this.im,r=.5*a(2*t)-.5*Math.cos(2*e);return new f(Math.sin(e)*a(t)/r,-Math.cos(e)*o(t)/r)},asin:function(){var e=this.re,t=this.im,r=new f(t*t-e*e+1,-2*e*t).sqrt(),n=new f(r.re-t,r.im+e).log();return new f(n.im,-n.re)},acos:function(){var e=this.re,t=this.im,r=new f(t*t-e*e+1,-2*e*t).sqrt(),n=new f(r.re-t,r.im+e).log();return new f(Math.PI/2-n.im,n.re)},atan:function(){var e=this.re,t=this.im;if(0===e){if(1===t)return new f(0,1/0);if(-1===t)return new f(0,-1/0)}var r=e*e+(1-t)*(1-t),n=new f((1-t*t-e*e)/r,-2*e/r).log();return new f(-.5*n.im,.5*n.re)},acot:function(){var e=this.re,t=this.im;if(0===t)return new f(Math.atan2(1,e),0);var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).atan():new f(0!==e?e/0:0,0!==t?-t/0:0).atan()},asec:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new f(0,1/0);var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).acos():new f(0!==e?e/0:0,0!==t?-t/0:0).acos()},acsc:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new f(Math.PI/2,1/0);var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).asin():new f(0!==e?e/0:0,0!==t?-t/0:0).asin()},sinh:function(){var e=this.re,t=this.im;return new f(o(e)*Math.cos(t),a(e)*Math.sin(t))},cosh:function(){var e=this.re,t=this.im;return new f(a(e)*Math.cos(t),o(e)*Math.sin(t))},tanh:function(){var e=2*this.re,t=2*this.im,r=a(e)+Math.cos(t);return new f(o(e)/r,Math.sin(t)/r)},coth:function(){var e=2*this.re,t=2*this.im,r=a(e)-Math.cos(t);return new f(o(e)/r,-Math.sin(t)/r)},csch:function(){var e=this.re,t=this.im,r=Math.cos(2*t)-a(2*e);return new f(-2*o(e)*Math.cos(t)/r,2*a(e)*Math.sin(t)/r)},sech:function(){var e=this.re,t=this.im,r=Math.cos(2*t)+a(2*e);return new f(2*a(e)*Math.cos(t)/r,-2*o(e)*Math.sin(t)/r)},asinh:function(){var e=this.im;this.im=-this.re,this.re=e;var t=this.asin();return this.re=-this.im,this.im=e,e=t.re,t.re=-t.im,t.im=e,t},acosh:function(){var e,t=this.acos();return t.im<=0?(e=t.re,t.re=-t.im,t.im=e):(e=t.im,t.im=-t.re,t.re=e),t},atanh:function(){var e=this.re,t=this.im,r=e>1&&0===t,n=1-e,i=1+e,a=n*n+t*t,o=0!==a?new f((i*n-t*t)/a,(t*n+i*t)/a):new f(-1!==e?e/0:0,0!==t?t/0:0),s=o.re;return o.re=u(o.re,o.im)/2,o.im=Math.atan2(o.im,s)/2,r&&(o.im=-o.im),o},acoth:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new f(0,Math.PI/2);var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).atanh():new f(0!==e?e/0:0,0!==t?-t/0:0).atanh()},acsch:function(){var e=this.re,t=this.im;if(0===t)return new f(0!==e?Math.log(e+Math.sqrt(e*e+1)):1/0,0);var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).asinh():new f(0!==e?e/0:0,0!==t?-t/0:0).asinh()},asech:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new f(1/0,0);var r=e*e+t*t;return 0!==r?new f(e/r,-t/r).acosh():new f(0!==e?e/0:0,0!==t?-t/0:0).acosh()},inverse:function(){var e=this.re,t=this.im,r=e*e+t*t;return new f(0!==e?e/r:0,0!==t?-t/r:0)},conjugate:function(){return new f(this.re,-this.im)},neg:function(){return new f(-this.re,-this.im)},ceil:function(e){return e=Math.pow(10,e||0),new f(Math.ceil(this.re*e)/e,Math.ceil(this.im*e)/e)},floor:function(e){return e=Math.pow(10,e||0),new f(Math.floor(this.re*e)/e,Math.floor(this.im*e)/e)},round:function(e){return e=Math.pow(10,e||0),new f(Math.round(this.re*e)/e,Math.round(this.im*e)/e)},equals:function(e,t){return c(e,t),Math.abs(i.re-this.re)<=f.EPSILON&&Math.abs(i.im-this.im)<=f.EPSILON},clone:function(){return new f(this.re,this.im)},toString:function(){var e=this.re,t=this.im,r="";return isNaN(e)||isNaN(t)?"NaN":(0!==e&&(r+=e),0!==t&&(0!==e?r+=t<0?" - ":" + ":t<0&&(r+="-"),1!==(t=Math.abs(t))&&(r+=t),r+="i"),r||"0")},toVector:function(){return[this.re,this.im]},valueOf:function(){return 0===this.im?this.re:null},isNaN:function(){return isNaN(this.re)||isNaN(this.im)},isFinite:function(){return isFinite(this.re)&&isFinite(this.im)}},f.ZERO=new f(0,0),f.ONE=new f(1,0),f.I=new f(0,1),f.PI=new f(Math.PI,0),f.E=new f(Math.E,0),f.EPSILON=1e-16,void 0===(n=function(){return f}.apply(t,[]))||(e.exports=n)}()},function(e,t,r){"use strict";var n=r(1);t.name="complex",t.factory=function(e,t,i,a){var o=r(4),s=a("complex",{"":function(){return e.Complex.ZERO},number:function(t){return new e.Complex(t,0)},"number, number":function(t,r){return new e.Complex(t,r)},"BigNumber, BigNumber":function(t,r){return new e.Complex(t.toNumber(),r.toNumber())},Complex:function(e){return e.clone()},string:function(t){return e.Complex(t)},Object:function(t){if("re"in t&&"im"in t)return new e.Complex(t.re,t.im);if("r"in t&&"phi"in t)return new e.Complex(t);throw new Error("Expected object with either properties re and im, or properties r and phi.")},"Array | Matrix":function(e){return n(e,s)}});return s.toTex={0:"0",1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)+"+o.symbols.i+"\\cdot\\left(${args[1]}\\right)\\right)"},s}},function(e,t,r){"use strict";var n={"{":"\\{","}":"\\}","\\":"\\textbackslash{}","#":"\\#",$:"\\$","%":"\\%","&":"\\&","^":"\\textasciicircum{}",_:"\\_","~":"\\textasciitilde{}"},i={"–":"\\--","—":"\\---"," ":"~","\t":"\\qquad{}","\r\n":"\\\\newline{}","\n":"\\\\newline{}"},a=function(e,t){return Object.assign({},e,t)};e.exports=function(e){for(var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=t.preserveFormatting,o=void 0!==r&&r,s=t.escapeMapFn,u=void 0===s?a:s,c=String(e),f="",l=u(Object.assign({},n),o?Object.assign({},i):{}),p=Object.keys(l),h=function(){var e=!1;p.forEach(function(t,r){e||c.startsWith(t)&&(f+=l[p[r]],c=c.slice(t.length,c.length),e=!0)}),e||(f+=c.slice(0,1),c=c.slice(1,c.length))};c;)h();return f}},function(e,t,r){e.exports=[r(175),r(93)]},function(e,t,r){var n=r(176);n.prototype.type="Fraction",n.prototype.isFraction=!0,n.prototype.toJSON=function(){return{mathjs:"Fraction",n:this.s*this.n,d:this.d}},n.fromJSON=function(e){return new n(e)},t.name="Fraction",t.path="type",t.factory=function(e,t,r,i){return n}},function(e,t,r){var n;
/**
 * @license Fraction.js v4.0.4 09/09/2015
 * http://www.xarg.org/2014/03/rational-numbers-in-javascript/
 *
 * Copyright (c) 2015, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
/**
 * @license Fraction.js v4.0.4 09/09/2015
 * http://www.xarg.org/2014/03/rational-numbers-in-javascript/
 *
 * Copyright (c) 2015, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
!function(r){"use strict";var i={s:1,n:0,d:1};function a(e){var t=function(){var t=Error.apply(this,arguments);t.name=this.name=e,this.stack=t.stack,this.message=t.message},r=function(){};return r.prototype=Error.prototype,t.prototype=new r,t}var o=p.DivisionByZero=a("DivisionByZero"),s=p.InvalidParameter=a("InvalidParameter");function u(e,t){return isNaN(e=parseInt(e,10))&&c(),e*t}function c(){throw new s}var f=function(e,t){var r,n=0,a=1,s=1,f=0,l=0,p=0,h=1,m=1,d=0,g=1,v=1,y=1;if(void 0===e||null===e);else if(void 0!==t)s=(n=e)*(a=t);else switch(typeof e){case"object":"d"in e&&"n"in e?(n=e.n,a=e.d,"s"in e&&(n*=e.s)):0 in e?(n=e[0],1 in e&&(a=e[1])):c(),s=n*a;break;case"number":if(e<0&&(s=e,e=-e),e%1==0)n=e;else if(e>0){for(e>=1&&(e/=m=Math.pow(10,Math.floor(1+Math.log(e)/Math.LN10)));g<=1e7&&y<=1e7;){if(e===(r=(d+v)/(g+y))){g+y<=1e7?(n=d+v,a=g+y):y>g?(n=v,a=y):(n=d,a=g);break}e>r?(d+=v,g+=y):(v+=d,y+=g),g>1e7?(n=v,a=y):(n=d,a=g)}n*=m}else(isNaN(e)||isNaN(t))&&(a=n=NaN);break;case"string":if(null===(g=e.match(/\d+|./g))&&c(),"-"===g[d]?(s=-1,d++):"+"===g[d]&&d++,g.length===d+1?l=u(g[d++],s):"."===g[d+1]||"."===g[d]?("."!==g[d]&&(f=u(g[d++],s)),(++d+1===g.length||"("===g[d+1]&&")"===g[d+3]||"'"===g[d+1]&&"'"===g[d+3])&&(l=u(g[d],s),h=Math.pow(10,g[d].length),d++),("("===g[d]&&")"===g[d+2]||"'"===g[d]&&"'"===g[d+2])&&(p=u(g[d+1],s),m=Math.pow(10,g[d+1].length)-1,d+=3)):"/"===g[d+1]||":"===g[d+1]?(l=u(g[d],s),h=u(g[d+2],1),d+=3):"/"===g[d+3]&&" "===g[d+1]&&(f=u(g[d],s),l=u(g[d+2],s),h=u(g[d+4],1),d+=5),g.length<=d){s=n=p+(a=h*m)*f+m*l;break}default:c()}if(0===a)throw new o;i.s=s<0?-1:1,i.n=Math.abs(n),i.d=Math.abs(a)},l=function(e,t){if(!e)return t;if(!t)return e;for(;;){if(!(e%=t))return t;if(!(t%=e))return e}};function p(e,t){if(!(this instanceof p))return new p(e,t);f(e,t),e=p.REDUCE?l(i.d,i.n):1,this.s=i.s,this.n=i.n/e,this.d=i.d/e}p.REDUCE=1,p.prototype={s:1,n:0,d:1,abs:function(){return new p(this.n,this.d)},neg:function(){return new p(-this.s*this.n,this.d)},add:function(e,t){return f(e,t),new p(this.s*this.n*i.d+i.s*this.d*i.n,this.d*i.d)},sub:function(e,t){return f(e,t),new p(this.s*this.n*i.d-i.s*this.d*i.n,this.d*i.d)},mul:function(e,t){return f(e,t),new p(this.s*i.s*this.n*i.n,this.d*i.d)},div:function(e,t){return f(e,t),new p(this.s*i.s*this.n*i.d,this.d*i.n)},clone:function(){return new p(this)},mod:function(e,t){return isNaN(this.n)||isNaN(this.d)?new p(NaN):void 0===e?new p(this.s*this.n%this.d,1):(f(e,t),0===i.n&&0===this.d&&p(0,0),new p(this.s*i.d*this.n%(i.n*this.d),i.d*this.d))},gcd:function(e,t){return f(e,t),new p(l(i.n,this.n),i.d*this.d/l(i.d,this.d))},lcm:function(e,t){return f(e,t),0===i.n&&0===this.n?new p:new p(i.n*this.n/l(i.n,this.n),l(i.d,this.d))},ceil:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new p(NaN):new p(Math.ceil(e*this.s*this.n/this.d),e)},floor:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new p(NaN):new p(Math.floor(e*this.s*this.n/this.d),e)},round:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new p(NaN):new p(Math.round(e*this.s*this.n/this.d),e)},inverse:function(){return new p(this.s*this.d,this.n)},pow:function(e){return e<0?new p(Math.pow(this.s*this.d,-e),Math.pow(this.n,-e)):new p(Math.pow(this.s*this.n,e),Math.pow(this.d,e))},equals:function(e,t){return f(e,t),this.s*this.n*i.d==i.s*i.n*this.d},compare:function(e,t){f(e,t);var r=this.s*this.n*i.d-i.s*i.n*this.d;return(0<r)-(r<0)},divisible:function(e,t){return f(e,t),!(!(i.n*this.d)||this.n*i.d%(i.n*this.d))},valueOf:function(){return this.s*this.n/this.d},toFraction:function(e){var t,r="",n=this.n,i=this.d;return this.s<0&&(r+="-"),1===i?r+=n:(e&&(t=Math.floor(n/i))>0&&(r+=t,r+=" ",n%=i),r+=n,r+="/",r+=i),r},toLatex:function(e){var t,r="",n=this.n,i=this.d;return this.s<0&&(r+="-"),1===i?r+=n:(e&&(t=Math.floor(n/i))>0&&(r+=t,n%=i),r+="\\frac{",r+=n,r+="}{",r+=i,r+="}"),r},toContinued:function(){var e,t=this.n,r=this.d,n=[];do{n.push(Math.floor(t/r)),e=t%r,t=r,r=e}while(1!==t);return n},toString:function(){var e,t=this.n,r=this.d;if(isNaN(t)||isNaN(r))return"NaN";p.REDUCE||(t/=e=l(t,r),r/=e);var n=function(e,t){for(;t%2==0;t/=2);for(;t%5==0;t/=5);if(1===t)return 0;for(var r=10%t,n=1;1!==r;n++)if(r=10*r%t,n>2e3)return 0;return n}(0,r),i=function(e,t,r){for(var n=1,i=function(e,t,r){for(var n=1;t>0;e=e*e%r,t>>=1)1&t&&(n=n*e%r);return n}(10,r,t),a=0;a<300;a++){if(n===i)return a;n=10*n%t,i=10*i%t}return 0}(0,r,n),a=-1===this.s?"-":"";if(a+=t/r|0,t%=r,(t*=10)&&(a+="."),n){for(var o=i;o--;)a+=t/r|0,t%=r,t*=10;a+="(";for(o=n;o--;)a+=t/r|0,t%=r,t*=10;a+=")"}else for(o=15;t&&o--;)a+=t/r|0,t%=r,t*=10;return a}},void 0===(n=function(){return p}.apply(t,[]))||(e.exports=n)}()},function(e,t,r){e.exports=[r(72),r(45),r(179),r(180),r(181),r(182),r(27),r(94),r(183),r(0),r(184)]},function(e,t,r){"use strict";t.isBoolean=function(e){return"boolean"==typeof e}},function(e,t,r){"use strict";var n=r(25),i=r(11),a=n.array,o=n.object,s=n.string,u=n.number,c=Array.isArray,f=u.isNumber,l=u.isInteger,p=s.isString,h=a.validateIndex;t.name="SparseMatrix",t.path="type",t.factory=function(e,t,m,d){var g=m(r(72)),v=m(r(10));function y(t,r){if(!(this instanceof y))throw new SyntaxError("Constructor must be called with the new operator");if(r&&!p(r))throw new Error("Invalid datatype: "+r);if(e.isMatrix(t))x(this,t,r);else if(t&&c(t.index)&&c(t.ptr)&&c(t.size))this._values=t.values,this._index=t.index,this._ptr=t.ptr,this._size=t.size,this._datatype=r||t.datatype;else if(c(t))w(this,t,r);else{if(t)throw new TypeError("Unsupported type of data ("+n.types.type(t)+")");this._values=[],this._index=[],this._ptr=[0],this._size=[0,0],this._datatype=r}}var x=function(e,t,r){"SparseMatrix"===t.type?(e._values=t._values?o.clone(t._values):void 0,e._index=o.clone(t._index),e._ptr=o.clone(t._ptr),e._size=o.clone(t._size),e._datatype=r||t._datatype):w(e,t.valueOf(),r||t._datatype)},w=function(e,t,r){e._values=[],e._index=[],e._ptr=[],e._datatype=r;var n=t.length,i=0,a=v,o=0;if(p(r)&&(a=d.find(v,[r,r])||v,o=d.convert(0,r)),n>0){var s=0;do{e._ptr.push(e._index.length);for(var u=0;u<n;u++){var f=t[u];if(c(f)){if(0===s&&i<f.length&&(i=f.length),s<f.length){var l=f[s];a(l,o)||(e._values.push(l),e._index.push(u))}}else 0===s&&i<1&&(i=1),a(f,o)||(e._values.push(f),e._index.push(u))}s++}while(s<i)}e._ptr.push(e._index.length),e._size=[n,i]};y.prototype=new g,y.prototype.type="SparseMatrix",y.prototype.isSparseMatrix=!0,y.prototype.storage=function(){return"sparse"},y.prototype.datatype=function(){return this._datatype},y.prototype.create=function(e,t){return new y(e,t)},y.prototype.density=function(){var e=this._size[0],t=this._size[1];return 0!==e&&0!==t?this._index.length/(e*t):0},y.prototype.subset=function(e,t,r){if(!this._values)throw new Error("Cannot invoke subset on a Pattern only matrix");switch(arguments.length){case 1:return b(this,e);case 2:case 3:return N(this,e,t,r);default:throw new SyntaxError("Wrong number of arguments")}};var b=function(t,r){if(!e.isIndex(r))throw new TypeError("Invalid index");if(r.isScalar())return t.get(r.min());var n,a,o,s,u=r.size();if(u.length!=t._size.length)throw new i(u.length,t._size.length);var c=r.min(),f=r.max();for(n=0,a=t._size.length;n<a;n++)h(c[n],t._size[n]),h(f[n],t._size[n]);var l=t._values,p=t._index,m=t._ptr,d=r.dimension(0),g=r.dimension(1),v=[],x=[];d.forEach(function(e,t){x[e]=t[0],v[e]=!0});var w=l?[]:void 0,b=[],N=[];return g.forEach(function(e){for(N.push(b.length),o=m[e],s=m[e+1];o<s;o++)n=p[o],!0===v[n]&&(b.push(x[n]),w&&w.push(l[o]))}),N.push(b.length),new y({values:w,index:b,ptr:N,size:u,datatype:t._datatype})},N=function(t,r,n,s){if(!r||!0!==r.isIndex)throw new TypeError("Invalid index");var u,c=r.size(),f=r.isScalar();if(e.isMatrix(n)?(u=n.size(),n=n.toArray()):u=a.size(n),f){if(0!==u.length)throw new TypeError("Scalar expected");t.set(r.min(),n,s)}else{if(1!==c.length&&2!==c.length)throw new i(c.length,t._size.length,"<");if(u.length<c.length){for(var l=0,p=0;1===c[l]&&1===u[l];)l++;for(;1===c[l];)p++,l++;n=a.unsqueeze(n,c.length,p,u)}if(!o.deepEqual(c,u))throw new i(c,u,">");for(var h=r.min()[0],m=r.min()[1],d=u[0],g=u[1],v=0;v<d;v++)for(var y=0;y<g;y++){var x=n[v][y];t.set([v+h,y+m],x,s)}}return t};y.prototype.get=function(e){if(!c(e))throw new TypeError("Array expected");if(e.length!=this._size.length)throw new i(e.length,this._size.length);if(!this._values)throw new Error("Cannot invoke get on a Pattern only matrix");var t=e[0],r=e[1];h(t,this._size[0]),h(r,this._size[1]);var n=E(t,this._ptr[r],this._ptr[r+1],this._index);return n<this._ptr[r+1]&&this._index[n]===t?this._values[n]:0},y.prototype.set=function(e,t,r){if(!c(e))throw new TypeError("Array expected");if(e.length!=this._size.length)throw new i(e.length,this._size.length);if(!this._values)throw new Error("Cannot invoke set on a Pattern only matrix");var n=e[0],a=e[1],o=this._size[0],s=this._size[1],u=v,f=0;p(this._datatype)&&(u=d.find(v,[this._datatype,this._datatype])||v,f=d.convert(0,this._datatype)),(n>o-1||a>s-1)&&(O(this,Math.max(n+1,o),Math.max(a+1,s),r),o=this._size[0],s=this._size[1]),h(n,o),h(a,s);var l=E(n,this._ptr[a],this._ptr[a+1],this._index);return l<this._ptr[a+1]&&this._index[l]===n?u(t,f)?M(l,a,this._values,this._index,this._ptr):this._values[l]=t:A(l,n,a,t,this._values,this._index,this._ptr),this};var E=function(e,t,r,n){if(r-t==0)return r;for(var i=t;i<r;i++)if(n[i]===e)return i;return t},M=function(e,t,r,n,i){r.splice(e,1),n.splice(e,1);for(var a=t+1;a<i.length;a++)i[a]--},A=function(e,t,r,n,i,a,o){i.splice(e,0,n),a.splice(e,0,t);for(var s=r+1;s<o.length;s++)o[s]++};y.prototype.resize=function(e,t,r){if(!c(e))throw new TypeError("Array expected");if(2!==e.length)throw new Error("Only two dimensions matrix are supported");e.forEach(function(t){if(!u.isNumber(t)||!u.isInteger(t)||t<0)throw new TypeError("Invalid size, must contain positive integers (size: "+s.format(e)+")")});var n=r?this.clone():this;return O(n,e[0],e[1],t)};var O=function(e,t,r,n){var i=n||0,a=v,o=0;p(e._datatype)&&(a=d.find(v,[e._datatype,e._datatype])||v,o=d.convert(0,e._datatype),i=d.convert(i,e._datatype));var s,u,c,f=!a(i,o),l=e._size[0],h=e._size[1];if(r>h){for(u=h;u<r;u++)if(e._ptr[u]=e._values.length,f)for(s=0;s<l;s++)e._values.push(i),e._index.push(s);e._ptr[r]=e._values.length}else r<h&&(e._ptr.splice(r+1,h-r),e._values.splice(e._ptr[r],e._values.length),e._index.splice(e._ptr[r],e._index.length));if(h=r,t>l){if(f){var m=0;for(u=0;u<h;u++){e._ptr[u]=e._ptr[u]+m,c=e._ptr[u+1]+m;var g=0;for(s=l;s<t;s++,g++)e._values.splice(c+g,0,i),e._index.splice(c+g,0,s),m++}e._ptr[h]=e._values.length}}else if(t<l){var y=0;for(u=0;u<h;u++){e._ptr[u]=e._ptr[u]-y;var x=e._ptr[u],w=e._ptr[u+1]-y;for(c=x;c<w;c++)(s=e._index[c])>t-1&&(e._values.splice(c,1),e._index.splice(c,1),y++)}e._ptr[u]=e._values.length}return e._size[0]=t,e._size[1]=r,e};y.prototype.reshape=function(e,t){if(!c(e))throw new TypeError("Array expected");if(2!==e.length)throw new Error("Sparse matrices can only be reshaped in two dimensions");if(e.forEach(function(t){if(!u.isNumber(t)||!u.isInteger(t)||t<0)throw new TypeError("Invalid size, must contain positive integers (size: "+s.format(e)+")")}),this._size[0]*this._size[1]!=e[0]*e[1])throw new Error("Reshaping sparse matrix will result in the wrong number of elements");var r=t?this.clone():this;if(this._size[0]===e[0]&&this._size[1]===e[1])return r;for(var n=[],i=0;i<r._ptr.length;i++)for(var a=0;a<r._ptr[i+1]-r._ptr[i];a++)n.push(i);var o=r._values.slice(),f=r._index.slice();for(i=0;i<r._index.length;i++){var l=f[i],p=n[i],h=l*r._size[1]+p;n[i]=h%e[1],f[i]=Math.floor(h/e[1])}for(r._values.length=0,r._index.length=0,r._ptr.length=e[1]+1,r._size=e.slice(),i=0;i<r._ptr.length;i++)r._ptr[i]=0;for(var m=0;m<o.length;m++){i=f[m],a=n[m];var d=o[m],g=E(i,r._ptr[a],r._ptr[a+1],r._index);A(g,i,a,d,r._values,r._index,r._ptr)}return r},y.prototype.clone=function(){return new y({values:this._values?o.clone(this._values):void 0,index:o.clone(this._index),ptr:o.clone(this._ptr),size:o.clone(this._size),datatype:this._datatype})},y.prototype.size=function(){return this._size.slice(0)},y.prototype.map=function(e,t){if(!this._values)throw new Error("Cannot invoke map on a Pattern only matrix");var r=this,n=this._size[0],i=this._size[1];return T(this,0,n-1,0,i-1,function(t,n,i){return e(t,[n,i],r)},t)};var T=function(e,t,r,n,i,a,o){var s=[],u=[],c=[],f=v,l=0;p(e._datatype)&&(f=d.find(v,[e._datatype,e._datatype])||v,l=d.convert(0,e._datatype));for(var h=function(e,t,r){e=a(e,t,r),f(e,l)||(s.push(e),u.push(t))},m=n;m<=i;m++){c.push(s.length);for(var g=e._ptr[m],x=e._ptr[m+1],w=t,b=g;b<x;b++){var N=e._index[b];if(N>=t&&N<=r){if(!o)for(var E=w;E<N;E++)h(0,E-t,m-n);h(e._values[b],N-t,m-n)}w=N+1}if(!o)for(var M=w;M<=r;M++)h(0,M-t,m-n)}return c.push(s.length),new y({values:s,index:u,ptr:c,size:[r-t+1,i-n+1]})};y.prototype.forEach=function(e,t){if(!this._values)throw new Error("Cannot invoke forEach on a Pattern only matrix");for(var r=this._size[0],n=this._size[1],i=0;i<n;i++){for(var a=this._ptr[i],o=this._ptr[i+1],s=0,u=a;u<o;u++){var c=this._index[u];if(!t)for(var f=s;f<c;f++)e(0,[f,i],this);e(this._values[u],[c,i],this),s=c+1}if(!t)for(var l=s;l<r;l++)e(0,[l,i],this)}},y.prototype.toArray=function(){return S(this._values,this._index,this._ptr,this._size,!0)},y.prototype.valueOf=function(){return S(this._values,this._index,this._ptr,this._size,!1)};var S=function(e,t,r,n,i){var a,s,u=n[0],c=n[1],f=[];for(a=0;a<u;a++)for(f[a]=[],s=0;s<c;s++)f[a][s]=0;for(s=0;s<c;s++)for(var l=r[s],p=r[s+1],h=l;h<p;h++)f[a=t[h]][s]=e?i?o.clone(e[h]):e[h]:1;return f};return y.prototype.format=function(e){for(var t=this._size[0],r=this._size[1],n=this.density(),i="Sparse Matrix ["+s.format(t,e)+" x "+s.format(r,e)+"] density: "+s.format(n,e)+"\n",a=0;a<r;a++)for(var o=this._ptr[a],u=this._ptr[a+1],c=o;c<u;c++){var f=this._index[c];i+="\n    ("+s.format(f,e)+", "+s.format(a,e)+") ==> "+(this._values?s.format(this._values[c],e):"X")}return i},y.prototype.toString=function(){return s.format(this.toArray())},y.prototype.toJSON=function(){return{mathjs:"SparseMatrix",values:this._values,index:this._index,ptr:this._ptr,size:this._size,datatype:this._datatype}},y.prototype.diagonal=function(t){if(t){if(e.isBigNumber(t)&&(t=t.toNumber()),!f(t)||!l(t))throw new TypeError("The parameter k must be an integer number")}else t=0;var r=t>0?t:0,n=t<0?-t:0,i=this._size[0],a=this._size[1],o=Math.min(i-n,a-r),s=[],u=[],c=[];c[0]=0;for(var p=r;p<a&&s.length<o;p++)for(var h=this._ptr[p],m=this._ptr[p+1],d=h;d<m;d++){var g=this._index[d];if(g===p-r+n){s.push(this._values[d]),u[s.length-1]=g-n;break}}return c.push(s.length),new y({values:s,index:u,ptr:c,size:[o,1]})},y.fromJSON=function(e){return new y(e)},y.diagonal=function(t,r,n,i,a){if(!c(t))throw new TypeError("Array expected, size parameter");if(2!==t.length)throw new Error("Only two dimensions matrix are supported");if(t=t.map(function(t){if(e.isBigNumber(t)&&(t=t.toNumber()),!f(t)||!l(t)||t<1)throw new Error("Size values must be positive integers");return t}),n){if(e.isBigNumber(n)&&(n=n.toNumber()),!f(n)||!l(n))throw new TypeError("The parameter k must be an integer number")}else n=0;var o=v,s=0;p(a)&&(o=d.find(v,[a,a])||v,s=d.convert(0,a));var u,h=n>0?n:0,m=n<0?-n:0,g=t[0],x=t[1],w=Math.min(g-m,x-h);if(c(r)){if(r.length!==w)throw new Error("Invalid value array length");u=function(e){return r[e]}}else if(e.isMatrix(r)){var b=r.size();if(1!==b.length||b[0]!==w)throw new Error("Invalid matrix length");u=function(e){return r.get([e])}}else u=function(){return r};for(var N=[],E=[],M=[],A=0;A<x;A++){M.push(N.length);var O=A-h;if(O>=0&&O<w){var T=u(O);o(T,s)||(E.push(O+m),N.push(T))}}return M.push(N.length),new y({values:N,index:E,ptr:M,size:[g,x]})},y.prototype.swapRows=function(e,t){if(!(f(e)&&l(e)&&f(t)&&l(t)))throw new Error("Row index must be positive integers");if(2!==this._size.length)throw new Error("Only two dimensional matrix is supported");return h(e,this._size[0]),h(t,this._size[0]),y._swapRows(e,t,this._size[1],this._values,this._index,this._ptr),this},y._forEachRow=function(e,t,r,n,i){for(var a=n[e],o=n[e+1],s=a;s<o;s++)i(r[s],t[s])},y._swapRows=function(e,t,r,n,i,a){for(var o=0;o<r;o++){var s=a[o],u=a[o+1],c=E(e,s,u,i),f=E(t,s,u,i);if(c<u&&f<u&&i[c]===e&&i[f]===t){if(n){var l=n[c];n[c]=n[f],n[f]=l}}else if(c<u&&i[c]===e&&(f>=u||i[f]!==t)){var p=n?n[c]:void 0;i.splice(f,0,t),n&&n.splice(f,0,p),i.splice(f<=c?c+1:c,1),n&&n.splice(f<=c?c+1:c,1)}else if(f<u&&i[f]===t&&(c>=u||i[c]!==e)){var h=n?n[f]:void 0;i.splice(c,0,e),n&&n.splice(c,0,h),i.splice(c<=f?f+1:f,1),n&&n.splice(c<=f?f+1:f,1)}}},e.Matrix._storage.sparse=y,y},t.lazy=!1},function(e,t,r){"use strict";t.name="Spa",t.path="type",t.factory=function(e,t,n){var i=n(r(20)),a=n(r(10));function o(){if(!(this instanceof o))throw new SyntaxError("Constructor must be called with the new operator");this._values=[],this._heap=new e.FibonacciHeap}return o.prototype.type="Spa",o.prototype.isSpa=!0,o.prototype.set=function(e,t){if(this._values[e])this._values[e].value=t;else{var r=this._heap.insert(e,t);this._values[e]=r}},o.prototype.get=function(e){var t=this._values[e];return t?t.value:0},o.prototype.accumulate=function(e,t){var r=this._values[e];r?r.value=i(r.value,t):(r=this._heap.insert(e,t),this._values[e]=r)},o.prototype.forEach=function(e,t,r){var n=this._heap,i=this._values,o=[],s=n.extractMinimum();for(s&&o.push(s);s&&s.key<=t;)s.key>=e&&(a(s.value,0)||r(s.key,s.value,this)),(s=n.extractMinimum())&&o.push(s);for(var u=0;u<o.length;u++){var c=o[u];i[(s=n.insert(c.key,c.value)).key]=s}},o.prototype.swap=function(e,t){var r=this._values[e],n=this._values[t];if(!r&&n)r=this._heap.insert(e,n.value),this._heap.remove(n),this._values[e]=r,this._values[t]=void 0;else if(r&&!n)n=this._heap.insert(t,r.value),this._heap.remove(r),this._values[t]=n,this._values[e]=void 0;else if(r&&n){var i=r.value;r.value=n.value,n.value=i}},o}},function(e,t,r){"use strict";t.name="FibonacciHeap",t.path="type",t.factory=function(e,t,n,i){var a=n(r(39)),o=n(r(34)),s=1/Math.log((1+Math.sqrt(5))/2);function u(){if(!(this instanceof u))throw new SyntaxError("Constructor must be called with the new operator");this._minimum=null,this._size=0}u.prototype.type="FibonacciHeap",u.prototype.isFibonacciHeap=!0,u.prototype.insert=function(e,t){var r={key:e,value:t,degree:0};if(this._minimum){var n=this._minimum;r.left=n,r.right=n.right,n.right=r,r.right.left=r,a(e,n.key)&&(this._minimum=r)}else r.left=r,r.right=r,this._minimum=r;return this._size++,r},u.prototype.size=function(){return this._size},u.prototype.clear=function(){this._minimum=null,this._size=0},u.prototype.isEmpty=function(){return 0===this._size},u.prototype.extractMinimum=function(){var e=this._minimum;if(null===e)return e;for(var t=this._minimum,r=e.degree,n=e.child;r>0;){var i=n.right;n.left.right=n.right,n.right.left=n.left,n.left=t,n.right=t.right,t.right=n,n.right.left=n,n.parent=null,n=i,r--}return e.left.right=e.right,e.right.left=e.left,e==e.right?t=null:(t=e.right,t=p(t,this._size)),this._size--,this._minimum=t,e},u.prototype.remove=function(e){this._minimum=c(this._minimum,e,-1),this.extractMinimum()};var c=function(e,t,r){t.key=r;var n=t.parent;return n&&a(t.key,n.key)&&(f(e,t,n),l(e,n)),a(t.key,e.key)&&(e=t),e},f=function(e,t,r){t.left.right=t.right,t.right.left=t.left,r.degree--,r.child==t&&(r.child=t.right),0===r.degree&&(r.child=null),t.left=e,t.right=e.right,e.right=t,t.right.left=t,t.parent=null,t.mark=!1},l=function(e,t){var r=t.parent;r&&(t.mark?(f(e,t,r),l(r)):t.mark=!0)},p=function(e,t){var r,n,i,u=Math.floor(Math.log(t)*s)+1,c=new Array(u),f=0,l=e;if(l)for(f++,l=l.right;l!==e;)f++,l=l.right;for(;f>0;){for(var p=l.degree,h=l.right;r=c[p];){if(o(l.key,r.key)){var m=r;r=l,l=m}i=l,(n=r).left.right=n.right,n.right.left=n.left,n.parent=i,i.child?(n.left=i.child,n.right=i.child.right,i.child.right=n,n.right.left=n):(i.child=n,n.right=n,n.left=n),i.degree++,n.mark=!1,c[p]=null,p++}c[p]=l,l=h,f--}e=null;for(var d=0;d<u;d++)(r=c[d])&&(e?(r.left.right=r.right,r.right.left=r.left,r.left=e,r.right=e.right,e.right=r,r.right.left=r,a(r.key,e.key)&&(e=r)):e=r);return e};return u}},function(e,t,r){"use strict";var n=r(25),i=n.string,a=n.object,o=Array.isArray,s=i.isString;t.name="ImmutableDenseMatrix",t.path="type",t.factory=function(e,t,i){var u=i(r(45)),c=i(r(39));function f(t,r){if(!(this instanceof f))throw new SyntaxError("Constructor must be called with the new operator");if(r&&!s(r))throw new Error("Invalid datatype: "+r);if(e.isMatrix(t)||o(t)){var i=new u(t,r);this._data=i._data,this._size=i._size,this._datatype=i._datatype,this._min=null,this._max=null}else if(t&&o(t.data)&&o(t.size))this._data=t.data,this._size=t.size,this._datatype=t.datatype,this._min=void 0!==t.min?t.min:null,this._max=void 0!==t.max?t.max:null;else{if(t)throw new TypeError("Unsupported type of data ("+n.types.type(t)+")");this._data=[],this._size=[0],this._datatype=r,this._min=null,this._max=null}}return f.prototype=new u,f.prototype.type="ImmutableDenseMatrix",f.prototype.isImmutableDenseMatrix=!0,f.prototype.subset=function(t){switch(arguments.length){case 1:var r=u.prototype.subset.call(this,t);return e.isMatrix(r)?new f({data:r._data,size:r._size,datatype:r._datatype}):r;case 2:case 3:throw new Error("Cannot invoke set subset on an Immutable Matrix instance");default:throw new SyntaxError("Wrong number of arguments")}},f.prototype.set=function(){throw new Error("Cannot invoke set on an Immutable Matrix instance")},f.prototype.resize=function(){throw new Error("Cannot invoke resize on an Immutable Matrix instance")},f.prototype.reshape=function(){throw new Error("Cannot invoke reshape on an Immutable Matrix instance")},f.prototype.clone=function(){return new f({data:a.clone(this._data),size:a.clone(this._size),datatype:this._datatype})},f.prototype.toJSON=function(){return{mathjs:"ImmutableDenseMatrix",data:this._data,size:this._size,datatype:this._datatype}},f.fromJSON=function(e){return new f(e)},f.prototype.swapRows=function(){throw new Error("Cannot invoke swapRows on an Immutable Matrix instance")},f.prototype.min=function(){if(null===this._min){var e=null;this.forEach(function(t){(null===e||c(t,e))&&(e=t)}),this._min=null!==e?e:void 0}return this._min},f.prototype.max=function(){if(null===this._max){var e=null;this.forEach(function(t){(null===e||c(e,t))&&(e=t)}),this._max=null!==e?e:void 0}return this._max},f}},function(e,t,r){"use strict";t.name="index",t.factory=function(e,t,r,n){return n("index",{"...number | string | BigNumber | Range | Array | Matrix":function(t){var r=t.map(function(t){return e.isBigNumber(t)?t.toNumber():Array.isArray(t)||e.isMatrix(t)?t.map(function(t){return e.isBigNumber(t)?t.toNumber():t}):t}),n=new e.Index;return e.Index.apply(n,r),n}})}},function(e,t,r){"use strict";t.name="sparse",t.factory=function(e,t,r,n){var i=e.SparseMatrix,a=n("sparse",{"":function(){return new i([])},string:function(e){return new i([],e)},"Array | Matrix":function(e){return new i(e)},"Array | Matrix, string":function(e,t){return new i(e,t)}});return a.toTex={0:"\\begin{bsparse}\\end{bsparse}",1:"\\left(${args[0]}\\right)"},a}},function(e,t,r){e.exports=[r(95)]},function(e,t,r){"use strict";var n=r(1),i=r(3);t.name="string",t.factory=function(e,t,r,a){var o=a("string",{"":function(){return""},number:i.format,null:function(e){return"null"},boolean:function(e){return e+""},string:function(e){return e},"Array | Matrix":function(e){return n(e,o)},any:function(e){return String(e)}});return o.toTex={0:'\\mathtt{""}',1:"\\mathrm{string}\\left(${args[0]}\\right)"},o}},function(e,t,r){e.exports=[r(188),r(189),r(190),r(191),r(192)]},function(e,t,r){"use strict";var n=r(9).endsWith,i=r(5).clone,a=r(96);t.name="Unit",t.path="type",t.factory=function(e,t,o,s,u){var c,f,l,p=o(r(16)),h=o(r(21)),m=o(r(22)),d=o(r(14)),g=o(r(46)),v=o(r(28)),y=o(r(97)),x=o(r(98)),w=o(r(30)),b=o(r(75)),N=o(r(99)),E=o(r(76)),M=o(r(74)),A=o(r(92));function O(t,r){if(!(this instanceof O))throw new Error("Constructor must be called with the new operator");if(void 0!=t&&!b(t)&&!e.isComplex(t))throw new TypeError("First parameter in Unit constructor must be number, BigNumber, Fraction, Complex, or undefined");if(void 0!=r&&("string"!=typeof r||""===r))throw new TypeError("Second parameter in Unit constructor must be a string");if(void 0!=r){var n=O.parse(r);this.units=n.units,this.dimensions=n.dimensions}else{this.units=[{unit:j,prefix:R.NONE,power:0}],this.dimensions=[];for(var i=0;i<q.length;i++)this.dimensions[i]=0}this.value=void 0!=t?this._normalize(t):null,this.fixPrefix=!1,this.isUnitListSimplified=!0}function T(){for(;" "==l||"\t"==l;)_()}function S(e){return e>="0"&&e<="9"}function _(){f++,l=c.charAt(f)}function C(e){f=e,l=c.charAt(f)}function z(){var e,t,r="";if(e=f,"+"==l?_():"-"==l&&(r+=l,_()),!((t=l)>="0"&&t<="9"||"."==t))return C(e),null;if("."==l){if(r+=l,_(),!S(l))return C(e),null}else{for(;S(l);)r+=l,_();"."==l&&(r+=l,_())}for(;S(l);)r+=l,_();if("E"==l||"e"==l){var n="",i=f;if(n+=l,_(),"+"!=l&&"-"!=l||(n+=l,_()),!S(l))return C(i),r;for(r+=n;S(l);)r+=l,_()}return r}function k(){for(var e="",t=c.charCodeAt(f);t>=48&&t<=57||t>=65&&t<=90||t>=97&&t<=122;)e+=l,_(),t=c.charCodeAt(f);return((t=e.charCodeAt(0))>=65&&t<=90||t>=97&&t<=122)&&e||null}function B(e){return l===e?(_(),e):null}function I(e){if(F.hasOwnProperty(e))return{unit:i=F[e],prefix:r=i.prefixes[""]};for(var t in F)if(F.hasOwnProperty(t)&&n(e,t)){var r,i=F[t],a=e.length-t.length,o=e.substring(0,a);if(void 0!==(r=i.prefixes.hasOwnProperty(o)?i.prefixes[o]:void 0))return{unit:i,prefix:r}}return null}O.prototype.type="Unit",O.prototype.isUnit=!0,O.parse=function(r,n){if(n=n||{},f=-1,l="","string"!=typeof(c=r))throw new TypeError("Invalid argument in Unit.parse, string expected");var i=new O;i.units=[],_(),T();var a=z(),o=null;a&&(o="BigNumber"===t.number?new e.BigNumber(a):"Fraction"===t.number?new e.Fraction(a):parseFloat(a)),T();for(var s=1,u=!1,p=[],h=1;;){for(T();"("===l;)p.push(s),h*=s,s=1,_(),T();if(!l)break;var m=l,d=k();if(null==d)throw new SyntaxError('Unexpected "'+m+'" in "'+c+'" at index '+f.toString());var g=I(d);if(null==g)throw new SyntaxError('Unit "'+d+'" not found.');var v=s*h;if(T(),B("^")){T();var y=z();if(null==y)throw new SyntaxError('In "'+r+'", "^" must be followed by a floating-point number');v*=y}i.units.push({unit:g.unit,prefix:g.prefix,power:v});for(var x=0;x<q.length;x++)i.dimensions[x]+=(g.unit.dimensions[x]||0)*v;for(T();")"===l;){if(0===p.length)throw new SyntaxError('Unmatched ")" in "'+c+'" at index '+f.toString());h/=p.pop(),_(),T()}if(u=!1,B("*")?(s=1,u=!0):B("/")?(s=-1,u=!0):s=1,g.unit.base){var w=g.unit.base.key;$.auto[w]={unit:g.unit,prefix:g.prefix}}}if(T(),l)throw new SyntaxError('Could not parse: "'+r+'"');if(u)throw new SyntaxError('Trailing characters: "'+r+'"');if(0!==p.length)throw new SyntaxError('Unmatched "(" in "'+c+'"');if(0==i.units.length&&!n.allowNoUnits)throw new SyntaxError('"'+r+'" contains no units');return i.value=void 0!=o?i._normalize(o):null,i},O.prototype.clone=function(){var e=new O;e.fixPrefix=this.fixPrefix,e.isUnitListSimplified=this.isUnitListSimplified,e.value=i(this.value),e.dimensions=this.dimensions.slice(0),e.units=[];for(var t=0;t<this.units.length;t++)for(var r in e.units[t]={},this.units[t])this.units[t].hasOwnProperty(r)&&(e.units[t][r]=this.units[t][r]);return e},O.prototype._isDerived=function(){return 0!==this.units.length&&(this.units.length>1||Math.abs(this.units[0].power-1)>1e-15)},O.prototype._normalize=function(e){var t,r,n,i,a;if(null==e||0===this.units.length)return e;if(this._isDerived()){var o=e;a=O._getNumberConverter(E(e));for(var s=0;s<this.units.length;s++)t=a(this.units[s].unit.value),i=a(this.units[s].prefix.value),n=a(this.units[s].power),o=m(o,g(m(t,i),n));return o}return t=(a=O._getNumberConverter(E(e)))(this.units[0].unit.value),r=a(this.units[0].unit.offset),i=a(this.units[0].prefix.value),m(p(e,r),m(t,i))},O.prototype._denormalize=function(e,t){var r,n,i,a,o;if(null==e||0===this.units.length)return e;if(this._isDerived()){var s=e;o=O._getNumberConverter(E(e));for(var u=0;u<this.units.length;u++)r=o(this.units[u].unit.value),a=o(this.units[u].prefix.value),i=o(this.units[u].power),s=d(s,g(m(r,a),i));return s}return r=(o=O._getNumberConverter(E(e)))(this.units[0].unit.value),a=o(this.units[0].prefix.value),n=o(this.units[0].unit.offset),h(d(d(e,r),void 0==t?a:t),n)},O.isValuelessUnit=function(e){return null!=I(e)},O.prototype.hasBase=function(e){if("string"==typeof e&&(e=L[e]),!e)return!1;for(var t=0;t<q.length;t++)if(Math.abs((this.dimensions[t]||0)-(e.dimensions[t]||0))>1e-12)return!1;return!0},O.prototype.equalBase=function(e){for(var t=0;t<q.length;t++)if(Math.abs((this.dimensions[t]||0)-(e.dimensions[t]||0))>1e-12)return!1;return!0},O.prototype.equals=function(e){return this.equalBase(e)&&w(this.value,e.value)},O.prototype.multiply=function(e){for(var t=this.clone(),r=0;r<q.length;r++)t.dimensions[r]=(this.dimensions[r]||0)+(e.dimensions[r]||0);for(r=0;r<e.units.length;r++){var n={};for(var i in e.units[r])n[i]=e.units[r][i];t.units.push(n)}if(null!=this.value||null!=e.value){var a=null==this.value?this._normalize(1):this.value,o=null==e.value?e._normalize(1):e.value;t.value=m(a,o)}else t.value=null;return t.isUnitListSimplified=!1,P(t)},O.prototype.divide=function(e){for(var t=this.clone(),r=0;r<q.length;r++)t.dimensions[r]=(this.dimensions[r]||0)-(e.dimensions[r]||0);for(r=0;r<e.units.length;r++){var n={};for(var i in e.units[r])n[i]=e.units[r][i];n.power=-n.power,t.units.push(n)}if(null!=this.value||null!=e.value){var a=null==this.value?this._normalize(1):this.value,o=null==e.value?e._normalize(1):e.value;t.value=d(a,o)}else t.value=null;return t.isUnitListSimplified=!1,P(t)},O.prototype.pow=function(e){for(var t=this.clone(),r=0;r<q.length;r++)t.dimensions[r]=(this.dimensions[r]||0)*e;for(r=0;r<t.units.length;r++)t.units[r].power*=e;return null!=t.value?t.value=g(t.value,e):t.value=null,t.isUnitListSimplified=!1,P(t)};var P=function(e){return e.equalBase(L.NONE)&&null!==e.value&&!t.predictable?e.value:e};O.prototype.abs=function(){var e=this.clone();for(var t in e.value=v(e.value),e.units)"VA"!==e.units[t].unit.name&&"VAR"!==e.units[t].unit.name||(e.units[t].unit=F.W);return e},O.prototype.to=function(t){var r,n=null==this.value?this._normalize(1):this.value;if("string"==typeof t){if(r=O.parse(t),!this.equalBase(r))throw new Error("Units do not match");if(null!==r.value)throw new Error("Cannot convert to a unit with a value");return r.value=i(n),r.fixPrefix=!0,r.isUnitListSimplified=!0,r}if(e.isUnit(t)){if(!this.equalBase(t))throw new Error("Units do not match");if(null!==t.value)throw new Error("Cannot convert to a unit with a value");return(r=t.clone()).value=i(n),r.fixPrefix=!0,r.isUnitListSimplified=!0,r}throw new Error("String or Unit expected as parameter")},O.prototype.toNumber=function(e){return M(this.toNumeric(e))},O.prototype.toNumeric=function(e){var t=this;return e&&(t=this.to(e)),t.simplifyUnitListLazy(),t._isDerived()?t._denormalize(t.value):t._denormalize(t.value,t.units[0].prefix.value)},O.prototype.toString=function(){return this.format()},O.prototype.toJSON=function(){return{mathjs:"Unit",value:this._denormalize(this.value),unit:this.formatUnits(),fixPrefix:this.fixPrefix}},O.fromJSON=function(e){var t=new O(e.value,e.unit);return t.fixPrefix=e.fixPrefix||!1,t},O.prototype.valueOf=O.prototype.toString,O.prototype.simplifyUnitListLazy=function(){if(!this.isUnitListSimplified&&null!=this.value){var e,t,r=[];for(var n in G)if(this.hasBase(L[n])){e=n;break}if("NONE"===e)this.units=[];else if(e&&G.hasOwnProperty(e)&&(t=G[e]),t)this.units=[{unit:t.unit,prefix:t.prefix,power:1}];else{for(var i=!1,a=0;a<q.length;a++){var o=q[a];Math.abs(this.dimensions[a]||0)>1e-12&&(G.hasOwnProperty(o)?r.push({unit:G[o].unit,prefix:G[o].prefix,power:this.dimensions[a]||0}):i=!0)}r.length<this.units.length&&!i&&(this.units=r)}this.isUnitListSimplified=!0}},O.prototype.toSI=function(){for(var e=this.clone(),t=[],r=0;r<q.length;r++){var n=q[r];if(Math.abs(e.dimensions[r]||0)>1e-12){if(!$.si.hasOwnProperty(n))throw new Error("Cannot express custom unit "+n+" in SI units");t.push({unit:$.si[n].unit,prefix:$.si[n].prefix,power:e.dimensions[r]||0})}}return e.units=t,e.isUnitListSimplified=!0,e},O.prototype.formatUnits=function(){this.simplifyUnitListLazy();for(var e="",t="",r=0,n=0,i=0;i<this.units.length;i++)this.units[i].power>0?(r++,e+=" "+this.units[i].prefix.name+this.units[i].unit.name,Math.abs(this.units[i].power-1)>1e-15&&(e+="^"+this.units[i].power)):this.units[i].power<0&&n++;if(n>0)for(i=0;i<this.units.length;i++)this.units[i].power<0&&(r>0?(t+=" "+this.units[i].prefix.name+this.units[i].unit.name,Math.abs(this.units[i].power+1)>1e-15&&(t+="^"+-this.units[i].power)):(t+=" "+this.units[i].prefix.name+this.units[i].unit.name,t+="^"+this.units[i].power));e=e.substr(1),t=t.substr(1),r>1&&n>0&&(e="("+e+")"),n>1&&r>0&&(t="("+t+")");var a=e;return r>0&&n>0&&(a+=" / "),a+=t},O.prototype.format=function(t){this.simplifyUnitListLazy();var r=!1;for(var n in void 0!==this.value&&null!==this.value&&e.isComplex(this.value)&&(r=Math.abs(this.value.re)<1e-14,Math.abs(this.value.im)),this.units)this.units[n].unit&&("VA"===this.units[n].unit.name&&r?this.units[n].unit=F.VAR:"VAR"!==this.units[n].unit.name||r||(this.units[n].unit=F.VA));1!==this.units.length||this.fixPrefix||Math.abs(this.units[0].power-Math.round(this.units[0].power))<1e-14&&(this.units[0].prefix=this._bestPrefix());var i=this._denormalize(this.value),a=null!==this.value?N(i,t||{}):"",o=this.formatUnits();return this.value&&e.isComplex(this.value)&&(a="("+a+")"),o.length>0&&a.length>0&&(a+=" "),a+=o},O.prototype._bestPrefix=function(){if(1!==this.units.length)throw new Error("Can only compute the best prefix for single units with integer powers, like kg, s^2, N^-1, and so forth!");if(Math.abs(this.units[0].power-Math.round(this.units[0].power))>=1e-14)throw new Error("Can only compute the best prefix for single units with integer powers, like kg, s^2, N^-1, and so forth!");var e=v(this.value),t=v(this.units[0].unit.value),r=this.units[0].prefix;if(0===e)return r;var n=this.units[0].power,i=Math.log(e/Math.pow(r.value*t,n))/Math.LN10-1.2;if(i>-2.200001&&i<1.800001)return r;i=Math.abs(i);var a=this.units[0].unit.prefixes;for(var o in a)if(a.hasOwnProperty(o)){var s=a[o];if(s.scientific){var u=Math.abs(Math.log(e/Math.pow(s.value*t,n))/Math.LN10-1.2);(u<i||u===i&&s.name.length<r.name.length)&&(r=s,i=u)}}return r},O.prototype.splitUnit=function(e){for(var t=this.clone(),r=[],n=0;n<e.length&&(t=t.to(e[n]),n!=e.length-1);n++){var i=t.toNumeric(),a=x(i),o=new O(w(a,i)?a:y(t.toNumeric()),e[n].toString());r.push(o),t=h(t,o)}var s=0;for(n=0;n<r.length;n++)s=p(s,r[n].value);return w(s,this.value)&&(t.value=0),r.push(t),r};var R={NONE:{"":{name:"",value:1,scientific:!0}},SHORT:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:10,scientific:!1},h:{name:"h",value:100,scientific:!1},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},d:{name:"d",value:.1,scientific:!1},c:{name:"c",value:.01,scientific:!1},m:{name:"m",value:.001,scientific:!0},u:{name:"u",value:1e-6,scientific:!0},n:{name:"n",value:1e-9,scientific:!0},p:{name:"p",value:1e-12,scientific:!0},f:{name:"f",value:1e-15,scientific:!0},a:{name:"a",value:1e-18,scientific:!0},z:{name:"z",value:1e-21,scientific:!0},y:{name:"y",value:1e-24,scientific:!0}},LONG:{"":{name:"",value:1,scientific:!0},deca:{name:"deca",value:10,scientific:!1},hecto:{name:"hecto",value:100,scientific:!1},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},deci:{name:"deci",value:.1,scientific:!1},centi:{name:"centi",value:.01,scientific:!1},milli:{name:"milli",value:.001,scientific:!0},micro:{name:"micro",value:1e-6,scientific:!0},nano:{name:"nano",value:1e-9,scientific:!0},pico:{name:"pico",value:1e-12,scientific:!0},femto:{name:"femto",value:1e-15,scientific:!0},atto:{name:"atto",value:1e-18,scientific:!0},zepto:{name:"zepto",value:1e-21,scientific:!0},yocto:{name:"yocto",value:1e-24,scientific:!0}},SQUARED:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:100,scientific:!1},h:{name:"h",value:1e4,scientific:!1},k:{name:"k",value:1e6,scientific:!0},M:{name:"M",value:1e12,scientific:!0},G:{name:"G",value:1e18,scientific:!0},T:{name:"T",value:1e24,scientific:!0},P:{name:"P",value:1e30,scientific:!0},E:{name:"E",value:1e36,scientific:!0},Z:{name:"Z",value:1e42,scientific:!0},Y:{name:"Y",value:1e48,scientific:!0},d:{name:"d",value:.01,scientific:!1},c:{name:"c",value:1e-4,scientific:!1},m:{name:"m",value:1e-6,scientific:!0},u:{name:"u",value:1e-12,scientific:!0},n:{name:"n",value:1e-18,scientific:!0},p:{name:"p",value:1e-24,scientific:!0},f:{name:"f",value:1e-30,scientific:!0},a:{name:"a",value:1e-36,scientific:!0},z:{name:"z",value:1e-42,scientific:!0},y:{name:"y",value:1e-48,scientific:!0}},CUBIC:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:1e3,scientific:!1},h:{name:"h",value:1e6,scientific:!1},k:{name:"k",value:1e9,scientific:!0},M:{name:"M",value:1e18,scientific:!0},G:{name:"G",value:1e27,scientific:!0},T:{name:"T",value:1e36,scientific:!0},P:{name:"P",value:1e45,scientific:!0},E:{name:"E",value:1e54,scientific:!0},Z:{name:"Z",value:1e63,scientific:!0},Y:{name:"Y",value:1e72,scientific:!0},d:{name:"d",value:.001,scientific:!1},c:{name:"c",value:1e-6,scientific:!1},m:{name:"m",value:1e-9,scientific:!0},u:{name:"u",value:1e-18,scientific:!0},n:{name:"n",value:1e-27,scientific:!0},p:{name:"p",value:1e-36,scientific:!0},f:{name:"f",value:1e-45,scientific:!0},a:{name:"a",value:1e-54,scientific:!0},z:{name:"z",value:1e-63,scientific:!0},y:{name:"y",value:1e-72,scientific:!0}},BINARY_SHORT:{"":{name:"",value:1,scientific:!0},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},Ki:{name:"Ki",value:1024,scientific:!0},Mi:{name:"Mi",value:Math.pow(1024,2),scientific:!0},Gi:{name:"Gi",value:Math.pow(1024,3),scientific:!0},Ti:{name:"Ti",value:Math.pow(1024,4),scientific:!0},Pi:{name:"Pi",value:Math.pow(1024,5),scientific:!0},Ei:{name:"Ei",value:Math.pow(1024,6),scientific:!0},Zi:{name:"Zi",value:Math.pow(1024,7),scientific:!0},Yi:{name:"Yi",value:Math.pow(1024,8),scientific:!0}},BINARY_LONG:{"":{name:"",value:1,scientific:!0},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},kibi:{name:"kibi",value:1024,scientific:!0},mebi:{name:"mebi",value:Math.pow(1024,2),scientific:!0},gibi:{name:"gibi",value:Math.pow(1024,3),scientific:!0},tebi:{name:"tebi",value:Math.pow(1024,4),scientific:!0},pebi:{name:"pebi",value:Math.pow(1024,5),scientific:!0},exi:{name:"exi",value:Math.pow(1024,6),scientific:!0},zebi:{name:"zebi",value:Math.pow(1024,7),scientific:!0},yobi:{name:"yobi",value:Math.pow(1024,8),scientific:!0}},BTU:{"":{name:"",value:1,scientific:!0},MM:{name:"MM",value:1e6,scientific:!0}},SHORTLONG:{}};for(var U in R.SHORT)R.SHORT.hasOwnProperty(U)&&(R.SHORTLONG[U]=R.SHORT[U]);for(var U in R.LONG)R.LONG.hasOwnProperty(U)&&(R.SHORTLONG[U]=R.LONG[U]);var q=["MASS","LENGTH","TIME","CURRENT","TEMPERATURE","LUMINOUS_INTENSITY","AMOUNT_OF_SUBSTANCE","ANGLE","BIT"],L={NONE:{dimensions:[0,0,0,0,0,0,0,0,0]},MASS:{dimensions:[1,0,0,0,0,0,0,0,0]},LENGTH:{dimensions:[0,1,0,0,0,0,0,0,0]},TIME:{dimensions:[0,0,1,0,0,0,0,0,0]},CURRENT:{dimensions:[0,0,0,1,0,0,0,0,0]},TEMPERATURE:{dimensions:[0,0,0,0,1,0,0,0,0]},LUMINOUS_INTENSITY:{dimensions:[0,0,0,0,0,1,0,0,0]},AMOUNT_OF_SUBSTANCE:{dimensions:[0,0,0,0,0,0,1,0,0]},FORCE:{dimensions:[1,1,-2,0,0,0,0,0,0]},SURFACE:{dimensions:[0,2,0,0,0,0,0,0,0]},VOLUME:{dimensions:[0,3,0,0,0,0,0,0,0]},ENERGY:{dimensions:[1,2,-2,0,0,0,0,0,0]},POWER:{dimensions:[1,2,-3,0,0,0,0,0,0]},PRESSURE:{dimensions:[1,-1,-2,0,0,0,0,0,0]},ELECTRIC_CHARGE:{dimensions:[0,0,1,1,0,0,0,0,0]},ELECTRIC_CAPACITANCE:{dimensions:[-1,-2,4,2,0,0,0,0,0]},ELECTRIC_POTENTIAL:{dimensions:[1,2,-3,-1,0,0,0,0,0]},ELECTRIC_RESISTANCE:{dimensions:[1,2,-3,-2,0,0,0,0,0]},ELECTRIC_INDUCTANCE:{dimensions:[1,2,-2,-2,0,0,0,0,0]},ELECTRIC_CONDUCTANCE:{dimensions:[-1,-2,3,2,0,0,0,0,0]},MAGNETIC_FLUX:{dimensions:[1,2,-2,-1,0,0,0,0,0]},MAGNETIC_FLUX_DENSITY:{dimensions:[1,0,-2,-1,0,0,0,0,0]},FREQUENCY:{dimensions:[0,0,-1,0,0,0,0,0,0]},ANGLE:{dimensions:[0,0,0,0,0,0,0,1,0]},BIT:{dimensions:[0,0,0,0,0,0,0,0,1]}};for(var U in L)L[U].key=U;var j={name:"",base:{},value:1,offset:0,dimensions:[0,0,0,0,0,0,0,0,0]},F={meter:{name:"meter",base:L.LENGTH,prefixes:R.LONG,value:1,offset:0},inch:{name:"inch",base:L.LENGTH,prefixes:R.NONE,value:.0254,offset:0},foot:{name:"foot",base:L.LENGTH,prefixes:R.NONE,value:.3048,offset:0},yard:{name:"yard",base:L.LENGTH,prefixes:R.NONE,value:.9144,offset:0},mile:{name:"mile",base:L.LENGTH,prefixes:R.NONE,value:1609.344,offset:0},link:{name:"link",base:L.LENGTH,prefixes:R.NONE,value:.201168,offset:0},rod:{name:"rod",base:L.LENGTH,prefixes:R.NONE,value:5.02921,offset:0},chain:{name:"chain",base:L.LENGTH,prefixes:R.NONE,value:20.1168,offset:0},angstrom:{name:"angstrom",base:L.LENGTH,prefixes:R.NONE,value:1e-10,offset:0},m:{name:"m",base:L.LENGTH,prefixes:R.SHORT,value:1,offset:0},in:{name:"in",base:L.LENGTH,prefixes:R.NONE,value:.0254,offset:0},ft:{name:"ft",base:L.LENGTH,prefixes:R.NONE,value:.3048,offset:0},yd:{name:"yd",base:L.LENGTH,prefixes:R.NONE,value:.9144,offset:0},mi:{name:"mi",base:L.LENGTH,prefixes:R.NONE,value:1609.344,offset:0},li:{name:"li",base:L.LENGTH,prefixes:R.NONE,value:.201168,offset:0},rd:{name:"rd",base:L.LENGTH,prefixes:R.NONE,value:5.02921,offset:0},ch:{name:"ch",base:L.LENGTH,prefixes:R.NONE,value:20.1168,offset:0},mil:{name:"mil",base:L.LENGTH,prefixes:R.NONE,value:254e-7,offset:0},m2:{name:"m2",base:L.SURFACE,prefixes:R.SQUARED,value:1,offset:0},sqin:{name:"sqin",base:L.SURFACE,prefixes:R.NONE,value:64516e-8,offset:0},sqft:{name:"sqft",base:L.SURFACE,prefixes:R.NONE,value:.09290304,offset:0},sqyd:{name:"sqyd",base:L.SURFACE,prefixes:R.NONE,value:.83612736,offset:0},sqmi:{name:"sqmi",base:L.SURFACE,prefixes:R.NONE,value:2589988.110336,offset:0},sqrd:{name:"sqrd",base:L.SURFACE,prefixes:R.NONE,value:25.29295,offset:0},sqch:{name:"sqch",base:L.SURFACE,prefixes:R.NONE,value:404.6873,offset:0},sqmil:{name:"sqmil",base:L.SURFACE,prefixes:R.NONE,value:6.4516e-10,offset:0},acre:{name:"acre",base:L.SURFACE,prefixes:R.NONE,value:4046.86,offset:0},hectare:{name:"hectare",base:L.SURFACE,prefixes:R.NONE,value:1e4,offset:0},m3:{name:"m3",base:L.VOLUME,prefixes:R.CUBIC,value:1,offset:0},L:{name:"L",base:L.VOLUME,prefixes:R.SHORT,value:.001,offset:0},l:{name:"l",base:L.VOLUME,prefixes:R.SHORT,value:.001,offset:0},litre:{name:"litre",base:L.VOLUME,prefixes:R.LONG,value:.001,offset:0},cuin:{name:"cuin",base:L.VOLUME,prefixes:R.NONE,value:16387064e-12,offset:0},cuft:{name:"cuft",base:L.VOLUME,prefixes:R.NONE,value:.028316846592,offset:0},cuyd:{name:"cuyd",base:L.VOLUME,prefixes:R.NONE,value:.764554857984,offset:0},teaspoon:{name:"teaspoon",base:L.VOLUME,prefixes:R.NONE,value:5e-6,offset:0},tablespoon:{name:"tablespoon",base:L.VOLUME,prefixes:R.NONE,value:15e-6,offset:0},drop:{name:"drop",base:L.VOLUME,prefixes:R.NONE,value:5e-8,offset:0},gtt:{name:"gtt",base:L.VOLUME,prefixes:R.NONE,value:5e-8,offset:0},minim:{name:"minim",base:L.VOLUME,prefixes:R.NONE,value:6.161152e-8,offset:0},fluiddram:{name:"fluiddram",base:L.VOLUME,prefixes:R.NONE,value:36966911e-13,offset:0},fluidounce:{name:"fluidounce",base:L.VOLUME,prefixes:R.NONE,value:2957353e-11,offset:0},gill:{name:"gill",base:L.VOLUME,prefixes:R.NONE,value:.0001182941,offset:0},cc:{name:"cc",base:L.VOLUME,prefixes:R.NONE,value:1e-6,offset:0},cup:{name:"cup",base:L.VOLUME,prefixes:R.NONE,value:.0002365882,offset:0},pint:{name:"pint",base:L.VOLUME,prefixes:R.NONE,value:.0004731765,offset:0},quart:{name:"quart",base:L.VOLUME,prefixes:R.NONE,value:.0009463529,offset:0},gallon:{name:"gallon",base:L.VOLUME,prefixes:R.NONE,value:.003785412,offset:0},beerbarrel:{name:"beerbarrel",base:L.VOLUME,prefixes:R.NONE,value:.1173478,offset:0},oilbarrel:{name:"oilbarrel",base:L.VOLUME,prefixes:R.NONE,value:.1589873,offset:0},hogshead:{name:"hogshead",base:L.VOLUME,prefixes:R.NONE,value:.238481,offset:0},fldr:{name:"fldr",base:L.VOLUME,prefixes:R.NONE,value:36966911e-13,offset:0},floz:{name:"floz",base:L.VOLUME,prefixes:R.NONE,value:2957353e-11,offset:0},gi:{name:"gi",base:L.VOLUME,prefixes:R.NONE,value:.0001182941,offset:0},cp:{name:"cp",base:L.VOLUME,prefixes:R.NONE,value:.0002365882,offset:0},pt:{name:"pt",base:L.VOLUME,prefixes:R.NONE,value:.0004731765,offset:0},qt:{name:"qt",base:L.VOLUME,prefixes:R.NONE,value:.0009463529,offset:0},gal:{name:"gal",base:L.VOLUME,prefixes:R.NONE,value:.003785412,offset:0},bbl:{name:"bbl",base:L.VOLUME,prefixes:R.NONE,value:.1173478,offset:0},obl:{name:"obl",base:L.VOLUME,prefixes:R.NONE,value:.1589873,offset:0},g:{name:"g",base:L.MASS,prefixes:R.SHORT,value:.001,offset:0},gram:{name:"gram",base:L.MASS,prefixes:R.LONG,value:.001,offset:0},ton:{name:"ton",base:L.MASS,prefixes:R.SHORT,value:907.18474,offset:0},tonne:{name:"tonne",base:L.MASS,prefixes:R.SHORT,value:1e3,offset:0},grain:{name:"grain",base:L.MASS,prefixes:R.NONE,value:6479891e-11,offset:0},dram:{name:"dram",base:L.MASS,prefixes:R.NONE,value:.0017718451953125,offset:0},ounce:{name:"ounce",base:L.MASS,prefixes:R.NONE,value:.028349523125,offset:0},poundmass:{name:"poundmass",base:L.MASS,prefixes:R.NONE,value:.45359237,offset:0},hundredweight:{name:"hundredweight",base:L.MASS,prefixes:R.NONE,value:45.359237,offset:0},stick:{name:"stick",base:L.MASS,prefixes:R.NONE,value:.115,offset:0},stone:{name:"stone",base:L.MASS,prefixes:R.NONE,value:6.35029318,offset:0},gr:{name:"gr",base:L.MASS,prefixes:R.NONE,value:6479891e-11,offset:0},dr:{name:"dr",base:L.MASS,prefixes:R.NONE,value:.0017718451953125,offset:0},oz:{name:"oz",base:L.MASS,prefixes:R.NONE,value:.028349523125,offset:0},lbm:{name:"lbm",base:L.MASS,prefixes:R.NONE,value:.45359237,offset:0},cwt:{name:"cwt",base:L.MASS,prefixes:R.NONE,value:45.359237,offset:0},s:{name:"s",base:L.TIME,prefixes:R.SHORT,value:1,offset:0},min:{name:"min",base:L.TIME,prefixes:R.NONE,value:60,offset:0},h:{name:"h",base:L.TIME,prefixes:R.NONE,value:3600,offset:0},second:{name:"second",base:L.TIME,prefixes:R.LONG,value:1,offset:0},sec:{name:"sec",base:L.TIME,prefixes:R.LONG,value:1,offset:0},minute:{name:"minute",base:L.TIME,prefixes:R.NONE,value:60,offset:0},hour:{name:"hour",base:L.TIME,prefixes:R.NONE,value:3600,offset:0},day:{name:"day",base:L.TIME,prefixes:R.NONE,value:86400,offset:0},week:{name:"week",base:L.TIME,prefixes:R.NONE,value:604800,offset:0},month:{name:"month",base:L.TIME,prefixes:R.NONE,value:2629800,offset:0},year:{name:"year",base:L.TIME,prefixes:R.NONE,value:31557600,offset:0},decade:{name:"year",base:L.TIME,prefixes:R.NONE,value:315576e3,offset:0},century:{name:"century",base:L.TIME,prefixes:R.NONE,value:315576e4,offset:0},millennium:{name:"millennium",base:L.TIME,prefixes:R.NONE,value:315576e5,offset:0},hertz:{name:"Hertz",base:L.FREQUENCY,prefixes:R.LONG,value:1,offset:0,reciprocal:!0},Hz:{name:"Hz",base:L.FREQUENCY,prefixes:R.SHORT,value:1,offset:0,reciprocal:!0},rad:{name:"rad",base:L.ANGLE,prefixes:R.LONG,value:1,offset:0},deg:{name:"deg",base:L.ANGLE,prefixes:R.LONG,value:null,offset:0},grad:{name:"grad",base:L.ANGLE,prefixes:R.LONG,value:null,offset:0},cycle:{name:"cycle",base:L.ANGLE,prefixes:R.NONE,value:null,offset:0},arcsec:{name:"arcsec",base:L.ANGLE,prefixes:R.NONE,value:null,offset:0},arcmin:{name:"arcmin",base:L.ANGLE,prefixes:R.NONE,value:null,offset:0},A:{name:"A",base:L.CURRENT,prefixes:R.SHORT,value:1,offset:0},ampere:{name:"ampere",base:L.CURRENT,prefixes:R.LONG,value:1,offset:0},K:{name:"K",base:L.TEMPERATURE,prefixes:R.NONE,value:1,offset:0},degC:{name:"degC",base:L.TEMPERATURE,prefixes:R.NONE,value:1,offset:273.15},degF:{name:"degF",base:L.TEMPERATURE,prefixes:R.NONE,value:1/1.8,offset:459.67},degR:{name:"degR",base:L.TEMPERATURE,prefixes:R.NONE,value:1/1.8,offset:0},kelvin:{name:"kelvin",base:L.TEMPERATURE,prefixes:R.NONE,value:1,offset:0},celsius:{name:"celsius",base:L.TEMPERATURE,prefixes:R.NONE,value:1,offset:273.15},fahrenheit:{name:"fahrenheit",base:L.TEMPERATURE,prefixes:R.NONE,value:1/1.8,offset:459.67},rankine:{name:"rankine",base:L.TEMPERATURE,prefixes:R.NONE,value:1/1.8,offset:0},mol:{name:"mol",base:L.AMOUNT_OF_SUBSTANCE,prefixes:R.SHORT,value:1,offset:0},mole:{name:"mole",base:L.AMOUNT_OF_SUBSTANCE,prefixes:R.LONG,value:1,offset:0},cd:{name:"cd",base:L.LUMINOUS_INTENSITY,prefixes:R.NONE,value:1,offset:0},candela:{name:"candela",base:L.LUMINOUS_INTENSITY,prefixes:R.NONE,value:1,offset:0},N:{name:"N",base:L.FORCE,prefixes:R.SHORT,value:1,offset:0},newton:{name:"newton",base:L.FORCE,prefixes:R.LONG,value:1,offset:0},dyn:{name:"dyn",base:L.FORCE,prefixes:R.SHORT,value:1e-5,offset:0},dyne:{name:"dyne",base:L.FORCE,prefixes:R.LONG,value:1e-5,offset:0},lbf:{name:"lbf",base:L.FORCE,prefixes:R.NONE,value:4.4482216152605,offset:0},poundforce:{name:"poundforce",base:L.FORCE,prefixes:R.NONE,value:4.4482216152605,offset:0},kip:{name:"kip",base:L.FORCE,prefixes:R.LONG,value:4448.2216,offset:0},J:{name:"J",base:L.ENERGY,prefixes:R.SHORT,value:1,offset:0},joule:{name:"joule",base:L.ENERGY,prefixes:R.SHORT,value:1,offset:0},erg:{name:"erg",base:L.ENERGY,prefixes:R.NONE,value:1e-7,offset:0},Wh:{name:"Wh",base:L.ENERGY,prefixes:R.SHORT,value:3600,offset:0},BTU:{name:"BTU",base:L.ENERGY,prefixes:R.BTU,value:1055.05585262,offset:0},eV:{name:"eV",base:L.ENERGY,prefixes:R.SHORT,value:1.602176565e-19,offset:0},electronvolt:{name:"electronvolt",base:L.ENERGY,prefixes:R.LONG,value:1.602176565e-19,offset:0},W:{name:"W",base:L.POWER,prefixes:R.SHORT,value:1,offset:0},watt:{name:"W",base:L.POWER,prefixes:R.LONG,value:1,offset:0},hp:{name:"hp",base:L.POWER,prefixes:R.NONE,value:745.6998715386,offset:0},VAR:{name:"VAR",base:L.POWER,prefixes:R.SHORT,value:A.I,offset:0},VA:{name:"VA",base:L.POWER,prefixes:R.SHORT,value:1,offset:0},Pa:{name:"Pa",base:L.PRESSURE,prefixes:R.SHORT,value:1,offset:0},psi:{name:"psi",base:L.PRESSURE,prefixes:R.NONE,value:6894.75729276459,offset:0},atm:{name:"atm",base:L.PRESSURE,prefixes:R.NONE,value:101325,offset:0},bar:{name:"bar",base:L.PRESSURE,prefixes:R.NONE,value:1e5,offset:0},torr:{name:"torr",base:L.PRESSURE,prefixes:R.NONE,value:133.322,offset:0},mmHg:{name:"mmHg",base:L.PRESSURE,prefixes:R.NONE,value:133.322,offset:0},mmH2O:{name:"mmH2O",base:L.PRESSURE,prefixes:R.NONE,value:9.80665,offset:0},cmH2O:{name:"cmH2O",base:L.PRESSURE,prefixes:R.NONE,value:98.0665,offset:0},coulomb:{name:"coulomb",base:L.ELECTRIC_CHARGE,prefixes:R.LONG,value:1,offset:0},C:{name:"C",base:L.ELECTRIC_CHARGE,prefixes:R.SHORT,value:1,offset:0},farad:{name:"farad",base:L.ELECTRIC_CAPACITANCE,prefixes:R.LONG,value:1,offset:0},F:{name:"F",base:L.ELECTRIC_CAPACITANCE,prefixes:R.SHORT,value:1,offset:0},volt:{name:"volt",base:L.ELECTRIC_POTENTIAL,prefixes:R.LONG,value:1,offset:0},V:{name:"V",base:L.ELECTRIC_POTENTIAL,prefixes:R.SHORT,value:1,offset:0},ohm:{name:"ohm",base:L.ELECTRIC_RESISTANCE,prefixes:R.SHORTLONG,value:1,offset:0},henry:{name:"henry",base:L.ELECTRIC_INDUCTANCE,prefixes:R.LONG,value:1,offset:0},H:{name:"H",base:L.ELECTRIC_INDUCTANCE,prefixes:R.SHORT,value:1,offset:0},siemens:{name:"siemens",base:L.ELECTRIC_CONDUCTANCE,prefixes:R.LONG,value:1,offset:0},S:{name:"S",base:L.ELECTRIC_CONDUCTANCE,prefixes:R.SHORT,value:1,offset:0},weber:{name:"weber",base:L.MAGNETIC_FLUX,prefixes:R.LONG,value:1,offset:0},Wb:{name:"Wb",base:L.MAGNETIC_FLUX,prefixes:R.SHORT,value:1,offset:0},tesla:{name:"tesla",base:L.MAGNETIC_FLUX_DENSITY,prefixes:R.LONG,value:1,offset:0},T:{name:"T",base:L.MAGNETIC_FLUX_DENSITY,prefixes:R.SHORT,value:1,offset:0},b:{name:"b",base:L.BIT,prefixes:R.BINARY_SHORT,value:1,offset:0},bits:{name:"bits",base:L.BIT,prefixes:R.BINARY_LONG,value:1,offset:0},B:{name:"B",base:L.BIT,prefixes:R.BINARY_SHORT,value:8,offset:0},bytes:{name:"bytes",base:L.BIT,prefixes:R.BINARY_LONG,value:8,offset:0}},D={meters:"meter",inches:"inch",feet:"foot",yards:"yard",miles:"mile",links:"link",rods:"rod",chains:"chain",angstroms:"angstrom",lt:"l",litres:"litre",liter:"litre",liters:"litre",teaspoons:"teaspoon",tablespoons:"tablespoon",minims:"minim",fluiddrams:"fluiddram",fluidounces:"fluidounce",gills:"gill",cups:"cup",pints:"pint",quarts:"quart",gallons:"gallon",beerbarrels:"beerbarrel",oilbarrels:"oilbarrel",hogsheads:"hogshead",gtts:"gtt",grams:"gram",tons:"ton",tonnes:"tonne",grains:"grain",drams:"dram",ounces:"ounce",poundmasses:"poundmass",hundredweights:"hundredweight",sticks:"stick",lb:"lbm",lbs:"lbm",kips:"kip",acres:"acre",hectares:"hectare",sqfeet:"sqft",sqyard:"sqyd",sqmile:"sqmi",sqmiles:"sqmi",mmhg:"mmHg",mmh2o:"mmH2O",cmh2o:"cmH2O",seconds:"second",secs:"second",minutes:"minute",mins:"minute",hours:"hour",hr:"hour",hrs:"hour",days:"day",weeks:"week",months:"month",years:"year",hertz:"hertz",radians:"rad",degree:"deg",degrees:"deg",gradian:"grad",gradians:"grad",cycles:"cycle",arcsecond:"arcsec",arcseconds:"arcsec",arcminute:"arcmin",arcminutes:"arcmin",BTUs:"BTU",watts:"watt",joules:"joule",amperes:"ampere",coulombs:"coulomb",volts:"volt",ohms:"ohm",farads:"farad",webers:"weber",teslas:"tesla",electronvolts:"electronvolt",moles:"mole"};function H(t){if("BigNumber"===t.number){var r=a.pi(e.BigNumber);F.rad.value=new e.BigNumber(1),F.deg.value=r.div(180),F.grad.value=r.div(200),F.cycle.value=r.times(2),F.arcsec.value=r.div(648e3),F.arcmin.value=r.div(10800)}else F.rad.value=1,F.deg.value=Math.PI/180,F.grad.value=Math.PI/200,F.cycle.value=2*Math.PI,F.arcsec.value=Math.PI/648e3,F.arcmin.value=Math.PI/10800}H(t),u.on("config",function(e,t){e.number!==t.number&&H(e)});var $={si:{NONE:{unit:j,prefix:R.NONE[""]},LENGTH:{unit:F.m,prefix:R.SHORT[""]},MASS:{unit:F.g,prefix:R.SHORT.k},TIME:{unit:F.s,prefix:R.SHORT[""]},CURRENT:{unit:F.A,prefix:R.SHORT[""]},TEMPERATURE:{unit:F.K,prefix:R.SHORT[""]},LUMINOUS_INTENSITY:{unit:F.cd,prefix:R.SHORT[""]},AMOUNT_OF_SUBSTANCE:{unit:F.mol,prefix:R.SHORT[""]},ANGLE:{unit:F.rad,prefix:R.SHORT[""]},BIT:{unit:F.bit,prefix:R.SHORT[""]},FORCE:{unit:F.N,prefix:R.SHORT[""]},ENERGY:{unit:F.J,prefix:R.SHORT[""]},POWER:{unit:F.W,prefix:R.SHORT[""]},PRESSURE:{unit:F.Pa,prefix:R.SHORT[""]},ELECTRIC_CHARGE:{unit:F.C,prefix:R.SHORT[""]},ELECTRIC_CAPACITANCE:{unit:F.F,prefix:R.SHORT[""]},ELECTRIC_POTENTIAL:{unit:F.V,prefix:R.SHORT[""]},ELECTRIC_RESISTANCE:{unit:F.ohm,prefix:R.SHORT[""]},ELECTRIC_INDUCTANCE:{unit:F.H,prefix:R.SHORT[""]},ELECTRIC_CONDUCTANCE:{unit:F.S,prefix:R.SHORT[""]},MAGNETIC_FLUX:{unit:F.Wb,prefix:R.SHORT[""]},MAGNETIC_FLUX_DENSITY:{unit:F.T,prefix:R.SHORT[""]},FREQUENCY:{unit:F.Hz,prefix:R.SHORT[""]}}};$.cgs=JSON.parse(JSON.stringify($.si)),$.cgs.LENGTH={unit:F.m,prefix:R.SHORT.c},$.cgs.MASS={unit:F.g,prefix:R.SHORT[""]},$.cgs.FORCE={unit:F.dyn,prefix:R.SHORT[""]},$.cgs.ENERGY={unit:F.erg,prefix:R.NONE[""]},$.us=JSON.parse(JSON.stringify($.si)),$.us.LENGTH={unit:F.ft,prefix:R.NONE[""]},$.us.MASS={unit:F.lbm,prefix:R.NONE[""]},$.us.TEMPERATURE={unit:F.degF,prefix:R.NONE[""]},$.us.FORCE={unit:F.lbf,prefix:R.NONE[""]},$.us.ENERGY={unit:F.BTU,prefix:R.BTU[""]},$.us.POWER={unit:F.hp,prefix:R.NONE[""]},$.us.PRESSURE={unit:F.psi,prefix:R.NONE[""]},$.auto=JSON.parse(JSON.stringify($.si));var G=$.auto;for(var U in O.setUnitSystem=function(e){if(!$.hasOwnProperty(e))throw new Error("Unit system "+e+" does not exist. Choices are: "+Object.keys($).join(", "));G=$[e]},O.getUnitSystem=function(){for(var e in $)if($[e]===G)return e},O.typeConverters={BigNumber:function(t){return new e.BigNumber(t+"")},Fraction:function(t){return new e.Fraction(t)},Complex:function(e){return e},number:function(e){return e}},O._getNumberConverter=function(e){if(!O.typeConverters[e])throw new TypeError('Unsupported type "'+e+'"');return O.typeConverters[e]},F)(V=F[U]).dimensions=V.base.dimensions;for(var Z in D)if(D.hasOwnProperty(Z)){var V=F[D[Z]],W={};for(var U in V)V.hasOwnProperty(U)&&(W[U]=V[U]);W.name=Z,F[Z]=W}return O.createUnit=function(e,t){if("object"!=typeof e)throw new TypeError("createUnit expects first parameter to be of type 'Object'");if(t&&t.override)for(var r in e)if(e.hasOwnProperty(r)&&O.deleteUnit(r),e[r].aliases)for(var n=0;n<e[r].aliases.length;n++)O.deleteUnit(e[r].aliases[n]);var i;for(var r in e)e.hasOwnProperty(r)&&(i=O.createUnitSingle(r,e[r]));return i},O.createUnitSingle=function(e,t,r){if(void 0!==t&&null!==t||(t={}),"string"!=typeof e)throw new TypeError("createUnitSingle expects first parameter to be of type 'string'");if(F.hasOwnProperty(e))throw new Error('Cannot create unit "'+e+'": a unit with that name already exists');!function(e){for(var t=0;t<e.length;t++){var r=e.charAt(t),n=function(e){return/^[a-zA-Z]$/.test(e)};if(0===t&&!n(r))throw new Error('Invalid unit name (must begin with alpha character): "'+e+'"');if(t>0&&!(n(r)||(i=r,i>="0"&&i<="9")))throw new Error('Invalid unit name (only alphanumeric characters are allowed): "'+e+'"')}var i}(e);var n,i,a=null,o=[],s=0;if(t&&"Unit"===t.type)a=t.clone();else if("string"==typeof t)""!==t&&(n=t);else{if("object"!=typeof t)throw new TypeError('Cannot create unit "'+e+'" from "'+t.toString()+'": expecting "string" or "Unit" or "Object"');n=t.definition,i=t.prefixes,s=t.offset,t.aliases&&(o=t.aliases.valueOf())}if(o)for(var u=0;u<o.length;u++)if(F.hasOwnProperty(o[u]))throw new Error('Cannot create alias "'+o[u]+'": a unit with that name already exists');if(n&&"string"==typeof n&&!a)try{a=O.parse(n,{allowNoUnits:!0})}catch(t){throw t.message='Could not create unit "'+e+'" from "'+n+'": '+t.message,t}else n&&"Unit"===n.type&&(a=n.clone());o=o||[],s=s||0,i=i&&i.toUpperCase&&R[i.toUpperCase()]||R.NONE;var c={};if(a){c={name:e,value:a.value,dimensions:a.dimensions.slice(0),prefixes:i,offset:s};var f=!1;for(var u in L)if(L.hasOwnProperty(u)){for(var l=!0,p=0;p<q.length;p++)if(Math.abs((c.dimensions[p]||0)-(L[u].dimensions[p]||0))>1e-12){l=!1;break}if(l){f=!0;break}}f||(h=e+"_STUFF",(d={dimensions:a.dimensions.slice(0)}).key=h,L[h]=d,G[h]={unit:c,prefix:R.NONE[""]},c.base=h)}else{var h=e+"_STUFF";if(q.indexOf(h)>=0)throw new Error('Cannot create new base unit "'+e+'": a base unit with that name already exists (and cannot be overridden)');for(var m in q.push(h),L)L.hasOwnProperty(m)&&(L[m].dimensions[q.length-1]=0);var d={dimensions:[]};for(u=0;u<q.length;u++)d.dimensions[u]=0;d.dimensions[q.length-1]=1,d.key=h,L[h]=d,c={name:e,value:1,dimensions:L[h].dimensions.slice(0),prefixes:i,offset:s,base:h},G[h]={unit:c,prefix:R.NONE[""]}}for(O.UNITS[e]=c,u=0;u<o.length;u++){var g=o[u],v={};for(var y in c)c.hasOwnProperty(y)&&(v[y]=c[y]);v.name=g,O.UNITS[g]=v}return new O(null,e)},O.deleteUnit=function(e){delete O.UNITS[e]},O.PREFIXES=R,O.BASE_DIMENSIONS=q,O.BASE_UNITS=L,O.UNIT_SYSTEMS=$,O.UNITS=F,O},t.math=!0},function(e,t,r){"use strict";var n=r(1);t.name="unit",t.factory=function(e,t,r,i){var a=i("unit",{Unit:function(e){return e.clone()},string:function(t){return e.Unit.isValuelessUnit(t)?new e.Unit(null,t):e.Unit.parse(t)},"number | BigNumber | Fraction | Complex, string":function(t,r){return new e.Unit(t,r)},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)${args[1]}\\right)"},a}},function(e,t,r){"use strict";r(1);t.name="createUnit",t.factory=function(e,t,r,n){return n("createUnit",{"Object, Object":function(t,r){return e.Unit.createUnit(t,r)},Object:function(t){return e.Unit.createUnit(t,{})},"string, Unit | string | Object, Object":function(t,r,n){var i={};return i[t]=r,e.Unit.createUnit(i,n)},"string, Unit | string | Object":function(t,r){var n={};return n[t]=r,e.Unit.createUnit(n,{})},string:function(t){var r={};return r[t]={},e.Unit.createUnit(r,{})}})}},function(e,t,r){"use strict";r(1);t.name="splitUnit",t.factory=function(e,t,r,n){return n("splitUnit",{"Unit, Array":function(e,t){return e.splitUnit(t)}})}},function(e,t,r){var n=r(5).lazy;function i(e,t,r){n(e,t,r),n(e.expression.mathWithTransform,t,r)}t.factory=function(e,t,r,n,a){function o(t){var r=e.Unit.parse(t);return r.fixPrefix=!0,r}i(a,"speedOfLight",function(){return o("299792458 m s^-1")}),i(a,"gravitationConstant",function(){return o("6.6738480e-11 m^3 kg^-1 s^-2")}),i(a,"planckConstant",function(){return o("6.626069311e-34 J s")}),i(a,"reducedPlanckConstant",function(){return o("1.05457172647e-34 J s")}),i(a,"magneticConstant",function(){return o("1.2566370614e-6 N A^-2")}),i(a,"electricConstant",function(){return o("8.854187817e-12 F m^-1")}),i(a,"vacuumImpedance",function(){return o("376.730313461 ohm")}),i(a,"coulomb",function(){return o("8.9875517873681764e9 N m^2 C^-2")}),i(a,"elementaryCharge",function(){return o("1.60217656535e-19 C")}),i(a,"bohrMagneton",function(){return o("9.2740096820e-24 J T^-1")}),i(a,"conductanceQuantum",function(){return o("7.748091734625e-5 S")}),i(a,"inverseConductanceQuantum",function(){return o("12906.403721742 ohm")}),i(a,"magneticFluxQuantum",function(){return o("2.06783375846e-15 Wb")}),i(a,"nuclearMagneton",function(){return o("5.0507835311e-27 J T^-1")}),i(a,"klitzing",function(){return o("25812.807443484 ohm")}),i(a,"bohrRadius",function(){return o("5.291772109217e-11 m")}),i(a,"classicalElectronRadius",function(){return o("2.817940326727e-15 m")}),i(a,"electronMass",function(){return o("9.1093829140e-31 kg")}),i(a,"fermiCoupling",function(){return o("1.1663645e-5 GeV^-2")}),i(a,"fineStructure",function(){return.007297352569824}),i(a,"hartreeEnergy",function(){return o("4.3597443419e-18 J")}),i(a,"protonMass",function(){return o("1.67262177774e-27 kg")}),i(a,"deuteronMass",function(){return o("3.3435830926e-27 kg")}),i(a,"neutronMass",function(){return o("1.6749271613e-27 kg")}),i(a,"quantumOfCirculation",function(){return o("3.636947552024e-4 m^2 s^-1")}),i(a,"rydberg",function(){return o("10973731.56853955 m^-1")}),i(a,"thomsonCrossSection",function(){return o("6.65245873413e-29 m^2")}),i(a,"weakMixingAngle",function(){return.222321}),i(a,"efimovFactor",function(){return 22.7}),i(a,"atomicMass",function(){return o("1.66053892173e-27 kg")}),i(a,"avogadro",function(){return o("6.0221412927e23 mol^-1")}),i(a,"boltzmann",function(){return o("1.380648813e-23 J K^-1")}),i(a,"faraday",function(){return o("96485.336521 C mol^-1")}),i(a,"firstRadiation",function(){return o("3.7417715317e-16 W m^2")}),i(a,"loschmidt",function(){return o("2.686780524e25 m^-3")}),i(a,"gasConstant",function(){return o("8.314462175 J K^-1 mol^-1")}),i(a,"molarPlanckConstant",function(){return o("3.990312717628e-10 J s mol^-1")}),i(a,"molarVolume",function(){return o("2.241396820e-10 m^3 mol^-1")}),i(a,"sackurTetrode",function(){return-1.164870823}),i(a,"secondRadiation",function(){return o("1.438777013e-2 m K")}),i(a,"stefanBoltzmann",function(){return o("5.67037321e-8 W m^-2 K^-4")}),i(a,"wienDisplacement",function(){return o("2.897772126e-3 m K")}),i(a,"molarMass",function(){return o("1e-3 kg mol^-1")}),i(a,"molarMassC12",function(){return o("1.2e-2 kg mol^-1")}),i(a,"gravity",function(){return o("9.80665 m s^-2")}),i(a,"planckLength",function(){return o("1.61619997e-35 m")}),i(a,"planckMass",function(){return o("2.1765113e-8 kg")}),i(a,"planckTime",function(){return o("5.3910632e-44 s")}),i(a,"planckCharge",function(){return o("1.87554595641e-18 C")}),i(a,"planckTemperature",function(){return o("1.41683385e+32 K")})},t.lazy=!1,t.math=!0},function(e,t,r){"use strict";var n=r(5),i=r(96);function a(e,t,r){e[t]=r,e.expression.mathWithTransform[t]=r}function o(e,t,r){n.lazy(e,t,r),n.lazy(e.expression.mathWithTransform,t,r)}t.factory=function e(t,n,s,u,c){c.on("config",function(r,i){r.number!==i.number&&e(t,n,s,u,c)}),a(c,"true",!0),a(c,"false",!1),a(c,"null",null),a(c,"uninitialized",r(2).UNINITIALIZED),"BigNumber"===n.number?(a(c,"Infinity",new t.BigNumber(1/0)),a(c,"NaN",new t.BigNumber(NaN)),o(c,"pi",function(){return i.pi(t.BigNumber)}),o(c,"tau",function(){return i.tau(t.BigNumber)}),o(c,"e",function(){return i.e(t.BigNumber)}),o(c,"phi",function(){return i.phi(t.BigNumber)}),o(c,"E",function(){return c.e}),o(c,"LN2",function(){return new t.BigNumber(2).ln()}),o(c,"LN10",function(){return new t.BigNumber(10).ln()}),o(c,"LOG2E",function(){return new t.BigNumber(1).div(new t.BigNumber(2).ln())}),o(c,"LOG10E",function(){return new t.BigNumber(1).div(new t.BigNumber(10).ln())}),o(c,"PI",function(){return c.pi}),o(c,"SQRT1_2",function(){return new t.BigNumber("0.5").sqrt()}),o(c,"SQRT2",function(){return new t.BigNumber(2).sqrt()})):(a(c,"Infinity",1/0),a(c,"NaN",NaN),a(c,"pi",Math.PI),a(c,"tau",2*Math.PI),a(c,"e",Math.E),a(c,"phi",1.618033988749895),a(c,"E",c.e),a(c,"LN2",Math.LN2),a(c,"LN10",Math.LN10),a(c,"LOG2E",Math.LOG2E),a(c,"LOG10E",Math.LOG10E),a(c,"PI",c.pi),a(c,"SQRT1_2",Math.SQRT1_2),a(c,"SQRT2",Math.SQRT2)),a(c,"i",t.Complex.I),a(c,"version",r(194))},t.lazy=!1,t.math=!0},function(e,t){e.exports="3.20.2"},function(e,t,r){e.exports=[r(100),r(388),r(393),r(395),r(406),r(41),r(113)]},function(e,t){e.exports={name:"bignumber",category:"Construction",syntax:["bignumber(x)"],description:"Create a big number from a number or string.",examples:["0.1 + 0.2","bignumber(0.1) + bignumber(0.2)",'bignumber("7.2")','bignumber("7.2e500")',"bignumber([0.1, 0.2, 0.3])"],seealso:["boolean","complex","fraction","index","matrix","string","unit"]}},function(e,t){e.exports={name:"boolean",category:"Construction",syntax:["x","boolean(x)"],description:"Convert a string or number into a boolean.",examples:["boolean(0)","boolean(1)","boolean(3)",'boolean("true")','boolean("false")',"boolean([1, 0, 1, 1])"],seealso:["bignumber","complex","index","matrix","number","string","unit"]}},function(e,t){e.exports={name:"complex",category:"Construction",syntax:["complex()","complex(re, im)","complex(string)"],description:"Create a complex number.",examples:["complex()","complex(2, 3)",'complex("7 - 2i")'],seealso:["bignumber","boolean","index","matrix","number","string","unit"]}},function(e,t){e.exports={name:"createUnit",category:"Construction",syntax:["createUnit(definitions)","createUnit(name, definition)"],description:"Create a user-defined unit and register it with the Unit type.",examples:['createUnit("foo")','createUnit("knot", {definition: "0.514444444 m/s", aliases: ["knots", "kt", "kts"]})','createUnit("mph", "1 mile/hour")'],seealso:["unit","splitUnit"]}},function(e,t){e.exports={name:"fraction",category:"Construction",syntax:["fraction(num)","fraction(num,den)"],description:"Create a fraction from a number or from a numerator and denominator.",examples:["fraction(0.125)","fraction(1, 3) + fraction(2, 5)"],seealso:["bignumber","boolean","complex","index","matrix","string","unit"]}},function(e,t){e.exports={name:"index",category:"Construction",syntax:["[start]","[start:end]","[start:step:end]","[start1, start 2, ...]","[start1:end1, start2:end2, ...]","[start1:step1:end1, start2:step2:end2, ...]"],description:"Create an index to get or replace a subset of a matrix",examples:["[]","[1, 2, 3]","A = [1, 2, 3; 4, 5, 6]","A[1, :]","A[1, 2] = 50","A[0:2, 0:2] = ones(2, 2)"],seealso:["bignumber","boolean","complex","matrix,","number","range","string","unit"]}},function(e,t){e.exports={name:"matrix",category:"Construction",syntax:["[]","[a1, b1, ...; a2, b2, ...]","matrix()",'matrix("dense")',"matrix([...])"],description:"Create a matrix.",examples:["[]","[1, 2, 3]","[1, 2, 3; 4, 5, 6]","matrix()","matrix([3, 4])",'matrix([3, 4; 5, 6], "sparse")','matrix([3, 4; 5, 6], "sparse", "number")'],seealso:["bignumber","boolean","complex","index","number","string","unit","sparse"]}},function(e,t){e.exports={name:"number",category:"Construction",syntax:["x","number(x)","number(unit, valuelessUnit)"],description:"Create a number or convert a string or boolean into a number.",examples:["2","2e3","4.05","number(2)",'number("7.2")',"number(true)","number([true, false, true, true])",'number(unit("52cm"), "m")'],seealso:["bignumber","boolean","complex","fraction","index","matrix","string","unit"]}},function(e,t){e.exports={name:"sparse",category:"Construction",syntax:["sparse()","sparse([a1, b1, ...; a1, b2, ...])",'sparse([a1, b1, ...; a1, b2, ...], "number")'],description:"Create a sparse matrix.",examples:["sparse()","sparse([3, 4; 5, 6])",'sparse([3, 0; 5, 0], "number")'],seealso:["bignumber","boolean","complex","index","number","string","unit","matrix"]}},function(e,t){e.exports={name:"splitUnit",category:"Construction",syntax:["splitUnit(unit: Unit, parts: Unit[])"],description:"Split a unit in an array of units whose sum is equal to the original unit.",examples:['splitUnit(1 m, ["feet", "inch"])'],seealso:["unit","createUnit"]}},function(e,t){e.exports={name:"string",category:"Construction",syntax:['"text"',"string(x)"],description:"Create a string or convert a value to a string",examples:['"Hello World!"',"string(4.2)","string(3 + 2i)"],seealso:["bignumber","boolean","complex","index","matrix","number","unit"]}},function(e,t){e.exports={name:"unit",category:"Construction",syntax:["value unit","unit(value, unit)","unit(string)"],description:"Create a unit.",examples:["5.5 mm","3 inch",'unit(7.1, "kilogram")','unit("23 deg")'],seealso:["bignumber","boolean","complex","index","matrix","number","string"]}},function(e,t){e.exports={name:"false",category:"Constants",syntax:["false"],description:"Boolean value false",examples:["false"],seealso:["true"]}},function(e,t){e.exports={name:"i",category:"Constants",syntax:["i"],description:"Imaginary unit, defined as i*i=-1. A complex number is described as a + b*i, where a is the real part, and b is the imaginary part.",examples:["i","i * i","sqrt(-1)"],seealso:[]}},function(e,t){e.exports={name:"Infinity",category:"Constants",syntax:["Infinity"],description:"Infinity, a number which is larger than the maximum number that can be handled by a floating point number.",examples:["Infinity","1 / 0"],seealso:[]}},function(e,t){e.exports={name:"LN2",category:"Constants",syntax:["LN2"],description:"Returns the natural logarithm of 2, approximately equal to 0.693",examples:["LN2","log(2)"],seealso:[]}},function(e,t){e.exports={name:"LN10",category:"Constants",syntax:["LN10"],description:"Returns the natural logarithm of 10, approximately equal to 2.302",examples:["LN10","log(10)"],seealso:[]}},function(e,t){e.exports={name:"LOG2E",category:"Constants",syntax:["LOG2E"],description:"Returns the base-2 logarithm of E, approximately equal to 1.442",examples:["LOG2E","log(e, 2)"],seealso:[]}},function(e,t){e.exports={name:"LOG10E",category:"Constants",syntax:["LOG10E"],description:"Returns the base-10 logarithm of E, approximately equal to 0.434",examples:["LOG10E","log(e, 10)"],seealso:[]}},function(e,t){e.exports={name:"NaN",category:"Constants",syntax:["NaN"],description:"Not a number",examples:["NaN","0 / 0"],seealso:[]}},function(e,t){e.exports={name:"null",category:"Constants",syntax:["null"],description:"Value null",examples:["null"],seealso:["true","false"]}},function(e,t){e.exports={name:"phi",category:"Constants",syntax:["phi"],description:"Phi is the golden ratio. Two quantities are in the golden ratio if their ratio is the same as the ratio of their sum to the larger of the two quantities. Phi is defined as `(1 + sqrt(5)) / 2` and is approximately 1.618034...",examples:["phi"],seealso:[]}},function(e,t){e.exports={name:"SQRT1_2",category:"Constants",syntax:["SQRT1_2"],description:"Returns the square root of 1/2, approximately equal to 0.707",examples:["SQRT1_2","sqrt(1/2)"],seealso:[]}},function(e,t){e.exports={name:"SQRT2",category:"Constants",syntax:["SQRT2"],description:"Returns the square root of 2, approximately equal to 1.414",examples:["SQRT2","sqrt(2)"],seealso:[]}},function(e,t){e.exports={name:"tau",category:"Constants",syntax:["tau"],description:"Tau is the ratio constant of a circle's circumference to radius, equal to 2 * pi, approximately 6.2832.",examples:["tau","2 * pi"],seealso:["pi"]}},function(e,t){e.exports={name:"true",category:"Constants",syntax:["true"],description:"Boolean value true",examples:["true"],seealso:["false"]}},function(e,t){e.exports={name:"version",category:"Constants",syntax:["version"],description:"A string with the version number of math.js",examples:["version"],seealso:[]}},function(e,t){e.exports={name:"derivative",category:"Algebra",syntax:["derivative(expr, variable)","derivative(expr, variable, {simplify: boolean})"],description:"Takes the derivative of an expression expressed in parser Nodes. The derivative will be taken over the supplied variable in the second parameter. If there are multiple variables in the expression, it will return a partial derivative.",examples:['derivative("2x^3", "x")','derivative("2x^3", "x", {simplify: false})','derivative("2x^2 + 3x + 4", "x")','derivative("sin(2x)", "x")','f = parse("x^2 + x")','x = parse("x")',"df = derivative(f, x)","df.eval({x: 3})"],seealso:["simplify","parse","eval"]}},function(e,t){e.exports={name:"lsolve",category:"Algebra",syntax:["x=lsolve(L, b)"],description:"Solves the linear system L * x = b where L is an [n x n] lower triangular matrix and b is a [n] column vector.",examples:["a = [-2, 3; 2, 1]","b = [11, 9]","x = lsolve(a, b)"],seealso:["lup","lusolve","usolve","matrix","sparse"]}},function(e,t){e.exports={name:"lup",category:"Algebra",syntax:["lup(m)"],description:"Calculate the Matrix LU decomposition with partial pivoting. Matrix A is decomposed in three matrices (L, U, P) where P * A = L * U",examples:["lup([[2, 1], [1, 4]])","lup(matrix([[2, 1], [1, 4]]))","lup(sparse([[2, 1], [1, 4]]))"],seealso:["lusolve","lsolve","usolve","matrix","sparse","slu","qr"]}},function(e,t){e.exports={name:"lusolve",category:"Algebra",syntax:["x=lusolve(A, b)","x=lusolve(lu, b)"],description:"Solves the linear system A * x = b where A is an [n x n] matrix and b is a [n] column vector.",examples:["a = [-2, 3; 2, 1]","b = [11, 9]","x = lusolve(a, b)"],seealso:["lup","slu","lsolve","usolve","matrix","sparse"]}},function(e,t){e.exports={name:"simplify",category:"Algebra",syntax:["simplify(expr)","simplify(expr, rules)"],description:"Simplify an expression tree.",examples:['simplify("3 + 2 / 4")','simplify("2x + x")','f = parse("x * (x + 2 + x)")',"simplified = simplify(f)","simplified.eval({x: 2})"],seealso:["derivative","parse","eval"]}},function(e,t){e.exports={name:"rationalize",category:"Algebra",syntax:["rationalize(expr)","rationalize(expr, scope)","rationalize(expr, scope, detailed)"],description:"Transform a rationalizable expression in a rational fraction. If rational fraction is one variable polynomial then converts the numerator and denominator in canonical form, with decreasing exponents, returning the coefficients of numerator.",examples:['rationalize("2x/y - y/(x+1)")','rationalize("2x/y - y/(x+1)", true)'],seealso:["simplify"]}},function(e,t){e.exports={name:"slu",category:"Algebra",syntax:["slu(A, order, threshold)"],description:"Calculate the Matrix LU decomposition with full pivoting. Matrix A is decomposed in two matrices (L, U) and two permutation vectors (pinv, q) where P * A * Q = L * U",examples:["slu(sparse([4.5, 0, 3.2, 0; 3.1, 2.9, 0, 0.9; 0, 1.7, 3, 0; 3.5, 0.4, 0, 1]), 1, 0.001)"],seealso:["lusolve","lsolve","usolve","matrix","sparse","lup","qr"]}},function(e,t){e.exports={name:"usolve",category:"Algebra",syntax:["x=usolve(U, b)"],description:"Solves the linear system U * x = b where U is an [n x n] upper triangular matrix and b is a [n] column vector.",examples:["x=usolve(sparse([1, 1, 1, 1; 0, 1, 1, 1; 0, 0, 1, 1; 0, 0, 0, 1]), [1; 2; 3; 4])"],seealso:["lup","lusolve","lsolve","matrix","sparse"]}},function(e,t){e.exports={name:"qr",category:"Algebra",syntax:["qr(A)"],description:"Calculates the Matrix QR decomposition. Matrix `A` is decomposed in two matrices (`Q`, `R`) where `Q` is an orthogonal matrix and `R` is an upper triangular matrix.",examples:["qr([[1, -1,  4], [1,  4, -2], [1,  4,  2], [1,  -1, 0]])"],seealso:["lup","slu","matrix"]}},function(e,t){e.exports={name:"abs",category:"Arithmetic",syntax:["abs(x)"],description:"Compute the absolute value.",examples:["abs(3.5)","abs(-4.2)"],seealso:["sign"]}},function(e,t){e.exports={name:"add",category:"Operators",syntax:["x + y","add(x, y)"],description:"Add two values.",examples:["a = 2.1 + 3.6","a - 3.6","3 + 2i","3 cm + 2 inch",'"2.3" + "4"'],seealso:["subtract"]}},function(e,t){e.exports={name:"cbrt",category:"Arithmetic",syntax:["cbrt(x)","cbrt(x, allRoots)"],description:"Compute the cubic root value. If x = y * y * y, then y is the cubic root of x. When `x` is a number or complex number, an optional second argument `allRoots` can be provided to return all three cubic roots. If not provided, the principal root is returned",examples:["cbrt(64)","cube(4)","cbrt(-8)","cbrt(2 + 3i)","cbrt(8i)","cbrt(8i, true)","cbrt(27 m^3)"],seealso:["square","sqrt","cube","multiply"]}},function(e,t){e.exports={name:"ceil",category:"Arithmetic",syntax:["ceil(x)"],description:"Round a value towards plus infinity. If x is complex, both real and imaginary part are rounded towards plus infinity.",examples:["ceil(3.2)","ceil(3.8)","ceil(-4.2)"],seealso:["floor","fix","round"]}},function(e,t){e.exports={name:"cube",category:"Arithmetic",syntax:["cube(x)"],description:"Compute the cube of a value. The cube of x is x * x * x.",examples:["cube(2)","2^3","2 * 2 * 2"],seealso:["multiply","square","pow"]}},function(e,t){e.exports={name:"divide",category:"Operators",syntax:["x / y","divide(x, y)"],description:"Divide two values.",examples:["a = 2 / 3","a * 3","4.5 / 2","3 + 4 / 2","(3 + 4) / 2","18 km / 4.5"],seealso:["multiply"]}},function(e,t){e.exports={name:"dotDivide",category:"Operators",syntax:["x ./ y","dotDivide(x, y)"],description:"Divide two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a ./ b"],seealso:["multiply","dotMultiply","divide"]}},function(e,t){e.exports={name:"dotMultiply",category:"Operators",syntax:["x .* y","dotMultiply(x, y)"],description:"Multiply two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a .* b"],seealso:["multiply","divide","dotDivide"]}},function(e,t){e.exports={name:"dotpow",category:"Operators",syntax:["x .^ y","dotpow(x, y)"],description:"Calculates the power of x to y element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","a .^ 2"],seealso:["pow"]}},function(e,t){e.exports={name:"exp",category:"Arithmetic",syntax:["exp(x)"],description:"Calculate the exponent of a value.",examples:["exp(1.3)","e ^ 1.3","log(exp(1.3))","x = 2.4","(exp(i*x) == cos(x) + i*sin(x))   # Euler's formula"],seealso:["pow","log"]}},function(e,t){e.exports={name:"fix",category:"Arithmetic",syntax:["fix(x)"],description:"Round a value towards zero. If x is complex, both real and imaginary part are rounded towards zero.",examples:["fix(3.2)","fix(3.8)","fix(-4.2)","fix(-4.8)"],seealso:["ceil","floor","round"]}},function(e,t){e.exports={name:"floor",category:"Arithmetic",syntax:["floor(x)"],description:"Round a value towards minus infinity.If x is complex, both real and imaginary part are rounded towards minus infinity.",examples:["floor(3.2)","floor(3.8)","floor(-4.2)"],seealso:["ceil","fix","round"]}},function(e,t){e.exports={name:"gcd",category:"Arithmetic",syntax:["gcd(a, b)","gcd(a, b, c, ...)"],description:"Compute the greatest common divisor.",examples:["gcd(8, 12)","gcd(-4, 6)","gcd(25, 15, -10)"],seealso:["lcm","xgcd"]}},function(e,t){e.exports={name:"hypot",category:"Arithmetic",syntax:["hypot(a, b, c, ...)","hypot([a, b, c, ...])"],description:"Calculate the hypotenusa of a list with values. ",examples:["hypot(3, 4)","sqrt(3^2 + 4^2)","hypot(-2)","hypot([3, 4, 5])"],seealso:["abs","norm"]}},function(e,t){e.exports={name:"lcm",category:"Arithmetic",syntax:["lcm(x, y)"],description:"Compute the least common multiple.",examples:["lcm(4, 6)","lcm(6, 21)","lcm(6, 21, 5)"],seealso:["gcd"]}},function(e,t){e.exports={name:"log",category:"Arithmetic",syntax:["log(x)","log(x, base)"],description:"Compute the logarithm of a value. If no base is provided, the natural logarithm of x is calculated. If base if provided, the logarithm is calculated for the specified base. log(x, base) is defined as log(x) / log(base).",examples:["log(3.5)","a = log(2.4)","exp(a)","10 ^ 4","log(10000, 10)","log(10000) / log(10)","b = log(1024, 2)","2 ^ b"],seealso:["exp","log10"]}},function(e,t){e.exports={name:"log10",category:"Arithmetic",syntax:["log10(x)"],description:"Compute the 10-base logarithm of a value.",examples:["log10(0.00001)","log10(10000)","10 ^ 4","log(10000) / log(10)","log(10000, 10)"],seealso:["exp","log"]}},function(e,t){e.exports={name:"mod",category:"Operators",syntax:["x % y","x mod y","mod(x, y)"],description:"Calculates the modulus, the remainder of an integer division.",examples:["7 % 3","11 % 2","10 mod 4","isOdd(x) = x % 2","isOdd(2)","isOdd(3)"],seealso:["divide"]}},function(e,t){e.exports={name:"multiply",category:"Operators",syntax:["x * y","multiply(x, y)"],description:"multiply two values.",examples:["a = 2.1 * 3.4","a / 3.4","2 * 3 + 4","2 * (3 + 4)","3 * 2.1 km"],seealso:["divide"]}},function(e,t){e.exports={name:"norm",category:"Arithmetic",syntax:["norm(x)","norm(x, p)"],description:"Calculate the norm of a number, vector or matrix.",examples:["abs(-3.5)","norm(-3.5)","norm(3 - 4i)","norm([1, 2, -3], Infinity)","norm([1, 2, -3], -Infinity)","norm([3, 4], 2)","norm([[1, 2], [3, 4]], 1)",'norm([[1, 2], [3, 4]], "inf")','norm([[1, 2], [3, 4]], "fro")']}},function(e,t){e.exports={name:"nthRoot",category:"Arithmetic",syntax:["nthRoot(a)","nthRoot(a, root)"],description:'Calculate the nth root of a value. The principal nth root of a positive real number A, is the positive real solution of the equation "x^root = A".',examples:["4 ^ 3","nthRoot(64, 3)","nthRoot(9, 2)","sqrt(9)"],seealso:["sqrt","pow"]}},function(e,t){e.exports={name:"pow",category:"Operators",syntax:["x ^ y","pow(x, y)"],description:"Calculates the power of x to y, x^y.",examples:["2^3","2*2*2","1 + e ^ (pi * i)"],seealso:["multiply"]}},function(e,t){e.exports={name:"round",category:"Arithmetic",syntax:["round(x)","round(x, n)"],description:"round a value towards the nearest integer.If x is complex, both real and imaginary part are rounded towards the nearest integer. When n is specified, the value is rounded to n decimals.",examples:["round(3.2)","round(3.8)","round(-4.2)","round(-4.8)","round(pi, 3)","round(123.45678, 2)"],seealso:["ceil","floor","fix"]}},function(e,t){e.exports={name:"sign",category:"Arithmetic",syntax:["sign(x)"],description:"Compute the sign of a value. The sign of a value x is 1 when x>1, -1 when x<0, and 0 when x=0.",examples:["sign(3.5)","sign(-4.2)","sign(0)"],seealso:["abs"]}},function(e,t){e.exports={name:"sqrt",category:"Arithmetic",syntax:["sqrt(x)"],description:"Compute the square root value. If x = y * y, then y is the square root of x.",examples:["sqrt(25)","5 * 5","sqrt(-1)"],seealso:["square","multiply"]}},function(e,t){e.exports={name:"square",category:"Arithmetic",syntax:["square(x)"],description:"Compute the square of a value. The square of x is x * x.",examples:["square(3)","sqrt(9)","3^2","3 * 3"],seealso:["multiply","pow","sqrt","cube"]}},function(e,t){e.exports={name:"subtract",category:"Operators",syntax:["x - y","subtract(x, y)"],description:"subtract two values.",examples:["a = 5.3 - 2","a + 2","2/3 - 1/6","2 * 3 - 3","2.1 km - 500m"],seealso:["add"]}},function(e,t){e.exports={name:"unaryMinus",category:"Operators",syntax:["-x","unaryMinus(x)"],description:"Inverse the sign of a value. Converts booleans and strings to numbers.",examples:["-4.5","-(-5.6)",'-"22"'],seealso:["add","subtract","unaryPlus"]}},function(e,t){e.exports={name:"unaryPlus",category:"Operators",syntax:["+x","unaryPlus(x)"],description:"Converts booleans and strings to numbers.",examples:["+true",'+"2"'],seealso:["add","subtract","unaryMinus"]}},function(e,t){e.exports={name:"xgcd",category:"Arithmetic",syntax:["xgcd(a, b)"],description:"Calculate the extended greatest common divisor for two values. The result is an array [d, x, y] with 3 entries, where d is the greatest common divisor, and d = x * a + y * b.",examples:["xgcd(8, 12)","gcd(8, 12)","xgcd(36163, 21199)"],seealso:["gcd","lcm"]}},function(e,t){e.exports={name:"bitAnd",category:"Bitwise",syntax:["x & y","bitAnd(x, y)"],description:"Bitwise AND operation. Performs the logical AND operation on each pair of the corresponding bits of the two given values by multiplying them. If both bits in the compared position are 1, the bit in the resulting binary representation is 1, otherwise, the result is 0",examples:["5 & 3","bitAnd(53, 131)","[1, 12, 31] & 42"],seealso:["bitNot","bitOr","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"bitNot",category:"Bitwise",syntax:["~x","bitNot(x)"],description:"Bitwise NOT operation. Performs a logical negation on each bit of the given value. Bits that are 0 become 1, and those that are 1 become 0.",examples:["~1","~2","bitNot([2, -3, 4])"],seealso:["bitAnd","bitOr","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"bitOr",category:"Bitwise",syntax:["x | y","bitOr(x, y)"],description:"Bitwise OR operation. Performs the logical inclusive OR operation on each pair of corresponding bits of the two given values. The result in each position is 1 if the first bit is 1 or the second bit is 1 or both bits are 1, otherwise, the result is 0.",examples:["5 | 3","bitOr([1, 2, 3], 4)"],seealso:["bitAnd","bitNot","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"bitXor",category:"Bitwise",syntax:["bitXor(x, y)"],description:"Bitwise XOR operation, exclusive OR. Performs the logical exclusive OR operation on each pair of corresponding bits of the two given values. The result in each position is 1 if only the first bit is 1 or only the second bit is 1, but will be 0 if both are 0 or both are 1.",examples:["bitOr(1, 2)","bitXor([2, 3, 4], 4)"],seealso:["bitAnd","bitNot","bitOr","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"leftShift",category:"Bitwise",syntax:["x << y","leftShift(x, y)"],description:"Bitwise left logical shift of a value x by y number of bits.",examples:["4 << 1","8 >> 1"],seealso:["bitAnd","bitNot","bitOr","bitXor","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"rightArithShift",category:"Bitwise",syntax:["x >> y","rightArithShift(x, y)"],description:"Bitwise right arithmetic shift of a value x by y number of bits.",examples:["8 >> 1","4 << 1","-12 >> 2"],seealso:["bitAnd","bitNot","bitOr","bitXor","leftShift","rightLogShift"]}},function(e,t){e.exports={name:"rightLogShift",category:"Bitwise",syntax:["x >>> y","rightLogShift(x, y)"],description:"Bitwise right logical shift of a value x by y number of bits.",examples:["8 >>> 1","4 << 1","-12 >>> 2"],seealso:["bitAnd","bitNot","bitOr","bitXor","leftShift","rightArithShift"]}},function(e,t){e.exports={name:"bellNumbers",category:"Combinatorics",syntax:["bellNumbers(n)"],description:"The Bell Numbers count the number of partitions of a set. A partition is a pairwise disjoint subset of S whose union is S. `bellNumbers` only takes integer arguments. The following condition must be enforced: n >= 0.",examples:["bellNumbers(3)","bellNumbers(8)"],seealso:["stirlingS2"]}},function(e,t){e.exports={name:"catalan",category:"Combinatorics",syntax:["catalan(n)"],description:"The Catalan Numbers enumerate combinatorial structures of many different types. catalan only takes integer arguments. The following condition must be enforced: n >= 0.",examples:["catalan(3)","catalan(8)"],seealso:["bellNumbers"]}},function(e,t){e.exports={name:"composition",category:"Combinatorics",syntax:["composition(n, k)"],description:"The composition counts of n into k parts. composition only takes integer arguments. The following condition must be enforced: k <= n.",examples:["composition(5, 3)"],seealso:["combinations"]}},function(e,t){e.exports={name:"stirlingS2",category:"Combinatorics",syntax:["stirlingS2(n, k)"],description:"he Stirling numbers of the second kind, counts the number of ways to partition a set of n labelled objects into k nonempty unlabelled subsets. `stirlingS2` only takes integer arguments. The following condition must be enforced: k <= n. If n = k or k = 1, then s(n,k) = 1.",examples:["stirlingS2(5, 3)"],seealso:["bellNumbers"]}},function(e,t){e.exports={name:"config",category:"Core",syntax:["config()","config(options)"],description:"Get configuration or change configuration.",examples:["config()","1/3 + 1/4",'config({number: "Fraction"})',"1/3 + 1/4"],seealso:[]}},function(e,t){e.exports={name:"import",category:"Core",syntax:["import(functions)","import(functions, options)"],description:"Import functions or constants from an object.",examples:["import({myFn: f(x)=x^2, myConstant: 32 })","myFn(2)","myConstant"],seealso:[]}},function(e,t){e.exports={name:"typed",category:"Core",syntax:["typed(signatures)","typed(name, signatures)"],description:"Create a typed function.",examples:['double = typed({ "number, number": f(x)=x+x })',"double(2)",'double("hello")'],seealso:[]}},function(e,t){e.exports={name:"arg",category:"Complex",syntax:["arg(x)"],description:"Compute the argument of a complex value. If x = a+bi, the argument is computed as atan2(b, a).",examples:["arg(2 + 2i)","atan2(3, 2)","arg(2 + 3i)"],seealso:["re","im","conj","abs"]}},function(e,t){e.exports={name:"conj",category:"Complex",syntax:["conj(x)"],description:"Compute the complex conjugate of a complex value. If x = a+bi, the complex conjugate is a-bi.",examples:["conj(2 + 3i)","conj(2 - 3i)","conj(-5.2i)"],seealso:["re","im","abs","arg"]}},function(e,t){e.exports={name:"re",category:"Complex",syntax:["re(x)"],description:"Get the real part of a complex number.",examples:["re(2 + 3i)","im(2 + 3i)","re(-5.2i)","re(2.4)"],seealso:["im","conj","abs","arg"]}},function(e,t){e.exports={name:"im",category:"Complex",syntax:["im(x)"],description:"Get the imaginary part of a complex number.",examples:["im(2 + 3i)","re(2 + 3i)","im(-5.2i)","im(2.4)"],seealso:["re","conj","abs","arg"]}},function(e,t){e.exports={name:"eval",category:"Expression",syntax:["eval(expression)","eval([expr1, expr2, expr3, ...])"],description:"Evaluate an expression or an array with expressions.",examples:['eval("2 + 3")','eval("sqrt(" + 4 + ")")'],seealso:[]}},function(e,t){e.exports={name:"help",category:"Expression",syntax:["help(object)","help(string)"],description:"Display documentation on a function or data type.",examples:["help(sqrt)",'help("complex")'],seealso:[]}},function(e,t){e.exports={name:"distance",category:"Geometry",syntax:["distance([x1, y1], [x2, y2])","distance([[x1, y1], [x2, y2])"],description:"Calculates the Euclidean distance between two points.",examples:["distance([0,0], [4,4])","distance([[0,0], [4,4]])"],seealso:[]}},function(e,t){e.exports={name:"intersect",category:"Geometry",syntax:["intersect(expr1, expr2, expr3, expr4)","intersect(expr1, expr2, expr3)"],description:"Computes the intersection point of lines and/or planes.",examples:["intersect([0, 0], [10, 10], [10, 0], [0, 10])","intersect([1, 0, 1],  [4, -2, 2], [1, 1, 1, 6])"],seealso:[]}},function(e,t){e.exports={name:"and",category:"Logical",syntax:["x and y","and(x, y)"],description:"Logical and. Test whether two values are both defined with a nonzero/nonempty value.",examples:["true and false","true and true","2 and 4"],seealso:["not","or","xor"]}},function(e,t){e.exports={name:"not",category:"Logical",syntax:["not x","not(x)"],description:"Logical not. Flips the boolean value of given argument.",examples:["not true","not false","not 2","not 0"],seealso:["and","or","xor"]}},function(e,t){e.exports={name:"or",category:"Logical",syntax:["x or y","or(x, y)"],description:"Logical or. Test if at least one value is defined with a nonzero/nonempty value.",examples:["true or false","false or false","0 or 4"],seealso:["not","and","xor"]}},function(e,t){e.exports={name:"xor",category:"Logical",syntax:["x xor y","xor(x, y)"],description:"Logical exclusive or, xor. Test whether one and only one value is defined with a nonzero/nonempty value.",examples:["true xor false","false xor false","true xor true","0 xor 4"],seealso:["not","and","or"]}},function(e,t){e.exports={name:"concat",category:"Matrix",syntax:["concat(A, B, C, ...)","concat(A, B, C, ..., dim)"],description:"Concatenate matrices. By default, the matrices are concatenated by the last dimension. The dimension on which to concatenate can be provided as last argument.",examples:["A = [1, 2; 5, 6]","B = [3, 4; 7, 8]","concat(A, B)","concat(A, B, 1)","concat(A, B, 2)"],seealso:["det","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"cross",category:"Matrix",syntax:["cross(A, B)"],description:"Calculate the cross product for two vectors in three dimensional space.",examples:["cross([1, 1, 0],  [0, 1, 1])","cross([3, -3, 1], [4, 9, 2])","cross([2, 3, 4],  [5, 6, 7])"],seealso:["multiply","dot"]}},function(e,t){e.exports={name:"det",category:"Matrix",syntax:["det(x)"],description:"Calculate the determinant of a matrix",examples:["det([1, 2; 3, 4])","det([-2, 2, 3; -1, 1, 3; 2, 0, -1])"],seealso:["concat","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"diag",category:"Matrix",syntax:["diag(x)","diag(x, k)"],description:"Create a diagonal matrix or retrieve the diagonal of a matrix. When x is a vector, a matrix with the vector values on the diagonal will be returned. When x is a matrix, a vector with the diagonal values of the matrix is returned. When k is provided, the k-th diagonal will be filled in or retrieved, if k is positive, the values are placed on the super diagonal. When k is negative, the values are placed on the sub diagonal.",examples:["diag(1:3)","diag(1:3, 1)","a = [1, 2, 3; 4, 5, 6; 7, 8, 9]","diag(a)"],seealso:["concat","det","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"dot",category:"Matrix",syntax:["dot(A, B)","A * B"],description:"Calculate the dot product of two vectors. The dot product of A = [a1, a2, a3, ..., an] and B = [b1, b2, b3, ..., bn] is defined as dot(A, B) = a1 * b1 + a2 * b2 + a3 * b3 + ... + an * bn",examples:["dot([2, 4, 1], [2, 2, 3])","[2, 4, 1] * [2, 2, 3]"],seealso:["multiply","cross"]}},function(e,t){e.exports={name:"eye",category:"Matrix",syntax:["eye(n)","eye(m, n)","eye([m, n])"],description:"Returns the identity matrix with size m-by-n. The matrix has ones on the diagonal and zeros elsewhere.",examples:["eye(3)","eye(3, 5)","a = [1, 2, 3; 4, 5, 6]","eye(size(a))"],seealso:["concat","det","diag","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"filter",category:"Matrix",syntax:["filter(x, test)"],description:"Filter items in a matrix.",examples:["isPositive(x) = x > 0","filter([6, -2, -1, 4, 3], isPositive)","filter([6, -2, 0, 1, 0], x != 0)"],seealso:["sort","map","forEach"]}},function(e,t){e.exports={name:"flatten",category:"Matrix",syntax:["flatten(x)"],description:"Flatten a multi dimensional matrix into a single dimensional matrix.",examples:["a = [1, 2, 3; 4, 5, 6]","size(a)","b = flatten(a)","size(b)"],seealso:["concat","resize","size","squeeze"]}},function(e,t){e.exports={name:"forEach",category:"Matrix",syntax:["forEach(x, callback)"],description:"Iterates over all elements of a matrix/array, and executes the given callback function.",examples:["forEach([1, 2, 3], function(val) { console.log(val) })"],seealso:["map","sort","filter"]}},function(e,t){e.exports={name:"inv",category:"Matrix",syntax:["inv(x)"],description:"Calculate the inverse of a matrix",examples:["inv([1, 2; 3, 4])","inv(4)","1 / 4"],seealso:["concat","det","diag","eye","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"kron",category:"Matrix",syntax:["kron(x, y)"],description:"Calculates the kronecker product of 2 matrices or vectors.",examples:["kron([[1, 0], [0, 1]], [[1, 2], [3, 4]])","kron([1,1], [2,3,4])"],seealso:["multiply","dot","cross"]}},function(e,t){e.exports={name:"map",category:"Matrix",syntax:["map(x, callback)"],description:"Create a new matrix or array with the results of the callback function executed on each entry of the matrix/array.",examples:["map([1, 2, 3], square)"],seealso:["filter","forEach"]}},function(e,t){e.exports={name:"ones",category:"Matrix",syntax:["ones(m)","ones(m, n)","ones(m, n, p, ...)","ones([m])","ones([m, n])","ones([m, n, p, ...])"],description:"Create a matrix containing ones.",examples:["ones(3)","ones(3, 5)","ones([2,3]) * 4.5","a = [1, 2, 3; 4, 5, 6]","ones(size(a))"],seealso:["concat","det","diag","eye","inv","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"partitionSelect",category:"Matrix",syntax:["partitionSelect(x, k)","partitionSelect(x, k, compare)"],description:"Partition-based selection of an array or 1D matrix. Will find the kth smallest value, and mutates the input array. Uses Quickselect.",examples:["partitionSelect([5, 10, 1], 2)",'partitionSelect(["C", "B", "A", "D"], 1)'],seealso:["sort"]}},function(e,t){e.exports={name:"range",category:"Type",syntax:["start:end","start:step:end","range(start, end)","range(start, end, step)","range(string)"],description:"Create a range. Lower bound of the range is included, upper bound is excluded.",examples:["1:5","3:-1:-3","range(3, 7)","range(0, 12, 2)",'range("4:10")',"a = [1, 2, 3, 4; 5, 6, 7, 8]","a[1:2, 1:2]"],seealso:["concat","det","diag","eye","inv","ones","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"resize",category:"Matrix",syntax:["resize(x, size)","resize(x, size, defaultValue)"],description:"Resize a matrix.",examples:["resize([1,2,3,4,5], [3])","resize([1,2,3], [5])","resize([1,2,3], [5], -1)","resize(2, [2, 3])",'resize("hello", [8], "!")'],seealso:["size","subset","squeeze","reshape"]}},function(e,t){e.exports={name:"reshape",category:"Matrix",syntax:["reshape(x, sizes)"],description:"Reshape a multi dimensional array to fit the specified dimensions.",examples:["reshape([1, 2, 3, 4, 5, 6], [2, 3])","reshape([[1, 2], [3, 4]], [1, 4])","reshape([[1, 2], [3, 4]], [4])"],seealso:["size","squeeze","resize"]}},function(e,t){e.exports={name:"size",category:"Matrix",syntax:["size(x)"],description:"Calculate the size of a matrix.",examples:["size(2.3)",'size("hello world")',"a = [1, 2; 3, 4; 5, 6]","size(a)","size(1:6)"],seealso:["concat","det","diag","eye","inv","ones","range","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"sort",category:"Matrix",syntax:["sort(x)","sort(x, compare)"],description:'Sort the items in a matrix. Compare can be a string "asc", "desc", "natural", or a custom sort function.',examples:["sort([5, 10, 1])",'sort(["C", "B", "A", "D"])',"sortByLength(a, b) = size(a)[1] - size(b)[1]",'sort(["Langdon", "Tom", "Sara"], sortByLength)','sort(["10", "1", "2"], "natural")'],seealso:["map","filter","forEach"]}},function(e,t){e.exports={name:"squeeze",category:"Matrix",syntax:["squeeze(x)"],description:"Remove inner and outer singleton dimensions from a matrix.",examples:["a = zeros(3,2,1)","size(squeeze(a))","b = zeros(1,1,3)","size(squeeze(b))"],seealso:["concat","det","diag","eye","inv","ones","range","size","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"subset",category:"Matrix",syntax:["value(index)","value(index) = replacement","subset(value, [index])","subset(value, [index], replacement)"],description:"Get or set a subset of a matrix or string. Indexes are one-based. Both the ranges lower-bound and upper-bound are included.",examples:["d = [1, 2; 3, 4]","e = []","e[1, 1:2] = [5, 6]","e[2, :] = [7, 8]","f = d * e","f[2, 1]","f[:, 1]"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","trace","transpose","zeros"]}},function(e,t){e.exports={name:"trace",category:"Matrix",syntax:["trace(A)"],description:"Calculate the trace of a matrix: the sum of the elements on the main diagonal of a square matrix.",examples:["A = [1, 2, 3; -1, 2, 3; 2, 0, 3]","trace(A)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e,t){e.exports={name:"transpose",category:"Matrix",syntax:["x'","transpose(x)"],description:"Transpose a matrix",examples:["a = [1, 2, 3; 4, 5, 6]","a'","transpose(a)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","trace","zeros"]}},function(e,t){e.exports={name:"zeros",category:"Matrix",syntax:["zeros(m)","zeros(m, n)","zeros(m, n, p, ...)","zeros([m])","zeros([m, n])","zeros([m, n, p, ...])"],description:"Create a matrix containing zeros.",examples:["zeros(3)","zeros(3, 5)","a = [1, 2, 3; 4, 5, 6]","zeros(size(a))"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose"]}},function(e,t){e.exports={name:"combinations",category:"Probability",syntax:["combinations(n, k)"],description:"Compute the number of combinations of n items taken k at a time",examples:["combinations(7, 5)"],seealso:["permutations","factorial"]}},function(e,t){e.exports={name:"factorial",category:"Probability",syntax:["n!","factorial(n)"],description:"Compute the factorial of a value",examples:["5!","5 * 4 * 3 * 2 * 1","3!"],seealso:["combinations","permutations","gamma"]}},function(e,t){e.exports={name:"gamma",category:"Probability",syntax:["gamma(n)"],description:"Compute the gamma function. For small values, the Lanczos approximation is used, and for large values the extended Stirling approximation.",examples:["gamma(4)","3!","gamma(1/2)","sqrt(pi)"],seealso:["factorial"]}},function(e,t){e.exports={name:"kldivergence",category:"Probability",syntax:["kldivergence(x, y)"],description:"Calculate the Kullback-Leibler (KL) divergence  between two distributions.",examples:["kldivergence([0.7,0.5,0.4], [0.2,0.9,0.5])"],seealso:[]}},function(e,t){e.exports={name:"multinomial",category:"Probability",syntax:["multinomial(A)"],description:"Multinomial Coefficients compute the number of ways of picking a1, a2, ..., ai unordered outcomes from `n` possibilities. multinomial takes one array of integers as an argument. The following condition must be enforced: every ai > 0.",examples:["multinomial([1, 2, 1])"],seealso:["combinations","factorial"]}},function(e,t){e.exports={name:"permutations",category:"Probability",syntax:["permutations(n)","permutations(n, k)"],description:"Compute the number of permutations of n items taken k at a time",examples:["permutations(5)","permutations(5, 3)"],seealso:["combinations","factorial"]}},function(e,t){e.exports={name:"pickRandom",category:"Probability",syntax:["pickRandom(array)","pickRandom(array, number)","pickRandom(array, weights)","pickRandom(array, number, weights)","pickRandom(array, weights, number)"],description:"Pick a random entry from a given array.",examples:["pickRandom(0:10)","pickRandom([1, 3, 1, 6])","pickRandom([1, 3, 1, 6], 2)","pickRandom([1, 3, 1, 6], [2, 3, 2, 1])","pickRandom([1, 3, 1, 6], 2, [2, 3, 2, 1])","pickRandom([1, 3, 1, 6], [2, 3, 2, 1], 2)"],seealso:["random","randomInt"]}},function(e,t){e.exports={name:"random",category:"Probability",syntax:["random()","random(max)","random(min, max)","random(size)","random(size, max)","random(size, min, max)"],description:"Return a random number.",examples:["random()","random(10, 20)","random([2, 3])"],seealso:["pickRandom","randomInt"]}},function(e,t){e.exports={name:"randomInt",category:"Probability",syntax:["randomInt(max)","randomInt(min, max)","randomInt(size)","randomInt(size, max)","randomInt(size, min, max)"],description:"Return a random integer number",examples:["randomInt(10, 20)","randomInt([2, 3], 10)"],seealso:["pickRandom","random"]}},function(e,t){e.exports={name:"compare",category:"Relational",syntax:["compare(x, y)"],description:"Compare two values. Returns 1 if x is larger than y, -1 if x is smaller than y, and 0 if x and y are equal.",examples:["compare(2, 3)","compare(3, 2)","compare(2, 2)","compare(5cm, 40mm)","compare(2, [1, 2, 3])"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compareNatural"]}},function(e,t){e.exports={name:"compareNatural",category:"Relational",syntax:["compareNatural(x, y)"],description:"Compare two values of any type in a deterministic, natural way.",examples:["compareNatural(2, 3)","compareNatural(3, 2)","compareNatural(2, 2)","compareNatural(5cm, 40mm)",'compareNatural("2", "10")',"compareNatural(2 + 3i, 2 + 4i)","compareNatural([1, 2, 4], [1, 2, 3])","compareNatural([1, 5], [1, 2, 3])","compareNatural([1, 2], [1, 2])","compareNatural({a: 2}, {a: 4})"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"deepEqual",category:"Relational",syntax:["deepEqual(x, y)"],description:"Check equality of two matrices element wise. Returns true if the size of both matrices is equal and when and each of the elements are equal.",examples:["deepEqual([1,3,4], [1,3,4])","deepEqual([1,3,4], [1,3])"],seealso:["equal","unequal","smaller","larger","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"equal",category:"Relational",syntax:["x == y","equal(x, y)"],description:"Check equality of two values. Returns true if the values are equal, and false if not.",examples:["2+2 == 3","2+2 == 4","a = 3.2","b = 6-2.8","a == b","50cm == 0.5m"],seealso:["unequal","smaller","larger","smallerEq","largerEq","compare","deepEqual"]}},function(e,t){e.exports={name:"larger",category:"Relational",syntax:["x > y","larger(x, y)"],description:"Check if value x is larger than y. Returns true if x is larger than y, and false if not.",examples:["2 > 3","5 > 2*2","a = 3.3","b = 6-2.8","(a > b)","(b < a)","5 cm > 2 inch"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"largerEq",category:"Relational",syntax:["x >= y","largerEq(x, y)"],description:"Check if value x is larger or equal to y. Returns true if x is larger or equal to y, and false if not.",examples:["2 >= 1+1","2 > 1+1","a = 3.2","b = 6-2.8","(a >= b)"],seealso:["equal","unequal","smallerEq","smaller","compare"]}},function(e,t){e.exports={name:"smaller",category:"Relational",syntax:["x < y","smaller(x, y)"],description:"Check if value x is smaller than value y. Returns true if x is smaller than y, and false if not.",examples:["2 < 3","5 < 2*2","a = 3.3","b = 6-2.8","(a < b)","5 cm < 2 inch"],seealso:["equal","unequal","larger","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"smallerEq",category:"Relational",syntax:["x <= y","smallerEq(x, y)"],description:"Check if value x is smaller or equal to value y. Returns true if x is smaller than y, and false if not.",examples:["2 <= 1+1","2 < 1+1","a = 3.2","b = 6-2.8","(a <= b)"],seealso:["equal","unequal","larger","smaller","largerEq","compare"]}},function(e,t){e.exports={name:"unequal",category:"Relational",syntax:["x != y","unequal(x, y)"],description:"Check unequality of two values. Returns true if the values are unequal, and false if they are equal.",examples:["2+2 != 3","2+2 != 4","a = 3.2","b = 6-2.8","a != b","50cm != 0.5m","5 cm != 2 inch"],seealso:["equal","smaller","larger","smallerEq","largerEq","compare","deepEqual"]}},function(e,t){e.exports={name:"setCartesian",category:"Set",syntax:["setCartesian(set1, set2)"],description:"Create the cartesian product of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setCartesian([1, 2], [3, 4])"],seealso:["setUnion","setIntersect","setDifference","setPowerset"]}},function(e,t){e.exports={name:"setDifference",category:"Set",syntax:["setDifference(set1, set2)"],description:"Create the difference of two (multi)sets: every element of set1, that is not the element of set2. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setDifference([1, 2, 3, 4], [3, 4, 5, 6])","setDifference([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setIntersect","setSymDifference"]}},function(e,t){e.exports={name:"setDistinct",category:"Set",syntax:["setDistinct(set)"],description:"Collect the distinct elements of a multiset. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setDistinct([1, 1, 1, 2, 2, 3])"],seealso:["setMultiplicity"]}},function(e,t){e.exports={name:"setIntersect",category:"Set",syntax:["setIntersect(set1, set2)"],description:"Create the intersection of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setIntersect([1, 2, 3, 4], [3, 4, 5, 6])","setIntersect([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setDifference"]}},function(e,t){e.exports={name:"setIsSubset",category:"Set",syntax:["setIsSubset(set1, set2)"],description:"Check whether a (multi)set is a subset of another (multi)set: every element of set1 is the element of set2. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setIsSubset([1, 2], [3, 4, 5, 6])","setIsSubset([3, 4], [3, 4, 5, 6])"],seealso:["setUnion","setIntersect","setDifference"]}},function(e,t){e.exports={name:"setMultiplicity",category:"Set",syntax:["setMultiplicity(element, set)"],description:"Count the multiplicity of an element in a multiset. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setMultiplicity(1, [1, 2, 2, 4])","setMultiplicity(2, [1, 2, 2, 4])"],seealso:["setDistinct","setSize"]}},function(e,t){e.exports={name:"setPowerset",category:"Set",syntax:["setPowerset(set)"],description:"Create the powerset of a (multi)set: the powerset contains very possible subsets of a (multi)set. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setPowerset([1, 2, 3])"],seealso:["setCartesian"]}},function(e,t){e.exports={name:"setSize",category:"Set",syntax:["setSize(set)","setSize(set, unique)"],description:'Count the number of elements of a (multi)set. When the second parameter "unique" is true, count only the unique values. A multi-dimension array will be converted to a single-dimension array before the operation.',examples:["setSize([1, 2, 2, 4])","setSize([1, 2, 2, 4], true)"],seealso:["setUnion","setIntersect","setDifference"]}},function(e,t){e.exports={name:"setSymDifference",category:"Set",syntax:["setSymDifference(set1, set2)"],description:"Create the symmetric difference of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setSymDifference([1, 2, 3, 4], [3, 4, 5, 6])","setSymDifference([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setIntersect","setDifference"]}},function(e,t){e.exports={name:"setUnion",category:"Set",syntax:["setUnion(set1, set2)"],description:"Create the union of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setUnion([1, 2, 3, 4], [3, 4, 5, 6])","setUnion([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setIntersect","setDifference"]}},function(e,t){e.exports={name:"erf",category:"Special",syntax:["erf(x)"],description:"Compute the erf function of a value using a rational Chebyshev approximations for different intervals of x",examples:["erf(0.2)","erf(-0.5)","erf(4)"],seealso:[]}},function(e,t){e.exports={name:"mad",category:"Statistics",syntax:["mad(a, b, c, ...)","mad(A)"],description:"Compute the median absolute deviation of a matrix or a list with values. The median absolute deviation is defined as the median of the absolute deviations from the median.",examples:["mad(10, 20, 30)","mad([1, 2, 3])"],seealso:["mean","median","std","abs"]}},function(e,t){e.exports={name:"max",category:"Statistics",syntax:["max(a, b, c, ...)","max(A)","max(A, dim)"],description:"Compute the maximum value of a list of values.",examples:["max(2, 3, 4, 1)","max([2, 3, 4, 1])","max([2, 5; 4, 3])","max([2, 5; 4, 3], 1)","max([2, 5; 4, 3], 2)","max(2.7, 7.1, -4.5, 2.0, 4.1)","min(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["mean","median","min","prod","std","sum","var"]}},function(e,t){e.exports={name:"mean",category:"Statistics",syntax:["mean(a, b, c, ...)","mean(A)","mean(A, dim)"],description:"Compute the arithmetic mean of a list of values.",examples:["mean(2, 3, 4, 1)","mean([2, 3, 4, 1])","mean([2, 5; 4, 3])","mean([2, 5; 4, 3], 1)","mean([2, 5; 4, 3], 2)","mean([1.0, 2.7, 3.2, 4.0])"],seealso:["max","median","min","prod","std","sum","var"]}},function(e,t){e.exports={name:"median",category:"Statistics",syntax:["median(a, b, c, ...)","median(A)"],description:"Compute the median of all values. The values are sorted and the middle value is returned. In case of an even number of values, the average of the two middle values is returned.",examples:["median(5, 2, 7)","median([3, -1, 5, 7])"],seealso:["max","mean","min","prod","std","sum","var","quantileSeq"]}},function(e,t){e.exports={name:"min",category:"Statistics",syntax:["min(a, b, c, ...)","min(A)","min(A, dim)"],description:"Compute the minimum value of a list of values.",examples:["min(2, 3, 4, 1)","min([2, 3, 4, 1])","min([2, 5; 4, 3])","min([2, 5; 4, 3], 1)","min([2, 5; 4, 3], 2)","min(2.7, 7.1, -4.5, 2.0, 4.1)","max(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["max","mean","median","prod","std","sum","var"]}},function(e,t){e.exports={name:"mode",category:"Statistics",syntax:["mode(a, b, c, ...)","mode(A)","mode(A, a, b, B, c, ...)"],description:"Computes the mode of all values as an array. In case mode being more than one, multiple values are returned in an array.",examples:["mode(2, 1, 4, 3, 1)","mode([1, 2.7, 3.2, 4, 2.7])","mode(1, 4, 6, 1, 6)"],seealso:["max","mean","min","median","prod","std","sum","var"]}},function(e,t){e.exports={name:"prod",category:"Statistics",syntax:["prod(a, b, c, ...)","prod(A)"],description:"Compute the product of all values.",examples:["prod(2, 3, 4)","prod([2, 3, 4])","prod([2, 5; 4, 3])"],seealso:["max","mean","min","median","min","std","sum","var"]}},function(e,t){e.exports={name:"quantileSeq",category:"Statistics",syntax:["quantileSeq(A, prob[, sorted])","quantileSeq(A, [prob1, prob2, ...][, sorted])","quantileSeq(A, N[, sorted])"],description:"Compute the prob order quantile of a matrix or a list with values. The sequence is sorted and the middle value is returned. Supported types of sequence values are: Number, BigNumber, Unit Supported types of probablity are: Number, BigNumber. \n\nIn case of a (multi dimensional) array or matrix, the prob order quantile of all elements will be calculated.",examples:["quantileSeq([3, -1, 5, 7], 0.5)","quantileSeq([3, -1, 5, 7], [1/3, 2/3])","quantileSeq([3, -1, 5, 7], 2)","quantileSeq([-1, 3, 5, 7], 0.5, true)"],seealso:["mean","median","min","max","prod","std","sum","var"]}},function(e,t){e.exports={name:"std",category:"Statistics",syntax:["std(a, b, c, ...)","std(A)","std(A, normalization)"],description:'Compute the standard deviation of all values, defined as std(A) = sqrt(var(A)). Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["std(2, 4, 6)","std([2, 4, 6, 8])",'std([2, 4, 6, 8], "uncorrected")','std([2, 4, 6, 8], "biased")',"std([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","sum","var"]}},function(e,t){e.exports={name:"sum",category:"Statistics",syntax:["sum(a, b, c, ...)","sum(A)"],description:"Compute the sum of all values.",examples:["sum(2, 3, 4, 1)","sum([2, 3, 4, 1])","sum([2, 5; 4, 3])"],seealso:["max","mean","median","min","prod","std","sum","var"]}},function(e,t){e.exports={name:"var",category:"Statistics",syntax:["var(a, b, c, ...)","var(A)","var(A, normalization)"],description:'Compute the variance of all values. Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["var(2, 4, 6)","var([2, 4, 6, 8])",'var([2, 4, 6, 8], "uncorrected")','var([2, 4, 6, 8], "biased")',"var([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","std","sum"]}},function(e,t){e.exports={name:"acos",category:"Trigonometry",syntax:["acos(x)"],description:"Compute the inverse cosine of a value in radians.",examples:["acos(0.5)","acos(cos(2.3))"],seealso:["cos","atan","asin"]}},function(e,t){e.exports={name:"acosh",category:"Trigonometry",syntax:["acosh(x)"],description:"Calculate the hyperbolic arccos of a value, defined as `acosh(x) = ln(sqrt(x^2 - 1) + x)`.",examples:["acosh(1.5)"],seealso:["cosh","asinh","atanh"]}},function(e,t){e.exports={name:"acot",category:"Trigonometry",syntax:["acot(x)"],description:"Calculate the inverse cotangent of a value.",examples:["acot(0.5)","acot(cot(0.5))","acot(2)"],seealso:["cot","atan"]}},function(e,t){e.exports={name:"acoth",category:"Trigonometry",syntax:["acoth(x)"],description:"Calculate the hyperbolic arccotangent of a value, defined as `acoth(x) = (ln((x+1)/x) + ln(x/(x-1))) / 2`.",examples:["acoth(2)","acoth(0.5)"],seealso:["acsch","asech"]}},function(e,t){e.exports={name:"acsc",category:"Trigonometry",syntax:["acsc(x)"],description:"Calculate the inverse cotangent of a value.",examples:["acsc(2)","acsc(csc(0.5))","acsc(0.5)"],seealso:["csc","asin","asec"]}},function(e,t){e.exports={name:"acsch",category:"Trigonometry",syntax:["acsch(x)"],description:"Calculate the hyperbolic arccosecant of a value, defined as `acsch(x) = ln(1/x + sqrt(1/x^2 + 1))`.",examples:["acsch(0.5)"],seealso:["asech","acoth"]}},function(e,t){e.exports={name:"asec",category:"Trigonometry",syntax:["asec(x)"],description:"Calculate the inverse secant of a value.",examples:["asec(0.5)","asec(sec(0.5))","asec(2)"],seealso:["acos","acot","acsc"]}},function(e,t){e.exports={name:"asech",category:"Trigonometry",syntax:["asech(x)"],description:"Calculate the inverse secant of a value.",examples:["asech(0.5)"],seealso:["acsch","acoth"]}},function(e,t){e.exports={name:"asin",category:"Trigonometry",syntax:["asin(x)"],description:"Compute the inverse sine of a value in radians.",examples:["asin(0.5)","asin(sin(0.5))"],seealso:["sin","acos","atan"]}},function(e,t){e.exports={name:"asinh",category:"Trigonometry",syntax:["asinh(x)"],description:"Calculate the hyperbolic arcsine of a value, defined as `asinh(x) = ln(x + sqrt(x^2 + 1))`.",examples:["asinh(0.5)"],seealso:["acosh","atanh"]}},function(e,t){e.exports={name:"atan",category:"Trigonometry",syntax:["atan(x)"],description:"Compute the inverse tangent of a value in radians.",examples:["atan(0.5)","atan(tan(0.5))"],seealso:["tan","acos","asin"]}},function(e,t){e.exports={name:"atanh",category:"Trigonometry",syntax:["atanh(x)"],description:"Calculate the hyperbolic arctangent of a value, defined as `atanh(x) = ln((1 + x)/(1 - x)) / 2`.",examples:["atanh(0.5)"],seealso:["acosh","asinh"]}},function(e,t){e.exports={name:"atan2",category:"Trigonometry",syntax:["atan2(y, x)"],description:"Computes the principal value of the arc tangent of y/x in radians.",examples:["atan2(2, 2) / pi","angle = 60 deg in rad","x = cos(angle)","y = sin(angle)","atan2(y, x)"],seealso:["sin","cos","tan"]}},function(e,t){e.exports={name:"cos",category:"Trigonometry",syntax:["cos(x)"],description:"Compute the cosine of x in radians.",examples:["cos(2)","cos(pi / 4) ^ 2","cos(180 deg)","cos(60 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["acos","sin","tan"]}},function(e,t){e.exports={name:"cosh",category:"Trigonometry",syntax:["cosh(x)"],description:"Compute the hyperbolic cosine of x in radians.",examples:["cosh(0.5)"],seealso:["sinh","tanh","coth"]}},function(e,t){e.exports={name:"cot",category:"Trigonometry",syntax:["cot(x)"],description:"Compute the cotangent of x in radians. Defined as 1/tan(x)",examples:["cot(2)","1 / tan(2)"],seealso:["sec","csc","tan"]}},function(e,t){e.exports={name:"coth",category:"Trigonometry",syntax:["coth(x)"],description:"Compute the hyperbolic cotangent of x in radians.",examples:["coth(2)","1 / tanh(2)"],seealso:["sech","csch","tanh"]}},function(e,t){e.exports={name:"csc",category:"Trigonometry",syntax:["csc(x)"],description:"Compute the cosecant of x in radians. Defined as 1/sin(x)",examples:["csc(2)","1 / sin(2)"],seealso:["sec","cot","sin"]}},function(e,t){e.exports={name:"csch",category:"Trigonometry",syntax:["csch(x)"],description:"Compute the hyperbolic cosecant of x in radians. Defined as 1/sinh(x)",examples:["csch(2)","1 / sinh(2)"],seealso:["sech","coth","sinh"]}},function(e,t){e.exports={name:"sec",category:"Trigonometry",syntax:["sec(x)"],description:"Compute the secant of x in radians. Defined as 1/cos(x)",examples:["sec(2)","1 / cos(2)"],seealso:["cot","csc","cos"]}},function(e,t){e.exports={name:"sech",category:"Trigonometry",syntax:["sech(x)"],description:"Compute the hyperbolic secant of x in radians. Defined as 1/cosh(x)",examples:["sech(2)","1 / cosh(2)"],seealso:["coth","csch","cosh"]}},function(e,t){e.exports={name:"sin",category:"Trigonometry",syntax:["sin(x)"],description:"Compute the sine of x in radians.",examples:["sin(2)","sin(pi / 4) ^ 2","sin(90 deg)","sin(30 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["asin","cos","tan"]}},function(e,t){e.exports={name:"sinh",category:"Trigonometry",syntax:["sinh(x)"],description:"Compute the hyperbolic sine of x in radians.",examples:["sinh(0.5)"],seealso:["cosh","tanh"]}},function(e,t){e.exports={name:"tan",category:"Trigonometry",syntax:["tan(x)"],description:"Compute the tangent of x in radians.",examples:["tan(0.5)","sin(0.5) / cos(0.5)","tan(pi / 4)","tan(45 deg)"],seealso:["atan","sin","cos"]}},function(e,t){e.exports={name:"tanh",category:"Trigonometry",syntax:["tanh(x)"],description:"Compute the hyperbolic tangent of x in radians.",examples:["tanh(0.5)","sinh(0.5) / cosh(0.5)"],seealso:["sinh","cosh"]}},function(e,t){e.exports={name:"to",category:"Units",syntax:["x to unit","to(x, unit)"],description:"Change the unit of a value.",examples:["5 inch to cm","3.2kg to g","16 bytes in bits"],seealso:[]}},function(e,t){e.exports={name:"clone",category:"Utils",syntax:["clone(x)"],description:"Clone a variable. Creates a copy of primitive variables,and a deep copy of matrices",examples:["clone(3.5)","clone(2 - 4i)","clone(45 deg)","clone([1, 2; 3, 4])",'clone("hello world")'],seealso:[]}},function(e,t){e.exports={name:"format",category:"Utils",syntax:["format(value)","format(value, precision)"],description:"Format a value of any type as string.",examples:["format(2.3)","format(3 - 4i)","format([])","format(pi, 3)"],seealso:["print"]}},function(e,t){e.exports={name:"isNaN",category:"Utils",syntax:["isNaN(x)"],description:"Test whether a value is NaN (not a number)",examples:["isNaN(2)","isNaN(0 / 0)","isNaN(NaN)","isNaN(Infinity)"],seealso:["isNegative","isNumeric","isPositive","isZero"]}},function(e,t){e.exports={name:"isInteger",category:"Utils",syntax:["isInteger(x)"],description:"Test whether a value is an integer number.",examples:["isInteger(2)","isInteger(3.5)","isInteger([3, 0.5, -2])"],seealso:["isNegative","isNumeric","isPositive","isZero"]}},function(e,t){e.exports={name:"isNegative",category:"Utils",syntax:["isNegative(x)"],description:"Test whether a value is negative: smaller than zero.",examples:["isNegative(2)","isNegative(0)","isNegative(-4)","isNegative([3, 0.5, -2])"],seealso:["isInteger","isNumeric","isPositive","isZero"]}},function(e,t){e.exports={name:"isNumeric",category:"Utils",syntax:["isNumeric(x)"],description:"Test whether a value is a numeric value. Returns true when the input is a number, BigNumber, Fraction, or boolean.",examples:["isNumeric(2)","isNumeric(0)","isNumeric(bignumber(500))","isNumeric(fraction(0.125))",'isNumeric("3")',"isNumeric(2 + 3i)",'isNumeric([2.3, "foo", false])'],seealso:["isInteger","isZero","isNegative","isPositive","isNaN"]}},function(e,t){e.exports={name:"isPositive",category:"Utils",syntax:["isPositive(x)"],description:"Test whether a value is positive: larger than zero.",examples:["isPositive(2)","isPositive(0)","isPositive(-4)","isPositive([3, 0.5, -2])"],seealso:["isInteger","isNumeric","isNegative","isZero"]}},function(e,t){e.exports={name:"isPrime",category:"Utils",syntax:["isPrime(x)"],description:"Test whether a value is prime: has no divisors other than itself and one.",examples:["isPrime(3)","isPrime(-2)","isPrime([2, 17, 100])"],seealso:["isInteger","isNumeric","isNegative","isZero"]}},function(e,t){e.exports={name:"isZero",category:"Utils",syntax:["isZero(x)"],description:"Test whether a value is zero.",examples:["isZero(2)","isZero(0)","isZero(-4)","isZero([3, 0, -2, 0])"],seealso:["isInteger","isNumeric","isNegative","isPositive"]}},function(e,t){e.exports={name:"typeof",category:"Utils",syntax:["typeof(x)"],description:"Get the type of a variable.",examples:["typeof(3.5)","typeof(2 - 4i)","typeof(45 deg)",'typeof("hello world")'],seealso:[]}},function(e,t,r){e.exports=[r(389),r(391),r(392),r(111),r(112)]},function(e,t,r){"use strict";var n=r(1);t.name="compile",t.factory=function(e,t,i,a){var o=i(r(41));return a("compile",{string:function(e){return o(e).compile()},"Array | Matrix":function(e){return n(e,function(e){return o(e).compile()})}})}},function(e,t,r){"use strict";var n=r(42).transform,i=r(13).setSafeProperty;t.factory=function(e,t,a,o){var s=a(r(23)),u=a(r(0));return function(e,t,r){try{if(Array.isArray(e))return u(e).subset(t,r).valueOf();if(e&&"function"==typeof e.subset)return e.subset(t,r);if("string"==typeof e)return s(e,t,r);if("object"==typeof e){if(!t.isObjectProperty())throw TypeError("Cannot apply a numeric index as object property");return i(e,t.getObjectProperty(),r),e}throw new TypeError("Cannot apply index: unsupported type of object")}catch(e){throw n(e)}}}},function(e,t,r){"use strict";var n=r(1);t.name="eval",t.factory=function(e,t,i,a){var o=i(r(41));return a("compile",{string:function(e){return o(e).compile().eval({})},"string, Object":function(e,t){return o(e).compile().eval(t)},"Array | Matrix":function(e){var t={};return n(e,function(e){return o(e).compile().eval(t)})},"Array | Matrix, Object":function(e,t){return n(e,function(e){return o(e).compile().eval(t)})}})}},function(e,t,r){"use strict";var n=r(13).getSafeProperty;t.math=!0,t.name="help",t.factory=function(e,t,i,a,o){var s=i(r(100));return a("help",{any:function(t){var r,i=t;if("string"!=typeof t)for(r in o)if(o.hasOwnProperty(r)&&t===o[r]){i=r;break}var a=n(s,i);if(!a)throw new Error('No documentation found on "'+i+'"');return new e.Help(a)}})}},function(e,t,r){e.exports=[r(103),r(80),r(105),r(106),r(107),r(47),r(78),r(108),r(56),r(15),r(110),r(55),r(63),r(79),r(36),r(394)]},function(e,t,r){"use strict";t.name="UpdateNode",t.path="expression.node",t.factory=function(e,t,r,n){return function(){throw new Error("UpdateNode is deprecated. Use AssignmentNode instead.")}}},function(e,t,r){e.exports=[r(396),r(397),r(398),r(399),r(400),r(401),r(402),r(403),r(404),r(405)]},function(e,t,r){"use strict";var n=r(42).transform;t.name="concat",t.path="expression.transform",t.factory=function(e,t,i,a){var o=i(r(64));return a("concat",{"...any":function(t){var r=t.length-1,i=t[r];e.isNumber(i)?t[r]=i-1:e.isBigNumber(i)&&(t[r]=i.minus(1));try{return o.apply(null,t)}catch(e){throw n(e)}}})}},function(e,t,r){"use strict";var n=r(2).filter,i=r(2).filterRegExp,a=r(32).maxArgumentCount;function o(e,t){var r=a(t);return n(e,function(e,n,i){return 1===r?t(e):2===r?t(e,[n+1]):t(e,[n+1],i)})}t.name="filter",t.path="expression.transform",t.factory=function(e,t,n,a){var s=n(r(81)),u=n(r(0));function c(t,r,n){var i,a;return t[0]&&(i=t[0].compile().eval(n)),t[1]&&(a=e.isSymbolNode(t[1])||e.isFunctionAssignmentNode(t[1])?t[1].compile().eval(n):s(t[1],r,n)),f(i,a)}c.rawArgs=!0;var f=a("filter",{"Array, function":o,"Matrix, function":function(e,t){return u(o(e.toArray(),t))},"Array, RegExp":i,"Matrix, RegExp":function(e,t){return u(i(e.toArray(),t))}});return f.toTex=void 0,c}},function(e,t,r){"use strict";var n=r(32).maxArgumentCount,i=r(2).forEach;t.name="forEach",t.path="expression.transform",t.factory=function(e,t,a,o){var s=a(r(81));function u(t,r,n){var i,a;return t[0]&&(i=t[0].compile().eval(n)),t[1]&&(a=e.isSymbolNode(t[1])||e.isFunctionAssignmentNode(t[1])?t[1].compile().eval(n):s(t[1],r,n)),c(i,a)}u.rawArgs=!0;var c=o("forEach",{"Array | Matrix, function":function(e,t){var r=n(t),a=function(n,o){Array.isArray(n)?i(n,function(e,t){a(e,o.concat(t+1))}):1===r?t(n):2===r?t(n,o):t(n,o,e)};a(e.valueOf(),[])}});return u}},function(e,t,r){"use strict";t.name="index",t.path="expression.transform",t.factory=function(e,t,r){return function(){for(var t=[],r=0,n=arguments.length;r<n;r++){var i=arguments[r];if(e.isRange(i))i.start--,i.end-=i.step>0?0:2;else if(i&&!0===i.isSet)i=i.map(function(e){return e-1});else if(e.isArray(i)||e.isMatrix(i))i=i.map(function(e){return e-1});else if(e.isNumber(i))i--;else if(e.isBigNumber(i))i=i.toNumber()-1;else if("string"!=typeof i)throw new TypeError("Dimension must be an Array, Matrix, number, string, or Range");t[r]=i}var a=new e.Index;return e.Index.apply(a,t),a}}},function(e,t,r){"use strict";var n=r(32).maxArgumentCount,i=r(2).map;function a(e,t,r){var a=n(t);return function e(n,o){return Array.isArray(n)?i(n,function(t,r){return e(t,o.concat(r+1))}):1===a?t(n):2===a?t(n,o):t(n,o,r)}(e,[])}t.name="map",t.path="expression.transform",t.factory=function(e,t,n,i){var o=n(r(81)),s=n(r(0));function u(t,r,n){var i,a;return t[0]&&(i=t[0].compile().eval(n)),t[1]&&(a=e.isSymbolNode(t[1])||e.isFunctionAssignmentNode(t[1])?t[1].compile().eval(n):o(t[1],r,n)),c(i,a)}u.rawArgs=!0;var c=i("map",{"Array, function":function(e,t){return a(e,t,e)},"Matrix, function":function(e,t){return s(a(e.valueOf(),t,e))}});return u}},function(e,t,r){"use strict";var n=r(42).transform,i=r(48);t.name="max",t.path="expression.transform",t.factory=function(e,t,a,o){var s=a(r(114));return o("max",{"...any":function(t){if(2==t.length&&i(t[0])){var r=t[1];e.isNumber(r)?t[1]=r-1:e.isBigNumber(r)&&(t[1]=r.minus(1))}try{return s.apply(null,t)}catch(e){throw n(e)}}})}},function(e,t,r){"use strict";var n=r(42).transform,i=r(48);t.name="mean",t.path="expression.transform",t.factory=function(e,t,a,o){var s=a(r(115));return o("mean",{"...any":function(t){if(2==t.length&&i(t[0])){var r=t[1];e.isNumber(r)?t[1]=r-1:e.isBigNumber(r)&&(t[1]=r.minus(1))}try{return s.apply(null,t)}catch(e){throw n(e)}}})}},function(e,t,r){"use strict";var n=r(42).transform,i=r(48);t.name="min",t.path="expression.transform",t.factory=function(e,t,a,o){var s=a(r(118));return o("min",{"...any":function(t){if(2==t.length&&i(t[0])){var r=t[1];e.isNumber(r)?t[1]=r-1:e.isBigNumber(r)&&(t[1]=r.minus(1))}try{return s.apply(null,t)}catch(e){throw n(e)}}})}},function(e,t,r){"use strict";t.name="range",t.path="expression.transform",t.factory=function(e,t,n,i){var a=n(r(119));return i("range",{"...any":function(e){return"boolean"!=typeof e[e.length-1]&&e.push(!0),a.apply(null,e)}})}},function(e,t,r){"use strict";var n=r(42).transform;t.name="subset",t.path="expression.transform",t.factory=function(e,t,i,a){var o=i(r(23));return a("subset",{"...any":function(e){try{return o.apply(null,e)}catch(e){throw n(e)}}})}},function(e,t,r){"use strict";var n=r(5),i=r(9);t.name="Help",t.path="type",t.factory=function(e,t,a,o){var s=a(r(112))();function u(e){if(!(this instanceof u))throw new SyntaxError("Constructor must be called with the new operator");if(!e)throw new Error('Argument "doc" missing');this.doc=e}return u.prototype.type="Help",u.prototype.isHelp=!0,u.prototype.toString=function(){var t=this.doc||{},r="\n";if(t.name&&(r+="Name: "+t.name+"\n\n"),t.category&&(r+="Category: "+t.category+"\n\n"),t.description&&(r+="Description:\n    "+t.description+"\n\n"),t.syntax&&(r+="Syntax:\n    "+t.syntax.join("\n    ")+"\n\n"),t.examples){r+="Examples:\n";for(var n=0;n<t.examples.length;n++){var a,o=t.examples[n];r+="    "+o+"\n";try{a=s.eval(o)}catch(e){a=e}void 0===a||e.isHelp(a)||(r+="        "+i.format(a,{precision:14})+"\n")}r+="\n"}return t.seealso&&t.seealso.length&&(r+="See also: "+t.seealso.join(", ")+"\n"),r},u.prototype.toJSON=function(){var e=n.clone(this.doc);return e.mathjs="Help",e},u.fromJSON=function(e){var t={};for(var r in e)"mathjs"!==r&&(t[r]=e[r]);return new u(t)},u.prototype.valueOf=u.prototype.toString,u}},function(e,t,r){e.exports=[r(408),r(428),r(447),r(460),r(464),r(468),r(471),r(475),r(488),r(498),r(501),r(509),r(511),r(517),r(519),r(544),r(546)]},function(e,t,r){e.exports=[r(409),r(82),r(411),r(412),r(127),r(128),r(133),r(426),r(134)]},function(e,t,r){"use strict";t.name="derivative",t.factory=function(e,t,n,i){var a=n(r(41)),o=n(r(82)),s=n(r(47)),u=n(r(56)),c=n(r(55)),f=n(r(63)),l=n(r(36)),p=i("derivative",{"Node, SymbolNode, Object":function(e,t,r){var n={};m(n,e,t.name);var i=d(e,n);return r.simplify?o(i):i},"Node, SymbolNode":function(e,t){return p(e,t,{simplify:!0})},"string, SymbolNode":function(e,t){return p(a(e),t)},"string, SymbolNode, Object":function(e,t,r){return p(a(e),t,r)},"string, string":function(e,t){return p(a(e),a(t))},"string, string, Object":function(e,t,r){return p(a(e),a(t),r)},"Node, string":function(e,t){return p(e,a(t))},"Node, string, Object":function(e,t,r){return p(e,a(t),r)}});p._simplify=!0,p.toTex=function(e){return h.apply(null,e.args)};var h=i("_derivTex",{"Node, SymbolNode":function(e,t){return h(e.toString(),t.toString(),1)},"Node, SymbolNode, ConstantNode":function(e,t,r){return h(e.toString(),t.name,r.value)},"string, string, number":function(e,t,r){return(1===r?"{d\\over d"+t+"}":"{d^{"+r+"}\\over d"+t+"^{"+r+"}}")+"\\left["+e+"\\right]"}}),m=i("constTag",{"Object, ConstantNode, string":function(e,t){return e[t]=!0},"Object, SymbolNode, string":function(e,t,r){return t.name!=r&&(e[t]=!0)},"Object, ParenthesisNode, string":function(e,t,r){return m(e,t.content,r)},"Object, FunctionAssignmentNode, string":function(e,t,r){return-1==t.params.indexOf(r)?e[t]=!0:m(e,t.expr,r)},"Object, FunctionNode | OperatorNode, string":function(e,t,r){if(0!=t.args.length){for(var n=m(e,t.args[0],r),i=1;i<t.args.length;++i)n=m(e,t.args[i],r)&&n;if(n)return e[t]=!0}return!1}}),d=i("_derivative",{"ConstantNode, Object":function(e){return new s("0",e.valueType)},"SymbolNode, Object":function(e,r){return void 0!==r[e]?new s("0",t.number):new s("1",t.number)},"ParenthesisNode, Object":function(e,t){return new f(d(e.content,t))},"FunctionAssignmentNode, Object":function(e,r){return void 0!==r[e]?new s("0",t.number):d(e.expr,r)},"FunctionNode, Object":function(e,r){if(1!=e.args.length&&function(e){if("log"!=e.name&&"nthRoot"!=e.name||2!=e.args.length){for(var t=0;t<e.args.length;++t)e.args[t]=new s(0);throw e.compile().eval(),new Error("Expected TypeError, but none found")}}(e),void 0!==r[e])return new s("0",t.number);var n,i,a,o,f=e.args[0],p=!1,h=!1;switch(e.name){case"cbrt":p=!0,i=new c("*","multiply",[new s("3",t.number),new c("^","pow",[f,new c("/","divide",[new s("2",t.number),new s("3",t.number)])])]);break;case"sqrt":case"nthRoot":if(1==e.args.length){p=!0,i=new c("*","multiply",[new s("2",t.number),new u("sqrt",[f])]);break}return r[n=new c("/","divide",[new s("1",t.number),e.args[1]])]=r[e.args[1]],d(new c("^","pow",[f,n]),r);case"log10":n=new s("10",t.number);case"log":if(n||1!=e.args.length){if(!n&&void 0===r[e.args[1]])return d(new c("/","divide",[new u("log",[f]),new u("log",[e.args[1]])]),r);i=new c("*","multiply",[f.clone(),new u("log",[n||e.args[1]])])}else i=f.clone();p=!0;break;case"exp":i=new u("exp",[f.clone()]);break;case"sin":i=new u("cos",[f.clone()]);break;case"cos":i=new c("-","unaryMinus",[new u("sin",[f.clone()])]);break;case"tan":i=new c("^","pow",[new u("sec",[f.clone()]),new s("2",t.number)]);break;case"sec":i=new c("*","multiply",[e,new u("tan",[f.clone()])]);break;case"csc":h=!0,i=new c("*","multiply",[e,new u("cot",[f.clone()])]);break;case"cot":h=!0,i=new c("^","pow",[new u("csc",[f.clone()]),new s("2",t.number)]);break;case"asin":p=!0,i=new u("sqrt",[new c("-","subtract",[new s("1",t.number),new c("^","pow",[f.clone(),new s("2",t.number)])])]);break;case"acos":p=!0,h=!0,i=new u("sqrt",[new c("-","subtract",[new s("1",t.number),new c("^","pow",[f.clone(),new s("2",t.number)])])]);break;case"atan":p=!0,i=new c("+","add",[new c("^","pow",[f.clone(),new s("2",t.number)]),new s("1",t.number)]);break;case"asec":p=!0,i=new c("*","multiply",[new u("abs",[f.clone()]),new u("sqrt",[new c("-","subtract",[new c("^","pow",[f.clone(),new s("2",t.number)]),new s("1",t.number)])])]);break;case"acsc":p=!0,h=!0,i=new c("*","multiply",[new u("abs",[f.clone()]),new u("sqrt",[new c("-","subtract",[new c("^","pow",[f.clone(),new s("2",t.number)]),new s("1",t.number)])])]);break;case"acot":p=!0,h=!0,i=new c("+","add",[new c("^","pow",[f.clone(),new s("2",t.number)]),new s("1",t.number)]);break;case"sinh":i=new u("cosh",[f.clone()]);break;case"cosh":i=new u("sinh",[f.clone()]);break;case"tanh":i=new c("^","pow",[new u("sech",[f.clone()]),new s("2",t.number)]);break;case"sech":h=!0,i=new c("*","multiply",[e,new u("tanh",[f.clone()])]);break;case"csch":h=!0,i=new c("*","multiply",[e,new u("coth",[f.clone()])]);break;case"coth":h=!0,i=new c("^","pow",[new u("csch",[f.clone()]),new s("2",t.number)]);break;case"asinh":p=!0,i=new u("sqrt",[new c("+","add",[new c("^","pow",[f.clone(),new s("2",t.number)]),new s("1",t.number)])]);break;case"acosh":p=!0,i=new u("sqrt",[new c("-","subtract",[new c("^","pow",[f.clone(),new s("2",t.number)]),new s("1",t.number)])]);break;case"atanh":p=!0,i=new c("-","subtract",[new s("1",t.number),new c("^","pow",[f.clone(),new s("2",t.number)])]);break;case"asech":p=!0,h=!0,i=new c("*","multiply",[f.clone(),new u("sqrt",[new c("-","subtract",[new s("1",t.number),new c("^","pow",[f.clone(),new s("2",t.number)])])])]);break;case"acsch":p=!0,h=!0,i=new c("*","multiply",[new u("abs",[f.clone()]),new u("sqrt",[new c("+","add",[new c("^","pow",[f.clone(),new s("2",t.number)]),new s("1",t.number)])])]);break;case"acoth":p=!0,h=!0,i=new c("-","subtract",[new s("1",t.number),new c("^","pow",[f.clone(),new s("2",t.number)])]);break;case"abs":i=new c("/","divide",[new u(new l("abs"),[f.clone()]),f.clone()]);break;case"gamma":default:throw new Error('Function "'+e.name+'" not supported by derivative')}p?(a="/",o="divide"):(a="*",o="multiply");var m=d(f,r);return h&&(m=new c("-","unaryMinus",[m])),new c(a,o,[m,i])},"OperatorNode, Object":function(r,n){if(void 0!==n[r])return new s("0",t.number);var i=r.args[0],a=r.args[1];switch(r.op){case"+":return new c(r.op,r.fn,r.args.map(function(e){return d(e,n)}));case"-":return 1==r.args.length?new c(r.op,r.fn,[d(i,n)]):new c(r.op,r.fn,[d(i,n),d(a,n)]);case"*":var o=r.args.filter(function(e){return void 0!==n[e]});if(o.length>0){var f=r.args.filter(function(e){return void 0===n[e]}),l=1===f.length?f[0]:new c("*","multiply",f),p=o.concat(d(l,n));return new c("*","multiply",p)}return new c("+","add",r.args.map(function(e){return new c("*","multiply",r.args.map(function(t){return t===e?d(t,n):t.clone()}))}));case"/":return void 0!==n[a]?new c("/","divide",[d(i,n),a]):void 0!==n[i]?new c("*","multiply",[new c("-","unaryMinus",[i]),new c("/","divide",[d(a,n),new c("^","pow",[a.clone(),new s("2",t.number)])])]):new c("/","divide",[new c("-","subtract",[new c("*","multiply",[d(i,n),a.clone()]),new c("*","multiply",[i.clone(),d(a,n)])]),new c("^","pow",[a.clone(),new s("2",t.number)])]);case"^":if(void 0!==n[i])return!e.isConstantNode(i)||"0"!==i.value&&"1"!==i.value?new c("*","multiply",[r,new c("*","multiply",[new u("log",[i.clone()]),d(a.clone(),n)])]):new s("0",t.number);if(void 0!==n[a]){if(e.isConstantNode(a)){var h=a.value;if("0"===h)return new s("0",t.number);if("1"===h)return d(i,n)}var m=new c("^","pow",[i.clone(),new c("-","subtract",[a,new s("1",t.number)])]);return new c("*","multiply",[a.clone(),new c("*","multiply",[d(i,n),m])])}return new c("*","multiply",[new c("^","pow",[i.clone(),a.clone()]),new c("+","add",[new c("*","multiply",[d(i,n),new c("/","divide",[a.clone(),i.clone()])]),new c("*","multiply",[d(a,n),new u("log",[i.clone()])])])]);case"%":case"mod":default:throw new Error('Operator "'+r.op+'" not supported by derivative')}}});return p}},function(e,t,r){"use strict";t.math=!0,t.name="resolve",t.path="algebra.simplify",t.factory=function(e,t,r,n,i){var a=i.expression.node.Node,o=i.expression.node.OperatorNode,s=i.expression.node.FunctionNode,u=i.expression.node.ParenthesisNode;return function t(r,n){if(!n)return r;if(e.isSymbolNode(r)){var c=n[r.name];if(c instanceof a)return t(c,n);if("number"==typeof c)return i.parse(String(c))}else{if(e.isOperatorNode(r)){var f=r.args.map(function(e){return t(e,n)});return new o(r.op,r.fn,f)}if(e.isParenthesisNode(r))return new u(t(r.content,n));if(e.isFunctionNode(r))return f=r.args.map(function(e){return t(e,n)}),new s(r.name,f)}return r}}},function(e,t,r){"use strict";t.name="rationalize",t.factory=function(e,t,n,i){var a=n(r(82)),o=n(r(122)),s=n(r(120)),u=r(44),c=n(r(111)),f=r(3),l=n(r(47)),p=n(r(55)),h=n(r(36)),m=i("rationalize",{string:function(e){return m(c(e),{},!1)},"string, boolean":function(e,t){return m(c(e),{},t)},"string, Object":function(e,t){return m(c(e),t,!1)},"string, Object, boolean":function(e,t,r){return m(c(e),t,r)},Node:function(e){return m(e,{},!1)},"Node, boolean":function(e,t){return m(e,{},t)},"Node, Object":function(e,t){return m(e,t,!1)},"Node, Object, boolean":function(e,t,r){var n,i,c,h,m=function(e,t,r){var n=[],i=a(e,t),o="+-*"+((r=!!r)?"/":"");!function e(t){var r=t.type;if("FunctionNode"===r)throw new u("There is an unsolved function call");if("OperatorNode"===r)if("^"===t.op){if("ConstantNode"!==t.args[1].type||!f.isInteger(parseFloat(t.args[1].value)))throw new u("There is a non-integer exponent");e(t.args[0])}else{if(-1===o.indexOf(t.op))throw new u("Operator "+t.op+" invalid in polynomial expression");for(var i=0;i<t.args.length;i++)e(t.args[i])}else if("SymbolNode"===r){var a=t.name,s=n.indexOf(a);-1===s&&n.push(a)}else if("ParenthesisNode"===r)e(t.content);else if("ConstantNode"!==r)throw new u("type "+r+" is not allowed in polynomial expression")}(i);var s={};return s.expression=i,s.variables=n,s}(e,t,!0),g=m.variables.length;if(e=m.expression,g>=1){var v=((h={}).firstRules=(n=[o,{l:"n+n",r:"2*n"},{l:"n+-n",r:"0"},s,{l:"n*(n1^-1)",r:"n/n1"},{l:"n*n1^-n2",r:"n/n1^n2"},{l:"n1^-1",r:"1/n1"},{l:"n*(n1/n2)",r:"(n*n1)/n2"},{l:"1*n",r:"n"}]).concat(i=[{l:"(-n1)/(-n2)",r:"n1/n2"},{l:"(-n1)*(-n2)",r:"n1*n2"},{l:"n1--n2",r:"n1+n2"},{l:"n1-n2",r:"n1+(-n2)"},{l:"(n1+n2)*n3",r:"(n1*n3 + n2*n3)"},{l:"n1*(n2+n3)",r:"(n1*n2+n1*n3)"},{l:"c1*n + c2*n",r:"(c1+c2)*n"},{l:"-v*-c",r:"c*v"},{l:"-v*c",r:"-c*v"},{l:"v*-c",r:"-c*v"},{l:"v*c",r:"c*v"},{l:"-(-n1*n2)",r:"(n1*n2)"},{l:"-(n1*n2)",r:"(-n1*n2)"},{l:"-(-n1+n2)",r:"(n1-n2)"},{l:"-(n1+n2)",r:"(-n1-n2)"},{l:"(n1^n2)^n3",r:"(n1^(n2*n3))"},{l:"-(-n1/n2)",r:"(n1/n2)"},{l:"-(n1/n2)",r:"(-n1/n2)"}],c=[{l:"(n1/(n2/n3))",r:"((n1*n3)/n2)"},{l:"(n1/n2/n3)",r:"(n1/(n2*n3))"}]),h.distrDivRules=[{l:"(n1/n2 + n3/n4)",r:"((n1*n4 + n3*n2)/(n2*n4))"},{l:"(n1/n2 + n3)",r:"((n1 + n3*n2)/n2)"},{l:"(n1 + n2/n3)",r:"((n1*n3 + n2)/n3)"}],h.sucDivRules=c,h.firstRulesAgain=n.concat(i),h.finalRules=[o,{l:"n*-n",r:"-n^2"},{l:"n*n",r:"n^2"},s,{l:"n*-n^n1",r:"-n^(n1+1)"},{l:"n*n^n1",r:"n^(n1+1)"},{l:"n^n1*-n^n2",r:"-n^(n1+n2)"},{l:"n^n1*n^n2",r:"n^(n1+n2)"},{l:"n^n1*-n",r:"-n^(n1+1)"},{l:"n^n1*n",r:"n^(n1+1)"},{l:"n^n1/-n",r:"-n^(n1-1)"},{l:"n^n1/n",r:"n^(n1-1)"},{l:"n/-n^n1",r:"-n^(1-n1)"},{l:"n/n^n1",r:"n^(1-n1)"},{l:"n^n1/-n^n2",r:"n^(n1-n2)"},{l:"n^n1/n^n2",r:"n^(n1-n2)"},{l:"n1+(-n2*n3)",r:"n1-n2*n3"},{l:"v*(-c)",r:"-c*v"},{l:"n1+-n2",r:"n1-n2"},{l:"v*c",r:"c*v"},{l:"(n1^n2)^n3",r:"(n1^(n2*n3))"}],h);e=function e(t,r,n){var i=t.type,a=arguments.length>1;if("OperatorNode"===i){var o=!1;if("^"===t.op&&("ParenthesisNode"===t.args[0].type||"OperatorNode"===t.args[0].type)&&"ConstantNode"===t.args[1].type){var s=parseFloat(t.args[1].value);o=s>=2&&f.isInteger(s)}if(o){if(s>2){var u=t.args[0],c=new p("^","pow",[t.args[0].cloneDeep(),new l(s-1)]);t=new p("*","multiply",[u,c])}else t=new p("*","multiply",[t.args[0],t.args[0].cloneDeep()]);a&&("content"===n?r.content=t:r.args[n]=t)}}if("ParenthesisNode"===i)e(t.content,t,"content");else if("ConstantNode"!==i&&"SymbolNode"!==i)for(var h=0;h<t.args.length;h++)e(t.args[h],t,h);if(!a)return t}(e);var y,x,w=!0,b="",N=!0;for(b=(e=a(e,v.firstRules)).toString();x=N?v.distrDivRules:v.sucDivRules,N=!N,(b=(e=a(e,x)).toString())!==y;)w=!0,y=b;w&&(e=a(e,v.firstRulesAgain)),e=a(e,v.finalRules)}var E=[],M={};return"OperatorNode"===e.type&&"/"===e.op?(1==g&&(e.args[0]=d(e.args[0],E),e.args[1]=d(e.args[1])),r&&(M.numerator=e.args[0],M.denominator=e.args[1])):(1==g&&(e=d(e,E)),r&&(M.numerator=e,M.denominator=null)),r?(M.coefficients=E,M.variables=m.variables,M.expression=e,M):e}});function d(e,t){var r;void 0===t&&(t=[]),t[0]=0;var n={cte:1,oper:"+",fire:""},i=0,a="";!function e(r,n,o){var s=r.type;if("FunctionNode"===s)throw new u("There is an unsolved function call");if("OperatorNode"===s){if(-1==="+-*^".indexOf(r.op))throw new u("Operator "+r.op+" invalid");if(null!==n){if(("unaryMinus"===r.fn||"pow"===r.fn)&&"add"!==n.fn&&"subtract"!==n.fn&&"multiply"!==n.fn)throw new u("Invalid "+r.op+" placing");if(("subtract"===r.fn||"add"===r.fn||"multiply"===r.fn)&&"add"!==n.fn&&"subtract"!==n.fn)throw new u("Invalid "+r.op+" placing");if(("subtract"===r.fn||"add"===r.fn||"unaryMinus"===r.fn)&&0!==o.noFil)throw new u("Invalid "+r.op+" placing")}"^"!==r.op&&"*"!==r.op||(o.fire=r.op);for(var c=0;c<r.args.length;c++)"unaryMinus"===r.fn&&(o.oper="-"),"+"!==r.op&&"subtract"!==r.fn||(o.fire="",o.cte=1,o.oper=0===c?"+":r.op),o.noFil=c,e(r.args[c],r,o)}else if("SymbolNode"===s){if(r.name!==a&&""!==a)throw new u("There is more than one variable");if(a=r.name,null===n)return void(t[1]=1);if("^"===n.op&&0!==o.noFil)throw new u("In power the variable should be the first parameter");if("*"===n.op&&1!==o.noFil)throw new u("In multiply the variable should be the second parameter");""!==o.fire&&"*"!==o.fire||(i<1&&(t[1]=0),t[1]+=o.cte*("+"===o.oper?1:-1),i=Math.max(1,i))}else{if("ConstantNode"!==s)throw new u("Type "+s+" is not allowed");var l=parseFloat(r.value);if(null===n)return void(t[0]=l);if("^"===n.op){if(1!==o.noFil)throw new u("Constant cannot be powered");if(!f.isInteger(l)||l<=0)throw new u("Non-integer exponent is not allowed");for(var c=i+1;c<l;c++)t[c]=0;return l>i&&(t[l]=0),t[l]+=o.cte*("+"===o.oper?1:-1),void(i=Math.max(l,i))}o.cte=l,""===o.fire&&(t[0]+=o.cte*("+"===o.oper?1:-1))}}(e,null,n);var o=!0;for(r=i=t.length-1;r>=0;r--)if(0!==t[r]){var s,c=new l(o?t[r]:Math.abs(t[r])),m=t[r]<0?"-":"+";if(r>0){var d=new h(a);if(r>1){var g=new l(r);d=new p("^","pow",[d,g])}c=-1===t[r]&&o?new p("-","unaryMinus",[d]):1===Math.abs(t[r])?d:new p("*","multiply",[c,d])}s=o?c:"+"===m?new p("+","add",[s,c]):new p("-","subtract",[s,c]),o=!1}return o?new l(0):s}return m}},function(e,t,r){"use strict";t.name="qr",t.factory=function(e,t,n,i){var a=n(r(0)),o=n(r(40)),s=n(r(62)),u=(n(r(123)),n(r(83))),c=(n(r(57)),n(r(124))),f=(n(r(28)),n(r(125))),l=n(r(50)),p=n(r(126)),h=n(r(35)),m=n(r(16)),d=n(r(14)),g=n(r(22)),v=n(r(21)),y=i("qr",{DenseMatrix:function(e){return x(e)},SparseMatrix:function(e){return w(e)},Array:function(e){var t=a(e),r=x(t);return{Q:r.Q.valueOf(),R:r.R.valueOf()}}}),x=function(e){var t,r,n,i=e._size[0],a=e._size[1],y=s([i],"dense"),x=y._data,w=e.clone(),b=w._data,N=o([i],"");for(n=0;n<Math.min(a,i);++n){var E=b[n][n],M=h(f(E)),A=p(M),O=0;for(t=n;t<i;t++)O=m(O,g(b[t][n],p(b[t][n])));var T=g(M,l(O));if(!u(T)){var S=v(E,T);for(N[n]=1,t=n+1;t<i;t++)N[t]=d(b[t][n],S);var _,C=h(p(d(S,T)));for(r=n;r<a;r++){for(_=0,t=n;t<i;t++)_=m(_,g(p(N[t]),b[t][r]));for(_=g(_,C),t=n;t<i;t++)b[t][r]=g(v(b[t][r],g(N[t],_)),A)}for(t=0;t<i;t++){for(_=0,r=n;r<i;r++)_=m(_,g(x[t][r],N[r]));for(_=g(_,C),r=n;r<i;++r)x[t][r]=d(v(x[t][r],g(_,p(N[r]))),A)}}}for(t=0;t<i;++t)for(r=0;r<t&&r<a;++r){if(c(0,d(b[t][r],1e5)))throw new Error("math.qr(): unknown error - R is not lower triangular (element ("+t+", "+r+")  = "+b[t][r]+")");b[t][r]=g(b[t][r],0)}return{Q:y,R:w,toString:function(){return"Q: "+this.Q.toString()+"\nR: "+this.R.toString()}}},w=function(e){throw new Error("qr not implemented for sparse matrices yet")};return y}},function(e,t,r){"use strict";t.name="cs_sqr",t.path="sparse",t.factory=function(e,t,n){var i=n(r(414)),a=n(r(416)),o=n(r(417)),s=n(r(418)),u=n(r(419)),c=function(e,t){var r=e._ptr,n=e._index,i=e._size,a=i[0],o=i[1];t.pinv=[],t.leftmost=[];var s,u,c,f,l,p=t.parent,h=t.pinv,m=t.leftmost,d=[],g=a,v=a+o,y=a+2*o;for(u=0;u<o;u++)d[g+u]=-1,d[v+u]=-1,d[y+u]=0;for(s=0;s<a;s++)m[s]=-1;for(u=o-1;u>=0;u--)for(f=r[u],l=r[u+1],c=f;c<l;c++)m[n[c]]=u;for(s=a-1;s>=0;s--)h[s]=-1,-1!=(u=m[s])&&(0==d[y+u]++&&(d[v+u]=s),d[0+s]=d[g+u],d[g+u]=s);for(t.lnz=0,t.m2=a,u=0;u<o;u++)if(s=d[g+u],t.lnz++,s<0&&(s=t.m2++),h[s]=u,!(--y[u]<=0)){t.lnz+=d[y+u];var x=p[u];-1!=x&&(0===d[y+x]&&(d[v+x]=d[v+u]),d[0+d[v+u]]=d[g+x],d[g+x]=d[0+s],d[y+x]+=d[y+u])}for(s=0;s<a;s++)h[s]<0&&(h[s]=u++);return!0};return function(e,t,r){var n,f=t._ptr,l=t._size[1],p={};if(p.q=i(e,t),e&&!p.q)return null;if(r){var h=e?a(t,null,p.q,0):t;p.parent=o(h,1);var m=s(p.parent,l);if(p.cp=u(h,p.parent,m,1),h&&p.parent&&p.cp&&c(h,p))for(p.unz=0,n=0;n<l;n++)p.unz+=p.cp[n]}else p.unz=4*f[l]+l,p.lnz=p.unz;return p}}},function(e,t,r){"use strict";t.name="cs_amd",t.path="sparse",t.factory=function(e,t,n){var i=n(r(84)),a=n(r(415)),o=n(r(129)),s=n(r(20)),u=n(r(12)),c=n(r(67)),f=function(e,t,r,n,i){var a=c(t);if(1===e&&n===r)return s(t,a);if(2==e){for(var o=a._index,f=a._ptr,l=0,p=0;p<r;p++){var h=f[p];if(f[p]=l,!(f[p+1]-h>i))for(var m=f[p+1];h<m;h++)o[l++]=o[h]}return f[r]=l,t=c(a),u(a,t)}return u(a,t)},l=function(e,t,r,n,i,a,o,s,u,c,f,l){for(var p=0;p<e;p++)r[n+p]=t[p+1]-t[p];r[n+e]=0;for(var m=0;m<=e;m++)r[i+m]=-1,a[m]=-1,r[o+m]=-1,r[s+m]=-1,r[u+m]=1,r[c+m]=1,r[f+m]=0,r[l+m]=r[n+m];var d=h(0,0,r,c,e);return r[f+e]=-2,t[e]=-1,r[c+e]=0,d},p=function(e,t,r,n,a,o,s,u,c,f,l){for(var p=0,h=0;h<e;h++){var m=r[n+h];if(0===m)r[a+h]=-2,p++,t[h]=-1,r[o+h]=0;else if(m>s)r[u+h]=0,r[a+h]=-1,p++,t[h]=i(e),r[u+e]++;else{var d=r[c+m];-1!=d&&(f[d]=h),r[l+h]=r[c+m],r[c+m]=h}}return p},h=function(e,t,r,n,i){if(e<2||e+t<0){for(var a=0;a<i;a++)0!==r[n+a]&&(r[n+a]=1);e=2}return e},m=function(e,t){return e!=t};return function(e,t){if(!t||e<=0||e>3)return null;var r=t._size,n=r[0],s=r[1],u=0,c=Math.max(16,10*Math.sqrt(s));c=Math.min(s-2,c);var d=f(e,t,n,s,c);a(d,m,null);for(var g,v,y,x,w,b,N,E,M,A,O,T,S,_,C,z,k=d._index,B=d._ptr,I=B[s],P=[],R=[],U=s+1,q=2*(s+1),L=3*(s+1),j=4*(s+1),F=5*(s+1),D=6*(s+1),H=7*(s+1),$=P,G=l(s,B,R,0,L,$,q,H,U,D,j,F),Z=p(s,B,R,F,j,D,c,U,L,$,q),V=0;Z<s;){for(y=-1;V<s&&-1==(y=R[L+V]);V++);-1!=R[q+y]&&($[R[q+y]]=-1),R[L+V]=R[q+y];var W=R[j+y],Y=R[U+y];Z+=Y;var X=0;R[U+y]=-Y;var J=B[y],Q=0===W?J:I,K=Q;for(x=1;x<=W+1;x++){for(x>W?(b=y,N=J,E=R[0+y]-W):(N=B[b=k[J++]],E=R[0+b]),w=1;w<=E;w++)(M=R[U+(g=k[N++])])<=0||(X+=M,R[U+g]=-M,k[K++]=g,-1!=R[q+g]&&($[R[q+g]]=$[g]),-1!=$[g]?R[q+$[g]]=R[q+g]:R[L+R[F+g]]=R[q+g]);b!=y&&(B[b]=i(y),R[D+b]=0)}for(0!==W&&(I=K),R[F+y]=X,B[y]=Q,R[0+y]=K-Q,R[j+y]=-2,G=h(G,u,R,D,s),A=Q;A<K;A++)if(!((O=R[j+(g=k[A])])<=0)){var ee=G-(M=-R[U+g]);for(J=B[g],T=B[g]+O-1;J<=T;J++)R[D+(b=k[J])]>=G?R[D+b]-=M:0!==R[D+b]&&(R[D+b]=R[F+b]+ee)}for(A=Q;A<K;A++){for(S=(T=B[g=k[A]])+R[j+g]-1,_=T,C=0,z=0,J=T;J<=S;J++)if(0!==R[D+(b=k[J])]){var te=R[D+b]-G;te>0?(z+=te,k[_++]=b,C+=b):(B[b]=i(y),R[D+b]=0)}R[j+g]=_-T+1;var re=_,ne=T+R[0+g];for(J=S+1;J<ne;J++){var ie=R[U+(v=k[J])];ie<=0||(z+=ie,k[_++]=v,C+=v)}0===z?(B[g]=i(y),X-=M=-R[U+g],Y+=M,Z+=M,R[U+g]=0,R[j+g]=-1):(R[F+g]=Math.min(R[F+g],z),k[_]=k[re],k[re]=k[T],k[T]=y,R[0+g]=_-T+1,C=(C<0?-C:C)%s,R[q+g]=R[H+C],R[H+C]=g,$[g]=C)}for(R[F+y]=X,u=Math.max(u,X),G=h(G+u,u,R,D,s),A=Q;A<K;A++)if(!(R[U+(g=k[A])]>=0))for(g=R[H+(C=$[g])],R[H+C]=-1;-1!=g&&-1!=R[q+g];g=R[q+g],G++){for(E=R[0+g],O=R[j+g],J=B[g]+1;J<=B[g]+E-1;J++)R[D+k[J]]=G;var ae=g;for(v=R[q+g];-1!=v;){var oe=R[0+v]===E&&R[j+v]===O;for(J=B[v]+1;oe&&J<=B[v]+E-1;J++)R[D+k[J]]!=G&&(oe=0);oe?(B[v]=i(g),R[U+g]+=R[U+v],R[U+v]=0,R[j+v]=-1,v=R[q+v],R[q+ae]=v):(ae=v,v=R[q+v])}}for(J=Q,A=Q;A<K;A++)(M=-R[U+(g=k[A])])<=0||(R[U+g]=M,z=R[F+g]+X-M,-1!=R[L+(z=Math.min(z,s-Z-M))]&&($[R[L+z]]=g),R[q+g]=R[L+z],$[g]=-1,R[L+z]=g,V=Math.min(V,z),R[F+g]=z,k[J++]=g);R[U+y]=Y,0==(R[0+y]=J-Q)&&(B[y]=-1,R[D+y]=0),0!==W&&(I=J)}for(g=0;g<s;g++)B[g]=i(B[g]);for(v=0;v<=s;v++)R[L+v]=-1;for(v=s;v>=0;v--)R[U+v]>0||(R[q+v]=R[L+B[v]],R[L+B[v]]=v);for(b=s;b>=0;b--)R[U+b]<=0||-1!=B[b]&&(R[q+b]=R[L+B[b]],R[L+B[b]]=b);for(y=0,g=0;g<=s;g++)-1==B[g]&&(y=o(g,y,R,L,q,P,D));return P.splice(P.length-1,1),P}}},function(e,t,r){"use strict";t.name="cs_fkeep",t.path="sparse",t.factory=function(){return function(e,t,r){for(var n=e._values,i=e._index,a=e._ptr,o=e._size[1],s=0,u=0;u<o;u++){var c=a[u];for(a[u]=s;c<a[u+1];c++)t(i[c],u,n?n[c]:1,r)&&(i[s]=i[c],n&&(n[s]=n[c]),s++)}return a[o]=s,i.splice(s,i.length-s),n&&n.splice(s,n.length-s),s}}},function(e,t,r){"use strict";t.name="cs_permute",t.path="sparse",t.factory=function(e){var t=e.SparseMatrix;return function(e,r,n,i){for(var a=e._values,o=e._index,s=e._ptr,u=e._size,c=e._datatype,f=u[0],l=u[1],p=i&&e._values?[]:null,h=[],m=[],d=0,g=0;g<l;g++){m[g]=d;for(var v=n?n[g]:g,y=s[v],x=s[v+1],w=y;w<x;w++){var b=r?r[o[w]]:o[w];h[d]=b,p&&(p[d]=a[w]),d++}}return m[l]=d,new t({values:p,index:h,ptr:m,size:[f,l],datatype:c})}}},function(e,t,r){"use strict";t.name="cs_etree",t.path="sparse",t.factory=function(){return function(e,t){if(!e)return null;var r,n,i=e._index,a=e._ptr,o=e._size,s=o[0],u=o[1],c=[],f=[],l=u;if(t)for(r=0;r<s;r++)f[l+r]=-1;for(var p=0;p<u;p++){c[p]=-1,f[0+p]=-1;for(var h=a[p],m=a[p+1],d=h;d<m;d++){var g=i[d];for(r=t?f[l+g]:g;-1!=r&&r<p;r=n)n=f[0+r],f[0+r]=p,-1==n&&(c[r]=p);t&&(f[l+g]=p)}}return c}}},function(e,t,r){"use strict";t.name="cs_post",t.path="sparse",t.factory=function(e,t,n){var i=n(r(129));return function(e,t){if(!e)return null;var r,n=0,a=[],o=[],s=t,u=2*t;for(r=0;r<t;r++)o[0+r]=-1;for(r=t-1;r>=0;r--)-1!=e[r]&&(o[s+r]=o[0+e[r]],o[0+e[r]]=r);for(r=0;r<t;r++)-1==e[r]&&(n=i(r,n,o,0,s,a,u));return a}}},function(e,t,r){"use strict";t.name="cs_counts",t.path="sparse",t.factory=function(e,t,n){var i=n(r(67)),a=n(r(420));return function(e,t,r,n){if(!e||!t||!r)return null;var o,s,u,c,f,l,p,h=e._size,m=h[0],d=h[1],g=4*d+(n?d+m+1:0),v=[],y=d,x=2*d,w=3*d,b=4*d,N=5*d+1;for(u=0;u<g;u++)v[u]=-1;var E=[],M=i(e),A=M._index,O=M._ptr;for(u=0;u<d;u++)for(E[s=r[u]]=-1==v[w+s]?1:0;-1!=s&&-1==v[w+s];s=t[s])v[w+s]=u;if(n){for(u=0;u<d;u++)v[r[u]]=u;for(o=0;o<m;o++){for(u=d,l=O[o],p=O[o+1],f=l;f<p;f++)u=Math.min(u,v[A[f]]);v[N+o]=v[b+u],v[b+u]=o}}for(o=0;o<d;o++)v[0+o]=o;for(u=0;u<d;u++){for(-1!=t[s=r[u]]&&E[t[s]]--,c=n?v[b+u]:s;-1!=c;c=n?v[N+c]:-1)for(f=O[c];f<O[c+1];f++){o=A[f];var T=a(o,s,v,w,y,x,0);T.jleaf>=1&&E[s]++,2==T.jleaf&&E[T.q]--}-1!=t[s]&&(v[0+s]=t[s])}for(s=0;s<d;s++)-1!=t[s]&&(E[t[s]]+=E[s]);return E}}},function(e,t,r){"use strict";t.name="cs_leaf",t.path="sparse",t.factory=function(){return function(e,t,r,n,i,a,o){var s,u,c,f,l=0;if(e<=t||r[n+t]<=r[i+e])return-1;if(r[i+e]=r[n+t],c=r[a+e],r[a+e]=t,-1===c)l=1,f=e;else{for(l=2,f=c;f!=r[o+f];f=r[o+f]);for(s=c;s!=f;s=u)u=r[o+s],r[o+s]=f}return{jleaf:l,q:f}}}},function(e,t,r){"use strict";t.name="cs_lu",t.path="sparse",t.factory=function(e,t,n){var i=n(r(28)),a=n(r(14)),o=n(r(12)),s=n(r(34)),u=n(r(130)),c=n(r(422)),f=e.SparseMatrix;return function(e,t,r){if(!e)return null;var n,l=e._size[1],p=100,h=100;t&&(n=t.q,p=t.lnz||p,h=t.unz||h);var m,d,g=[],v=[],y=[],x=new f({values:g,index:v,ptr:y,size:[l,l]}),w=[],b=[],N=[],E=new f({values:w,index:b,ptr:N,size:[l,l]}),M=[],A=[],O=[];for(m=0;m<l;m++)A[m]=0,M[m]=-1,y[m+1]=0;p=0,h=0;for(var T=0;T<l;T++){y[T]=p,N[T]=h;var S=n?n[T]:T,_=c(x,e,S,O,A,M,1),C=-1,z=-1;for(d=_;d<l;d++)if(M[m=O[d]]<0){var k=i(A[m]);s(k,z)&&(z=k,C=m)}else b[h]=M[m],w[h++]=A[m];if(-1==C||z<=0)return null;M[S]<0&&u(i(A[S]),o(z,r))&&(C=S);var B=A[C];for(b[h]=T,w[h++]=B,M[C]=T,v[p]=C,g[p++]=1,d=_;d<l;d++)M[m=O[d]]<0&&(v[p]=m,g[p++]=a(A[m],B)),A[m]=0}for(y[l]=p,N[l]=h,d=0;d<p;d++)v[d]=M[v[d]];return g.splice(p,g.length-p),v.splice(p,v.length-p),w.splice(h,w.length-h),b.splice(h,b.length-h),{L:x,U:E,pinv:M}}}},function(e,t,r){"use strict";t.name="cs_spsolve",t.path="sparse",t.factory=function(e,t,n){var i=n(r(14)),a=n(r(12)),o=n(r(21)),s=n(r(423));return function(e,t,r,n,u,c,f){var l,p,h,m,d=e._values,g=e._index,v=e._ptr,y=e._size[1],x=t._values,w=t._index,b=t._ptr,N=s(e,t,r,n,c);for(l=N;l<y;l++)u[n[l]]=0;for(p=b[r],h=b[r+1],l=p;l<h;l++)u[w[l]]=x[l];for(var E=N;E<y;E++){var M=n[E],A=c?c[M]:M;if(!(A<0))for(p=v[A],h=v[A+1],u[M]=i(u[M],d[f?p:h-1]),l=f?p+1:p,m=f?h:h-1;l<m;l++){var O=g[l];u[O]=o(u[O],a(d[l],u[M]))}}return N}}},function(e,t,r){"use strict";t.name="cs_reach",t.path="sparse",t.factory=function(e,t,n){var i=n(r(424)),a=n(r(131)),o=n(r(132));return function(e,t,r,n,s){var u,c,f,l=e._ptr,p=e._size,h=t._index,m=t._ptr,d=p[1],g=d;for(c=m[r],f=m[r+1],u=c;u<f;u++){var v=h[u];a(l,v)||(g=i(v,e,g,n,s))}for(u=g;u<d;u++)o(l,n[u]);return g}}},function(e,t,r){"use strict";t.name="cs_dfs",t.path="sparse",t.factory=function(e,t,n){var i=n(r(131)),a=n(r(132)),o=n(r(425));return function(e,t,r,n,s){var u,c,f,l=t._index,p=t._ptr,h=t._size[1],m=0;for(n[0]=e;m>=0;){e=n[m];var d=s?s[e]:e;i(p,e)||(a(p,e),n[h+m]=d<0?0:o(p[d]));var g=1;for(c=n[h+m],f=d<0?0:o(p[d+1]);c<f;c++)if(u=l[c],!i(p,u)){n[h+m]=c,n[++m]=u,g=0;break}g&&(m--,n[--r]=e)}return r}}},function(e,t,r){"use strict";t.name="cs_unflip",t.path="sparse",t.factory=function(e,t,n){var i=n(r(84));return function(e){return e<0?i(e):e}}},function(e,t,r){"use strict";var n=Array.isArray;t.name="lusolve",t.factory=function(e,t,i,a){var o=i(r(0)),s=i(r(127)),u=i(r(128)),c=i(r(427)),f=i(r(85)),l=i(r(134)),p=i(r(133)),h=a("lusolve",{"Array, Array | Matrix":function(e,t){e=o(e);var r=s(e);return d(r.L,r.U,r.p,null,t).valueOf()},"DenseMatrix, Array | Matrix":function(e,t){var r=s(e);return d(r.L,r.U,r.p,null,t)},"SparseMatrix, Array | Matrix":function(e,t){var r=s(e);return d(r.L,r.U,r.p,null,t)},"SparseMatrix, Array | Matrix, number, number":function(e,t,r,n){var i=u(e,r,n);return d(i.L,i.U,i.p,i.q,t)},"Object, Array | Matrix":function(e,t){return d(e.L,e.U,e.p,e.q,t)}}),m=function(t){if(e.isMatrix(t))return t;if(n(t))return o(t);throw new TypeError("Invalid Matrix LU decomposition")},d=function(e,t,r,n,i){e=m(e),t=m(t),i=f(e,i,!1),r&&(i._data=c(r,i._data));var a=p(e,i),o=l(t,a);return n&&(o._data=c(n,o._data)),o};return h}},function(e,t,r){"use strict";t.name="cs_ipvec",t.path="sparse",t.factory=function(){return function(e,t,r){r=t.length;var n,i=[];if(e)for(n=0;n<r;n++)i[e[n]]=t[n];else for(n=0;n<r;n++)i[n]=t[n];return i}}},function(e,t,r){e.exports=[r(28),r(20),r(16),r(429),r(430),r(431),r(49),r(135),r(432),r(433),r(434),r(97),r(435),r(436),r(437),r(438),r(137),r(440),r(441),r(12),r(442),r(443),r(46),r(98),r(125),r(50),r(444),r(21),r(35),r(445),r(446)]},function(e,t,r){"use strict";var n=r(1);var i=Math.cbrt||function(e){if(0===e)return e;var t,r=e<0;return r&&(e=-e),t=isFinite(e)?(e/((t=Math.exp(Math.log(e)/3))*t)+2*t)/3:e,r?-t:t};t.name="cbrt",t.factory=function(e,t,a,o){var s=a(r(35)),u=a(r(58)),c=a(r(0)),f=o("cbrt",{number:i,Complex:l,"Complex, boolean":l,BigNumber:function(e){return e.cbrt()},Unit:function(t){if(t.value&&e.isComplex(t.value)){var r=t.clone();return r.value=1,(r=r.pow(1/3)).value=l(t.value),r}var n,i=u(t.value);i&&(t.value=s(t.value)),n=e.isBigNumber(t.value)?new e.BigNumber(1).div(3):e.isFraction(t.value)?new e.Fraction(1,3):1/3;var r=t.pow(n);return i&&(r.value=s(r.value)),r},"Array | Matrix":function(e){return n(e,f,!0)}});function l(r,n){var a=r.arg()/3,o=r.abs(),s=new e.Complex(i(o),0).mul(new e.Complex(0,a).exp());if(n){var u=[s,new e.Complex(i(o),0).mul(new e.Complex(0,a+2*Math.PI/3).exp()),new e.Complex(i(o),0).mul(new e.Complex(0,a-2*Math.PI/3).exp())];return"Array"===t.matrix?u:c(u)}return s}return f.toTex={1:"\\sqrt[3]{${args[0]}}"},f}},function(e,t,r){"use strict";var n=r(1);t.name="ceil",t.factory=function(e,t,r,i){var a=i("ceil",{number:Math.ceil,Complex:function(e){return e.ceil()},BigNumber:function(e){return e.ceil()},Fraction:function(e){return e.ceil()},"Array | Matrix":function(e){return n(e,a,!0)}});return a.toTex={1:"\\left\\lceil${args[0]}\\right\\rceil"},a}},function(e,t,r){"use strict";var n=r(1);t.name="cube",t.factory=function(e,t,r,i){var a=i("cube",{number:function(e){return e*e*e},Complex:function(e){return e.mul(e).mul(e)},BigNumber:function(e){return e.times(e).times(e)},Fraction:function(e){return e.pow(3)},"Array | Matrix":function(e){return n(e,a,!0)},Unit:function(e){return e.pow(3)}});return a.toTex={1:"\\left(${args[0]}\\right)^3"},a}},function(e,t,r){"use strict";t.name="dotMultiply",t.factory=function(e,t,n,i){var a=n(r(0)),o=n(r(22)),s=r(4),u=n(r(24)),c=n(r(136)),f=n(r(19)),l=n(r(8)),p=n(r(6)),h=i("dotMultiply",{"any, any":o,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,o,!1);break;default:r=u(t,e,o,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,o,!1);break;default:r=l(e,t,o)}}return r},"Array, Array":function(e,t){return h(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return h(a(e),t)},"Matrix, Array":function(e,t){return h(e,a(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,o,!1);break;default:r=p(e,t,o,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,o,!0);break;default:r=p(t,e,o,!0)}return r},"Array, any":function(e,t){return p(a(e),t,o,!1).valueOf()},"any, Array":function(e,t){return p(a(t),e,o,!0).valueOf()}});return h.toTex={2:"\\left(${args[0]}"+s.operators.dotMultiply+"${args[1]}\\right)"},h}},function(e,t,r){"use strict";t.name="dotPow",t.factory=function(e,t,n,i){var a=n(r(0)),o=n(r(46)),s=r(4),u=n(r(17)),c=n(r(26)),f=n(r(19)),l=n(r(18)),p=n(r(8)),h=n(r(6)),m=i("dotPow",{"any, any":o,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,o,!1);break;default:r=u(t,e,o,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,o,!1);break;default:r=p(e,t,o)}}return r},"Array, Array":function(e,t){return m(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return m(a(e),t)},"Matrix, Array":function(e,t){return m(e,a(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, any":function(e,t){return h(a(e),t,m,!1).valueOf()},"any, Array":function(e,t){return h(a(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+s.operators.dotPow+"${args[1]}\\right)"},m}},function(e,t,r){"use strict";var n=r(1);t.name="exp",t.factory=function(e,t,r,i){var a=i("exp",{number:Math.exp,Complex:function(e){return e.exp()},BigNumber:function(e){return e.exp()},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\exp\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);t.name="floor",t.factory=function(e,t,r,i){var a=i("floor",{number:Math.floor,Complex:function(e){return e.floor()},BigNumber:function(e){return e.floor()},Fraction:function(e){return e.floor()},"Array | Matrix":function(e){return n(e,a,!0)}});return a.toTex={1:"\\left\\lfloor${args[0]}\\right\\rfloor"},a}},function(e,t,r){"use strict";var n=r(3).isInteger;function i(e,t){if(!n(e)||!n(t))throw new Error("Parameters in function gcd must be integer numbers");for(var r;0!=t;)r=e%t,e=t,t=r;return e<0?-e:e}t.name="gcd",t.factory=function(e,t,n,a){var o=n(r(0)),s=n(r(33)),u=n(r(73)),c=n(r(38)),f=n(r(8)),l=n(r(6)),p=a("gcd",{"number, number":i,"BigNumber, BigNumber":function(t,r){if(!t.isInt()||!r.isInt())throw new Error("Parameters in function gcd must be integer numbers");for(var n=new e.BigNumber(0);!r.isZero();){var i=t.mod(r);t=r,r=i}return t.lt(n)?t.neg():t},"Fraction, Fraction":function(e,t){return e.gcd(t)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=u(e,t,p);break;default:r=s(t,e,p,!0)}break;default:switch(t.storage()){case"sparse":r=s(e,t,p,!1);break;default:r=f(e,t,p)}}return r},"Array, Array":function(e,t){return p(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return p(o(e),t)},"Matrix, Array":function(e,t){return p(e,o(t))},"Matrix, number | BigNumber":function(e,t){var r;switch(e.storage()){case"sparse":r=c(e,t,p,!1);break;default:r=l(e,t,p,!1)}return r},"number | BigNumber, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=c(t,e,p,!0);break;default:r=l(t,e,p,!0)}return r},"Array, number | BigNumber":function(e,t){return l(o(e),t,p,!1).valueOf()},"number | BigNumber, Array":function(e,t){return l(o(t),e,p,!0).valueOf()},"Array | Matrix | number | BigNumber, Array | Matrix | number | BigNumber, ...Array | Matrix | number | BigNumber":function(e,t,r){for(var n=p(e,t),i=0;i<r.length;i++)n=p(n,r[i]);return n}});return p.toTex="\\gcd\\left(${args}\\right)",p}},function(e,t,r){"use strict";var n=r(2).flatten;t.name="hypot",t.factory=function(e,t,i,a){var o=i(r(28)),s=i(r(16)),u=i(r(14)),c=i(r(22)),f=i(r(50)),l=i(r(39)),p=i(r(57)),h=a("hypot",{"... number | BigNumber":function(e){for(var t=0,r=0,n=0;n<e.length;n++){var i=o(e[n]);l(r,i)?(t=c(t,c(u(r,i),u(r,i))),t=s(t,1),r=i):t=s(t,p(i)?c(u(i,r),u(i,r)):i)}return c(r,f(t))},Array:function(e){return h.apply(h,n(e))},Matrix:function(e){return h.apply(h,n(e.toArray()))}});return h.toTex="\\hypot\\left(${args}\\right)",h}},function(e,t,r){"use strict";var n=r(3).isInteger;function i(e,t){if(!n(e)||!n(t))throw new Error("Parameters in function lcm must be integer numbers");if(0==e||0==t)return 0;for(var r,i=e*t;0!=t;)t=e%(r=t),e=r;return Math.abs(i/e)}t.name="lcm",t.factory=function(e,t,n,a){var o=n(r(0)),s=n(r(24)),u=n(r(68)),c=n(r(19)),f=n(r(8)),l=n(r(6)),p=a("lcm",{"number, number":i,"BigNumber, BigNumber":function(t,r){if(!t.isInt()||!r.isInt())throw new Error("Parameters in function lcm must be integer numbers");if(t.isZero()||r.isZero())return new e.BigNumber(0);for(var n=t.times(r);!r.isZero();){var i=r;r=t.mod(i),t=i}return n.div(t).abs()},"Fraction, Fraction":function(e,t){return e.lcm(t)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=u(e,t,p);break;default:r=s(t,e,p,!0)}break;default:switch(t.storage()){case"sparse":r=s(e,t,p,!1);break;default:r=f(e,t,p)}}return r},"Array, Array":function(e,t){return p(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return p(o(e),t)},"Matrix, Array":function(e,t){return p(e,o(t))},"Matrix, number | BigNumber":function(e,t){var r;switch(e.storage()){case"sparse":r=c(e,t,p,!1);break;default:r=l(e,t,p,!1)}return r},"number | BigNumber, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=c(t,e,p,!0);break;default:r=l(t,e,p,!0)}return r},"Array, number | BigNumber":function(e,t){return l(o(e),t,p,!1).valueOf()},"number | BigNumber, Array":function(e,t){return l(o(t),e,p,!0).valueOf()},"Array | Matrix | number | BigNumber, Array | Matrix | number | BigNumber, ...Array | Matrix | number | BigNumber":function(e,t,r){for(var n=p(e,t),i=0;i<r.length;i++)n=p(n,r[i]);return n}});return p.toTex=void 0,p}},function(e,t,r){"use strict";e.exports=function(e,t,r,n,i,a,o,s,u,c,f){var l,p,h,m,d=e._values,g=e._index,v=e._ptr,y=o._index;if(n)for(p=v[t],h=v[t+1],l=p;l<h;l++)r[m=g[l]]!==a?(r[m]=a,y.push(m),c?(n[m]=u?s(d[l],f):s(f,d[l]),i[m]=a):n[m]=d[l]):(n[m]=u?s(d[l],n[m]):s(n[m],d[l]),i[m]=a);else for(p=v[t],h=v[t+1],l=p;l<h;l++)r[m=g[l]]!==a?(r[m]=a,y.push(m)):i[m]=a}},function(e,t,r){"use strict";var n=r(1);var i=Math.log10||function(e){return Math.log(e)/Math.LN10};t.name="log10",t.factory=function(e,t,r,a){var o=a("log10",{number:function(r){return r>=0||t.predictable?i(r):new e.Complex(r,0).log().div(Math.LN10)},Complex:function(t){return new e.Complex(t).log().div(Math.LN10)},BigNumber:function(r){return!r.isNegative()||t.predictable?r.log():new e.Complex(r.toNumber(),0).log().div(Math.LN10)},"Array | Matrix":function(e){return n(e,o)}});return o.toTex={1:"\\log_{10}\\left(${args[0]}\\right)"},o}},function(e,t,r){"use strict";t.name="mod",t.factory=function(e,t,n,i){var a=n(r(0)),o=r(4),s=n(r(24)),u=n(r(17)),c=n(r(61)),f=n(r(19)),l=n(r(18)),p=n(r(8)),h=n(r(6)),m=i("mod",{"number, number":function(e,t){if(t>0)return e-t*Math.floor(e/t);if(0===t)return e;throw new Error("Cannot calculate mod for a negative divisor")},"BigNumber, BigNumber":function(e,t){return t.isZero()?e:e.mod(t)},"Fraction, Fraction":function(e,t){return e.mod(t)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,m,!1);break;default:r=s(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,m,!1);break;default:r=p(e,t,m)}}return r},"Array, Array":function(e,t){return m(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return m(a(e),t)},"Matrix, Array":function(e,t){return m(e,a(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, any":function(e,t){return h(a(e),t,m,!1).valueOf()},"any, Array":function(e,t){return h(a(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+o.operators.mod+"${args[1]}\\right)"},m}},function(e,t,r){"use strict";t.name="norm",t.factory=function(e,t,n,i){var a=n(r(28)),o=n(r(20)),s=n(r(46)),u=n(r(50)),c=n(r(12)),f=n(r(10)),l=n(r(34)),p=n(r(39)),h=n(r(0)),m=n(r(138)),d=n(r(67)),g=i("norm",{number:Math.abs,Complex:function(e){return e.abs()},BigNumber:function(e){return e.abs()},"boolean | null":function(e){return Math.abs(e)},Array:function(e){return v(h(e),2)},Matrix:function(e){return v(e,2)},"number | Complex | BigNumber | boolean | null, number | BigNumber | string":function(e){return g(e)},"Array, number | BigNumber | string":function(e,t){return v(h(e),t)},"Matrix, number | BigNumber | string":function(e,t){return v(e,t)}});function v(e,t){var r=e.size();if(1==r.length){if(t===Number.POSITIVE_INFINITY||"inf"===t){var n=0;return e.forEach(function(e){var t=a(e);l(t,n)&&(n=t)},!0),n}var i;if(t===Number.NEGATIVE_INFINITY||"-inf"===t)return e.forEach(function(e){var t=a(e);i&&!p(t,i)||(i=t)},!0),i||0;if("fro"===t)return v(e,2);if("number"==typeof t&&!isNaN(t)){if(!f(t,0)){var h=0;return e.forEach(function(e){h=o(s(a(e),t),h)},!0),s(h,1/t)}return Number.POSITIVE_INFINITY}throw new Error("Unsupported parameter value")}if(2==r.length){if(1===t){var g=[],y=0;return e.forEach(function(e,t){var r=t[1],n=o(g[r]||0,a(e));l(n,y)&&(y=n),g[r]=n},!0),y}if(t===Number.POSITIVE_INFINITY||"inf"===t){var x=[],w=0;return e.forEach(function(e,t){var r=t[0],n=o(x[r]||0,a(e));l(n,w)&&(w=n),x[r]=n},!0),w}if("fro"===t)return u(m(c(d(e),e)));if(2===t)throw new Error("Unsupported parameter value, missing implementation of matrix singular value decomposition");throw new Error("Unsupported parameter value")}}return g.toTex={1:"\\left\\|${args[0]}\\right\\|",2:void 0},g}},function(e,t,r){"use strict";function n(e,t){var r=t<0;if(r&&(t=-t),0===t)throw new Error("Root must be non-zero");if(e<0&&Math.abs(t)%2!=1)throw new Error("Root must be odd when a is negative.");if(0==e)return r?1/0:0;if(!isFinite(e))return r?0:e;var n=Math.pow(Math.abs(e),1/t);return n=e<0?-n:n,r?1/n:n}function i(e,t){if(t<0)throw new Error("Root must be greater than zero");if(0===t)throw new Error("Root must be non-zero");if(t%1!=0)throw new Error("Root must be an integer");for(var r=e.arg(),n=e.abs(),i=[],a=Math.pow(n,1/t),o=0;o<t;o++)i.push({r:a,phi:(r+2*Math.PI*o)/t});return i}t.name="nthRoot",t.factory=function(e,t,a,o){var s=a(r(0)),u=a(r(33)),c=a(r(24)),f=a(r(68)),l=a(r(19)),p=a(r(8)),h=a(r(6)),m=o("nthRoot",{number:function(e){return n(e,2)},"number, number":n,BigNumber:function(t){return d(t,new e.BigNumber(2))},Complex:function(e){return i(e,2)},"Complex, number":i,"BigNumber, BigNumber":d,"Array | Matrix":function(e){return m(e,2)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":if(1!==t.density())throw new Error("Root must be non-zero");r=f(e,t,m);break;default:r=c(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":if(1!==t.density())throw new Error("Root must be non-zero");r=u(e,t,m,!1);break;default:r=p(e,t,m)}}return r},"Array, Array":function(e,t){return m(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return m(s(e),t)},"Matrix, Array":function(e,t){return m(e,s(t))},"Matrix, number | BigNumber":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"number | BigNumber, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":if(1!==t.density())throw new Error("Root must be non-zero");r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, number | BigNumber":function(e,t){return m(s(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return m(e,s(t)).valueOf()}});return m.toTex={2:"\\sqrt[${args[1]}]{${args[0]}}"},m;function d(t,r){var n=e.BigNumber.precision,i=e.BigNumber.clone({precision:n+2}),a=new e.BigNumber(0),o=new i(1),s=r.isNegative();if(s&&(r=r.neg()),r.isZero())throw new Error("Root must be non-zero");if(t.isNegative()&&!r.abs().mod(2).equals(1))throw new Error("Root must be odd when a is negative.");if(t.isZero())return s?new i(1/0):0;if(!t.isFinite())return s?a:t;var u=t.abs().pow(o.div(r));return u=t.isNeg()?u.neg():u,new e.BigNumber((s?o.div(u):u).toPrecision(n))}}},function(e,t,r){"use strict";var n=r(1);t.name="square",t.factory=function(e,t,r,i){var a=i("square",{number:function(e){return e*e},Complex:function(e){return e.mul(e)},BigNumber:function(e){return e.times(e)},Fraction:function(e){return e.mul(e)},"Array | Matrix":function(e){return n(e,a,!0)},Unit:function(e){return e.pow(2)}});return a.toTex={1:"\\left(${args[0]}\\right)^2"},a}},function(e,t,r){"use strict";var n=r(1);t.name="unaryPlus",t.factory=function(e,t,i,a){var o=r(4),s=a("unaryPlus",{number:function(e){return e},Complex:function(e){return e},BigNumber:function(e){return e},Fraction:function(e){return e},Unit:function(e){return e.clone()},"Array | Matrix":function(e){return n(e,s,!0)},"boolean | string | null":function(r){return"BigNumber"==t.number?new e.BigNumber(+r):+r}});return s.toTex={1:o.operators.unaryPlus+"\\left(${args[0]}\\right)"},s}},function(e,t,r){"use strict";var n=r(3).isInteger;t.name="xgcd",t.factory=function(e,t,i,a){var o=i(r(0)),s=a("xgcd",{"number, number":function(e,r){var i,a,s,u,c=0,f=1,l=1,p=0;if(!n(e)||!n(r))throw new Error("Parameters in function xgcd must be integer numbers");for(;r;)a=Math.floor(e/r),s=e-a*r,i=c,c=f-a*c,f=i,i=l,l=p-a*l,p=i,e=r,r=s;return u=e<0?[-e,-f,-p]:[e,e?f:0,p],"Array"===t.matrix?u:o(u)},"BigNumber, BigNumber":function(r,n){var i,a,s,u,c=new e.BigNumber(0),f=new e.BigNumber(1),l=c,p=f,h=f,m=c;if(!r.isInt()||!n.isInt())throw new Error("Parameters in function xgcd must be integer numbers");for(;!n.isZero();)a=r.div(n).floor(),s=r.mod(n),i=l,l=p.minus(a.times(l)),p=i,i=h,h=m.minus(a.times(h)),m=i,r=n,n=s;return u=r.lt(c)?[r.neg(),p.neg(),m.neg()]:[r,r.isZero()?0:p,m],"Array"===t.matrix?u:o(u)}});return s.toTex=void 0,s}},function(e,t,r){e.exports=[r(448),r(450),r(451),r(453),r(455),r(457),r(459)]},function(e,t,r){"use strict";var n=r(3).isInteger,i=r(449);t.name="bitAnd",t.factory=function(e,t,a,o){var s=r(4),u=a(r(0)),c=a(r(24)),f=a(r(68)),l=a(r(19)),p=a(r(8)),h=a(r(6)),m=o("bitAnd",{"number, number":function(e,t){if(!n(e)||!n(t))throw new Error("Integers expected in function bitAnd");return e&t},"BigNumber, BigNumber":i,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=c(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,m,!1);break;default:r=p(e,t,m)}}return r},"Array, Array":function(e,t){return m(u(e),u(t)).valueOf()},"Array, Matrix":function(e,t){return m(u(e),t)},"Matrix, Array":function(e,t){return m(e,u(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, any":function(e,t){return h(u(e),t,m,!1).valueOf()},"any, Array":function(e,t){return h(u(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+s.operators.bitAnd+"${args[1]}\\right)"},m}},function(e,t,r){var n=r(86);e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitAnd");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);if(e.isZero()||t.eq(-1)||e.eq(t))return e;if(t.isZero()||e.eq(-1))return t;if(!e.isFinite()||!t.isFinite()){if(!e.isFinite()&&!t.isFinite())return e.isNegative()==t.isNegative()?e:new r(0);if(!e.isFinite())return t.isNegative()?e:e.isNegative()?new r(0):t;if(!t.isFinite())return e.isNegative()?t:t.isNegative()?new r(0):e}return n(e,t,function(e,t){return e&t})}},function(e,t,r){"use strict";var n=r(1),i=r(87),a=r(3).isInteger;t.name="bitNot",t.factory=function(e,t,o,s){var u=r(4),c=s("bitNot",{number:function(e){if(!a(e))throw new Error("Integer expected in function bitNot");return~e},BigNumber:i,"Array | Matrix":function(e){return n(e,c)}});return c.toTex={1:u.operators.bitNot+"\\left(${args[0]}\\right)"},c}},function(e,t,r){"use strict";var n=r(3).isInteger,i=r(452);t.name="bitOr",t.factory=function(e,t,a,o){var s=r(4),u=a(r(0)),c=a(r(33)),f=a(r(73)),l=a(r(38)),p=a(r(8)),h=a(r(6)),m=o("bitOr",{"number, number":function(e,t){if(!n(e)||!n(t))throw new Error("Integers expected in function bitOr");return e|t},"BigNumber, BigNumber":i,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,m);break;default:r=c(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,m,!1);break;default:r=p(e,t,m)}}return r},"Array, Array":function(e,t){return m(u(e),u(t)).valueOf()},"Array, Matrix":function(e,t){return m(u(e),t)},"Matrix, Array":function(e,t){return m(e,u(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, any":function(e,t){return h(u(e),t,m,!1).valueOf()},"any, Array":function(e,t){return h(u(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+s.operators.bitOr+"${args[1]}\\right)"},m}},function(e,t,r){var n=r(86);e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitOr");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);var i=new r(-1);return e.isZero()||t.eq(i)||e.eq(t)?t:t.isZero()||e.eq(i)?e:e.isFinite()&&t.isFinite()?n(e,t,function(e,t){return e|t}):!e.isFinite()&&!e.isNegative()&&t.isNegative()||e.isNegative()&&!t.isNegative()&&!t.isFinite()?i:e.isNegative()&&t.isNegative()?e.isFinite()?e:t:e.isFinite()?t:e}},function(e,t,r){"use strict";var n=r(3).isInteger,i=r(454);t.name="bitXor",t.factory=function(e,t,a,o){var s=r(4),u=a(r(0)),c=a(r(17)),f=a(r(26)),l=a(r(18)),p=a(r(8)),h=a(r(6)),m=o("bitXor",{"number, number":function(e,t){if(!n(e)||!n(t))throw new Error("Integers expected in function bitXor");return e^t},"BigNumber, BigNumber":i,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,m);break;default:r=c(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,m,!1);break;default:r=p(e,t,m)}}return r},"Array, Array":function(e,t){return m(u(e),u(t)).valueOf()},"Array, Matrix":function(e,t){return m(u(e),t)},"Matrix, Array":function(e,t){return m(e,u(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, any":function(e,t){return h(u(e),t,m,!1).valueOf()},"any, Array":function(e,t){return h(u(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+s.operators.bitXor+"${args[1]}\\right)"},m}},function(e,t,r){var n=r(86),i=r(87);e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitXor");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);if(e.isZero())return t;if(t.isZero())return e;if(e.eq(t))return new r(0);var a=new r(-1);return e.eq(a)?i(t):t.eq(a)?i(e):e.isFinite()&&t.isFinite()?n(e,t,function(e,t){return e^t}):e.isFinite()||t.isFinite()?new r(e.isNegative()==t.isNegative()?1/0:-1/0):a}},function(e,t,r){"use strict";var n=r(3).isInteger,i=r(456);t.name="leftShift",t.factory=function(e,t,a,o){var s=r(4),u=a(r(0)),c=a(r(10)),f=a(r(40)),l=a(r(33)),p=a(r(24)),h=a(r(88)),m=a(r(38)),d=a(r(19)),g=a(r(8)),v=a(r(6)),y=o("leftShift",{"number, number":function(e,t){if(!n(e)||!n(t))throw new Error("Integers expected in function leftShift");return e<<t},"BigNumber, BigNumber":i,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=h(e,t,y,!1);break;default:r=p(t,e,y,!0)}break;default:switch(t.storage()){case"sparse":r=l(e,t,y,!1);break;default:r=g(e,t,y)}}return r},"Array, Array":function(e,t){return y(u(e),u(t)).valueOf()},"Array, Matrix":function(e,t){return y(u(e),t)},"Matrix, Array":function(e,t){return y(e,u(t))},"Matrix, number | BigNumber":function(e,t){if(!c(t,0)){var r;switch(e.storage()){case"sparse":r=d(e,t,y,!1);break;default:r=v(e,t,y,!1)}return r}return e.clone()},"number | BigNumber, Matrix":function(e,t){if(!c(e,0)){var r;switch(t.storage()){case"sparse":r=m(t,e,y,!0);break;default:r=v(t,e,y,!0)}return r}return f(t.size(),t.storage())},"Array, number | BigNumber":function(e,t){return y(u(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return y(e,u(t)).valueOf()}});return y.toTex={2:"\\left(${args[0]}"+s.operators.leftShift+"${args[1]}\\right)"},y}},function(e,t){e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function leftShift");var r=e.constructor;return e.isNaN()||t.isNaN()||t.isNegative()&&!t.isZero()?new r(NaN):e.isZero()||t.isZero()?e:e.isFinite()||t.isFinite()?t.lt(55)?e.times(Math.pow(2,t.toNumber())+""):e.times(new r(2).pow(t)):new r(NaN)}},function(e,t,r){"use strict";var n=r(3).isInteger,i=r(458);t.name="rightArithShift",t.factory=function(e,t,a,o){var s=r(4),u=a(r(0)),c=a(r(10)),f=a(r(40)),l=a(r(33)),p=a(r(24)),h=a(r(88)),m=a(r(38)),d=a(r(19)),g=a(r(8)),v=a(r(6)),y=o("rightArithShift",{"number, number":function(e,t){if(!n(e)||!n(t))throw new Error("Integers expected in function rightArithShift");return e>>t},"BigNumber, BigNumber":i,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=h(e,t,y,!1);break;default:r=p(t,e,y,!0)}break;default:switch(t.storage()){case"sparse":r=l(e,t,y,!1);break;default:r=g(e,t,y)}}return r},"Array, Array":function(e,t){return y(u(e),u(t)).valueOf()},"Array, Matrix":function(e,t){return y(u(e),t)},"Matrix, Array":function(e,t){return y(e,u(t))},"Matrix, number | BigNumber":function(e,t){if(!c(t,0)){var r;switch(e.storage()){case"sparse":r=d(e,t,y,!1);break;default:r=v(e,t,y,!1)}return r}return e.clone()},"number | BigNumber, Matrix":function(e,t){if(!c(e,0)){var r;switch(t.storage()){case"sparse":r=m(t,e,y,!0);break;default:r=v(t,e,y,!0)}return r}return f(t.size(),t.storage())},"Array, number | BigNumber":function(e,t){return y(u(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return y(e,u(t)).valueOf()}});return y.toTex={2:"\\left(${args[0]}"+s.operators.rightArithShift+"${args[1]}\\right)"},y}},function(e,t){e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function rightArithShift");var r=e.constructor;return e.isNaN()||t.isNaN()||t.isNegative()&&!t.isZero()?new r(NaN):e.isZero()||t.isZero()?e:t.isFinite()?t.lt(55)?e.div(Math.pow(2,t.toNumber())+"").floor():e.div(new r(2).pow(t)).floor():e.isNegative()?new r(-1):e.isFinite()?new r(0):new r(NaN)}},function(e,t,r){"use strict";var n=r(3).isInteger;t.name="rightLogShift",t.factory=function(e,t,i,a){var o=r(4),s=i(r(0)),u=i(r(10)),c=i(r(40)),f=i(r(33)),l=i(r(24)),p=i(r(88)),h=i(r(38)),m=i(r(19)),d=i(r(8)),g=i(r(6)),v=a("rightLogShift",{"number, number":function(e,t){if(!n(e)||!n(t))throw new Error("Integers expected in function rightLogShift");return e>>>t},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=p(e,t,v,!1);break;default:r=l(t,e,v,!0)}break;default:switch(t.storage()){case"sparse":r=f(e,t,v,!1);break;default:r=d(e,t,v)}}return r},"Array, Array":function(e,t){return v(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return v(s(e),t)},"Matrix, Array":function(e,t){return v(e,s(t))},"Matrix, number | BigNumber":function(e,t){if(!u(t,0)){var r;switch(e.storage()){case"sparse":r=m(e,t,v,!1);break;default:r=g(e,t,v,!1)}return r}return e.clone()},"number | BigNumber, Matrix":function(e,t){if(!u(e,0)){var r;switch(t.storage()){case"sparse":r=h(t,e,v,!0);break;default:r=g(t,e,v,!0)}return r}return c(t.size(),t.storage())},"Array, number | BigNumber":function(e,t){return v(s(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return v(e,s(t)).valueOf()}});return v.toTex={2:"\\left(${args[0]}"+o.operators.rightLogShift+"${args[1]}\\right)"},v}},function(e,t,r){e.exports=[r(461),r(462),r(139),r(463)]},function(e,t,r){"use strict";t.name="bellNumbers",t.factory=function(e,t,n,i){var a=n(r(20)),o=n(r(139)),s=n(r(58)),u=n(r(51)),c=i("bellNumbers",{"number | BigNumber":function(e){if(!u(e)||s(e))throw new TypeError("Non-negative integer value expected in function bellNumbers");for(var t=0,r=0;r<=e;r++)t=a(t,o(e,r));return t}});return c.toTex={1:"\\mathrm{B}_{${args[0]}}"},c}},function(e,t,r){"use strict";t.name="composition",t.factory=function(e,t,n,i){var a=n(r(70)),o=n(r(16)),s=n(r(57)),u=n(r(51)),c=n(r(34)),f=i("composition",{"number | BigNumber, number | BigNumber":function(e,t){if(!(u(e)&&s(e)&&u(t)&&s(t)))throw new TypeError("Positive integer value expected in function composition");if(c(t,e))throw new TypeError("k must be less than or equal to n in function composition");return a(o(e,-1),o(t,-1))}});return f.toTex=void 0,f}},function(e,t,r){"use strict";t.name="catalan",t.factory=function(e,t,n,i){var a=n(r(20)),o=n(r(49)),s=n(r(12)),u=n(r(70)),c=n(r(58)),f=n(r(51)),l=i("catalan",{"number | BigNumber":function(e){if(!f(e)||c(e))throw new TypeError("Non-negative integer value expected in function catalan");return o(u(s(e,2),e),a(e,1))}});return l.toTex={1:"\\mathrm{C}_{${args[0]}}"},l}},function(e,t,r){e.exports=[r(465),r(126),r(466),r(467)]},function(e,t,r){"use strict";var n=r(1);t.name="arg",t.factory=function(e,t,r,i){var a=i("arg",{number:function(e){return Math.atan2(0,e)},BigNumber:function(t){return e.BigNumber.atan2(0,t)},Complex:function(e){return e.arg()},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\arg\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);t.name="im",t.factory=function(e,t,r,i){var a=i("im",{number:function(e){return 0},BigNumber:function(t){return new e.BigNumber(0)},Complex:function(e){return e.im},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\Im\\left\\lbrace${args[0]}\\right\\rbrace"},a}},function(e,t,r){"use strict";var n=r(1);t.name="re",t.factory=function(e,t,r,i){var a=i("re",{number:function(e){return e},BigNumber:function(e){return e},Complex:function(e){return e.re},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\Re\\left\\lbrace${args[0]}\\right\\rbrace"},a}},function(e,t,r){e.exports=[r(469),r(470)]},function(e,t,r){"use strict";t.name="intersect",t.factory=function(e,t,n,i){var a=n(r(28)),o=n(r(20)),s=n(r(16)),u=n(r(0)),c=n(r(12)),f=n(r(22)),l=n(r(14)),p=n(r(21)),h=n(r(39)),m=n(r(10)),d=i("intersect",{"Array, Array, Array":function(e,t,r){if(!y(e))throw new TypeError("Array with 3 numbers or BigNumbers expected for first argument");if(!y(t))throw new TypeError("Array with 3 numbers or BigNumbers expected for second argument");if(!(4===(n=r).length&&g(n[0])&&g(n[1])&&g(n[2])&&g(n[3])))throw new TypeError("Array with 4 numbers expected as third argument");var n,i,a,o,u,c,h,m,d,v,x,w,b,N,E,M,A,O,T,S,_;return i=e[0],a=e[1],o=e[2],u=t[0],c=t[1],h=t[2],m=r[0],d=r[1],v=r[2],x=r[3],w=f(i,m),b=f(u,m),N=f(a,d),E=f(c,d),M=f(o,v),A=f(h,v),O=l(p(p(p(x,w),N),M),p(p(p(s(s(b,E),A),w),N),M)),T=s(i,f(O,p(u,i))),S=s(a,f(O,p(c,a))),_=s(o,f(O,p(h,o))),[T,S,_]},"Array, Array, Array, Array":function(e,r,n,i){if(2===e.length){if(!v(e))throw new TypeError("Array with 2 numbers or BigNumbers expected for first argument");if(!v(r))throw new TypeError("Array with 2 numbers or BigNumbers expected for second argument");if(!v(n))throw new TypeError("Array with 2 numbers or BigNumbers expected for third argument");if(!v(i))throw new TypeError("Array with 2 numbers or BigNumbers expected for fourth argument");return function(e,r,n,i){var u=e,m=n,d=p(u,r),g=p(m,i),v=p(f(d[0],g[1]),f(g[0],d[1]));if(h(a(v),t.epsilon))return null;var y=f(g[0],u[1]),x=f(g[1],u[0]),w=f(g[0],m[1]),b=f(g[1],m[0]),N=l(s(p(p(y,x),w),b),v);return o(c(d,N),u)}(e,r,n,i)}if(3===e.length){if(!y(e))throw new TypeError("Array with 3 numbers or BigNumbers expected for first argument");if(!y(r))throw new TypeError("Array with 3 numbers or BigNumbers expected for second argument");if(!y(n))throw new TypeError("Array with 3 numbers or BigNumbers expected for third argument");if(!y(i))throw new TypeError("Array with 3 numbers or BigNumbers expected for fourth argument");return u=e[0],d=e[1],g=e[2],w=r[0],b=r[1],N=r[2],E=n[0],M=n[1],A=n[2],O=i[0],T=i[1],S=i[2],_=x(u,E,O,E,d,M,T,M,g,A,S,A),C=x(O,E,w,u,T,M,b,d,S,A,N,g),z=x(u,E,w,u,d,M,b,d,g,A,N,g),k=x(O,E,O,E,T,M,T,M,S,A,S,A),B=x(w,u,w,u,b,d,b,d,N,g,N,g),I=l(p(f(_,C),f(z,k)),p(f(B,k),f(C,C))),P=l(s(_,f(I,C)),k),R=s(u,f(I,p(w,u))),U=s(d,f(I,p(b,d))),q=s(g,f(I,p(N,g))),L=s(E,f(P,p(O,E))),j=s(M,f(P,p(T,M))),F=s(A,f(P,p(S,A))),m(R,L)&&m(U,j)&&m(q,F)?[R,U,q]:null}throw new TypeError("Arrays with two or thee dimensional points expected");var u,d,g,w,b,N,E,M,A,O,T,S,_,C,z,k,B,I,P,R,U,q,L,j,F},"Matrix, Matrix, Matrix":function(e,t,r){return u(d(e.valueOf(),t.valueOf(),r.valueOf()))},"Matrix, Matrix, Matrix, Matrix":function(e,t,r,n){return u(d(e.valueOf(),t.valueOf(),r.valueOf(),n.valueOf()))}});function g(t){return"number"==typeof t||e.isBigNumber(t)}function v(e){return 2===e.length&&g(e[0])&&g(e[1])}function y(e){return 3===e.length&&g(e[0])&&g(e[1])&&g(e[2])}function x(e,t,r,n,i,a,o,u,c,l,h,m){var d=f(p(e,t),p(r,n)),g=f(p(i,a),p(o,u)),v=f(p(c,l),p(h,m));return s(s(d,g),v)}return d}},function(e,t,r){"use strict";t.name="distance",t.factory=function(e,t,n,i){n(r(0));var a=n(r(16)),o=n(r(21)),s=n(r(22)),u=n(r(14)),c=n(r(35)),f=n(r(50)),l=n(r(28));function p(t){return"number"==typeof t||e.isBigNumber(t)}function h(e){return e.constructor!==Array&&(e=g(e)),p(e[0])&&p(e[1])}function m(e){return e.constructor!==Array&&(e=g(e)),p(e[0])&&p(e[1])&&p(e[2])}function d(e){return e.constructor!==Array&&(e=g(e)),p(e[0])&&p(e[1])&&p(e[2])&&p(e[3])&&p(e[4])&&p(e[5])}function g(e){for(var t=Object.keys(e),r=[],n=0;n<t.length;n++)r.push(e[t[n]]);return r}function v(e,t,r,n,i){var o=l(a(a(s(r,e),s(n,t)),i)),c=f(a(s(r,r),s(n,n)));return u(o,c)}function y(e,t,r,n,i,c,l,p,h){var m=[o(s(o(i,t),h),s(o(c,r),p)),o(s(o(c,r),l),s(o(n,e),h)),o(s(o(n,e),p),s(o(i,t),l))];m=f(a(a(s(m[0],m[0]),s(m[1],m[1])),s(m[2],m[2])));var d=f(a(a(s(l,l),s(p,p)),s(h,h)));return u(m,d)}function x(e,t,r,n){var i=o(n,t),u=o(r,e),c=a(s(i,i),s(u,u));return f(c)}function w(e,t,r,n,i,u){var c=o(u,r),l=o(i,t),p=o(n,e),h=a(a(s(c,c),s(l,l)),s(p,p));return f(h)}return i("distance",{"Array, Array, Array":function(e,t,r){if(2==e.length&&2==t.length&&2==r.length){if(!h(e))throw new TypeError("Array with 2 numbers or BigNumbers expected for first argument");if(!h(t))throw new TypeError("Array with 2 numbers or BigNumbers expected for second argument");if(!h(r))throw new TypeError("Array with 2 numbers or BigNumbers expected for third argument");var n=u(o(r[1],r[0]),o(t[1],t[0])),i=s(s(n,n),t[0]),a=c(s(n,t[0])),f=e[1];return v(e[0],e[1],i,a,f)}throw new TypeError("Invalid Arguments: Try again")},"Object, Object, Object":function(e,t,r){if(2==Object.keys(e).length&&2==Object.keys(t).length&&2==Object.keys(r).length){if(!h(e))throw new TypeError("Values of pointX and pointY should be numbers or BigNumbers");if(!h(t))throw new TypeError("Values of lineOnePtX and lineOnePtY should be numbers or BigNumbers");if(!h(r))throw new TypeError("Values of lineTwoPtX and lineTwoPtY should be numbers or BigNumbers");if(e.hasOwnProperty("pointX")&&e.hasOwnProperty("pointY")&&t.hasOwnProperty("lineOnePtX")&&t.hasOwnProperty("lineOnePtY")&&r.hasOwnProperty("lineTwoPtX")&&r.hasOwnProperty("lineTwoPtY")){var n=u(o(r.lineTwoPtY,r.lineTwoPtX),o(t.lineOnePtY,t.lineOnePtX)),i=s(s(n,n),t.lineOnePtX),a=c(s(n,t.lineOnePtX)),f=e.pointX;return v(e.pointX,e.pointY,i,a,f)}throw new TypeError("Key names do not match")}throw new TypeError("Invalid Arguments: Try again")},"Array, Array":function(e,t){if(2==e.length&&3==t.length){if(!h(e))throw new TypeError("Array with 2 numbers or BigNumbers expected for first argument");if(!m(t))throw new TypeError("Array with 3 numbers or BigNumbers expected for second argument");return v(e[0],e[1],t[0],t[1],t[2])}if(3==e.length&&6==t.length){if(!m(e))throw new TypeError("Array with 3 numbers or BigNumbers expected for first argument");if(!d(t))throw new TypeError("Array with 6 numbers or BigNumbers expected for second argument");return y(e[0],e[1],e[2],t[0],t[1],t[2],t[3],t[4],t[5])}if(2==e.length&&2==t.length){if(!h(e))throw new TypeError("Array with 2 numbers or BigNumbers expected for first argument");if(!h(t))throw new TypeError("Array with 2 numbers or BigNumbers expected for second argument");return x(e[0],e[1],t[0],t[1])}if(3==e.length&&3==t.length){if(!m(e))throw new TypeError("Array with 3 numbers or BigNumbers expected for first argument");if(!m(t))throw new TypeError("Array with 3 numbers or BigNumbers expected for second argument");return w(e[0],e[1],e[2],t[0],t[1],t[2])}throw new TypeError("Invalid Arguments: Try again")},"Object, Object":function(e,t){if(2==Object.keys(e).length&&3==Object.keys(t).length){if(!h(e))throw new TypeError("Values of pointX and pointY should be numbers or BigNumbers");if(!m(t))throw new TypeError("Values of xCoeffLine, yCoeffLine and constant should be numbers or BigNumbers");if(e.hasOwnProperty("pointX")&&e.hasOwnProperty("pointY")&&t.hasOwnProperty("xCoeffLine")&&t.hasOwnProperty("yCoeffLine")&&t.hasOwnProperty("constant"))return v(e.pointX,e.pointY,t.xCoeffLine,t.yCoeffLine,t.constant);throw new TypeError("Key names do not match")}if(3==Object.keys(e).length&&6==Object.keys(t).length){if(!m(e))throw new TypeError("Values of pointX, pointY and pointZ should be numbers or BigNumbers");if(!d(t))throw new TypeError("Values of x0, y0, z0, a, b and c should be numbers or BigNumbers");if(e.hasOwnProperty("pointX")&&e.hasOwnProperty("pointY")&&t.hasOwnProperty("x0")&&t.hasOwnProperty("y0")&&t.hasOwnProperty("z0")&&t.hasOwnProperty("a")&&t.hasOwnProperty("b")&&t.hasOwnProperty("c"))return y(e.pointX,e.pointY,e.pointZ,t.x0,t.y0,t.z0,t.a,t.b,t.c);throw new TypeError("Key names do not match")}if(2==Object.keys(e).length&&2==Object.keys(t).length){if(!h(e))throw new TypeError("Values of pointOneX and pointOneY should be numbers or BigNumbers");if(!h(t))throw new TypeError("Values of pointTwoX and pointTwoY should be numbers or BigNumbers");if(e.hasOwnProperty("pointOneX")&&e.hasOwnProperty("pointOneY")&&t.hasOwnProperty("pointTwoX")&&t.hasOwnProperty("pointTwoY"))return x(e.pointOneX,e.pointOneY,t.pointTwoX,t.pointTwoY);throw new TypeError("Key names do not match")}if(3==Object.keys(e).length&&3==Object.keys(t).length){if(!m(e))throw new TypeError("Values of pointOneX, pointOneY and pointOneZ should be numbers or BigNumbers");if(!m(t))throw new TypeError("Values of pointTwoX, pointTwoY and pointTwoZ should be numbers or BigNumbers");if(e.hasOwnProperty("pointOneX")&&e.hasOwnProperty("pointOneY")&&e.hasOwnProperty("pointOneZ")&&t.hasOwnProperty("pointTwoX")&&t.hasOwnProperty("pointTwoY")&&t.hasOwnProperty("pointTwoZ"))return w(e.pointOneX,e.pointOneY,e.pointOneZ,t.pointTwoX,t.pointTwoY,t.pointTwoZ);throw new TypeError("Key names do not match")}throw new TypeError("Invalid Arguments: Try again")},Array:function(e){if(!function(e){if(2==e[0].length&&p(e[0][0])&&p(e[0][1])){for(var t in e)if(2!=e[t].length||!p(e[t][0])||!p(e[t][1]))return!1}else{if(!(3==e[0].length&&p(e[0][0])&&p(e[0][1])&&p(e[0][2])))return!1;for(var t in e)if(3!=e[t].length||!p(e[t][0])||!p(e[t][1])||!p(e[t][2]))return!1}return!0}(e))throw new TypeError("Incorrect array format entered for pairwise distance calculation");return function(e){for(var t=[],r=0;r<e.length-1;r++)for(var n=r+1;n<e.length;n++)2==e[0].length?t.push(x(e[r][0],e[r][1],e[n][0],e[n][1])):3==e[0].length&&t.push(w(e[r][0],e[r][1],e[r][2],e[n][0],e[n][1],e[n][2]));return t}(e)}})}},function(e,t,r){e.exports=[r(472),r(141),r(473),r(474)]},function(e,t,r){"use strict";t.name="and",t.factory=function(e,t,n,i){var a=r(4),o=n(r(0)),s=n(r(40)),u=n(r(141)),c=(n(r(83)),n(r(24))),f=n(r(68)),l=n(r(19)),p=n(r(8)),h=n(r(6)),m=i("and",{"number, number":function(e,t){return!(!e||!t)},"Complex, Complex":function(e,t){return!(0===e.re&&0===e.im||0===t.re&&0===t.im)},"BigNumber, BigNumber":function(e,t){return!(e.isZero()||t.isZero()||e.isNaN()||t.isNaN())},"Unit, Unit":function(e,t){return m(e.value,t.value)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=c(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,m,!1);break;default:r=p(e,t,m)}}return r},"Array, Array":function(e,t){return m(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return m(o(e),t)},"Matrix, Array":function(e,t){return m(e,o(t))},"Matrix, any":function(e,t){if(u(t))return s(e.size(),e.storage());var r;switch(e.storage()){case"sparse":r=l(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"any, Matrix":function(e,t){if(u(e))return s(e.size(),e.storage());var r;switch(t.storage()){case"sparse":r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, any":function(e,t){return m(o(e),t).valueOf()},"any, Array":function(e,t){return m(e,o(t)).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+a.operators.and+"${args[1]}\\right)"},m}},function(e,t,r){"use strict";t.name="or",t.factory=function(e,t,n,i){var a=r(4),o=n(r(0)),s=n(r(17)),u=n(r(61)),c=n(r(18)),f=n(r(8)),l=n(r(6)),p=i("or",{"number, number":function(e,t){return!(!e&&!t)},"Complex, Complex":function(e,t){return 0!==e.re||0!==e.im||0!==t.re||0!==t.im},"BigNumber, BigNumber":function(e,t){return!e.isZero()&&!e.isNaN()||!t.isZero()&&!t.isNaN()},"Unit, Unit":function(e,t){return p(e.value,t.value)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=u(e,t,p);break;default:r=s(t,e,p,!0)}break;default:switch(t.storage()){case"sparse":r=s(e,t,p,!1);break;default:r=f(e,t,p)}}return r},"Array, Array":function(e,t){return p(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return p(o(e),t)},"Matrix, Array":function(e,t){return p(e,o(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=c(e,t,p,!1);break;default:r=l(e,t,p,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=c(t,e,p,!0);break;default:r=l(t,e,p,!0)}return r},"Array, any":function(e,t){return l(o(e),t,p,!1).valueOf()},"any, Array":function(e,t){return l(o(t),e,p,!0).valueOf()}});return p.toTex={2:"\\left(${args[0]}"+a.operators.or+"${args[1]}\\right)"},p}},function(e,t,r){"use strict";t.name="xor",t.factory=function(e,t,n,i){var a=r(4),o=n(r(0)),s=n(r(17)),u=n(r(26)),c=n(r(18)),f=n(r(8)),l=n(r(6)),p=i("xor",{"number, number":function(e,t){return!!e!=!!t},"Complex, Complex":function(e,t){return(0!==e.re||0!==e.im)!=(0!==t.re||0!==t.im)},"BigNumber, BigNumber":function(e,t){return(!e.isZero()&&!e.isNaN())!=(!t.isZero()&&!t.isNaN())},"Unit, Unit":function(e,t){return p(e.value,t.value)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=u(e,t,p);break;default:r=s(t,e,p,!0)}break;default:switch(t.storage()){case"sparse":r=s(e,t,p,!1);break;default:r=f(e,t,p)}}return r},"Array, Array":function(e,t){return p(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return p(o(e),t)},"Matrix, Array":function(e,t){return p(e,o(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=c(e,t,p,!1);break;default:r=l(e,t,p,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=c(t,e,p,!0);break;default:r=l(t,e,p,!0)}return r},"Array, any":function(e,t){return l(o(e),t,p,!1).valueOf()},"any, Array":function(e,t){return l(o(t),e,p,!0).valueOf()}});return p.toTex={2:"\\left(${args[0]}"+a.operators.xor+"${args[1]}\\right)"},p}},function(e,t,r){e.exports=[r(64),r(476),r(117),r(477),r(478),r(62),r(479),r(480),r(481),r(116),r(482),r(142),r(483),r(89),r(119),r(484),r(485),r(29),r(143),r(487),r(23),r(138),r(67),r(40)]},function(e,t,r){"use strict";var n=r(2);t.name="cross",t.factory=function(e,t,i,a){var o=i(r(0)),s=i(r(21)),u=i(r(12)),c=a("cross",{"Matrix, Matrix":function(e,t){return o(f(e.toArray(),t.toArray()))},"Matrix, Array":function(e,t){return o(f(e.toArray(),t))},"Array, Matrix":function(e,t){return o(f(e,t.toArray()))},"Array, Array":f});return c.toTex={2:"\\left(${args[0]}\\right)\\times\\left(${args[1]}\\right)"},c;function f(e,t){var r=Math.max(n.size(e).length,n.size(t).length);e=n.squeeze(e),t=n.squeeze(t);var i=n.size(e),a=n.size(t);if(1!=i.length||1!=a.length||3!=i[0]||3!=a[0])throw new RangeError("Vectors with length 3 expected (Size A = ["+i.join(", ")+"], B = ["+a.join(", ")+"])");var o=[s(u(e[1],t[2]),u(e[2],t[1])),s(u(e[2],t[0]),u(e[0],t[2])),s(u(e[0],t[1]),u(e[1],t[0]))];return r>1?[o]:o}}},function(e,t,r){"use strict";var n=r(2),i=(r(5).clone,r(3).isInteger);t.name="diag",t.factory=function(e,t,a,o){var s=a(r(0)),u=o("diag",{Array:function(e){return c(e,0,n.size(e),null)},"Array, number":function(e,t){return c(e,t,n.size(e),null)},"Array, BigNumber":function(e,t){return c(e,t.toNumber(),n.size(e),null)},"Array, string":function(e,t){return c(e,0,n.size(e),t)},"Array, number, string":function(e,t,r){return c(e,t,n.size(e),r)},"Array, BigNumber, string":function(e,t,r){return c(e,t.toNumber(),n.size(e),r)},Matrix:function(e){return c(e,0,e.size(),e.storage())},"Matrix, number":function(e,t){return c(e,t,e.size(),e.storage())},"Matrix, BigNumber":function(e,t){return c(e,t.toNumber(),e.size(),e.storage())},"Matrix, string":function(e,t){return c(e,0,e.size(),t)},"Matrix, number, string":function(e,t,r){return c(e,t,e.size(),r)},"Matrix, BigNumber, string":function(e,t,r){return c(e,t.toNumber(),e.size(),r)}});return u.toTex=void 0,u;function c(t,r,n,a){if(!i(r))throw new TypeError("Second parameter in function diag must be an integer");var o,u,c,f,l,p,h=r>0?r:0,m=r<0?-r:0;switch(n.length){case 1:return o=t,u=r,c=a,f=n[0],l=[f+m,f+h],p=e.Matrix.storage(c||"dense").diagonal(l,o,u),null!==c?p:p.valueOf();case 2:return function(t,r,n,i,a,o){if(e.isMatrix(t)){var u=t.diagonal(r);return null!==n?n!==u.storage()?s(u,n):u:u.valueOf()}for(var c=Math.min(i[0]-a,i[1]-o),f=[],l=0;l<c;l++)f[l]=t[l+a][l+o];return null!==n?s(f):f}(t,r,a,n,m,h)}throw new RangeError("Matrix for function diag must be 2 dimensional")}}},function(e,t,r){"use strict";var n=r(2).size;t.name="dot",t.factory=function(e,t,i,a){var o=i(r(20)),s=i(r(12)),u=a("dot",{"Matrix, Matrix":function(e,t){return c(e.toArray(),t.toArray())},"Matrix, Array":function(e,t){return c(e.toArray(),t)},"Array, Matrix":function(e,t){return c(e,t.toArray())},"Array, Array":c});return u.toTex={2:"\\left(${args[0]}\\cdot${args[1]}\\right)"},u;function c(e,t){var r=n(e),i=n(t),a=r[0];if(1!==r.length||1!==i.length)throw new RangeError("Vector expected");if(r[0]!=i[0])throw new RangeError("Vectors must have equal length ("+r[0]+" != "+i[0]+")");if(0==a)throw new RangeError("Cannot calculate the dot product of empty vectors");for(var u=0,c=0;c<a;c++)u=o(u,s(e[c],t[c]));return u}}},function(e,t,r){"use strict";var n=r(2).filter,i=r(2).filterRegExp,a=r(32).maxArgumentCount;function o(e,t){var r=a(t);return n(e,function(e,n,i){return 1===r?t(e):2===r?t(e,[n]):t(e,[n],i)})}t.name="filter",t.factory=function(e,t,n,a){var s=n(r(0)),u=a("filter",{"Array, function":o,"Matrix, function":function(e,t){return s(o(e.toArray(),t))},"Array, RegExp":i,"Matrix, RegExp":function(e,t){return s(i(e.toArray(),t))}});return u.toTex=void 0,u}},function(e,t,r){"use strict";var n=r(5).clone,i=r(2).flatten;t.name="flatten",t.factory=function(e,t,a,o){var s=a(r(0)),u=o("flatten",{Array:function(e){return i(n(e))},Matrix:function(e){var t=i(n(e.toArray()));return s(t)}});return u.toTex=void 0,u}},function(e,t,r){"use strict";var n=r(32).maxArgumentCount,i=r(2).forEach;function a(e,t){var r=n(t),a=function(n,o){Array.isArray(n)?i(n,function(e,t){a(e,o.concat(t))}):1===r?t(n):2===r?t(n,o):t(n,o,e)};a(e,[])}t.name="forEach",t.factory=function(e,t,r,n){var i=n("forEach",{"Array, function":a,"Matrix, function":function(e,t){return e.forEach(t)}});return i.toTex=void 0,i}},function(e,t,r){"use strict";var n=r(2).size;t.name="kron",t.factory=function(e,t,i,a){var o=i(r(0)),s=i(r(22));return a("kron",{"Matrix, Matrix":function(e,t){return o(u(e.toArray(),t.toArray()))},"Matrix, Array":function(e,t){return o(u(e.toArray(),t))},"Array, Matrix":function(e,t){return o(u(e,t.toArray()))},"Array, Array":u});function u(e,t){if(1===n(e).length&&(e=[e]),1===n(t).length&&(t=[t]),n(e).length>2||n(t).length>2)throw new RangeError("Vectors with dimensions greater then 2 are not supported expected (Size x = "+JSON.stringify(e.length)+", y = "+JSON.stringify(t.length)+")");var r=[],i=[];return e.map(function(e){return t.map(function(t){return e.map(function(e){return t.map(function(t){return i.push(s(e,t))})},r.push(i=[]))})},r=[])&&r}}},function(e,t,r){"use strict";var n=r(3).isInteger,i=r(2).resize;t.name="ones",t.factory=function(e,t,a,o){var s=a(r(0)),u=o("ones",{"":function(){return"Array"===t.matrix?c([]):c([],"default")},"...number | BigNumber | string":function(e){return"string"==typeof e[e.length-1]?c(e,e.pop()):"Array"===t.matrix?c(e):c(e,"default")},Array:c,Matrix:function(e){var t=e.storage();return c(e.valueOf(),t)},"Array | Matrix, string":function(e,t){return c(e.valueOf(),t)}});return u.toTex=void 0,u;function c(t,r){var a,o=(a=!1,t.forEach(function(t,r,n){e.isBigNumber(t)&&(a=!0,n[r]=t.toNumber())}),a?new e.BigNumber(1):1);if(t.forEach(function(e){if("number"!=typeof e||!n(e)||e<0)throw new Error("Parameters in function ones must be positive integers")}),r){var u=s(r);return t.length>0?u.resize(t,o):u}var c=[];return t.length>0?i(c,t,o):c}}},function(e,t,r){"use strict";r(11);var n=r(3).isInteger,i=r(2);t.name="reshape",t.factory=function(e,t,a,o){var s=a(r(0)),u=o("reshape",{"Matrix, Array":function(e,t){return e.reshape?e.reshape(t):s(i.reshape(e.valueOf(),t))},"Array, Array":function(e,t){return t.forEach(function(e){if(!n(e))throw new TypeError("Invalid size for dimension: "+e)}),i.reshape(e,t)}});return u.toTex=void 0,u}},function(e,t,r){"use strict";var n=r(11),i=r(44),a=r(3).isInteger,o=r(9).format,s=r(5).clone,u=r(2);t.name="resize",t.factory=function(e,t,c,f){var l=c(r(0)),p=function(r,c,f){if(2!=arguments.length&&3!=arguments.length)throw new i("resize",arguments.length,2,3);if(e.isMatrix(c)&&(c=c.valueOf()),e.isBigNumber(c[0])&&(c=c.map(function(t){return e.isBigNumber(t)?t.toNumber():t})),e.isMatrix(r))return r.resize(c,f,!0);if("string"==typeof r)return function(e,t,r){if(void 0!==r){if("string"!=typeof r||1!==r.length)throw new TypeError("Single character expected as defaultValue")}else r=" ";if(1!==t.length)throw new n(t.length,1);var i=t[0];if("number"!=typeof i||!a(i))throw new TypeError("Invalid size, must contain positive integers (size: "+o(t)+")");if(e.length>i)return e.substring(0,i);if(e.length<i){for(var s=e,u=0,c=i-e.length;u<c;u++)s+=r;return s}return e}(r,c,f);var p=!Array.isArray(r)&&"Array"!==t.matrix;if(0==c.length){for(;Array.isArray(r);)r=r[0];return s(r)}Array.isArray(r)||(r=[r]),r=s(r);var h=u.resize(r,c,f);return p?l(h):h};return p.toTex=void 0,p}},function(e,t){e.exports=function e(t,r){"use strict";var n,i,a=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,o=/(^[ ]*|[ ]*$)/g,s=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,u=/^0x[0-9a-f]+$/i,c=/^0/,f=function(t){return e.insensitive&&(""+t).toLowerCase()||""+t},l=f(t).replace(o,"")||"",p=f(r).replace(o,"")||"",h=l.replace(a,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),m=p.replace(a,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),d=parseInt(l.match(u),16)||1!==h.length&&l.match(s)&&Date.parse(l),g=parseInt(p.match(u),16)||d&&p.match(s)&&Date.parse(p)||null;if(g){if(d<g)return-1;if(d>g)return 1}for(var v=0,y=Math.max(h.length,m.length);v<y;v++){if(n=!(h[v]||"").match(c)&&parseFloat(h[v])||h[v]||0,i=!(m[v]||"").match(c)&&parseFloat(m[v])||m[v]||0,isNaN(n)!==isNaN(i))return isNaN(n)?1:-1;if(typeof n!=typeof i&&(n+="",i+=""),n<i)return-1;if(n>i)return 1}return 0}},function(e,t,r){"use strict";var n=r(5),i=r(2);t.name="squeeze",t.factory=function(e,t,a,o){var s=a(r(0)),u=o("squeeze",{Array:function(e){return i.squeeze(n.clone(e))},Matrix:function(e){var t=i.squeeze(e.toArray());return Array.isArray(t)?s(t):t},any:function(e){return n.clone(e)}});return u.toTex=void 0,u}},function(e,t,r){e.exports=[r(70),r(69),r(140),r(489),r(490),r(491),r(492),r(496),r(497)]},function(e,t,r){"use strict";t.name="kldivergence",t.factory=function(e,t,n,i){var a=n(r(0)),o=n(r(49)),s=n(r(144)),u=n(r(12)),c=n(r(135)),f=n(r(137)),l=n(r(75));function p(e,t){var r=t.size().length,n=e.size().length;if(r>1)throw new Error("first object must be one dimensional");if(n>1)throw new Error("second object must be one dimensional");if(r!==n)throw new Error("Length of two vectors must be equal");if(0===s(e))throw new Error("Sum of elements in first object must be non zero");if(0===s(t))throw new Error("Sum of elements in second object must be non zero");var i=o(e,s(e)),a=o(t,s(t)),p=s(u(i,f(c(i,a))));return l(p)?p:Number.NaN}return i("kldivergence",{"Array, Array":function(e,t){return p(a(e),a(t))},"Matrix, Array":function(e,t){return p(e,a(t))},"Array, Matrix":function(e,t){return p(a(e),t)},"Matrix, Matrix":function(e,t){return p(e,t)}})}},function(e,t,r){"use strict";var n=r(43);t.name="multinomial",t.factory=function(e,t,i,a){var o=i(r(20)),s=i(r(12)),u=i(r(49)),c=i(r(69)),f=i(r(51)),l=i(r(57));return a("multinomial",{"Array | Matrix":function(e){var t=0,r=1;return n(e,function(e){if(!f(e)||!l(e))throw new TypeError("Positive integer value expected in function multinomial");t=o(t,e),r=s(r,c(e))}),u(c(t),r)}})}},function(e,t,r){"use strict";var n=r(3).isInteger;function i(e){return e.isInteger()&&e.gte(0)}t.name="permutations",t.factory=function(e,t,a,o){var s=o("permutations",{"number | BigNumber":a(r(69)),"number, number":function(e,t){var r,i;if(!n(e)||e<0)throw new TypeError("Positive integer value expected in function permutations");if(!n(t)||t<0)throw new TypeError("Positive integer value expected in function permutations");if(t>e)throw new TypeError("second argument k must be less than or equal to first argument n");for(r=1,i=e-t+1;i<=e;i++)r*=i;return r},"BigNumber, BigNumber":function(t,r){var n,a;if(!i(t)||!i(r))throw new TypeError("Positive integer value expected in function permutations");if(r.gt(t))throw new TypeError("second argument k must be less than or equal to first argument n");for(n=new e.BigNumber(1),a=t.minus(r).plus(1);a.lte(t);a=a.plus(1))n=n.times(a);return n}});return s.toTex=void 0,s}},function(e,t,r){"use strict";t.name="pickRandom",t.factory=function(e,t,n,i){var a=n(r(90))("uniform").pickRandom;return a.toTex=void 0,a}},function(e,t,r){"use strict";var n=r(494),i=n();t.factory=function(e,t,r,a,o){var s;function u(e){s=null===e?i:n(String(e))}return u(t.randomSeed),o.on("config",function(e,t,r){void 0!==r.randomSeed&&u(e.randomSeed)}),function(){return s()}},t.math=!0},function(e,t,r){"use strict";(function(t){var r=256,n=[],i=void 0===t?window:t,a=Math.pow(r,6),o=Math.pow(2,52),s=2*o,u=r-1,c=Math.random;function f(e,t){for(var r,n=e+"",i=0;i<n.length;)t[u&i]=u&(r^=19*t[u&i])+n.charCodeAt(i++);return l(t)}function l(e){return String.fromCharCode.apply(0,e)}e.exports=function(t,c){if(c&&!0===c.global)return c.global=!1,Math.random=e.exports(t,c),c.global=!0,Math.random;var p=[],h=(f(function e(t,r){var n,i=[],a=(typeof t)[0];if(r&&"o"==a)for(n in t)try{i.push(e(t[n],r-1))}catch(e){}return i.length?i:"s"==a?t:t+"\0"}(c&&c.entropy||!1?[t,l(n)]:0 in arguments?t:function(e){try{return i.crypto.getRandomValues(e=new Uint8Array(r)),l(e)}catch(e){return[+new Date,i,i.navigator&&i.navigator.plugins,i.screen,l(n)]}}(),3),p),new function(e){var t,n=e.length,i=this,a=0,o=i.i=i.j=0,s=i.S=[];n||(e=[n++]);for(;a<r;)s[a]=a++;for(a=0;a<r;a++)s[a]=s[o=u&o+e[a%n]+(t=s[a])],s[o]=t;(i.g=function(e){for(var t,n=0,a=i.i,o=i.j,s=i.S;e--;)t=s[a=u&a+1],n=n*r+s[u&(s[a]=s[o=u&o+t])+(s[o]=t)];return i.i=a,i.j=o,n})(r)}(p));return f(l(h.S),n),function(){for(var e=h.g(6),t=a,n=0;e<o;)e=(e+n)*r,t*=r,n=h.g(1);for(;e>=s;)e/=2,t/=2,n>>>=1;return(e+n)/t}},e.exports.resetGlobal=function(){Math.random=c},f(Math.random(),n)}).call(t,r(495))},function(e,t){var r;r=function(){return this}();try{r=r||Function("return this")()||(0,eval)("this")}catch(e){"object"==typeof window&&(r=window)}e.exports=r},function(e,t,r){"use strict";t.name="random",t.factory=function(e,t,n,i){var a=n(r(90))("uniform").random;return a.toTex=void 0,a}},function(e,t,r){"use strict";t.name="randomInt",t.factory=function(e,t,n,i){var a=n(r(90))("uniform").randomInt;return a.toTex=void 0,a}},function(e,t,r){e.exports=[r(52),r(31),r(499),r(30),r(34),r(130),r(39),r(500),r(124)]},function(e,t,r){"use strict";t.name="deepEqual",t.factory=function(e,t,n,i){var a=n(r(30)),o=i("deepEqual",{"any, any":function(e,t){return function e(t,r){if(Array.isArray(t)){if(Array.isArray(r)){var n=t.length;if(n!==r.length)return!1;for(var i=0;i<n;i++)if(!e(t[i],r[i]))return!1;return!0}return!1}return!Array.isArray(r)&&a(t,r)}(e.valueOf(),t.valueOf())}});return o.toTex=void 0,o}},function(e,t,r){"use strict";var n=r(3).nearlyEqual,i=r(37);t.name="smallerEq",t.factory=function(e,t,a,o){var s=a(r(0)),u=a(r(17)),c=a(r(26)),f=a(r(18)),l=a(r(8)),p=a(r(6)),h=r(4),m=o("smallerEq",{"boolean, boolean":function(e,t){return e<=t},"number, number":function(e,r){return e<=r||n(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return e.lte(r)||i(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return 1!==e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return m(e.value,t.value)},"string, string":function(e,t){return e<=t},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,m);break;default:r=u(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,m,!1);break;default:r=l(e,t,m)}}return r},"Array, Array":function(e,t){return m(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return m(s(e),t)},"Matrix, Array":function(e,t){return m(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=p(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,m,!0);break;default:r=p(t,e,m,!0)}return r},"Array, any":function(e,t){return p(s(e),t,m,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+h.operators.smallerEq+"${args[1]}\\right)"},m}},function(e,t,r){e.exports=[r(502),r(145),r(503),r(146),r(504),r(505),r(506),r(507),r(147),r(508)]},function(e,t,r){"use strict";var n=r(2).flatten;t.name="setCartesian",t.factory=function(e,t,i,a){var o=i(r(27)),s=i(r(45)),u=i(r(29)),c=i(r(23)),f=i(r(31));return a("setCartesian",{"Array | Matrix, Array | Matrix":function(e,t){if(0===c(u(e),new o(0))||0===c(u(t),new o(0)))var r=[];else for(var i=n(Array.isArray(e)?e:e.toArray()).sort(f),a=n(Array.isArray(t)?t:t.toArray()).sort(f),l=(r=[],0);l<i.length;l++)for(var p=0;p<a.length;p++)r.push([i[l],a[p]]);return Array.isArray(e)&&Array.isArray(t)?r:new s(r)}})}},function(e,t,r){"use strict";var n=r(2).flatten;t.name="setDistinct",t.factory=function(e,t,i,a){var o=i(r(30)),s=i(r(27)),u=i(r(45)),c=i(r(29)),f=i(r(23)),l=i(r(31));return a("setDistinct",{"Array | Matrix":function(e){if(0===f(c(e),new s(0)))var t=[];else{var r=n(Array.isArray(e)?e:e.toArray()).sort(l);(t=[]).push(r[0]);for(var i=1;i<r.length;i++)o(r[i],r[i-1])||t.push(r[i])}return Array.isArray(e)?t:new u(t)}})}},function(e,t,r){"use strict";var n=r(2).flatten,i=r(2).identify;t.name="setIsSubset",t.factory=function(e,t,a,o){var s=a(r(30)),u=a(r(27)),c=a(r(29)),f=a(r(23)),l=a(r(31));return o("setIsSubset",{"Array | Matrix, Array | Matrix":function(e,t){if(0===f(c(e),new u(0)))return!0;if(0===f(c(t),new u(0)))return!1;for(var r,a=i(n(Array.isArray(e)?e:e.toArray()).sort(l)),o=i(n(Array.isArray(t)?t:t.toArray()).sort(l)),p=0;p<a.length;p++){r=!1;for(var h=0;h<o.length;h++)if(s(a[p].value,o[h].value)&&a[p].identifier===o[h].identifier){r=!0;break}if(!1===r)return!1}return!0}})}},function(e,t,r){"use strict";var n=r(2).flatten;t.name="setMultiplicity",t.factory=function(e,t,i,a){var o=i(r(30)),s=i(r(27)),u=i(r(29)),c=i(r(23));return a("setMultiplicity",{"number | BigNumber | Fraction | Complex, Array | Matrix":function(e,t){if(0===c(u(t),new s(0)))return 0;for(var r=n(Array.isArray(t)?t:t.toArray()),i=0,a=0;a<r.length;a++)o(r[a],e)&&i++;return i}})}},function(e,t,r){"use strict";var n=r(2).flatten;t.name="setPowerset",t.factory=function(e,t,i,a){var o=i(r(27)),s=i(r(29)),u=i(r(23)),c=i(r(31));return a("setPowerset",{"Array | Matrix":function(e){if(0===u(s(e),new o(0)))return[];for(var t=n(Array.isArray(e)?e:e.toArray()).sort(c),r=[],i=0;i.toString(2).length<=t.length;)r.push(f(t,i.toString(2).split("").reverse())),i++;return function(e){for(var t=[],r=e.length-1;r>0;r--)for(var n=0;n<r;n++)e[n].length>e[n+1].length&&(t=e[n],e[n]=e[n+1],e[n+1]=t);return e}(r)}});function f(e,t){for(var r=[],n=0;n<t.length;n++)"1"===t[n]&&r.push(e[n]);return r}}},function(e,t,r){"use strict";var n=r(2).flatten;t.name="setSize",t.factory=function(e,t,i,a){var o=i(r(30)),s=i(r(31));return a("setSize",{"Array | Matrix":function(e){return Array.isArray(e)?n(e).length:n(e.toArray()).length},"Array | Matrix, boolean":function(e,t){if(!1===t||0===e.length)return Array.isArray(e)?n(e).length:n(e.toArray()).length;for(var r=n(Array.isArray(e)?e:e.toArray()).sort(s),i=1,a=1;a<r.length;a++)o(r[a],r[a-1])||i++;return i}})}},function(e,t,r){"use strict";var n=r(2).flatten;t.name="setUnion",t.factory=function(e,t,i,a){var o=i(r(27)),s=i(r(64)),u=i(r(29)),c=i(r(23)),f=i(r(146)),l=i(r(147));return a("setUnion",{"Array | Matrix, Array | Matrix":function(e,t){if(0===c(u(e),new o(0)))return n(t);if(0===c(u(t),new o(0)))return n(e);var r=n(e),i=n(t);return s(l(r,i),f(r,i))}})}},function(e,t,r){e.exports=[r(510)]},function(e,t,r){"use strict";var n=r(1),i=r(3).sign;var a=.46875,o=.5641895835477563,s=[[3.1611237438705655,113.86415415105016,377.485237685302,3209.3775891384694,.18577770618460315],[.5641884969886701,8.883149794388377,66.11919063714163,298.6351381974001,881.952221241769,1712.0476126340707,2051.0783778260716,1230.3393547979972,2.1531153547440383e-8],[.30532663496123236,.36034489994980445,.12578172611122926,.016083785148742275,.0006587491615298378,.016315387137302097]],u=[[23.601290952344122,244.02463793444417,1282.6165260773723,2844.236833439171],[15.744926110709835,117.6939508913125,537.1811018620099,1621.3895745666903,3290.7992357334597,4362.619090143247,3439.3676741437216,1230.3393548037495],[2.568520192289822,1.8729528499234604,.5279051029514285,.06051834131244132,.0023352049762686918]],c=Math.pow(2,53);t.name="erf",t.factory=function(e,t,r,f){var l=f("erf",{number:function(e){var t=Math.abs(e);return t>=c?i(e):t<=a?i(e)*function(e){var t,r=e*e,n=s[0][4]*r,i=r;for(t=0;t<3;t+=1)n=(n+s[0][t])*r,i=(i+u[0][t])*r;return e*(n+s[0][3])/(i+u[0][3])}(t):t<=4?i(e)*(1-function(e){var t,r=s[1][8]*e,n=e;for(t=0;t<7;t+=1)r=(r+s[1][t])*e,n=(n+u[1][t])*e;var i=(r+s[1][7])/(n+u[1][7]),a=parseInt(16*e)/16,o=(e-a)*(e+a);return Math.exp(-a*a)*Math.exp(-o)*i}(t)):i(e)*(1-function(e){var t,r=1/(e*e),n=s[2][5]*r,i=r;for(t=0;t<4;t+=1)n=(n+s[2][t])*r,i=(i+u[2][t])*r;var a=r*(n+s[2][4])/(i+u[2][4]);a=(o-a)/e,r=parseInt(16*e)/16;var c=(e-r)*(e+r);return Math.exp(-r*r)*Math.exp(-c)*a}(t))},BigNumber:function(t){return new e.BigNumber(l(t.toNumber()))},"Array | Matrix":function(e){return n(e,l)}});return l.toTex={1:"erf\\left(${args[0]}\\right)"},l}},function(e,t,r){e.exports=[r(512),r(114),r(115),r(148),r(118),r(513),r(514),r(515),r(516),r(144),r(149)]},function(e,t,r){"use strict";var n=r(2).flatten;t.name="mad",t.factory=function(e,t,i,a){var o=i(r(28)),s=i(r(142)),u=i(r(148)),c=i(r(21)),f=a("mad",{"Array | Matrix":l,"...":function(e){return l(e)}});return f.toTex=void 0,f;function l(e){if(0===(e=n(e.valueOf())).length)throw new Error("Cannot calculate median absolute deviation of an empty array");var t=u(e);return u(s(e,function(e){return o(c(e,t))}))}}},function(e,t,r){"use strict";var n=r(2).flatten;t.name="mode",t.factory=function(e,t,r,i){return i("mode",{"Array | Matrix":a,"...":function(e){return a(e)}});function a(e){if(0==(e=n(e.valueOf())).length)throw new Error("Cannot calculate mode of an empty array");var t={},r=[],i=0;for(var a in e)e[a]in t||(t[e[a]]=0),t[e[a]]++,t[e[a]]==i?r.push(e[a]):t[e[a]]>i&&(i=t[e[a]],r=[e[a]]);return r}}},function(e,t,r){"use strict";var n=r(43);t.name="prod",t.factory=function(e,t,i,a){var o=i(r(22)),s=a("prod",{"Array | Matrix":u,"Array | Matrix, number | BigNumber":function(e,t){throw new Error("prod(A, dim) is not yet supported")},"...":function(e){return u(e)}});return s.toTex=void 0,s;function u(e){var t=void 0;if(n(e,function(e){t=void 0===t?e:o(t,e)}),void 0===t)throw new Error("Cannot calculate prod of an empty array");return t}}},function(e,t,r){"use strict";var n=r(3).isInteger,i=r(3).isNumber,a=r(2).flatten,o=r(48);t.name="quantileSeq",t.factory=function(e,t,s,u){var c=s(r(20)),f=s(r(12)),l=s(r(89)),p=s(r(52));function h(e,t,r){var n=a(e),o=n.length;if(0===o)throw new Error("Cannot calculate quantile of an empty sequence");if(i(t)){var s;if(0==(y=(s=t*(o-1))%1)){var u=r?n[s]:l(n,s);return m(u),u}var h=Math.floor(s);if(r)g=n[h],v=n[h+1];else{v=l(n,h+1),g=n[h];for(var d=0;d<h;++d)p(n[d],g)>0&&(g=n[d])}return m(g),m(v),c(f(g,1-y),f(v,y))}if((s=t.times(o-1)).isInteger())return s=s.toNumber(),u=r?n[s]:l(n,s),m(u),u;h=s.floor();var g,v,y=s.minus(h),x=h.toNumber();if(r)g=n[x],v=n[x+1];else for(v=l(n,x+1),g=n[x],d=0;d<x;++d)p(n[d],g)>0&&(g=n[d]);m(g),m(v);var w=new y.constructor(1);return c(f(g,w.minus(y)),f(v,y))}var m=u({"number | BigNumber | Unit":function(e){return e}});return function(t,r,a){var s,u,c;if(arguments.length<2||arguments.length>3)throw new SyntaxError("Function quantileSeq requires two or three parameters");if(o(t)){if("boolean"==typeof(a=a||!1)){if(u=t.valueOf(),i(r)){if(r<0)throw new Error("N/prob must be non-negative");if(r<=1)return h(u,r,a);if(r>1){if(!n(r))throw new Error("N must be a positive integer");var f=r+1;s=new Array(r);for(var l=0;l<r;)s[l]=h(u,++l/f,a);return s}}if(e.isBigNumber(r)){if(r.isNegative())throw new Error("N/prob must be non-negative");if(c=new r.constructor(1),r.lte(c))return h(u,r,a);if(r.gt(c)){if(!r.isInteger())throw new Error("N must be a positive integer");var p=r.toNumber();if(p>4294967295)throw new Error("N must be less than or equal to 2^32-1, as that is the maximum length of an Array");for(f=new e.BigNumber(p+1),s=new Array(p),l=0;l<p;)s[l]=h(u,new e.BigNumber(++l).div(f),a);return s}}if(Array.isArray(r)){for(s=new Array(r.length),l=0;l<s.length;++l){var m=r[l];if(i(m)){if(m<0||m>1)throw new Error("Probability must be between 0 and 1, inclusive")}else{if(!e.isBigNumber(m))throw new TypeError("Unexpected type of argument in function quantileSeq");if(c=new m.constructor(1),m.isNegative()||m.gt(c))throw new Error("Probability must be between 0 and 1, inclusive")}s[l]=h(u,m,a)}return s}throw new TypeError("Unexpected type of argument in function quantileSeq")}throw new TypeError("Unexpected type of argument in function quantileSeq")}throw new TypeError("Unexpected type of argument in function quantileSeq")}}},function(e,t,r){"use strict";t.name="std",t.factory=function(e,t,n,i){var a=n(r(50)),o=n(r(149)),s=i("std",{"Array | Matrix":u,"Array | Matrix, string":u,"...":function(e){return u(e)}});return s.toTex=void 0,s;function u(e,t){if(0==e.length)throw new SyntaxError("Function std requires one or more parameters (0 provided)");return a(o.apply(null,arguments))}}},function(e,t,r){e.exports=[r(99),r(518)]},function(e,t,r){"use strict";var n=r(9).isString,i=r(9).format;function a(e,t,r){return e.replace(/\$([\w\.]+)/g,function(e,a){for(var o=a.split("."),s=t[o.shift()];o.length&&void 0!==s;){var u=o.shift();s=u?s[u]:s+"."}return void 0!==s?n(s)?s:i(s,r):e})}t.name="print",t.factory=function(e,t,r,n){var i=n("print",{"string, Object":a,"string, Object, number | Object":a});return i.toTex=void 0,i}},function(e,t,r){e.exports=[r(520),r(150),r(521),r(522),r(523),r(524),r(525),r(526),r(527),r(528),r(529),r(530),r(531),r(532),r(533),r(534),r(535),r(536),r(537),r(538),r(539),r(540),r(541),r(542),r(543)]},function(e,t,r){"use strict";var n=r(1);t.name="acos",t.factory=function(e,t,r,i){var a=i("acos",{number:function(r){return r>=-1&&r<=1||t.predictable?Math.acos(r):new e.Complex(r,0).acos()},Complex:function(e){return e.acos()},BigNumber:function(e){return e.acos()},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\cos^{-1}\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);t.name="acot",t.factory=function(e,t,r,i){var a=i("acot",{number:function(e){return Math.atan(1/e)},Complex:function(e){return e.acot()},BigNumber:function(t){return new e.BigNumber(1).div(t).atan()},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\cot^{-1}\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);t.name="acoth",t.factory=function(e,t,r,i){var a=i("acoth",{number:function(r){return r>=1||r<=-1||t.predictable?isFinite(r)?(Math.log((r+1)/r)+Math.log(r/(r-1)))/2:0:new e.Complex(r,0).acoth()},Complex:function(e){return e.acoth()},BigNumber:function(t){return new e.BigNumber(1).div(t).atanh()},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\coth^{-1}\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);t.name="acsc",t.factory=function(e,t,r,i){var a=i("acsc",{number:function(r){return r<=-1||r>=1||t.predictable?Math.asin(1/r):new e.Complex(r,0).acsc()},Complex:function(e){return e.acsc()},BigNumber:function(t){return new e.BigNumber(1).div(t).asin()},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\csc^{-1}\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);t.name="acsch",t.factory=function(e,t,r,i){var a=i("acsch",{number:function(e){return e=1/e,Math.log(e+Math.sqrt(e*e+1))},Complex:function(e){return e.acsch()},BigNumber:function(t){return new e.BigNumber(1).div(t).asinh()},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\mathrm{csch}^{-1}\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);t.name="asec",t.factory=function(e,t,r,i){var a=i("asec",{number:function(r){return r<=-1||r>=1||t.predictable?Math.acos(1/r):new e.Complex(r,0).asec()},Complex:function(e){return e.asec()},BigNumber:function(t){return new e.BigNumber(1).div(t).acos()},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\sec^{-1}\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);t.name="asech",t.factory=function(e,t,i,a){a.find(i(r(150)),["Complex"]);var o=a("asech",{number:function(r){if(r<=1&&r>=-1||t.predictable){r=1/r;var n=Math.sqrt(r*r-1);return r>0||t.predictable?Math.log(n+r):new e.Complex(Math.log(n-r),Math.PI)}return new e.Complex(r,0).asech()},Complex:function(e){return e.asech()},BigNumber:function(t){return new e.BigNumber(1).div(t).acosh()},"Array | Matrix":function(e){return n(e,o)}});return o.toTex={1:"\\mathrm{sech}^{-1}\\left(${args[0]}\\right)"},o}},function(e,t,r){"use strict";var n=r(1);t.name="asin",t.factory=function(e,t,r,i){var a=i("asin",{number:function(r){return r>=-1&&r<=1||t.predictable?Math.asin(r):new e.Complex(r,0).asin()},Complex:function(e){return e.asin()},BigNumber:function(e){return e.asin()},"Array | Matrix":function(e){return n(e,a,!0)}});return a.toTex={1:"\\sin^{-1}\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);t.name="asinh",t.factory=function(e,t,r,i){var a=i("asinh",{number:Math.asinh||function(e){return Math.log(Math.sqrt(e*e+1)+e)},Complex:function(e){return e.asinh()},BigNumber:function(e){return e.asinh()},"Array | Matrix":function(e){return n(e,a,!0)}});return a.toTex={1:"\\sinh^{-1}\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);t.name="atan",t.factory=function(e,t,r,i){var a=i("atan",{number:function(e){return Math.atan(e)},Complex:function(e){return e.atan()},BigNumber:function(e){return e.atan()},"Array | Matrix":function(e){return n(e,a,!0)}});return a.toTex={1:"\\tan^{-1}\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";t.name="atan2",t.factory=function(e,t,n,i){var a=n(r(0)),o=n(r(24)),s=n(r(17)),u=n(r(136)),c=n(r(19)),f=n(r(18)),l=n(r(8)),p=n(r(6)),h=i("atan2",{"number, number":Math.atan2,"BigNumber, BigNumber":function(t,r){return e.BigNumber.atan2(t,r)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=u(e,t,h,!1);break;default:r=o(t,e,h,!0)}break;default:switch(t.storage()){case"sparse":r=s(e,t,h,!1);break;default:r=l(e,t,h)}}return r},"Array, Array":function(e,t){return h(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return h(a(e),t)},"Matrix, Array":function(e,t){return h(e,a(t))},"Matrix, number | BigNumber":function(e,t){var r;switch(e.storage()){case"sparse":r=c(e,t,h,!1);break;default:r=p(e,t,h,!1)}return r},"number | BigNumber, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,h,!0);break;default:r=p(t,e,h,!0)}return r},"Array, number | BigNumber":function(e,t){return p(a(e),t,h,!1).valueOf()},"number | BigNumber, Array":function(e,t){return p(a(t),e,h,!0).valueOf()}});return h.toTex={2:"\\mathrm{atan2}\\left(${args}\\right)"},h}},function(e,t,r){"use strict";var n=r(1);var i=Math.atanh||function(e){return Math.log((1+e)/(1-e))/2};t.name="atanh",t.factory=function(e,t,r,a){var o=a("atanh",{number:function(r){return r<=1&&r>=-1||t.predictable?i(r):new e.Complex(r,0).atanh()},Complex:function(e){return e.atanh()},BigNumber:function(e){return e.atanh()},"Array | Matrix":function(e){return n(e,o,!0)}});return o.toTex={1:"\\tanh^{-1}\\left(${args[0]}\\right)"},o}},function(e,t,r){"use strict";var n=r(1);t.name="cos",t.factory=function(e,t,r,i){var a=i("cos",{number:Math.cos,Complex:function(e){return e.cos()},BigNumber:function(e){return e.cos()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cos is no angle");return a(t.value)},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\cos\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);var i=Math.cosh||function(e){return(Math.exp(e)+Math.exp(-e))/2};t.name="cosh",t.factory=function(e,t,r,a){var o=a("cosh",{number:i,Complex:function(e){return e.cosh()},BigNumber:function(e){return e.cosh()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cosh is no angle");return o(t.value)},"Array | Matrix":function(e){return n(e,o)}});return o.toTex={1:"\\cosh\\left(${args[0]}\\right)"},o}},function(e,t,r){"use strict";var n=r(1);t.name="cot",t.factory=function(e,t,r,i){var a=i("cot",{number:function(e){return 1/Math.tan(e)},Complex:function(e){return e.cot()},BigNumber:function(t){return new e.BigNumber(1).div(t.tan())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cot is no angle");return a(t.value)},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\cot\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);function i(e){var t=Math.exp(2*e);return(t+1)/(t-1)}t.name="coth",t.factory=function(e,t,r,a){var o=a("coth",{number:i,Complex:function(e){return e.coth()},BigNumber:function(t){return new e.BigNumber(1).div(t.tanh())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function coth is no angle");return o(t.value)},"Array | Matrix":function(e){return n(e,o)}});return o.toTex={1:"\\coth\\left(${args[0]}\\right)"},o}},function(e,t,r){"use strict";var n=r(1);t.name="csc",t.factory=function(e,t,r,i){var a=i("csc",{number:function(e){return 1/Math.sin(e)},Complex:function(e){return e.csc()},BigNumber:function(t){return new e.BigNumber(1).div(t.sin())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csc is no angle");return a(t.value)},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\csc\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1),i=r(3).sign;function a(e){return 0==e?Number.POSITIVE_INFINITY:Math.abs(2/(Math.exp(e)-Math.exp(-e)))*i(e)}t.name="csch",t.factory=function(e,t,r,i){var o=i("csch",{number:a,Complex:function(e){return e.csch()},BigNumber:function(t){return new e.BigNumber(1).div(t.sinh())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csch is no angle");return o(t.value)},"Array | Matrix":function(e){return n(e,o)}});return o.toTex={1:"\\mathrm{csch}\\left(${args[0]}\\right)"},o}},function(e,t,r){"use strict";var n=r(1);t.name="sec",t.factory=function(e,t,r,i){var a=i("sec",{number:function(e){return 1/Math.cos(e)},Complex:function(e){return e.sec()},BigNumber:function(t){return new e.BigNumber(1).div(t.cos())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sec is no angle");return a(t.value)},"Array | Matrix":function(e){return n(e,a)}});return a.toTex={1:"\\sec\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);function i(e){return 2/(Math.exp(e)+Math.exp(-e))}t.name="sech",t.factory=function(e,t,r,a){var o=a("sech",{number:i,Complex:function(e){return e.sech()},BigNumber:function(t){return new e.BigNumber(1).div(t.cosh())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sech is no angle");return o(t.value)},"Array | Matrix":function(e){return n(e,o)}});return o.toTex={1:"\\mathrm{sech}\\left(${args[0]}\\right)"},o}},function(e,t,r){"use strict";var n=r(1);t.name="sin",t.factory=function(e,t,r,i){var a=i("sin",{number:Math.sin,Complex:function(e){return e.sin()},BigNumber:function(e){return e.sin()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sin is no angle");return a(t.value)},"Array | Matrix":function(e){return n(e,a,!0)}});return a.toTex={1:"\\sin\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);var i=Math.sinh||function(e){return(Math.exp(e)-Math.exp(-e))/2};t.name="sinh",t.factory=function(e,t,r,a){var o=a("sinh",{number:i,Complex:function(e){return e.sinh()},BigNumber:function(e){return e.sinh()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sinh is no angle");return o(t.value)},"Array | Matrix":function(e){return n(e,o,!0)}});return o.toTex={1:"\\sinh\\left(${args[0]}\\right)"},o}},function(e,t,r){"use strict";var n=r(1);t.name="tan",t.factory=function(e,t,r,i){var a=i("tan",{number:Math.tan,Complex:function(e){return e.tan()},BigNumber:function(e){return e.tan()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tan is no angle");return a(t.value)},"Array | Matrix":function(e){return n(e,a,!0)}});return a.toTex={1:"\\tan\\left(${args[0]}\\right)"},a}},function(e,t,r){"use strict";var n=r(1);var i=Math.tanh||function(e){var t=Math.exp(2*e);return(t-1)/(t+1)};t.name="tanh",t.factory=function(e,t,r,a){var o=a("tanh",{number:i,Complex:function(e){return e.tanh()},BigNumber:function(e){return e.tanh()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tanh is no angle");return o(t.value)},"Array | Matrix":function(e){return n(e,o,!0)}});return o.toTex={1:"\\tanh\\left(${args[0]}\\right)"},o}},function(e,t,r){e.exports=[r(545)]},function(e,t,r){"use strict";t.name="to",t.factory=function(e,t,n,i){var a=r(4),o=n(r(0)),s=n(r(8)),u=n(r(6)),c=i("to",{"Unit, Unit | string":function(e,t){return e.to(t)},"Matrix, Matrix":function(e,t){return s(e,t,c)},"Array, Array":function(e,t){return c(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return c(o(e),t)},"Matrix, Array":function(e,t){return c(e,o(t))},"Matrix, any":function(e,t){return u(e,t,c,!1)},"any, Matrix":function(e,t){return u(t,e,c,!0)},"Array, any":function(e,t){return u(o(e),t,c,!1).valueOf()},"any, Array":function(e,t){return u(o(t),e,c,!0).valueOf()}});return c.toTex={2:"\\left(${args[0]}"+a.operators.to+"${args[1]}\\right)"},c}},function(e,t,r){e.exports=[r(123),r(51),r(58),r(75),r(57),r(547),r(83),r(548),r(76)]},function(e,t,r){"use strict";var n=r(1);t.name="isPrime",t.factory=function(e,t,r,i){var a=i("isPrime",{number:function(e){if(e<2)return!1;if(2==e)return!0;if(e%2==0)return!1;for(var t=3;t*t<=e;t+=2)if(e%t==0)return!1;return!0},BigNumber:function(t){if(t.lt(2))return!1;if(t.equals(2))return!0;if(t.mod(2).isZero())return!1;for(var r=e.BigNumber(3);r.times(r).lte(t);r=r.plus(1))if(t.mod(r).isZero())return!1;return!0},"Array | Matrix":function(e){return n(e,a)}});return a}},function(e,t,r){"use strict";var n=r(1);r(3);t.name="isNaN",t.factory=function(e,t,r,i){return i("isNaN",{number:function(e){return Number.isNaN(e)},BigNumber:function(e){return e.isNaN()},Fraction:function(e){return!1},Complex:function(e){return e.isNaN()},Unit:function(e){return Number.isNaN(e.value)},"Array | Matrix":function(e){return n(e,Number.isNaN)}})}},function(e,t,r){e.exports=[r(550)]},function(e,t,r){"use strict";t.name="reviver",t.path="json",t.factory=function(e,t,r,n){return function(t,r){var n=e[r&&r.mathjs];return n&&"function"==typeof n.fromJSON?n.fromJSON(r):r}}},function(e,t,r){"use strict";var n=r(44),i=r(11),a=r(53);e.exports=[{name:"ArgumentsError",path:"error",factory:function(){return n}},{name:"DimensionError",path:"error",factory:function(){return i}},{name:"IndexError",path:"error",factory:function(){return a}}]}])});
//# sourceMappingURL=math.min.map