<?php


class WCS_Settings {

	function __construct(){

		add_action( 'admin_menu', array( $this, 'settings_page' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'load_assets' ) );

	}


	function load_assets(){

		$screen = get_current_screen();

		if( $screen->base !== 'class_page_wcs_settings' )
			return;

			wp_register_style( 'wcs-admin-element', 'https://unpkg.com/element-ui/lib/theme-default/index.css' );
			wp_register_style( 'wcs-settings', plugins_url() . '/weekly-class/assets/admin/css/settings.css', array( 'wcs-admin-element'  ), rand() );

      wp_register_script( 'wcs-admin-vue', 'https://cdnjs.cloudflare.com/ajax/libs/vue/2.4.4/vue.js', array( 'jquery' ), null, true );
      wp_register_script( 'wcs-admin-vue-resource', 'https://cdnjs.cloudflare.com/ajax/libs/vue-resource/1.3.4/vue-resource.js', array( 'wcs-admin-vue' ), null, true );
      wp_register_script( 'wcs-admin-moment', 'https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment.min.js', array( 'wcs-admin-vue' ), null, true );
      wp_register_script( 'wcs-admin-element', 'https://unpkg.com/element-ui/lib/index.js', array( 'wcs-admin-vue' ), null, true );
			wp_register_script( 'wcs-admin-element-locale-en', 'https://cdnjs.cloudflare.com/ajax/libs/element-ui/1.4.6/locale/en.min.js', array( 'wcs-admin-vue', 'wcs-admin-element' ), null, true );

			wp_register_script( 'wcs-settings', plugins_url() . '/weekly-class/assets/admin/js/min/settings-min.js', array( 'jquery', 'wp-color-picker', 'wcs-admin-vue-resource', 'wcs-admin-element', 'wcs-admin-element-locale-en' ), rand() );

      wp_localize_script( 'wcs-settings', 'EventsSchedule', array( 'rest_route' => esc_url_raw( get_rest_url() ), 'nonce' => wp_create_nonce( 'wp_rest' ) ) );



	}


	function settings_page(){
		add_submenu_page( 'edit.php?post_type=class', __( 'Events Schedule Settings', 'WeeklyClass' ), __( 'Settings', 'WeeklyClass' ), 'manage_options', 'wcs_settings', array( $this, 'settings_page_hook' ) );
	}

	function settings_page_hook(){

		wp_enqueue_style( 'wcs-settings' );
		wp_enqueue_script( 'wcs-settings' );

  	$templates 		= get_page_templates();
  	$templates		= array_merge( array( __('Default Page', 'WeeklyClass' ) => 'page', __('Single Page', 'WeeklyClass' ) => 'single' ), $templates );

		?>

		<div class="wrap wcs-settings">

			<div id="wcs-settings__app" v-cloak>
				<h1><?php _e( 'Events Schedule Settings', 'WeeklyClass' ) ?></h1>
				<el-form v-if="form" ref="form" :model="form" label-position="left" label-width="180px" class="wcs-settings-form" v-loading="loading">
					<el-tabs v-model="tabs">

						<el-tab-pane label="General" name="general">
							<el-form-item label="<?php _e( 'Event Single Page', 'WeeklyClass' ) ?>">
                <el-switch
                  v-model="form.wcs_single"
                  on-text="Yes"
                  off-text="No">
                </el-switch>
                <small><?php _e( 'Allow events to have a public single page', 'WeekylClass' ) ?>. <?php _e( 'Checking this field will allow visitors to view each event also as a separate page', 'WeeklyClass' ) ?></small>
              </el-form-item>

						</el-tab-pane>

            <el-tab-pane label="Event Page" name="single" v-if="form.wcs_single">

							<el-form-item label="<?php _e( 'Event Page Template', 'WeeklyClass' ) ?>">
                <el-select v-model="form.wcs_single_template" filterable placeholder="Select Template">
									<?php foreach( $templates as $key => $template ) : ?>
										<el-option label="<?php echo $key ?>" value="<?php echo $template ?>"></el-option>
									<?php endforeach; ?>
								</el-select>
							</el-form-item>

							<el-form-item label="<?php _e( 'Event Page Slug', 'WeeklyClass' ) ?>">
                <el-input v-model="form.wcs_slug" placeholder="Enter your event page slug here"></el-input>
                <small><?php _e( 'Default: class. This field cannot be empty', 'WeeklyClass' ) ?></small>
              </el-form-item>

							<el-form-item label="<?php _e( 'Events Box Position', 'WeeklyClass' ) ?>">
								<el-radio-group v-model="form.wcs_single_box">
								  <el-radio-button label="disabled">Disabled</el-radio-button>
								  <el-radio-button label="left">Left</el-radio-button>
								  <el-radio-button label="center">Center</el-radio-button>
								  <el-radio-button label="right">Right</el-radio-button>
								</el-radio-group>
							</el-form-item>

							<el-form-item label="<?php _e( 'Special Color', 'WeeklyClass' ) ?>">
								<el-color-picker v-model="form.wcs_single_color"></el-color-picker>
								<small><?php _e( 'This color will be used in the titles and on the background of the buttons', 'WeeklyClass' ) ?></small>
							</el-form-item>

							<el-form-item label="<?php _e( 'Date Format', 'WeeklyClass' ) ?>">
                <el-input v-model="form.wcs_dateformat" placeholder="Enter your date format here"></el-input>
                <small><?php _e( 'Default: F j @ H:i. Available date &amp; time formats available here: <a href="https://codex.wordpress.org/Formatting_Date_and_Time" target="_blank">WordPress Date Formatting</a>', 'WeeklyClass' ) ?></small>
              </el-form-item>

							<el-form-item label="<?php _e( '12h Time Format', 'WeeklyClass' ) ?>">
                <el-switch
                  v-model="form.wcs_time_format"
                  on-text="Yes"
                  off-text="No">
                </el-switch>
            	</el-form-item>

							<el-form-item v-if="form.wcs_single_box !== 'disabled'" label="<?php _e( 'Show Ending Time', 'WeeklyClass' ) ?>">
                <el-switch
                  v-model="form.wcs_single_ending"
                  on-text="Yes"
                  off-text="No">
                </el-switch>
            	</el-form-item>

							<el-form-item v-if="form.wcs_single_box !== 'disabled'" label="<?php _e( 'Show Duration', 'WeeklyClass' ) ?>">
                <el-switch
                  v-model="form.wcs_single_duration"
                  on-text="Yes"
                  off-text="No">
                </el-switch>
            	</el-form-item>

							<el-form-item v-if="form.wcs_single_box !== 'disabled'" label="<?php _e( 'Show Location', 'WeeklyClass' ) ?>">
                <el-switch
                  v-model="form.wcs_single_location"
                  on-text="Yes"
                  off-text="No">
                </el-switch>
            	</el-form-item>

							<el-form-item v-if="form.wcs_single_box !== 'disabled'" label="<?php _e( 'Show Instructor', 'WeeklyClass' ) ?>">
                <el-switch
                  v-model="form.wcs_single_instructor"
                  on-text="Yes"
                  off-text="No">
                </el-switch>
            	</el-form-item>

							<el-form-item v-if="form.wcs_single_box !== 'disabled'" label="<?php _e( 'Show Map', 'WeeklyClass' ) ?>">
                <el-switch
                  v-model="form.wcs_single_map"
                  on-text="Yes"
                  off-text="No">
                </el-switch>
            	</el-form-item>

						</el-tab-pane>
						<el-tab-pane label="Google Maps" name="google-maps">

							<el-form-item label="<?php _e( 'Google Maps API Key', 'WeeklyClass' ) ?>">
                <el-input v-model="form.wcs_api_key" placeholder="Enter your date Google API key here"></el-input>
                <small><?php _e( 'For optimal performances we recommend using your own Google Maps API Key. You can create one here: <a href="
https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">Generate API Key</a>', 'WeeklyClass' ) ?></small>
              </el-form-item>

							<el-form-item label="<?php _e( 'Map Theme', 'WeeklyClass' ) ?>">
								<el-radio-group v-model="form.wcs_single_map_theme">
								  <el-radio-button label="light"><?php _e( 'Light Theme', 'WeeklyClass' ) ?></el-radio-button>
								  <el-radio-button label="dark"><?php _e( 'Dark Theme', 'WeeklyClass' ) ?></el-radio-button>
								</el-radio-group>
							</el-form-item>

							<el-form-item label="<?php _e( 'Map Zoom Level', 'WeeklyClass' ) ?>">
                <el-slider
                  v-model="form.wcs_single_map_zoom"
                  :step="1" show-input :min="1" :max="18">
                </el-slider>
							</el-form-item>

							<el-form-item label="<?php _e( 'Map Type', 'WeeklyClass' ) ?>">
								<el-radio-group v-model="form.wcs_single_map_type">
								  <el-radio-button label="roadmap"><?php _e( 'Roadmap', 'WeeklyClass' ) ?></el-radio-button>
								  <el-radio-button label="satellite"><?php _e( 'Satellite', 'WeeklyClass' ) ?></el-radio-button>
								</el-radio-group>
							</el-form-item>
						</el-tab-pane>

						<el-tab-pane label="Advanced" name="advanced">
							<el-form-item label="<?php _e( 'Enable Lazy Load', 'WeeklyClass' ) ?>">
								<el-switch
									v-model="form.wcs_lazy_load"
									on-text="Yes"
									off-text="No">
								</el-switch>
								<small><?php _e( 'Checking this field will load the events after the pages has loaded. This can speed up the loading of your site and also can solve potential incompatibilities with other 3rd party plugins.', 'WeeklyClass' ) ?></small>
							</el-form-item>
						</el-tab-pane>

					</el-tabs>
					<el-form-item>
            <el-button type="primary" :disabled="loading" v-on:click="saveSettings()">Save Settings</el-button>
          </el-form-item>
				</elform>
			</div>

		</div>

		<?php

	}


}

new WCS_Settings();


?>
