/**
 * vertical layout mode
 */

( function( window, factory ) {
	// universal module definition
	/* jshint strict: false */ /*globals define, module, require */
	if ( typeof define == 'function' && define.amd ) {
		// AMD
		define(
			[
			'../layout-mode'
			],
			factory
		);
	} else if ( typeof module == 'object' && module.exports ) {
		// CommonJS
		module.exports = factory(
			require( '../layout-mode' )
		);
	} else {
		// browser global
		factory(
			window.Isotope.LayoutMode
		);
	}

}( window, function factory( LayoutMode ) {
	'use strict';

	var Vertical = LayoutMode.create(
		'vertical',
		{
			horizontalAlignment: 0
		}
	);

	var proto = Vertical.prototype;

	proto._resetLayout = function() {
		this.y = 0;
	};

	proto._getItemLayoutPosition = function( item ) {
		item.getSize();
		var x   = ( this.isotope.size.innerWidth - item.size.outerWidth ) *
		this.options.horizontalAlignment;
		var y   = this.y;
		this.y += item.size.outerHeight;
		return { x: x, y: y };
	};

	proto._getContainerSize = function() {
		return { height: this.y };
	};

	return Vertical;

}));
