; (function ($, window, document, envira_gallery) {

	/******* LIGHTBOX *********/

	$(document).on(
		'envirabox_api_after_show',
		function (e, obj, instance, current) {

			var envira_lb_image = $('div.envirabox-slide--current img.envirabox-image').attr('src'),
				envira_force_download = obj.get_config('download_lightbox_force') ? obj.get_config('download_lightbox_force') : obj.get_config('download_force'),
				envira_is_album = obj.images ? false : true,
				envira_gallery_id = envira_is_album ? current.gallery_id : obj.id,
				envira_gallery_album_id = envira_is_album ? obj.id : false,
				envira_gallery_item_id = current.enviraItemId !== undefined ? current.enviraItemId : current.id,
				is_dynamic = (obj.data.type !== undefined && obj.data.type == 'dynamic') || (obj.data.dynamic !== undefined && obj.data.dynamic !== '') ? true : false;

			envira_gallery_item_id = envira_is_album ? current.id : envira_gallery_item_id;

			if (envira_gallery_item_id === undefined || envira_gallery_item_id === false) {
				return;
			}

			/* new lb */
			$('.envirabox-inner').on(
				'click',
				'.envira-download-button a',
				function (e) {

					e.preventDefault();

					if (envira_force_download == '1' && envira_gallery_item_id !== undefined) {
						if ((typeof envira_gallery_item_id === 'string' || envira_gallery_item_id instanceof String) && envira_gallery_item_id.indexOf("folder_") !== false) {
							var url = location.protocol + '//' + location.host + location.pathname + '?envira-downloads-gallery-id=' + envira_gallery_id + '&envira-downloads-gallery-image=' + envira_lb_image;
						} else {
							var url = location.protocol + '//' + location.host + location.pathname + '?envira-downloads-gallery-id=' + envira_gallery_id + '&envira-downloads-gallery-image=' + envira_gallery_item_id;
						}
					} else {
						// Open Window
						var url = envira_lb_image = $('div.envirabox-slide--current img.envirabox-image').attr('src');
					}

					if (is_dynamic) {
						url = url + '&envira-dynamic=1';
					}

					if (envira_is_album) {
						url = url + '&envira-downloads-album-id=' + envira_gallery_album_id;
					}

					// If Password Protection is enabled, prompt for a password before sending it as part of the request
					if (envira_downloads.password_protection) {
						// Check if a cookie for this gallery ID already exists with a password
						if (is_dynamic) {
							var cookie_password = envira_downloads_get_cookie('envira_password_protection_download_dynamic');
						} else {
							var cookie_password = envira_downloads_get_cookie('envira_password_protection_download_' + envira_gallery_id);
						}
						if (cookie_password == '') {
							// Fallback to user requested password
							var password = prompt(envira_downloads.password_required);
							if (password == '') {
								return false;
							}
						} else {
							password = cookie_password;
						}

						if (password == null) {
							return false;
						}

						// Append password to URL
						url = envira_update_query_string_parameter(url, 'envira_password_protection_download', encodeURIComponent(password));

					}

					if (envira_force_download == '1') {
						window.open(url, '_self');
					} else {
						// Open Window
						window.open(url, '_blank');
					}

				}
			);

		}
	);

	function envira_update_query_string_parameter(uri, key, value) {
		var re = new RegExp("([?&])" + key + "=.*?(&|$)", "i");
		var separator = uri.indexOf('?') !== -1 ? "&" : "?";
		if (uri.match(re)) {
			return uri.replace(re, '$1' + key + "=" + value + '$2');
		}
		else {
			return uri + separator + key + "=" + value;
		}
	}

	/******* GALLERY *********/

	$('.envira-gallery-item').on(
		'click',
		'.envira-download-button a',
		function (e) {

			e.preventDefault();

			// Is this a dynamic gallery?
			if ($(this).closest('.envira-gallery-wrap').hasClass('envira-dynamic-gallery')) {
				// Gallery + Dynamic
				var gallery_id = 'dynamic';
				var url = $(this).attr('href');
				var is_dynamic = 'true';
			} else if ($(this).closest('.envirabox-wrap').hasClass('envira-dynamic-gallery')) {
				// Lightbox + Dynamic
				var image = $('img.envirabox-image').attr('src'),
					force_download = $(this).parent().attr('data-envira-downloads-force-download'),
					gallery_id = $('img.envirabox-image').data('envira-gallery-id'),
					gallery_item_id = $('img.envirabox-image').data('envira-item-id');

				var is_dynamic = 'true';

				// Build URL based on whether we're forcing a download or not
				if (force_download == '1') {
					url = location.protocol + '//' + location.host + location.pathname + '?envira-downloads-gallery-id=' + gallery_id + '&envira-downloads-gallery-image=' + gallery_item_id + '&envira-dynamic=1';
				} else {
					url = image;
				}
			} else if ($('.envirabox-container').css('display') == 'block') {
				// Get image based on whether we're in the lightbox or not
				// Lightbox
				var image = $('img.envirabox-image').attr('src'),
					force_download = $(this).parent().attr('data-envira-downloads-force-download'),
					gallery_id = $('.envirabox-container').data('envirabox-id'),
					gallery_item_id = $('img.envirabox-image').data('envira-item-id');

				// Build URL based on whether we're forcing a download or not
				if (force_download == '1') {
					url = location.protocol + '//' + location.host + location.pathname + '?envira-downloads-gallery-id=' + gallery_id + '&envira-downloads-gallery-image=' + gallery_item_id;
				} else {
					url = image;
				}
			} else {
				// Gallery
				var url = $(this).attr('href'),
					gallery_id = $(this).closest('.envira-gallery-public').attr('id').split('-')[2];
			}

			// If Password Protection is enabled, prompt for a password before sending it as part of the request
			if (envira_downloads.password_protection) {
				// Check if a cookie for this gallery ID already exists with a password
				if (is_dynamic) {
					var cookie_password = envira_downloads_get_cookie('envira_password_protection_download_dynamic');
				} else {
					var cookie_password = envira_downloads_get_cookie('envira_password_protection_download_' + gallery_id);
				}
				if (cookie_password == '') {
					// Fallback to user requested password
					var password = prompt(envira_downloads.password_required);
					if (password == '') {
						return false;
					}
				} else {
					password = cookie_password;
				}

				if (password == null) {
					return false;
				}

				// Append password to URL
				url += '&envira_password_protection_download=' + encodeURIComponent(password);

			}
			if (force_download == '1') {
				window.open(url, '_self');
			} else {

				// Open Window
				window.open(url, '_blank');

			}

			return false;
		}
	);

	$('.envira-gallery-wrap').on(
		'click',
		'a.envira-download-all',
		function (e) {

			e.preventDefault();

			// Get the URL from the link
			var url = $(this).attr('href');

			// Is this a dynamic gallery?
			if ($(this).closest('.envira-gallery-wrap').hasClass('envira-dynamic-gallery')) {
				var gallery_id = 'dynamic';
				var url = $(this).attr('href');
				var is_dynamic = 'true';
			} else if ($(this).data('gallery-id') !== undefined && $(this).data('gallery-id') != '') {
				var gallery_id = $(this).data('gallery-id');
			} else {
				// Extracting the gallery_id from the url ensures we are getting it correctly and not searching through the DOM
				var gallery_id = envira_downloads_getParameterByName('envira-downloads-gallery-id', url);
				if (gallery_id == null) {
					return false;
				}
			}

			// If Password Protection is enabled, prompt for a password before sending it as part of the request
			if (envira_downloads.password_protection) {
				// Check if a cookie for this gallery ID already exists with a password
				if (is_dynamic) {
					var cookie_password = envira_downloads_get_cookie('envira_password_protection_download_dynamic');
				} else {
					var cookie_password = envira_downloads_get_cookie('envira_password_protection_download_' + gallery_id);
				}
				if (cookie_password == '') {
					// Fallback to user requested password
					var password = prompt(envira_downloads.password_required);
					if (password == '') {
						return false;
					}
				} else {
					password = cookie_password;
				}

				if (password == null) {
					return false;
				}

				// Append password to URL
				url += '&envira_password_protection_download=' + password;
			}

			// Open Window
			window.open(url, '_self');
			return false;
		}
	);

	if (!$('div.envira-gallery-wrap').hasClass('envira-lightbox-theme-base_light') && !$('div.envira-gallery-wrap').hasClass('envira-lightbox-theme-base_dark')) {

		$(document).on(
			'mouseenter',
			'div.envira-gallery-item-inner',
			function () {
				$('div.envira-download-button', $(this)).fadeIn().css('display', 'inline-block');
			}
		);

		$(document).on(
			'mouseleave',
			'div.envira-gallery-item-inner',
			function () {
				$('div.envira-download-button', $(this)).hide();
			}
		);

	} else {

		$('div.envira-download-button', $(this)).fadeIn().css('display', 'inline-block');

	}

	/**
	 * Get a cookie by its name
	 *
	 * @since 1.0.0
	 *
	 * @param 	string 	cname 	Cookie Name
	 * @return 	string 			Cookie Value
	 */
	function envira_downloads_get_cookie(cname) {
		var name = cname + "=";
		var ca = document.cookie.split(';');
		for (var i = 0; i < ca.length; i++) {
			var c = ca[i];
			while (c.charAt(0) == ' ') {
				c = c.substring(1);
			}
			if (c.indexOf(name) == 0) {
				return c.substring(name.length, c.length);
			}
		}
		return "";
	}

	function envira_downloads_getParameterByName(name, url) {
		if (!url) {
			url = window.location.href;
		}
		name = name.replace(/[\[\]]/g, "\\$&");
		var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
			results = regex.exec(url);
		if (!results) {
			return null;
		}
		if (!results[2]) {
			return '';
		}
		return decodeURIComponent(results[2].replace(/\+/g, " "));
	}

})(jQuery, window, document, envira_gallery);
