jQuery( document ).ready( function( $ ) {

    /******* FANCYBOX *********/

    $(document).on( 'envirabox_api_after_show', function( e, obj, instance, current ){

		e.stopPropagation();

        if ( obj.get_config( 'lightbox_woocommerce' ) != 1 ) {
            return;
        }

		var envira_lb_image         = $( 'img.envirabox-image' ).attr( 'src' ),
            envira_gallery_id       = obj.id,
            envira_gallery_item_id  = current.enviraItemId;
        
        // Clear any divs from previous slides
        $('#envira-woocommerce').remove();

		// Append a fresh container to the DOM.
		var container = $( '<div id="envira-woocommerce"' + ( this.is_supersize ? ' class="envira-supersize"' : '' ) + '></div>' );
		container.prependTo( 'div.envirabox-stage div.envirabox-slide--current div.envirabox-image-wrap' );

        if ( envira_gallery_item_id === undefined || envira_gallery_item_id === false ) {
            return;
        }

		/**
		 * Get WooCommerce Add to Cart Form
		 */
		$.ajax( {
            url:      envira_woocommerce.ajax,
            type:     'post',
            data: {
                action:         'envira_woocommerce_get_add_to_cart_form',
                gallery_id:     envira_gallery_id,
                attachment_id:  envira_gallery_item_id,
                nonce:          envira_woocommerce.get_add_to_cart_form_nonce
            },
            success: function( response ) {

                // If WP_DEBUG enabled, output response data
                if ( envira_woocommerce.debug ) {
	                console.log( response );
                }

                // Check whether the request was truly successful.
                if ( ! response.success ) {
                    return;
                }

                // Check whether any data was returned.
                // If not, this means the attachment doesn't have a WooCommerce product assigned to it
                if ( response.data.length == 0 ) {
                    return;
                }

                // Output the WooCommerce Form

                container.append( response.data.woocommerce_form );

				var $form = $( '.envirabox-stage .variations_form' );

				// If the form exists,then rebind WooCommerce variation functions!
				if ( $form ) {
                    // we have to turn off triggering because Woo is nutty
                    $( window ).off( 'resize' );
                    $form.wc_variation_form();
                    // turning it back on
                    $( window ).on( 'resize' );
					$( '.envirabox-stage .variations_form .variations select' ).change();

                }

            },
            error: function( xhr, textStatus, e ) {

                // If WP_DEBUG enabled, output error details
                if ( envira_woocommerce.debug ) {
	                console.log( xhr );
					console.log( textStatus );
                    console.log( e );
                }

            }
        } );

        $('.envirabox-wrap').addClass('envirabox-woocommerce');

        $( '#envira-woocommerce' ).on( 'change', 'select', function( e ) {

            /* Prevent default action */
            e.preventDefault();

            if ( this.value != '' ) {
                $( 'a.reset_variations' ).css("visibility", "visible");
            }

        });

        $( '#envira-woocommerce' ).on( 'click', 'a.reset_variations', function( e ) {

            /* Prevent default action */
            e.preventDefault();

            $( '#envira-woocommerce select' ).val( '' ).change();
            $( 'a.reset_variations' ).css("visibility", "hidden");

        });

    });

	$(document).on('change', '.envirabox-wrap table.variations select', function( e ) {
		e.preventDefault();

		var all_selected = true;

		$(".envirabox-wrap table.variations select").each(function() {
			if ( $(this).find('option:selected').val() == '' ) {
				all_selected = false;
			}
		});

		if ( all_selected === false ) {
			return;
		}

		// get production varations stored in <form>
		var varations = $(this).closest( "form" ).data('product_variations');
		var chosen = new Array();
		var counter = 0;

		// get the current listings for the dropdowns
		$(".envirabox-wrap table.variations select").each(function() {
		    chosen[this.name] = new Array();
		    chosen[this.name][0] = this.value;
		    counter++;
		});

		var match = false;
		var counter = 0;
		var main_variation_id = 0;

		// now that we got the value, go through the varations for a match
		$.each( varations, function( key, varation_value ) {
			var variation_id = varation_value.variation_id;
			var match_counter = 0;
			$.each( varation_value.attributes, function( key, value ) {


				if ( chosen[key] == value ) {
					// console.log ('MATCH');
					match_counter++;
				}

			});

			if ( match_counter == $(".envirabox-wrap table.variations select").length ) {
				main_variation_id = variation_id;
				console.log ( 'main_variation_id:' + main_variation_id );
				match = true;
				return false;
			}

		});

		$(this).closest( "form" ).find('input[name="variation_id"]').val(main_variation_id);

	} );


} );

