<?php
/*
Plugin Name: Elfsight Google Maps CC
Description: Start creating Google Maps on your website with the incredible Elfsight map builder.
Plugin URI: https://elfsight.com/google-maps-widget/wordpress/?utm_source=markets&utm_medium=codecanyon&utm_campaign=google-maps&utm_content=plugin-site
Version: 1.2.0
Author: پرشین اسکریپت
Author URI: http://www.persianscript.ir
*/

if (!defined('ABSPATH')) exit;


require_once('core/elfsight-plugin.php');

$elfsight_google_maps_config_path = plugin_dir_path(__FILE__) . 'config.json';
$elfsight_google_maps_config = json_decode(file_get_contents($elfsight_google_maps_config_path), true);

new ElfsightPlugin(array(
        'name' => 'Google Maps',
        'description' => 'Start creating Google Maps on your website with the incredible Elfsight map builder.',
        'slug' => 'elfsight-google-maps',
        'version' => '1.2.0',
        'text_domain' => 'elfsight-google-maps',
        'editor_settings' => $elfsight_google_maps_config['settings'],
        'editor_preferences' => $elfsight_google_maps_config['preferences'],
        'script_url' => plugins_url('assets/elfsight-google-maps.js', __FILE__),

        'plugin_name' => 'Elfsight Google Maps',
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),

        'menu_icon' => plugins_url('assets/img/menu-icon.png', __FILE__),
        'update_url' => 'https://a.elfsight.com/updates/',

        'preview_url' => plugins_url('preview/index.html', __FILE__),
        'observer_url' => plugins_url('preview/google-maps-observer.js', __FILE__),

        'product_url' => 'https://codecanyon.net/item/elfsight-google-maps-wordpress-plugin/20574814?ref=Elfsight',
        'support_url' => 'https://elfsight.ticksy.com/submit/#100010647'
    )
);

?>