<?php

if (!defined('ABSPATH')) exit;


function elfsight_contact_form_shortcode_options_filter($options, $widget_id) {
	global $elfsight_contact_form_action_url;
	global $elfsight_contact_form_action_name;
	global $elfsight_contact_form_recaptcha;

	if (is_array($options)) {
		$options['actionUrl'] = $elfsight_contact_form_action_url;
		$options['actionName'] = $elfsight_contact_form_action_name;
        $options['recaptchaKeyCheckbox'] = $elfsight_contact_form_recaptcha['checkbox']['key'];
        $options['recaptchaKeyInvisible'] = $elfsight_contact_form_recaptcha['invisible']['key'];
        $options['widgetId'] = $widget_id;
	}

	return $options;
}
add_filter('elfsight_contact_form_shortcode_options', 'elfsight_contact_form_shortcode_options_filter', 10, 2);

function elfsight_contact_form_widget_options_filter($options_json) {
	$options = json_decode($options_json, true);

	if (is_array($options)) {
		unset($options['actionUrl']);
		unset($options['actionName']);
        unset($options['recaptchaKeyCheckbox']);
        unset($options['recaptchaKeyInvisible']);
        unset($options['widgetId']);
	}

	return json_encode($options);
}
add_filter('elfsight_contact_form_widget_options', 'elfsight_contact_form_widget_options_filter', null);
