<?php
/*
Plugin Name: Elfsight Contact Form CC
Description: Get more leads and feedback with easy-to-fill contact form
Plugin URI: https://elfsight.com/contact-form-widget/wordpress/?utm_source=markets&utm_medium=codecanyon&utm_campaign=contact-form&utm_content=plugin-site
Version: 2.1.0
Author: پرشین اسکریپت
Author URI: https://www.persianscript.ir
*/

if (!defined('ABSPATH')) exit;


$elfsight_contact_form_config_path = plugin_dir_path(__FILE__) . 'config.json';
$elfsight_contact_form_config = json_decode(file_get_contents($elfsight_contact_form_config_path), true);

$elfsight_contact_form_action_url = admin_url('admin-ajax.php');
$elfsight_contact_form_action_name = 'elfsight_contact_form_mail';
$elfsight_contact_form_recaptcha = array(
    'checkbox' => array(
        'key' => '6LfXGHgUAAAAAHNIE_EH7kEI1l4xvf_ynIlg5bfo',
        'secret' => '6LfXGHgUAAAAAGCmhNNDS2ml7XEPuVPAu_SR7PlO'
    ),
    'invisible' => array(
        'key' => '6Ld1CXgUAAAAAFTHmixC1Eo-NP7_3ddB1YOj9AfX',
        'secret' => '6Ld1CXgUAAAAAEHIphoU9Rl8HFNl7sv-XquN8zc4'
    )
);

if (is_array($elfsight_contact_form_config['settings'])) {
    array_push($elfsight_contact_form_config['settings']['properties'], array(
        'id' => 'actionUrl',
        'tab' => 'settings',
        'type' => 'hidden',
        'defaultValue' => $elfsight_contact_form_action_url
    ));

    array_push($elfsight_contact_form_config['settings']['properties'], array(
        'id' => 'actionName',
        'tab' => 'settings',
        'type' => 'hidden',
        'defaultValue' => $elfsight_contact_form_action_name
    ));

    array_push($elfsight_contact_form_config['settings']['properties'], array(
        'id' => 'recaptchaKeyCheckbox',
        'tab' => 'settings',
        'type' => 'hidden',
        'defaultValue' => $elfsight_contact_form_recaptcha['checkbox']['key']
    ));

    array_push($elfsight_contact_form_config['settings']['properties'], array(
        'id' => 'recaptchaKeyInvisible',
        'tab' => 'settings',
        'type' => 'hidden',
        'defaultValue' => $elfsight_contact_form_recaptcha['invisible']['key']
    ));

    foreach ($elfsight_contact_form_config['settings']['properties'] as $index => $property) {
        if (isset($property['id']) && $property['id'] === 'recaptchaType') {
            $elfsight_contact_form_config['settings']['properties'][$index]['selectInline'] = array(
                'options' => array(
                    array(
                        'value' => 'checkbox',
                        'name' => 'Checkbox'
                    ),
                    array(
                        'value' => 'invisible',
                        'name' => 'Invisible'
                    ),
                    array(
                        'value' => 'none',
                        'name' => 'None'
                    )
                )
            );
        }
    }
}

require_once('includes/filters.php');

require_once('core/elfsight-plugin.php');
require_once('includes/mail.php');

new ElfsightContactFormMail(
    array(
        'plugin_name' => 'Contact Form',
        'plugin_slug' => 'elfsight-contact-form',
        'recaptcha_secret_checkbox' => $elfsight_contact_form_recaptcha['checkbox']['secret'],
        'recaptcha_secret_invisible' => $elfsight_contact_form_recaptcha['invisible']['secret']
    )
);

new ElfsightContactFormPlugin(
    array(
        'name' => esc_html__('Contact Form'),
        'slug' => 'elfsight-contact-form',
        'description' => esc_html__('Get more leads and feedback with easy-to-fill contact form'),
        'version' => '2.1.0',
        'text_domain' => 'elfsight-contact-form',
        'editor_settings' => $elfsight_contact_form_config['settings'],
        'editor_preferences' => $elfsight_contact_form_config['preferences'],
        'script_url' => plugins_url('assets/elfsight-contact-form.js', __FILE__),

        'plugin_name' => esc_html__('Elfsight Contact Form'),
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),

        'menu_icon' => plugins_url('assets/img/menu-icon.png', __FILE__),
        'update_url' => esc_url('https://a.elfsight.com/updates/v1/'),

        'preview_url' => plugins_url('preview/index.html', __FILE__),
        'observer_url' => plugins_url('preview/contact-form-observer.js', __FILE__),

        'product_url' => esc_url('https://codecanyon.net/item/wp-contact-us-form-wordpress-contact-form-plugin/21638322?ref=Elfsight'),
        'support_url' => esc_url('https://elfsight.ticksy.com/submit/#100012053'),
    )
);

?>