(function() {
    "use strict";

    document.addEventListener('appReady.EappsContactForm', function() {
        var widgets = document.querySelectorAll('[data-elfsight-contact-form-options]');

        Array.prototype.slice.call(widgets).forEach(function(widget) {
            var version = widget.getAttribute('data-elfsight-contact-form-version');
            var options = widget.getAttribute('data-elfsight-contact-form-options');
            var data = JSON.parse(decodeURIComponent(options));

            window.eappsContactForm(widget, data);

            widget.removeAttribute('data-elfsight-contact-form-options');
            widget.removeAttribute('data-elfsight-contact-form-version');

            widget.data = {
                options: data,
                version: version
            };
        });
    });

    //= ../app/app/dist/contact-form.js
})();