<?php

namespace WilokeTeamMember\Share;

use stdClass;
use WP_Query;
use WP_User;

trait TraitHandleQuery
{
	public array     $aArgs           = [];
	protected string $regularPriceKey = '_regular_price';
	protected string $salePriceKey    = '_sale_price';
	protected array  $aDefineSizeImage
	                                  = [
			'thumbnail'    => 'small',
			'medium'       => 'medium',
			'medium_large' => 'large'
		];

	public function commonParseArgs(array $aRawArgs)
	{

		if (isset($aRawArgs['postNumber'])) {
			$this->aArgs['posts_per_page'] = (int)$aRawArgs['postNumber'];
		}
		if (isset($aRawArgs['orderBy'])) {
			$this->aArgs['orderBy'] = $aRawArgs['orderBy'];
		}
		if (isset($aRawArgs['order'])) {
			$this->aArgs['order'] = $aRawArgs['order'];
		}
		if (isset($aRawArgs['categories'])) {
			$this->aArgs['category__in'] = array_map(function ($id) {
				return (int)$id;
			}, $aRawArgs['categories']);
		}
		if (isset($aRawArgs['productFilter'])) {
			switch ($aRawArgs['productFilter']) {
				case 'onSale':
					$this->aArgs['meta_query'] = [
						[
							'key'     => '_sale_price',
							'value'   => 0,
							'compare' => '>',
							'type'    => 'numeric'
						]
					];
					break;
				case 'outOfStock':
					$this->aArgs['meta_query'] = [
						[
							'key'   => '_stock_status',
							'value' => 'outofstock'
						]
					];
					break;
				case 'inStock':
					$this->aArgs['meta_query'] = [
						[
							'key'     => '_stock_status',
							'value'   => 'outofstock',
							'compare' => '!='
						]
					];
					break;
				case 'categories':
					if (isset($aRawArgs['productCategories'])) {
						$aTermId = array_map(function ($id) {
							return (int)$id;
						}, $aRawArgs['productCategories']);
						$this->aArgs['tax_query'] = [
							[
								'taxonomy' => 'product_cat',
								'field'    => 'term_id',
								'terms'    => $aTermId,
								'operator' => 'IN'
							]
						];
					}
					break;
				case 'tags':
					if (isset($aRawArgs['productTags'])) {
						$aTermId = array_map(function ($id) {
							return (int)$id;
						}, $aRawArgs['productTags']);
						//product_tag
						$this->aArgs['tax_query'] = [
							[
								'taxonomy' => 'product_tag',
								'field'    => 'term_id',
								'terms'    => $aTermId,
								'operator' => 'IN'
							]
						];
					}
					break;
			}
		}

		$this->aArgs = wp_parse_args($this->aArgs, $this->defineArgs());
		return $this;
	}

	private function defineArgs(): array
	{
		return [
			'posts_per_page' => 20,
			'paged'          => 1,
			'orderby'        => 'ID',
			'order'          => 'DESC',
			'status'         => 'publish',
		];
	}

	public function handleSizeImageThumbnail($featuredImageId): array
	{
		$aImage = [];
		$aImageMetaData = wp_get_attachment_metadata($featuredImageId);
		if (isset($aImageMetaData['sizes'])) {
			$fullSizePath = get_attached_file($featuredImageId);
			$baseDir = str_replace(basename($fullSizePath), '', get_the_guid($featuredImageId));
			foreach ($this->aDefineSizeImage as $key => $value) {
				if (isset($aImageMetaData['sizes'][$key])) {
					$aImage[$value] = [
						'width'  => $aImageMetaData['sizes'][$key]['width'],
						'height' => $aImageMetaData['sizes'][$key]['height'],
						'src'    => $baseDir . $aImageMetaData['sizes'][$key]['file']
					];
				} else {
					$aImage[$value] = [
						'width'  => $aImageMetaData['width'],
						'height' => $aImageMetaData['height'],
						'src'    => home_url('/wp-content/uploads/') . $aImageMetaData['file']
					];
				}
			}
		}
		return $aImage;
	}

	public function query($type = 'post')
	{
		$aItems = [];
		if ($type == 'product') {
			$this->aArgs['post_type'] = 'product';
		}

		$oQuery = new WP_Query($this->aArgs);

		if ($oQuery->have_posts()) {
			while ($oQuery->have_posts()) {
				$oQuery->the_post();
				$postID = $oQuery->post->ID;
				switch ($type) {
					case 'product':
						$aFeaturedImage = [];
						$aGalleryImages = [];
						$aProductCat = [];
						$aDataProductCat = get_the_terms($postID, 'product_cat');
						$featuredImageId = get_post_meta($postID, '_thumbnail_id', true);
						$aGalleryImageId = !empty($galleryImageId = get_post_meta($postID, '_product_image_gallery',
							true))
							? explode(',', $galleryImageId) : [];

						if (isset($featuredImageId)) {
							$aFeaturedImage = $this->handleSizeImageThumbnail($featuredImageId);
						}

						if (!empty($aDataProductCat)) {
							foreach ($aDataProductCat as $aItem) {
								$aProductCat[] = [
									'id'    => $aItem->term_id,
									'name'  => $aItem->name,
									'slug'  => $aItem->slug,
									'count' => $aItem->count,
									'link'  => home_url('/product-category/' . $aItem->slug),
								];
							}
						}
						$oProduct = wc_get_product($postID);
						$ratingCount = $oProduct->get_rating_count() ?? 0;
						$reviewCount = $oProduct->get_review_count() ?? 0;
						$average = $oProduct->get_average_rating() ?? '0';

						if (isset($aGalleryImageId) && !empty($aGalleryImageId)) {
							foreach ($aGalleryImageId as $id) {
								$aGalleryImages[] = $this->handleSizeImageThumbnail($id);
							}
						}

						$aRawCommentsReview = get_comments([
							'post_type' => 'product',
							'post_id'   => $postID,
							'status'    => 'approve',
							'type'      => 'review'
						]);
						if (!empty($aRawCommentsReview)) {
							$aItemsComment = [];
							foreach ($aRawCommentsReview as $oItemComment) {
								$aItemsComment[] = [
									'commentID'          => $oItemComment->comment_ID,
									'commentPostID'      => $oItemComment->comment_post_ID,
									'commentAuthor'      => $oItemComment->comment_author,
									'commentAuthorEmail' => $oItemComment->comment_author_email,
									'commentDate'        => $oItemComment->comment_date,
									'commentDateGmt'     => $oItemComment->comment_date_gmt,
									'commentContent'     => $oItemComment->comment_content
								];
							}
						}
						if (empty($aItemsComment)) {
							$aItemsComment = new stdClass();
						}

						$aHTMLPrice = [
							wc_price((float)get_post_meta($postID, $this->regularPriceKey,
								true)),
							wc_price((float)get_post_meta($postID, $this->salePriceKey,
								true)),
						];

						$aAmountPrice = [
							(float)get_post_meta($postID, $this->regularPriceKey, true),
							(float)get_post_meta($postID, $this->salePriceKey, true),
						];

						$inWishList = false;
						if (function_exists('YITH_WCWL')) {
							$inWishList = YITH_WCWL()->is_product_in_wishlist($postID);
						}
						$aItems[] = [
							'id'            => $postID,
							'title'         => $oQuery->post->post_title,
							'slug'          => $oQuery->post->post_name,
							'link'          => get_permalink($postID),
							'content'       => get_the_content($postID),
							'createDate'    => $oQuery->post->post_date,
							'categories'    => $aProductCat,
							'featuredImage' => $aFeaturedImage,
							'galleryImages' => $aGalleryImages,
							'outOfStock'    => ProductMetaWoocommerce::isProductOutOfStock($postID),
							'onSale'        => ProductMetaWoocommerce::isProductOnSale($postID),
							'sku'           => ProductMetaWoocommerce::getProductSKU($postID),
							'price'         => $aHTMLPrice,
							'amountPrice'   => $aAmountPrice,
							'inWishList'    => $inWishList,
							'reviews'       => [
								'ratingCount' => $ratingCount,
								'reviewCount' => $reviewCount,
								'average'     => $average,
								'items'       => $aItemsComment,
							]
						];
						break;
					default:
						$aComments = [];
						$aCategories = [];
						$aPostComments = get_comments([
							'number'  => 10,
							'status'  => 'approve',
							'type'    => 'comment',
							'post_id' => $postID
						]);
						$aRawCategories = get_the_category($postID);
						if (!empty($aPostComments)) {
							foreach ($aPostComments as $aPostComment) {
								$aComments[] = [
									'id'           => $aPostComment->comment_ID,
									'content'      => $aPostComment->comment_content,
									'createDate'   => $aPostComment->comment_date,
									'modifiedDate' => $aPostComment->comment_date_gmt,
									'authorName'   => $aPostComment->comment_author,
									'authorIP'     => $aPostComment->comment_author_IP,
									'authorUrl'    => $aPostComment->comment_author_url,
									'authorEmail'  => $aPostComment->comment_author_email
								];
							}
						}
						if (!empty($aRawCategories)) {
							foreach ($aRawCategories as $aCategory) {
								$aCategories[] = [
									'id'    => $aCategory->term_id,
									'name'  => $aCategory->name,
									'count' => $aCategory->count,
									'slug'  => $aCategory->slug,
									'link'  => home_url('/category/' . $aCategory->slug),
								];
							}
						}
						$oUser = new WP_User($oQuery->post->post_author);
						$thumbnail_id = get_post_meta($postID,'_thumbnail_id',true);
						$aItems[] = [
							'id'           => (string)$postID,
							'content'      => get_the_content($postID),
							'title'        => get_the_title($postID),
							'slug'         => $oQuery->post->post_name,
							'excerpt'      => $oQuery->post->post_excerpt,
							'createDate'   => $oQuery->post->post_date,
							'modifiedDate' => $oQuery->post->post_modified,
							'link'         => $oQuery->post->guid,
							'comments'     => $aComments,
							'categories'   => $aCategories,
							'author'       => [
								'id'             => $oUser->ID,
								'authorName'     => $oUser->display_name,
								'authorEmail'    => $oUser->user_email,
								'authorNiceName' => $oUser->user_nicename,
								'authorUrl'      => $oUser->user_url,
								'roles'          => $oUser->roles,
								'avatar'         => esc_url(get_avatar_url($oUser->ID)),
							],
							'status'       => get_post_status($postID),
							'image'        => $this->handleSizeImageThumbnail($thumbnail_id)
						];
						break;
				}
			}
		}
		wp_reset_postdata();
		return $aItems;
	}

}