jQuery(document).ready(function ($) {
  'use strict';
  let productControl = elementor.modules.controls.BaseData.extend({
    onReady: function () {
      this.postNumber = this.$el.find('#wil-products-number');
      this.productCategories = this.$el.find('#wil-product-categories-ids');
      this.productTags = this.$el.find('#wil-product-tags-ids');
      this.orderBy = this.$el.find('#wil-product-order-by');
      this.productFilter = this.$el.find('#wil-filter-product');
      this.order = this.$el.find('#wil-product-order');
      this.postID = this.$el.find('#wil-product-id');

      this.initCategory();
      this.initTags();
      this.productCategories.on('change', () => {
        this.saveValue();
      });
      this.productTags.on('change', () => {
        this.saveValue();
      });
      this.productFilter.on('change', () => {
        let productFilter = this.productFilter.val();
        switch (productFilter) {
          case 'tags':
            this.$el.find('#wil-tag-product-hidden').removeClass('wil-hidden');
            this.$el.find('#wil-categories-product-hidden').addClass('wil-hidden');
            break;
          case 'categories':
            this.$el.find('#wil-categories-product-hidden').removeClass('wil-hidden');
            this.$el.find('#wil-tag-product-hidden').addClass('wil-hidden');
            break;
          default:
            this.$el.find('#wil-categories-product-hidden').addClass('wil-hidden');
            this.$el.find('#wil-tag-product-hidden').addClass('wil-hidden');
            break;
        }
        this.saveValue();
      });

      this.postNumber.on('change', () => {
        this.saveValue();
      });
      this.orderBy.on('change', () => {
        this.saveValue();
      });
      this.order.on('change', () => {
        this.saveValue();
      });
      this.saveValue();
    },

    saveValue: function () {
      $.ajax({
        url: ajaxurl,
        data: {
          action: WilokeTeamMember.prefix + '_custom_wil_product_save_value',
          payload: {
            postID: this.postID.val(),
            postNumber: this.postNumber.val(),
            productCategories: this.productCategories.select2().val(),
            productTags: this.productTags.select2().val(),
            productFilter: this.productFilter.val(),
            orderBy: this.orderBy.val(),
            order: this.order.val(),
          },
        },
        type: 'post',
        dataType: 'text',
        success: data => {
          let response = JSON.parse(data);
          this.setValue(response.data);
        },
      });
      this.initCategory();
      this.initTags();
    },
    initCategory: function () {
      this.productCategories.select2({
        ajax: {
          url: ajaxurl,
          type: 'GET',
          data: {
            action: WilokeTeamMember.prefix + '_custom_wil_product_categories',
          },
          dataType: 'json',
          processResults: function (data) {
            return {
              results: data,
            };
          },
        },
      });
    },
    initTags: function () {
      this.productTags.select2({
        ajax: {
          url: ajaxurl,
          type: 'GET',
          data: {
            action: WilokeTeamMember.prefix + '_custom_wil_product_tags',
          },
          dataType: 'json',
          processResults: function (data) {
            return {
              results: data,
            };
          },
        },
      });
    },

    onBeforeDestroy: function () {
      this.saveValue();
      $.ajax({
        url: ajaxurl,
        data: {
          action: WilokeTeamMember.prefix + '_custom_wil_product_delete_value',
          payload: {
            postID: this.postID.val(),
          },
        },
        type: 'post',
        dataType: 'text',
        success: data => {},
      });
    },
  });
  elementor.addControlView('wil-product', productControl);
});