<?php

namespace WilokeTeamMember\Controllers\PostControl;

use Elementor\Base_Control;
use WilokeTeamMember\Share\TraitHandleCustomPost;

class CustomPostControl extends Base_Control
{
	use TraitHandleCustomPost;

	public function getFieldsOrderBy(): array
	{
		return [
			'ID'            => esc_attr__('ID', 'wil-team-member'),
			'author'        => esc_attr__('Author', 'wil-team-member'),
			'title'         => esc_attr__('Title', 'wil-team-member'),
			'date'          => esc_attr__('Date', 'wil-team-member'),
			'menu_order'    => esc_attr__('Menu Order', 'wil-team-member'),
			'rand'          => esc_attr__('Random', 'wil-team-member'),
			'comment_count' => esc_attr__('Comment Count', 'wil-team-member'),
		];
	}

	public function getFieldsOrder(): array
	{
		return [
			'desc' => esc_attr__('DESC', 'wil-team-member'),
			'asc'  => esc_attr__('ASC', 'wil-team-member')
		];
	}

	public function get_type()
	{
		return 'wil-post';
	}

	public function enqueue()
	{
		wp_register_script(WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_post_script',
			WILOKE_WILOKETEAMMEMBER_VIEWS_URL . 'src/Controllers/PostControl/CustomPostControl.js',
			['jquery'],
			WILOKE_WILOKETEAMMEMBER_VERSION,
			true);
		wp_register_style(
			WILOKE_WILOKETEAMMEMBER_NAMESPACE . md5('wiloke-style'),
			WILOKE_WILOKETEAMMEMBER_VIEWS_URL . 'src/Assets/Style/Style.css',
			[],
			WILOKE_WILOKETEAMMEMBER_VERSION);
		wp_localize_script('jquery', 'WilokeTeamMember', [
			'prefix' => WILOKE_WILOKETEAMMEMBER_NAMESPACE
		]);
		wp_enqueue_style(WILOKE_WILOKETEAMMEMBER_NAMESPACE . md5('wiloke-style'));
		wp_enqueue_script(WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_post_script');
	}

	public function content_template()
	{
		$postID = (int)$_GET['post'];
		$aData = $this->getFieldsData($postID);
		$orderBy = $aData['orderBy'] ?? "{{{data.default.orderby}}}" ?? 'ID';
		$order = $aData['order'] ?? "{{{data.default.order}}}" ?? 'desc';
		$postNumber = $aData['postNumber'] ?? "{{{data.default.limit}}}" ?? 20;
		$aCategories = [];
		if (isset($aData['categories']) && !empty($aData['categories'])) {
			foreach ($aData['categories'] as $categoryID) {
				$aCategories[$categoryID] = get_cat_name($categoryID);
			}
		}
		?>
        <div class="elementor-control elementor-control-type-divider elementor-label-inline elementor-control-separator-none">
            <div class="elementor-control-content">
            </div>
        </div>
        <label for="elementor-control-default-c1218" class="elementor-control-title wil-margin-bottom-15">{{{ data.label
            }}}</label>

        <# if ( data.description ) { #>
        <div class="elementor-control-field-description">{{{ data.description }}}</div>
        <# } #>
        <br>
        <div class="elementor-control-field">
            <input id="wil-post-id" type="hidden" name="wilPostId" value="<?php echo esc_attr($_GET['post'] ?? 0); ?>">
            <label class="elementor-control-title"><?php echo esc_html__('Categories', 'wil-team-member') ?></label>

            <div class="elementor-control-input-wrapper elementor-control-unit-5">
                <select multiple class="post-select wil-width-100" name="wil-categories" id="wil-categories-ids">
					<?php
					if (!empty($aCategories)) {
						foreach ($aCategories as $key => $name):
							?>
                            <option value="<?php echo esc_attr($key); ?>" selected="selected">
								<?php echo esc_html($name); ?></option>
						<?php
						endforeach;
					}
					?>
                </select>
            </div>
        </div>
        <br>
        <div class="elementor-control-field">

            <label for="elementor-control-default-c1218"
                   class="elementor-control-title"><?php echo esc_html__('Number Post',
					'wil-team-member'); ?></label>

            <div class="elementor-control-input-wrapper elementor-control-unit-5">
                <input id="wil-post-number"
                       type="number"
                       name="postNumber"
                       value="<?php echo esc_attr($postNumber); ?>">
            </div>
        </div>
        <br>
        <div class="elementor-control-field">

            <label class="elementor-control-title"><?php echo esc_html__('Order By', 'wil-team-member'); ?></label>

            <div class="elementor-control-input-wrapper elementor-control-unit-5">
                <select id="wil-order-by" name="wil-order-by" class="wil-width-100">
					<?php foreach ($this->getFieldsOrderBy() as $key => $value): ?>
                        <option <?php echo esc_attr($key == $orderBy ? 'selected' : ''); ?>
                                value="<?php echo esc_attr($key); ?>">
							<?php echo esc_html($value); ?>
                        </option>
					<?php endforeach; ?>
                </select>
            </div>
        </div>
        <br>
        <div class="elementor-control-field">

            <label class="elementor-control-title"><?php echo esc_html__('Order', 'wil-team-member'); ?></label>

            <div class="elementor-control-input-wrapper elementor-control-unit-5">
                <select id="wil-order" name="wil-order" class="wil-width-100">
					<?php foreach ($this->getFieldsOrder() as $key => $value): ?>
                        <option <?php echo esc_attr($key == $order ? 'selected' : ''); ?>
                                value="<?php echo esc_attr($key); ?>">
							<?php echo esc_html($value); ?>
                        </option>
					<?php endforeach; ?>
                </select>
            </div>
        </div>
        <br>
        <div class="elementor-control elementor-control-type-divider elementor-label-inline elementor-control-separator-none">
            <div class="elementor-control-content">
            </div>
        </div>
		<?php

	}
}