jQuery(document).ready(function ($) {
  'use strict';

  let postSelectControl = elementor.modules.controls.BaseData.extend({
    onReady: function () {
      this.postNumber = this.$el.find('#wil-post-number');
      this.categories = this.$el.find('#wil-categories-ids');
      this.orderBy = this.$el.find('#wil-order-by');
      this.order = this.$el.find('#wil-order');
      this.postID = this.$el.find('#wil-post-id');

      this.categories.on('change', () => {
        this.saveValue();
        this.initCategory();
      });
      this.postNumber.on('change', () => {
        this.saveValue();
        this.initCategory();
      });
      this.orderBy.on('change', () => {
        this.saveValue();
        this.initCategory();
      });
      this.order.on('change', () => {
        this.saveValue();
        this.initCategory();
      });

      $.ajax({
        url: ajaxurl,
        data: {
          action: WilokeTeamMember.prefix + '_custom_wil_post',
        },
        dataType: 'json',
        success: data => {
          this.initCategory(data);
        },
        error: function (jqXHR, error) {
          console.log(error);
        },
      });
      this.saveValue();
    },

    saveValue: function () {
      $.ajax({
        url: ajaxurl,
        data: {
          action: WilokeTeamMember.prefix + '_custom_wil_post_save_value',
          payload: {
            postID: this.postID.val(),
            postNumber: this.postNumber.val(),
            categories: this.categories.select2().val(),
            orderBy: this.orderBy.val(),
            order: this.order.val(),
          },
        },
        type: 'post',
        dataType: 'text',
        success: data => {
          let response = JSON.parse(data);
          this.setValue(response.data);
        },
      });
    },
    initCategory: function (initialData) {
      this.categories.select2({
        data: initialData,
        ajax: {
          url: ajaxurl,
          data: function (params) {
            return {
              q: params.term, // search term
              page: params.page,
              action: WilokeTeamMember.prefix + '_custom_wil_post',
            };
          },
          dataType: 'json',
          processResults: function (data, params) {
            params.page = params.page || 1;
            return {
              results: data,
              pagination: {
                more: params.page * 30 < data.length,
              },
            };
          },
        },
      });
    },

    onBeforeDestroy: function () {
      this.saveValue();
      $.ajax({
        url: ajaxurl,
        data: {
          action: WilokeTeamMember.prefix + '_custom_wil_post_delete_value',
          payload: {
            postID: this.postID.val(),
          },
        },
        type: 'post',
        dataType: 'text',
        success: data => {},
      });
    },
  });

  elementor.addControlView('wil-post', postSelectControl);
});