<?php

namespace ElementPack\Modules\HoverVideo\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;       
use Elementor\Utils;

use ElementPack\Modules\HoverVideo\Skins;
use Elementor\Modules\DynamicTags\Module as TagsModule;

if (!defined('ABSPATH')) {
    exit();
}

// Exit if accessed directly
class Hover_Video extends Widget_Base
{

    public function get_name()
    {
        return 'bdt-hover-video';
    }

    public function get_title()
    {
        return BDTEP . esc_html__('Hover Video', 'bdthemes-element-pack');
    }

    public function get_icon()
    {
        return 'bdt-wi-hover-video';
    }

    public function get_categories()
    {
        return [
            'element-pack',
        ];
    }

    public function get_keywords()
    {
        return ['hover', 'insta', 'video', 'player'];
    }

    public function get_style_depends()
    {
        return ['ep-hover-video'];
    }

    public function get_script_depends()
    {
        return ['ep-hover-video'];
    }

    // public function get_custom_help_url()
    // {
    //     return 'https://youtu.be/PIQ6BJtNpNU';
    // }
    
    public function _register_skins() {
        $this->add_skin( new Skins\Skin_Accordion( $this ) );
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_layouts',
            [
                'label' => esc_html__('Hover Video', 'element-pack'),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
			'source_type',
			[
				'label'       => esc_html__( 'Video Type', 'bdthemes-element-pack' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'remote_url',
				'label_block' => true,
				'options'     => [
					'remote_url' => esc_html__( 'Remote Video', 'bdthemes-element-pack' ),
					'hosted_url' => esc_html__( 'Local Video', 'bdthemes-element-pack' ),
				],
			]
		);

		$repeater->add_control(
			'remote_url',
			[
				'type'          => Controls_Manager::URL,
				'label'         => __( 'Video Source', 'bdthemes-element-pack' ),
				'label_block'   => true,
				'show_external' => false,
				'placeholder'   => __( 'https://exmaple.com/sample.mp4', 'bdthemes-element-pack' ),
				'dynamic'       => [ 'active' => true ],
				'condition'     => [
					'source_type' => 'remote_url',
				],
			]
		);

		$repeater->add_control(
			'hosted_url',
			[
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [
					'active'     => true,
					'categories' => [
						TagsModule::POST_META_CATEGORY,
						TagsModule::MEDIA_CATEGORY,
					],
				],
				'media_type' => 'video',
				'condition' => [
					'source_type' => 'hosted_url'
				],
			]
		);

        $repeater->add_control(
            'hover_video_poster',
            [
                'label'       => __('Video Poster', 'bdthemes-element-pack'),
                'type'        => Controls_Manager::MEDIA,
                'dynamic'     => [
                    'active' => true,
                ],
                'label_block' => true,
                
            ]
        );

        $repeater->add_control(
            'hover_video_title',
            [
                'label'       => __('Title', 'bdthemes-element-pack'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __('Title Item', 'bdthemes-element-pack'),
                'default'     => __('Title Item', 'bdthemes-element-pack'),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'hover_item_icon_type',
            [
                'label'        => esc_html__('Icon Type', 'bdthemes-element-pack'),
                'type'         => Controls_Manager::CHOOSE,
                'toggle'       => false,
                'default'      => 'icon',
                'prefix_class' => 'bdt-icon-type-',
                'render_type'  => 'template',
                'options'      => [
                    'icon' => [
                        'title' => esc_html__('Icon', 'bdthemes-element-pack'),
                        'icon'  => 'fas fa-star'
                    ],
                    'image' => [
                        'title' => esc_html__('Image', 'bdthemes-element-pack'),
                        'icon'  => 'far fa-image'
                    ]
                ]
            ]
        );

        $repeater->add_control(
            'hover_item_icon',
            [
                'label'            => __( 'Icon', 'bdthemes-element-pack' ),
                'type'             => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'condition'        => [
                    'hover_item_icon_type' => 'icon',
                ]
            ]
        );

        $repeater->add_control(
            'hover_selected_image',
            [
                'label'       => __( 'Image Icon', 'bdthemes-element-pack' ),
                'type'        => Controls_Manager::MEDIA,
                'render_type' => 'template',
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'hover_item_icon_type' => 'image'
                ]
            ]
        );

        

        $this->add_control(
            'hover_video_list',
            [
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'hover_video_title'   => 'DUAL-LENS 360',
                        'hover_item_icon'  => ['value' => 'far fa-laugh', 'library' => 'fa-regular'],
                    ],
                    [
                        'hover_video_title'   => '4K WIDE ANGLE',
                        'hover_item_icon'  => ['value' => 'far fa-laugh', 'library' => 'fa-regular'],
                    ],
                    [
                        'hover_video_title'   => '4K WIDE ANGLE',
                        'hover_item_icon'  => ['value' => 'far fa-laugh', 'library' => 'fa-regular'],

                    ],
                ],
                'title_field' => '{{{ hover_video_title }}}',
            ]
        );

        $this->add_responsive_control(
            'hover_video_height',
            [
                'label'     => __('Video Height', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 200,
                        'max' => 1000,
                    ],
                ], 
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-wrapper-list' => 'height: {{SIZE}}{{UNIT}};', 
                ],
                'separator' => 'before'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_additional',
            [
                'label' => esc_html__('Additional', 'element-pack'),
            ]
        );



        $this->add_control(
            'progress_visibility',
            [
                'label' => __('Show Progress', 'bdthemes-element-pack'),
                'type'  => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'icon_visibility',
            [
                'label' => __('Show Icon', 'bdthemes-element-pack'),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );


        $this->add_control(
            'video_preload',
            [
                'label'   => __('Video Preload', 'bdthemes-element-pack'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

           // preload="none"


        $this->end_controls_section();

        $this->start_controls_section(
            'hover_video',
            [
                'label' => __('Video', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'hover_video_border',
                'label'    => esc_html__('Border', 'bdthemes-element-pack'),
                'selector' => '{{WRAPPER}} .bdt-hover-video .bdt-hover-wrapper-list video',
            ]
        );

        $this->add_responsive_control(
            'hover_video_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-wrapper-list video' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
           Group_Control_Box_Shadow::get_type(),
           [
            'name'     => 'hover_video_shadow',
            'selector' => '{{WRAPPER}} .bdt-hover-video .bdt-hover-wrapper-list video'
        ]
    );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name'      => 'hover_video_css_filters',
                'selector'  => '{{WRAPPER}} .bdt-hover-video .bdt-hover-wrapper-list video',
            ]
        );

 
        $this->add_responsive_control(
            'hover_video_spacing',
            [
                'label'     => __('Spacing', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ], 
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-wrapper-list' => 'margin-bottom: {{SIZE}}{{UNIT}};', 
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'hover_progress_style',
            [
                'label'     => __('Progress', 'bdthemes-element-pack'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'progress_visibility' => ['yes'],
                ]
            ]
        );


        $this->add_control(
            'hover_progress_bg',
            [
                'label'     => __('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-bar-list .bdt-hover-bar-wrapper .bdt-hover-bar' => 'background-color: {{VALUE}}',

                ],
            ]
        );

        $this->add_control(
            'hover_progress_fill',
            [
                'label'     => __('Fill Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-bar-list .bdt-hover-bar-wrapper .bdt-hover-bar .bdt-hover-progress' => 'background-color: {{VALUE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            'hover_progress_height',
            [
                'label'     => __('Height', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 20,
                    ],
                ], 
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-bar-list .bdt-hover-bar-wrapper .bdt-hover-bar' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-bar-list .bdt-hover-bar-wrapper .bdt-hover-bar .bdt-hover-progress'  => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'hover_progress_width',
            [
                'label'     => __('Width', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ], 
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-bar-list .bdt-hover-bar-wrapper .bdt-hover-bar' => 'width: {{SIZE}}{{UNIT}};', 
                ],
            ]
        );

        $this->add_control(
            'hover_progress_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-bar-list .bdt-hover-bar-wrapper .bdt-hover-bar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-bar-list .bdt-hover-bar-wrapper .bdt-hover-bar .bdt-hover-progress'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'hover_progress_spacing',
            [
                'label'     => __('Spacing', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ], 
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-bar-list' => 'margin-bottom: {{SIZE}}{{UNIT}};', 
                ],
            ]
        );

        


        $this->end_controls_section();


        $this->start_controls_section(
            'hover_button_style',
            [
                'label' => __('Button', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition'=> [
                    '_skin' => ['']
                ]
            ]
        );

        $this->start_controls_tabs('hover_button_tabs');

        $this->start_controls_tab(
            'hover_button_normal',
            [
                'label' => __('Normal  ', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'hover_button_color',
            [
                'label'     => __('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn i' => 'color: {{VALUE}}', 
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn .bdt-hover-btn-text' => 'color: {{VALUE}}', 
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn svg *' => 'stroke: {{VALUE}}', 
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'hover_button_bg',
                'selector'  => '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'hover_button_border',
                'label'    => esc_html__('Border', 'bdthemes-element-pack'),
                'selector' => '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn',
            ]
        );


        $this->add_responsive_control(
            'hover_button_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'hover_button_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
           Group_Control_Box_Shadow::get_type(),
           [
            'name'     => 'hover_button_shadow',
            'selector' => '{{WRAPPER}} .bdt-hover-video .bdt-hover-wrapper-list video'
        ]
    );

        $this->add_control(
            'hover_button_spaceing',
            [
                'label'     => __('Spacing', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 15,
                    ],
                ], 
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};', 
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'hover_button_text',
                'selector' => '{{WRAPPER}} .bdt-hover-video.skin-default .bdt-hover-btn-wrapper .bdt-hover-btn .bdt-hover-btn-text',
            ]
        );

        $this->add_responsive_control(
            'hover_button_align',
            [
                'label'       => __( 'Alignment', 'bdthemes-element-pack' ),
                'type'        => Controls_Manager::CHOOSE,
                'toggle'      => false,
                'default'     => 'center',
                'options'     => [
                    'left'   => [
                        'title' => __( 'Left', 'bdthemes-element-pack' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'bdthemes-element-pack' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'bdthemes-element-pack' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'selectors'   => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper' => 'text-align: {{VALUE}};',
                ],
                'render_type' => 'template'
            ]
        );

        $this->add_control(
            'hover_svg_img_heading',
            [
                'label'     => __('Icon/Image', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'hover_svg_img_size',
            [
                'label'     => __('Size', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 15,
                        'max' => 50,
                    ],
                ], 
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video.skin-default .bdt-hover-btn-wrapper .bdt-hover-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .bdt-hover-video.skin-default .bdt-hover-btn-wrapper .bdt-hover-btn img' => 'width: {{SIZE}}{{UNIT}};',  
                    '{{WRAPPER}} .bdt-hover-video.skin-default .bdt-hover-btn-wrapper .bdt-hover-btn svg' => 'width: {{SIZE}}{{UNIT}};', 
                ],
            ]
        );

        $this->add_responsive_control(
            'hover_svg_img_spacing',
            [
                'label'     => __('Spacing', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 20,
                    ],
                ], 
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn .bdt-hover-icon-wrapper' => 'margin-right: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'hover_button_active',
            [
                'label' => __('Active', 'bdthemes-element-pack'),
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'hover_button_bg_active',
                'selector'  => '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn.active',
            ]
        );

        $this->add_control(
            'hover_button_color_active',
            [
                'label'     => __('Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn.active i' => 'color: {{VALUE}}', 
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn.active .bdt-hover-btn-text' => 'color: {{VALUE}}', 
                    '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn.active svg *' => 'stroke: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_button_border_active',
            [
                'label'     => __( 'Border Color', 'bdthemes-element-pack' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                   '{{WRAPPER}} .bdt-hover-video .bdt-hover-btn-wrapper .bdt-hover-btn.active'  => 'border-color: {{VALUE}};',
               ],
               'condition' => [
                'hover_button_border_border!' => '',
            ],
        ]
    );

        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $this->add_render_attribute( 'hover_video_attr', 'class', 'bdt-hover-video' );
        $this->add_render_attribute( 'hover_video_attr', 'class', 'skin-default' );

        $proVisibility = ($settings['progress_visibility']) == 'yes' ? 'yes' : 'no';

        $video_preload = ($settings['video_preload']) == 'yes' ? 'auto' : 'none';
        

        ?>

        <div <?php echo $this->get_render_attribute_string('hover_video_attr'); ?>>
            <div class="bdt-hover-wrapper-list">
                <?php
                $i = 0;
                foreach ($settings['hover_video_list'] as $index => $item):
                    $i++;
                    $this->add_render_attribute('bdt_hover_video_attr', 'id', $this->get_id().'-'.$item['_id'], true);
                    $active_class = ($i == 1) ? 'active' : '';
                    $this->add_render_attribute('bdt_hover_video_attr', 'class', $active_class, true);
                    $this->add_render_attribute('bdt_hover_video_attr', 'preload', $video_preload, true);

                    $video_poster = ( $item['hover_video_poster']['url'] ) ? $item['hover_video_poster']['url'] : BDTEP_ASSETS_URL . 'images/video-thumbnail.svg';
                    $video_source = $item['remote_url']['url'];

                    if ( 'hosted_url' == $item['source_type'] ) {
                        $video_source = $item['hosted_url']['url'];
                    } else {
                        $video_source = $item['remote_url']['url'];
                    }
                    
                    if (!$video_source) {
                        $video_poster = BDTEP_ASSETS_URL . 'images/video-not-found.svg';
                    }

                    ?>
                    <video <?php echo $this->get_render_attribute_string('bdt_hover_video_attr'); ?> 
                    oncontextmenu="return false;" 
                    src="<?php echo esc_url($video_source); ?>" 
                    poster="<?php echo esc_url($video_poster); ?>"  muted > 
                </video>
            <?php endforeach;?>

        </div>
        <?php if($settings['progress_visibility'] == 'yes'){ ?>
            <div class="bdt-hover-bar-list">
                <?php
                $i = 0;
                foreach ($settings['hover_video_list'] as $index => $item):
                    $i++;
            // pro = progress
                    $this->add_render_attribute('bdt_hover_pro_attr', 'class', 'bdt-hover-progress', true); 
                    $this->add_render_attribute('bdt_hover_pro_attr', 'data-id', $this->get_id().'-'.$item['_id'], true);
                    if ($i == 1) {
                        $this->add_render_attribute('bdt_hover_pro_attr', 'class', 'active');
                    }    
            // echo $i;

                    ?>
                    <div class="bdt-hover-bar-wrapper">
                        <div class="bdt-hover-bar">
                            <div <?php echo $this->get_render_attribute_string('bdt_hover_pro_attr'); ?>></div>
                        </div>
                    </div>
                <?php endforeach;?>

            </div>
        <?php } ?>
        <div class="bdt-hover-btn-wrapper">
            <?php
            $i = 0;
            foreach ($settings['hover_video_list'] as $index => $item):
                $i++;
                $this->add_render_attribute('bdt_hover_btn_attr', 'class', 'bdt-hover-btn', true);
                $this->add_render_attribute('bdt_hover_btn_attr', 'data-id', $this->get_id().'-'.$item['_id'], true);
                if ($i == 1) {
                    $this->add_render_attribute('bdt_hover_btn_attr', 'class', 'active');
                }
            // echo $i;

                ?>
                <div <?php echo $this->get_render_attribute_string('bdt_hover_btn_attr'); ?>>
                    <!-- <img  src="http://192.168.0.101:8012/element-pack/circle/video-player/insta-360/assets/insta-360-btn-1.png"> -->
                    <?php if($settings['icon_visibility'] == 'yes'){ ?>
                        <div class="bdt-hover-icon-wrapper">
                            <span class="bdt-hover-icon">
                                <?php 
                                $has_icon  = ! empty( $item['hover_item_icon'] );
                                $has_image = ! empty( $item['hover_selected_image']['url'] );

                                if ( $has_icon and 'icon' == $item['hover_item_icon_type'] ) {
                                    $this->add_render_attribute( 'font-icon', 'class', $item['hover_item_icon'] );
                                    $this->add_render_attribute( 'font-icon', 'aria-hidden', 'true' );          
                                } elseif ( $has_image and 'image' == $item['hover_item_icon_type'] ) {
                                    $this->add_render_attribute( 'image-icon', 'src', $item['hover_selected_image']['url'] );
                                    $this->add_render_attribute( 'image-icon', 'alt', $item['hover_video_title'] );
                                }

                                if ( ! $has_icon && ! empty( $item['hover_item_icon']['value'] ) ) {
                                    $has_icon = true;
                                }

                                ?>

                                <?php 
                                if ( $has_icon and 'icon' == $item['hover_item_icon_type'] ) {  
                                    Icons_Manager::render_icon($item['hover_item_icon'], ['aria-hidden' => 'true']); 
                                }elseif ( $has_image and 'image' == $item['hover_item_icon_type'] ) { 
                                    ?>
                                    <img <?php echo $this->get_render_attribute_string( 'image-icon' ); ?>>
                                <?php } ?>
                            </span>
                        </div>
                    <?php } ?>

                    <div class="bdt-hover-btn-text">
                        <?php echo $item['hover_video_title']; ?>
                    </div>
                </div>

            <?php endforeach;?>
        </div>
    </div>

    <?php
}
}
