(function($, elementor) {
    'use strict'; 
    var widgetBusinessHours = function($scope, $) {
        var $businessHoursContainer = $scope.find('.bdt-business-hours'),
        $businessHours = $businessHoursContainer.find('.bdt-business-hours-current-time');
        if (!$businessHoursContainer.length) {
            return;
        }
        var $settings = $businessHoursContainer.data('settings');
        var dynamic_timezone = $settings.dynamic_timezone;
        
        $(document).ready(function() {
            if(dynamic_timezone != null && dynamic_timezone != 'undefined'){
                setInterval(timestamp, 1000);
            }
        });

        function timestamp() {
            var date = moment(new Date());
            var live_time = date.tz(dynamic_timezone).format('h:mm:ss a');
            $($businessHoursContainer).find('.bdt-business-hours-current-time').html(live_time);
        }

    };
    jQuery(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/bdt-business-hours.default', widgetBusinessHours);
    });
}(jQuery, window.elementorFrontend));