<?php

namespace ElementPack\Modules\AdvancedPostTab\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Background;
use Elementor\Utils;
use Elementor\Icons_Manager;

use ElementPack\Modules\QueryControl\Module;
use ElementPack\Modules\QueryControl\Controls\Group_Control_Posts;
use ElementPack\Modules\AdvancedPostTab\Advanced_Post_Tab_Helper;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Advanced_Post_Tab extends Widget_Base
{

    public function get_name()
    {
        return 'bdt-advanced-post-tab';
    }

    public function get_title()
    {
        return BDTEP . esc_html__('Advanced Post Tab', 'bdthemes-element-pack');
    }

    public function get_icon()
    {
        return 'bdt-wi-advanced-post-tab';
    }

    public function get_categories()
    {
        return ['element-pack'];
    }

    public function get_keywords()
    {
        return ['post', 'grid', 'blog', 'recent', 'news'];
    }

    public function get_style_depends()
    {
        return ['element-pack-font', 'ep-advanced-post-tab'];
    }

    public function get_script_depends() {
        return ['ep-advanced-post-tab' ];
    }

    // public function get_custom_help_url() {
    // 	return 'https://youtu.be/z3gWwPIsCkg';
    // }

    public function on_import($element)
    {
        if (!get_post_type_object($element['settings']['posts_post_type'])) {
            $element['settings']['posts_post_type'] = 'post';
        }

        return $element;
    }

    public function on_export($element)
    {
        $element = Group_Control_Posts::on_export_remove_setting_from_element($element, 'posts');
        return $element;
    }

    public function get_query()
    {
        return $this->_query;
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__('Layout', 'bdthemes-element-pack'),
            ]
        );
        
        $this->add_control(
			'column_gap',
			[
				'label'   => esc_html__( 'Column Gap', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'small',
				'options' => [
					'small'    => esc_html__( 'Small', 'bdthemes-element-pack' ),
					'medium'   => esc_html__( 'Medium', 'bdthemes-element-pack' ),
					'large'    => esc_html__( 'Large', 'bdthemes-element-pack' ),
					'collapse' => esc_html__( 'Collapse', 'bdthemes-element-pack' ),
				],
			]
        );

        $this->add_responsive_control(
			'primary_item_height',
			[
				'label' => esc_html__( 'Primary Item Height', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min'  => 100,
						'max'  => 800,
						'step' => 2,
					],
                ],
                'default' => [
                    'size' => 400,
                ],
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-primary .bdt-post-tab-img-wrap img' => 'height: {{SIZE}}px',
				],
			]
		);

		$this->add_responsive_control(
			'secondary_item_height',
			[
				'label' => esc_html__( 'Secondary Item Height', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min'  => 100,
						'max'  => 800,
						'step' => 2,
					],
                ],
                'default' => [
                    'size' => 280,
                ],
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-secondary .bdt-post-tab-img-wrap img' => 'height: {{SIZE}}px',
				],
			]
        );

        $this->add_control(
            'heading',
            [
                'label' => __('Heading for the grid', 'bdthemes-element-pack'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __('My Posts', 'bdthemes-element-pack'),
                'default' => __('My Posts', 'bdthemes-element-pack'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
			'show_pagination',
			[
				'label' => esc_html__( 'Pagination', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::SWITCHER,
			]
        );
        
      
        // $this->add_control(
        //     'post_types',
        //     [
        //         'label' => __('Post Types', 'bdthemes-element-pack'),
        //         'type' => Controls_Manager::SELECT2,
        //         'default' => 'post',
        //         'options' => Advanced_Post_Tab_Helper::get_all_post_type_options(),
        //         'multiple' => true
        //     ]
        // );

        // $this->add_control(
        //     'tax_query',
        //     [
        //         'label' => __('Taxonomies', 'bdthemes-element-pack'),
        //         'type' => Controls_Manager::SELECT2,
        //         'options' => Advanced_Post_Tab_Helper::get_all_taxonomy_options(),
        //         'multiple' => true,
        //         'label_block' => true
        //     ]
        // );

        // $this->add_control(
        //     'post_in',
        //     [
        //         'label' => __('Post In', 'bdthemes-element-pack'),
        //         'description' => __('Provide a comma separated list of Post IDs to display in the grid.', 'bdthemes-element-pack'),
        //         'type' => Controls_Manager::TEXT,
        //         'label_block' => true
        //     ]
        // );

        // $this->add_control(
        //     'orderby',
        //     [
        //         'label' => __('Order By', 'bdthemes-element-pack'),
        //         'type' => Controls_Manager::SELECT,
        //         'options' => array(
        //             'none' => __('No order', 'bdthemes-element-pack'),
        //             'ID' => __('Post ID', 'bdthemes-element-pack'),
        //             'author' => __('Author', 'bdthemes-element-pack'),
        //             'title' => __('Title', 'bdthemes-element-pack'),
        //             'date' => __('Published date', 'bdthemes-element-pack'),
        //             'modified' => __('Modified date', 'bdthemes-element-pack'),
        //             'parent' => __('By parent', 'bdthemes-element-pack'),
        //             'rand' => __('Random order', 'bdthemes-element-pack'),
        //             'comment_count' => __('Comment count', 'bdthemes-element-pack'),
        //             'menu_order' => __('Menu order', 'bdthemes-element-pack'),
        //             'post__in' => __('By include order', 'bdthemes-element-pack'),
        //         ),
        //         'default' => 'date'
        //     ]
        // );

        // $this->add_control(
        //     'order',
        //     [
        //         'label' => __('Order', 'bdthemes-element-pack'),
        //         'type' => Controls_Manager::SELECT,
        //         'options' => array(
        //             'ASC' => __('Ascending', 'bdthemes-element-pack'),
        //             'DESC' => __('Descending', 'bdthemes-element-pack'),
        //         ),
        //         'default' => 'DESC'
        //     ]
        // );


        // $this->add_control(
        //     'offset',
        //     [
        //         'label' => __('Offset', 'bdthemes-element-pack'),
        //         'description' => __('Number of posts to skip or pass over.', 'bdthemes-element-pack'),
        //         'type' => Controls_Manager::NUMBER,
        //         'default' => 0
        //     ]
        // );

        

        $this->end_controls_section();


        $this->start_controls_section(
			'section_post_grid_query',
			[
				'label' => esc_html__( 'Query', 'bdthemes-element-pack' ),
			]
		);

		$this->add_group_control(
			Group_Control_Posts::get_type(),
			[
				'name'  => 'posts',
				'label' => esc_html__( 'Posts', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'advanced',
			[
				'label' => esc_html__( 'Advanced', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => esc_html__( 'Order By', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'post_date',
				'options' => [
					'post_date'  => esc_html__( 'Date', 'bdthemes-element-pack' ),
					'post_title' => esc_html__( 'Title', 'bdthemes-element-pack' ),
					'menu_order' => esc_html__( 'Menu Order', 'bdthemes-element-pack' ),
					'rand'       => esc_html__( 'Random', 'bdthemes-element-pack' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => esc_html__( 'Order', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'desc',
				'options' => [
					'asc'  => esc_html__( 'ASC', 'bdthemes-element-pack' ),
					'desc' => esc_html__( 'DESC', 'bdthemes-element-pack' ),
				],
			]
		);

		$this->add_control(
			'offset',
			[
				'label'     => esc_html__( 'Offset', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 0,
				'condition' => [
					'posts_post_type!' => 'by_id',
				],
			]
        );
        
        $this->add_control(
            'taxonomy_filter',
            [
                'type' => Controls_Manager::SELECT,
                'label' => __('Choose the taxonomy to display and filter on.', 'bdthemes-element-pack'),
                'label_block' => true,
                'description' => __('Choose the taxonomy information to display for posts/portfolio and the taxonomy that is used to filter the portfolio/post. Takes effect only if no taxonomy filters are specified when building query.', 'bdthemes-element-pack'),
                'options' => Advanced_Post_Tab_Helper::get_taxonomies_map(),
                'default' => 'category',
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_content_additional_settings',
            [
                'label' => esc_html__('Additional Settings', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'show_title',
            [
                'label' => esc_html__('Title', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_author',
            [
                'label' => esc_html__('Author', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Date', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_comments',
            [
                'label' => esc_html__('Comments', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_category',
            [
                'label' => esc_html__('Category', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_excerpt',
            [
                'label' => esc_html__('Excerpt', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'excerpt_length',
            [
                'label' => esc_html__('Excerpt Length', 'bdthemes-element-pack'),
                'type' => Controls_Manager::NUMBER,
                'default' => 15,
                'condition' => [
                    'show_excerpt' => 'yes',
                ]
            ]
        );


        $this->add_control(
            'show_readmore',
            [
                'label' => esc_html__('Read More', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'readmore_text',
            [
                'label' => esc_html__('Read More Text', 'bdthemes-element-pack'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Read More', 'bdthemes-element-pack'),
                'placeholder' => esc_html__('Read More', 'bdthemes-element-pack'),
                'condition' => [
                    'show_readmore' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'post_grid_icon',
            [
                'label' => esc_html__('Icon', 'bdthemes-element-pack'),
                'type' => Controls_Manager::ICONS,
                'condition' => [
                    'show_readmore' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'icon_align',
            [
                'label' => esc_html__('Icon Position', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SELECT,
                'default' => 'right',
                'options' => [
                    'left' => esc_html__('Before', 'bdthemes-element-pack'),
                    'right' => esc_html__('After', 'bdthemes-element-pack'),
                ],
                'condition' => [
                    'post_grid_icon[value]!' => '',
                ],
            ]
        );

        $this->add_control(
            'icon_indent',
            [
                'label' => esc_html__('Icon Spacing', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 8,
                ],
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                ],
                'condition' => [
                    'post_grid_icon[value]!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-button-icon-align-right' => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-button-icon-align-left' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
            
        $this->end_controls_section();

        //Style
        $this->start_controls_section(
            'section_style_advanced_post_tab',
            [
                'label' => esc_html__('Advanced Post Tab', 'bdthemes-element-pack'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
       
        $this->add_control(
            'itam_heading',
            [
                'label' => esc_html__('Item', 'bdthemes-element-pack'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item',
            ]
        );

        $this->add_responsive_control(
			'item_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'item_shadow',
				'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item',
			]
        );
        
        $this->add_control(
            'itam_content',
            [
                'label' => esc_html__('Content', 'bdthemes-element-pack'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'content_background_color',
            [
                'label' => esc_html__('background', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
			'content_padding',
			[
				'label'      => esc_html__( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
        );
        
        $this->add_responsive_control(
			'content_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'bdthemes-element-pack'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => esc_html__('Spacing', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 2,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-title' => 'padding-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('Typography', 'bdthemes-element-pack'),
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-title',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'primary_title_typography',
                'label' => esc_html__('Primary Typography', 'bdthemes-element-pack'),
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-primary .bdt-post-tab-title',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'secondary_title_typography',
                'label' => esc_html__('Secondary Typography', 'bdthemes-element-pack'),
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-secondary .bdt-post-tab-title',

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_author',
            [
                'label' => esc_html__('Author', 'bdthemes-element-pack'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_author' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'author_color',
            [
                'label' => esc_html__('Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-meta .bdt-post-tab-author a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'author_typography',
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-meta .bdt-post-tab-author a',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_date',
            [
                'label' => esc_html__('Date', 'bdthemes-element-pack'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_date' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'date_color',
            [
                'label' => esc_html__('Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-meta .bdt-post-tab-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'date_divider_color',
            [
                'label' => esc_html__('Divider Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-meta .bdt-post-tab-date:before' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'date_typography',
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-meta .bdt-post-tab-date',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_comments',
            [
                'label' => esc_html__('Comments', 'bdthemes-element-pack'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_comments' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'comments_color',
            [
                'label' => esc_html__('Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-img-wrap .bdt-post-tab-comments' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'comments_typography',
                'label' => esc_html__('Typography', 'bdthemes-element-pack'),
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-img-wrap .bdt-post-tab-comments',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_category',
            [
                'label' => esc_html__('Category', 'bdthemes-element-pack'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_category' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'category_color',
            [
                'label' => esc_html__('Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-img-wrap .bdt-post-tab-category a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'category_background',
            [
                'label' => esc_html__('Background', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-img-wrap .bdt-post-tab-category a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
			'category_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-img-wrap .bdt-post-tab-category a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
        );
        
        $this->add_responsive_control(
			'category_padding',
			[
				'label'      => esc_html__( 'Padding', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-img-wrap .bdt-post-tab-category a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'category_typography',
                'label' => esc_html__('Typography', 'bdthemes-element-pack'),
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-img-wrap .bdt-post-tab-category a',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_excerpt',
            [
                'label' => esc_html__('Excerpt', 'bdthemes-element-pack'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'excerpt_color',
            [
                'label' => esc_html__('Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-excerpt' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'excerpt_spacing',
            [
                'label' => esc_html__('Spacing', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 2,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-excerpt' => 'padding-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'excerpt_typography',
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-excerpt',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_readmore',
            [
                'label' => esc_html__('Read More', 'bdthemes-element-pack'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_readmore' => 'yes',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_readmore_style');

        $this->start_controls_tab(
            'tab_readmore_normal',
            [
                'label' => esc_html__('Normal', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'readmore_color',
            [
                'label' => esc_html__('Text Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'readmore_background',
            [
                'label' => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'readmore_border',
                'label' => esc_html__('Border', 'bdthemes-element-pack'),
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a',
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'readmore_border_radius',
            [
                'label' => esc_html__('Border Radius', 'bdthemes-element-pack'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'readmore_shadow',
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a',
            ]
        );

        $this->add_responsive_control(
            'readmore_padding',
            [
                'label' => esc_html__('Padding', 'bdthemes-element-pack'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'readmore_spacing',
            [
                'label' => esc_html__('Spacing', 'bdthemes-element-pack'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 2,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'readmore_typography',
                'label' => esc_html__('Typography', 'bdthemes-element-pack'),
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_readmore_hover',
            [
                'label' => esc_html__('Hover', 'bdthemes-element-pack'),
            ]
        );

        $this->add_control(
            'readmore_hover_color',
            [
                'label' => esc_html__('Text Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a:hover svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'readmore_hover_background',
            [
                'label' => esc_html__('Background Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'readmore_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'readmore_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-post-tab-item .bdt-post-tab-desc .bdt-post-tab-btn a:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'readmore_hover_animation',
            [
                'label' => esc_html__('Animation', 'bdthemes-element-pack'),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
			'section_design_filter',
			[
				'label'     => esc_html__( 'Filter Bar', 'bdthemes-element-pack' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'heading_color',
            [
                'label' => esc_html__('Main Title Color', 'bdthemes-element-pack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-post-tab .bdt-tabs-main-title span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'heading_text_typography',
                'label'     => esc_html__( 'Title Typography', 'bdthemes-element-pack' ),
                'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-tabs-main-title span',
            ]
        );

		$this->start_controls_tabs( 'tabs_style_normal' );

		$this->start_controls_tab(
			'filter_tab_normal',
			[
				'label' => __( 'Normal', 'bdthemes-element-pack' )
			]
		);
        
		$this->add_control(
			'color_filter',
			[
				'label'     => esc_html__( 'Text Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>*>a' => 'color: {{VALUE}}',
				],
			]
        );
        
        
		$this->add_control(
			'desktop_filter_background',
			[
				'label'     => esc_html__( 'Background', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>*>a' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'desktop_filter_padding',
			[
				'label'      => __('Padding', 'bdthemes-element-pack'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>*>a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'desktop_filter_border',
				'selector'    => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>*>a'
			]
		);

		$this->add_control(
			'desktop_filter_radius',
			[
				'label'      => __('Radius', 'bdthemes-element-pack'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>*>a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'desktop_filter_shadow',
				'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>*>a'
			]
        );
        
        $this->add_control(
			'filter_line_color',
			[
				'label'     => esc_html__( 'Line Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab:before' => 'border-color: {{VALUE}}',
				],
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_filter',
				'label'    => esc_html__( 'Typography', 'bdthemes-element-pack' ),
				'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>*>a',
			]
		);

		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'filter_tab_active',
			[
				'label' => __( 'Active', 'bdthemes-element-pack' )
			]
        );
        
		$this->add_control(
			'color_filter_active',
			[
				'label'     => esc_html__( 'Text Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>.bdt-active>a' => 'color: {{VALUE}}; border-bottom-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'desktop_active_filter_background',
			[
				'label'     => esc_html__( 'Background', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>.bdt-active>a' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'desktop_active_filter_border_color',
			[
				'label'     => esc_html__( 'Border Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>.bdt-active>a' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'desktop_active_filter_radius',
			[
				'label'      => __('Radius', 'bdthemes-element-pack'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>.bdt-active>a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'desktop_active_filter_shadow',
				'selector' => '{{WRAPPER}} .bdt-advanced-post-tab .bdt-tab>.bdt-active>a'
			]
		);
		
		$this->end_controls_tab();
		
		$this->end_controls_tabs();

		$this->end_controls_section();

    }

    
    public function get_taxonomies() {
		$taxonomies = get_taxonomies( [ 'show_in_nav_menus' => true ], 'objects' );

		$options = [ '' => '' ];

		foreach ( $taxonomies as $taxonomy ) {
			$options[ $taxonomy->name ] = $taxonomy->label;
		}

		return $options;
	}

	public function get_posts_tags() {
		$taxonomy = $this->get_settings( 'taxonomy' );

		foreach ( $this->_query->posts as $post ) {
			if ( ! $taxonomy ) {
				$post->tags = [];

				continue;
			}

			$tags = wp_get_post_terms( $post->ID, $taxonomy );

			$tags_slugs = [];

			foreach ( $tags as $tag ) {
				$tags_slugs[ $tag->term_id ] = $tag;
			}

			$post->tags = $tags_slugs;
		}
	}

	public function query_posts($posts_per_page) {
		$query_args = Module::get_query_args( 'posts', $this->get_settings() );

		$query_args['posts_per_page'] = $posts_per_page;

		$this->_query = new \WP_Query( $query_args );
    }

/*
    protected function render() {
        $settings   = $this->get_settings();
        $query_args = Advanced_Post_Tab_Helper::build_query_args($settings);

        $query_args = apply_filters('ep_advanced_post_tab_' . $this->get_id() . '_query_args', $query_args, $settings);
        $loop       = new \WP_Query($query_args);

        // Loop through the posts and do something with them.
        if ($loop->have_posts()) :
            $dir = is_rtl() ? ' dir="rtl"' : '';

            // Check if any taxonomy filter has been applied
            list($chosen_terms, $taxonomies) = Advanced_Post_Tab_Helper::get_chosen_terms($query_args);

            if (empty($chosen_terms)){
                $taxonomies[] = $settings['taxonomy_filter'];
            }

            ?>
            <div class="bdt-advanced-post-tab">
            <?php wp_nonce_field( 'ajax-ep-advanced-post-tab-nonce', 'bdt-advanced-post-tab-sc' ); ?>
            <input type="hidden" class="bdt_spinner_message" value="<?php echo __('Please wait!','bdthemes-element-pack') ?>"/>
            <?php
            if (!empty($settings['heading'])):
                $header_class = (trim($settings['heading']) === '') ? ' d-none' : '';
                ?>
                <div class="bdt-tabs-main-title <?php echo esc_attr($header_class) ?>">
                    <?php
                    if (isset($settings['heading_tag'])) :
                        ?>
                        <<?php echo esc_attr($settings['heading_tag']) ?> class="bdt-widget-heading"><?php echo wp_kses_post($settings['heading']) ?></<?php echo esc_attr($settings['heading_tag']) ?>>
                        <?php
                    endif;
                    ?>
                </div>
                <?php
                endif;

                echo Advanced_Post_Tab_Helper::get_taxonomy_terms_filter($taxonomies, $chosen_terms);
                ?>
                <div class="bdt-advanced-post-tab-wrapper bdt-switcher bdt-margin">
                    <div class="bdt-grid-row segment-0">
                        <div class="bdt-grid">
                            <?php
                            $max_page_no    = $loop->max_num_pages;
                            $page_id        = get_the_ID();
                            $i              = 1;
                            while ($loop->have_posts()) : $loop->the_post();
                                $cols = ($i < 3) ? 2 : 3;
                                ?>
                                <div class="bdt-width-1-<?php echo esc_attr($cols) ?>@m">
                                    <?php include(BDTEP_MODULES_PATH . 'advanced-post-tab/template-parts/temp-item.php'); ?>
                                </div>
                                <?php
                                $i++;
                            endwhile;
                            ?>
                        </div>
                        <?php if($max_page_no > 1): ?>
                            <div class="bdt-advanced-post-tab-pagination">
                                <a data-paged="1" data-page-id="<?php echo esc_attr($page_id) ?>" data-max-paged="<?php echo esc_attr($max_page_no) ?>" data-taxonomy="all" class="load-more-pagination" href="javascript:void()">Load More</a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php
                wp_reset_postdata();
            endif;
    }
*/

    protected function render() {
		$settings = $this->get_settings();
        $id       = $this->get_id();
        
        $query_args = Advanced_Post_Tab_Helper::build_query_args($settings);

        $query_args = apply_filters('ep_advanced_post_tab_' . $this->get_id() . '_query_args', $query_args, $settings);
        $loop       = new \WP_Query($query_args);

        // Loop through the posts and do something with them.
        if ($loop->have_posts()) :
        $dir = is_rtl() ? ' dir="rtl"' : '';

        // Check if any taxonomy filter has been applied
        list($chosen_terms, $taxonomies) = Advanced_Post_Tab_Helper::get_chosen_terms($query_args);

        if (empty($chosen_terms)){
            $taxonomies[] = $settings['taxonomy_filter'];
        }


        $this->query_posts(5);
        $wp_query = $this->get_query();

        if ( ! $wp_query->found_posts ) {
            return;
        }

        ?>
        <div class="bdt-advanced-post-tab">
            <?php wp_nonce_field( 'ajax-ep-advanced-post-tab-nonce', 'bdt-advanced-post-tab-sc' ); ?>
            <input type="hidden" class="bdt_spinner_message" value="<?php echo __('Please wait!','bdthemes-element-pack') ?>"/>
            <div class="bdt-tabs-main-title">
                <span><?php echo wp_kses_post($settings['heading']) ?></span>
            </div>
            <?php
            
            echo Advanced_Post_Tab_Helper::get_taxonomy_terms_filter($taxonomies, $chosen_terms);
            
            ?>

            <div class="bdt-advanced-post-tab-wrapper bdt-margin">
                <div class="bdt-grid bdt-grid-<?php echo esc_attr($settings['column_gap']); ?>" bdt-grid>

                    <?php $bdt_count = 0;
                
                    while ($wp_query->have_posts()) :
                        $wp_query->the_post();
                            
                        $bdt_count++;

                        if ( $bdt_count <= 2) {
                            $bdt_grid_raw = 2;
                            $bdt_post_class = ' bdt-primary';
                        } else {
                            $bdt_grid_raw = 3;
                            $bdt_post_class = ' bdt-secondary';
                        }

                        $bdt_grid_raw = ( $bdt_count <= 2) ? 2 : 3;
                        $bdt_post_class = ( $bdt_count <= 2) ? ' bdt-primary' : ' bdt-secondary';
                        ?>

                        <div class="bdt-width-1-<?php echo esc_attr($bdt_grid_raw); ?>@m<?php echo esc_attr($bdt_post_class); ?>">
                            <?php include(BDTEP_MODULES_PATH . 'advanced-post-tab/template-parts/temp-item.php'); ?>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </div>
	
        <?php 

        if ($settings['show_pagination']) {
            element_pack_post_pagination($wp_query);
        }
        wp_reset_postdata();
    endif;
    }
}
