<?php

namespace ElementPack\Modules\AdvancedPostTab;

use ElementPack\Base\Element_Pack_Module_Base;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Module extends Element_Pack_Module_Base
{

    public function get_name()
    {
        return 'advanced-post-tab';
    }

    public function get_widgets()
    {

        $widgets = [
            'Advanced_Post_Tab',
        ];

        return $widgets;
    }

    public function __construct()
    {
        parent::__construct();

        add_action('wp_ajax_nopriv_element_pack_ajax_advanced_post_tab', array($this, 'element_pack_ajax_advanced_post_tab'));
        add_action('wp_ajax_element_pack_ajax_advanced_post_tab', array($this, 'element_pack_ajax_advanced_post_tab'));

        add_action('wp_ajax_nopriv_element_pack_ajax_advanced_post_tab_load_more', array($this, 'element_pack_ajax_advanced_post_tab_load_more'));
        add_action('wp_ajax_element_pack_ajax_advanced_post_tab_load_more', array($this, 'element_pack_ajax_advanced_post_tab_load_more'));
    }

    public function element_pack_ajax_advanced_post_tab_load_more()
    {

        check_ajax_referer( 'ajax-ep-advanced-post-tab-nonce', 'security' );

        if ('POST' == $_SERVER['REQUEST_METHOD']) {
            $widgetId   = sanitize_text_field($_POST['widget_id']);
            $page_id    = intval($_POST['page_id']);
            $page_no    = intval($_POST['paged']);
            $taxonomy   = sanitize_text_field($_POST['taxonomy']);
            $settings   = $this->get_widget_settings($page_id, $widgetId);

            if ($taxonomy != 'all') {
                $settings['tax_query'][] = $taxonomy;
            }

            $settings['tax_query'] = array_filter($settings['tax_query']);
//            $settings['posts_per_page'] = intval($settings['posts_per_page']) + 1;
            $query_args             = Advanced_Post_Tab_Helper::build_query_args($settings);
            $query_args['paged']    = $page_no;
            $query_args             = apply_filters('ep_advanced_post_tab_' . $widgetId . '_query_args', $query_args, $settings);
            $query_args['offset']   = $page_no * $query_args['posts_per_page'];
            $loop                   = new \WP_Query($query_args);
            ob_start();
            ?>
            <?php
            while ($loop->have_posts()) : $loop->the_post();
                ?>
                <div class="bdt-width-1-3@m">
                <?php include(BDTEP_MODULES_PATH . 'advanced-post-tab/template-parts/temp-item.php'); ?>
                </div><?php
            endwhile; ?>
            <?php
            $output = trim(ob_get_contents());
            ob_end_clean();
            echo wp_json_encode(array('data' => $output), 200);
        }
        exit;
    }

    public function element_pack_ajax_advanced_post_tab()
    {
        check_ajax_referer( 'ajax-ep-advanced-post-tab-nonce', 'security' );

        if ('POST' == $_SERVER['REQUEST_METHOD']) {
            $widgetId   = sanitize_text_field($_POST['widget_id']);
            $page_id    = intval($_POST['page_id']);
            $segment    = intval($_POST['segment']);
            $taxonomy   = sanitize_text_field($_POST['taxonomy']);
            $settings   = $this->get_widget_settings($page_id, $widgetId);

            $settings['tax_query'][] = $taxonomy;
            $settings['tax_query'] = array_filter($settings['tax_query']);

            $query_args = Advanced_Post_Tab_Helper::build_query_args($settings);
            $query_args = apply_filters('ep_advanced_post_tab_' . $widgetId . '_query_args', $query_args, $settings);

            $loop       = new \WP_Query($query_args);

            if ($loop->have_posts()) :
                $max_page_no = $loop->max_num_pages;
                $i = 1;
                ob_start();
                ?>
                <div class="bdt-grid-row bdt-active segment-<?php echo esc_attr($segment) ?>">
                    <div class="bdt-grid">
                        <?php
                        while ($loop->have_posts()) : $loop->the_post();
                            $cols = ($i < 3) ? 2 : 3;
                            ?>
                            <div class="bdt-width-1-<?php echo esc_attr($cols) ?>@m">
                                <?php include(BDTEP_MODULES_PATH . 'advanced-post-tab/template-parts/temp-item.php'); ?>
                            </div><?php
                            $i++;
                        endwhile; ?>
                    </div>
                    <?php if ($max_page_no > 1): ?>
                        <div class="bdt-advanced-post-tab-pagination">
                            <a data-paged="1" data-page-id="<?php echo esc_attr($page_id) ?>" data-max-paged="<?php echo esc_attr($max_page_no) ?>" data-taxonomy="<?php echo esc_attr($taxonomy) ?>" class="load-more-pagination" href="javascript:void()">Load More</a>
                        </div>
                    <?php endif; ?>
                </div>
                <?php
                $output = ob_get_contents();
                ob_end_clean();
                echo wp_json_encode(array('data' => $output), 200);
            endif;
        }
        exit;
    }
}
