<?php
namespace ElementPack\Modules\AdvancedPostTab;

class Advanced_Post_Tab_Helper {

    public static function get_all_post_type_options() {

        $post_types = get_post_types(array('public' => true), 'objects');

        $options = ['' => ''];

        foreach ($post_types as $post_type) {
            $options[$post_type->name] = $post_type->label;
        }

        return apply_filters('ep_advanced_post_tab_post_type_options', $options);
    }

    /**
     * Action to handle searching taxonomy terms.
     */
    public static function get_all_taxonomy_options() {

        $taxonomies = self::get_all_taxonomies();

        $results = array();
        foreach ($taxonomies as $taxonomy) {
            $terms = get_terms(array('taxonomy' => $taxonomy));
            foreach ($terms as $term)
                $results[$term->taxonomy . ':' . $term->slug] = $term->taxonomy . ':' . $term->name;
        }

        return apply_filters('ep_advanced_post_tab_taxonomy_options', $results);
    }


    /** Isotope filtering support**/
    public static function get_taxonomy_terms_filter( $taxonomies, $chosen_terms = array() )
    {
        $output = '';
        $terms = array();

        if ( empty($chosen_terms) ) {
            foreach ( $taxonomies as $taxonomy ) {
                global  $wp_version ;

                if ( version_compare( $wp_version, '4.5', '>=' ) ) {
                    $taxonomy_terms = get_terms( array(
                        'taxonomy' => $taxonomy,
                    ) );
                } else {
                    $taxonomy_terms = get_terms( $taxonomy );
                }

                if ( !empty($taxonomy_terms) && !is_wp_error( $taxonomy_terms ) ) {
                    $terms = array_merge( $terms, $taxonomy_terms );
                }
            }
        } else {
            $terms = $chosen_terms;
        }

        if ( !empty($terms) ) {
            $output .= '<div class="bdt-flex-right" bdt-tab>';
            $output .= '<div class="bdt-filter-item"><a data-value="*" data-segment="0" href="#">' . esc_html__( 'All', 'bdthemes-element-pack' ) . '</a></div>';
            $segment_count = 1;
            foreach ( $terms as $term ) {
                $taxonomy = $term->taxonomy;
                $slug = $term->slug;
                $output .= '<div class="bdt-filter-item segment-'.$segment_count.'"><a href="#" data-segment="'.$segment_count.'" data-page-id="'.get_the_ID().'" data-taxonomy="'.$taxonomy.':'.$slug.'" data-value=".term-' . intval( $term->term_id ) . '" title="' . esc_html__( 'View all items filed under ', 'bdthemes-element-pack' ) . esc_attr( $term->name ) . '">' . esc_html( $term->name ) . '</a></div>';
                $segment_count++;
            }
            $output .= '</div>';
        }

        return apply_filters(
            'ep_advanced_post_tab_taxonomy_terms_filter',
            $output,
            $taxonomies,
            $chosen_terms
        );
    }


    public static function get_chosen_terms( $query_args )
    {
        $chosen_terms = array();
        $taxonomies = array();

        if ( !empty($query_args) && !empty($query_args['tax_query']) ) {
            $term_queries = $query_args['tax_query'];
            foreach ( $term_queries as $terms_query ) {
                if ( !is_array( $terms_query ) ) {
                    continue;
                }
                $field = $terms_query['field'];
                $taxonomy = $terms_query['taxonomy'];
                $terms = $terms_query['terms'];
                if ( empty($taxonomy) || empty($terms) ) {
                    continue;
                }
                if ( !in_array( $taxonomy, $taxonomies ) ) {
                    $taxonomies[] = $taxonomy;
                }

                if ( is_array( $terms ) ) {
                    foreach ( $terms as $term ) {
                        $chosen_terms[] = get_term_by( $field, $term, $taxonomy );
                    }
                } else {
                    $chosen_terms[] = get_term_by( $field, $terms, $taxonomy );
                }

            }
        }

        // Remove duplicates
        $taxonomies = array_unique( $taxonomies );
        $return = array( $chosen_terms, $taxonomies );
        return apply_filters( 'ep_advanced_post_tab_chosen_taxonomy_terms', $return, $query_args );
    }

    public static function get_all_taxonomies()
    {
        $taxonomies = get_taxonomies( array(
            'public'   => true,
            '_builtin' => false,
        ) );
        $taxonomies = array_merge( array(
            'category' => 'category',
            'post_tag' => 'post_tag',
        ), $taxonomies );
        return $taxonomies;
    }

    public static function build_query_args($settings){


        $query_args = self::default_query_args($settings);

        if (!empty($settings['post_in'])) {
            $query_args['post_type'] = 'any';
            $query_args['post__in'] = explode(',', $settings['post_in']);
            $query_args['post__in'] = array_map('intval', $query_args['post__in']);
        }
        else {
            if (!empty($settings['post_types'])) {
                $query_args['post_type'] = $settings['post_types'];
            }

            if (!empty($settings['tax_query'])) {
                $tax_queries = $settings['tax_query'];

                $query_args['tax_query'] = array();
                $query_args['tax_query']['relation'] = 'OR';
                foreach ($tax_queries as $tq) {
                    list($tax, $term) = explode(':', $tq);

                    if (empty($tax) || empty($term))
                        continue;
                    $query_args['tax_query'][] = array(
                        'taxonomy' => $tax,
                        'field' => 'slug',
                        'terms' => $term
                    );
                }
            }
        }

        $query_args = apply_filters('ep_advanced_post_tab_custom_query_args', $query_args, $settings);

        $query_args['paged'] = max(1, get_query_var('paged'), get_query_var('page'));

        return apply_filters('ep_advanced_post_tab_posts_query_args', $query_args, $settings);
    }

    public static function default_query_args($settings) {

        $query_args = [
            'orderby'   => $settings['orderby'],
            'order'     => $settings['order'],
            'ignore_sticky_posts'   => 1,
            'post_status'           => 'publish',
        ];

        $query_args['posts_per_page'] = $settings['posts_per_page'];

        $query_args['offset'] = isset($settings['offset']) ? intval($settings['offset']) : 0;

        return apply_filters('ep_advanced_post_tab_default_query_args', $query_args, $settings);
    }

    // get all registered taxonomies
    public static function get_taxonomies_map()
    {
        $map = array();
        $taxonomies = self::get_all_taxonomies();
        foreach ( $taxonomies as $taxonomy ) {
            $map[$taxonomy] = $taxonomy;
        }
        return apply_filters( 'ep_advanced_post_tab_taxonomies_map', $map );
    }

    public static function get_excerpt($limit, $source = null){

        $excerpt = $source == "content" ? get_the_content() : get_the_excerpt();
        $excerpt = preg_replace(" (\[.*?\])",'',$excerpt);
        $excerpt = strip_shortcodes($excerpt);
        $excerpt = strip_tags($excerpt);
        $excerpt = substr($excerpt, 0, $limit);
        $excerpt = substr($excerpt, 0, strripos($excerpt, " "));
        $excerpt = trim(preg_replace( '/\s+/', ' ', $excerpt));
        return $excerpt;
    }

}
