<?php

namespace ElementPack\Modules\AdvancedDivider\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class Advanced_Divider extends Widget_Base {

	public function get_name() {
		return 'bdt-advanced-divider';
	}

	public function get_title() {
		return BDTEP . esc_html__( 'Advanced Divider', 'bdthemes-element-pack' );
	}

	public function get_icon() {
		return 'bdt-wi-advanced-divider bdt-new';
	}

	public function get_categories() {
		return [ 'element-pack' ];
	}

	public function get_keywords() {
		return [ 'svg', 'divider', 'advanced', 'icon', 'separator', 'fancy' ];
	}

	public function get_style_depends() {
		return [ 'ep-advanced-divider' ];
	}

	// public function get_custom_help_url() {
	// 	return 'https://youtu.be/IU4s5Cc6CUA';
	// }

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_svg_divider',
			[
				'label' => __( 'Advanced Divider', 'bdthemes-element-pack' ),
			]
		);

		$this->add_control(
			'advanced_divider_type',
			[
				'label'   => esc_html__( 'Divider Type', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::CHOOSE,
				'toggle'  => false,
				'default' => 'select',
				'options' => [
					'select' => [
						'title' => esc_html__( 'Select', 'bdthemes-element-pack' ),
						'icon'  => 'fas fa-th-list'
					],
					'choose' => [
						'title' => esc_html__( 'Choose', 'bdthemes-element-pack' ),
						'icon'  => 'fas fa-upload'
					]
				]
			]
		);

		$this->add_control(
			'advanced_divider_select',
			[
				'label'     => esc_html__( 'Select Divider', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'line',
				'options'   => [
					'line'        => esc_html__( 'Line', 'bdthemes-element-pack' ),
					'line-circle' => esc_html__( 'Line Circle', 'bdthemes-element-pack' ),
					'line-cross'  => esc_html__( 'Line Cross', 'bdthemes-element-pack' ),
					'line-star'   => esc_html__( 'Line Star', 'bdthemes-element-pack' ),
					'line-dashed' => esc_html__( 'Line Dashed', 'bdthemes-element-pack' ),
					'heart'       => esc_html__( 'Heart', 'bdthemes-element-pack' ),
					'dashed'      => esc_html__( 'Dashed', 'bdthemes-element-pack' ),
					'floret'      => esc_html__( 'Floret', 'bdthemes-element-pack' ),
					'rectangle'   => esc_html__( 'Rectangle', 'bdthemes-element-pack' ),
					'leaf'        => esc_html__( 'Leaf', 'bdthemes-element-pack' ),
					'slash'       => esc_html__( 'Slash', 'bdthemes-element-pack' ),
					'triangle'    => esc_html__( 'Triangle', 'bdthemes-element-pack' ),
					'wave'        => esc_html__( 'Wave', 'bdthemes-element-pack' ),
					'kiss-curl'   => esc_html__( 'Kiss-curl', 'bdthemes-element-pack' ),
					'jemik'       => esc_html__( 'Jemik', 'bdthemes-element-pack' ),
					'finest'       => esc_html__( 'Finest', 'bdthemes-element-pack' ),
					'furrow'       => esc_html__( 'Furrow', 'bdthemes-element-pack' ),
					'peak'         => esc_html__( 'Peak', 'bdthemes-element-pack' ),
					'melody'       => esc_html__( 'Melody', 'bdthemes-element-pack' ),
					// 'ripple'      => esc_html__( 'Ripple', 'bdthemes-element-pack' ),
					// 'elite'        => esc_html__( 'Elite', 'bdthemes-element-pack' ),
					// 'pick'         => esc_html__( 'Pick', 'bdthemes-element-pack' ),
					// 'blossom'      => esc_html__( 'Blossom', 'bdthemes-element-pack' ),
					// 'boundary'     => esc_html__( 'Boundary', 'bdthemes-element-pack' ),
					// 'cable'        => esc_html__( 'Cable', 'bdthemes-element-pack' ),
					// 'floweret'     => esc_html__( 'Floweret', 'bdthemes-element-pack' ),
					// 'flush'        => esc_html__( 'Flush', 'bdthemes-element-pack' ),
					// 'separk'       => esc_html__( 'Separk', 'bdthemes-element-pack' ),
					// 'splitter'     => esc_html__( 'Splitter', 'bdthemes-element-pack' ),
					// 'hi'           => esc_html__( 'Hi', 'bdthemes-element-pack' ),
					// 'hello'        => esc_html__( 'Hello', 'bdthemes-element-pack' ),
					// 'boom'         => esc_html__( 'Boom', 'bdthemes-element-pack' ),
					// 'bye'          => esc_html__( 'Bye', 'bdthemes-element-pack' ),
					// 'new'          => esc_html__( 'New', 'bdthemes-element-pack' ),
					// 'omg'          => esc_html__( 'Omg', 'bdthemes-element-pack' ),
					// 'lol'          => esc_html__( 'Lol', 'bdthemes-element-pack' ),
					// 'woow'         => esc_html__( 'Woow', 'bdthemes-element-pack' ),
					// 'welcome'      => esc_html__( 'Welcome', 'bdthemes-element-pack' ),
					// 'element-pack' => esc_html__( 'Element Pack', 'bdthemes-element-pack' ),
				],
				'condition' => [
					'advanced_divider_type' => 'select',
				],
			]
		);

		$this->add_control(
			'advanced_divider_choose',
			[
				'label'     => __( 'Choose Divider', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default'   => [
					'url' => BDTEP_ASSETS_URL . 'images/divider/line.svg',
				],
				'condition' => [
					'advanced_divider_type' => 'choose',
				],
			]
		);

		$this->add_control(
			'divider_align',
			[
				'label'       => __( 'Alignment', 'bdthemes-element-pack' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'default'     => 'center',
				'options'     => [
					'left'   => [
						'title' => __( 'Left', 'bdthemes-element-pack' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'bdthemes-element-pack' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'bdthemes-element-pack' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .bdt-advanced-divider' => 'text-align: {{VALUE}}; margin: 0 auto; margin-{{VALUE}}: 0;',
				],
				'condition'   => [
					'advanced_divider_select!' => ['line', 'dashed', 'line-circle', 'line-cross', 'line-dashed', 'line-star', 'slash', 'rectangle', 'triangle', 'wave', 'kiss-curl', 'jemik', 'finest', 'furrow']
				],
				'render_type' => 'template'
			]
		);

		$this->add_responsive_control(
			'divider_line_align',
			[
				'label'       => __( 'Alignment', 'bdthemes-element-pack' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'default'     => 'center',
				'options'     => [
					'left'   => [
						'title' => __( 'Left', 'bdthemes-element-pack' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'bdthemes-element-pack' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'bdthemes-element-pack' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .bdt-advanced-divider' => 'text-align: {{VALUE}}; margin: 0 auto; margin-{{VALUE}}: 0;',
				],
				'condition'   => [
					'advanced_divider_select' => ['line', 'dashed', 'line-circle', 'line-cross', 'line-dashed', 'line-star', 'slash', 'rectangle', 'triangle', 'wave', 'kiss-curl', 'jemik', 'finest', 'furrow']
				],
				'render_type' => 'template',
			]
		);

		$this->add_responsive_control(
			'max_width',
			[
				'label'     => __( 'Max Width', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'max' => 1200,
						'min' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-divider' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'divider_gap_top',
			[
				'label'   => __( 'Top Gap', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SLIDER,
				'range'   => [
					'px' => [
						'max' => 150,
					],
				],
				'default' => [
					'size' => 15,
				],

				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-divider' => 'padding-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'divider_gap_bottom',
			[
				'label'     => __( 'Bottom Gap', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'max' => 150,
					],
				],
				'default'   => [
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-divider' => 'padding-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_additional',
			[
				'label' => __( 'Additional Settings', 'bdthemes-element-pack' ),
			]
		);

		$this->add_responsive_control(
			'divider_svg_stroke_width',
			[
				'label'     => __( 'Stroke Width', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'max' => 10,
						'min' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-divider svg *' => 'stroke-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'divider_crop',
			[
				'label' => __( 'Divider Crop', 'bdthemes-element-pack' ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1000,
					],
				],

				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-divider svg' => 'transform: scale({{SIZE}}) scale(0.01)',
				],
			]
		);

		$this->add_responsive_control(
			'max_height',
			[
				'label'     => __( 'Match Height', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-divider svg' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_svg_divider',
			[
				'label' => __( 'Advanced Divider', 'bdthemes-element-pack' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'divider_svg_stroke_color',
			[
				'label'     => esc_html__( 'Color', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-divider svg *' => 'stroke: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'line_cap',
			[
				'label'   => esc_html__( 'Line Cap', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'square',
				'options' => [
					'square' => esc_html__( 'Square', 'bdthemes-element-pack' ),
					'round'  => esc_html__( 'Rounded', 'bdthemes-element-pack' ),
					'butt'   => esc_html__( 'Butt', 'bdthemes-element-pack' ),
				],
			]
		);

		$this->add_responsive_control(
			'divider_offset',
			[
				'label'     => __( 'Offset', 'bdthemes-element-pack' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdt-advanced-divider' => 'margin-top: -{{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}

	public function render_svg_image() {
		$settings = $this->get_settings();

		$this->add_render_attribute( 'svg-image', 'class', 'bdt-animation-stroke' );
		$this->add_render_attribute( 'svg-image', 'bdt-svg', 'stroke-animation: true;' );

		if ( $settings['advanced_divider_choose']['id'] ) {
			$settings['advanced_divider_choose_size'] = 'full';
			$image_html                               = Group_Control_Image_Size::get_attachment_image_src( $settings['advanced_divider_choose']['id'], 'advanced_divider_choose', $settings );
		} else {
			$image_html = BDTEP_ASSETS_URL . 'images/divider/line.svg';
		}
		?>
        <img src="<?php echo esc_url( $image_html ); ?>"
             alt="<?php echo get_the_title(); ?>" <?php echo $this->get_render_attribute_string( 'svg-image' ); ?>>

		<?php
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'wrapper', 'class', 'bdt-advanced-divider' );

		$align     = ( 'left' == $settings['divider_align'] or 'right' == $settings['divider_align'] ) ? '-' . $settings['divider_align'] : '';
		$svg_image = BDTEP_ASSETS_URL . 'images/divider/' . $settings['advanced_divider_select'] . $align . '.svg';

		$line_cap = $settings['line_cap'];

		?>
        <div <?php echo $this->get_render_attribute_string( 'wrapper' ); ?>>

			<?php if ( 'select' == $settings['advanced_divider_type'] ) : ?>
                <img class="bdt-animation-stroke <?php echo $line_cap; ?>" src="<?php echo $svg_image; ?>"
                     bdt-svg="stroke-animation: true;" alt="advanced divider">
			<?php elseif ( 'choose' == $settings['advanced_divider_type'] ) : ?>
				<?php $this->render_svg_image(); ?>
			<?php endif; ?>

        </div>

		<?php
	}
}
