(function($, elementor) {

    'use strict';

    var widgetWCCarousel = function($scope, $) {

        var $wcCarousel = $scope.find('.bdt-wc-carousel');

        if (!$wcCarousel.length) {
            return;
        }

        var $wcCarouselContainer = $wcCarousel.find('.swiper-container'),
            $settings = $wcCarousel.data('settings');

        var swiper = new Swiper($wcCarouselContainer, $settings);

        if ($settings.pauseOnHover) {
            $($wcCarouselContainer).hover(function() {
                (this).swiper.autoplay.stop();
            }, function() {
                (this).swiper.autoplay.start();
            });
        }

    };

    var widgetWCProductTable = function($scope, $) {

        var $productTable = $scope.find('.bdt-wc-products-skin-table'),
            $settings = $productTable.data('settings'),
            $table = $productTable.find('> table');

        if (!$productTable.length) {
            return;
        }

        $settings.language = window.ElementPackConfig.data_table.language;

        $($table).DataTable($settings);

    };

    // Quickviews
    var widgetProductQuickView = {

        loadQuickViewHtml: function(_this, $scope) {

            var product_id = $(_this).data('id');

            bdtUIkit.notification({
                message: '<div bdt-spinner></div>' + $scope.find('.bdt_modal_spinner_message').val(),
                timeout: false
            });

            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: element_pack_ajax_login_config.ajaxurl,
                data: {
                    'action': 'element_pack_wc_product_quick_view_content',
                    'product_id': product_id,
                    'security': $scope.find('#bdt-wc-product-modal-sc').val()
                },
                success: function(response) {
                    bdtUIkit.modal(response.data).show();
                    bdtUIkit.notification.closeAll();
                },
            });
        },
    }

    var widgetWCProductDefault = function($scope, $) {

        $scope.on('click', '.bdt-quick-view a', function(e) {
            e.preventDefault();
            widgetProductQuickView.loadQuickViewHtml(this, $scope);
        })
    };


    jQuery(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/bdt-wc-carousel.default', widgetWCCarousel);
        elementorFrontend.hooks.addAction('frontend/element_ready/bdt-wc-carousel.wc-carousel-hidie', widgetWCCarousel);
        elementorFrontend.hooks.addAction('frontend/element_ready/bdt-wc-products.bdt-table', widgetWCProductTable);
        elementorFrontend.hooks.addAction('frontend/element_ready/bdt-wc-products.default', widgetWCProductDefault);
        elementorFrontend.hooks.addAction('frontend/element_ready/bdt-wc-products.bdt-table', widgetWCProductDefault);
    });

}(jQuery, window.elementorFrontend));