<?php

namespace ElementPack\Modules\SourceCode\Widgets;

use Elementor\Widget_Base;
use Elementor\Icons_Manager;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Box_Shadow;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Source_Code extends Widget_Base {

    public function get_name() {
        return 'bdt-source-code';
    }

    public function get_title() {
        return BDTEP . esc_html__('Source Code', 'bdthemes-element-pack');
    }

    public function get_icon() {
        return 'bdt-wi-source-code';
    }

    public function get_categories() {
        return ['element-pack'];
    }

    public function get_style_depends() {
        return ['ep-source-code'];
    }

    public function get_script_depends() {
//        return ['source-code', 'source-code-clipboard', 'source-code-x5'];
        return ['source-code', 'source-code-clipboard'];
        //        return ['source-code'];
    }

    public function get_keywords() {
        return ['s', 'source', 'code', 'sc'];
    }

    public function get_custom_help_url() {
        return 'https://youtu.be/faIeyW7LOJ8';
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'source_code_section_layout', [
            'label' => esc_html__('Screen', 'bdthemes-element-pack'),
                ]
        );

        $this->add_control(
                'source_code_screen', [
            'label' => __('Select Screen', 'bdthemes-element-pack'),
            'type' => Controls_Manager::SELECT,
            'default' => 'default',
            'options' => [
                'default' => __('Default', 'bdthemes-element-pack'),
                'coy' => __('Coy', 'bdthemes-element-pack'),
                'dark' => __('Dark', 'bdthemes-element-pack'),
                'funky' => __('Funky', 'bdthemes-element-pack'),
                'okaidia' => __('Okaidia', 'bdthemes-element-pack'),
                'solarizedlight' => __('Solarizedlight', 'bdthemes-element-pack'),
                'tomorrow-night' => __('Tomorrow-night', 'bdthemes-element-pack'),
                'twilight' => __('Twilight', 'bdthemes-element-pack'),
            ],
                //            'selectors' => [
                //                '{{WRAPPER}} .bdt-fancy-list .bdt-list>li:nth-child(n+2),{{WRAPPER}} .bdt-fancy-list  .bdt-list>li>ul' => 'margin-top: {{SIZE}}{{UNIT}}',
                //            ],
                ]
        );

        $this->add_control(
                'source_code_copy_button', [
            'label' => __('Copy Button', 'bdthemes-element-pack'),
            'type' => Controls_Manager::SELECT,
            'default' => 'yes',
            'options' => [
                'yes' => __('Yes', 'bdthemes-element-pack'),
                'no' => __('No', 'bdthemes-element-pack'),
            ]
                ]
        );

        $this->add_control(
                'source_code_language_selector', [
            'label' => __('Select Language', 'bdthemes-element-pack'),
            'type' => Controls_Manager::SELECT,
            'default' => 'language-markup',
            'options' => [
                'language-markup' => __('HTML markup', 'bdthemes-element-pack'),
                'language-clike' => __('C-like', 'bdthemes-element-pack'),
                'language-css' => __('CSS', 'bdthemes-element-pack'),
                'language-scss' => __('Sass', 'bdthemes-element-pack'),
                'language-scss' => __('Scss', 'bdthemes-element-pack'),
                'language-less' => __('Less', 'bdthemes-element-pack'),
                'language-javascript' => __('Javascript', 'bdthemes-element-pack'),
                'language-php' => __('PHP', 'bdthemes-element-pack'),
                'language-phpdoc' => __('PHP DOC', 'bdthemes-element-pack'),
                'language-py' => __('Python', 'bdthemes-element-pack'),
                'language-c' => __('C ', 'bdthemes-element-pack'),
                'language-cpp' => __('C++ ', 'bdthemes-element-pack'),
                'language-csharp' => __('C# ', 'bdthemes-element-pack'),
                'language-aspnet' => __('Asp.net (C#) ', 'bdthemes-element-pack'),
                'language-django' => __('Django ', 'bdthemes-element-pack'),
                'language-git' => __('Git ', 'bdthemes-element-pack'),
                'language-gml' => __('GameMaker language ', 'bdthemes-element-pack'),
                'language-go' => __('Go ', 'bdthemes-element-pack'),
                'language-java' => __('Java ', 'bdthemes-element-pack'),
                'language-javadoc' => __('Java Doc', 'bdthemes-element-pack'),
                'language-json' => __('JSON', 'bdthemes-element-pack'),
                'language-jsonp' => __('JSONP', 'bdthemes-element-pack'),
                'language-kotlin' => __('Kotlin', 'bdthemes-element-pack'),
                'language-markup-templating' => __('Markup templating', 'bdthemes-element-pack'),
                'language-nginx' => __('nginx', 'bdthemes-element-pack'),
                'language-perl' => __('Perl', 'bdthemes-element-pack'),
                'language-jsx' => __('React JSX', 'bdthemes-element-pack'),
                'language-rb' => __('Ruby', 'bdthemes-element-pack'),
                'language-sql' => __('SQL', 'bdthemes-element-pack'),
                'language-swift' => __('Swift', 'bdthemes-element-pack'),
                'language-vbnet' => __('VB.Net', 'bdthemes-element-pack'),
                'language-vb' => __('Visual Basic', 'bdthemes-element-pack'),
            ]
                ]
        );



        $this->add_control(
                'source_code_user_input', [
            'label' => __('Source Code', 'bdthemes-element-pack'),
            'type' => Controls_Manager::TEXTAREA,
            'rows' => 10,
            'default' => __(' <h4 class="title">Code Sample</h4>', 'bdthemes-element-pack'),
            'placeholder' => __('Type your code here', 'bdthemes-element-pack'),
                ]
        );



        $this->end_controls_section();

        $this->start_controls_section(
                'section_style', [
            'label' => __('Items', 'bdthemes-element-pack'),
            'tab' => Controls_Manager::TAB_STYLE,
                ]
        );

        $this->add_control(
                'source_code_preview_height', [
            'label' => __('Height', 'bdthemes-element-pack'),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 500,
                'unit' => 'px',
            ],
            'range' => [
                'px' => [
                    'min' => 10,
                    'max' => 2000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .bdt-source-code pre' => 'max-height: {{SIZE}}{{UNIT}}',
            ],
                ]
        );

        $this->add_group_control(
                Group_Control_Border::get_type(), [
            'name' => 'source_code_preview_border',
            'label' => esc_html__('Border', 'bdthemes-element-pack'),
            'selector' => '{{WRAPPER}} .bdt-source-code pre',
//                'condition' => [
//                    '_skin' => '',
//                ],
                ]
        );


        $this->add_control(
                'source_code_preview_border_radius', [
            'label' => __('Border Radius', 'bdthemes-element-pack'),
            'type' => Controls_Manager::DIMENSIONS,
            // 'default' => '11px 15px',
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .bdt-source-code pre' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ',
            ],
                ]
        );

        $this->add_responsive_control(
                'source_code_preview_padding', [
            'label' => __('Padding', 'bdthemes-element-pack'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors' => [
                '{{WRAPPER}} .bdt-source-code pre' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
            ],
                ]
        );
        $this->add_responsive_control(
                'source_code_preview_margin', [
            'label' => __('Margin', 'bdthemes-element-pack'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors' => [
                '{{WRAPPER}} .bdt-source-code pre' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
            ],
                ]
        );



        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ($settings['source_code_copy_button'] == 'no') {
            echo '<style>.source-code .copy{display: none !important}</style>';
        }
        ?>


        <div class="bdt-source-code">

            <div class="code-toolbar ">
                <pre class="<?php
                echo esc_html($settings['source_code_language_selector']);
                ?>"> <?php
                         echo esc_html($settings['source_code_user_input']);
                         ?> </pre>
            </div>


        </div>
        <input id="select-test" value="<?php echo $settings['source_code_screen']; ?>">
        <script>
            jQuery(function ($) {
            jQuery("<link/>", {
            rel: "stylesheet",
                    type: "text/css",
                    id: 'css-exits',
                    href: "<?php echo BDTEP_URL; ?>assets/css/ep-source-code-default.css"
            }).appendTo("head");
            
            
                   var xx = jQuery('#select-test').val();
       
                    if (xx == 'default'){
                    jQuery("#css-exits").attr('href', '<?php echo BDTEP_URL; ?>assets/css/ep-source-code-default.css');
                    }else if(xx == 'coy'){
                    jQuery("#css-exits").attr('href', '<?php echo BDTEP_URL; ?>assets/css/ep-source-code-coy.css');
                    }else if(xx == 'dark'){
                    jQuery("#css-exits").attr('href', '<?php echo BDTEP_URL; ?>assets/css/ep-source-code-dark.css');
                    } else{
                    jQuery("#css-exits").attr('href', '<?php echo BDTEP_URL; ?>assets/css/ep-source-code-default.css');
                    }


            });
        //            if (jQuery(document).find('#css-exits')) {
        //                jQuery("#css-exits").attr('href', 'http://192.168.1.121/wordpress/wp-content/plugins/bdthemes-element-pack/assets/css/ep-source-code-dark.css');
        //            }
        </script>




        <?php
//        if ($settings['source_code_screen'] == 'default') {
////            wp_enqueue_style('source-code-coy', BDTEP_URL . 'assets/css/ep-source-code-default.css', false);
//            $test = '<script>    if (jQuery(document).find("#css-exits")) {   jQuery("#css-exits").attr("href","http://192.168.1.121/wordpress/wp-content/plugins/bdthemes-element-pack/assets/css/ep-source-code-default.css"); }  ;</script>';
//            echo $test;
//            
//        } elseif ($settings['source_code_screen'] == 'coy') {
////            wp_enqueue_style('source-code-coy', BDTEP_URL . 'assets/css/ep-source-code-coy.css', false);
//                $test = '<script>      if (jQuery(document).find("#css-exits")) {   jQuery("#css-exits").attr("href","http://192.168.1.121/wordpress/wp-content/plugins/bdthemes-element-pack/assets/css/ep-source-code-coy.css"); }  ;</script>';
//            echo $test;
//            
//        } elseif ($settings['source_code_screen'] == 'dark') {
//            wp_enqueue_style('source-code-dark', BDTEP_URL . 'assets/css/ep-source-code-dark.css', false);
//        } elseif ($settings['source_code_screen'] == 'funky') {
//            wp_enqueue_style('source-code-dark', BDTEP_URL . 'assets/css/ep-source-code-funky.css', false);
//        } elseif ($settings['source_code_screen'] == 'okaidia') {
//            wp_enqueue_style('source-code-dark', BDTEP_URL . 'assets/css/ep-source-code-okaidia.css', false);
//        } elseif ($settings['source_code_screen'] == 'solarizedlight') {
//            wp_enqueue_style('source-code-dark', BDTEP_URL . 'assets/css/ep-source-code-solarizedlight.css', false);
//        } elseif ($settings['source_code_screen'] == 'tomorrow-night') {
//            wp_enqueue_style('source-code-dark', BDTEP_URL . 'assets/css/ep-source-code-tomorrow-night.css', false);
//        } elseif ($settings['source_code_screen'] == 'twilight') {
//            wp_enqueue_style('source-code-dark', BDTEP_URL . 'assets/css/ep-source-code-twilight.css', false);
//        } else {
//            //            its default
//            wp_enqueue_style('source-code-coy', BDTEP_URL . 'assets/css/ep-source-code-default.css', false);
//        }
        ?>



        <script>
                    //            jQuery(document).ready(function ($) { var s = document.createElement("script");  s.type = "text/javascript"; s.src = "http://192.168.1.121/wordpress/wp-content/plugins/bdthemes-element-pack/assets/vendor/js/source-code-default.js";jQuery("body").append(s); });</script>

        <script>
            jQuery(document).ready(function ($) {
            var s = document.createElement("script");
            s.type = "text/javascript";
            s.src = "<?php echo BDTEP_URL; ?>assets/vendor/js/source-code-default.js";
            jQuery("body").append(s);
            });

        </script>





        <?php
//
//        wp_enqueue_script('mypluginscript', BDTEP_URL . 'assets/vendor/js/source-code-x5.js', true);
    }

}
