<?php
namespace ElementPack\Modules\AdvancedProgressBar\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly

class Advanced_Progress_Bar extends Widget_Base
{

    public function get_name()
    {
        return 'bdt-advanced-progress-bar';
    }

    public function get_title()
    {
        return BDTEP . esc_html__('Advanced Progress Bar', 'bdthemes-element-pack');
    }

    public function get_icon()
    {
        return 'bdt-wi-advanced-progress-bar';
    }

    public function get_categories()
    {
        return ['element-pack'];
    }

    public function get_keywords()
    {
        return ['advanced bar', 'progress', 'skills', 'bars'];
    }

    public function get_style_depends()
    {
        return ['ep-advanced-progress-bar'];
    }

    public function get_script_depends()
    {
        return ['ep-advanced-progress-bar'];
    }

    // public function get_custom_help_url() {
    //     return 'https://youtu.be/DP3XNV1FEk0';
    // }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_progress_bars',
            [
                'label' => __('Progress Bars', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'name',
            [
                'type'        => Controls_Manager::TEXT,
                'label'       => __('Name', 'bdthemes-element-pack'),
                'default'     => __('Design', 'bdthemes-element-pack'),
                'placeholder' => __('Type a skill name', 'bdthemes-element-pack'),
            ]
        );

        $repeater->add_control(
            'max_level',
            [
                'label'      => __('Max Value', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::SLIDER,
                'default'    => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'size_units' => ['%'],
                'range'      => [
                    '%' => [
                        'min'  => 0,
                        'step' => 10,
                        'max'  => 100,
                    ],
                ],
            ]
        );

        $repeater->add_control(
            'level',
            [
                'label'      => __('Level (Out Of Max Value)', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::SLIDER,
                'default'    => [
                    'unit' => '%',
                    'size' => 95,
                ],
                'size_units' => ['%'],
                'range'      => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
            ]
        );

        $repeater->add_control(
            'color',
            [
                'label'     => __('Text Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item{{CURRENT_ITEM}}' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'level_color',
            [
                'label'          => __('Level Color', 'bdthemes-element-pack'),
                'type'           => Controls_Manager::COLOR,
                'selectors'      => [
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item{{CURRENT_ITEM}} .bdt-progress::-webkit-progress-value' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item{{CURRENT_ITEM}} .bdt-progress::-moz-progress-bar'      => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item{{CURRENT_ITEM}} .bdt-progress::-ms-fill'               => 'background-color: {{VALUE}};',
                ],
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'base_color',
            [
                'label'          => __('Base Color', 'bdthemes-element-pack'),
                'type'           => Controls_Manager::COLOR,
                'selectors'      => [
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item{{CURRENT_ITEM}} .bdt-progress::-webkit-progress-bar' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item{{CURRENT_ITEM}} .bdt-progress'                       => 'background-color: {{VALUE}};',
                ],
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'progress_bars',
            [
                'show_label'  => false,
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '<# print((name || level.size) ? (name || "Skill") + " - " + level.size + level.unit : "Skill - 0%") #>',
                'default'     => [
                    [
                        'name'  => 'Design',
                        'level' => ['size' => 97, 'unit' => '%'],
                    ],
                    [
                        'name'  => 'UX',
                        'level' => ['size' => 88, 'unit' => '%'],
                    ],
                    [
                        'name'  => 'Coding',
                        'level' => ['size' => 92, 'unit' => '%'],
                    ],
                    [
                        'name' => 'Speed',
                    ],
                    [
                        'name'  => 'Passion',
                        'level' => ['size' => 100, 'unit' => '%'],
                    ],
                ],
            ]
        );

        $this->add_control(
            'text_position',
            [
                'type'           => Controls_Manager::SELECT,
                'label'          => __('Text Position', 'bdthemes-element-pack'),
                'separator'      => 'before',
                'default'        => 'outside-top',
                'options'        => [
                    'inside'         => __('Text Inside', 'bdthemes-element-pack'),
                    'outside-top'    => __('Text Outside Top', 'bdthemes-element-pack'),
                    'outside-bottom' => __('Text Outside Bottom', 'bdthemes-element-pack'),
                ],
                'style_transfer' => true,
            ]
        );

        $this->end_controls_section();

        //Style
        $this->start_controls_section(
            'section_style_progress_bars',
            [
                'label' => __('Progress Bars', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'height',
            [
                'label'      => __('Height', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 1,
                        'max' => 250,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'spacing',
            [
                'label'      => __('Spacing Between', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 250,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition'  => [
                    'text_position' => ['outside-top', 'inside'],
                ],
            ]
        );

        $this->add_control(
            'outside_bottom_spacing',
            [
                'label'      => __('Spacing Between', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 250,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-name' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition'  => [
                    'text_position' => 'outside-bottom',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label'      => __('Border Radius', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item{{CURRENT_ITEM}} .bdt-progress::-webkit-progress-value' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item{{CURRENT_ITEM}} .bdt-progress::-moz-progress-bar'      => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item{{CURRENT_ITEM}} .bdt-progress::-ms-fill'               => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item{{CURRENT_ITEM}} .bdt-progress::-webkit-progress-bar'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item{{CURRENT_ITEM}} .bdt-progress'                         => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'exclude'  => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress',
            ]
        );

        $this->add_control(
            'progress_bar_padding',
            [
                'label'      => esc_html__('Padding', 'bdthemes-element-pack'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_content_style',
            [
                'label' => __('Content', 'bdthemes-element-pack'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color',
            [
                'label'     => __('Text Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'level_color',
            [
                'label'     => __('Level Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item .bdt-progress::-webkit-progress-value' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item .bdt-progress::-moz-progress-bar'      => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item .bdt-progress::-ms-fill'               => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'base_color',
            [
                'label'     => __('Base Color', 'bdthemes-element-pack'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item .bdt-progress::-webkit-progress-bar' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item .bdt-progress'                       => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'info_typography',
                'selector' => '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name'     => 'info_text_shadow',
                'selector' => '{{WRAPPER}} .bdt-advanced-progress-bar .bdt-progress-item',
            ]
        );
    }

    public function render()
    {
        $settings = $this->get_active_settings();

        if ('inside' == $settings['text_position']) {
            $this->add_render_attribute('progress-bar', 'class', 'bdt-advanced-progress-bar bdt-progess-text-inside');
        } elseif ('outside-bottom' == $settings['text_position']) {
            $this->add_render_attribute('progress-bar', 'class', 'bdt-advanced-progress-bar bdt-progess-text-outside-bottom');
        } else {
            $this->add_render_attribute('progress-bar', 'class', 'bdt-advanced-progress-bar');
        }

        ?>
		<div <?php echo $this->get_render_attribute_string('progress-bar'); ?>>
			<?php
            
            foreach ($settings['progress_bars'] as $progress):
            ?>

				<?php if ( 'outside-bottom' == $settings['text_position'] ) { ?>

                    <div class="bdt-progress-item elementor-repeater-item-<?php echo esc_attr($progress['_id']); ?>">
                     <progress id="bdt-js-progressbar<?php echo (rand()); ?>"  class="bdt-progress"  data="<?php echo esc_attr($progress['level']['size']) ?>" value="0" max="<?php echo esc_attr($progress['max_level']['size']) ?>">
                        </progress>
                        <div class="bdt-progress-name"><?php echo esc_html($progress['name']); ?></div>
                        <span class="bdt-progress-parcentage"><?php echo esc_html($progress['level']['size']); ?>%</span>
                    </div>

                <?php } else { ?>
                    <div class="bdt-progress-item elementor-repeater-item-<?php echo esc_attr($progress['_id']); ?>">
                        <div class="bdt-progress-name "><?php echo esc_html($progress['name']); ?></div>
                        <progress id="bdt-js-progressbar<?php echo (rand()); ?>" class="bdt-progress" data="<?php echo esc_attr($progress['level']['size']) ?>" value="0"   max="<?php echo esc_attr($progress['max_level']['size']) ?>">
                        </progress>
                        <span class="bdt-progress-parcentage"><?php echo esc_html($progress['level']['size']); ?>%</span>
                    </div> 
                
				<?php }?>

			<?php endforeach;?>
		</div>

		<?php
}
}
