<?php
namespace ElementPack\Modules\TransformEffects;

use Elementor\Elementor_Base;
use Elementor\Controls_Manager;
use ElementPack;
use ElementPack\Plugin;
use ElementPack\Base\Element_Pack_Module_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Module extends Element_Pack_Module_Base {

	public function __construct() {
		parent::__construct();
		$this->add_actions();
	}

	public function get_name() {
		return 'bdt-transform-effects';
	}

	public function register_controls_widget_transform_effect($widget, $widget_id, $args) {
		static $widgets = [
			'section_effects', /* Section */
		];

		if ( ! in_array( $widget_id, $widgets ) ) {
			return;
		}

		$widget->add_control(
			'element_pack_widget_transform',
			[
				'label'        => BDTEP_CP . esc_html__( 'Use Transform?', 'bdthemes-element-pack' ),
				'description'  => esc_html__( 'Don\'t use with others addon effect so it will work abnormal.' , 'bdthemes-element-pack' ),
				'type'         => Controls_Manager::SWITCHER,
				'prefix_class' => 'bdt-motion-effect-',
				'separator'    => 'before',
			]
		);


		$widget->start_controls_tabs( 'element_pack_widget_motion_effect_tabs' );

		$widget->start_controls_tab(
			'element_pack_widget_motion_effect_tab_normal',
			[
				'label' => esc_html__( 'Normal', 'bdthemes-element-pack' ),
				'condition' => [
					'element_pack_widget_transform' => 'yes',
				],
			]
		);


		$widget->add_control(
			'element_pack_translate_toggle_normal',
			[
				'label' 		=> __( 'Translate', 'bdthemes-element-pack' ),
				'type' 			=> Controls_Manager::POPOVER_TOGGLE,
				'return_value' 	=> 'yes',
				'condition' 	=> [
					'element_pack_widget_transform' => 'yes',
				],
			]
		);

		$widget->start_popover();


		$widget->add_responsive_control(
			'element_pack_widget_effect_transx_normal',
			[
				'label'      => esc_html__( 'Translate X', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'      => [
					'px' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'condition' => [
					'element_pack_translate_toggle_normal' => 'yes',
					'element_pack_widget_transform' => 'yes',
				],
			]
		);

		$widget->add_responsive_control(
			'element_pack_widget_effect_transy_normal',
			[
				'label'      => esc_html__( 'Translate Y', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'      => [
					'px' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'selectors' => [
					'(desktop){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget' => 'transform: translate({{element_pack_widget_effect_transx_normal.SIZE || 0}}px, {{element_pack_widget_effect_transy_normal.SIZE || 0}}px);',
					'(tablet){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget' => 'transform: translate({{element_pack_widget_effect_transx_normal_tablet.SIZE || 0}}px, {{element_pack_widget_effect_transy_normal_tablet.SIZE || 0}}px);',
					'(mobile){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget' => 'transform: translate({{element_pack_widget_effect_transx_normal_mobile.SIZE || 0}}px, {{element_pack_widget_effect_transy_normal_mobile.SIZE || 0}}px);',
				],
				'condition' => [
					'element_pack_translate_toggle_normal' => 'yes',
					'element_pack_widget_transform' => 'yes',
				],
			]
		);


		$widget->end_popover();



		$widget->add_control(
			'element_pack_rotate_toggle_normal',
			[
				'label' 		=> __( 'Rotate', 'bdthemes-element-pack' ),
				'type' 			=> Controls_Manager::POPOVER_TOGGLE,
				'return_value' 	=> 'yes',
				'condition' 	=> [
					'element_pack_widget_transform' => 'yes',
				],
			]
		);

		$widget->start_popover();


		$widget->add_responsive_control(
			'element_pack_widget_effect_rotatex_normal',
			[
				'label'      => esc_html__( 'Rotate X', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'      => [
					'px' => [
						'min'  => -180,
						'max'  => 180,
					],
				],
				'condition' => [
					'element_pack_rotate_toggle_normal' => 'yes',
					'element_pack_widget_transform' => 'yes',
				],
			]
		);

		$widget->add_responsive_control(
			'element_pack_widget_effect_rotatey_normal',
			[
				'label'      => esc_html__( 'Rotate Y', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'      => [
					'px' => [
						'min'  => -180,
						'max'  => 180,
					],
				],
				'condition' => [
					'element_pack_rotate_toggle_normal' => 'yes',
					'element_pack_widget_transform' => 'yes',
				],
			]
		);


		$widget->add_responsive_control(
			'element_pack_widget_effect_rotatez_normal',
			[
				'label'   => __( 'Rotate Z', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min'  => -180,
						'max'  => 180,
					],
				],
				'selectors' => [
					'(desktop){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget' => 'transform: translate( {{element_pack_widget_effect_transx_normal.SIZE || 0}}px, {{element_pack_widget_effect_transy_normal.SIZE || 0}}px) rotateX({{element_pack_widget_effect_rotatex_normal.SIZE || 0}}deg) rotateY({{element_pack_widget_effect_rotatey_normal.SIZE || 0}}deg) rotateZ({{element_pack_widget_effect_rotatez_normal.SIZE || 0}}deg);',
					'(tablet){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget' => 'transform: translate( {{element_pack_widget_effect_transx_normal_tablet.SIZE || 0}}px, {{element_pack_widget_effect_transy_normal_tablet.SIZE || 0}}px) rotateX({{element_pack_widget_effect_rotatex_normal.SIZE || 0}}deg) rotateY({{element_pack_widget_effect_rotatey_normal.SIZE || 0}}deg) rotateZ({{element_pack_widget_effect_rotatez_normal.SIZE || 0}}deg);',
					'(mobile){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget' => 'transform: translate( {{element_pack_widget_effect_transx_normal_mobile.SIZE || 0}}px, {{element_pack_widget_effect_transy_normal_mobile.SIZE || 0}}px) rotateX({{element_pack_widget_effect_rotatex_normal.SIZE || 0}}deg) rotateY({{element_pack_widget_effect_rotatey_normal.SIZE || 0}}deg) rotateZ({{element_pack_widget_effect_rotatez_normal.SIZE || 0}}deg);',
				],
				'condition' => [
					'element_pack_rotate_toggle_normal' => 'yes',
					'element_pack_widget_transform' => 'yes',
				],
			]
		);


		$widget->end_popover();

		$widget->end_controls_tab();

		$widget->start_controls_tab(
			'element_pack_widget_motion_effect_tab_hover',
			[
				'label' => esc_html__( 'Hover', 'bdthemes-element-pack' ),
				'condition' => [
					'element_pack_widget_transform' => 'yes',
				],
			]
		);

		$widget->add_control(
			'element_pack_translate_toggle_hover',
			[
				'label' 		=> __( 'Translate', 'bdthemes-element-pack' ),
				'type' 			=> Controls_Manager::POPOVER_TOGGLE,
				'return_value' 	=> 'yes',
				'condition' 	=> [
					'element_pack_widget_transform' => 'yes',
				],
			]
		);

		$widget->start_popover();


		$widget->add_responsive_control(
			'element_pack_widget_effect_transx_hover',
			[
				'label'      => esc_html__( 'Translate X', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'      => [
					'px' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'condition' => [
					'element_pack_translate_toggle_hover' => 'yes',
					'element_pack_widget_transform' => 'yes',
				],
			]
		);

		$widget->add_responsive_control(
			'element_pack_widget_effect_transy_hover',
			[
				'label'      => esc_html__( 'Translate Y', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'      => [
					'px' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'selectors' => [
					'(desktop){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget:hover' => 'transform: translate({{element_pack_widget_effect_transx_hover.SIZE || 0}}px, {{element_pack_widget_effect_transy_hover.SIZE || 0}}px);',
					'(tablet){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget:hover' => 'transform: translate({{element_pack_widget_effect_transx_hover_tablet.SIZE || 0}}px, {{element_pack_widget_effect_transy_hover_tablet.SIZE || 0}}px);',
					'(mobile){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget:hover' => 'transform: translate({{element_pack_widget_effect_transx_hover_mobile.SIZE || 0}}px, {{element_pack_widget_effect_transy_hover_mobile.SIZE || 0}}px);',
				],
				'condition' => [
					'element_pack_translate_toggle_hover' => 'yes',
					'element_pack_widget_transform' => 'yes',
				],
			]
		);


		$widget->end_popover();



		$widget->add_control(
			'element_pack_rotate_toggle_hover',
			[
				'label' 		=> __( 'Rotate', 'bdthemes-element-pack' ),
				'type' 			=> Controls_Manager::POPOVER_TOGGLE,
				'return_value' 	=> 'yes',
				'condition' 	=> [
					'element_pack_widget_transform' => 'yes',
				],
			]
		);

		$widget->start_popover();


		$widget->add_responsive_control(
			'element_pack_widget_effect_rotatex_hover',
			[
				'label'      => esc_html__( 'Rotate X', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'      => [
					'px' => [
						'min'  => -180,
						'max'  => 180,
					],
				],
				'condition' => [
					'element_pack_rotate_toggle_hover' => 'yes',
					'element_pack_widget_transform' => 'yes',
				],
			]
		);

		$widget->add_responsive_control(
			'element_pack_widget_effect_rotatey_hover',
			[
				'label'      => esc_html__( 'Rotate Y', 'bdthemes-element-pack' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range'      => [
					'px' => [
						'min'  => -180,
						'max'  => 180,
					],
				],
				'condition' => [
					'element_pack_rotate_toggle_hover' => 'yes',
					'element_pack_widget_transform' => 'yes',
				],
			]
		);


		$widget->add_responsive_control(
			'element_pack_widget_effect_rotatez_hover',
			[
				'label'   => __( 'Rotate Z', 'bdthemes-element-pack' ),
				'type'    => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min'  => -180,
						'max'  => 180,
					],
				],
				'selectors' => [
					'(desktop){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget:hover' => 'transform: translate( {{element_pack_widget_effect_transx_hover.SIZE || 0}}px, {{element_pack_widget_effect_transy_hover.SIZE || 0}}px) rotateX({{element_pack_widget_effect_rotatex_hover.SIZE || 0}}deg) rotateY({{element_pack_widget_effect_rotatey_hover.SIZE || 0}}deg) rotateZ({{element_pack_widget_effect_rotatez_hover.SIZE || 0}}deg);',
					'(tablet){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget:hover' => 'transform: translate( {{element_pack_widget_effect_transx_hover_tablet.SIZE || 0}}px, {{element_pack_widget_effect_transy_hover_tablet.SIZE || 0}}px) rotateX({{element_pack_widget_effect_rotatex_hover.SIZE || 0}}deg) rotateY({{element_pack_widget_effect_rotatey_hover.SIZE || 0}}deg) rotateZ({{element_pack_widget_effect_rotatez_hover.SIZE || 0}}deg);',
					'(mobile){{WRAPPER}}.bdt-motion-effect-yes.elementor-widget:hover' => 'transform: translate( {{element_pack_widget_effect_transx_hover_mobile.SIZE || 0}}px, {{element_pack_widget_effect_transy_hover_mobile.SIZE || 0}}px) rotateX({{element_pack_widget_effect_rotatex_hover.SIZE || 0}}deg) rotateY({{element_pack_widget_effect_rotatey_hover.SIZE || 0}}deg) rotateZ({{element_pack_widget_effect_rotatez_hover.SIZE || 0}}deg);',
				],
				'condition' => [
					'element_pack_rotate_toggle_hover' => 'yes',
					'element_pack_widget_transform' => 'yes',
				],
			]
		);


		$widget->end_popover();


		$widget->end_controls_tab();

		$widget->end_controls_tabs();


	}


	public function widget_transform_effect_before_render($widget) {    		
		$settings = $widget->get_settings();

		// if( $settings['element_pack_widget_tooltip'] == 'yes' ) {
		// 	$element_id = $widget->get_settings( '_element_id' );
		// 	if (empty($element_id)) {
		// 		$id = 'bdt-widget-tooltip-'.$widget->get_id();
		// 		$widget->add_render_attribute( '_wrapper', 'id', $id, true );
		// 	} else {
		// 		$id = $widget->get_settings( '_element_id' );
		// 	}
			
		// 	$widget->add_render_attribute( '_wrapper', 'class', 'bdt-tippy-tooltip' );
		// 	$widget->add_render_attribute( '_wrapper', 'data-tippy', '', true );
		// }
	}

	protected function add_actions() {

		add_action( 'elementor/element/before_section_end', [ $this, 'register_controls_widget_transform_effect' ], 10, 3 );
		add_action( 'elementor/frontend/widget/before_render', [ $this, 'widget_transform_effect_before_render' ], 10, 1 );

	}
}