<style>
	.edd-invoices-field {
		float: left;
		width: 25%;
	}

	.edd-invoices-div {
		margin-top: 2em;
		margin-bottom: 2em;
	}
</style>
<form action="" method="post" id="<?php echo 'edd-invoices'; ?>">
	<div class="edd-invoices-div edd-invoices-custom-div">
		<label class="edd-invoices-field edd-invoices-custom-field" for="company"><?php esc_html_e( 'Company:', 'edd-invoices' ); ?></label>
		<input type="text" name="edd-payment-company" value="<?php echo esc_attr( $company ); ?>" id="company" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div">
		<label class="edd-invoices-field edd-invoices-custom-field" for="name"><?php esc_html_e( 'Billing Name:', 'edd-invoices' ); ?></label>
		<input type="text" name="edd-payment-user-name" value="<?php echo ! empty( $address['name'] ) ? esc_attr( $address['name'] ) : ''; ?>" id="name" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div">
		<label class="edd-invoices-field edd-invoices-custom-field" for="address1"><?php _e( 'Billing Address:', 'edd-invoices' ); ?></label>
		<input type="text" name="edd-payment-address[line1]" value="<?php echo( ! empty( $address['line1'] ) ? esc_attr( $address['line1'] ) : '' ); ?>" id="address1" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div">
		<label class="edd-invoices-field edd-invoices-custom-field" for="address2"><?php _e( 'Line 2:', 'edd-invoices' ); ?></label>
		<input type="text" name="edd-payment-address[line2]" value="<?php echo( ! empty( $address['line2'] ) ? esc_attr( $address['line2'] ) : '' ); ?>" id="address2" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div">
		<label class="edd-invoices-field edd-invoices-custom-field" for="city"><?php _e( 'City:', 'edd-invoices' ); ?></label>
		<input type="text" name="edd-payment-address[city]" value="<?php echo( ! empty( $address['city'] ) ? esc_attr( $address['city'] ) : '' ); ?>" id="city" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div">
		<label class="edd-invoices-field edd-invoices-custom-field" for="zip"><?php _e( 'Zip / Postal Code:', 'edd-invoices' ); ?></label>
		<input type="text" name="edd-payment-address[zip]" value="<?php echo( ! empty( $address['zip'] ) ? esc_attr( $address['zip'] ) : '' ); ?>" id="zip" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div">
		<label class="edd-invoices-field edd-invoices-custom-field" for="country"><?php _e( 'Country:', 'edd-invoices' ); ?></label>
		<select name="edd-payment-address[country]" size="1" id="country">
			<?php
			$users_country = ! empty( $address['country'] ) ? $address['country'] : '';
			foreach ( edd_get_country_list() as $key => $value ) {
				?>
				<option value="<?php echo esc_attr( $key ); ?>"<?php selected( $users_country, $key ); ?>><?php echo esc_html( $value ); ?></option>
				<?php
			}
			?>
		</select>
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div">
		<label class="edd-invoices-field edd-invoices-custom-field" for="state"><?php _e( 'County / State:', 'edd-invoices' ); ?></label>
		<input type="text" name="edd-payment-address[state]" value="<?php echo( ! empty( $address['state'] ) ? esc_attr( $address['state'] ) : '' ); ?>" id="state" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div">
		<label class="edd-invoices-field edd-invoices-custom-field" for="vat"><?php _e( 'Tax/VAT Number:', 'edd-invoices' ); ?></label>
		<input type="text" name="edd-payment-vat" value="<?php echo esc_attr( $vat ); ?>" id="vat" />
	</div>
	<div class="edd-invoices-div edd-invoices-custom-div">
		<label class="edd-invoices-field edd-invoices-custom-field" for="notes"><?php _e( 'Custom Notes:', 'edd-invoices' ); ?></label>
		<textarea name="edd-payment-notes"><?php echo esc_textarea( $notes ); ?></textarea>
	</div>
	<?php
	if ( ! empty( $address['id'] ) ) {
		?>
		<input name="address-id" type="hidden" value="<?php echo esc_attr( $address['id'] ); ?>" />
		<?php
	}
	?>
	<div class="edd-invoices-div edd-invoices-custom-div">
		<?php wp_nonce_field('edd-invoices'.'-generate-invoice', 'edd-invoices'.'-nonce'); ?>
		<input type="submit" class="edd-invoices-generate-invoice-button edd_submit button button-secondary" value="<?php echo esc_attr( apply_filters( 'edd_invoices_generate_invoice_button_text', __( 'Save Billing Details &amp; Generate Invoice', 'edd-invoices' ) ) ); ?>" />
	</div>
</form>
