<?php
/**
 * Shortcodes
 *
 * @package   edd-invoices
 * @copyright Copyright (c) 2021, Sandhills Development, LLC
 * @license   GPL2+
 * @since     1.2
 */

/**
 * Shows the form to allow the user to enter their billing information, before seeing an on-screen
 * HTML invoice.
 *
 * @param array  $atts
 * @param string $content
 *
 * @since 1.2
 * @return string
 */
function edd_invoices_shortcode( $atts, $content = '' ) {
	if ( ! edd_get_option( 'edd-invoices-page' ) ) {
		return '';
	}

	$generator = new EDD_Invoice_Generator();

	$generator->validate_request();

	if ( ! $generator->is_valid_request() ) {
		return implode( '<br>', $generator->get_error_messages() );
	}

	if ( ! edd_invoices_can_user_edit_invoice_data( get_current_user_id() ) ) {
		return __( 'You do not have permission to update this invoice.', 'edd-invoices' );
	}

	$order   = $generator->order;
	$address = edd_invoices_get_order_address( $order );
	$vat     = edd_invoices_get_custom_order_meta( $order, 'invoices_vat' );
	$notes   = edd_invoices_get_custom_order_meta( $order, 'invoices_notes' );
	$company = edd_invoices_get_custom_order_meta( $order, 'invoices_company' );

	// Generate form URL.
	$url = esc_url( add_query_arg( array(
		'payment_id' => urlencode( $order->ID ),
	) ), get_permalink( edd_get_option( 'edd-invoices-page' ) ) );

	// Output form
	// @todo template-ize
	ob_start();
	include_once EDD_INVOICES_PLUGIN_DIR . 'views/form.php';

	return ob_get_clean();
}

add_shortcode( 'edd_invoices', 'edd_invoices_shortcode' );
