<?php
/**
 * Invoice PDF
 *
 * @package   edd-invoice
 * @copyright Copyright (c) 2021, Sandhills Development, LLC
 * @license   GPL2+
 * @since     1.3
 */

add_action( 'edd_invoices_invoice_head', 'edd_invoices_load_pdf_scripts' );
/**
 * Enqueues and loads the scripts needed to generate PDF invoices.
 *
 * @since 1.3
 * @return void
 */
function edd_invoices_load_pdf_scripts() {
	$minify = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
	wp_register_script( 'html2pdf', EDD_INVOICES_PLUGIN_URL . "js/html2pdf.bundle{$minify}.js", array(), '0.9.3', true );
	wp_register_script( 'edd-invoices-pdf', EDD_INVOICES_PLUGIN_URL . 'js/edd-invoices-pdf.js', array( 'html2pdf' ), EDD_INVOICES_VERSION, true );
	wp_print_scripts( 'edd-invoices-pdf' );
}

/**
 * If PDF Invoices is not active, redirects PDF Invoice links to the new invoice.
 *
 * @since 1.3
 * @return void
 */
add_action( 'edd_generate_pdf_invoice', function() {
	if ( function_exists( 'edd_pdf_invoices' ) ) {
		return;
	}
	$order_id = filter_input( INPUT_GET, 'purchase_id', FILTER_SANITIZE_NUMBER_INT );
	if ( empty( $order_id ) ) {
		return;
	}
	$input_email = filter_input( INPUT_GET, 'email', FILTER_SANITIZE_EMAIL );
	$input_key   = ! empty( $_GET['purchase_key'] ) ? sanitize_text_field( $_GET['purchase_key'] ) : '';
	$key         = false;
	if ( function_exists( 'edd_get_order' ) ) {
		$order = edd_get_order( intval( $order_id ) );
		if ( ! empty( $order->payment_key ) ) {
			$key = $order->payment_key;
		}
	} else {
		$order = edd_get_payment( intval( $order_id ) );
		if ( ! empty( $order->payment_meta['key'] ) ) {
			$key = $order->payment_meta['key'];
		}
	}
	foreach ( array( $input_email, $input_key, $key ) as $item_to_check ) {
		if ( empty( $item_to_check ) ) {
			return;
		}
	}

	if ( $input_email === $order->email && $input_key === $key ) {
		wp_safe_redirect( edd_invoices_get_invoice_url( $order_id, true ) );
		exit;
	}
	wp_die( esc_html__( 'You do not have permission to view this invoice.', 'edd-invoices' ), esc_html__( 'Access Denied', 'edd-invoices' ), array( 'response' => 403 ) );
} );
