<?php
/**
 * Email Functions
 *
 * @package   edd-invoices
 * @copyright Copyright (c) 2021, Sandhills Development, LLC
 * @license   GPL2+
 * @since     1.3
 */

add_action( 'edd_add_email_tags', 'edd_invoices_register_email_tag' );
/**
 * Register an email tag to view an invoice.
 *
 * @since 1.3
 * @return void
 */
function edd_invoices_register_email_tag() {
	edd_add_email_tag(
		'edd_invoice',
		__( 'Creates a link to a printable invoice.', 'edd-invoices' ),
		'edd_invoices_get_email_invoice_link',
		__( 'Invoice', 'edd-invoices' )
	);
}

/**
 * Gets the invoice URL to include in an email.
 *
 * @param int $order_id
 * @return string
 */
function edd_invoices_get_email_invoice_link( $order_id ) {
	if ( empty( $order_id ) || ! in_array( edd_get_payment_status( $order_id ), edd_invoices_get_invoiceable_order_statuses(), true ) ) {
		return '';
	}

	return sprintf(
		'<a href="%s">%s</a>',
		esc_url( edd_invoices_get_invoice_url( $order_id, true ) ),
		__( 'View Invoice', 'edd-invoices' )
	);
}
