<?php
/**
 * Admin Actions
 *
 * @package   edd-invoices
 * @copyright Copyright (c) 2021, Sandhills Development, LLC
 * @license   GPL2+
 * @since     1.3
 */

/**
 * Adds a "View Invoice" link to the order row actions.
 *
 * @since 1.3
 * @param array                         $row_actions The array of actions links for the order.
 * @param \EDD\Orders\Order|EDD_Payment $order       The order (EDD 3.0) or payment (2.x) object.
 * @return array
 */
function edd_invoices_row_actions( $row_actions, $order ) {

	if ( ! in_array( edd_get_payment_status( $order->ID ), edd_invoices_get_invoiceable_order_statuses(), true ) ) {
		return $row_actions;
	}

	$row_actions['invoices'] = sprintf(
		'<a href="%s" target="_blank">%s</a>',
		esc_url( edd_invoices_get_invoice_url( $order->ID, true ) ),
		__( 'View Invoice', 'edd-invoices' )
	);

	return $row_actions;
}

add_action( 'admin_init', function() {
	$hook = function_exists( 'edd_get_order' ) ? 'order' : 'payment';
	add_filter( "edd_{$hook}_row_actions", 'edd_invoices_row_actions', 10, 2 );
} );

/**
 * Adds a "View Invoice" link to the payment/order details screen, after the "Resend Receipt" button.
 *
 * @since 1.3
 * @param int $order_id The order ID.
 * @return void
 */
function edd_invoices_show_invoice_link_payment_details( $order_id ) {

	if ( ! in_array( edd_get_payment_status( $order_id ), edd_invoices_get_invoiceable_order_statuses(), true ) ) {
		return;
	}

	printf(
		'<p><a href="%s" class="button button-secondary" target="_blank">%s</a></p>',
		esc_url( edd_invoices_get_invoice_url( $order_id, true ) ),
		esc_html__( 'View Invoice', 'edd-invoices' )
	);
}
add_action( 'edd_view_order_details_resend_receipt_after', 'edd_invoices_show_invoice_link_payment_details' );
