<?php

/*
 * Plugin Name: Easy Social Share Buttons for WordPress Template Pack - Christmas
 * Description: Activate usage of special holiday Christmas template
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Version: 1.0
 * Author: CreoApps
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

define('ESSB_TEMPLATEPACK_CHRISTMAS', '1.0');

add_filter('essb4_templates', 'essb_template_christmas_initialize');
add_filter('essb4_templates_class', 'essb_template_christmas_class', 10, 2);
add_action('plugins_loaded', 'essb_template_christmas_styles', 999);
add_action ('admin_enqueue_scripts', 'essb_template_christmas_styles_admin', 999 );

function essb_template_christmas_initialize($templates) {
	$templates['901'] = 'Christmas Baubles (Retina)';
	$templates['902'] = 'Christmas Presents (Retina)';
	
	return $templates;
}

function essb_template_christmas_class($folder, $template_id) {
	if ($template_id == '901') {
		$folder = 'christmas-retina';
	}
	if ($template_id == '902') {
		$folder = 'christmas-retina essb_template_christmas-presents-retina';
	}
	
	return $folder;
}

function essb_template_christmas_styles() {
	
	if (function_exists('essb_resource_builder')) {
		essb_resource_builder()->add_static_resource(plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) . '/assets/essb-template.css', 'essb-template-pack-christmas', 'css');
	}
	
}

function essb_template_christmas_styles_admin() {
	wp_register_style ( 'essb-admin3-style-christmas', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) . '/assets/essb-template.css', array (), '1.0' );
	wp_enqueue_style ( 'essb-admin3-style-christmas' );
}