<?php
global $essbab_options_structure;
if (! class_exists ( 'ESSBOptionsStructureHelperShared4' ) && defined ( 'ESSB3_VERSION' )) {
	include_once (ESSB3_PLUGIN_ROOT . 'lib/core/options/essb-options-structure-shared4.php');

}

if (! class_exists ( 'ESSBOptionsStructureHelperShared4' )) {
	return;
}

$essbab_options_structure = new ESSBOptionsStructureHelperShared4 ();
$essbab_options_structure->tab ( 'settings', __ ( 'Social A/B', 'essb-ab' ), __ ( 'Social A/B', 'essb-ab' ) );

$essbab_options_structure->menu_item ( 'settings', 'settings', __ ( 'Settings', 'essb-ab' ), 'default' );
$essbab_options_structure->menu_item ( 'settings', 'report', __ ( 'Report', 'essb-ab' ), 'pie-chart' );
$essbab_options_structure->menu_item ( 'settings', 'setting1', __ ( 'Configuration #1', 'essb-ab' ), 'ti-layout-grid2-alt', 'activate_first', 'setting1-1' );
essbab_register_configration_options ( 'setting1', 'ab1_' );
$essbab_options_structure->menu_item ( 'settings', 'setting2', __ ( 'Configuration #2', 'essb-ab' ), 'ti-layout-grid2-alt', 'activate_first', 'setting2-1' );
essbab_register_configration_options ( 'setting2', 'ab2_' );
$essbab_options_structure->menu_item ( 'settings', 'setting3', __ ( 'Configuration #3', 'essb-ab' ), 'ti-layout-grid2-alt', 'activate_first', 'setting3-1' );
essbab_register_configration_options ( 'setting3', 'ab3_' );

$essbab_options_structure->field_switch ( 'settings', 'settings', 'ab_active', __ ( 'Activate A/B tests', 'essb-ab' ), __ ( 'Activate split test of social sharing buttons configuration', 'essb-ab' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
$essbab_options_structure->field_switch ( 'settings', 'settings', 'ab_reset', __ ( 'Reset collected data on activation', 'essb-ab' ), __ ( 'Activate this option if you wish to clear your current collected data and start from the beginning', 'essb-ab' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
$essbab_options_structure->field_select ( 'settings', 'settings', 'ab_count', __ ( 'Number of concurent configurations', 'essb-ab' ), __ ( 'Choose number of concurent configurations that you will use currently on site. Social A/B add-on can take up to 3 configrations that will run at same time', 'essb-ab' ), array ("2" => "2 Configurations - Configuration #1, Configuration #2", '3' => '3 Configurations - Configuration #1, Configuration #2, Configuration #3' ) );

$essbab_options_structure->field_func ( 'settings', 'report', 'essb4_ab_report', __ ( '', 'essb' ), __ ( '', 'essb' ) );

function essbab_register_configration_options($menu_id, $configuration_id) {
	global $essbab_options_structure;
	
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-1', __ ( 'Positions', 'essb' ), 'default' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-2', __ ( 'Display Position Settings', 'essb' ), 'chevron-down', 'menu', 'title' );
	
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-3', __ ( 'Content Top', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-4', __ ( 'Content Bottom', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-5', __ ( 'Float from top', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-6', __ ( 'Post vertical float', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-7', __ ( 'Sidebar', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-8', __ ( 'Top bar', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-9', __ ( 'Bottom bar', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-10', __ ( 'Pop up', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-11', __ ( 'Fly in', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-12', __ ( 'On media', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-13', __ ( 'Full screen hero share', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-14', __ ( 'Post share bar', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-15', __ ( 'Point', 'essb' ), 'default', 'menu', 'true' );
	$essbab_options_structure->submenu_item ( 'settings', $menu_id . '-16', __ ( 'Excerpt', 'essb' ), 'default', 'menu', 'true' );
	
	// each location setup
	$essbab_options_structure->structure_row_start ( 'settings', $menu_id . '-1' );
	$essbab_options_structure->structure_section_start ( 'settings', $menu_id . '-1', 'c12', __ ( 'Primary content display position', 'essb' ), __ ( 'Choose default method that will be used to render buttons inside content', 'essb' ) );
	$essbab_options_structure->field_image_radio ( 'settings', $menu_id . '-1', $configuration_id . 'content_position', '', '', essb_avaliable_content_positions () );
	$essbab_options_structure->structure_section_end ( 'settings', $menu_id . '-1' );
	$essbab_options_structure->structure_row_end ( 'settings', $menu_id . '-1' );
	
	$essbab_options_structure->structure_row_start ( 'settings', $menu_id . '-1' );
	$essbab_options_structure->structure_section_start ( 'settings', $menu_id . '-1', 'c12', __ ( 'Additional button display positions', 'essb' ), __ ( 'Choose additional display methods that can be used to display buttons.', 'essb' ) );
	$essbab_options_structure->field_image_checkbox ( 'settings', $menu_id . '-1', $configuration_id . 'button_position', '', '', essb_available_button_positions () );
	$essbab_options_structure->structure_section_end ( 'settings', $menu_id . '-1' );
	$essbab_options_structure->structure_row_end ( 'settings', $menu_id . '-1' );
	
	add_action ( 'admin_init', 'essb3_register_positions_by_posttypes' );
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-3', $configuration_id . 'top' );
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-4', $configuration_id . 'bottom' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-5', __ ( 'Set custom top position of float bar', 'essb' ), __ ( 'If your current theme has fixed bar or menu you may need to provide custom top position of float or it will be rendered below this sticked bar. For example you can try with value 40 (which is equal to 40px from top).', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-5', $configuration_id . 'float_top', __ ( 'Top position for non logged in users', 'essb' ), __ ( '', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-5', $configuration_id . 'float_top_loggedin', __ ( 'Top position for logged in users', 'essb' ), __ ( 'If you display WordPress admin bar for logged in users you can correct float from top position for logged in users to avoid bar to be rendered below WordPress admin bar.', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-5', $configuration_id . 'float_top_disappear', __ ( 'Hide buttons after percent of content is viewed', 'essb' ), __ ( 'Provide value in percent if you wish to hide float bar - for example 80 will make bar to disappear when 80% of page content is viewed from user.', 'essb' ), '', 'input60', 'fa-sort-numeric-asc', 'right' );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-5' );
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-5', __ ( 'Background color', 'essb' ), __ ( 'Change default background color of float bar (default is white #FFFFFF).', 'essb' ) );
	$essbab_options_structure->field_color_panel ( 'settings', $menu_id . '-5', $configuration_id . 'float_bg', __ ( 'Choose background color', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-5', $configuration_id . 'float_bg_opacity', __ ( 'Change opacity of background color', 'essb' ), __ ( 'Change default opacity of background color if you wish to have a semi-transparent effect (default is 1 full color). You can enter value between 0 and 1 (example: 0.7)', 'essb' ), '', 'input60' );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-5' );
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-5', __ ( 'Width and positioning settings', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-5', $configuration_id . 'float_full', __ ( 'Set full width of float bar', 'essb' ), __ ( 'This option will make float bar to take full width of browser window.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-5', $configuration_id . 'float_full_maxwidth', __ ( 'Max width of buttons area', 'essb' ), __ ( 'Provide custom max width of buttons area when full width float bar is active. Provide number value in pixels without the px (example 960)', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-5', $configuration_id . 'float_remove_margin', __ ( 'Remove top space', 'essb' ), __ ( 'This option will clear the blank space that may appear according to theme settings between top of window and float bar.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-5' );
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-5', $configuration_id . 'float' );
	
	$essbab_options_structure->field_section_start_full_panels ( 'settings', $menu_id . '-6' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-6', $configuration_id . 'postfloat_initialtop', __ ( 'Custom top position of post float bar when loaded', 'essb' ), __ ( 'Customize the initial top position of post float bar if you wish to be different from content start.', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-6', $configuration_id . 'postfloat_top', __ ( 'Top position of post float buttons when they are fixed', 'essb' ), __ ( 'Filled value to change the top position if you have another fixed element (example: fixed menu).', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-6', $configuration_id . 'postfloat_marginleft', __ ( 'Horizontal offset from content', 'essb' ), __ ( 'You can provide custom left offset from content. Leave blank to use default value.', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-6', $configuration_id . 'postfloat_margintop', __ ( 'Vertical offset from content start', 'essb' ), __ ( 'You can provide custom vertical offset from content start. Leave blank to use default value. (Negative values moves up, positve moves down).', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-6', $configuration_id . 'postfloat_percent', __ ( 'Display after percent of content is passed', 'essb' ), __ ( 'Provide percent of content to viewed when buttons will appear (default state if this field is provided will be hidden for that display method).', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-6', $configuration_id . 'postfloat_always_visible', __ ( 'Do not hide post vertical float at the end of content', 'essb' ), __ ( 'Activate this option to make post vertical float stay on screen when end of post content is reached.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_section_end_full_panels ( 'settings', $menu_id . '-6' );
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-6', $configuration_id . 'postfloat' );
	
	$listOfOptions = array ("" => "Left", "right" => "Right" );
	$essbab_options_structure->field_select ( 'settings', $menu_id . '-7', $configuration_id . 'sidebar_pos', __ ( 'Sidebar Appearance', 'essb' ), __ ( 'You choose different position for sidebar. Available options are Left (default), Right', 'essb' ), $listOfOptions );
	$essbab_options_structure->field_section_start_full_panels ( 'settings', $menu_id . '-7', __ ( 'Left or Right sidebar appearance options', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-7', $configuration_id . 'sidebar_fixedleft', __ ( 'Customize left/right position of sidebar', 'essb' ), __ ( 'Use this field to change initial position of sidebar. You can use numeric value for example 10.', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-7', $configuration_id . 'sidebar_fixedtop', __ ( 'Fixed top position of sidebar', 'essb' ), __ ( 'You can provide custom top position of sidebar in pixels or percents (ex: 100px, 15%).', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-7', $configuration_id . 'sidebar_leftright_percent', __ ( 'Display after percent of content is viewed', 'essb' ), __ ( 'If you wish to make sidebar appear after percent of content is viewed enter value here (leave blank to appear immediately after load).', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-7', $configuration_id . 'sidebar_leftright_percent_hide', __ ( 'Hide after percent of content is viewed', 'essb' ), __ ( 'If you wish to make sidebar disappear after percent of content is viewed enter value here (leave blank to make it always be visible).', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-7', $configuration_id . 'sidebar_leftright_close', __ ( 'Add close sidebar button', 'essb' ), __ ( 'Activate that option to add a close sidebar button.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$sidebar_loading_animations = array ("" => __ ( "No animation", "essb" ), "slide" => __ ( "Slide", "essb" ), "fade" => __ ( "Fade", "essb" ) );
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-7', $configuration_id . 'sidebar_entry_ani', __ ( 'Display animation', 'essb' ), __ ( 'Assign sidebar initial appearance animation - a nice way to catch visitors attention.', 'essb' ), $sidebar_loading_animations );
	$essbab_options_structure->field_section_end_full_panels ( 'settings', $menu_id . '-7' );
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-7', $configuration_id . 'sidebar' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-8', __ ( 'Top bar appearance', 'essb' ), __ ( 'If your current theme has fixed bar or menu you may need to provide custom top position of top bar or it will be rendered below this sticked bar. For example you can try with value 40 (which is equal to 40px from top).', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_top', __ ( 'Top position for non logged in users', 'essb' ), __ ( '', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_top_loggedin', __ ( 'Top position for logged in users', 'essb' ), __ ( 'f you display WordPress admin bar for logged in users you can correct float from top position for logged in users to avoid bar to be rendered below WordPress admin bar.', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_top_onscroll', __ ( 'Appear after percent of content is viewed', 'essb' ), __ ( 'If you wish top bar to appear when user starts scrolling fill here percent of conent after is viewed it will be visible.', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_hide', __ ( 'Hide buttons after percent of content is viewed', 'essb' ), __ ( 'Provide value in percent if you wish to hide float bar - for example 80 will make bar to disappear when 80% of page content is viewed from user.', 'essb' ), '', 'input60', 'fa-sort-numeric-asc', 'right' );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-8' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-8', __ ( 'Background color', 'essb' ), __ ( 'Change default background color of top bar (default is white #FFFFFF).', 'essb' ) );
	$essbab_options_structure->field_color_panel ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_bg', __ ( 'Choose background color', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_bg_opacity', __ ( 'Change opacity of background color', 'essb' ), __ ( 'Change default opacity of background color if you wish to have a semi-transparent effect (default is 1 full color). You can enter value between 0 and 1 (example: 0.7)', 'essb' ), '', 'input60' );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-8' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-8', __ ( 'Top bar width, height & placement', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_height', __ ( 'Height of top bar content area', 'essb' ), __ ( 'Provide custom height of content area. Provide number value in pixels without the px (example 40). Leave blank for default height.', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_maxwidth', __ ( 'Max width of content area', 'essb' ), __ ( 'Provide custom max width of content area. Provide number value in pixels without the px (example 960). Leave blank for full width.', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$listOfOptions = array ("left" => "Left", "center" => "Center", "right" => "Right" );
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_buttons_align', __ ( 'Align buttons', 'essb' ), __ ( 'Choose your button alignment', 'essb' ), $listOfOptions );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-8' );
	
	$essbab_options_structure->panel_start ( 'settings', $menu_id . '-8', __ ( 'TOP BAR CUSTOM CONTENT SETTINGS', 'essb' ), __ ( 'Include custom content into top bar along with your share buttons' ), 'fa21 fa fa-cogs', array ("mode" => "switch", 'switch_id' => 'topbar_contentarea', 'switch_on' => __ ( 'Yes', 'essb' ), 'switch_off' => __ ( 'No', 'essb' ) ) );
	$essbab_options_structure->field_section_start_full_panels ( 'settings', $menu_id . '-8', __ ( 'Background color', 'essb' ), __ ( 'Change default background color of top bar (default is white #FFFFFF).', 'essb' ) );
	$listOfOptions = array ("left" => "Left", "right" => "Right" );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_contentarea_width', __ ( 'Custom content area % width', 'essb' ), __ ( 'Provide custom width of content area (default value if nothing is filled is 30 which means 30%). Fill number value without % mark - example 40.', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_contentarea_pos', __ ( 'Custom content area position', 'essb' ), __ ( 'Choose your content area alignment', 'essb' ), $listOfOptions );
	$essbab_options_structure->field_section_end_full_panels ( 'settings', $menu_id . '-8' );
	$essbab_options_structure->field_wpeditor ( 'settings', $menu_id . '-8', $configuration_id . 'topbar_usercontent', __ ( 'Custom content', 'essb' ), '', 'htmlmixed' );
	$essbab_options_structure->panel_end ( 'settings', $menu_id . '-8' );
	// $essbab_options_structure->field_section_end('settings', $menu_id.'-8');
	
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-8', $configuration_id . 'topbar' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-9', __ ( 'Bottom bar appearance', 'essb' ), __ ( 'Use to fit the buttons to the style of your footer area.', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-9', $configuration_id . 'bottombar_top_onscroll', __ ( 'Appear after percent of content is viewed', 'essb' ), __ ( 'If you wish bottom bar to appear when user starts scrolling fill here percent of conent after is viewed it will be visible.', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-9', $configuration_id . 'bottombar_hide', __ ( 'Hide buttons after percent of content is viewed', 'essb' ), __ ( 'Provide value in percent if you wish to hide float bar - for example 80 will make bar to disappear when 80% of page content is viewed from user.', 'essb' ), '', 'input60', 'fa-sort-numeric-asc', 'right' );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-9' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-9', __ ( 'Background color', 'essb' ), __ ( 'Change default background color of bottom bar (default is white #FFFFFF).', 'essb' ) );
	$essbab_options_structure->field_color_panel ( 'settings', $menu_id . '-9', $configuration_id . 'bottombar_bg', __ ( 'Choose background color', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-9', $configuration_id . 'bottombar_bg_opacity', __ ( 'Change opacity of background color', 'essb' ), __ ( 'Change default opacity of background color if you wish to have a semi-transparent effect (default is 1 full color). You can enter value between 0 and 1 (example: 0.7)', 'essb' ), '', 'input60' );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-9' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-9', __ ( 'Bottom bar width, height & placement', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-9', $configuration_id . 'bottombar_height', __ ( 'Height of top bar content area', 'essb' ), __ ( 'Provide custom height of content area. Provide number value in pixels without the px (example 40). Leave blank for default value.', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-9', $configuration_id . 'bottombar_maxwidth', __ ( 'Max width of content area', 'essb' ), __ ( 'Provide custom max width of content area. Provide number value in pixels without the px (example 960). Leave blank for full width.', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$listOfOptions = array ("left" => "Left", "center" => "Center", "right" => "Right" );
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-9', $configuration_id . 'bottombar_buttons_align', __ ( 'Align buttons', 'essb' ), __ ( 'Choose your content area alignment', 'essb' ), $listOfOptions );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-9' );
	
	$essbab_options_structure->panel_start ( 'settings', $menu_id . '-9', __ ( 'BOTTOM BAR CUSTOM CONTENT SETTINGS', 'essb' ), __ ( 'Include custom content into bottom bar along with your share buttons' ), 'fa21 fa fa-cogs', array ("mode" => "switch", 'switch_id' => 'bottombar_contentarea', 'switch_on' => __ ( 'Yes', 'essb' ), 'switch_off' => __ ( 'No', 'essb' ) ) );
	$essbab_options_structure->field_section_start_full_panels ( 'settings', $menu_id . '-9', __ ( 'Bottom bar content settings', 'essb' ), __ ( '', 'essb' ) );
	$listOfOptions = array ("left" => "Left", "right" => "Right" );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-9', $configuration_id . 'bottombar_contentarea_width', __ ( 'Custom content area % width', 'essb' ), __ ( 'Provide custom width of content area (default value if nothing is filled is 30 which means 30%). Fill number value without % mark - example 40.', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-9', $configuration_id . 'bottombar_contentarea_pos', __ ( 'Custom content area position', 'essb' ), __ ( 'Choose your button alignment', 'essb' ), $listOfOptions );
	$essbab_options_structure->field_section_end_full_panels ( 'settings', $menu_id . '-9' );
	$essbab_options_structure->field_wpeditor ( 'settings', $menu_id . '-9', $configuration_id . 'bottombar_usercontent', __ ( 'Custom content', 'essb' ), '', 'htmlmixed' );
	$essbab_options_structure->panel_end ( 'settings', $menu_id . '-9' );
	
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-9', $configuration_id . 'bottombar' );
	
	$essbab_options_structure->field_section_start ( 'settings', $menu_id . '-10', __ ( 'Pop up window settings', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_stretched ( 'settings', $menu_id . '-10', $configuration_id . 'popup_window_title', __ ( 'Pop up window title', 'essb' ), __ ( 'Set your custom pop up window title.', 'essb' ) );
	$essbab_options_structure->field_editor ( 'settings', $menu_id . '-10', $configuration_id . 'popup_user_message', __ ( 'Pop up window message', 'essb' ), __ ( 'Set your custom message that will appear above buttons', 'essb' ), "htmlmixed" );
	$essbab_options_structure->field_textbox ( 'settings', $menu_id . '-10', $configuration_id . 'popup_user_width', __ ( 'Pop up window width', 'essb' ), __ ( 'Set your custom window width (default is 800 or window width - 60). Value if provided should be numeric without px symbols.', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$essbab_options_structure->field_section_end ( 'settings', $menu_id . '-10' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-10', __ ( 'Pop up window display', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_window_popafter', __ ( 'Display pop up window after (sec)', 'essb' ), __ ( 'If you wish pop up window to appear after amount of seconds you can provide theme here. Leave blank for immediate pop up after page load.', 'essb' ), '', 'input60', 'fa-clock-o', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_user_percent', __ ( 'Display pop up window after percent of content is viewed', 'essb' ), __ ( 'Set amount of page content after which the pop up will appear.', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_display_end', __ ( 'Display pop up at the end of content', 'essb' ), __ ( 'Automatically display pop up when the content end is reached', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_display_exit', __ ( 'Display pop up on exit intent', 'essb' ), __ ( 'Automatically display pop up when exit intent is detected', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_display_comment', __ ( 'Display pop up on user comment', 'essb' ), __ ( 'Automatically display pop up when user leave a comment.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_display_purchase', __ ( 'Display pop up after WooCommerce purchase', 'essb' ), __ ( 'Display on Thank You page of WooCommerce after purchase', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_user_manual_show', __ ( 'Manual window display mode', 'essb' ), __ ( 'Activating manual display mode will allow you to show window when you decide with calling following javascript function essb_popup_show();', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_avoid_logged_users', __ ( 'Do not show pop up for logged in users', 'essb' ), __ ( 'Activate this option to avoid display of pop up when user is logged in into site.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-10' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-10', __ ( 'Pop up window close', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_window_close_after', __ ( 'Automatically close pop up after (sec)', 'essb' ), __ ( 'You can provide seconds and after they expire window will close automatically. User can close this window manually by pressing close button.', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_user_autoclose', __ ( 'Close up message customize', 'essb' ), __ ( 'Set custom text announcement for closing the pop up. After your text there will be timer counting the seconds leaving.', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_user_notshow_onclose', __ ( 'After user close window do not show it again on this page/post for him', 'essb' ), __ ( 'Activating this option will set cookie that will not show again pop up message for next 7 days for user on this post/page', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-10', $configuration_id . 'popup_user_notshow_onclose_all', __ ( 'After user close window do not show it again on all page/post for him', 'essb' ), __ ( 'Activating this option will set cookie that will not show again pop up message for next 7 days for user on all posts/pages', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-10' );
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-10', $configuration_id . 'popup' );
	
	$essbab_options_structure->field_section_start ( 'settings', $menu_id . '-11', __ ( 'Fly In window settings', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_stretched ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_window_title', __ ( 'Fly in window title', 'essb' ), __ ( 'Set your custom fly in window title.', 'essb' ) );
	$essbab_options_structure->field_editor ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_user_message', __ ( 'Fly in window message', 'essb' ), __ ( 'Set your custom message that will appear above buttons', 'essb' ), "htmlmixed" );
	$essbab_options_structure->field_textbox ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_user_width', __ ( 'Fly in window width', 'essb' ), __ ( 'Set your custom window width (default is 400 or window width - 60). If value is provided should be numeric without px symbols.', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$listOfOptions = array ("right" => "Right", "left" => "Left" );
	$essbab_options_structure->field_select ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_position', __ ( 'Choose fly in display position', 'essb' ), '', $listOfOptions );
	$essbab_options_structure->field_section_end ( 'settings', $menu_id . '-11' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-11', __ ( 'Fly in window display', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_window_popafter', __ ( 'Display fly in window after (sec)', 'essb' ), __ ( 'If you wish fly in window to appear after amount of seconds you can provide them here. Leave blank for immediate pop up after page load.', 'essb' ), '', 'input60', 'fa-clock-o', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_user_percent', __ ( 'Display fly in window after percent of content is viewed', 'essb' ), __ ( 'Set amount of page content after which the pop up will appear.', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_display_end', __ ( 'Display fly in at the end of content', 'essb' ), __ ( 'Automatically display fly in when the content end is reached.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_display_comment', __ ( 'Display fly in on user comment', 'essb' ), __ ( 'Automatically display fly in when user leaves a comment.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_user_manual_show', __ ( 'Manual fly in display mode', 'essb' ), __ ( 'Activating manual display mode will allow you to show window when you decide with calling following javascript function essb_flyin_show();', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-11' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-11', __ ( 'Fly in window close', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_window_close_after', __ ( 'Automatically close fly in after (sec)', 'essb' ), __ ( 'You can provide seconds and after they expire window will close automatically. User can close this window manually by pressing close button.', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_user_autoclose', __ ( 'Close up message customize', 'essb' ), __ ( 'Set custom text announcement for closing the fly in. After your text there will be timer counting the seconds leaving.', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_user_notshow_onclose', __ ( 'After user closes window do not show it again on this page/post for him', 'essb' ), __ ( 'Activating this option will set cookie that will not show again pop up message for next 7 days for user on this post/page', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_user_notshow_onclose_all', __ ( 'After user close window do not show it again on all page/post for him', 'essb' ), __ ( 'Activating this option will set cookie that will not show again pop up message for next 7 days for user on all posts/pages', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-11' );
	$essbab_options_structure->field_switch ( 'settings', $menu_id . '-11', $configuration_id . 'flyin_noshare', __ ( 'Do not show share buttons in fly in', 'essb' ), __ ( 'Activating this you will get a fly in display without share buttons in it - only the custom content you have set.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-11', 'flyin' );
	
	$essbab_options_structure->panel_start ( 'settings', $menu_id . '-12', __ ( 'On media buttons appearance', 'essb' ), __ ( 'Choose where you wish buttons to appear', 'essb' ), 'fa21 ti-layout-grid2-alt', array ("mode" => "toggle" ) );
	$essbab_options_structure->field_section_start_full_panels ( 'settings', $menu_id . '-12', __ ( 'Appearance', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-12', $configuration_id . 'sis_selector', __ ( 'Default image share selector', 'essb' ), __ ( 'Provide your own custom image selector that will allow to pickup share images. Leave blank for use the default or use <b>.essbis_site img</b> to allow share of any image on site.', 'essb' ) );
	// $essbab_options_structure->field_textbox('settings', $menu_id.'-12',
	// 'sis_dontshow', __('Do not show on', 'essb'), __('Set image classes and
	// IDs for which on media display buttons won\'t show. Separate several
	// selectors with commas.', 'essb'));
	// $essbab_options_structure->field_textbox('settings', $menu_id.'-12',
	// 'sis_dontaddclass', __('Do not move following classes', 'essb'),
	// __('Provide image classes that you wish not to be moved to on media
	// sharing element. If you use multiple selectors separate them with ,',
	// 'essb'));
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-12', $configuration_id . 'sis_minWidth', __ ( 'Minimal width', 'essb' ), __ ( 'Minimum width of image for sharing. Use value without px.', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-12', $configuration_id . 'sis_minHeight', __ ( 'Minimal height', 'essb' ), __ ( 'Minimum height of image for sharing. Use value without px.', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-12', $configuration_id . 'sis_on_mobile', __ ( 'Enable on mobile', 'essb' ), __ ( 'Enable image sharing on mobile devices', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_section_end_full_panels ( 'settings', $menu_id . '-12' );
	$essbab_options_structure->panel_end ( 'settings', $menu_id . '-12' );
	
	$essbab_options_structure->panel_start ( 'settings', $menu_id . '-12', __ ( 'Use the following social buttons', 'essb' ), __ ( 'Choose social buttons that you will use on media images', 'essb' ), 'fa21 ti-layout-grid2-alt', array ("mode" => "toggle" ) );
	$listOfNetworks = array ("facebook", "twitter", "google", "linkedin", "pinterest", "tumblr", "reddit", "digg", "delicious", "vkontakte", "odnoklassniki" );
	$listOfNetworksAdvanced = array ("facebook" => "Facebook", "twitter" => "Twitter", "google" => "Google", "linkedin" => "LinkedIn", "pinterest" => "Pinterest", "tumblr" => "Tumblr", "reddit" => "Reddit", "digg" => "Digg", "delicious" => "Delicious", "vkontakte" => "VKontakte", "odnoklassniki" => "Odnoklassniki" );
	$essbab_options_structure->field_checkbox_list ( 'settings', $menu_id . '-12', $configuration_id . 'sis_networks', __ ( 'Activate networks', 'essb' ), __ ( 'Choose active social networks', 'essb' ), $listOfNetworksAdvanced );
	$essbab_options_structure->field_simplesort ( 'settings', $menu_id . '-12', $configuration_id . 'sis_network_order', __ ( 'Display order', 'essb' ), __ ( 'Arrange network appearance using drag and drop', 'essb' ), $listOfNetworks );
	// $essbab_options_structure->field_section_start('settings',
	// $menu_id.'-12', __('Share Options', 'essb'), __('', 'essb'));
	// $essbab_options_structure->field_switch('settings', $menu_id.'-12',
	// 'sis_sharer', __('Share selected image<div
	// class="essb-new"><span></span></div><div
	// class="essb-beta"><span></span></div>', 'essb'), __('Activate this option
	// to make plugin include selected image into share. Please note that
	// activating that option will make share counter not to include that shares
	// in it because url structure will change.<br/><br/>Please note that if you
	// have long descriptions, titles or urls you will need <a
	// href="http://appscreo.com/self-hosted-short-urls/"
	// target="_blank"><b>Self-Hosted Short URLs add-on</b></a> for proper
	// sharing.', 'essb'), '', __('Yes', 'essb'), __('No', 'essb'));
	// $essbab_options_structure->field_switch('settings', $menu_id.'-12',
	// 'sis_pinterest_alt', __('Use provided image alternative text for
	// Pinterest share<div class="essb-new"><span></span></div><div
	// class="essb-beta"><span></span></div>', 'essb'), __('Activate this option
	// to allow Pinterest share take image alternative text as share
	// description. If no alternative texts is provided it will use post title.
	// If this option is not active Pinterest share will use post title.',
	// 'essb'), '', __('Yes', 'essb'), __('No', 'essb'));
	// $essbab_options_structure->field_section_end('settings', $menu_id.'-12');
	$essbab_options_structure->panel_end ( 'settings', $menu_id . '-12' );
	$essbab_options_structure->panel_start ( 'settings', $menu_id . '-12', __ ( 'Visual display setup', 'essb' ), __ ( 'Customize look and feel of your social share buttons that appear on images', 'essb' ), 'fa21 ti-layout-grid2-alt', array ("mode" => "toggle" ) );
	
	$essbab_options_structure->field_section_start_full_panels ( 'settings', $menu_id . '-12', __ ( 'Display Options', 'essb' ), __ ( '', 'essb' ) );
	// $essbab_options_structure->field_switch('settings', $menu_id.'-12',
	// 'sis_always_show', __('Always visible', 'essb'), __('Activate this option
	// to make image share buttons be always visible on images.', 'essb'), '',
	// __('Yes', 'essb'), __('No', 'essb'));
	
	$list_of_positions = array ('top-left' => __ ( 'Top left', 'essb' ), 'top-middle' => __ ( 'Top middle', 'essb' ), 'top-right' => __ ( 'Top right', 'essb' ), 'middle-left' => __ ( 'Middle left', 'essb' ), 'middle-middle' => __ ( 'Middle', 'essb' ), 'middle-right' => __ ( 'Middle right', 'essb' ), 'bottom-left' => __ ( 'Bottom left', 'essb' ), 'bottom-middle' => __ ( 'Bottom middle', 'essb' ), 'bottom-right' => __ ( 'Bottom right', 'essb' ) );
	
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-12', $configuration_id . 'sis_position', __ ( 'Choose position of buttons on image', 'essb' ), __ ( 'Select default position of buttons over image. Depends on active buttons and template select the best to fit them into images', 'essb' ), $list_of_positions );
	
	$listOfTemplates = array ("tiny" => "Tiny", "flat-small" => "Small", "flat" => "Regular", "round" => "Round" );
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-12', $configuration_id . 'sis_style', __ ( 'Template', 'essb' ), __ ( 'Choose buttons template. You can use only build into module templates to avoid misconfiguration', 'essb' ), $listOfTemplates );
	// $listOfOptions = array("left" => "Left", "right" => "Right", "center-x"
	// => "Center");
	// $essbab_options_structure->field_select('settings', $menu_id.'-12',
	// 'sis_align_x', __('Horizontal Align', 'essb'), '', $listOfOptions);
	// $listOfOptions = array("top" => "Top", "bottom" => "Bottom", "center-y"
	// => "Center");
	// $essbab_options_structure->field_select('settings', 'positions-30',
	// 'sis_align_y', __('Vertical Align', 'essb'), '', $listOfOptions);
	$listOfOptions = array ("horizontal" => __ ( "Horizontal", 'essb' ), "vertical" => __ ( "Vertical", 'essb' ) );
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-12', $configuration_id . 'sis_orientation', __ ( 'Orientation', 'essb' ), __ ( 'Display buttons aligned horizontal or vertical', 'essb' ), $listOfOptions );
	// $essbab_options_structure->field_textbox('settings', $menu_id.'-12',
	// 'sis_offset_x', __('Move buttons horizontally', 'essb'), __('Provide
	// custom value if you wish to move buttons horizontally from the edge of
	// image', 'essb'));
	// $essbab_options_structure->field_textbox('settings', $menu_id.'-12',
	// 'sis_offset_y', __('Move buttons vertically', 'essb'), __('Provide custom
	// value if you wish to move buttons vertically from the edge of image.',
	// 'essb'));
	$essbab_options_structure->field_section_end_full_panels ( 'settings', $menu_id . '-12' );
	$essbab_options_structure->panel_end ( 'settings', $menu_id . '-12' );
	
	$essbab_options_structure->field_textbox ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_user_width', __ ( 'Custom window width', 'essb' ), __ ( 'Set your custom window width (default is 960 or window width - 60). Value if provided should be numeric without px symbols.', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
	$essbab_options_structure->field_section_start ( 'settings', $menu_id . '-13', __ ( 'Primary content area', 'essb' ), __ ( 'Primary content area is located above post information and share details. You can use it to add custom title or message that will appear on top. Leave it blank if you do not wish to have such', 'essb' ) );
	$essbab_options_structure->field_textbox_stretched ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_window_title', __ ( 'Window title', 'essb' ), __ ( 'Set your custom pop up window title.', 'essb' ) );
	$essbab_options_structure->field_editor ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_user_message', __ ( 'Window message', 'essb' ), __ ( 'Set your custom message that will appear above buttons', 'essb' ), "htmlmixed" );
	$essbab_options_structure->field_section_end ( 'settings', $menu_id . '-13' );
	
	$essbab_options_structure->field_section_start ( 'settings', $menu_id . '-13', __ ( 'Additional content area', 'essb' ), __ ( 'Additional content area is located below share buttons and provide various message types. If you do not wish to display it choose data type to html message and leave field for message blank', 'essb' ) );
	$essbab_options_structure->field_textbox_stretched ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_second_title', __ ( 'Title', 'essb' ), __ ( 'Set your custom pop up window title for additional content area.', 'essb' ) );
	$listOfOptions = array ("top" => "Top social posts (require build in analytics to be active)", "fans" => "Followers counter (require followers counter to be activated)", "html" => "Custom HTML message" );
	$essbab_options_structure->field_select ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_second_type', __ ( 'Type of displayed data', 'essb' ), __ ( 'Choose what you wish to be displayed into second widget area below share buttons. If you wish to leave it blank choose Custom HTML message and do not fill anything inside field for custom message.', 'essb' ), $listOfOptions );
	$essbab_options_structure->field_textbox_stretched ( 'settings', $menu_id . '-13', 'heroshare_second_fans', __ ( 'Followers counter shortcode', 'essb' ), __ ( 'Fill in this field you followers counter shortcode that will be used if you select in second widget area to have followers counter. Shortcode can be generated using shortcode generator.', 'essb' ) );
	$essbab_options_structure->field_editor ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_second_message', __ ( 'Custom HTML message', 'essb' ), __ ( 'Set your custom message (for example html code for opt-in form). This field supports shortcodes.', 'essb' ), "htmlmixed" );
	$essbab_options_structure->field_section_end ( 'settings', $menu_id . '-13' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-13', __ ( 'Hero share window display', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_window_popafter', __ ( 'Display pop up window after (sec)', 'essb' ), __ ( 'If you wish pop up window to appear after amount of seconds you can provide theme here. Leave blank for immediate pop up after page load.', 'essb' ), '', 'input60', 'fa-clock-o', 'right' );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_user_percent', __ ( 'Display pop up window after percent of content is viewed', 'essb' ), __ ( 'Set amount of page content after which the pop up will appear.', 'essb' ), '', 'input60', 'fa-arrows-v', 'right' );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_display_end', __ ( 'Display pop up at the end of content', 'essb' ), __ ( 'Automatically display pop up when the content end is reached', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_display_exit', __ ( 'Display pop up on exit intent', 'essb' ), __ ( 'Automatically display pop up when exit intent is detected', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_user_manual_show', __ ( 'Manual window display mode', 'essb' ), __ ( 'Activating manual display mode will allow you to show window when you decide with calling following javascript function essb_heroshare_show();', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_avoid_logged_users', __ ( 'Do not show pop up for logged in users', 'essb' ), __ ( 'Activate this option to avoid display of pop up when user is logged in into site.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-13' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-13', __ ( 'Window close', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_user_notshow_onclose', __ ( 'After user close window do not show it again on this page/post for him', 'essb' ), __ ( 'Activating this option will set cookie that will not show again pop up message for next 7 days for user on this post/page', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-13', $configuration_id . 'heroshare_user_notshow_onclose_all', __ ( 'After user close window do not show it again on all page/post for him', 'essb' ), __ ( 'Activating this option will set cookie that will not show again pop up message for next 7 days for user on all posts/pages', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-13' );
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-13', 'heroshare' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-14', __ ( 'Deactivate default components', 'essb' ), __ ( 'Deactivate default active display elements', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_deactivate_prevnext', __ ( 'Deactivate previous/next articles', 'essb' ), __ ( 'Activate this option if you wish to deactivate display of previous/next article buttons', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_deactivate_progress', __ ( 'Deactivate read progress bar', 'essb' ), __ ( 'Activate this option if you wish to deactivate display of read progress', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_deactivate_title', __ ( 'Deactivate post title', 'essb' ), __ ( 'Activate this option if you wish to deactivate display of post title', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-14' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-14', __ ( 'Activate additional components', 'essb' ), __ ( 'Activate additional display elements', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_activate_category', __ ( 'Activate display of category', 'essb' ), __ ( 'Activate this option if you wish to activate display of category', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_activate_author', __ ( 'Activate display of post author', 'essb' ), __ ( 'Activate this option if you wish to activate display of post author', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_activate_total', __ ( 'Activate display of total shares counter', 'essb' ), __ ( 'Activate this option if you wish to activate display of total shares counter', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_activate_comments', __ ( 'Activate display of comments counter', 'essb' ), __ ( 'Activate this option if you wish to activate display of comments counter', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_activate_time', __ ( 'Activate display of time to read', 'essb' ), __ ( 'Activate this option if you wish to activate display of time to read', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_textbox_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_activate_time_words', __ ( 'Words per minuted for time to read', 'essb' ), __ ( 'Customize the words per minute for time to read display', 'essb' ), '', 'input60', 'fa-clock-o', 'right' );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-14' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-14', __ ( 'Customize colors', 'essb' ), __ ( 'Customize default colors of core components', 'essb' ) );
	$essbab_options_structure->field_color_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_bgcolor', __ ( 'Change default background color', 'essb' ), __ ( 'Customize the default post bar background color (#FFFFFF)', 'essb' ) );
	$essbab_options_structure->field_color_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_color', __ ( 'Change default text color', 'essb' ), __ ( 'Customize the default post bar text color (#111111)', 'essb' ) );
	$essbab_options_structure->field_color_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_accentcolor', __ ( 'Change default accent color', 'essb' ), __ ( 'Customize the default post bar accent color (#3D8EB9)', 'essb' ) );
	$essbab_options_structure->field_color_panel ( 'settings', $menu_id . '-14', $configuration_id . 'postbar_altcolor', __ ( 'Change default alt text color', 'essb' ), __ ( 'Customize the default post bar alt text color (#FFFFFF) which is applied to elements with accent background color', 'essb' ) );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-14' );
	
	$essbab_options_structure->field_section_start ( 'settings', $menu_id . '-14', __ ( 'Customize button style', 'essb' ), __ ( '', 'essb' ) );
	$tab_id = 'settings';
	$menu_id = $menu_id . '-14';
	$location = $configuration_id . 'postbar';
	$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_button_style', __ ( 'Buttons Style', 'essb' ), __ ( 'Select your button display style.', 'essb' ), essb_avaiable_button_style_with_recommend () );
	$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_template', __ ( 'Template', 'essb' ), __ ( 'Select your template for that display location.', 'essb' ), essb_available_tempaltes () );
	$essbab_options_structure->field_switch ( $tab_id, $menu_id, $location . '_nospace', __ ( 'Remove spacing between buttons', 'essb' ), __ ( 'Activate this option to remove default space between share buttons.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch ( $tab_id, $menu_id, $location . '_show_counter', __ ( 'Display counter of sharing', 'essb' ), __ ( 'Activate display of share counters.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_counter_pos', __ ( 'Position of counters', 'essb' ), __ ( 'Choose your default button counter position', 'essb' ), essb_avaliable_counter_positions () );
	
	$essbab_options_structure->field_section_end ( 'settings', $menu_id . '-14' );
	
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-14', $configuration_id . 'postbar' );
	
	// Point
	$essbab_options_structure->field_heading ( 'settings', $menu_id . '-15', 'heading1', __ ( 'Display Position Settings: Point', 'essb' ) );
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-15', __ ( 'Point display', 'essb' ), __ ( 'Choose location of point and style', 'essb' ) );
	$point_positions = array ("bottomright" => __ ( 'Bottom Right', 'essb' ), 'bottomleft' => __ ( 'Bottom Left', 'essb' ), 'topright' => __ ( 'Top Right', 'essb' ), 'topleft' => __ ( 'Top Left', 'essb' ) );
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-15', $configuration_id . 'point_position', __ ( 'Point will appear on', 'essb' ), __ ( 'Choose where you wish sharing point to appear', 'essb' ), $point_positions );
	$essbab_options_structure->field_switch_panel ( 'settings', $menu_id . '-15', $configuration_id . 'point_total', __ ( 'Display total counter', 'essb' ), __ ( 'Activate this option if you wish to activate display of total counter on point', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	// $essbab_options_structure->field_switch_panel('settings', $menu_id.'-15',
	// 'point_open_end', __('Automatic share point open at the end of content',
	// 'essb'), __('Activate this option if you wish to automatic share point
	// open at the end of post content', 'essb'), '', __('Yes', 'essb'),
	// __('No', 'essb'));
	$point_open_triggers = array ("no" => __ ( "No", "essb" ), "end" => __ ( "At the end of content", "essb" ), "middle" => __ ( "After the middle of content", "essb" ) );
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-15', $configuration_id . 'point_open_auto', __ ( 'Automatic share point open', 'essb' ), __ ( 'Select your button display style.', 'essb' ), $point_open_triggers );
	
	$point_display_style = array ("simple" => __ ( 'Simple icons', 'essb' ), 'advanced' => __ ( 'Advanced Panel', 'essb' ) );
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-15', $configuration_id . 'point_style', __ ( 'Share buttons action type', 'essb' ), __ ( 'Choose your share buttons action type. Simple buttons will just open share buttons when you click the point. Advanced panel allows you also to include custom texts before/after buttons into nice flyout panel', 'essb' ), $point_display_style );
	$point_display_style = array ("round" => __ ( 'Round', 'essb' ), 'square' => __ ( 'Square', 'essb' ), 'rounded' => __ ( 'Rounded edges square', 'essb' ) );
	$essbab_options_structure->field_select_panel ( 'settings', $menu_id . '-15', $configuration_id . 'point_shape', __ ( 'Point button shape', 'essb' ), __ ( 'Choose the shape of share point - default is round', 'essb' ), $point_display_style );
	
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-15' );
	
	$essbab_options_structure->field_section_start_panels ( 'settings', $menu_id . '-15', __ ( 'Customize colors', 'essb' ), __ ( 'Customize default colors of core components', 'essb' ) );
	$essbab_options_structure->field_color_panel ( 'settings', $menu_id . '-15', $configuration_id . 'point_bgcolor', __ ( 'Change default background color', 'essb' ), __ ( 'Customize the default point background color', 'essb' ) );
	$essbab_options_structure->field_color_panel ( 'settings', $menu_id . '-15', $configuration_id . 'point_color', __ ( 'Change default text color', 'essb' ), __ ( 'Customize the default point text color', 'essb' ) );
	$essbab_options_structure->field_color_panel ( 'settings', $menu_id . '-15', $configuration_id . 'point_accentcolor', __ ( 'Change default total background color', 'essb' ), __ ( 'Customize the default total background color', 'essb' ) );
	$essbab_options_structure->field_color_panel ( 'settings', $menu_id . '-15', $configuration_id . 'point_altcolor', __ ( 'Change default total text color', 'essb' ), __ ( 'Customize the default total text color', 'essb' ) );
	$essbab_options_structure->field_section_end_panels ( 'settings', $menu_id . '-15' );
	
	$essbab_options_structure->field_section_start ( 'settings', $menu_id . '-15', __ ( 'Customize button style', 'essb' ), __ ( '', 'essb' ) );
	$tab_id = 'settings';
	$menu_id = $menu_id . '-15';
	$location = $configuration_id . 'point';
	$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_button_style', __ ( 'Buttons Style', 'essb' ), __ ( 'Select your button display style.', 'essb' ), essb_avaiable_button_style_with_recommend () );
	$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_template', __ ( 'Template', 'essb' ), __ ( 'Select your template for that display location.', 'essb' ), essb_available_tempaltes4 () );
	$essbab_options_structure->field_switch ( $tab_id, $menu_id, $location . '_nospace', __ ( 'Remove spacing between buttons', 'essb' ), __ ( 'Activate this option to remove default space between share buttons.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_switch ( $tab_id, $menu_id, $location . '_show_counter', __ ( 'Display counter of sharing', 'essb' ), __ ( 'Activate display of share counters.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_counter_pos', __ ( 'Position of counters', 'essb' ), __ ( 'Choose your default button counter position. Please note that if you use Simple icons mode all Inside positions will act like Inside - network names will not appear because of visual limitations', 'essb' ), essb_avaliable_counter_positions_point () );
	$essbab_options_structure->field_section_end ( 'settings', $menu_id . '-15' );
	
	$essbab_options_structure->field_section_start ( 'settings', $menu_id . '-15', __ ( 'Custom button content for Advanced panel display', 'essb' ), __ ( '', 'essb' ) );
	$essbab_options_structure->field_wpeditor ( 'settings', $menu_id . '-15', 'point_top_content', __ ( 'Custom content above share buttons', 'essb' ), __ ( 'Optional: Provide custom content that will appear above share buttons. You can use the variables to display post related content: %%title%%, %%url%%, %%image%%, %%permalink%%', 'essb' ), 'htmlmixed' );
	$essbab_options_structure->field_wpeditor ( 'settings', $menu_id . '-15', 'point_bottom_content', __ ( 'Custom content below share buttons', 'essb' ), __ ( 'Optional: Provide custom content that will appear below share buttons. You can use the variables to display post related content: %%title%%, %%url%%, %%image%%, %%permalink%%', 'essb' ), 'htmlmixed' );
	$essbab_options_structure->field_switch ( 'settings', $menu_id . '-15', 'point_articles', __ ( 'Display prev/next article', 'essb' ), __ ( 'Activate this option to display prev/next article from same category', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	$essbab_options_structure->field_section_end ( 'settings', $menu_id . '-15' );
	
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-15', $configuration_id . 'point' );
	
	essb_prepare_location_advanced_customization_ab ( 'settings', $menu_id . '-16', $configuration_id . 'excerpt' );

}

function essb_prepare_location_advanced_customization_ab($tab_id, $menu_id, $location = '', $post_type = false) {
	global $essb_networks, $essbab_options_structure;
	
	$checkbox_list_networks = array ();
	foreach ( $essb_networks as $key => $object ) {
		// $checkbox_list_networks[$key] = '<i class="essb_icon_'.$key.'"></i> '
		// . $object['name'];
		$checkbox_list_networks [$key] = $object ['name'];
	}
	
	if ($location != 'mobile') {
		$essbab_options_structure->field_heading ( $tab_id, $menu_id, 'heading5', __ ( 'Deactivate display of functions', 'essb' ) );
		$essbab_options_structure->field_section_start_full_panels ( $tab_id, $menu_id );
		
		$essbab_options_structure->field_switch_panel ( $tab_id, $menu_id, $location . '_mobile_deactivate', __ ( 'Deactivate on mobile', 'essb' ), __ ( 'Activate this option if you wish that method to be hidden when site is browsed with mobile device.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
		$essbab_options_structure->field_switch_panel ( $tab_id, $menu_id, $location . '_tablet_deactivate', __ ( 'Deactivate on tablet', 'essb' ), __ ( 'Activate this option if you wish that method to be hidden when site is browsed with tablet device.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
		
		if ($location != 'postbar' && $location != 'point') {
			$essbab_options_structure->field_switch_panel ( $tab_id, $menu_id, $location . '_native_deactivate', __ ( 'Deactivate native buttons', 'essb' ), __ ( 'Activate this option if you wish to deactivate native buttons for that display method.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
			
			if (! $post_type) {
				$essbab_options_structure->field_switch_panel ( $tab_id, $menu_id, $location . '_text_deactivate', __ ( 'Hide message above, before or below', 'essb' ), __ ( 'Activate this option if you wish to hide message above, before or below for that display.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
			}
		}
		$essbab_options_structure->field_section_end_full_panels ( $tab_id, $menu_id );
	}
	
	if ($location == 'mobile') {
		$essbab_options_structure->title ( $tab_id, $menu_id, __ ( 'Customize active social networks', 'essb' ), __ ( 'Apply selection only if you wish to modify the default network list that is used over site.', 'essb' ), 'inner-row' );
		$essbab_options_structure->field_checkbox_list_sortable ( $tab_id, $menu_id, $location . '_networks', '', '', $checkbox_list_networks );
	}
	
	$panel_title = "";
	if (! $post_type) {
		$panel_title = __ ( 'Personalize buttons on that display position', 'essb' );
	} else {
		$panel_title = __ ( 'Personalize buttons for that post type', 'essb' );
	}
	
	if ($location == 'mobile') {
		$panel_title = __ ( 'Personalize buttons that are displayed on mobile device', 'essb' );
	}
	
	$essbab_options_structure->panel_start ( $tab_id, $menu_id, $panel_title, __ ( 'Activating this option will allow you to make full personalization of displayed buttons.', 'essb' ), 'fa21 fa fa-cogs', array ("mode" => "toggle", 'switch_id' => $location . '_activate', 'switch_on' => __ ( 'Yes', 'essb' ), 'switch_off' => __ ( 'No', 'essb' ) ) );
	$essbab_options_structure->field_switch_panel ( $tab_id, $menu_id, $location . '_activate', __ ( 'Apply customizations on that location', 'essb' ), __ ( 'Activate this option to make options bellow work.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
	
	// if (essb_option_bool_value($location.'_activate')) {
	
	if ($location != 'postbar' && $location != 'point') {
		$essbab_options_structure->field_heading ( $tab_id, $menu_id, 'heading5', __ ( 'Visual customizations', 'essb' ) );
		$essbab_options_structure->tabs_start ( $tab_id, $menu_id, $location . '-visual', array ('<i class="fa fa-square"></i> Button Style', '<i class="fa fa-plus"></i> More button', '<i class="fa fa-share-alt"></i> Share button', '<i class="fa fa-history"></i> Counters', '<i class="fa fa-arrows-h"></i> Width' ) );
		
		$essbab_options_structure->tab_start ( $tab_id, $menu_id, $location . '-visual-0', 'true' );
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_button_style', __ ( 'Buttons Style', 'essb' ), __ ( 'Select your button display style.', 'essb' ), essb_avaiable_button_style () );
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_button_pos', __ ( 'Buttons Align', 'essb' ), __ ( 'Choose how buttons
					to be aligned. Default position is left but you can also select
					Right or Center', 'essb' ), array ("" => "Left", "center" => "Center", "right" => "Right" ) );
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_template', __ ( 'Template', 'essb' ), __ ( 'Select your template for that display location.', 'essb' ), essb_available_tempaltes4 () );
		$essbab_options_structure->field_switch ( $tab_id, $menu_id, $location . '_nospace', __ ( 'Remove spacing between buttons', 'essb' ), __ ( 'Activate this option to remove default space between share buttons.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
		$animations_container = array ();
		$animations_container [""] = "Default value from settings";
		foreach ( essb_available_animations () as $key => $text ) {
			if ($key != '') {
				$animations_container [$key] = $text;
			} else {
				$animations_container ['no'] = 'No amination';
			}
		}
		
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_css_animations', __ ( 'Activate animations', 'essb' ), __ ( 'Animations
					are provided with CSS transitions and work on best with retina
					templates.', 'essb' ), $animations_container );
		
		$essbab_options_structure->tab_end ( $tab_id, $menu_id );
		
		$essbab_options_structure->tab_start ( $tab_id, $menu_id, $location . '-visual-1' );
		
		$more_options = array ("plus" => "Plus icon", "dots" => "Dots icon" );
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_more_button_icon', __ ( 'More button icon', 'essb' ), __ ( 'Select more button icon style. You can choose from default + symbol or dots symbol', 'essb' ), $more_options );
		
		$more_options = array ("" => "Default function", "1" => "Display all active networks after more button", "2" => "Display all social networks as pop up", "3" => "Display only active social networks as pop up" );
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_more_button_func', __ ( 'More button function', 'essb' ), __ ( 'Select networks that you wish to appear in your list. With drag and drop you can rearrange them.', 'essb' ), $more_options );
		$essbab_options_structure->tab_end ( $tab_id, $menu_id );
		$essbab_options_structure->tab_start ( $tab_id, $menu_id, $location . '-visual-2' );
		$more_options = array ("1" => "Display all active networks after share button", "2" => "Display all social networks as pop up", "3" => "Display only active social networks as pop up" );
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_share_button_func', __ ( 'Share button function', 'essb' ), __ ( 'Select networks that you wish to appear in your list. With drag and drop you can rearrange them.', 'essb' ), $more_options );
		
		$essb_available_buttons_width = array ();
		$essb_available_buttons_width ['plus'] = array ("image" => '<div class="fa21 essb_icon_plus"></div>', "label" => "" );
		$essb_available_buttons_width ['dots'] = array ("image" => '<div class="fa21 essb_icon_dots"></div>', "label" => "" );
		$essb_available_buttons_width ['share'] = array ("image" => '<div class="fa21 essb_icon_share"></div>', "label" => "" );
		$essb_available_buttons_width ['share-alt-square'] = array ("image" => '<div class="fa21 essb_icon_share-alt-square"></div>', "label" => "" );
		$essb_available_buttons_width ['share-alt'] = array ("image" => '<div class="fa21 essb_icon_share-alt"></div>', "label" => "" );
		$essb_available_buttons_width ['share-tiny'] = array ("image" => '<div class="fa21 essb_icon_share-tiny"></div>', "label" => "" );
		$essb_available_buttons_width ['share-outline'] = array ("image" => '<div class="fa21 essb_icon_share-outline"></div>', "label" => "" );
		$essbab_options_structure->field_html_radio_buttons ( $tab_id, $menu_id, $location . '_share_button_icon', __ ( 'Share button icon', 'essb' ), __ ( 'Choose the share button icon you will use (default is share if nothing is selected)', 'essb' ), $essb_available_buttons_width, '', '', '26px' );
		
		$more_options = array ("" => "Default from settings (like other share buttons)", "icon" => "Icon only", "button" => "Button", "text" => "Text only" );
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_share_button_style', __ ( 'Share button style', 'essb' ), __ ( 'Select more button icon style. You can choose from default + symbol or dots symbol', 'essb' ), $more_options );
		
		$share_counter_pos = array ("hidden" => "No counter", "inside" => "Inside button without text", "insidename" => "Inside button after text", "insidebeforename" => "Inside button before text", "topn" => "Top", "bottom" => "Bottom" );
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_share_button_counter', __ ( 'Display total counter with the following position', 'essb' ), __ ( 'Choose where you wish to display total counter of shares assigned with this button. <br/> To view total counter you need to have share counters active and they should not be running in real time mode. Also you need to have your share button set with style button. When you use share button with counter we highly recommend to hide total counter by setting position to be hidden - this will avoid having two set of total value on screen.', 'essb' ), $share_counter_pos );
		$essbab_options_structure->tab_end ( $tab_id, $menu_id );
		
		$essbab_options_structure->tab_start ( $tab_id, $menu_id, $location . '-visual-3' );
		$essbab_options_structure->field_switch ( $tab_id, $menu_id, $location . '_show_counter', __ ( 'Display counter of sharing', 'essb' ), __ ( 'Activate display of share counters.', 'essb' ), '', __ ( 'Yes', 'essb' ), __ ( 'No', 'essb' ) );
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_counter_pos', __ ( 'Position of counters', 'essb' ), __ ( 'Choose your default button counter position', 'essb' ), essb_avaliable_counter_positions () );
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_total_counter_pos', __ ( 'Position of total counter', 'essb' ), __ ( 'For vertical display methods left means before buttons (top) and right means after buttons (bottom).', 'essb' ), essb_avaiable_total_counter_position () );
		$essbab_options_structure->tab_end ( $tab_id, $menu_id );
		
		$essbab_options_structure->tab_start ( $tab_id, $menu_id, $location . '-visual-4' );
		$essbab_options_structure->field_section_start ( $tab_id, $menu_id, __ ( 'Set button width', 'essb' ), __ ( '', 'essb' ) );
		$essbab_options_structure->field_select ( $tab_id, $menu_id, $location . '_button_width', __ ( 'Width of buttons' ), __ ( 'Choose between automatic width, pre defined width or display in columns.' ), array ('' => 'Automatic Width', 'fixed' => 'Fixed Width', 'full' => 'Full Width', "column" => "Display in columns", "flex" => "Flex width" ) );
		$essbab_options_structure->field_section_end ( $tab_id, $menu_id );
		
		$essbab_options_structure->field_section_start_panels ( $tab_id, $menu_id, __ ( 'Fixed width share buttons', 'essb' ), __ ( 'Customize the fixed width options', 'essb' ) );
		$essbab_options_structure->field_textbox_panel ( $tab_id, $menu_id, $location . '_fixed_width_value', __ ( 'Custom buttons width', 'essb' ), __ ( '', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
		$essbab_options_structure->field_select_panel ( $tab_id, $menu_id, $location . '_fixed_width_align', __ ( 'Choose alignment of network name', 'essb' ), __ ( '', 'essb' ), array ("" => "Center", "left" => "Left", "right" => "Right" ) );
		$essbab_options_structure->field_section_end_panels ( $tab_id, $menu_id );
		
		$essbab_options_structure->field_section_start_panels ( $tab_id, $menu_id, __ ( 'Full width share buttons', 'essb' ), __ ( 'Full width option will make buttons to take the width of your post content area.', 'essb' ) );
		$essbab_options_structure->field_textbox_panel ( $tab_id, $menu_id, $location . '_fullwidth_share_buttons_correction', __ ( 'Max width of button on desktop', 'essb' ), __ ( '', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
		$essbab_options_structure->field_textbox_panel ( $tab_id, $menu_id, $location . '_fullwidth_share_buttons_correction_mobile', __ ( 'Max width of button on mobile', 'essb' ), __ ( '', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
		$essbab_options_structure->field_textbox_panel ( $tab_id, $menu_id, $location . '_fullwidth_share_buttons_container', __ ( 'Max width of buttons container element', 'essb' ), __ ( '', 'essb' ), '', 'input60', 'fa-arrows-h', 'right' );
		$essbab_options_structure->field_select_panel ( $tab_id, $menu_id, $location . '_fullwidth_align', __ ( 'Choose alignment of network name', 'essb' ), __ ( '', 'essb' ), array ("left" => "Left", "center" => "Center", "right" => "Right" ) );
		
		$essbab_options_structure->field_section_end_panels ( $tab_id, $menu_id );
		
		$essbab_options_structure->field_section_start_panels ( $tab_id, $menu_id, __ ( 'Display in columns', 'essb' ), '' );
		$listOfOptions = array ("1" => "1", "2" => "2", "3" => "3", "4" => "4", "5" => "5" );
		$essbab_options_structure->field_select_panel ( $tab_id, $menu_id, $location . '_fullwidth_share_buttons_columns', __ ( 'Number of columns', 'essb' ), __ ( '', 'essb' ), $listOfOptions );
		$essbab_options_structure->field_select_panel ( $tab_id, $menu_id, $location . '_fullwidth_share_buttons_columns_align', __ ( 'Choose alignment of network name', 'essb' ), __ ( '', 'essb' ), array ("" => "Left", "center" => "Center", "right" => "Right" ) );
		$essbab_options_structure->field_section_end_panels ( $tab_id, $menu_id );
		
		$essbab_options_structure->tab_end ( $tab_id, $menu_id );
		$essbab_options_structure->tabs_end ( $tab_id, $menu_id );
	
	}
	// $essbab_options_structure->field_section_start($tab_id, $menu_id,
	// __('Personalize social networks', 'essb'), '');
	$essbab_options_structure->field_heading ( $tab_id, $menu_id, 'heading5', __ ( 'Personalize social networks', 'essb' ) );
	
	if ($location != 'mobile') {
		$essbab_options_structure->title ( $tab_id, $menu_id, __ ( 'Customize active social networks', 'essb' ), __ ( 'Apply selection only if you wish to modify the default network list that is used over site.', 'essb' ), 'inner-row' );
		$essbab_options_structure->field_checkbox_list_sortable ( $tab_id, $menu_id, $location . '_networks', '', '', $checkbox_list_networks );
		
		// $essbab_options_structure->structure_row_start($tab_id, $menu_id);
		// $essbab_options_structure->structure_section_start($tab_id, $menu_id,
	// 'c12', __('Customize active social networks', 'essb'), __('Apply
	// selection only if you wish to modify the default network list that is
	// used over site.', 'essb'));
		// $essbab_options_structure->field_checkbox_list_sortable($tab_id,
	// $menu_id, $location.'_networks', '', '', $checkbox_list_networks);
		// $essbab_options_structure->structure_section_end($tab_id, $menu_id);
		// $essbab_options_structure->structure_row_end($tab_id, $menu_id);
	
	}
	
	// $essbab_options_structure->title($tab_id, $menu_id, __('Customize text of
	// social network over button', 'essb'), __('Set texts that will appear on
	// selected display method instead of default network names. Use dash (-) if
	// you wish to remove text for that network name.', 'essb'));
	$essbab_options_structure->panel_start ( $tab_id, $menu_id, __ ( 'Customize text of social network over button', 'essb' ), __ ( 'Set texts that will appear on selected display method instead of default network names. Use dash (-) if you wish to remove text for that network name.', 'essb' ), 'fa21 fa fa-cogs', array ("mode" => "switch", 'switch_id' => $location . '_name_change', 'switch_on' => __ ( 'Yes', 'essb' ), 'switch_off' => __ ( 'No', 'essb' ) ) );
	
	$essbab_options_structure->structure_row_start ( $tab_id, $menu_id, 'inner-row social-name-change' );
	$count = 0;
	foreach ( $checkbox_list_networks as $key => $text ) {
		if ($count == 4) {
			$essbab_options_structure->structure_row_end ( $tab_id, $menu_id );
			$essbab_options_structure->structure_row_start ( $tab_id, $menu_id, 'inner-row social-name-change' );
			$count = 0;
		}
		$count ++;
		$essbab_options_structure->structure_section_start ( $tab_id, $menu_id, 'c3' );
		$essbab_options_structure->field_textbox_panel ( $tab_id, $menu_id, $location . '_' . $key . '_name', $text, '', '', '', '', '', '6' );
		$essbab_options_structure->structure_section_end ( $tab_id, $menu_id );
	}
	
	$essbab_options_structure->structure_row_end ( $tab_id, $menu_id );
	$essbab_options_structure->panel_end ( $tab_id, $menu_id ); // network names
	                                                         // }
	$essbab_options_structure->panel_end ( $tab_id, $menu_id ); // customization
		                                                         
	// $essbab_options_structure->field_section_end($tab_id, $menu_id);

}

function essb4_ab_report() {
	$ab_stats = get_option ( ESSB3_AB_STAT_NAME );
	
	// print_r($ab_stats);
	
	ESSBOptionsFramework::draw_heading ( __ ( 'Conversion', 'essb-a' ), '5', '' );
	// active options
	$number_of_options = essb_ab_option_value ( 'ab_count' );
	
	$case_data = array ();
	
	$networks_data = array ();
	$position_data = array ();
	
	$networks_all = 0;
	$position_all = 0;
	
	if (isset ( $ab_stats ['display'] )) {
		for($i = 1; $i <= intval ( $number_of_options ); $i ++) {
			$case_value = isset ( $ab_stats ['display'] [$i] ) ? $ab_stats ['display'] [$i] : 0;
			
			if (! isset ( $case_data [$i] )) {
				$case_data [$i] = array ('display' => 0, 'clicks' => 0, 'coversion' => 0 );
			}
			
			$case_data [$i] ['display'] = $case_value;
		}
	}
	
	$best_conversion = 0;
	$best_location = 0;
	
	if (isset ( $ab_stats ['clicks'] )) {
		for($i = 1; $i <= intval ( $number_of_options ); $i ++) {
			
			if (isset ( $ab_stats ['clicks'] [$i] )) {
				$case_value = isset ( $ab_stats ['clicks'] [$i] ['total'] ) ? $ab_stats ['clicks'] [$i] ['total'] : 0;
				
				if (! isset ( $case_data [$i] )) {
					$case_data [$i] = array ('display' => 0, 'clicks' => 0, 'coversion' => 0 );
				}
				
				$case_data [$i] ['clicks'] = $case_value;
				$case_data [$i] ['positions'] = $ab_stats ['clicks'] [$i] ['positions'];
				$case_data [$i] ['networks'] = $ab_stats ['clicks'] [$i] ['networks'];
				$case_data [$i] ['coversion'] = intval ( $case_data [$i] ['clicks'] ) * 100 / $case_data [$i] ['display'];
				
				if ($best_conversion < $case_data [$i] ['coversion']) {
					$best_conversion = $case_data [$i] ['coversion'];
					$best_location = $i;
				}
				
				arsort ( $case_data [$i] ['positions'] );
				arsort ( $case_data [$i] ['networks'] );
			
			}
		}
	}
	
	// print_r($case_data);
	
	print '<div style="display: flex;">';
	for($i = 1; $i <= intval ( $number_of_options ); $i ++) {
		print '<div style="width: 30%; display: inline-block; padding: 15px; ' . ($best_location == $i ? 'background-color:#f5f7f9;' : '') . '">';
		print '<div style="font-size: 16px; font-weight: bold;">Configuratoin #' . $i . ' ' . ($best_location == $i ? '<span style="font-size:11px;font-weight:600;background-color:#FD5B03; padding: 2px; border-radius: 3px; color: #fff;">' . __ ( 'BEST' ) . '</span>' : '') . '</div>';
		print '<div style="margin-top: 10px; margin-bottom: 10px;">';
		print '<span style="width: 70%; text-transform: uppercase; display: inline-block; margin-right: 5px;">Displayed: <b style="font-size:21px; float: right; margin-top: -5px;">' . $case_data [$i] ['display'] . '</b></span>';
		print '<span style="width: 70%; text-transform: uppercase; display: inline-block; margin-right: 5px;">Clicks: <b style="font-size:21px; float: right; margin-top: -5px;">' . $case_data [$i] ['clicks'] . '</b></span>';
		print '</div>';
		print '<div style="margin-top: 20px; margin-bottom: 20px; background: rgba(0, 0, 0, 0.05); height: 40px;">';
		print '<span style="width: 70%; text-transform: uppercase; display: block;">Conversion: <b style="font-size:28px; float: right; margin-top: 0px;">' . number_format ( $case_data [$i] ['coversion'], 2 ) . '%</b></span>';
		print '</div>';
		
		if (isset ( $case_data [$i] ['positions'] )) {
			ESSBOptionsFramework::draw_heading ( __ ( 'Clicks By Position', 'essb-a' ), '4', '' );
			
			print '<div style="margin-top: 10px; margin-bottom: 10px;">';
			
			foreach ( $case_data [$i] ['positions'] as $network => $value ) {
				print '<span style="width: 70%; text-transform: uppercase; display: inline-block; margin-right: 5px;">' . $network . ': <b style="font-size:21px; float: right; margin-top: -5px;">' . $value . '</b></span>';
				
				if (! isset ( $position_data [$network] )) {
					$position_data [$network] = 0;
				}
				$position_data [$network] += intval ( $value );
				$position_all += intval ( $value );
			}
			
			print '</div>';
		}
		
		if (isset ( $case_data [$i] ['networks'] )) {
			ESSBOptionsFramework::draw_heading ( __ ( 'Clicks By Network', 'essb-a' ), '4', '' );
			
			print '<div style="margin-top: 10px; margin-bottom: 10px;">';
			
			foreach ( $case_data [$i] ['networks'] as $network => $value ) {
				print '<span style="width: 70%; text-transform: uppercase; display: inline-block; margin-right: 5px;">' . $network . ': <b style="font-size:21px; float: right; margin-top: -5px;">' . $value . '</b></span>';
				if (! isset ( $networks_data [$network] )) {
					$networks_data [$network] = 0;
				}
				$networks_data [$network] += intval ( $value );
				$networks_all += intval ( $value );
			
			}
			
			print '</div>';
		}
		
		print '</div>';
	}
	print '</div>';
	
	arsort ( $networks_data );
	arsort ( $position_data );
	
	ESSBOptionsFramework::draw_heading ( __ ( 'Best Performing on all configurations', 'essb-a' ), '5', '' );
	print '<div style="display: flex;">';
	
	print '<div style="width: 30%; display: inline-block; padding: 15px;background-color:#f5f7f9;">';
	print '<div style="font-size: 16px; font-weight: bold;">Social Networks</div>';
	
	print '<div style="margin-top: 10px; margin-bottom: 10px;">';
	
	$is_odd = false;
	foreach ( $networks_data as $network => $value ) {
		$percent = intval($value) * 100 / $networks_all;
		print '<span style="width: 80%; text-transform: uppercase; display: inline-block; padding: 5px; margin-right: 5px; margin-bottom: 5px;'.($is_odd ? "background-color:rgba(0,0,0,0.05);" : "").'">' . $network . ': <b style="font-size:21px; float: right; margin-top: -5px;">' . $value . ' <span style="font-size:12px;">'.number_format($percent, 2) .' %'.'</span></b></span>';
		if (!$is_odd) $is_odd = true; else $is_odd = false;
	}
	
	print '</div>';
	
	print '</div>';
	
	print '<div style="width: 30%; display: inline-block; padding: 15px;' . '">';
	print '<div style="font-size: 16px; font-weight: bold;">Positions</div>';
		
	print '<div style="margin-top: 10px; margin-bottom: 10px;">';
	
	$is_odd = false;
	foreach ( $position_data as $network => $value ) {
		$percent = intval($value) * 100 / $position_all;
		print '<span style="width: 80%; text-transform: uppercase; display: inline-block; padding: 5px; margin-right: 5px; margin-bottom: 5px;'.($is_odd ? "background-color:rgba(0,0,0,0.05);" : "").'">' . $network . ': <b style="font-size:21px; float: right; margin-top: -5px;">' . $value . ' <span style="font-size:12px;">'.number_format($percent, 2) .' %'.'</span></b></span>';
		if (!$is_odd) $is_odd = true; else $is_odd = false;
	}
	
	print '</div>';
		
	print '</div>';
	
	print '</div>';
}
?>