<?php

/*
 * Plugin Name: Easy Social Share Buttons for WordPress Display Method - Viral Point
 * Description: Activate usage of Viral Point display method
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Version: 1.0
 * Author: CreoApps
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

define ( 'ESSB_DM_VP_PLUGIN_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESSB_DM_VP_PLUGIN_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );


add_action('init', 'essb_display_method_viralpoint_styles', 99);

add_filter('essb4_button_positions', 'essb_display_viralpoint');
//add_filter('essb4_button_positions_mobile', 'essb_display_superpostfloat');
add_filter('essb4_custom_positions', 'essb_display_register_viralpoint');
add_filter('essb4_custom_method_list', 'essb_register_viralpoint');
add_filter("essb4_position_style_viralpoint", "essb_applystyle_viralpoint");

add_action('wp_footer', 'essb4_viralpoint_display', 9);

function essb_viralpoint_key() {
	return 'display-35';
}

function essb_register_viralpoint($methods) {
	$methods[essb_viralpoint_key()] = __('Viral Point', 'essb');
	
	return $methods;
}

function essb_display_method_viralpoint_styles() {
	
	if (function_exists('essb_resource_builder')) {
		essb_resource_builder()->add_static_resource(ESSB_DM_VP_PLUGIN_URL . '/assets/essb-display.css', 'essb-viralpoint', 'css');
		essb_resource_builder()->add_static_resource(ESSB_DM_VP_PLUGIN_URL . '/assets/essb-display.js', 'essb-viralpoint', 'js');
	}
	
	if (is_admin()) {
		include_once ESSB_DM_VP_PLUGIN_ROOT . 'lib/essb-display-viralpoint-settings.php';
	}
}

function essb_display_viralpoint($positions) {
	
	$positions['viralpoint'] = array ("image" => ESSB_DM_VP_PLUGIN_URL."/assets/icon.png", "label" => __("Viral Point", "essb") );
	
	return $positions;
}

function essb_display_register_viralpoint($positions) {
	$positions['viralpoint'] = __('Viral Point', 'essb');
}

function essb4_viralpoint_display() {
	$buttons = '';
	
	$general_options = essb_core()->get_general_options();
	$is_valid = false;
	if (is_array($general_options)) {
		if (in_array('viralpoint', $general_options['button_position'])) {
			$is_valid = true;
		}
		
		
		if (is_archive() || is_front_page() || is_search() || is_tag() || is_post_type_archive() || is_home()) {
			$is_valid = false;
		}

		if ($is_valid) {
			$post_types = $general_options['display_in_types'];
			
			if (essb_core()->check_applicability($post_types, 'viralpoint')) {
				
				include_once ESSB_DM_VP_PLUGIN_ROOT . 'lib/essb-display-viralpoint-draw.php';
				$buttons = essb_viralpoint_draw();
				print $buttons;
			}
		}
	}
		
}

function essb_applystyle_viralpoint($button_style) {
	$position = 'viralpoint';
	
	$button_style['template'] = '18';
	
	$button_style['nospace'] = 'false';
	$button_style['show_counter'] = false;
	$button_style['counter_pos'] = 'hidden';
	$button_style['total_counter_pos'] = 'hidden';
	
	$button_style['button_style'] = 'vertical';

		
	$position_animation = essb_option_value('viralpoint_animation');
	if (!empty($position_animation)) {
		$button_style['button_animation'] = $position_animation;
	}
	
	$button_style['button_width'] = 'fixed';
	$button_style['button_width_fixed_value'] = '100';
	$button_style['button_width_fixed_align'] = 'center';
	
	return $button_style;
}