<?php

/*
 * Plugin Name: Easy Social Share Buttons for WordPress Subscribe Connector - JetPack Subscriptions
 * Description: Activate usage of JetPack Subscriptions in Opt-in Module
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Version: 1.0
 * Author: CreoApps
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

define('ESSB_SUBSCRIBE_CONNECTOR_JETPACK', '1.0');

add_filter('essb_external_subscribe_connectors', 'essb_subscribe_register_jetpack');

function essb_subscribe_register_jetpack($connectors) {
	$connectors['jetpack'] = __('JetPack Subscriptions', 'essb');
	
	return $connectors;
}

add_filter('essb_subscribe_jetpack', 'essb_subscribe_jetpack', 10, 3);

function essb_subscribe_jetpack($email, $name, $output) {
	
	if (class_exists('Jetpack_Subscriptions')) {
		$subscribe = Jetpack_Subscriptions::subscribe($email, 0, false);
		$output['code'] = '1';
		$output['message'] = __('Thank your for your subscribing', 'essb');		
	}
	else {
		$output['exteranl_connection_message'] = __('JetPack Subscriptions is not activated', 'essb');
	}
	
	return $output;
}