<?php

/*
 * Plugin Name: Easy Social Share Buttons for WordPress Display Method - Mobile Share Bar with Call to Action Button
 * Description: Activate usage of Mobile Share Bar with Call to Action Button display method
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Version: 1.0
 * Author: CreoApps
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

define ( 'ESSB_DM_MSBCTA_PLUGIN_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESSB_DM_MSBCTA_PLUGIN_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );


add_action('init', 'essb_display_method_mobile_sharebarcta_styles', 99);

add_filter('essb4_button_positions_mobile', 'essb_display_mobile_sharebarcta');
add_filter('essb4_custom_positions', 'essb_display_register_mobile_sharebarcta');
add_filter('essb4_custom_method_list_mobile', 'essb_register_mobile_sharebarcta');
add_filter("essb4_position_style_mobile_sharebarcta", "essb_applystyle_mobile_sharebarcta");

add_filter('wp_footer', 'essb4_mobile_sharebarcta_display', 9);

function essb_mobile_sharebarcta_key() {
	return 'mobile-30';
}

function essb_register_mobile_sharebarcta($methods) {
	$methods[essb_mobile_sharebarcta_key()] = __('Mobile Share Bar with Call to Action Button', 'essb');
	
	return $methods;
}

function essb_display_method_mobile_sharebarcta_styles() {
	
	if (function_exists('essb_resource_builder')) {
		essb_resource_builder()->add_static_resource(ESSB_DM_MSBCTA_PLUGIN_URL . '/assets/essb-display.css', 'essb-mobile_sharebarcta', 'css');
		essb_resource_builder()->add_static_resource(ESSB_DM_MSBCTA_PLUGIN_URL . '/assets/essb-display.js', 'essb-mobile_sharebarcta', 'js');
	}
	
	if (is_admin()) {
		include_once ESSB_DM_MSBCTA_PLUGIN_ROOT . 'lib/essb-display-mobile_sharebarcta-settings.php';
	}
}

function essb_display_mobile_sharebarcta($positions) {
	
	$positions['mobile_sharebarcta'] = array ("image" => ESSB_DM_MSBCTA_PLUGIN_URL."/assets/icon.png", "label" => __("Mobile Share Bar with Call to Action Button", "essb") );
	
	return $positions;
}

function essb_display_register_mobile_sharebarcta($positions) {
	$positions['mobile_sharebarcta'] = __('Mobile Share Bar with Call to Action Button', 'essb');
}

function essb4_mobile_sharebarcta_display() {
	$buttons = '';
	
	if (!essb_core()->is_mobile_safecss()) {
		return;
	}
	
	$general_options = essb_core()->get_general_options();
	$is_valid = true;
	if (is_array($general_options)) {
		
		if (is_archive() || is_front_page() || is_search() || is_tag() || is_post_type_archive() || is_home()) {
			$is_valid = false;
		}
		
		
		if ($is_valid) {
			$post_types = $general_options['display_in_types'];
			if (essb_core()->check_applicability($post_types, 'mobile_sharebarcta')) {
				//$buttons = '<b>SuperPostBar will go here!</b>';
				include_once ESSB_DM_MSBCTA_PLUGIN_ROOT . 'lib/essb-display-mobile_sharebarcta-draw.php';
				$buttons = essb_mobile_sharebarcta_draw();
				print $buttons;
				
			}
		}
	}
	
}

function essb_applystyle_mobile_sharebarcta($button_style) {
	$position = 'mobile_sharebarcta';
	if (essb_option_value($position.'_template') != "") {
		$button_style['template'] = essb_option_value($position.'_template');
	}

	$button_style['nospace'] = 'false';
	$button_style['show_counter'] = 'false';
	$button_style['counter_pos'] = 'hidden';
	$button_style['total_counter_pos'] = 'hidden';
	$button_style['button_style'] = 'button';

	
	$button_style['button_width'] = 'column';
	$button_style['button_width_columns'] = '1';	
		
	return $button_style;
}