<?php
/*
 * Plugin Name: Easy Social Share Buttons for WordPress Addon - Optin forms in content
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Description: Include beatiful optin forms automatically into content of posts 
 * Version: 1.0 
 * Author: CreoApps 
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

if (! defined ( 'WPINC' ))
	die ();

define ( 'ESSB3_OF_VERSION', '1.0' );
define ( 'ESSB3_OF_PLUGIN_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESSB3_OF_PLUGIN_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );
define ( 'ESSB3_OF_PLUGIN_BASE_NAME', plugin_basename ( __FILE__ ) );
define ( 'ESSB3_OF_OPTIONS_NAME', 'essb3-of' );

global $essb3of_options;

class ESSBAddonOptinForms {
	private static $_instance;
	private $version = "1.0";
	
	function __construct() {
		
		global $essb3of_options;
		
		$essb3of_options = get_option ( ESSB3_OF_OPTIONS_NAME );
				
		$this->init();
		add_filter ( 'the_content', array(&$this, 'attach_option_form'), 100);
		
		
	}
	
	/**
	 * Get static instance of class
	 *
	 * @return ESSB_Manager
	 */
	public static function getInstance() {
		if (! (self::$_instance instanceof self)) {
			self::$_instance = new self ();
		}
		
		return self::$_instance;
	}
	
	/**
	 * Cloning disabled
	 */
	private function __clone() {
	}
	
	/**
	 * Serialization disabled
	 */
	private function __sleep() {
	}
	
	/**
	 * De-serialization disabled
	 */
	private function __wakeup() {
	}
	
	public function handle_save_settings() {
		if (@$_POST && isset ( $_POST ['option_page'] )) {
			$changed = false;
			if ('essbof_settings_group' == $this->getval ( $_POST, 'option_page' )) {
				$this->update_options ();
				$changed = true;
					
			}
			if ($changed) {
				$user_section = isset ( $_REQUEST ['section'] ) ? $_REQUEST ['section'] : '';
				$user_subsection = isset ( $_REQUEST ['subsection'] ) ? $_REQUEST ['subsection'] : '';
	
				// $goback = add_query_arg ( 'settings-updated', 'true',
				// wp_get_referer () );
				$goback = esc_url_raw ( add_query_arg ( array ('settings-updated' => 'true', 'section' => $user_section, 'subsection' => $user_subsection ), wp_get_referer () ) );
				// $goback = str_replace('#038;', '', $goback);
				wp_redirect ( $goback );
				die ();
			}
		}
	
	}
	
	
	public function attach_option_form($content) {
		global $essb3of_options;
		
		if (!is_main_query() || !in_the_loop()) {
			return $content;
		}
		
		$of_design = isset($essb3of_options['of_design']) ? $essb3of_options['of_design'] : '';
		$of_creditlink = isset($essb3of_options['of_creditlink']) ? $essb3of_options['of_creditlink'] : 'false';
		$of_posts = isset($essb3of_options['of_posts']) ? $essb3of_options['of_posts'] : 'false';
		$of_pages = isset($essb3of_options['of_pages']) ? $essb3of_options['of_pages'] : 'false';
		
		$output = '';
		$output .= "<!-- Best social sharing plugin for WordPress has optin module : http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo -->";
		
		// see if link plugin is selected
		if ($of_creditlink == 'true') {
			$output .= '<p style="font-size: 12px; text-align: center;">Powered by <a href="http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo" target="_blank">Best Social Sharing Plugin for WordPress</a> Easy Social Shre Buttons</p>';
		}		
		
		if ( (is_single() && $of_posts == 'true') || (is_page() && $of_pages == 'true') ) {
			$disable_facebook_comments = get_post_meta( get_the_ID(), 'essbof_disable', true );
			if ( $disable_facebook_comments != 'true') {
				$output .= do_shortcode('[easy-subscribe design="'.$of_design.'" mode="mailchimp"]');
				$content .= $output ;
			}
		}
		
		return $content;
	}
	
	public function handle_shortcode($atts) {
		global $essb3of_options;
		
		
		$fc_title = isset($essb3of_options['fc_title']) ? $essb3of_options['fc_title'] : '';
		$fc_colors = isset($essb3of_options['fc_colors']) ? $essb3of_options['fc_colors'] : 'light';
		$fc_comments = isset($essb3of_options['fc_comments']) ? $essb3of_options['fc_comments'] : '10';
		$fc_sort = isset($essb3of_options['fc_sort']) ? $essb3of_options['fc_sort'] : 'top';
		$fc_posts = isset($essb3of_options['fc_posts']) ? $essb3of_options['fc_posts'] : 'false';
		$fc_pages = isset($essb3of_options['fc_pages']) ? $essb3of_options['fc_pages'] : 'false';
		$fc_creditlink = isset($essb3of_options['fc_creditlink']) ? $essb3of_options['fc_creditlink'] : 'false';
		
		$output = '';
		$colorscheme_value = 'data-colorscheme="'.$fc_colors.'"';
		$width_value = 'data-width="100%"';
		$numpost_value = 'data-numposts="'.$fc_comments.'"';
		$orderby_value = 'data-order-by="'.$fc_sort.'"';
		
		if (!empty($fc_title)) {
			$output .= '<h3 class="essbfc-title">' . $fc_title . '</h3>';
		}
		
		$comment_str = '<div class="fb-comments" data-href="' . get_permalink () . '" ' . $width_value . ' ' . $numpost_value . ' ' . $colorscheme_value . ' ' . $orderby_value . ' ></div>';
		$output .= "<!-- Facebook Comments free Add-on for Easy Social Share Buttons for WordPress : http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo -->" . $comment_str;
		
		// see if link plugin is selected
		if ($fc_creditlink == 'true') {
			$output .= '<p style="font-size: 12px; text-align: center;">Powered by <a href="http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo" target="_blank">Facebook Comments free add-on for <b>most feature packed social sharing plugin for WordPress</b> Easy Social Share Buttons</a></p>';
		}
				
		return $output;
	}
	
	public function update_options() {
		global $essbof_options_structure;
	
		$tabs = $essbof_options_structure->tabs;
		$sidebar_sections = $essbof_options_structure->sidebar_sections;
		$sidebar_section_options = $essbof_options_structure->sidebar_section_options;
	
		$current_options = get_option ( ESSB3_OF_OPTIONS_NAME );
		if (! is_array ( $current_options )) {
			$current_options = array ();
		}
	
		$current_tab = isset ( $_REQUEST ['tab'] ) ? $_REQUEST ['tab'] : '';
		$user_options = isset ( $_REQUEST ['essb_options'] ) ? $_REQUEST ['essb_options'] : array ();
	
		$reset_settings = isset ( $_REQUEST ['reset_settings'] ) ? $_REQUEST ['reset_settings'] : '';
	
		// print_r($user_options);
	
		if ($current_tab == '') {
			return;
		}
	
		$options = $sidebar_section_options [$current_tab];
	
		foreach ( $options as $section => $fields ) {
			$section_options = $fields;
				
			foreach ( $section_options as $option ) {
				$type = $option ['type'];
				$id = isset ( $option ['id'] ) ? $option ['id'] : '';
	
				if ($id == '') {
					continue;
				}
	
				switch ($type) {
					case "checkbox_list_sortable" :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						$option_value = isset ( $user_options [$id . '_order'] ) ? $user_options [$id . '_order'] : '';
						$current_options [$id . '_order'] = $option_value;
						break;
					default :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						break;
				}
			}
		}
	
		$current_options = $this->clean_blank_values ( $current_options );
	
		
		update_option ( ESSB3_OF_OPTIONS_NAME, $current_options );
	
	}
	
	function clean_blank_values($object) {
		foreach ( $object as $key => $value ) {
			if (! is_array ( $value )) {
				$value = trim ( $value );
	
				if (empty ( $value )) {
					unset ( $object [$key] );
				}
			} else {
				if (count ( $value ) == 0) {
					unset ( $object [$key] );
				}
			}
		}
	
		return $object;
	}
		
	public function init() {
		
		
		if (is_admin()) {
			include_once (ESSB3_OF_PLUGIN_ROOT . 'lib/essbof-admin.php');
			add_action ( 'admin_menu', array ($this, 'register_menu' ), 99 );
			
			$hook = (defined ( 'WP_NETWORK_ADMIN' ) && WP_NETWORK_ADMIN) ? 'network_admin_menu' : 'admin_menu';
			add_action ( $hook, array ($this, 'handle_save_settings' ) );
			
			add_action ( 'add_meta_boxes', array ($this, 'create_metabox' ) );
			add_action ( 'save_post', array ($this, 'save_metabox' ) );
		}
	}
	
	public function register_menu() {
		global $essb_options;
	
		$menu_pos = false;
		$essb_access = "edit_pages";
			
		add_submenu_page ( 'essb_options', __ ( 'Optin forms in content', 'easy-optin-forms' ), '' . __ ( '[Addon] Optin forms in content', 'easy-optin-forms' ) . '', $essb_access, 'essb_of', array ($this, 'essb_of_settings_redirect' ) );
	}

	function essb_of_settings_redirect() {
		include_once (ESSB3_OF_PLUGIN_ROOT . 'lib/admin/essbof-settings.php');
	}
		
	public function create_metabox() {
		$pts = get_post_types ( array ('show_ui' => true, '_builtin' => true ) );
		foreach ( $pts as $pt ) {
			add_meta_box ( 'essbof_metabox', __ ( 'Optin forms in content', 'easy-optin-forms' ), array ($this, 'essb_of_metabox' ), $pt, 'side', 'high' );
		
		}
	}
	
	public function save_metabox() {
		global $post, $post_id;
		
		if (! $post) {
			return $post_id;
		}
		
		if (! $post_id) {
			$post_id = $post->ID;
		}
		$essb_metabox = isset ( $_REQUEST ['essb_of_metabox'] ) ? $_REQUEST ['essb_of_metabox'] : array ();
		$this->save_metabox_value ( $post_id, 'essbof_disable', $essb_metabox );
	
	}
	
	public function save_metabox_value($post_id, $option, $valueContainer) {
		$value = isset ( $valueContainer [$option] ) ? $valueContainer [$option] : '';
		if (! empty ( $value )) {
			update_post_meta ( $post_id, $option, $value );
		} else {
			delete_post_meta ( $post_id, $option );
		}
	}
	
	function essb_of_metabox() {
		global $post;
		
		if (isset ( $_GET ['action'] )) {
			
			$custom = get_post_custom ( $post->ID );
			$essb_views = isset ( $custom ["essbof_disable"] ) ? $custom ["essbof_disable"] [0] : "";
			
			if (class_exists ( 'ESSBMetaboxInterface' )) {
				
				ESSBMetaboxInterface::draw_form_start ( 'essb_of_metabox' );
				
				ESSBMetaboxOptionsFramework::draw_section_start ();
				
				ESSBMetaboxOptionsFramework::draw_options_row_start ( __ ( 'Disable Optin forms in content', 'easy-optin-forms' ), __ ( 'Activate this option to disable display of Facebook Comments', 'easy-optin-forms' ), '', '2', false );
				ESSBMetaboxOptionsFramework::draw_options_row_end ();
				
				ESSBMetaboxOptionsFramework::draw_options_row_start ( '', '', '', '2', false );
				ESSBMetaboxOptionsFramework::draw_switch_field ( 'essbof_disable', 'essb_of_metabox', $essb_views, __ ( 'Yes', ESSB3_TEXT_DOMAIN ), __ ( 'No', ESSB3_TEXT_DOMAIN ) );
				
				ESSBMetaboxOptionsFramework::draw_options_row_end ();
				
				ESSBMetaboxOptionsFramework::draw_section_end ();
				
				ESSBMetaboxInterface::draw_form_end ();
			}
		}
	}
	
	function getval($from, $what, $default = false) {
		if (is_object ( $from ) && isset ( $from->$what ))
			return $from->$what;
		else if (is_array ( $from ) && isset ( $from [$what] ))
			return $from [$what];
		else
			return $default;
	}
}

/**
 * main code *
 */
global $essb_of;
function essb_optin_forms() {
	global $essb_of;
	
	if (! isset ( $essb_of )) {
		$essb_of = ESSBAddonOptinForms::getInstance ();
	}
}

add_action ( 'init', 'essb_optin_forms', 9 );