<?php
global $essbfc_options_structure;
if (!class_exists('ESSBOptionsStructureHelperShared') && defined('ESSB3_VERSION')) {
	include_once (ESSB3_PLUGIN_ROOT . 'lib/core/options/essb-options-structure-shared.php');

}

if (!class_exists('ESSBOptionsStructureHelperShared')) { return; }


$essbfc_options_structure = new ESSBOptionsStructureHelperShared();
$essbfc_options_structure->tab('settings', __('Facebook Comments', 'easy-facebook-comments'), __('Facebook Comments', 'easy-facebook-comments'));

$essbfc_options_structure->menu_item('settings', 'settings', __('Settings', 'easy-facebook-comments'), 'default');

$essbfc_options_structure->field_heading('settings', 'settings', 'heading1', __('Settings', 'easy-facebook-comments'));
$essbfc_options_structure->field_textbox_stretched('settings', 'settings', 'fc_appid', __('Facebook Application ID', 'easy-facebook-comments'), __('Enter your Facebook Application ID or leave this field blank if you have done this with another plugin (for example SEO plugin). If you do not have application assigned with your site you need to create such in Facebook Developer Center - <a href="https://developers.facebook.com/apps" target="_blank">click here to open it</a>.', 'easy-facebook-comments'));
$essbfc_options_structure->field_textbox_stretched('settings', 'settings', 'fc_admin', __('Enter Facebook IDs of Moderators for comments', 'easy-facebook-comments'), __('Enter profile IDs for users that will be able to moderate comments. If you do not know your Facebook Profile ID you can visit <a href="http://findmyfbid.com/" target="_blank">this site</a> to get it.', 'easy-facebook-comments'));
$essbfc_options_structure->field_heading('settings', 'settings', 'heading5', __('Visual', 'easy-facebook-comments'));
$list_of_methods = array ("light" => __('Light', 'easy-facebook-comments'), "dark" => __('Dark', 'easy-facebook-comments'));
$essbfc_options_structure->field_textbox_stretched('settings', 'settings', 'fc_title', __('Enter custom title before comments block', 'easy-facebook-comments'), __('If you wish to have title of your comments block enter it here.', 'easy-facebook-comments'));
$essbfc_options_structure->field_select('settings', 'settings', 'fc_colors', __('Color scheme', 'easy-facebook-comments'), __('Choose color scheme for your Facebook comments', 'easy-facebook-comments'), $list_of_methods);
$essbfc_options_structure->field_textbox('settings', 'settings', 'fc_comments', __('Number of comments to display', 'easy-facebook-comments'), __('Enter number of comments that will be visible when page is loaded or leave blank for default value of 10.', 'easy-facebook-comments'));
$list_of_methods = array ("social" => __('Top', 'easy-facebook-comments'), "time" => __('Oldest', 'easy-facebook-comments'), 'reverse_time' => __('Newest', 'easy-facebook-comments'));
$essbfc_options_structure->field_select('settings', 'settings', 'fc_sort', __('How comments should be ordered', 'easy-facebook-comments'), __('Choose how you wish comments to be ordered and displayed. Default value is Top', 'easy-facebook-comments'), $list_of_methods);
$essbfc_options_structure->field_switch('settings', 'settings', 'fc_posts', __('Display on posts', 'easy-facebook-comments'), __('Automatically display comments on posts.', 'easy-facebook-comments'), '', __('Yes', 'easy-facebook-comments'), __('No', 'easy-facebook-comments'));
$essbfc_options_structure->field_switch('settings', 'settings', 'fc_pages', __('Display on pages', 'easy-facebook-comments'), __('Automatically display comments on pages.', 'easy-facebook-comments'), '', __('Yes', 'easy-facebook-comments'), __('No', 'easy-facebook-comments'));
$essbfc_options_structure->field_func('settings', 'settings', 'fc_manual_display', __('Display using shortcode', 'easy-facebook-comments'), __('Display anywhere on your site using shortcode.', 'easy-facebook-comments'), '', __('Yes', 'easy-facebook-comments'), __('No', 'easy-facebook-comments'));

$essbfc_options_structure->field_switch('settings', 'settings', 'fc_creditlink', __('Include credit link', 'easy-facebook-comments'), __('Include tiny credit link below your comments box to allow others know what you are using to generate Facebook Comments. Activate this option to show your appreciation for our efforts.', 'easy-facebook-comments'), '', __('Yes', 'easy-facebook-comments'), __('No', 'easy-facebook-comments'));

$essbfc_options_structure->field_heading('settings', 'settings', 'heading5', __('Integration', 'easy-facebook-comments'));

$essbfc_options_structure->field_switch('settings', 'settings', 'fc_usesapi', __('My site already uses Facebook API', 'easy-facebook-comments'), __('Activate this option if your site already uses Facebook API on it. Once you activate this option if your comments do not appear then go back here and deactivate it - your site does not use Facebook API', 'easy-facebook-comments'), '', __('Yes', 'easy-facebook-comments'), __('No', 'easy-facebook-comments'));
$essbfc_options_structure->field_textbox('settings', 'settings', 'fc_customver', __('Custom version of Facebook API', 'easy-facebook-comments'), __('If you need to change the version of API that plugin uses enter it here (example: 2.2, 2.3, 2.4 or 2.5). We recommend to leave blank and allow us to choose the best for your site.', 'easy-facebook-comments'));
$list_of_methods = array ("" => __('Default language (English US)', 'easy-facebook-comments'), "af_ZA" => "Afrikaans","ak_GH" => "Akan","am_ET" => "Amharic","ar_AR" => "Arabic","as_IN" => "Assamese","ay_BO" => "Aymara","az_AZ" => "Azerbaijani","be_BY" => "Belarusian","bg_BG" => "Bulgarian","bn_IN" => "Bengali","br_FR" => "Breton","bs_BA" => "Bosnian","ca_ES" => "Catalan","cb_IQ" => "Sorani Kurdish","ck_US" => "Cherokee","co_FR" => "Corsican","cs_CZ" => "Czech","cx_PH" => "Cebuano","cy_GB" => "Welsh","da_DK" => "Danish","de_DE" => "German","el_GR" => "Greek","en_GB" => "English (UK)","en_IN" => "English (India)","en_PI" => "English (Pirate)","en_UD" => "English (Upside Down)","en_US" => "English (US)","eo_EO" => "Esperanto","es_CL" => "Spanish (Chile)","es_CO" => "Spanish (Colombia)","es_ES" => "Spanish (Spain)","es_LA" => "Spanish","es_MX" => "Spanish (Mexico)","es_VE" => "Spanish (Venezuela)","et_EE" => "Estonian","eu_ES" => "Basque","fa_IR" => "Persian","fb_LT" => "Leet Speak","ff_NG" => "Fulah","fi_FI" => "Finnish","fo_FO" => "Faroese","fr_CA" => "French (Canada)","fr_FR" => "French (France)","fy_NL" => "Frisian","ga_IE" => "Irish","gl_ES" => "Galician","gn_PY" => "Guarani","gu_IN" => "Gujarati","gx_GR" => "Classical Greek","ha_NG" => "Hausa","he_IL" => "Hebrew","hi_IN" => "Hindi","hr_HR" => "Croatian","ht_HT" => "Haitian Creole","hu_HU" => "Hungarian","hy_AM" => "Armenian","id_ID" => "Indonesian","ig_NG" => "Igbo","is_IS" => "Icelandic","it_IT" => "Italian","ja_JP" => "Japanese","ja_KS" => "Japanese (Kansai)","jv_ID" => "Javanese","ka_GE" => "Georgian","kk_KZ" => "Kazakh","km_KH" => "Khmer","kn_IN" => "Kannada","ko_KR" => "Korean","ku_TR" => "Kurdish (Kurmanji)","ky_KG" => "Kyrgyz","la_VA" => "Latin","lg_UG" => "Ganda","li_NL" => "Limburgish","ln_CD" => "Lingala","lo_LA" => "Lao","lt_LT" => "Lithuanian","lv_LV" => "Latvian","mg_MG" => "Malagasy","mi_NZ" => "Māori","mk_MK" => "Macedonian","ml_IN" => "Malayalam","mn_MN" => "Mongolian","mr_IN" => "Marathi","ms_MY" => "Malay","mt_MT" => "Maltese","my_MM" => "Burmese","nb_NO" => "Norwegian (bokmal)","nd_ZW" => "Ndebele","ne_NP" => "Nepali","nl_BE" => "Dutch (België)","nl_NL" => "Dutch","nn_NO" => "Norwegian (nynorsk)","ny_MW" => "Chewa","or_IN" => "Oriya","pa_IN" => "Punjabi","pl_PL" => "Polish","ps_AF" => "Pashto","pt_BR" => "Portuguese (Brazil)","pt_PT" => "Portuguese (Portugal)","qc_GT" => "Quiché","qu_PE" => "Quechua","rm_CH" => "Romansh","ro_RO" => "Romanian","ru_RU" => "Russian","rw_RW" => "Kinyarwanda","sa_IN" => "Sanskrit","sc_IT" => "Sardinian","se_NO" => "Northern Sámi","si_LK" => "Sinhala","sk_SK" => "Slovak","sl_SI" => "Slovenian","sn_ZW" => "Shona","so_SO" => "Somali","sq_AL" => "Albanian","sr_RS" => "Serbian","sv_SE" => "Swedish","sw_KE" => "Swahili","sy_SY" => "Syriac","sz_PL" => "Silesian","ta_IN" => "Tamil","te_IN" => "Telugu","tg_TJ" => "Tajik","th_TH" => "Thai","tk_TM" => "Turkmen","tl_PH" => "Filipino","tl_ST" => "Klingon","tr_TR" => "Turkish","tt_RU" => "Tatar","tz_MA" => "Tamazight","uk_UA" => "Ukrainian","ur_PK" => "Urdu","uz_UZ" => "Uzbek","vi_VN" => "Vietnamese","wo_SN" => "Wolof","xh_ZA" => "Xhosa","yi_DE" => "Yiddish","yo_NG" => "Yoruba","zh_CN" => "Simplified Chinese (China)","zh_HK" => "Traditional Chinese (Hong Kong)","zh_TW" => "Traditional Chinese (Taiwan)","zu_ZA" => "Zulu","zz_TR" => "Zazaki");
$essbfc_options_structure->field_select('settings', 'settings', 'fc_language', __('Choose language for comments display', 'easy-facebook-comments'), __('Choose your language from the list or leave blank for English US', 'easy-facebook-comments'), $list_of_methods);

function fc_manual_display() {
	echo 'To display Facebook Comments using shortcode place <b>[easy-facebook-comments]</b> at the place where you wish they to appear';
}

?>