<?php

/*
 * Plugin Name: Easy Social Share Buttons for WordPress Display Method - WooCommerce Share Bar
 * Description: Activate usage of WooCommerce Share Bar display method
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Version: 1.0
 * Author: CreoApps
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

define ( 'ESSB_DM_WSB_PLUGIN_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESSB_DM_WSB_PLUGIN_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );


add_action('init', 'essb_display_method_woocommercebar_styles', 99);

add_filter('essb4_button_positions', 'essb_display_woocommercebar');
add_filter('essb4_button_positions_mobile', 'essb_display_woocommercebar');
add_filter('essb4_custom_positions', 'essb_display_register_woocommercebar');
add_filter('essb4_custom_method_list', 'essb_register_woocommercebar');
add_filter("essb4_position_style_woocommercebar", "essb_applystyle_woocommercebar");

add_filter('wp_footer', 'essb4_woocommercebar_display', 9);

function essb_woocommercebar_key() {
	return 'display-32';
}

function essb_register_woocommercebar($methods) {
	$methods[essb_woocommercebar_key()] = __('WooCommerce Share Bar', 'essb');
	
	return $methods;
}

function essb_display_method_woocommercebar_styles() {
	
	if (function_exists('essb_resource_builder')) {
		essb_resource_builder()->add_static_resource(ESSB_DM_WSB_PLUGIN_URL . '/assets/essb-display.css', 'essb-woocommercebar', 'css');
	}
	
	if (is_admin()) {
		include_once ESSB_DM_WSB_PLUGIN_ROOT . 'lib/essb-display-woocommercebar-settings.php';
	}
}

function essb_display_woocommercebar($positions) {
	
	$positions['woocommercebar'] = array ("image" => ESSB_DM_WSB_PLUGIN_URL."/assets/icon.png", "label" => __("WooCommerce Share Bar", "essb") );
	
	return $positions;
}

function essb_display_register_woocommercebar($positions) {
	$positions['woocommercebar'] = __('WooCommerce Share Bar', 'essb');
}

function essb4_woocommercebar_display() {
	$buttons = '';
	
	$general_options = essb_core()->get_general_options();
	$is_valid = false;
	if (is_array($general_options)) {
		
		if (in_array('woocommercebar', $general_options['button_position'])) {
			$is_valid = true;
		}
		
		if (is_archive() || is_front_page() || is_search() || is_tag() || is_post_type_archive() || is_home()) {
			$is_valid = false;
		}
		
		if (!function_exists('is_product')) {
			$is_valid = false;
		}
		else {
			$is_valid = is_product();
		}
		
		if (!in_array('woocommercebar', $general_options['button_position'])) {
			$is_valid = false;
		}
		
		if ($is_valid) {
			//$post_types = $general_options['display_in_types'];
			//if (essb_core()->check_applicability($post_types, 'woocommercebar')) {
				//$buttons = '<b>SuperPostBar will go here!</b>';
				include_once ESSB_DM_WSB_PLUGIN_ROOT . 'lib/essb-display-woocommercebar-draw.php';
				$buttons = essb_woocommercebar_draw();
			//}
		}
	}
	
	print $buttons;
	
}

function essb_applystyle_woocommercebar($button_style) {
	$position = 'woocommercebar';
	if (essb_option_value($position.'_template') != "") {
		$button_style['template'] = essb_option_value($position.'_template');
	}

	$button_style['nospace'] = essb_option_value($position.'_nospace');
	$button_style['show_counter'] = essb_option_value($position.'_show_counter');
	$button_style['counter_pos'] = essb_option_value($position.'_counter_pos');
	$button_style['total_counter_pos'] = 'hidden';
	$button_style['button_style'] = essb_option_value($position.'_button_style');

	if ($button_style['button_style'] == 'recommended') {
		$button_style['button_style'] = 'icon';
	}
	
	$position_animation = essb_option_value($position.'_css_animations');
	if (!empty($position_animation)) {
		$button_style['button_animation'] = $position_animation;
	}
	
	
	$button_style['button_width'] = 'auto';	
	
	return $button_style;
}