<?php

$essb_settings_tab = 'where';
$essb_settings_menu = essb_superpostbar_key();

// loading display method settings safe to prevent possible errors
if (class_exists('ESSBOptionsStructureHelper')) {
	
	ESSBOptionsStructureHelper::field_section_start_panels($essb_settings_tab, $essb_settings_menu, __('Deactivate default components', 'essb'), __('Deactivate default components used by this display method', 'essb'));
	ESSBOptionsStructureHelper::field_switch_panel($essb_settings_tab, $essb_settings_menu, 'spb_deactivate_prevnext', __('Deactivate previous/next articles', 'essb'), __('Activate this option if you wish to deactivate display of previous/next article buttons', 'essb'), '', __('Yes', 'essb'), __('No', 'essb'));
	ESSBOptionsStructureHelper::field_switch_panel($essb_settings_tab, $essb_settings_menu, 'spb_deactivate_comments', __('Deactivate comments counter', 'essb'), __('Activate this option if remove display of comments counter', 'essb'), '', __('Yes', 'essb'), __('No', 'essb'));
	ESSBOptionsStructureHelper::field_switch_panel($essb_settings_tab, $essb_settings_menu, 'spb_deactivate_shares', __('Deactivate shares counter', 'essb'), __('Activate this option if remove display of total shares counter', 'essb'), '', __('Yes', 'essb'), __('No', 'essb'));
	ESSBOptionsStructureHelper::field_section_end_panels($essb_settings_tab, $essb_settings_menu);
	
	ESSBOptionsStructureHelper::field_section_start_panels($essb_settings_tab, $essb_settings_menu, __('Component appearance', 'essb'), __('Customize how this display method will appear', 'essb'));
	
	ESSBOptionsStructureHelper::field_select_panel($essb_settings_tab, $essb_settings_menu, 'spb_prevnext_location', __('Where will prev/next article section appear', 'essb'), __('Choose position if you have left this component active.', 'essb'), array('after' => __('After share buttons', 'essb'), 'before' => __('Before share buttons', 'essb')));
	ESSBOptionsStructureHelper::field_select_panel($essb_settings_tab, $essb_settings_menu, 'spb_counter_location', __('Where will share/comments counters appear', 'essb'), __('Choose position if you have left this component active.', 'essb'), array('left' => __('On the left side', 'essb'), 'right' => __('On the right side', 'essb')));
	
	
	ESSBOptionsStructureHelper::field_section_end_panels($essb_settings_tab, $essb_settings_menu);
	//ESSBOptionsStructureHelper::title($essb_settings_tab, $essb_settings_menu, __('Customize share buttons style', 'essb'), __('Make a settings change to allow buttons fit best in your theme', 'essb'), 'inner-row');
	ESSBOptionsStructureHelper::field_heading($essb_settings_tab, $essb_settings_menu, 'heading5', __('Customize share buttons style', 'essb'));
	
	ESSBOptionsStructureHelper::field_section_start($essb_settings_tab, $essb_settings_menu, '', '');
	$location = 'superpostbar';
	ESSBOptionsStructureHelper::field_select($essb_settings_tab, $essb_settings_menu, $location.'_button_style', __('Buttons Style', 'essb'), __('Select your button display style.', 'essb'), essb_avaiable_button_style_with_recommend());
	ESSBOptionsStructureHelper::field_select($essb_settings_tab, $essb_settings_menu, $location.'_template', __('Template', 'essb'), __('Select your template for that display location.', 'essb'), essb_available_tempaltes4(true));
	ESSBOptionsStructureHelper::field_switch($essb_settings_tab, $essb_settings_menu, $location.'_nospace', __('Remove spacing between buttons', 'essb'), __('Activate this option to remove default space between share buttons.', 'essb'), '', __('Yes', 'essb'), __('No', 'essb'));
	ESSBOptionsStructureHelper::field_switch($essb_settings_tab, $essb_settings_menu, $location.'_show_counter', __('Display counter of sharing', 'essb'), __('Activate display of share counters.', 'essb'), '', __('Yes', 'essb'), __('No', 'essb'));
	ESSBOptionsStructureHelper::field_select($essb_settings_tab, $essb_settings_menu, $location.'_counter_pos', __('Position of counters', 'essb'), __('Choose your default button counter position', 'essb'), essb_avaliable_counter_positions());
	
	ESSBOptionsStructureHelper::field_select($essb_settings_tab, $essb_settings_menu, $location.'_customwidth', __('Customize width of buttons', 'essb'), __('Choose how your button width will be applied on share buttons', 'essb'), array('automatic' => __('Automatic width', 'essb'), 'flex' => __('Flexible full width', 'essb')));
	
	$animations_container = array ();
	$animations_container[""] = "Default value from settings";
	foreach (essb_available_animations() as $key => $text) {
		if ($key != '') {
			$animations_container[$key] = $text;
		}
		else {
			$animations_container['no'] = 'No amination';
		}
	}
	
	ESSBOptionsStructureHelper::field_select($essb_settings_tab, $essb_settings_menu, $location.'_css_animations', __('Activate animations', 'essb'), __('Animations
			are provided with CSS transitions and work on best with retina
			templates.', 'essb'), $animations_container);
	
	ESSBOptionsStructureHelper::field_section_end($essb_settings_tab, $essb_settings_menu);
	
	
	ESSBOptionsStructureHelper::panel_start($essb_settings_tab, $essb_settings_menu, __('Customize used social networks for this display method', 'essb'), __('Activate this option if you wish to make a full change of default share buttons that you use on entire site.', 'essb'), 'fa21 fa fa-cogs', array("mode" => "switch", 'switch_id' => $location.'_activate', 'switch_on' => __('Yes', 'essb'), 'switch_off' => __('No', 'essb'), 'switch_submit' => 'true'));
	if (essb_option_bool_value($location.'_activate')) {
		
		global $essb_networks;
		
		$checkbox_list_networks = array();
		foreach ($essb_networks as $key => $object) {
			$checkbox_list_networks[$key] = $object['name'];
		}
		ESSBOptionsStructureHelper::title($essb_settings_tab, $essb_settings_menu, __('Customize active social networks', 'essb'), __('Apply selection only if you wish to modify the default network list that is used over site.', 'essb'), 'inner-row');
		ESSBOptionsStructureHelper::field_checkbox_list_sortable($essb_settings_tab, $essb_settings_menu, $location.'_networks', '', '', $checkbox_list_networks);
		ESSBOptionsStructureHelper::panel_start($essb_settings_tab, $essb_settings_menu, __('Customize text of social network over button', 'essb'), __('Set texts that will appear on selected display method instead of default network names. Use dash (-) if you wish to remove text for that network name.', 'essb'), 'fa21 fa fa-cogs', array("mode" => "switch", 'switch_id' => $location.'_name_change', 'switch_on' => __('Yes', 'essb'), 'switch_off' => __('No', 'essb')));
		
		ESSBOptionsStructureHelper::structure_row_start($essb_settings_tab, $essb_settings_menu, 'inner-row social-name-change');
		$count = 0;
		foreach ($checkbox_list_networks as $key => $text) {
			if ($count == 4) {
				ESSBOptionsStructureHelper::structure_row_end($essb_settings_tab, $essb_settings_menu);
				ESSBOptionsStructureHelper::structure_row_start($essb_settings_tab, $essb_settings_menu, 'inner-row social-name-change');
				$count = 0;
			}
			$count++;
			ESSBOptionsStructureHelper::structure_section_start($essb_settings_tab, $essb_settings_menu, 'c3');
			ESSBOptionsStructureHelper::field_textbox_panel($essb_settings_tab, $essb_settings_menu, $location.'_'.$key.'_name', $text, '', '', '', '', '', '6');
			ESSBOptionsStructureHelper::structure_section_end($essb_settings_tab, $essb_settings_menu);
		}
		
		ESSBOptionsStructureHelper::structure_row_end($essb_settings_tab, $essb_settings_menu);
		ESSBOptionsStructureHelper::panel_end($essb_settings_tab, $essb_settings_menu); // network names
	}
	ESSBOptionsStructureHelper::panel_end($essb_settings_tab, $essb_settings_menu); // customization
	
}