<?php

/*
 * Plugin Name: Easy Social Share Buttons for WordPress: Functional Buttons Pack
 * Description: Include usage of functional buttons set: Previous Post, Next Post, Copy Link, Bookmark, QR Code Generator
 * Page Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Version: 1.0 
 * Author: CreoApps 
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

define ( 'ESSB_FP_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESSB_FP_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );

add_filter ( 'essb4_social_networks', 'essb_functional_pack_register' );

function essb_functional_pack_register($networks) {
	$networks ['prevpost'] = array ('name' => 'Previous Post', 'type' => 'buildin', 'supports' => 'desktop,mobile,retina templates only' );
	$networks ['nextpost'] = array ('name' => 'Next Post', 'type' => 'buildin', 'supports' => 'desktop,mobile,retina templates only' );
	$networks ['copylink'] = array ('name' => 'Copy Link', 'type' => 'buildin', 'supports' => 'desktop,mobile,retina templates only' );
	$networks ['bookmark'] = array ('name' => 'Bookmark Page', 'type' => 'buildin', 'supports' => 'desktop,mobile,retina templates only' );
	$networks ['qrcode'] = array ('name' => 'QR Code', 'type' => 'buildin', 'supports' => 'desktop,mobile,retina templates only' );
	return $networks;
}

add_action ( 'wp_enqueue_scripts', 'essfb_register_assets', 2 );
add_action ( 'admin_enqueue_scripts', 'essfb_register_assets_admin', 100 );
add_action ( 'wp_footer', 'essbfp_require_scripts', 100);
add_filter ( 'essb4_after_draw_buttons', 'essbfp_after_share_buttons', 10, 2);

function essfb_register_assets() {
	if (! defined ( 'ESSB3_VERSION' )) {
		return;
	}
	
	if (essb_is_plugin_deactivated_on () || essb_is_module_deactivated_on ( 'share' )) {
		return;
	}
	
	$resource_url = ESSB_FP_URL . '/assets/essb-functional-pack.css';
	essb_resource_builder ()->add_static_resource ( $resource_url, 'easy-social-share-buttons-functional-pack', 'css' );
	essb_resource_builder ()->activate_resource ( 'essb-fp' );

	$resource_url = ESSB_FP_URL . '/assets/clipboard.min.js';
	essb_resource_builder ()->add_static_resource ( $resource_url, 'easy-social-share-buttons-functional-pack', 'js' , true);
	essb_resource_builder ()->activate_resource ( 'essb-fp-js' );

	$resource_url = ESSB_FP_URL . '/assets/qrcode.min.js';
	essb_resource_builder ()->add_static_resource ( $resource_url, 'easy-social-share-buttons-functional-qrcode', 'js' , true);
	essb_resource_builder ()->activate_resource ( 'essb-fp-qrcode' );
	
}

function essfb_register_assets_admin() {
	wp_register_style ( 'essb-fp-admin-icon', ESSB_FP_URL . '/assets/essb-functional-pack.css', array (), ESSB3_VERSION );
	wp_enqueue_style ( 'essb-fp-admin-icon' );

}

add_filter ( 'essb4_shareapi_api_command_bookmark', 'essbfp_bookmark_command' );
add_filter ( 'essb4_shareapi_api_command_copylink', 'essbfp_copylink_command' );
add_filter ( 'essb4_shareapi_api_command_qrcode', 'essbfp_qrcode_command' );
add_filter ( 'essb4_shareapi_url_prevpost', 'essb_fp_prevpost_url' );
add_filter ( 'essb4_shareapi_url_nextpost', 'essb_fp_nextpost_url' );
add_filter ( 'essb4_no_counter_for_nextpost', '__return_true');
add_filter ( 'essb4_no_counter_for_prevpost', '__return_true');
add_filter ( 'essb4_no_counter_for_copylink', '__return_true');
add_filter ( 'essb4_no_counter_for_bookmark', '__return_true');
add_filter ( 'essb4_no_counter_for_qrcode', '__return_true');

add_filter ( 'essb4_shareapi_api_command_prevpost', 'essbfp_prevpost_command' );

function essbfp_prevpost_command($share) {
	$salt = $share['salt'];
	return 'essb_tracking_only(\'\', \'prevpost\', \''.$salt.'\', true);';
}

function essbfp_copylink_command($share) {
	$salt = $share['salt'];
	return 'essbfp_copylink(\''.$share['salt'].'\'); essb_tracking_only(\'\', \'copylink\', \''.$salt.'\', true); return false;';
}

function essbfp_qrcode_command($share) {
	$url = $share['url'];
	$salt = $share['salt'];
	return 'essbfp_qrcode(\''.$salt.'\', \''.$url.'\'); essb_tracking_only(\'\', \'qrcode\', \''.$salt.'\', true); return false;';
}

function essbfp_bookmark_command($share) {
	$salt = $share['salt'];
	return 'essbf_bookmark_page(); essb_tracking_only(\'\', \'bookmark\', \''.$salt.'\', true); return false;';
}

function essb_fp_prevpost_url($share) {
	$url = '';
	$prev_post = get_previous_post ();
	if (! empty ( $prev_post )) {
		$url = get_permalink ( $prev_post->ID );
	}
	return $url;
}

function essb_fp_nextpost_url($share) {
	$url = '';
	$prev_post = get_next_post ();
	if (! empty ( $prev_post )) {
		$url = get_permalink ( $prev_post->ID );
	}
	return $url;
}

function essbfp_require_scripts() {
	if (! defined ( 'ESSB3_VERSION' )) {
		return;
	}
	
	if (essb_is_plugin_deactivated_on () || essb_is_module_deactivated_on ( 'share' )) {
		return;
	}
	
	echo '<script type="text/javascript">';
	echo '
	function essbf_bookmark_page() {
		var bookmarkURL = window.location.href;
    	var bookmarkTitle = document.title;

    	if (\'addToHomescreen\' in window && addToHomescreen.isCompatible) {
		      // Mobile browsers
      		addToHomescreen({ autostart: false, startDelay: 0 }).show(true);
    	} else if (window.sidebar && window.sidebar.addPanel) {
		      // Firefox <=22
      		window.sidebar.addPanel(bookmarkTitle, bookmarkURL, \'\');
    	} else if ((window.sidebar && /Firefox/i.test(navigator.userAgent)) || (window.opera && window.print)) {
		      // Firefox 23+ and Opera <=14
      		jQuery(this).attr({
        		href: bookmarkURL,
        		title: bookmarkTitle,
        		rel: \'sidebar\'
      		}).off(e);
      		return true;
    	} else if (window.external && (\'AddFavorite\' in window.external)) {
      		// IE Favorites
      		window.external.AddFavorite(bookmarkURL, bookmarkTitle);
    	} else {
      		// Other browsers (mainly WebKit & Blink - Safari, Chrome, Opera 15+)
     		 alert(\'Press \' + (/Mac/i.test(navigator.userAgent) ? \'Cmd\' : \'Ctrl\') + \'+D to bookmark this page.\');
    	}

   		return false;
	}
	
	function essbfp_copylink(instance) {
	    return false;
	}	
	
	function essbfp_qrcode(instance, url) {
		var element = jQuery("#essb-qr-"+instance);
		
		if (!jQuery(element).hasClass("generated")) {
			var qrcode = new QRCode("essb-qr-"+instance);
			qrcode.makeCode(url);
			jQuery(element).addClass("generated");
		}
		
		setTimeout(function() {
			var qrContent = document.getElementById("essb-qr-"+instance).innerHTML;
			essbQRCodeOpenPopup(qrContent);
		}, 1);
		return false;
	}
	
	function essbQRCodeOpenPopup(content){ 
    winpops = window.open(
        \'\',
        \'QR Code\',
        \'fullscreen=no, toolbar=yes, status=yes, menubar=yes, scrollbars=yes, resizable=yes, directories=yes, location=yes, width=500, height=400, left=100, top=100, screenX=100, screenY=100\');
     
    // Write the content to the popup
    winpops.document.write(\'<style type="text/css">#content div { font-family: sans-serif; font-weight: bold; text-align:center; margin: 20px 0; } #content img { margin: 0 auto; }</style><div id="content" style="-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif">\'+content+\'</div>\');
} 
	
	jQuery( document ).ready(function() {
    	new Clipboard(\'.essb_link_copylink a\', {
    		text: function(trigger) {
    			var element = trigger.parentElement.parentElement.parentElement;
    			var url = jQuery(element).attr("data-essb-url") || "";
    			console.log("closest URL = " +url);
        		return url;
    		}
		});
	});
	';
	echo '</script>';
}

function essbfp_after_share_buttons($share = array(), $style = array()) {
	
	$salt = $share['salt'];
	
	$result = '';
	$result .= '<div class="essb-qr-code" id="essb-qr-'.$salt.'" style="display: none;">';
	$result .= '<div style="font-size: 16px;">Use Scan QR Code to copy link and share it</div>';
	$result .= '</div>';
	
	return $result;
}