<?php
global $essbpv_options_structure;
if (!class_exists('ESSBOptionsStructureHelperShared') && defined('ESSB3_VERSION')) {
	include_once (ESSB3_PLUGIN_ROOT . 'lib/core/options/essb-options-structure-shared.php');

}

if (!class_exists('ESSBOptionsStructureHelperShared')) { return; }
$essbpv_options_structure = new ESSBOptionsStructureHelperShared();
$essbpv_options_structure->tab('settings', __('Post View Settings', 'easy-post-views'), __('Post View Settings', 'easy-post-views'));

$essbpv_options_structure->menu_item('settings', 'postviews', __('Settings', 'easy-post-views'), 'default');
$essbpv_options_structure->menu_item('settings', 'display', __('Display', 'easy-post-views'), 'default');

$essbpv_options_structure->field_heading('settings', 'postviews', 'heading1', __('Settings', 'easy-post-views'));
$essbpv_options_structure->field_switch('settings', 'postviews', 'postviews_active', __('Activate display of post views', 'easy-post-views'), __('Activate this option if you wish automatically to display post views.', 'easy-post-views'), '', __('Yes', 'easy-post-views'), __('No', 'easy-post-views'));
$essbpv_options_structure->field_textbox('settings', 'postviews', 'postviews_text', __('Append custom text to views counter', 'easy-post-views'), __('Customize the default text that is added below view counter. Leave blank for default value views or enter custom text (example: reads)', 'easy-post-views'));
$list_of_methods = array ("short" => __('Short number value (100, 1k, 10k, 1m)', 'easy-post-views'), "full" => __('Full number value (100, 1000, 10000)', 'easy-post-views'));
$essbpv_options_structure->field_select('settings', 'postviews', 'postviews_value_type', __('Value display type', 'easy-post-views'), __('Choose how number value will be displayed. Recommended option is short numbers'), $list_of_methods);
$list_of_methods = array ("normal" => __('Regular update', 'easy-post-views'), "ajax" => __('Cache compatible update mode', 'easy-post-views'));
$essbpv_options_structure->field_select('settings', 'postviews', 'postviews_value_update', __('Value display type', 'easy-post-views'), __('Choose how number value will be displayed. Recommended option is short numbers'), $list_of_methods);

$list_of_methods = array ("light" => __('Dark text on light background', 'easy-post-views'), "dark" => __('Light text on dark background', 'easy-post-views'));
$essbpv_options_structure->field_select('settings', 'postviews', 'postviews_style', __('Display style', 'easy-post-views'), __('Choose display style based on your theme', 'easy-post-views'), $list_of_methods);

$list_of_methods = array ("no" => __('Do not display post views', 'easy-post-views'),  "automatic" => __('Let plugin choose best position', 'easy-post-views'), "left" => __('Left', 'easy-post-views'), "right" => __('Right', 'easy-post-views'));

if (function_exists('essb_avaliable_content_positions')) {
	$positions = essb_avaliable_content_positions();
	$essbpv_options_structure->field_heading('settings', 'display', 'heading5', __('Content Positions', 'easy-post-views'));
	
	foreach ($positions as $key => $data) {
		$key = str_replace('content_', '', $key);
		$essbpv_options_structure->field_select('settings', 'display', 'postviews_position_'.$key, __($data['label'], 'easy-post-views'), __('Choose post views counter position for '.$data['label'].' display method'), $list_of_methods);		
	}
}

if (function_exists('essb_available_button_positions')) {
	$positions = essb_available_button_positions();
	$essbpv_options_structure->field_heading('settings', 'display', 'heading5', __('Button Positions', 'easy-post-views'));

	foreach ($positions as $key => $data) {
		$essbpv_options_structure->field_select('settings', 'display', 'postviews_position_'.$key, __($data['label'], 'easy-post-views'), __('Choose post views counter position for '.$data['label'].' display method'), $list_of_methods);
	}
}

?>