<?php

class ESSBPostViewsPopularPosts extends WP_Widget {

	/**
	 * Sets up a new Recent Posts widget instance.
	 *
	 * @since 2.8.0
	 * @access public
	 */
	public function __construct() {
		$widget_ops = array('classname' => 'widget_essbpv_popular', 'description' => __( "Your site&#8217;s most viewed Posts.") );
		parent::__construct('easy-most-viewed-posts', __('Easy Social Share Buttons: Most viewed posts'), $widget_ops);
		$this->alt_option_name = 'widget_essbpv_popular';
	}

	/**
	 * Outputs the content for the current Recent Posts widget instance.
	 *
	 * @since 2.8.0
	 * @access public
	 *
	 * @param array $args     Display arguments including 'before_title', 'after_title',
	 *                        'before_widget', and 'after_widget'.
	 * @param array $instance Settings for the current Recent Posts widget instance.
	 */
	public function widget( $args, $instance ) {
		global $essb3pv_options;
		
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$postviews_text = isset($essb3pv_options['postviews_text']) ? $essb3pv_options['postviews_text'] : __('views', 'essb');
		
		
		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		if ( ! $number )
			$number = 5;
		$show_num = isset( $instance['show_num'] ) ? $instance['show_num'] : false;

		/**
		 * Filter the arguments for the Recent Posts widget.
		 *
		 * @since 3.4.0
		 *
		 * @see WP_Query::get_posts()
		 *
		 * @param array $args An array of arguments used to retrieve the recent posts.
		 */
		$r = new WP_Query( apply_filters( 'widget_posts_args', array(
			'posts_per_page'      => $number,
			'no_found_rows'       => true,
			'orderby' => 'meta_value_num',
		    'meta_key' => 'essb_views',
			'post_status'         => 'publish',
			'ignore_sticky_posts' => true,
				'post_type' => 'any'
		) ) );

		if ($r->have_posts()) :
		?>
		<?php echo $args['before_widget']; ?>
		<?php if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		} ?>
		<ul>
		<?php while ( $r->have_posts() ) : $r->the_post(); ?>
			<li>
				<a href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?>
			<?php if ( $show_num ) : ?>
				<span class="essb-widget-post-views"><?php essb_print_views(get_the_ID(), '', '', true); ?><span class="essb-widget-post-views-text"><?php echo $postviews_text; ?></span></span>
			<?php endif; ?>
			</a>
			</li>
		<?php endwhile; ?>
		</ul>
		<?php echo $args['after_widget']; ?>
		<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;
	}

	/**
	 * Handles updating the settings for the current Recent Posts widget instance.
	 *
	 * @since 2.8.0
	 * @access public
	 *
	 * @param array $new_instance New settings for this instance as input by the user via
	 *                            WP_Widget::form().
	 * @param array $old_instance Old settings for this instance.
	 * @return array Updated settings to save.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['number'] = (int) $new_instance['number'];
		$instance['show_num'] = isset( $new_instance['show_num'] ) ? (bool) $new_instance['show_num'] : false;
		return $instance;
	}

	/**
	 * Outputs the settings form for the Recent Posts widget.
	 *
	 * @since 2.8.0
	 * @access public
	 *
	 * @param array $instance Current settings.
	 */
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
		$show_num = isset( $instance['show_num'] ) ? (bool) $instance['show_num'] : false;
?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of posts to show:' ); ?></label>
		<input class="tiny-text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="number" step="1" min="1" value="<?php echo $number; ?>" size="3" /></p>

		<p><input class="checkbox" type="checkbox"<?php checked( $show_num ); ?> id="<?php echo $this->get_field_id( 'show_num' ); ?>" name="<?php echo $this->get_field_name( 'show_num' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_num' ); ?>"><?php _e( 'Display post views?' ); ?></label></p>
<?php
	}
}

  function init_wp_widget_essb_mostviewed_posts() {
    register_widget( 'ESSBPostViewsPopularPosts' );
  }

  add_action( 'widgets_init', 'init_wp_widget_essb_mostviewed_posts' );

  add_shortcode ( 'easy-most-viewed', 'essbpv_most_viewed_posts' );
  
  if (!function_exists('essbpv_most_viewed_posts')) {
  	function essbpv_most_viewed_posts($atts) {
  		
  		global $essb3pv_options;
  		$postviews_text = isset($essb3pv_options['postviews_text']) ? $essb3pv_options['postviews_text'] : __('views', 'essb');
  		
  		$attributes = shortcode_atts ( array ('title' => '', 'number' => '', 'show_num' => 'false' ), $atts );
  		$title = ( ! empty( $attributes['title'] ) ) ? $attributes['title'] : '';
  		$number = ( ! empty( $attributes['number'] ) ) ? absint( $attributes['number'] ) : 5;
  		if ( ! $number )
  			$number = 5;
  		$show_num = isset( $attributes['show_num'] ) ? $attributes['show_num'] : 'false';
  		
  		$r = new WP_Query( apply_filters( 'widget_posts_args', array(
  				'posts_per_page'      => $number,
  				'no_found_rows'       => true,
  				'orderby' => 'meta_value_num',
  				'meta_key' => 'essb_views',
  				'post_status'         => 'publish',
  				'ignore_sticky_posts' => true,
  				'post_type' => 'any'
  		) ) );
  		
  		$attributes['before_title'] = '<h3>';
  		$attributes['after_title'] = '</h3>';
  		
  		$attributes['before_widget'] ='<div class="essbpv-most-viewed">';
  		$attributes['after_widget'] = '</div>';
  		
  		if ($r->have_posts()) :
  		?>
  				<?php echo $attributes['before_widget']; ?>
  				<?php if ( $title ) {
  					echo $attributes['before_title'] . $title . $attributes['after_title'];
  				} ?>
  				<ul>
  				<?php while ( $r->have_posts() ) : $r->the_post(); ?>
  					<li>
  						<a href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?>
  					<?php if ( $show_num && $show_num == 'yes' ) : ?>
				<span class="essb-widget-post-views"><?php essb_print_views(get_the_ID(), '', '', true); ?><span class="essb-widget-post-views-text"><?php echo $postviews_text; ?></span></span>
  					<?php endif; ?>
  					</a>
  					</li>
  				<?php endwhile; ?>
  				</ul>
  				<?php echo $attributes['after_widget']; ?>
  				<?php
  				// Reset the global $the_post as this query will have stomped on it
  				wp_reset_postdata();
  		
  				endif;
  	}
  }