<?php
/*
 * Plugin Name: Easy Social Share Buttons for WordPress Addon - Post Views
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Description: Simple post view counter integrated with Easy Social Share Buttons for WordPress (compatible with cache plugins). Including top viewed posts. 
 * Version: 1.0 
 * Author: CreoApps 
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

if (! defined ( 'WPINC' ))
	die ();

define ( 'ESSB3_PV_VERSION', '1.0' );
define ( 'ESSB3_PV_PLUGIN_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESSB3_PV_PLUGIN_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );
define ( 'ESSB3_PV_PLUGIN_BASE_NAME', plugin_basename ( __FILE__ ) );
define ( 'ESSB3_PV_OPTIONS_NAME', 'essb3-pv' );

global $essb3pv_options;

class ESSBAddonPostViews {
	private static $_instance;
	private $version = "1.0";
	
	function __construct() {
		
		global $essb3pv_options;
		
		$essb3pv_options = get_option ( ESSB3_PV_OPTIONS_NAME );
		
		// tell Easy Social Share Buttons that add-on is active
		$postviews_active = isset($essb3pv_options['postviews_active']) ? $essb3pv_options['postviews_active'] : 'false';
		if ($postviews_active == 'true') {
			define('ESSB3_POSTVIEWS_ACTIVE', true);
		}
		
		add_action ( 'init', array (&$this, 'init' ), 9 );
		add_action( 'plugins_loaded', array( &$this, 'load_widgets' ), 9);
	}
	
	/**
	 * Get static instance of class
	 *
	 * @return ESSB_Manager
	 */
	public static function getInstance() {
		if (! (self::$_instance instanceof self)) {
			self::$_instance = new self ();
		}
		
		return self::$_instance;
	}
	
	/**
	 * Cloning disabled
	 */
	private function __clone() {
	}
	
	/**
	 * Serialization disabled
	 */
	private function __sleep() {
	}
	
	/**
	 * De-serialization disabled
	 */
	private function __wakeup() {
	}
	
	public function handle_save_settings() {
		if (@$_POST && isset ( $_POST ['option_page'] )) {
			$changed = false;
			if ('essbpv_settings_group' == $this->getval ( $_POST, 'option_page' )) {
				$this->update_options ();
				$changed = true;
					
			}
			if ($changed) {
				$user_section = isset ( $_REQUEST ['section'] ) ? $_REQUEST ['section'] : '';
				$user_subsection = isset ( $_REQUEST ['subsection'] ) ? $_REQUEST ['subsection'] : '';
	
				// $goback = add_query_arg ( 'settings-updated', 'true',
				// wp_get_referer () );
				$goback = esc_url_raw ( add_query_arg ( array ('settings-updated' => 'true', 'section' => $user_section, 'subsection' => $user_subsection ), wp_get_referer () ) );
				// $goback = str_replace('#038;', '', $goback);
				wp_redirect ( $goback );
				die ();
			}
		}
	
	}
	
	public function update_options() {
		global $essbpv_options_structure;
	
		$tabs = $essbpv_options_structure->tabs;
		$sidebar_sections = $essbpv_options_structure->sidebar_sections;
		$sidebar_section_options = $essbpv_options_structure->sidebar_section_options;
	
		$current_options = get_option ( ESSB3_PV_OPTIONS_NAME );
		if (! is_array ( $current_options )) {
			$current_options = array ();
		}
	
		$current_tab = isset ( $_REQUEST ['tab'] ) ? $_REQUEST ['tab'] : '';
		$user_options = isset ( $_REQUEST ['essb_options'] ) ? $_REQUEST ['essb_options'] : array ();
	
		$reset_settings = isset ( $_REQUEST ['reset_settings'] ) ? $_REQUEST ['reset_settings'] : '';
	
		// print_r($user_options);
	
		if ($current_tab == '') {
			return;
		}
	
		$options = $sidebar_section_options [$current_tab];
	
		foreach ( $options as $section => $fields ) {
			$section_options = $fields;
				
			foreach ( $section_options as $option ) {
				$type = $option ['type'];
				$id = isset ( $option ['id'] ) ? $option ['id'] : '';
	
				if ($id == '') {
					continue;
				}
	
				switch ($type) {
					case "checkbox_list_sortable" :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						$option_value = isset ( $user_options [$id . '_order'] ) ? $user_options [$id . '_order'] : '';
						$current_options [$id . '_order'] = $option_value;
						break;
					default :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						break;
				}
			}
		}
	
		$current_options = $this->clean_blank_values ( $current_options );
	
		update_option ( ESSB3_PV_OPTIONS_NAME, $current_options );
	
	}
	
	function clean_blank_values($object) {
		foreach ( $object as $key => $value ) {
			if (! is_array ( $value )) {
				$value = trim ( $value );
	
				if (empty ( $value )) {
					unset ( $object [$key] );
				}
			} else {
				if (count ( $value ) == 0) {
					unset ( $object [$key] );
				}
			}
		}
	
		return $object;
	}
	
	public function load_widgets() {
		include_once (ESSB3_PV_PLUGIN_ROOT . 'lib/class-essbpv-widget-popular-posts.php');
	}
	
	public function init() {
		
		add_action ( 'wp_enqueue_scripts', array ($this, 'load_static_resources' ) );
		
		add_action ( 'wp_ajax_postviews', array ($this, 'increment_views' ) );
		add_action ( 'wp_ajax_nopriv_postviews', array ($this, 'increment_views' ) );
		
		add_action ( 'wp_ajax_getpostviews', array ($this, 'get_ajax_views' ) );
		add_action ( 'wp_ajax_nopriv_getpostviews', array ($this, 'get_ajax_views' ) );
		
		add_shortcode ( 'easy-views', array ($this, 'views_shortcode' ) );
		
		// display views in list of posts

		add_action ( 'pre_get_posts', array($this, 'sort_postviews' ));
		
		
		if (is_admin()) {
			include_once (ESSB3_PV_PLUGIN_ROOT . 'lib/essbpv-admin.php');
			add_action ( 'admin_menu', array ($this, 'register_menu' ) );
			
			$hook = (defined ( 'WP_NETWORK_ADMIN' ) && WP_NETWORK_ADMIN) ? 'network_admin_menu' : 'admin_menu';
			add_action ( $hook, array ($this, 'handle_save_settings' ) );
			
			add_action ( 'add_meta_boxes', array ($this, 'create_metabox' ) );
			add_action ( 'save_post', array ($this, 'save_metabox' ) );
			add_action ( 'manage_posts_custom_column', array($this, 'add_postviews_column_content' ));
			add_filter ( 'manage_posts_columns', array($this, 'add_postviews_column' ));
			add_action ( 'manage_pages_custom_column', array($this, 'add_postviews_column_content' ));
			add_filter ( 'manage_pages_columns', array($this, 'add_postviews_column' ));
		
			add_filter ( 'manage_edit-post_sortable_columns', array($this, 'sort_postviews_column' ));
			add_filter ( 'manage_edit-page_sortable_columns', array($this, 'sort_postviews_column' ));
		}
	}
	
	public function register_menu() {
		global $essb_options;
	
		$menu_pos = false;
		$essb_access = "edit_pages";
			
		add_submenu_page ( 'essb_options', __ ( 'Post Views', 'easy-post-views' ), '' . __ ( '[Addon] Post Views', 'easy-post-views' ) . '', $essb_access, 'essb_pv', array ($this, 'essb_pv_settings_redirect' ) );
	}

	function essb_pv_settings_redirect() {
		include_once (ESSB3_PV_PLUGIN_ROOT . 'lib/admin/essbpv-settings.php');
	}
	
	function add_postviews_column($defaults) {
		$defaults ['essb_views'] = __ ( 'Post Views', 'easy-post-views' );
		return $defaults;
	}
	
	// # Functions Fill In The Views Count
	function add_postviews_column_content($column_name) {
		if ($column_name == 'essb_views') {
			if (function_exists ( 'essb_print_views' )) {
				essb_print_views();
			}
		}
	}
	
	function sort_postviews_column($defaults) {
		$defaults ['essb_views'] = 'essb_views';
		return $defaults;
	}
	function sort_postviews($query) {
		if (! is_admin ())
			return;
		$orderby = $query->get ( 'orderby' );
		if ('essb_views' == $orderby) {
			$query->set ( 'meta_key', 'essb_views' );
			$query->set ( 'orderby', 'meta_value_num' );
		}
	}
	
	public function views_shortcode($atts) {
		$attributes = shortcode_atts ( array ('id' => 0, 'prefix' => '', 'postfix' => '', 'template' => '' ), $atts );
		$id = intval ( $attributes ['id'] );
		$prefix = isset ( $attributes ['prefix'] ) ? $attributes ['prefix'] : '';
		$postfix = isset ( $attributes ['postfix'] ) ? $attributes ['postfix'] : '';
		$template = isset ( $attributes ['template'] ) ? $attributes ['template'] : '';
		if ($id === 0) {
			$id = get_the_ID ();
		}
		
		return $this->get_views ( false, $id, $prefix, $postfix, $template );
	}
	
	public function create_metabox() {
		$pts = get_post_types ( array ('show_ui' => true, '_builtin' => true ) );
		$cpts = get_post_types ( array ('show_ui' => true, '_builtin' => false ) );
		foreach ( $pts as $pt ) {
			add_meta_box ( 'essbpv_metabox', __ ( 'Post Views Addon for ESSB', 'easy-post-views' ), array ($this, 'essb_postviews_metabox' ), $pt, 'side', 'high' );
		
		}
		
		foreach ( $cpts as $cpt ) {
			add_meta_box ( 'essbpv_metabox', __ ( 'Post Views Addon for ESSB', 'easy-post-views' ), array ($this, 'essb_postviews_metabox' ), $cpt, 'side', 'high' );
		
		}
	}
	
	public function save_metabox() {
		global $post, $post_id;
		
		if (! $post) {
			return $post_id;
		}
		
		if (! $post_id) {
			$post_id = $post->ID;
		}
		$essb_metabox = isset ( $_REQUEST ['essb_views_metabox'] ) ? $_REQUEST ['essb_views_metabox'] : array ();
		$this->save_metabox_value ( $post_id, 'essb_views', $essb_metabox );
	
	}
	
	public function save_metabox_value($post_id, $option, $valueContainer) {
		$value = isset ( $valueContainer [$option] ) ? $valueContainer [$option] : '';
		if (! empty ( $value )) {
			update_post_meta ( $post_id, $option, $value );
		} else {
			delete_post_meta ( $post_id, $option );
		}
	}
	
	public function load_static_resources() {
		global $post;
		
		if (! isset ( $post )) {
			return;
		}

		$is_valid_count = false;
		if ( !wp_is_post_revision( $post ) && ( is_single() || is_page() ) ) {
			$is_valid_count = true;
		}
		wp_enqueue_script ( 'essb-post-views', plugins_url ( 'assets/js/essb-post-views.js', __FILE__ ), array ('jquery' ), $this->version, true );
		wp_localize_script ( 'essb-post-views', 'essbViewsCacheL10n', array ('admin_ajax_url' => admin_url ( 'admin-ajax.php' ), 'post_id' => intval ( $post->ID ), 'valid' => $is_valid_count ) );
		wp_enqueue_style ( 'essb-post-views', plugins_url ( 'assets/css/essb-post-views.css', __FILE__ ), false, $this->version, 'all' );
	}
	
	public function increment_views() {
		if (empty ( $_GET ['postviews_id'] ))
			return;
		
		$post_id = intval ( $_GET ['postviews_id'] );
		if ($post_id > 0) {
			$post_views = get_post_custom ( $post_id );
			$post_views = intval ( $post_views ['essb_views'] [0] );
			update_post_meta ( $post_id, 'essb_views', ($post_views + 1) );
			do_action ( 'essb_postviews_increment_views_ajax', ($post_views + 1) );
			echo ($post_views + 1);
			exit ();
		}
	}
	
	public function get_ajax_views() {
		global $essb3pv_options;
		
		$postviews_value_type = isset($essb3pv_options['postviews_value_type']) ? $essb3pv_options['postviews_value_type'] : 'short';
		
		$output = array ();
		$output ['views'] = 0;
		
		$post_id = intval ( $_GET ['postviews_id'] );
		if (intval ( $post_id ) > 0) {
			$post_views = get_post_custom ( $post_id );
			$post_views = intval ( $post_views ['essb_views'] [0] );
			
			if ($postviews_value_type == 'short') {
				$post_views = $this->round_number($post_views);
			}
			
			$output ['views'] = $post_views;
		}
		
		echo json_encode ( $output );
		die ();
	}
	
	public function round_number($number, $min_value = 1000, $decimal = 1) {
		if ($number < $min_value) {
			return number_format_i18n ( $number );
		}
		$alphabets = array (1000000000 => 'B', 1000000 => 'M', 1000 => 'K' );
		foreach ( $alphabets as $key => $value ) {
			if ($number >= $key) {
				return round ( $number / $key, $decimal ) . '' . $value;
			}
		}
	}
	
	public function get_views($display = true, $post_id = '', $prefix = '', $postfix = '', $views_tempate = '%VIEW_COUNT%') {
		
		if (empty ( $post_id )) {
			$post_id = get_the_ID ();
		}
		
		$post_views = intval ( get_post_meta ( $post_id, 'essb_views', true ) );
		
		if (empty ( $views_tempate )) {
			$views_tempate = '%VIEW_COUNT%';
		}
				
		$output = $prefix . str_replace ( array ('%VIEW_COUNT%', '%VIEW_COUNT_ROUNDED%' ), array (number_format_i18n ( $post_views ), $this->round_number ( $post_views ) ), stripslashes ( $views_tempate ) ) . $postfix;
		
		if ($display) {
			echo $output;
		} else {
			return $output;
		}
	}
	
	function essb_postviews_metabox() {
		global $post;
		
		if (isset ( $_GET ['action'] )) {
			
			$custom = get_post_custom ( $post->ID );
			$essb_views = isset ( $custom ["essb_views"] ) ? $custom ["essb_views"] [0] : "";
			
			if (class_exists ( 'ESSBMetaboxInterface' )) {
				
				ESSBMetaboxInterface::draw_form_start ( 'essb_views_metabox' );
				
				ESSBMetaboxOptionsFramework::draw_section_start ();
				
				ESSBMetaboxOptionsFramework::draw_options_row_start ( __ ( 'Post views', 'easy-post-views' ), __ ( 'Customize value of post views', 'easy-post-views' ), '', '2', false );
				ESSBMetaboxOptionsFramework::draw_options_row_end ();
				
				ESSBMetaboxOptionsFramework::draw_options_row_start ( '', '', '', '2', false );
				ESSBMetaboxOptionsFramework::draw_input_field ( 'essb_views', true, 'essb_views_metabox', $essb_views );
				ESSBMetaboxOptionsFramework::draw_options_row_end ();
				
				ESSBMetaboxOptionsFramework::draw_section_end ();
				
				ESSBMetaboxInterface::draw_form_end ();
			}
		}
	}
	
	function getval($from, $what, $default = false) {
		if (is_object ( $from ) && isset ( $from->$what ))
			return $from->$what;
		else if (is_array ( $from ) && isset ( $from [$what] ))
			return $from [$what];
		else
			return $default;
	}
}

/**
 * main code *
 */
global $essb_pv;
if (! isset ( $essb_pv )) {
	$essb_pv = ESSBAddonPostViews::getInstance ();
}

if (! function_exists ( 'essb_views' )) {
	function essb_views($display = true, $post_id = '', $prefix = '', $postfix = '', $view_template = '') {
		global $essb_pv;
		
		if ($essb_pv) {
			if ($display) {
				$essb_pv->get_views ( $display, $post_id, $prefix, $postfix, $view_template );
			} else {
				return $essb_pv->get_views ( $display, $post_id, $prefix, $postfix, $view_template );
			}
		}
	}
}

if (! function_exists ( 'essb_get_views' )) {
	function essb_get_views($post_id = '', $prefix = '', $postfix = '', $short_number = false) {
		global $essb_pv;
		
		$view_template = ($short_number) ? '%VIEW_COUNT_ROUNDED%' : '';
		return $essb_pv->get_views ( false, $post_id, $prefix, $postfix, $view_template );
	}
}

if (! function_exists ( 'essb_print_views' )) {
	function essb_print_views($post_id = '', $prefix = '', $postfix = '', $short_number = false) {
		global $essb_pv;
		
		$view_template = ($short_number) ? '%VIEW_COUNT_ROUNDED%' : '';
		return $essb_pv->get_views ( true, $post_id, $prefix, $postfix, $view_template );
	}
}

if (!function_exists('essb_generate_views_code')) {
	function essb_generate_views_code($post_id = '', $position = '') {
		global $essb3pv_options;
		
		$position_display = $position;//isset($essb3pv_options['postviews_position_'.$position]) ? $essb3pv_options['postviews_position_'.$position] : 'no';
		$postviews_text = isset($essb3pv_options['postviews_text']) ? $essb3pv_options['postviews_text'] : 'views';
		$postviews_value_type = isset($essb3pv_options['postviews_value_type']) ? $essb3pv_options['postviews_value_type'] : 'short';
		$postviews_style = isset($essb3pv_options['postviews_style']) ? $essb3pv_options['postviews_style'] : 'light';
		$postviews_value_update = isset($essb3pv_options['postviews_value_update']) ? $essb3pv_options['postviews_value_update'] : 'normal';
		
		$ajax = ($postviews_value_update == "ajax") ? true: false;
		
		// demo mode
		if (defined('ESSB_DEMO_CACHED_COUNTERS_HOME')) {
			if (is_home()  || is_front_page()) {
				$ajax = false;
			}
		}
		
		
		if ($position_display == 'no') {
			return '';
		}
		else {
			$output = '';
			$output .= '<li class="essb_item essb_viewcount'.(($ajax) ? ' essb_viewcount_ajax' : ''). ' essb_viewcount_style_'.$postviews_style.'">';
			$output .= '<span class="essb_views_number">';
			if (!$ajax) {
				$output .= essb_get_views($post_id, '', '', (($postviews_value_type == 'short') ? true: false));
			}
			$output .= '</span>';
			$output .= '<span class="essb_views_text">';
			$output .= $postviews_text;
			$output .= '</span>';
			$output .= '</li>';
			
			return $output;
		}
	}
}

if (!function_exists('essb_postview_position')) {
	function essb_postview_position($button_position = '', $counter_position = '') {
		global $essb3pv_options;
		
		
		$position_display = isset($essb3pv_options['postviews_position_'.$button_position]) ? $essb3pv_options['postviews_position_'.$button_position] : 'no';
		if ($position_display == 'no') {
			return '';
		}
		else {
			if ($position_display == 'automatic') {
				if ($counter_position == 'left' || $counter_position == 'leftbig') {
					return 'right';
				}
				else {
					return 'left';
				}
			}
			else {
				return $position_display;
			}
		}
	}
}

if (!function_exists('essb_postviews_position_from_shortcode')) {
	function essb_postviews_position_from_shortcode($postview_shortcode_position = '', $counter_position = '') {
		$position_display = '';
		
		if (!empty($postview_shortcode_position)) {
			if ($postview_shortcode_position == 'automatic') {
				if ($counter_position == 'left' || $counter_position == 'leftbig') {
					$position_display = 'right';
				}
				else {
					$position_display = 'left';
				}
			}
			else {
				$position_display = $postview_shortcode_position;
			}
		}
		
		return $position_display;
	}
}