<?php

function essb_superpostbar_draw() {
	global $post;
	
	$buttons = '';
	
	if (isset($post)) {
		$deactivate_prevnext = essb_option_bool_value('spb_deactivate_prevnext');
		$deactivate_comments = essb_option_bool_value('spb_deactivate_comments');
		$deactivate_shares = essb_option_bool_value('spb_deactivate_shares');
		
		$prevnext_location = essb_option_value('spb_prevnext_location');
		$counter_location = essb_option_value('spb_counter_location');
		
		$buttons .= '<div class="essb-superpostbar">';
	
		if (!$deactivate_prevnext && $prevnext_location == 'before') {
			$buttons .= essb_superpostbar_generate_prevnext();
		}
		
		$total_shares_code = essb_shortcode_total_shares(array('inline' => 'yes'));
		$share_buttons = essb_core()->generate_share_buttons('superpostbar');
		$comment_count = get_post_field( 'comment_count', $post->ID );
		
		$buttons .= '<div class="essb-superpostbar-shares">';
		if (!$deactivate_comments && !$deactivate_shares && ($counter_location == '' || $counter_location == 'left')) {
			$buttons .= '<div class="essb-superpostbar-icons left">';
			if (!$deactivate_shares) {
				$buttons .= '<span class="essb-superpostbar-totalshares"><i class="essb_icon_share"></i><span class="essb-postbar-number">'.$total_shares_code.'</span></span>';				
			}
			if (!$deactivate_comments) {
				$buttons .= '<span class="essb-superpostbar-comments"><i class="essb_icon_comments"></i><span class="essb-postbar-number">'.$comment_count.'</span></span>';				
			}
			$buttons .= '</div>';
		}
		
		$buttons .= '<div class="essb-superpostbar-buttons">'.$share_buttons.'</div>';
		
		if (!$deactivate_comments && !$deactivate_shares && $counter_location == 'right') {
			$buttons .= '<div class="essb-superpostbar-icons right">';
			if (!$deactivate_shares) {
				$buttons .= '<span class="essb-postbar-totalshares"><i class="essb_icon_share"></i><span class="essb-postbar-number">'.$total_shares_code.'</span></span>';
			}
			if (!$deactivate_comments) {
				$buttons .= '<span class="essb-postbar-comments"><i class="essb_icon_comments"></i><span class="essb-postbar-number">'.$comment_count.'</span></span>';
			}
			$buttons .= '</div>';
				
		}
		
		$buttons .= '</div>';
		
		if (!$deactivate_prevnext && ($prevnext_location == '' || $prevnext_location == 'after')) {
			$buttons .= essb_superpostbar_generate_prevnext();
		}
		
		$buttons .= '</div>';
	}
	
	return $buttons;
}

function essb_superpostbar_generate_prevnext() {	
	$output = '';
	
	
	$output .= '<div class="essb-superpostbar-prevnext">';
	
	$output .= '<div class="essb-superpostbar-post">';
	// previous post
	$prev_post = get_adjacent_post( true, '', true, 'category');
	
	if ( is_a( $prev_post, 'WP_Post' ) ) {
		$output .= '<a href="'.get_permalink( $prev_post->ID ).'">';
		
		$post_title = substr(get_the_title( $prev_post->ID ),0,100);
		$output .= '<div class="spb-title"><span class="spb-navicon"><i class="essb_icon_prev"></i></span><span class="spb-posttitle">'.$post_title.'</span></div>';
			
		$output .= '<div class="essb-superpostbar-post-content">';
		$output .= '<span class="spb-category">';
		if(is_singular( 'post' )) {
			$category = get_the_category($prev_post->ID);
			$output .= $category[0]->cat_name;
		}
		$output .= '</span>';
		
	
	
		$working_post_content = $prev_post->post_content;
	
		//$essb_post_og_desc = strip_shortcodes($essb_post_og_desc);
		$post_shortdesc = $prev_post->post_excerpt;
		if ($post_shortdesc != '') {
			$working_post_content = $post_shortdesc;
		}
	
	
		$working_post_content = strip_tags ( $working_post_content );
		$working_post_content = preg_replace( '/\s+/', ' ', $working_post_content );
		$working_post_content = strip_shortcodes($working_post_content);
		$working_post_content = trim ( $working_post_content );
		$working_post_content = substr ( $working_post_content, 0, 150 );
		$working_post_content .= '&hellip;';
		$output .= '<span class="spb-excerpt">';
		$output .= $working_post_content;
		$output .= '</span>';
		$output .= '</div>'; // post info
		$output .= '</a>';
	}
	$output .= '</div>';
	
	// next post
	$output .= '<div class="essb-superpostbar-post">';
	$prev_post = get_adjacent_post( true, '', false, 'category');
	
	if ( is_a( $prev_post, 'WP_Post' ) ) {
		$output .= '<a href="'.get_permalink( $prev_post->ID ).'">';
		
		$post_title = substr(get_the_title( $prev_post->ID ),0,100);
		//$output .= '<div class="spb-title"><span class="spb-navicon"><i class="essb_icon_next"></i></span><span class="spb-posttitle">'.$post_title.'</span></div>';
		$output .= '<div class="spb-title right"><span class="spb-posttitle">'.$post_title.'</span><span class="spb-navicon"><i class="essb_icon_next"></i></span></div>';
		
		$output .= '<div class="essb-superpostbar-post-content">';
		$output .= '<span class="spb-category">';
		if(is_singular( 'post' )) {
			$category = get_the_category($prev_post->ID);
			$output .= $category[0]->cat_name;
		}
		$output .= '</span>';
		
	
	
		$working_post_content = $prev_post->post_content;
	
		//$essb_post_og_desc = strip_shortcodes($essb_post_og_desc);
		$post_shortdesc = $prev_post->post_excerpt;
		if ($post_shortdesc != '') {
			$working_post_content = $post_shortdesc;
		}
	
	
		$working_post_content = strip_tags ( $working_post_content );
		$working_post_content = preg_replace( '/\s+/', ' ', $working_post_content );
		$working_post_content = strip_shortcodes($working_post_content);
		$working_post_content = trim ( $working_post_content );
		$working_post_content = substr ( $working_post_content, 0, 150 );
		$working_post_content .= '&hellip;';
		$output .= '<span class="spb-excerpt">';
		$output .= $working_post_content;
		$output .= '</span>';
		$output .= '</div>'; // post info
		$output .= '</a>';
	}
	$output .= '</div>';
	$output .= '</div>';
	
	return $output;
}