<?php

/*
 * Plugin Name: Easy Social Share Buttons for WordPress Display Method - Super Post Float
 * Description: Activate usage of Super Post Float display method
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Version: 1.0
 * Author: CreoApps
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

define ( 'ESSB_DM_SPF_PLUGIN_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESSB_DM_SPF_PLUGIN_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );


add_action('init', 'essb_display_method_superpostfloat_styles', 99);

add_filter('essb4_button_positions', 'essb_display_superpostfloat');
//add_filter('essb4_button_positions_mobile', 'essb_display_superpostfloat');
add_filter('essb4_custom_positions', 'essb_display_register_superpostfloat');
add_filter('essb4_custom_method_list', 'essb_register_superpostfloat');
add_filter("essb4_position_style_superpostfloat", "essb_applystyle_superpostfloat");

add_filter('the_content', 'essb4_superpostfloat_display', 9);

function essb_superpostfloat_key() {
	return 'display-33';
}

function essb_register_superpostfloat($methods) {
	$methods[essb_superpostfloat_key()] = __('Super Post Float', 'essb');
	
	return $methods;
}

function essb_display_method_superpostfloat_styles() {
	
	if (function_exists('essb_resource_builder')) {
		essb_resource_builder()->add_static_resource(ESSB_DM_SPF_PLUGIN_URL . '/assets/essb-display.css', 'essb-superpostfloat', 'css');
		essb_resource_builder()->add_static_resource(ESSB_DM_SPF_PLUGIN_URL . '/assets/essb-display.js', 'essb-superpostfloat', 'js');
	}
	
	if (is_admin()) {
		include_once ESSB_DM_SPF_PLUGIN_ROOT . 'lib/essb-display-superpostfloat-settings.php';
	}
}

function essb_display_superpostfloat($positions) {
	
	$positions['superpostfloat'] = array ("image" => "assets/images/display-positions-13.png", "label" => __("Super Post Float", "essb") );
	
	return $positions;
}

function essb_display_register_superpostfloat($positions) {
	$positions['superpostfloat'] = __('Super Post Float', 'essb');
}

function essb4_superpostfloat_display($content) {
	$buttons = '';
	
	$general_options = essb_core()->get_general_options();
	$is_valid = false;
	if (is_array($general_options)) {
		if (in_array('superpostfloat', $general_options['button_position'])) {
			$is_valid = true;
		}
		
		
		if (is_archive() || is_front_page() || is_search() || is_tag() || is_post_type_archive() || is_home()) {
			$is_valid = false;
		}
		
		if ($is_valid) {
			$post_types = $general_options['display_in_types'];
			if (essb_core()->check_applicability($post_types, 'superpostfloat')) {
				//$buttons = '<b>superpostfloat will go here!</b>';
				include_once ESSB_DM_SPF_PLUGIN_ROOT . 'lib/essb-display-superpostfloat-draw.php';
				$buttons = essb_superpostfloat_draw();
			}
		}
	}
	
	return $buttons.$content;
	
}

function essb_applystyle_superpostfloat($button_style) {
	$position = 'superpostfloat';
	if (essb_option_value($position.'_template') != "") {
		$button_style['template'] = essb_option_value($position.'_template');
	}

	$button_style['nospace'] = essb_option_value($position.'_nospace');
	$button_style['show_counter'] = false;
	$button_style['counter_pos'] = 'hidden';
	$button_style['total_counter_pos'] = 'hidden';
	
	$button_style['button_style'] = essb_option_value($position.'_button_style');

	if ($button_style['button_style'] == 'recommended') {
		$button_style['button_style'] = 'icon';
	}
	if ($button_style['button_style'] == '') {
		$button_style['button_style'] = 'icon';
	}
		
	$position_animation = essb_option_value($position.'_css_animations');
	if (!empty($position_animation)) {
		$button_style['button_animation'] = $position_animation;
	}
	
	$button_style['button_width'] = 'auto';
	
	if ($button_style['button_style'] == 'button' || $button_style['button_style'] == 'button_name') {
		$button_style['button_width'] = 'full';
	}
		
	return $button_style;
}