<?php
/*
 * Plugin Name: Easy Social Share Buttons for WordPress Addon - Opt-in Flyout
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Description: Display flyout opt-in forms on inactivity, exit intent or during scroll
 * Version: 1.0 
 * Author: CreoApps 
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

if (! defined ( 'WPINC' ))
	die ();

define ( 'ESSB3_OFOF_VERSION', '1.1' );
define ( 'ESSB3_OFOF_PLUGIN_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESSB3_OFOF_PLUGIN_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );
define ( 'ESSB3_OFOF_PLUGIN_BASE_NAME', plugin_basename ( __FILE__ ) );
define ( 'ESSB3_OFOF_OPTIONS_NAME', 'essb3-ofof' );

global $essb3ofof_options;

class ESSBAddonOptinFormsFlyout {
	private static $_instance;
	private $version = "1.0";
	
	function __construct() {
		
		global $essb3ofof_options;
		
		$essb3ofof_options = get_option ( ESSB3_OFOF_OPTIONS_NAME );
				
		$this->init();
		
		if ($this->option_bool_value('ofof_time') || $this->option_bool_value('ofof_scroll') || $this->option_bool_value('ofof_exit')) {
			add_action ( 'wp_footer', array(&$this, 'draw_forms'), 99);
			add_action('init', array(&$this, 'load_assets'), 99);
				
		}
		
		
	}
	
	public function load_assets() {
		if (function_exists('essb_resource_builder')) {
			//print "resource load";
			essb_resource_builder()->add_static_resource(ESSB3_OFOF_PLUGIN_URL . '/assets/essb-optin-flyout.css', 'essb-optin-flyout', 'css');
			essb_resource_builder()->add_static_resource_footer(ESSB3_OFOF_PLUGIN_URL . '/assets/essb-optin-flyout.js', 'essb-optin-flyout', 'js');
		}
	}
	
	public function option_value($param) {
		global $essb3ofof_options;
		
		$value = isset($essb3ofof_options[$param]) ? $essb3ofof_options[$param] : '';
		
		return $value;
	}
	
	public function option_bool_value($param) {
		global $essb3ofof_options;
		
		$value = isset($essb3ofof_options[$param]) ? $essb3ofof_options[$param] : '';
		
		if ($value == 'true') {
			return true;
		}
		else {
			return false;
		}
	}
	
	/**
	 * Get static instance of class
	 *
	 * @return ESSB_Manager
	 */
	public static function getInstance() {
		if (! (self::$_instance instanceof self)) {
			self::$_instance = new self ();
		}
		
		return self::$_instance;
	}
	
	/**
	 * Cloning disabled
	 */
	private function __clone() {
	}
	
	/**
	 * Serialization disabled
	 */
	private function __sleep() {
	}
	
	/**
	 * De-serialization disabled
	 */
	private function __wakeup() {
	}
	
	public function handle_save_settings() {
		if (@$_POST && isset ( $_POST ['option_page'] )) {
			$changed = false;
			if ('essbofof_settings_group' == $this->getval ( $_POST, 'option_page' )) {
				$this->update_options ();
				$changed = true;
					
			}
			if ($changed) {
				$user_section = isset ( $_REQUEST ['section'] ) ? $_REQUEST ['section'] : '';
				$user_subsection = isset ( $_REQUEST ['subsection'] ) ? $_REQUEST ['subsection'] : '';
	
				// $goback = add_query_arg ( 'settings-updated', 'true',
				// wp_get_referer () );
				$goback = esc_url_raw ( add_query_arg ( array ('settings-updated' => 'true', 'section' => $user_section, 'subsection' => $user_subsection ), wp_get_referer () ) );
				// $goback = str_replace('#038;', '', $goback);
				wp_redirect ( $goback );
				die ();
			}
		}
	
	}
		
	public function update_options() {
		global $essbofof_options_structure;
	
		$tabs = $essbofof_options_structure->tabs;
		$sidebar_sections = $essbofof_options_structure->sidebar_sections;
		$sidebar_section_options = $essbofof_options_structure->sidebar_section_options;
	
		$current_options = get_option ( ESSB3_OFOF_OPTIONS_NAME );
		if (! is_array ( $current_options )) {
			$current_options = array ();
		}
	
		$current_tab = isset ( $_REQUEST ['tab'] ) ? $_REQUEST ['tab'] : '';
		$user_options = isset ( $_REQUEST ['essb_options'] ) ? $_REQUEST ['essb_options'] : array ();
	
		$reset_settings = isset ( $_REQUEST ['reset_settings'] ) ? $_REQUEST ['reset_settings'] : '';
	
		// print_r($user_options);
	
		if ($current_tab == '') {
			return;
		}
	
		$options = $sidebar_section_options [$current_tab];
	
		foreach ( $options as $section => $fields ) {
			$section_options = $fields;
				
			foreach ( $section_options as $option ) {
				$type = $option ['type'];
				$id = isset ( $option ['id'] ) ? $option ['id'] : '';
	
				if ($id == '') {
					continue;
				}
	
				switch ($type) {
					case "checkbox_list_sortable" :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						$option_value = isset ( $user_options [$id . '_order'] ) ? $user_options [$id . '_order'] : '';
						$current_options [$id . '_order'] = $option_value;
						break;
					default :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						break;
				}
			}
		}
	
		$current_options = $this->clean_blank_values ( $current_options );
	
		
		update_option ( ESSB3_OFOF_OPTIONS_NAME, $current_options );
	
	}
	
	function clean_blank_values($object) {
		foreach ( $object as $key => $value ) {
			if (! is_array ( $value )) {
				$value = trim ( $value );
	
				if (empty ( $value )) {
					unset ( $object [$key] );
				}
			} else {
				if (count ( $value ) == 0) {
					unset ( $object [$key] );
				}
			}
		}
	
		return $object;
	}
		
	public function init() {
		
		
		if (is_admin()) {
			include_once (ESSB3_OFOF_PLUGIN_ROOT . 'lib/essbofof-admin.php');
			add_action ( 'admin_menu', array ($this, 'register_menu' ), 99 );
			
			$hook = (defined ( 'WP_NETWORK_ADMIN' ) && WP_NETWORK_ADMIN) ? 'network_admin_menu' : 'admin_menu';
			add_action ( $hook, array ($this, 'handle_save_settings' ) );
			
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
		}
	}
	
	public function admin_enqueue_scripts() {
		$page = isset($_REQUEST['page']) ? $_REQUEST['page'] : '';
		
		if ($page == 'essb_of' || $page == 'essb_ofof') {
			wp_enqueue_script( 'wp-color-picker-alpha', plugins_url( 'assets/wp-color-picker-alpha.js', __FILE__ ), array( 'wp-color-picker' ), time() );
		}
	}
	
	public function register_menu() {
		global $essb_options;
	
		$menu_pos = false;
		$essb_access = "edit_pages";
			
		add_submenu_page ( 'essb_options', __ ( 'Opt-in Flyout', 'easy-optin-flyout' ), '' . __ ( '[Addon] Opt-in Flyout', 'easy-optin-flyout' ) . '', $essb_access, 'essb_ofof', array ($this, 'essb_ofof_settings_redirect' ) );
	}

	function essb_ofof_settings_redirect() {
		include_once (ESSB3_OFOF_PLUGIN_ROOT . 'lib/admin/essbofof-settings.php');
	}
		
	
	function getval($from, $what, $default = false) {
		if (is_object ( $from ) && isset ( $from->$what ))
			return $from->$what;
		else if (is_array ( $from ) && isset ( $from [$what] ))
			return $from [$what];
		else
			return $default;
	}
	
	public function draw_forms() {
		
		if (essb_is_plugin_deactivated_on()) {
			return;
		}
		
		$ofof_single = $this->option_bool_value('ofof_single');
		$ofof_creditlink = $this->option_bool_value('ofof_creditlink');
		
		if ($this->option_bool_value('ofof_time')) {
			$ofof_time_delay = $this->option_value('ofof_time_delay');
			$of_time_design = $this->option_value('of_time_design');
			$of_time_bgcolor = $this->option_value('of_time_bgcolor');
			
			if ($ofof_time_delay != '') {
				$callback = ' data-delay="'.$ofof_time_delay.'" data-single="'.$ofof_single.'"';
				$this->draw_form_code('time', $of_time_design, $of_time_bgcolor, $callback, $ofof_creditlink);
			}
		}
		
		if ($this->option_bool_value('ofof_scroll')) {
			$ofof_scroll_percent = $this->option_value('ofof_scroll_percent');
			$of_scroll_design = $this->option_value('of_scroll_design');
			$of_scroll_bgcolor = $this->option_value('of_scroll_bgcolor');
				
			if ($ofof_scroll_percent != '') {
				$callback = ' data-scroll="'.$ofof_scroll_percent.'" data-single="'.$ofof_single.'"';
				$this->draw_form_code('scroll', $of_scroll_design, $of_scroll_bgcolor, $callback, $ofof_creditlink);
			}
		}
		
		if ($this->option_bool_value('ofof_exit')) {			
			$of_exit_design = $this->option_value('of_exit_design');
			$of_exit_bgcolor = $this->option_value('of_exit_bgcolor');				
			$callback = ' data-exit="1" data-single="'.$ofof_single.'"';
			$this->draw_form_code('exit', $of_exit_design, $of_exit_bgcolor, $callback, $ofof_creditlink);
				
		}
	}
	
	public function draw_form_code($event = '', $design = '', $overlay_color = '', $event_fire = '', $credit_link = false) {
		$output = '';
		
		$affiliate_user = $this->option_value('ofof_creditlink_user');
		if ($affiliate_user == '') {
			$affiliate_user = 'appscreo';
		}
		
		$close_type = $this->option_value('of_'.$event.'_close');
		$close_color = $this->option_value('of_'.$event.'_closecolor');
		$close_text = $this->option_value('of_'.$event.'_closetext');
		
		$position = $this->option_value('ofof_position');
		
		$css_color = '';
		if ($close_color != '') {
			$css_color = ' style="color:'.$close_color.'!important;"';
		}
		
		if ($close_type == '') {
			$close_type = 'icon';
		}
		
		if ($close_text == '') {
			$close_text = __("No thanks. I don't want.", 'easy-optin-flyout');
		}
		
		$output .= '<div class="essb-optinflyout essb-optinflyout-'.$position.' essb-optinflyout-'.$event.'" '.$event_fire.' '.($overlay_color != '' ? ' style="background-color:'.$overlay_color.'!important;"' : '').'>';
		
		if ($close_type == 'icon') {
			$output .= '<div class="essb-optinflyout-close essb-optinflyout-closeicon" '.$css_color.'><i class="essb_icon_close"></i></div>';
		}
		
		$output .= do_shortcode('[easy-subscribe design="'.$design.'" mode="mailchimp"]');
		if ($close_type != 'icon') {
			$output .= '<div class="essb-optinflyout-close essb-optinflyout-closetext" '.$css_color.'>'.$close_text.'</div>';
		}
		if ($credit_link) {
			$output .= '<div class="promo">Powered by <a href="http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref='.$affiliate_user.'" target="_blank">Best Social Sharing Plugin for WordPress</a> Easy Social Share Buttons</div>';
		}
		
		$output .= '</div>';
		
		echo $output;
	}
}

/**
 * main code *
 */
global $essb_ofof;
function essb_optin_forms_flyout() {
	global $essb_ofof;
	
	if (! isset ( $essb_ofof )) {
		$essb_ofof = ESSBAddonOptinFormsFlyout::getInstance ();
	}
}

add_action ( 'init', 'essb_optin_forms_flyout', 9 );