<?php

function essb_woocommercebar_draw() {
	global $post;
	
	$buttons = '';
	
	if (isset($post)) {
		$woocommercebar_buynow_text = essb_option_value('woocommercebar_buynow_text');
		if ($woocommercebar_buynow_text == '') {
			$woocommercebar_buynow_text = __('Buy Now', 'essb');
		}
		
		// customizations
		$woocommercebar_buynow_bg = essb_option_value('woocommercebar_buynow_bg');
		$woocommercebar_buynow_color = essb_option_value('woocommercebar_buynow_color');
		$woocommercebar_bar_bg = essb_option_value('woocommercebar_bar_bg');
		$woocommercebar_bar_text = essb_option_value('woocommercebar_bar_text');
		
		$additional_css = '';
		
		if ($woocommercebar_bar_bg != '' || $woocommercebar_bar_text != '' || $woocommercebar_buynow_bg != '' || $woocommercebar_buynow_color != '') {
			if ($woocommercebar_buynow_bg != '') {
				$additional_css .= '.essb-woocommercebar-buynow { background-color:'.$woocommercebar_buynow_bg.'!important; }';
			}
			if ($woocommercebar_buynow_color != '') {
				$additional_css .= '.essb-woocommercebar-buynow { color:'.$woocommercebar_buynow_color.'!important; }';
			}

			if ($woocommercebar_bar_bg != '') {
				$additional_css .= '.essb-woocommercebar { background-color:'.$woocommercebar_bar_bg.'!important; }';
			}
			if ($woocommercebar_bar_text != '') {
				$additional_css .= '.essb-woocommercebar { color:'.$woocommercebar_bar_text.'!important; }';
			}
		}
		
		$buttons .= '<div class="essb-woocommercebar essb-woocommercebar-loading">';
	
		
		//$total_shares_code = essb_shortcode_total_shares(array('inline' => 'yes'));
		$share_buttons = essb_core()->generate_share_buttons('woocommercebar', 'share', array('only_share' => true));
		
		$buttons .= '<div class="essb-woocommercebar-sharebuttons">';
		$buttons .= $share_buttons;
		
		$buttons .= '</div>'; // end share buttons
		
		$product = new WC_Product(get_the_ID());
		$product_price = wc_price($product->get_price_including_tax(1,$product->get_price()));
		$product_title = get_the_title(get_the_ID());
		
		$buttons .= '<div class="essb-woocommercebar-product">';
		$buttons .= '<div class="product-title">'.$product_title.'</div>';
		$buttons .= '<div class="product-details"><span class="price">'.$product_price.'</span>';
		$buttons .= '<span class="categories">'.$product->get_categories( ', ', '<span class="posted_in">' . _n( 'Category:', 'Categories:', sizeof( get_the_terms( $post->ID, 'product_cat' ) ), 'woocommerce' ) . ' ', '.</span>' ).'</span>';
		$buttons .= '</div>';
		$buttons .= '</div>'; // end product title and price
		
		$add_to_cart = do_shortcode('[add_to_cart_url id="'.get_the_ID().'"]');
		
		$buttons .= '<div class="essb-woocommercebar-buy">';
		$buttons .= '<a href="'.$add_to_cart.'" class="essb-woocommercebar-buynow" '.(!$product->is_in_stock() ? ' disabled="disabled"': '').'>'.$woocommercebar_buynow_text.'</a>';
		$buttons .= '</div>'; // end buy now button
		
		$buttons .= '</div>';
		
		$buttons .= '<script type="text/javascript">
(function( $ ) {
	$(document).ready(function() {
		var essb_reveal_woocommercebar_transition = function() {

			$(".essb-woocommercebar").each(function() {
				if ($(this).hasClass("essb-woocommercebar-loading")) {
					$(this).toggleClass("essb-woocommercebar-loading");
				}				
			});
		}
		essb_reveal_woocommercebar_transition();

	});

})( jQuery );
</script>
<style type="text/css">
body { margin-bottom: 50px; }
'.$additional_css.'
</style>
		';
		
 		//$product_cats = wp_get_post_terms( get_the_ID(), 'product_cat' );
 		//print_r($product_cats);
		
	}
	
	return $buttons;
}

