<?php

$essb_settings_tab = 'where';
$essb_settings_menu = essb_viralpoint_key();

// loading display method settings safe to prevent possible errors
if (class_exists('ESSBOptionsStructureHelper')) {
	
	ESSBOptionsStructureHelper::field_section_start_panels($essb_settings_tab, $essb_settings_menu, __('Point button setup', 'essb'), __('Configure appearance of share triggering point', 'essb'));
	ESSBOptionsStructureHelper::field_textbox_stretched($essb_settings_tab, $essb_settings_menu, 'viralpoint_sharetext', __('Include text with icon', 'essb'), __('Setup your own call to action text with icon for sharing', 'essb'));
	
	$essb_available_buttons_width = array();
	$essb_available_buttons_width ['plus'] = array ("image" => '<div class="fa21 essb_icon_plus"></div>', "label" => "" );
	$essb_available_buttons_width ['dots'] = array ("image" => '<div class="fa21 essb_icon_dots"></div>', "label" => "" );
	$essb_available_buttons_width ['share'] = array ("image" => '<div class="fa21 essb_icon_share"></div>', "label" => "" );
	$essb_available_buttons_width ['share-alt-square'] = array ("image" => '<div class="fa21 essb_icon_share-alt-square"></div>', "label" => "" );
	$essb_available_buttons_width ['share-alt'] = array ("image" => '<div class="fa21 essb_icon_share-alt"></div>', "label" => "" );
	$essb_available_buttons_width ['share-tiny'] = array ("image" => '<div class="fa21 essb_icon_share-tiny"></div>', "label" => "" );
	$essb_available_buttons_width ['share-outline'] = array ("image" => '<div class="fa21 essb_icon_share-outline"></div>', "label" => "" );
	ESSBOptionsStructureHelper::field_html_radio_buttons($essb_settings_tab, $essb_settings_menu, 'viralpoint_icon', __('Choose icon', 'essb'), __('Choose icon you will use (default is share if nothing is selected)', 'essb'), $essb_available_buttons_width, '', '', '26px');
	
	
	ESSBOptionsStructureHelper::field_color_panel($essb_settings_tab, $essb_settings_menu, 'viralpoint_bgcolor', __('Choose background color for button', 'essb'), __('Choose custom background color of Share button', 'essb'));
	ESSBOptionsStructureHelper::field_color_panel($essb_settings_tab, $essb_settings_menu, 'viralpoint_color', __('Choose text color for button', 'essb'), __('Choose custom text color of Share button', 'essb'));
	ESSBOptionsStructureHelper::field_section_end_panels($essb_settings_tab, $essb_settings_menu);
	
	$animations_container = array ();
	foreach (essb_available_animations() as $key => $text) {
		if ($key != '') {
			if (strpos($key, 'icon_animation') !== false) {
				$animations_container[$key] = $text;
			}
		}
		else {
			$animations_container['no'] = 'No amination';
		}
	}
	
	ESSBOptionsStructureHelper::field_select($essb_settings_tab, $essb_settings_menu, 'viralpoint_animation', __('Activate animations', 'essb'), __('Animations
			are provided with CSS transitions and work on best with retina
			templates.', 'essb'), $animations_container);
	

	ESSBOptionsStructureHelper::field_switch($essb_settings_tab, $essb_settings_menu, 'viralpoint_total', __('Activate total counter', 'essb'), __('Include tiny total counter along with your share icon', 'essb'), '', __('Yes', 'essb'), __('No', 'essb'));
	
	ESSBOptionsStructureHelper::field_select($essb_settings_tab, $essb_settings_menu, 'viralpoint_location', __('Appear at', 'essb'), __('Choose the best place where you wish to see viral point appear', 'essb'), array("bottom-right" => __("Bottom Right Corner", "essb"), "bottom-left" => __("Bottom Left Corner", "essb"), "top-right" => __("Top Right Corner", "essb"), "top-left" => __("Top Left Corner", "essb")));
	
	$location = "viralpoint";
	ESSBOptionsStructureHelper::panel_start($essb_settings_tab, $essb_settings_menu, __('Customize used social networks for this display method', 'essb'), __('Activate this option if you wish to make a full change of default share buttons that you use on entire site.', 'essb'), 'fa21 fa fa-cogs', array("mode" => "switch", 'switch_id' => $location.'_activate', 'switch_on' => __('Yes', 'essb'), 'switch_off' => __('No', 'essb'), 'switch_submit' => 'true'));
	if (essb_option_bool_value($location.'_activate')) {
		
		global $essb_networks;
		
		$checkbox_list_networks = array();
		foreach ($essb_networks as $key => $object) {
			$checkbox_list_networks[$key] = $object['name'];
		}
		ESSBOptionsStructureHelper::title($essb_settings_tab, $essb_settings_menu, __('Customize active social networks', 'essb'), __('Apply selection only if you wish to modify the default network list that is used over site.', 'essb'), 'inner-row');
		ESSBOptionsStructureHelper::field_checkbox_list_sortable($essb_settings_tab, $essb_settings_menu, $location.'_networks', '', '', $checkbox_list_networks);
		ESSBOptionsStructureHelper::panel_start($essb_settings_tab, $essb_settings_menu, __('Customize text of social network over button', 'essb'), __('Set texts that will appear on selected display method instead of default network names. Use dash (-) if you wish to remove text for that network name.', 'essb'), 'fa21 fa fa-cogs', array("mode" => "switch", 'switch_id' => $location.'_name_change', 'switch_on' => __('Yes', 'essb'), 'switch_off' => __('No', 'essb')));
		
		ESSBOptionsStructureHelper::structure_row_start($essb_settings_tab, $essb_settings_menu, 'inner-row social-name-change');
		$count = 0;
		foreach ($checkbox_list_networks as $key => $text) {
			if ($count == 4) {
				ESSBOptionsStructureHelper::structure_row_end($essb_settings_tab, $essb_settings_menu);
				ESSBOptionsStructureHelper::structure_row_start($essb_settings_tab, $essb_settings_menu, 'inner-row social-name-change');
				$count = 0;
			}
			$count++;
			ESSBOptionsStructureHelper::structure_section_start($essb_settings_tab, $essb_settings_menu, 'c3');
			ESSBOptionsStructureHelper::field_textbox_panel($essb_settings_tab, $essb_settings_menu, $location.'_'.$key.'_name', $text, '', '', '', '', '', '6');
			ESSBOptionsStructureHelper::structure_section_end($essb_settings_tab, $essb_settings_menu);
		}
		
		ESSBOptionsStructureHelper::structure_row_end($essb_settings_tab, $essb_settings_menu);
		ESSBOptionsStructureHelper::panel_end($essb_settings_tab, $essb_settings_menu); // network names
	}
	ESSBOptionsStructureHelper::panel_end($essb_settings_tab, $essb_settings_menu); // customization
	
}