<?php
/*
 * Plugin Name: Easy Social Share Buttons for WordPress Addon - Facebook Comments
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Description: Simple and easy way to add responsive Facebook comments to your posts, pages 
 * Version: 1.0 
 * Author: CreoApps 
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

if (! defined ( 'WPINC' ))
	die ();

define ( 'ESSB3_FC_VERSION', '1.0' );
define ( 'ESSB3_FC_PLUGIN_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESSB3_FC_PLUGIN_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );
define ( 'ESSB3_FC_PLUGIN_BASE_NAME', plugin_basename ( __FILE__ ) );
define ( 'ESSB3_FC_OPTIONS_NAME', 'essb3-fc' );

global $essb3fc_options;

class ESSBAddonFacebookComments {
	private static $_instance;
	private $version = "1.0";
	
	function __construct() {
		
		global $essb3fc_options;
		
		$essb3fc_options = get_option ( ESSB3_FC_OPTIONS_NAME );
		
		$activate_trigger = isset($_REQUEST['fbcomments_demo']) ? $_REQUEST['fbcomments_demo'] : '';
				
		$this->init();
		add_action ( 'wp_footer', array(&$this, 'append_facebook_api'), 999);
		add_action ( 'wp_head', array(&$this, 'facebook_comments_head_section'));
		add_filter ( 'the_content', array(&$this, 'attach_facebook_comments'), 100);
		add_shortcode( 'easy-facebook-comments', array(&$this, 'handle_shortcode'));
		
	}
	
	/**
	 * Get static instance of class
	 *
	 * @return ESSB_Manager
	 */
	public static function getInstance() {
		if (! (self::$_instance instanceof self)) {
			self::$_instance = new self ();
		}
		
		return self::$_instance;
	}
	
	/**
	 * Cloning disabled
	 */
	private function __clone() {
	}
	
	/**
	 * Serialization disabled
	 */
	private function __sleep() {
	}
	
	/**
	 * De-serialization disabled
	 */
	private function __wakeup() {
	}
	
	public function handle_save_settings() {
		if (@$_POST && isset ( $_POST ['option_page'] )) {
			$changed = false;
			if ('essbfc_settings_group' == $this->getval ( $_POST, 'option_page' )) {
				$this->update_options ();
				$changed = true;
					
			}
			if ($changed) {
				$user_section = isset ( $_REQUEST ['section'] ) ? $_REQUEST ['section'] : '';
				$user_subsection = isset ( $_REQUEST ['subsection'] ) ? $_REQUEST ['subsection'] : '';
	
				// $goback = add_query_arg ( 'settings-updated', 'true',
				// wp_get_referer () );
				$goback = esc_url_raw ( add_query_arg ( array ('settings-updated' => 'true', 'section' => $user_section, 'subsection' => $user_subsection ), wp_get_referer () ) );
				// $goback = str_replace('#038;', '', $goback);
				wp_redirect ( $goback );
				die ();
			}
		}
	
	}
	
	public function facebook_comments_head_section() {
		global $essb3fc_options;
		
		$fc_appid = isset($essb3fc_options['fc_appid']) ? $essb3fc_options['fc_appid'] : '';
		$fc_admin = isset($essb3fc_options['fc_admin']) ? $essb3fc_options['fc_admin'] : '';
		
		if (!empty($fc_appid)) {
			echo '<meta property="fb:app_id" content="'.$fc_appid.'"/>';
		}
		if (!empty($fc_admin)) {
			$moderators = trim($fc_admin);
			if(strpos($moderators,',') >= 0)
			{
				$moderators_array = explode(",", $moderators);
				foreach($moderators_array as $moderator){
					echo '<meta property="fb:admins" content="'.$moderator.'"/>';
				}
			} else {
				echo '<meta property="fb:admins" content="'.$moderators.'"/>';
			}
		}
	}
	
	public function append_facebook_api() {
		global $essb3fc_options;
		
		$fc_usesapi = isset($essb3fc_options['fc_usesapi']) ? $essb3fc_options['fc_usesapi'] : '';
		// site already uses Facebook API
		if ($fc_usesapi == 'true') { return; }
		
		$fc_customver = isset($essb3fc_options['fc_customver']) ? $essb3fc_options['fc_customver'] : '';
		$fc_language = isset($essb3fc_options['fc_language']) ? $essb3fc_options['fc_language'] : '';
		$fc_appid = isset($essb3fc_options['fc_appid']) ? $essb3fc_options['fc_appid'] : '';
		
		if (empty($fc_customver)) { $fc_customver = '2.4';}
		if (empty($fc_language)) { $fc_language = 'en_US';}
		
		?>
<!-- Facebook Comments free Add-on for Easy Social Share Buttons for WordPress : http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo -->
<div id="fb-root"></div>
<script>(function(d, s, id) {
				  var js, fjs = d.getElementsByTagName(s)[0];
				  if (d.getElementById(id)) return;
				  js = d.createElement(s); js.id = id;
				  js.src = "//connect.facebook.net/<?php echo $fc_language; ?>/sdk.js#xfbml=1&version=v<?php echo $fc_customver; ?>&appId=<?php echo $fc_appid; ?>";
				  fjs.parentNode.insertBefore(js, fjs);
				}(document, 'script', 'facebook-jssdk'));</script>
<?php 
	}
	
	public function attach_facebook_comments($content) {
		global $essb3fc_options;
		
		
		$fc_title = isset($essb3fc_options['fc_title']) ? $essb3fc_options['fc_title'] : '';
		$fc_colors = isset($essb3fc_options['fc_colors']) ? $essb3fc_options['fc_colors'] : 'light';
		$fc_comments = isset($essb3fc_options['fc_comments']) ? $essb3fc_options['fc_comments'] : '10';
		$fc_sort = isset($essb3fc_options['fc_sort']) ? $essb3fc_options['fc_sort'] : 'top';
		$fc_posts = isset($essb3fc_options['fc_posts']) ? $essb3fc_options['fc_posts'] : 'false';
		$fc_pages = isset($essb3fc_options['fc_pages']) ? $essb3fc_options['fc_pages'] : 'false';
		$fc_creditlink = isset($essb3fc_options['fc_creditlink']) ? $essb3fc_options['fc_creditlink'] : 'false';
		
		$output = '';
		$colorscheme_value = 'data-colorscheme="'.$fc_colors.'"';
		$width_value = 'data-width="100%"';
		$numpost_value = 'data-numposts="'.$fc_comments.'"';
		$orderby_value = 'data-order-by="'.$fc_sort.'"';
		
		if (!empty($fc_title)) {
			$output .= '<h3 class="essbfc-title">' . $fc_title . '</h3>';
		}
		
		$comment_str = '<div class="fb-comments" data-href="' . get_permalink () . '" ' . $width_value . ' ' . $numpost_value . ' ' . $colorscheme_value . ' ' . $orderby_value . ' ></div>';
		$output .= "<!-- Facebook Comments free Add-on for Easy Social Share Buttons for WordPress : http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo -->" . $comment_str;
		
		// see if link plugin is selected
		if ($fc_creditlink == 'true') {
			$output .= '<p style="font-size: 12px; text-align: center;">Powered by <a href="http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo" target="_blank">Facebook Comments free add-on for <b>most feature packed social sharing plugin for WordPress</b> Easy Social Share Buttons</a></p>';
		}
		
		if ( (is_single() && $fc_posts == 'true') || (is_page() && $fc_pages == 'true') ) {
			$disable_facebook_comments = get_post_meta( get_the_ID(), 'essbfc_disable', true );
			if ( $disable_facebook_comments != 'true') {
				$content .= $output ;
			}
		}
		
		return $content;
	}
	
	public function handle_shortcode($atts) {
		global $essb3fc_options;
		
		
		$fc_title = isset($essb3fc_options['fc_title']) ? $essb3fc_options['fc_title'] : '';
		$fc_colors = isset($essb3fc_options['fc_colors']) ? $essb3fc_options['fc_colors'] : 'light';
		$fc_comments = isset($essb3fc_options['fc_comments']) ? $essb3fc_options['fc_comments'] : '10';
		$fc_sort = isset($essb3fc_options['fc_sort']) ? $essb3fc_options['fc_sort'] : 'top';
		$fc_posts = isset($essb3fc_options['fc_posts']) ? $essb3fc_options['fc_posts'] : 'false';
		$fc_pages = isset($essb3fc_options['fc_pages']) ? $essb3fc_options['fc_pages'] : 'false';
		$fc_creditlink = isset($essb3fc_options['fc_creditlink']) ? $essb3fc_options['fc_creditlink'] : 'false';
		
		$output = '';
		$colorscheme_value = 'data-colorscheme="'.$fc_colors.'"';
		$width_value = 'data-width="100%"';
		$numpost_value = 'data-numposts="'.$fc_comments.'"';
		$orderby_value = 'data-order-by="'.$fc_sort.'"';
		
		if (!empty($fc_title)) {
			$output .= '<h3 class="essbfc-title">' . $fc_title . '</h3>';
		}
		
		$comment_str = '<div class="fb-comments" data-href="' . get_permalink () . '" ' . $width_value . ' ' . $numpost_value . ' ' . $colorscheme_value . ' ' . $orderby_value . ' ></div>';
		$output .= "<!-- Facebook Comments free Add-on for Easy Social Share Buttons for WordPress : http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo -->" . $comment_str;
		
		// see if link plugin is selected
		if ($fc_creditlink == 'true') {
			$output .= '<p style="font-size: 12px; text-align: center;">Powered by <a href="http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo" target="_blank">Facebook Comments free add-on for <b>most feature packed social sharing plugin for WordPress</b> Easy Social Share Buttons</a></p>';
		}
				
		return $output;
	}
	
	public function update_options() {
		global $essbfc_options_structure;
	
		$tabs = $essbfc_options_structure->tabs;
		$sidebar_sections = $essbfc_options_structure->sidebar_sections;
		$sidebar_section_options = $essbfc_options_structure->sidebar_section_options;
	
		$current_options = get_option ( ESSB3_FC_OPTIONS_NAME );
		if (! is_array ( $current_options )) {
			$current_options = array ();
		}
	
		$current_tab = isset ( $_REQUEST ['tab'] ) ? $_REQUEST ['tab'] : '';
		$user_options = isset ( $_REQUEST ['essb_options'] ) ? $_REQUEST ['essb_options'] : array ();
	
		$reset_settings = isset ( $_REQUEST ['reset_settings'] ) ? $_REQUEST ['reset_settings'] : '';
	
		// print_r($user_options);
	
		if ($current_tab == '') {
			return;
		}
	
		$options = $sidebar_section_options [$current_tab];
	
		foreach ( $options as $section => $fields ) {
			$section_options = $fields;
				
			foreach ( $section_options as $option ) {
				$type = $option ['type'];
				$id = isset ( $option ['id'] ) ? $option ['id'] : '';
	
				if ($id == '') {
					continue;
				}
	
				switch ($type) {
					case "checkbox_list_sortable" :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						$option_value = isset ( $user_options [$id . '_order'] ) ? $user_options [$id . '_order'] : '';
						$current_options [$id . '_order'] = $option_value;
						break;
					default :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						break;
				}
			}
		}
	
		$current_options = $this->clean_blank_values ( $current_options );
	
		update_option ( ESSB3_FC_OPTIONS_NAME, $current_options );
	
	}
	
	function clean_blank_values($object) {
		foreach ( $object as $key => $value ) {
			if (! is_array ( $value )) {
				$value = trim ( $value );
	
				if (empty ( $value )) {
					unset ( $object [$key] );
				}
			} else {
				if (count ( $value ) == 0) {
					unset ( $object [$key] );
				}
			}
		}
	
		return $object;
	}
		
	public function init() {
		
		
		if (is_admin()) {
			include_once (ESSB3_FC_PLUGIN_ROOT . 'lib/essbfc-admin.php');
			add_action ( 'admin_menu', array ($this, 'register_menu' ), 99 );
			
			$hook = (defined ( 'WP_NETWORK_ADMIN' ) && WP_NETWORK_ADMIN) ? 'network_admin_menu' : 'admin_menu';
			add_action ( $hook, array ($this, 'handle_save_settings' ) );
			
			add_action ( 'add_meta_boxes', array ($this, 'create_metabox' ) );
			add_action ( 'save_post', array ($this, 'save_metabox' ) );
		}
	}
	
	public function register_menu() {
		global $essb_options;
	
		$menu_pos = false;
		$essb_access = "edit_pages";
			
		add_submenu_page ( 'essb_options', __ ( 'Facebook Comments', 'easy-facebook-comments' ), '' . __ ( '[Addon] Facebook Comments', 'easy-facebook-comments' ) . '', $essb_access, 'essb_fc', array ($this, 'essb_fc_settings_redirect' ) );
	}

	function essb_fc_settings_redirect() {
		include_once (ESSB3_FC_PLUGIN_ROOT . 'lib/admin/essbfc-settings.php');
	}
		
	public function create_metabox() {
		$pts = get_post_types ( array ('show_ui' => true, '_builtin' => true ) );
		foreach ( $pts as $pt ) {
			add_meta_box ( 'essbfc_metabox', __ ( 'Facebook Comments', 'easy-facebook-comments' ), array ($this, 'essb_fc_metabox' ), $pt, 'side', 'high' );
		
		}
	}
	
	public function save_metabox() {
		global $post, $post_id;
		
		if (! $post) {
			return $post_id;
		}
		
		if (! $post_id) {
			$post_id = $post->ID;
		}
		$essb_metabox = isset ( $_REQUEST ['essb_fc_metabox'] ) ? $_REQUEST ['essb_fc_metabox'] : array ();
		$this->save_metabox_value ( $post_id, 'essbfc_disable', $essb_metabox );
	
	}
	
	public function save_metabox_value($post_id, $option, $valueContainer) {
		$value = isset ( $valueContainer [$option] ) ? $valueContainer [$option] : '';
		if (! empty ( $value )) {
			update_post_meta ( $post_id, $option, $value );
		} else {
			delete_post_meta ( $post_id, $option );
		}
	}
	
	function essb_fc_metabox() {
		global $post;
		
		if (isset ( $_GET ['action'] )) {
			
			$custom = get_post_custom ( $post->ID );
			$essb_views = isset ( $custom ["essbfc_disable"] ) ? $custom ["essbfc_disable"] [0] : "";
			
			if (class_exists ( 'ESSBMetaboxInterface' )) {
				
				ESSBMetaboxInterface::draw_form_start ( 'essb_fc_metabox' );
				
				ESSBMetaboxOptionsFramework::draw_section_start ();
				
				ESSBMetaboxOptionsFramework::draw_options_row_start ( __ ( 'Disable Facebook Comments', 'easy-facebook-comments' ), __ ( 'Activate this option to disable display of Facebook Comments', 'easy-facebook-comments' ), '', '2', false );
				ESSBMetaboxOptionsFramework::draw_options_row_end ();
				
				ESSBMetaboxOptionsFramework::draw_options_row_start ( '', '', '', '2', false );
				ESSBMetaboxOptionsFramework::draw_switch_field ( 'essbfc_disable', 'essb_fc_metabox', $essb_views, __ ( 'Yes', ESSB3_TEXT_DOMAIN ), __ ( 'No', ESSB3_TEXT_DOMAIN ) );
				
				ESSBMetaboxOptionsFramework::draw_options_row_end ();
				
				ESSBMetaboxOptionsFramework::draw_section_end ();
				
				ESSBMetaboxInterface::draw_form_end ();
			}
		}
	}
	
	function getval($from, $what, $default = false) {
		if (is_object ( $from ) && isset ( $from->$what ))
			return $from->$what;
		else if (is_array ( $from ) && isset ( $from [$what] ))
			return $from [$what];
		else
			return $default;
	}
}

/**
 * main code *
 */
global $essb_fc;
function essb_facebook_comments() {
	global $essb_fc;
	
	if (! isset ( $essb_fc )) {
		$essb_fc = ESSBAddonFacebookComments::getInstance ();
	}
}

add_action ( 'init', 'essb_facebook_comments', 9 );