<?php

/*
 * Plugin Name: Easy Social Share Buttons for WordPress: Beaver Builder Theme Custom Positions
 * Description: Activate generation buttons on locations above/below content when Beaver Builder Theme is used (requires Easy Social Share Buttons for WordPress 4.1 or newer)
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Version: 1.0
 * Author: CreoApps
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

define ( 'ESSB_BBT_CUSTOM_BOILERPLATE', dirname ( __FILE__ ) . '/' );
define ( 'ESSB_BBT_CUSTOM_BOILERPLATE_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );

add_action('init', 'essb_custom_methods_register', 99);

add_filter('essb4_button_positions', 'essb_display_mycustom_position');
add_filter('essb4_button_positions_mobile', 'essb_display_mycustom_position');
add_filter('essb4_custom_positions', 'essb_display_register_mycustom_position');
add_filter('essb4_custom_method_list', 'essb_register_mycustom_position');

function essb_register_mycustom_position($methods) {
	$methods['display-41'] = __('Beaver Builder: Before Content Element', 'essb');
	$methods['display-42'] = __('Beaver Builder: Before Content', 'essb');
	$methods['display-43'] = __('Beaver Builder: After Content', 'essb');
	
	return $methods;
}

function essb_custom_methods_register() {
	
	if (is_admin()) {
		if (class_exists('ESSBOptionsStructureHelper')) {
			essb_prepare_location_advanced_customization('where', 'display-41', 'custompos1');
			essb_prepare_location_advanced_customization('where', 'display-42', 'custompos2');
			essb_prepare_location_advanced_customization('where', 'display-43', 'custompos3');
		}

	}
}

function essb_display_mycustom_position($positions) {
	
	$positions['custompos1'] = array ("image" => "assets/images/display-positions-02.png", "label" => __("Beaver Builder: Before Content Element", "essb") );
	$positions['custompos2'] = array ("image" => "assets/images/display-positions-02.png", "label" => __("Beaver Builder: Before Content", "essb") );
	$positions['custompos3'] = array ("image" => "assets/images/display-positions-03.png", "label" => __("Beaver Builder: After Content", "essb") );
	
	return $positions;
}

function essb_display_register_mycustom_position($positions) {
	$positions['custompos1'] = __('Beaver Builder: Before Content Element', 'essb');
	$positions['custompos2'] = __('Beaver Builder: Before Content', 'essb');
	$positions['custompos3'] = __('Beaver Builder: After Content', 'essb');
}

if (!function_exists('essb_draw_custom_position')) {
	function essb_draw_custom_position($position) {
		if (function_exists('essb_core')) {
			$general_options = essb_core()->get_general_options();
			
			if (is_array($general_options)) {
				if (in_array($position, $general_options['button_position'])) {
					echo essb_core()->generate_share_buttons($position);
				}
			}
		}
	}
	
	add_action('fl_content_open', 'essb_custom_position1');
	add_action('fl_post_top_meta_close', 'essb_custom_position2');
	add_action('fl_post_bottom_meta_open', 'essb_custom_position3');

	function essb_custom_position1() {
		essb_draw_custom_position('custompos1');
	}
	function essb_custom_position2() {
		essb_draw_custom_position('custompos2');
	}
	function essb_custom_position3() {
		essb_draw_custom_position('custompos3');
	}

}
